#!/bin/sh

# 打印参数说明
print_usage() {
    echo "Usage: $0 <BMC_IP> <BMC_username> <BMC_password> <BMC_I2C_port> <riser_slot> <read/write> <address> <length> <write_value><IS_DPU>"
    echo "BMC_IP: The IP address of the BMC."
    echo "BMC_username: The username for BMC login."
    echo "BMC_password: The password for BMC login."
    echo "BMC_I2C_port: The BMC I2C port number. Check the server's topology map to find this information."
    echo "riser_slot: The slot number where the product card is plugged into the riser."
    echo "read/write: read is 1 or write is 0."
    echo "address: The address to read from or write to."
    echo "length: The number of bytes to read or write."
    echo "write_value: The value to write to the address (applicable only for write operation)."
    echo "IS_DPU=1:X510/X511/X512 is 1,other is 0"
}

# 检查参数数量是否正确
if [ "$#" -lt 10 ]; then
    echo "Invalid parameters."
    print_usage
    exit 1
fi

# 提取参数
BMC_IP=$1
BMC_username=$2
BMC_password=$3
BMC_I2C_port=$4
riser_slot=$5
action=$6
address=$7
length=$8
write_value=${9}
IS_DPU=${10}

# 验证地址和写值是否为数字
for param in "$address" "$write_value"; do
    if ! echo "$param" | grep -qE '^(0[xX])?[0-9a-fA-F]+$'; then
        echo "Error: Parameter '$param' is not a valid hexadecimal value." >&2
        exit 1
    fi
done

if [ "$IS_DPU" -eq 0 ]; then
    if [ "$action" -eq 1 ]; then
        # 读取寄存器时拆分地址为四个字节
        a=$(printf "%02x" $(($address & 0xff)))
        b=$(printf "%02x" $(($address >> 8 & 0xff)))
        c=$(printf "%02x" $(($address >> 16 & 0xff)))
        d=$(printf "%02x" $(($address >> 24 & 0xff)))

        # echo "bit0-bit7: 0x$a"
        # echo "bit7-bit15: 0x$b"
        # echo "bit16-bit23: 0x$c"
        # echo "bit24-bit31: 0x$d"

        count=1

        for addr in $a $b $c $d; do
            ipmi_command="ipmitool -I lanplus -H $BMC_IP -U $BMC_username -P $BMC_password raw 0x34 0x36 0x12 0x00 0x3e 0x01 0x$BMC_I2C_port 0x23 0x2 0x$addr 0xdd 0x4 0x1 0x70 $riser_slot 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff" 
            #echo "Executing IPMI command: $ipmi_command"
            response=$(eval "$ipmi_command")
            if [ $? -ne 0 ]; then
                echo "Failed to read register."
                exit 1
            fi

            #提取返回结果的第5个字节开始的4个字节数据，并组成32位数
            result=""
            for i in 4 5 6 7; do
                byte=$(echo $response | cut -d' ' -f$((i+1)))
                result="$result$byte"
            done

            # 打印结果，以16进制格式显示，仅在第四次循环时打印
            if [ $count -eq 4 ]; then
                echo "Read data: 0x$result"
            fi

            count=$((count + 1))
        done
    elif [ "$action" -eq 0 ]; then
        # 写寄存器时拆分地址和内容为四个字节
        a=$(printf "%02x" $(($address >> 24 & 0xff)))
        b=$(printf "%02x" $(($address >> 16 & 0xff)))
        c=$(printf "%02x" $(($address >> 8 & 0xff)))
        d=$(printf "%02x" $(($address & 0xff)))

        e=$(printf "%02x" $(($write_value >> 24 & 0xff)))
        f=$(printf "%02x" $(($write_value >> 16 & 0xff)))
        g=$(printf "%02x" $(($write_value >> 8 & 0xff)))
        h=$(printf "%02x" $(($write_value & 0xff)))

        # echo "address(bit0-bit7): 0x$a"
        # echo "address(bit8-bit15): 0x$b"
        # echo "address(bit16-bit23): 0x$c"
        # echo "address(bit24-bit31): 0x$d"
        # echo "value(bit0-bit7): 0x$e"
        # echo "value(bit8-bit15): 0x$f"
        # echo "value(bit16-bit23): 0x$g"
        # echo "value(bit24-bit31): 0x$h"

        write_val=$(printf "%02x" $write_value)

        ipmi_command="ipmitool -I lanplus -H $BMC_IP -U $BMC_username -P $BMC_password raw 0x34 0x36 0x12 0x00 0x3c 0x01 0x$BMC_I2C_port 0x23 0x2 0xee 0xee 0x8 0x1 0x70 $riser_slot 0xff 0xff 0x$a 0x$b 0x$c 0x$d 0x$e 0x$f 0x$g 0x$h 0xff 0xff"
        #echo "Executing IPMI command: $ipmi_command"

        response=$(eval "$ipmi_command")

        if [ $? -ne 0 ]; then
            echo "Failed to write register."
            exit 1
        else
            echo "Write successful."
        fi

    else
        echo "Invalid action. Action should be 1 for read or 0 for write."
        exit 1
    fi
elif [ "$IS_DPU" -eq 1 ];then
    if [ "$action" -eq 1 ]; then
        # 读取寄存器时拆分地址为四个字节
        a=$(printf "%02x" $(($address >> 24 & 0xff)))
        b=$(printf "%02x" $(($address >> 16 & 0xff)))
        c=$(printf "%02x" $(($address >> 8 & 0xff)))
        d=$(printf "%02x" $(($address & 0xff)))

        ipmi_command="ipmitool -I lanplus -H $BMC_IP -U $BMC_username -P $BMC_password raw 0x34 0x36 0x12 0 0x3c 1 0x$BMC_I2C_port 0x50 1 0x68 0xff 0x04 0x01 0x70 $riser_slot 0xff 0xff 0x$a 0x$b 0x$c 0x$d 0xff 0xff 0xff 0xff 0xff 0xff"
        #echo "Executing IPMI command: $ipmi_command"
        eval "$ipmi_command"

        ipmi_command="ipmitool -I lanplus -H $BMC_IP -U $BMC_username -P $BMC_password raw 0x34 0x36 0x12 0 0x3c 1 0x$BMC_I2C_port 0x50 1 0x64 0xff 0x04 0x01 0x70 $riser_slot 0xff 0xff 0x25 0x01 0x00 0x04 0xff 0xff 0xff 0xff 0xff 0xff"
        #echo "Executing IPMI command: $ipmi_command"
        eval "$ipmi_command"

        ipmi_command="ipmitool -I lanplus -H $BMC_IP -U $BMC_username -P $BMC_password raw 0x34 0x36 0x12 0 0x3e 1 0x$BMC_I2C_port 0x50 1 0x68 0xff 0x04 0x01 0x70 $riser_slot 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff"
        #echo "Executing IPMI command: $ipmi_command"
        # 从第3条命令返回值的第5个字节开始读4个字节，并按照16进制格式打印出来
        response=$(eval "$ipmi_command")
        if [ $? -ne 0 ]; then
            echo "Failed to read register."
            exit 1
        fi

        result=""
        for i in 4 5 6 7; do
            byte=$(echo $response | cut -d' ' -f$((i+1)))
            result="$result$byte"
        done

        # 打印结果，以16进制格式显示
        echo "Read data: 0x$result"
    elif [ "$action" -eq 0 ]; then
        a=$(printf "%02x" $(($address >> 24 & 0xff)))
        b=$(printf "%02x" $(($address >> 16 & 0xff)))
        c=$(printf "%02x" $(($address >> 8 & 0xff)))
        d=$(printf "%02x" $(($address & 0xff)))

        e=$(printf "%02x" $(($write_value >> 24 & 0xff)))
        f=$(printf "%02x" $(($write_value >> 16 & 0xff)))
        g=$(printf "%02x" $(($write_value >> 8 & 0xff)))
        h=$(printf "%02x" $(($write_value & 0xff)))

        ipmi_command="ipmitool -I lanplus -H $BMC_IP -U $BMC_username -P $BMC_password raw 0x34 0x36 0x12 0 0x3c 1 0x$BMC_I2C_port 0x50 1 0x6c 0xff 0x04 0x01 0x70 $riser_slot 0xff 0xff 0x$e 0x$f 0x$g 0x$h 0xff 0xff 0xff 0xff 0xff 0xff"
        #echo "Executing IPMI command: $ipmi_command"
        eval "$ipmi_command"

        ipmi_command="ipmitool -I lanplus -H $BMC_IP -U $BMC_username -P $BMC_password raw 0x34 0x36 0x12 0 0x3c 1 0x$BMC_I2C_port 0x50 1 0x68 0xff 0x04 0x01 0x70 $riser_slot 0xff 0xff 0x$a 0x$b 0x$c 0x$d 0xff 0xff 0xff 0xff 0xff 0xff"
        #echo "Executing IPMI command: $ipmi_command"
        eval "$ipmi_command"

        ipmi_command="ipmitool -I lanplus -H $BMC_IP -U $BMC_username -P $BMC_password raw 0x34 0x36 0x12 0 0x3c 1 0x$BMC_I2C_port 0x50 1 0x64 0xff 0x04 0x01 0x70 $riser_slot 0xff 0xff 0x25 0x02 0x00 0x08 0xff 0xff 0xff 0xff 0xff 0xff"
        #echo "Executing IPMI command: $ipmi_command"
        response=$(eval "$ipmi_command")

        if [ $? -ne 0 ]; then
            echo "Failed to write register."
            exit 1
        else
            echo "Write successful."
        fi
    fi
fi
