#!/bin/bash


unload_drivers_dinghai10e() {
    echo "移除dinghai10e新ko..."
    rmmod dinghai10e_en_aux
    rmmod dinghai10e
    rmmod dinghai10e_tsn
    rmmod dinghai10e_ptp
    rmmod dinghai10e_np
    rmmod dinghai10e_cmd
    rmmod dinghai10e_auxiliary
    echo "移除成功"
}

unload_drivers_zxdh() {
    echo "移除zxdh旧ko..."
    rmmod zxdh_en_aux
    rmmod zxdh_pf
    rmmod zxdh_tsn
    rmmod zxdh_ptp
    rmmod zxdh_np
    rmmod zxdh_cmd
    rmmod zxdh_auxiliary
    echo "移除成功"
}

load_zxdh_kernel() {
    echo "加载新ko..."
    modprobe dinghai10e_en_aux
    echo "加载成功"
}

# 主逻辑
command="$1"
case "$command" in
    r) unload_drivers_dinghai10e ;;
    r_zxdh) unload_drivers_zxdh ;;
    i) load_zxdh_kernel ;;
    a)
        unload_drivers_dinghai10e
        unload_drivers_zxdh
        load_zxdh_kernel
        ;;
    *)
        echo "用法："
        echo "r 移除ko"
        echo "r_zxdh 移除旧版本zxdh名的ko"
        echo "i 加载ko"
        echo "a = r + r_zxdh + i 移除ko+卸载rpm"
        ;;
esac

# 检查最后一个命令的退出状态
if [ $? -ne 0 ]; then
    echo "错误：上一个命令失败！"
    exit 1
fi