/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_apt_se_api.h
* 文件标识 : 
* 内容摘要 : SE适配业务接口数据结构和函数声明
* 其它说明 : 
* 当前版本 : 
* 作    者 : chenqin00181032
* 完成日期 : 2022/02/22
* MANUAL_PERCENT: 100%   
 
* 修改记录1: 
* 修改日期:  
* 版 本 号:  
* 修 改 人:  
* 修改内容:  
***************************************************************/

#ifndef _DPP_APT_SE_API_H_
#define _DPP_APT_SE_API_H_

#include "zxic_common.h"

#if ZXIC_REAL("header file")
#include "dpp_se_api.h"
#include "dpp_etcam.h"
#include "dpp_se.h"
#include "dpp_agent_se_res.h"
#endif

#define VF_ACTIVE(VPORT)    ((VPORT & 0x0800) >> 11)
#define EPID_BY(VPORT)         ((VPORT & 0x7000) >> 12)
#define FUNC_NUM(VPORT)     ((VPORT & 0x0700) >> 8) 
#define VFUNC_NUM(VPORT)    ((VPORT & 0x00FF)) 

#define PF_VQM_VFID_OFFSET  (1152)
#define IS_PF(VPORT)        (!VF_ACTIVE(VPORT))
#define VQM_VFID(VPORT)     (IS_PF(VPORT) ? \
                            (PF_VQM_VFID_OFFSET + EPID_BY(VPORT) * 8 + FUNC_NUM(VPORT)) : \
                            (EPID_BY(VPORT) * 256 + VFUNC_NUM(VPORT)))
#define OWNER_PF_VQM_VFID(VPORT)   (PF_VQM_VFID_OFFSET + EPID_BY(VPORT) * 8 + FUNC_NUM(VPORT))
#define PF_ID(EPID_BY, FUNC_NUM)   (((EPID_BY & 0x7) << 12) | ((FUNC_NUM  & 0x7) << 8))

#define ZXDH_SDT_INVALID                (ZXIC_UINT32)(0xffffffff)

#define DPP_PORT_NAME_MAX       (32)

#define VQM_VFID_MAX_NUM            (2048)
#if ZXIC_REAL("data struct define")
typedef ZXIC_UINT32 (*DPP_APT_ACL_ENTRY_SET_FUNC)(ZXIC_VOID *pData,DPP_ACL_ENTRY_EX_T *aclEntry);
typedef ZXIC_UINT32 (*DPP_APT_ACL_ENTRY_GET_FUNC)(ZXIC_VOID *pData,DPP_ACL_ENTRY_EX_T *aclEntry);

typedef ZXIC_UINT32 (*DPP_APT_ERAM_SET_FUNC)(ZXIC_VOID *pData,ZXIC_UINT32 buf[4]);
typedef ZXIC_UINT32 (*DPP_APT_ERAM_GET_FUNC)(ZXIC_VOID *pData,ZXIC_UINT32 buf[4]);

typedef ZXIC_UINT32 (*DPP_APT_HASH_ENTRY_SET_FUNC)(ZXIC_VOID *pData,DPP_HASH_ENTRY *pEntry);
typedef ZXIC_UINT32 (*DPP_APT_HASH_ENTRY_GET_FUNC)(ZXIC_VOID *pData,DPP_HASH_ENTRY *pEntry);

typedef ZXIC_UINT32 (*DPP_APT_LPM_ENTRY_SET_FUNC)(ZXIC_VOID *pData,ZXIC_VOID *pEntry);
typedef ZXIC_UINT32 (*DPP_APT_LPM_ENTRY_GET_FUNC)(ZXIC_VOID *pData,ZXIC_VOID *pEntry);

typedef ZXIC_UINT32 (*DPP_APT_DDR_SET_FUNC)(ZXIC_VOID *pData,ZXIC_UINT32 buf[DPP_DIR_TBL_BUF_MAX_NUM]);
typedef ZXIC_UINT32 (*DPP_APT_DDR_GET_FUNC)(ZXIC_VOID *pData,ZXIC_UINT32 buf[DPP_DIR_TBL_BUF_MAX_NUM]);

typedef enum dpp_lpm_rsp_ddr_mode_e
{
    LPM_RSP_DDR_MODE_32  = 0,
    LPM_RSP_DDR_MODE_64  = 1,
    LPM_RSP_DDR_MODE_128 = 2,
    LPM_RSP_DDR_MODE_256 = 3,
} DPP_LPM_RSP_DDR_MODE_E;
typedef enum dpp_se_res_type_e
{
    SE_STD_NIC_RES_TYPE      = 0,  /**<  @brief 标卡资源*/
    SE_NON_STD_NIC_RES_TYPE  = 1,  /**<  @brief 非标卡资源(业务卸载)*/
    SE_RES_TYPE_BUTT
} DPP_SE_RES_TYPE_E;

typedef struct dpp_apt_eram_table_t
{
    ZXIC_UINT32 sdtNo;          /** <@brief sdt no 0~255 */
    DPP_SDTTBL_ERAM_T eRamSdt; /** <@brief eRam属性*/
    ZXIC_UINT32 opr_mode;     /**cpu读写位宽模式DPP_ERAM128_OPR_MODE_E 0:128b 1:64b 2:1b 3:32b <@*/
    ZXIC_UINT32 rd_mode;      /*读清模式DPP_ERAM128_RD_CLR_MODE_E，0:正常读 1:读清模式*/
    DPP_APT_ERAM_SET_FUNC  eram_set_func;   /** <@brief 结构体转换为码流 */
    DPP_APT_ERAM_GET_FUNC  eram_get_func;   /** <@brief 码流转换为结构体 */
} DPP_APT_ERAM_TABLE_T;

typedef struct dpp_apt_ddr_table_t
{
    ZXIC_UINT32 sdtNo;          /** <@brief sdt no 0~255 */
    DPP_SDTTBL_DDR3_T eDdrSdt;  /** <@brief DDR属性*/
    ZXIC_UINT32 ddr_table_depth;/** <@brief DDR表项深度，单位与读写模式一致*/
    DPP_APT_DDR_SET_FUNC  ddr_set_func;     /** <@brief 结构体转换为码流 */
    DPP_APT_DDR_GET_FUNC  ddr_get_func;     /** <@brief 码流转换为结构体 */
} DPP_APT_DDR_TABLE_T;

typedef struct dpp_apt_acl_res_t
{
    ZXIC_UINT32 pri_mode;      /** <@brief1：显式优先级，2：隐式优先级，以条目下发顺序作为优先级，3：用户指定每个条目在tcam中的存放索引*/
    ZXIC_UINT32 entry_num;      /** <@brief 可配置的条目数*/
    ZXIC_UINT32 block_num;      /** <@brief  最大8个 */
    ZXIC_UINT32 block_index[DPP_ETCAM_BLOCK_NUM]; /** <@brief  0~7 */
} DPP_APT_ACL_RES_T;

typedef struct dpp_apt_acl_table_t
{
    ZXIC_UINT32 sdtNo;          /** <@brief sdt no 0~255 */
    ZXIC_UINT32 sdt_partner;    /** <@brief sdt no 0~255,eram直接表维护acl index信息，不存在，则设置无效值-1(0xffffffff) */
    DPP_SDTTBL_ETCAM_T aclSdt;  /** <@brief acl属性*/
    DPP_APT_ACL_RES_T aclRes;   /** <@brief acl资源*/
    DPP_APT_ACL_ENTRY_SET_FUNC  acl_set_func;  /** <@brief 结构体转换为码流 */
    DPP_APT_ACL_ENTRY_GET_FUNC  acl_get_func;  /** <@brief 码流转换为结构体 */
} DPP_APT_ACL_TABLE_T;

typedef struct dpp_apt_hash_table_t
{
    ZXIC_UINT32 sdtNo;          /** <@brief sdt no 0~255 */
    ZXIC_UINT32 sdt_partner;    /** <@brief 二级hash sdt号0~255，如果没有二级hash，则设置为无效值-1(0xffffffff) */
    DPP_SDTTBL_HASH_T hashSdt;  /** <@brief hash sdt属性*/
    ZXIC_UINT32 tbl_flag;       /**<  @brief 业务表初始化标记（bit0：老化保活置位使能，bit1：硬件学习使能，bit2：微码写表使能）*/
    DPP_APT_HASH_ENTRY_SET_FUNC hash_set_func;  /** <@brief 结构体转换为码流,转换时预留一个字节，从第1字节开始填充 */
    DPP_APT_HASH_ENTRY_GET_FUNC hash_get_func;  /** <@brief 码流转换为结构体 */
} DPP_APT_HASH_TABLE_T;

typedef struct dpp_apt_hash_func_res_t
{
    ZXIC_UINT32 func_id;        /**<  @brief hash引擎id 0~3*/
    ZXIC_UINT32 zblk_num;       /**<  @brief 0~32*/
    ZXIC_UINT32 zblk_bitmap;    /**<  @brief 置1的bit位表示分配的block编号 */
    ZXIC_UINT32 ddr_dis;        /** <@brief 0:混合模式，1：纯片内模式*/
} DPP_APT_HASH_FUNC_RES_T;

typedef struct dpp_apt_hash_bulk_res_t
{
    ZXIC_UINT32 func_id;                     /**<  @brief 0~3*/
    ZXIC_UINT32 bulk_id;                     /**<  @brief 0~7*/
    ZXIC_UINT32 zcell_num;                   /**<  @brief 0~128*/
    ZXIC_UINT32 zreg_num;                    /**<  @brief 0~128*/
    ZXIC_UINT32 ddr_baddr;                   /**<  @brief 分配给hash的DDR空间的硬件基地址,单位2k*256bit*/
    ZXIC_UINT32 ddr_item_num;                /**<  @brief 分配给hash的DDR空间单元数目，以256bit为一个单元（根据分配的基地址和单元数目确定分配的DDR空间大小）*/
    DPP_HASH_DDR_WIDTH_MODE ddr_width_mode;  /**<  @brief 分配给hash的DDR空间物理存储位宽模式，0:无效值，1:256bit 2:512bit*/
    ZXIC_UINT32 ddr_crc_sel;                 /**<  @brief 选择一个DDR CRC多项式，取值范围0~3,0~3分别对应一个CRC多项式*/
    ZXIC_UINT32 ddr_ecc_en;                  /**<  @brief DDR ECC使能: 0-不使能，1-使能*/
} DPP_APT_HASH_BULK_RES_T;

/* @param   lpm_flags        配置信息
*|0:eRam(第5bit)1:ddr|   (第4bit)      |   (第3bit)      |    (第2bit)   |   (第1bit)   |       (第0bit)       |
*| 级联结果表模式      | v6是否非线速模式  | v4是否非线速模式  | 是否v6片外查找  | 是否v4片外查找 | 是否使能级联结果表查找  |*/
typedef struct dpp_apt_route_res_t
{
    ZXIC_UINT32 lpm_flags;
    ZXIC_UINT32 zblk_num;              /**<  @brief LPM ipv4和ipv6共享的zblock数目*/
    ZXIC_UINT32 zblk_bitmap;           /**<  @brief LPM ipv4和ipv6共享的bitmap*/
    ZXIC_UINT32 mono_ipv4_zblk_num;    /**<  @brief ipv4独占zblock数目*/
    ZXIC_UINT32 mono_ipv4_zblk_bitmap; /**<  @brief ipv4独占zblock bitmap*/
    ZXIC_UINT32 mono_ipv6_zblk_num;    /**<  @brief ipv6独占zblock数目*/
    ZXIC_UINT32 mono_ipv6_zblk_bitmap; /**<  @brief ipv6独占zblock bitmap*/
    ZXIC_UINT32 ddr4_item_num;         /**<  @brief 分配给ipv4前缀查找的ddr存储条目数，以256bit为单位*/
    ZXIC_UINT32 ddr4_baddr;            /**<  @brief 分配给ipv4前缀查找的ddr存储空间的基地址，以4K*128bit为单位*/
    ZXIC_UINT32 ddr4_base_offset;      /**<  @brief ipv4前缀查找相对于片外ddr存储空间基地址的偏移量，以256bit为单位*/
    ZXIC_UINT32 ddr4_ecc_en;           /**<  @brief 固定配为1，分配给ipv4前缀查找的ddr存储空间的ECC校验使能标志*/
    ZXIC_UINT32 ddr6_item_num;         /**<  @brief 分配给ipv6前缀查找的ddr存储条目数，以256bit为单位*/
    ZXIC_UINT32 ddr6_baddr;            /**<  @brief 分配给ipv6前缀查找的ddr存储空间的基地址，以4K*128bit为单位*/
    ZXIC_UINT32 ddr6_base_offset;      /**<  @brief ipv6前缀查找相对于片外ddr存储空间基地址的偏移量，以256bit为单位*/
    ZXIC_UINT32 ddr6_ecc_en;           /**<  @brief 固定配为1，分配给ipv4前缀查找的ddr存储空间的ECC校验使能标志*/
} DPP_APT_ROUTE_RES_T;
typedef struct dpp_apt_lpm_table_t
{
    ZXIC_UINT32 sdtNo;             /** <@brief sdt no 0~255 */
    DPP_SDTTBL_LPM_T lpmSdt;       /** <@brief lpm属性*/
    DPP_ROUTE_AS_ERAM_T as_eram_cfg[DPP_SMMU0_LPM_AS_TBL_ID_NUM];  /**<  @brief LPM级联eRam结果表空间属性*/
    DPP_ROUTE_AS_DDR_T  as_ddr_cfg;   /**<  @brief LPM级联DDR结果表空间属性*/
    DPP_APT_LPM_ENTRY_SET_FUNC  lpm_set_func;  /** <@brief 结构体转换为码流 */
    DPP_APT_LPM_ENTRY_GET_FUNC  lpm_get_func;  /** <@brief 码流转换为结构体 */
} DPP_APT_LPM_TABLE_T;

typedef struct dpp_apt_res_deinit_t
{
    ZXIC_UINT32 queue_id;                       /*<@brief 释放队列*/
    ZXIC_CHAR  port_name[DPP_PORT_NAME_MAX];   
    ZXIC_UINT32 flag;                           /*<@brief 释放hash表资源标识 bit0:hash0,bit1:hash1,bit2:hash2,bit3:hash3 */
    ZXIC_UINT32 flush_mode;                     /*<@brief DDR flush方式 0：寄存器方式 1：dtb方式 参考DPP_DDR_FLUSH_MODE_E*/                    
    ZXIC_UINT32 sdt_num;                        /*<@brief 除hash sdt外需要释放的sdt个数*/
    ZXIC_UINT32 sdt_array[];                       /*<@brief 需要释放资源的sdt号 sdt no 0~255 */   
}DPP_APT_RES_DEINIT_T;

typedef struct dpp_apt_eram_res_init_t
{
    ZXIC_UINT32 tbl_num;
    DPP_APT_ERAM_TABLE_T *eram_res;
} DPP_APT_ERAM_RES_INIT_T;

typedef struct dpp_ddr_res_init_t
{
    ZXIC_UINT32 tbl_num;
    DPP_APT_DDR_TABLE_T *ddr_res;
} DPP_APT_DDR_RES_INIT_T;

typedef struct dpp_apt_hash_res_init_t
{   
    ZXIC_UINT32 func_num; 
    ZXIC_UINT32 bulk_num;
    ZXIC_UINT32 tbl_num;
    DPP_APT_HASH_FUNC_RES_T *func_res;
    DPP_APT_HASH_BULK_RES_T *bulk_res;
    DPP_APT_HASH_TABLE_T  *tbl_res;
} DPP_APT_HASH_RES_INIT_T;

typedef struct dpp_apt_lpm_res_init_t
{
    ZXIC_UINT32 tbl_num;              /*最大个数为2*/
    DPP_APT_LPM_TABLE_T *lpm_res;     /*ipv4/ipv6资源*/
    DPP_APT_ROUTE_RES_T *glb_res;     /*ipv4/ipv6公共资源*/
} DPP_APT_LPM_RES_INIT_T;

typedef struct dpp_apt_acl_res_init_t
{
    ZXIC_UINT32 tbl_num; 
    DPP_APT_ACL_TABLE_T *acl_res;
} DPP_APT_ACL_RES_INIT_T;

typedef struct dpp_apt_stat_res_init_t
{
    ZXIC_UINT32 eram_baddr;      /*片内统计基地址，单位128bit*/
    ZXIC_UINT32 eram_depth;      /*片内统计深度，单位128bit*/
    ZXIC_UINT32 ddr_baddr;       /*片外统计基地址，单位2k*256bit*/ 
    ZXIC_UINT32 ppu_ddr_offset;  /*片外DDR统计偏移，单位128bit，默认为0*/
} DPP_APT_STAT_RES_INIT_T;

typedef struct dpp_dtb_addr_info_t
{
    ZXIC_UINT32 sdt_no;        /** <@brief sdt no 0~255 */
    ZXIC_UINT32 size;          /** <@brief dump空间大小 最大64MB*/
    ZXIC_ADDR_T phy_addr;      /** <@brief dump空间物理地址 */
    ZXIC_ADDR_T vir_addr;      /** <@brief dump空间虚拟地址 */
}DPP_DTB_ADDR_INFO_T;
typedef struct dpp_dev_init_ctrl_t
{
    ZXIC_UINT32 vport;          /** <@brief vport */                     
    ZXIC_CHAR  port_name[DPP_PORT_NAME_MAX];
    ZXIC_UINT32 vector;                    /** <@brief 中断号 0~127 */    
    ZXIC_UINT32 queue_id;                  /** <@brief 队列号 0~127 NP申请，返回给用户*/ 
    ZXIC_UINT32 np_bar_offset;             /** <@brief NP模块bar偏移地址*/ 
    ZXIC_UINT32 np_bar_len;                /** <@brief NP模块bar通道长度*/ 
    ZXIC_ADDR_T pcie_vir_addr;             /** <@brief pcie虚拟地址 */
    ZXIC_ADDR_T down_phy_addr;             /** <@brief 用户申请的大页物理地址(dtb下发通道地址) */
    ZXIC_ADDR_T down_vir_addr;             /** <@brief 用户申请的大页虚拟地址(dtb下发通道地址) */
    ZXIC_ADDR_T dump_phy_addr;             /** <@brief 用户申请的大页物理地址(dtb dump通道地址) */
    ZXIC_ADDR_T dump_vir_addr;             /** <@brief 用户申请的大页虚拟地址(dtb dump通道地址) */
    ZXIC_UINT32 dump_sdt_num;              /** <@brief 需要dump的sdt个数 */
    DPP_DTB_ADDR_INFO_T dump_addr_info[];  /** <@brief dtb dump空间地址 */
} DPP_DEV_INIT_CTRL_T;

typedef struct dpp_apt_se_res_t
{
    ZXIC_UINT32              valid;
    ZXIC_UINT32              hash_func_num;
    ZXIC_UINT32              hash_bulk_num;
    ZXIC_UINT32              hash_tbl_num;
    ZXIC_UINT32              eram_num;
    ZXIC_UINT32              acl_num;
    ZXIC_UINT32              lpm_num;
    ZXIC_UINT32              ddr_num;
    DPP_APT_HASH_FUNC_RES_T  hash_func[HASH_FUNC_MAX_NUM];
    DPP_APT_HASH_BULK_RES_T  hash_bulk[HASH_BULK_MAX_NUM];
    DPP_APT_HASH_TABLE_T     hash_tbl[HASH_TABLE_MAX_NUM];
    DPP_APT_ERAM_TABLE_T     eram_tbl[ERAM_MAX_NUM];
    DPP_APT_ACL_TABLE_T      acl_tbl[ETCAM_MAX_NUM];
    DPP_APT_ROUTE_RES_T      lpm_global_res;
    DPP_APT_LPM_TABLE_T      lpm_tbl[LPM_MAX_NUM];
    DPP_APT_DDR_TABLE_T      ddr_tbl[DDR_MAX_NUM];
    DPP_APT_STAT_RES_INIT_T  stat_cfg;
}DPP_APT_SE_RES_T;

#endif

#if ZXIC_REAL("SE APT FUNCTION")

/***********************************************************/
/** 获取ERAM资源信息
* @param   dev_id           设备号
* @param   type             资源类型，详见DPP_SE_RES_TYPE_E
* @param   pEramResInit     出参，eram资源
* @param   
* @return  
* @remark  无
* @see
* @author  cq      @date  2024/01/24
************************************************************/
DPP_STATUS dpp_apt_eram_res_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type, DPP_APT_ERAM_RES_INIT_T *pEramResInit);

/***********************************************************/
/** 获取HASH资源信息
* @param   dev_id            设备号
* @param   type              资源类型，详见DPP_SE_RES_TYPE_E
* @param   pHashResInit      出参，hash资源
* @param   
* @return  
* @remark  无
* @see
* @author  cq      @date  2024/01/24
************************************************************/
DPP_STATUS dpp_apt_hash_res_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type, DPP_APT_HASH_RES_INIT_T *pHashResInit);

/***********************************************************/
/** 获取DDR资源信息
* @param   type              资源类型，详见DPP_SE_RES_TYPE_E
* @param   pDdrResInit       出参，DDR直接表资源
* @param   
* @return  
* @remark  无
* @see
* @author  cq      @date  2024/01/24
************************************************************/
DPP_STATUS dpp_apt_ddr_res_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type, DPP_APT_DDR_RES_INIT_T *pDdrResInit);

/***********************************************************/
/** 获取ACL资源信息
* @param   dev_id         设备号
* @param   type            资源类型，详见DPP_SE_RES_TYPE_E
* @param   pAclResInit     出参，acl资源
* @param   
* @return  
* @remark  无
* @see
* @author  cq      @date  2024/01/24
************************************************************/
DPP_STATUS dpp_apt_acl_res_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type, DPP_APT_ACL_RES_INIT_T *pAclResInit);

/***********************************************************/
/** 获取LPM资源信息
* @param   type            资源类型，详见DPP_SE_RES_TYPE_E
* @param   pLpmResInit     出参，DDR直接表资源
* @param   
* @return  
* @remark  无
* @see
* @author  cq      @date  2024/01/24
************************************************************/
DPP_STATUS dpp_apt_lpm_res_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type, DPP_APT_LPM_RES_INIT_T *pLpmResInit);

/***********************************************************/
/** 获取统计资源信息
* @param   dev_id          设备号
* @param   type            资源类型，详见DPP_SE_RES_TYPE_E
* @param   pStatResInit     出参，统计资源
* @param   
* @return  
* @remark  无
* @see
* @author  cq      @date  2024/01/24
************************************************************/
DPP_STATUS dpp_apt_stat_res_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type, DPP_APT_STAT_RES_INIT_T *pStatResInit);

/***********************************************************/
/** eram表资源初始化
* @param   dev_id  设备号 
* @param   tbl_num  需初始化的eram表个数
* @param   pEramTbl  eram资源信息，包括SDT配置信息，直接表读取位宽和结构体码流转换回调函数
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_eram_res_init(ZXIC_UINT32 dev_id,ZXIC_UINT32 tbl_num,DPP_APT_ERAM_TABLE_T *pEramTbl);

/***********************************************************/
/** eram表项插入/更新
* @param   dev_id  设备号 
* @param   sdt_no  SDT号 0~255
* @param   index   条目index，索引范围随wrt_mode模式不同
* @param   pData   插入表项内容，由业务确定
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_eram_insert(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,ZXIC_UINT32 index,void *pData);

/***********************************************************/
/** eram表项删除,将指定索引位置数据清0
* @param   dev_id  设备号 
* @param   sdt_no  SDT号 0~255
* @param   index   条目index，索引范围随wrt_mode模式不同
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_eram_clear(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,ZXIC_UINT32 index);

/***********************************************************/
/** 获取eram表项数据
* @param   dev_id  设备号 
* @param   sdt_no  SDT号 0~255
* @param   index   条目index，索引范围随wrt_mode模式不同
* @param   pData   出参，返回业务表项内容
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_eram_get(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,ZXIC_UINT32 index,void *pData);

/***********************************************************/
/** DDR表资源初始化
* @param   dev_id  设备号 
* @param   tbl_num  需初始化的DDR表个数
* @param   pDdrTbl  ddr资源信息，包括SDT配置信息，直接表读取位宽和结构体码流转换回调函数
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/07/26
************************************************************/
DPP_STATUS dpp_apt_ddr_res_init(ZXIC_UINT32 dev_id,ZXIC_UINT32 tbl_num,DPP_APT_DDR_TABLE_T *pDdrTbl);

/***********************************************************/
/** ddr表项插入/更新
* @param   dev_id  设备号 
* @param   sdt_no  SDT号 0~255
* @param   index   条目index，索引范围随rw_mode模式(128bit/256bit/512bit)不同
* @param   pData   插入表项内容，由业务确定
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/07/26
************************************************************/
DPP_STATUS dpp_apt_ddr_insert(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,ZXIC_UINT32 index,void *pData);

/***********************************************************/
/** ddr表项删除,将指定索引位置数据清0
* @param   dev_id  设备号 
* @param   sdt_no  SDT号 0~255
* @param   index   条目index，索引范围随rw_mode模式(128bit/256bit/512bit)不同
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_ddr_clear(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,ZXIC_UINT32 index);

/***********************************************************/
/** ddr表项数据获取
* @param   dev_id  设备号 
* @param   sdt_no  SDT号 0~255
* @param   index   条目index，索引范围随rw_mode模式不同
* @param   pData   出参，返回业务表项内容
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/07/26
************************************************************/
DPP_STATUS dpp_apt_ddr_get(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,ZXIC_UINT32 index,void *pData);

/***********************************************************/
/** acl资源初始化
* @param   dev_id  设备号 
* @param   tbl_num     etcam对应的sdt表个数
* @param   pAclTblRes  acl表资源信息，包括SDT配置信息，acl资源(条目数，存放方式和占用的block)和结构体码流转换回调函数
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_acl_res_init(ZXIC_UINT32 dev_id,ZXIC_UINT32 tbl_num,DPP_APT_ACL_TABLE_T *pAclTblRes);

/***********************************************************/
/** acl表项插入/更新
* @param   dev_id  设备号 
* @param   sdt_no  sdt号 0~255
* @param   pData   业务插入表项内容，具体结构体由业务确定(结构体的第一个字段必须为index)，SDK不感知
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_acl_entry_insert(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no, void *pData);

/***********************************************************/
/** acl表项删除
* @param   dev_id  设备号 
* @param   sdt_no  sdt号 0~255
* @param   pData   删除表项，具体结构体由业务确定(结构体的第一个字段必须为index)，SDK不感知
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_acl_entry_delete(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no, void *pData);

/***********************************************************/
/** acl表项查找(根据data&mask查找)
* @param   dev_id  设备号 
* @param   sdt_no  sdt号 0~255
* @param   pData   查找表项，具体结构体由业务确定，SDK不感知
* @param   srh_mode 查找模式 0:软件查找 1:硬件查找
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_acl_entry_search(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,void *pData,ZXIC_UINT32 srh_mode);

/***********************************************************/
/** acl表项查找(根据索引查找)
* @param   dev_id  设备号 
* @param   sdt_no  sdt号 0~255
* @param   index   acl表项索引值
* @param   pData   查找表项，具体结构体由业务确定(结构体的第一个字段必须为index)，SDK不感知
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_acl_entry_get(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,void *pData);


/***********************************************************/
/** hash表全局资源初始化
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_hash_global_res_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/** hash表全局资源去初始化
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  cq      @date  2024/08/01
************************************************************/
DPP_STATUS dpp_apt_hash_global_res_uninit(ZXIC_UINT32 dev_id);

/***********************************************************/
/** hash引擎初始化
* @param   dev_id  设备号 
* @param   func_num     需初始化的hash引擎个数 1~4
* @param   pHashFuncRes  每个hash引擎分配的zblock个数和编号，以及分配模式(混合模式或者纯片内模式)
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_hash_func_res_init(ZXIC_UINT32 dev_id,ZXIC_UINT32 func_num,DPP_APT_HASH_FUNC_RES_T *pHashFuncRes);

/***********************************************************/
/** hash引擎bulk空间初始化
* @param   dev_id  设备号 
* @param   bulk_num     需初始化的bulk表个数 1~32
* @param   pBulkRes  zcell和zreg资源占用信息，如果是混合模式，需进行DDR资源分配
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_hash_bulk_res_init(ZXIC_UINT32 dev_id,ZXIC_UINT32 bulk_num,DPP_APT_HASH_BULK_RES_T *pBulkRes);

/***********************************************************/
/** hash业务表属性初始化
* @param   dev_id  设备号 
* @param   tbl_num     需初始化的业务表表个数 1~128
* @param   pHashTbl  sdt配置信息，初始化标记和业务结构体码流转换函数
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_hash_tbl_res_init(ZXIC_UINT32 dev_id,ZXIC_UINT32 tbl_num,DPP_APT_HASH_TABLE_T *pHashTbl);

/***********************************************************/
/** stat资源初始化
* @param   dev_id  设备号 
* @param   type            资源类型，详见DPP_SE_RES_TYPE_E
* @param   stat_res_init  stat资源
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_stat_res_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 type, DPP_APT_STAT_RES_INIT_T *stat_res_init);

/***********************************************************/
/** hash表项插入/更新
* @param   dev_id  设备号 
* @param   sdt_no  sdt号 0~255
* @param   pData   插入hash表项信息,由业务确定
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_hash_insert(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,void *pData);

/***********************************************************/
/** hash表项删除
* @param   dev_id  设备号 
* @param   sdt_no  sdt号 0~255
* @param   pData   删除hash表项信息,由业务传入
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_hash_delete(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,void *pData);

/***********************************************************/
/** hash表项查找
* @param   dev_id  设备号 
* @param   sdt_no  sdt号 0~255
* @param   pData   删除hash表项信息,由业务传入
* @param   hdw_flag   查找模式，0：软件查找 1：硬件查找
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_hash_search(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,void *pData,ZXIC_UINT32 hdw_flag);

/***********************************************************/
/** 删除全部hash表项和hash表资源
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  cq      @date  2023/09/19
************************************************************/
DPP_STATUS dpp_apt_hash_destroy(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 指定sdt的hash表删除
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  cq      @date  2023/09/19
************************************************************/
DPP_STATUS dpp_apt_hash_table_delete(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no);

/***********************************************************/
/** lpm资源初始化
* @param   dev_id      设备号 
* @param   pGlobalRes  占用zblock信息以及DDR资源
* @param   tbl_num     表项个数，最多2个，ipv4和ipv6
* @param   pLpmTbl     sdt资源信息以及级联信息
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/02/22
************************************************************/
DPP_STATUS dpp_apt_lpm_res_init(ZXIC_UINT32 dev_id,DPP_APT_ROUTE_RES_T *pGlobalRes,ZXIC_UINT32 tbl_num,DPP_APT_LPM_TABLE_T *pLpmTbl);

/***********************************************************/
/** hash表资源释放
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/09/19
************************************************************/
DPP_STATUS dpp_apt_hash_destroy(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 删除全部lpm表项和lpm表资源
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  cq      @date  2023/09/19
************************************************************/
DPP_STATUS dpp_apt_lpm_destroy(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 删除全部hash/lpm表项和hash/lpm表资源
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  cq      @date  2023/09/19
************************************************************/
DPP_STATUS dpp_apt_hash_lpm_destroy(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 插入lpm表项
* @param   dev_id  设备号 
* @param   sdt_no  sdt号0~255 
* @param   pData   插入表项内容，由业务确定 
* @return  
* @remark  无
* @see     
* @author  cq      @date  2023/10/17
************************************************************/
DPP_STATUS dpp_apt_lpm_insert(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,void *pData);

/***********************************************************/
/** 删除lpm表项
* @param   dev_id  设备号 
* @param   sdt_no  sdt号0~255 
* @param   pData   删除表项内容，由业务确定 
* @return  
* @remark  无
* @see     
* @author  cq      @date  2023/10/17
************************************************************/
DPP_STATUS dpp_apt_lpm_delete(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,void *pData);

/***********************************************************/
/** 查找lpm表项
* @param   dev_id  设备号 
* @param   sdt_no  sdt号0~255 
* @param   pData   查找表项内容，由业务确定 
* @param   hdw_flag   0:软件查找 1:硬件查找
* @return  
* @remark  无
* @see     
* @author  cq      @date  2023/10/17
************************************************************/
DPP_STATUS dpp_apt_lpm_search(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no,void *pData,ZXIC_UINT32 hdw_flag);

/***********************************************************/
/** 获取lpm级联结果
* @param   dev_id   设备号
* @param   route_id  4：ipv4 5:ipv6 见DPP_ROUTE_ID_E
* @param   vpn_id      
* @param   index       索引
* @param   as_data      级联结果
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author cq     @date  2023/12/28
************************************************************/
DPP_STATUS dpp_lpm_as_data_get(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 route_id, 
                                ZXIC_UINT32 vpn_id,
                                ZXIC_UINT32 handle, 
                                ZXIC_UINT8 *as_data);

/***********************************************************/
/** dtb资源初始化
* @param   dev_id  设备号 
* @param   p_dev_init_ctrl   初始化配置信息
* @return  
* @remark  无
* @see     
* @author  cq      @date  2023/10/17
************************************************************/
DPP_STATUS dpp_apt_dtb_res_init(ZXIC_UINT32 dev_id, DPP_DEV_INIT_CTRL_T *p_dev_init_ctrl);

/***********************************************************/
/** 释放sdt资源以及适配资源
* @param   dev_id      设备号
* @param   sdt_no      sdt号
* @return  
* @remark  无
* @see
* @author  cq      @date  2023/11/09
************************************************************/
DPP_STATUS dpp_apt_sdt_res_deinit(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no);

/***********************************************************/
/** dtb资源释放(包括流表资源和流表)
* @param   dev_id  设备号 
* @param   p_res_deinit_ctrl   释放的资源信息
* @return  
* @remark  无
* @see     
* @author  cq      @date  2023/10/17
************************************************************/
DPP_STATUS dpp_apt_dtb_res_deinit(ZXIC_UINT32 dev_id, DPP_APT_RES_DEINIT_T *p_res_deinit_ctrl);

/***********************************************************/
/** 获取hash表数目
* @param   dev_id         设备号
* @param   type         流表类型0:标卡 1：非标卡 DPP_SE_RES_TYPE_E
* @return  ZXIC_UINT32
* @remark  无
* @see
* @author  cq      @date  2024/01/24
************************************************************/
ZXIC_UINT32 dpp_apt_hash_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** 获取eram表数目
* @param   dev_id         设备号
* @param   type         流表类型0:标卡 1：非标卡 DPP_SE_RES_TYPE_E
* @return  ZXIC_UINT32
* @remark  无
* @see
* @author  cq      @date  2024/11/16
************************************************************/
ZXIC_UINT32 dpp_apt_eram_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** 获取acl表数目
* @param   dev_id         设备号
* @param   type         流表类型0:标卡 1：非标卡 DPP_SE_RES_TYPE_E
* @return  ZXIC_UINT32
* @remark  无
* @see
* @author  cq      @date  2024/11/16
************************************************************/
ZXIC_UINT32 dpp_apt_acl_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** 获取ddr表数目
* @param   dev_id         设备号
* @param   type         流表类型0:标卡 1：非标卡 DPP_SE_RES_TYPE_E
* @return  ZXIC_UINT32
* @remark  无
* @see
* @author  cq      @date  2024/11/16
************************************************************/
ZXIC_UINT32 dpp_apt_ddr_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** 获取ddr表数目
* @param   dev_id         设备号
* @param   type         流表类型0:标卡 1：非标卡 DPP_SE_RES_TYPE_E
* @return  ZXIC_UINT32
* @remark  无
* @see
* @author  cq      @date  2024/11/16
************************************************************/
ZXIC_UINT32 dpp_apt_lpm_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** 消息通道获取指定类型的所有流表资源
* @param   devId          NP设备号
* @param   type           资源类型0:标卡 1:非标卡
* @return
* @remark  无
* @see
* @author  cq      @date  2024/11/11
************************************************************/
DPP_STATUS dpp_agent_se_res_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** 初始化流表资源
* @param   devId          NP设备号
* @param   type           资源类型0:标卡 1:非标卡
* @return
* @remark  无
* @see
* @author  cq      @date  2024/11/11
************************************************************/
DPP_STATUS dpp_se_res_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** 消息通道获取指定类型流表资源&流表资源初始化
* @param   devId          NP设备号
* @param   type           资源类型0:标卡 1:非标卡
* @return
* @remark  无
* @see
* @author  cq      @date  2024/11/11
************************************************************/
DPP_STATUS dpp_se_res_get_and_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);
#endif

#endif