/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_trpg_api.h
* 文件标识 : 
* 内容摘要 : TRPG模块对外数据结构和函数声明
* 其它说明 : 
* 当前版本 : 
* 作    者 : yangyg
* 完成日期 : 2015/02/15
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* 修改记录1: 
* 修改日期:  
* 版 本 号:  
* 修 改 人:  
* 修改内容:  
***************************************************************/

#ifndef _DPP_TRPG_API_H_
#define _DPP_TRPG_API_H_

#include "zxic_common.h"
#include "dpp_type_api.h"

#if ZXIC_REAL("TRPG RX macro")
#define TRPG_RX_RAM_DEEP                        (32U)
#define TRPG_RX_HIGH_WATER_LEVEL_DEFAULT        (30U)
#define TRPG_RX_LOW_WATER_LEVEL_DEFAULT         (10U)
#define TRPG_RX_RAM_ALMOST_FULL_LEVAL_DEFAULT   (28U)
#define TRPG_RX_DATA_RAM_WORD_NUM               (TRPG_RX_RAM_DEEP * 2048 / 32)
#define TRPG_RX_INFO_RAM_WORD_NUM               (TRPG_RX_RAM_DEEP * 256 / 32)
#define TRPG_RX_INFO_RAM_VALID_WORD_NUM         (TRPG_RX_RAM_DEEP * 160 / 32)
#define TPRG_RX_INFO_RAM_ROW_WIDTH              (8U)
#define TRPG_RX_INFO_RAM_ROW_VALID_WIDTH        (5U)
#endif

#if ZXIC_REAL("TRPG TX macro")
#define TRPG_TX_RAM_DEEP                            (188U)
#define TRPG_TX_RAM_ALMOST_FULL_LEVEL_DEFAULT_200G  (32U)
#define TRPG_TX_ETM_RAM_DEEP                        (8U)
#define TRPG_TX_ETM_RAM_ALMOST_FULL_LEVEL_DEFAULT   (5U)
#define TRPG_TX_DATA_RAM_WORD_NUM                   (TRPG_TX_RAM_DEEP * 2048 / 32)
#define TRPG_TX_INFO_RAM_WORD_NUM                   (TRPG_TX_RAM_DEEP * 128 / 32)
#define TRPG_TX_INFO_RAM_VALID_WORD_NUM             (TRPG_TX_RAM_DEEP * 96 / 32)
#define TPRG_TX_INFO_RAM_ROW_WIDTH                  (4U)
#define TRPG_TX_INFO_RAM_ROW_VALID_WIDTH            (3U)
#define TRPG_TX_ETM_DATA_RAM_WORD_NUM               (TRPG_TX_ETM_RAM_DEEP * 2048 / 32)
#define TRPG_TX_ETM_INFO_RAM_WORD_NUM               (TRPG_TX_RAM_DEEP * 128 / 32)
#define TRPG_TX_ETM_INFO_RAM_VALID_WORD_NUM         (TRPG_TX_RAM_DEEP * 96 / 32)
#define TPRG_TX_ETM_INFO_RAM_ROW_WIDTH              (4U)
#define TRPG_TX_ETM_INFO_RAM_ROW_VALID_WIDTH        (3U)
#endif

#if ZXIC_REAL("TRPG GLB macro")
#define TRPG_EXT_PORT_NUM_BEGIN                 (0U)
#define TRPG_EXT_PORT_NUM_END                   (9U)
#define TRPG_INT_PORT_NUM_BEGIN                 (16U)
#define TRPG_INT_PORT_NUM_UNUSED_BEGIN          (17U)
#define TPRG_INT_PORT_NUM_UNUSED_END            (23U)
#define TRPG_INT_PORT_NUM_END                   (27U)
#define TRPG_PORT_RAM_NUM_BEGIN                 (0)
#define TRPG_PORT_RAM_NUM_END                   (14)
#define TRPG_GLB_TOD_TIME_RAM_DEEP              (2048U)
#define TRPG_TOKEN_FC_CLK_FREQ_MAX              (2047U)
// 默认DPU芯片的基频为1Ghz，令牌桶所需的0.1us工作周期，需要100个clk
#define TPRG_TOKEN_FC_CLK_FREQ_DEFAULT          (100U)
#define TRPG_TOKEN_FC_ADD_NUM_MAX               (32767U)    //15 bits
#define TRPG_TOKEN_FC_DEEP_MIN                  (32768U)    
#define TPRG_TOKEN_FC_DEEP_MAX                  (65535U)    //16 bits
#define TPRG_TOKEN_FC_DEEP_DEFAULT              (49152U)
#endif

#if ZXIC_REAL("TRPG ENMU macro")
typedef enum dpp_trpg_extlport_num
{
    TRPG_EXTLPORT_MAC0    = 0,
    TRPG_EXTLPORT_MAC1    = 1,
    TRPG_EXTLPORT_MAC2    = 2,
    TRPG_EXTLPORT_MAC3    = 3,
    TRPG_EXTLPORT_MAC4    = 4,
    TRPG_EXTLPORT_MAC5    = 5,
    TRPG_EXTLPORT_MAC6    = 6,
    TRPG_EXTLPORT_MAC7    = 7,
    TRPG_EXTLPORT_MAC8    = 8,
    TRPG_EXTLPORT_MAC9    = 9,
}DPP_TRPG_EXTLPORT_NUM;

typedef enum dpp_trpg_intlport_num
{
    TRPG_INTLPORT_RDMA    = 16,
    TRPG_INTLPORT_VQM     = 24,
    TRPG_INTLPORT_DTP     = 25,
    TRPG_INTLPORT_DRS     = 26,
    TRPG_INTLPORT_DTD     = 27,
}DPP_TRPG_INTLPORT_NUM;

typedef enum dpp_trpg_port_ram_num
{
    TRPG_RAM_MAC0      = 0,
    TRPG_RAM_MAC1      = 1,
    TRPG_RAM_MAC2      = 2,
    TRPG_RAM_MAC3      = 3,
    TRPG_RAM_MAC4      = 4,
    TRPG_RAM_MAC5      = 5,
    TRPG_RAM_MAC6      = 6,
    TRPG_RAM_MAC7      = 7,
    TRPG_RAM_MAC8      = 8,
    TRPG_RAM_MAC9      = 9,
    TRPG_RAM_RDMA      = 10,
    TRPG_RAM_VQM       = 11,
    TRPG_RAM_DTP       = 12,
    TRPG_RAM_DRS       = 13,
    TRPG_RAM_DTD       = 14,
}DPP_TRPG_PORT_RAM_NUM;

typedef enum dpp_trpg_token_fc_mode
{
    TRPG_TOKEN_FC_10G  = 125,
    TRPG_TOKEN_FC_25G  = 312,
    TRPG_TOKEN_FC_32G  = 400,
    TRPG_TOKEN_FC_50G  = 625,
    TPRG_TOKEN_FC_64G  = 800,
    TRPG_TOKEN_FC_100G = 1250,
    TRPG_TOKEN_FC_200G = 2500,
    TRPG_TOKEN_FC_400G = 5000,
}DPP_TRPG_TOKEN_FC_MODE;
#endif

#if ZXIC_REAL("TRPG CHECK macro")

#define DPP_TRPG_CHECK_PORT_NUM(dev_id,portNo)\
    do{\
        if(portNo > TRPG_EXT_PORT_NUM_END && portNo < TRPG_INT_PORT_NUM_BEGIN)\
        {\
            ZXIC_COMM_TRACE_DEV_ERROR(dev_id, "\n %s:%d[Error:PORT_NO[0x%x] INVALID]! FUNCTION :%s !\n", __FILE__, __LINE__, portNo, __FUNCTION__);\
            ZXIC_COMM_ASSERT(0);\
            return ZXIC_ERR;\
        }\
        else if(portNo >= TRPG_INT_PORT_NUM_UNUSED_BEGIN && portNo <= TPRG_INT_PORT_NUM_UNUSED_END)\
        {\
            ZXIC_COMM_TRACE_DEV_ERROR(dev_id, "\n %s:%d[Error:PORT_NO[0x%x] INVALID]! FUNCTION :%s !\n", __FILE__, __LINE__, portNo, __FUNCTION__);\
            ZXIC_COMM_ASSERT(0);\
            return ZXIC_ERR;\
        }\
        else if(portNo >= TRPG_INT_PORT_NUM_END)\
        {\
            ZXIC_COMM_TRACE_DEV_ERROR(dev_id, "\n %s:%d[Error:PORT_NO[0x%x] INVALID]! FUNCTION :%s !\n", __FILE__, __LINE__, portNo, __FUNCTION__);\
            ZXIC_COMM_ASSERT(0);\
            return ZXIC_ERR;\
        }\
     }while(0)

#endif

#if ZXIC_REAL("TRPG FUNCTION macro")

/***********************************************************/
/** TRPG模块初始化
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG EXTERNAL PORT MASTER SLAVE STATUS SET
* @param   dev_id  设备号
* @param   masterPort  外端口主端口号
* @param   slavePort   外端口从端口号
* @param   en      使能状态
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_extlport_ms_status_set(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM masterPort, DPP_TRPG_EXTLPORT_NUM slavePort, BOOLEAN en);


/***********************************************************/
/** TRPG EXTERNAL PORT MASTER SLAVE STATUS GET
* @param   dev_id  设备号
* @param   portNo  外端口号
* @param   en      使能状态指针
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_extlport_ms_status_get(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM portNo, BOOLEAN* en);

/***********************************************************/
/** TRPG EXTERNAL PORT MASTER SLAVE ENABLE SET
* @param   dev_id      设备号
* @param   masterPort  主外端口号
* @param   slavePort   从外端口号
* @param   en          使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_extlport_ms_en_set(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM masterPort, DPP_TRPG_EXTLPORT_NUM slavePort, BOOLEAN en);

/***********************************************************/
/** TRPG EXTERNAL PORT MASTER SLAVE ENABLE GET
* @param   dev_id      设备号
* @param   extlPort    外端口号
* @param   en          使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_extlport_ms_en_get(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM extlPort, BOOLEAN *en);

/***********************************************************/
/** TRPG EXTERNAL PORT MASTER SLAVE CONFIGURE SET
* @param   dev_id      设备号
* @param   masterPort  主外端口号
* @param   slavePort   从外端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_extlport_ms_config_set(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM masterPort, DPP_TRPG_EXTLPORT_NUM slavePort);

/***********************************************************/
/** TRPG EXTERNAL PORT MASTER SLAVE IND GET
* @param   dev_id      设备号
* @param   extlPort    外端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_extlport_ms_ind_get(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM extlPort, BOOLEAN *en);

/***********************************************************/
/** TRPG EXTERNAL PORT MASTER SLAVE PARTNER GET
* @param   dev_id      设备号
* @param   extlPort    外端口号
* @param   partnerPort 配合端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_extlport_ms_partner_get(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM extlPort, DPP_TRPG_EXTLPORT_NUM *partnerPort);

/***********************************************************/
/** TRPG INT&EXT PORT ENABLE SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_port_packet_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN en);

/***********************************************************/
/** TRPG INT&EXT PORT ENABLE GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_port_packet_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN *en);

/***********************************************************/
/** TRPG INT&EXT PORT INNER LOOPBACK ENABLE SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      内环回使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_port_inner_loopback_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN en);

/***********************************************************/
/** TRPG INT&EXT PORT INNER LOOPBACK ENABLE GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      内环回使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_port_inner_loopback_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN *en);

/***********************************************************/
/** TRPG RX EXTERNAL PORT FC PAUSE THRESHOLD SET
* @param   dev_id         设备号 
* @param   portNo         外端口号
* @param   thresholdHigh  PAUSE高水线(单位：256 Byte)
* @param   thresholdLow   PAUSE低水线(单位：256 Byte)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_extlport_pause_threshold_set(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM portNo, ZXIC_UINT32 thresholdHigh, ZXIC_UINT32 thresholdLow);

/***********************************************************/
/** TRPG RX INT&EXT PORT RAM ALMOST FULL LEVEL SET
* @param   dev_id   设备号 
* @param   portNo   端口号
* @param   level    将满水位(单位：256 Byte)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_ram_almost_full_level_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 level);

/***********************************************************/
/** TRPG RX INT&EXT PORT RAM ALMOST FULL LEVEL GET
* @param   dev_id   设备号 
* @param   portNo   端口号
* @param   level    将满水位(单位：256 Byte)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_ram_almost_full_level_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 *level);

/***********************************************************/
/** TRPG RX INTERNAL PORT PFC ENABLE SET
* @param   dev_id  设备号 
* @param   portNo  内端口号
* @param   en      PFC使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_intlport_pfc_en_set(ZXIC_UINT32 dev_id, DPP_TRPG_INTLPORT_NUM portNo, BOOLEAN en);

/***********************************************************/
/** TRPG RX INTERNAL PORT PFC ENABLE GET
* @param   dev_id    设备号 
* @param   intlPort  内端口号
* @param   en        PFC使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_intlport_pfc_en_get(ZXIC_UINT32 dev_id, DPP_TRPG_INTLPORT_NUM intlPort, BOOLEAN *en);

/***********************************************************/
/** TRPG RX INT&EXT PORT RAM TEST ENABLE SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      使能:1-CPU读写RAM  0-逻辑读写RAM
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_ram_test_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN en);

/***********************************************************/
/** TRPG RX INT&EXT PORT RAM TEST ENABLE GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      使能:1-CPU读写RAM  0-逻辑读写RAM
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_ram_test_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN *en);

/***********************************************************/
/** TRPG RX INT&EXT PORT PKT NUMBER GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   pktNum  端口接收包个数指针（指向64bit空间）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_pkt_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT64 *pktNum);

/***********************************************************/
/** TRPG RX INT&EXT PORT PKT BYTE NUMBER GET
* @param   dev_id      设备号 
* @param   portNo      端口号
* @param   pktByteNum  端口接收包字节数指针（指向64bit空间）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_pkt_byte_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT64 *pktByteNum);

/***********************************************************/
/** TRPG RX INT&EXT PORT PKT CNT CLR
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_pkt_cnt_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC CLOCK FREQ SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   clkFreq 端口令牌桶流控工作频率所需的系统clk数（令牌桶流控需要0.1us周期的工作频率，假设芯片的基频为1Ghz,那么令牌桶需要100个clk）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_token_bucket_fc_clk_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 clkFreq);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC CLOCK FREQ GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   clkFreq 端口令牌桶流控工作频率所需的系统clk数（令牌桶流控需要0.1us周期的工作频率，假设芯片的基频为1Ghz,那么令牌桶需要100个clk）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_token_bucket_fc_clk_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 *clkFreq);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC ENABLE SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      端口令牌桶流控使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_token_bucket_fc_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN en);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC ENABLE GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      端口令牌桶流控使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_token_bucket_fc_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN *en);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC ADD NUM SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   addNum  端口令牌桶流控单位时间令牌添加数量(每0.1us添加的令牌数（字节数）粒度：0.08G)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_token_bucket_fc_add_num_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, DPP_TRPG_TOKEN_FC_MODE addNum);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC ADD NUM GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   addNum  端口令牌桶流控单位时间令牌添加数量(每0.1us添加的令牌数（字节数）粒度：0.08G)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_token_bucket_fc_add_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, DPP_TRPG_TOKEN_FC_MODE *addNum);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC MAX NUM SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   maxNum  端口令牌桶流控令牌桶的深度
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_token_bucket_fc_max_num_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 maxNum);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC MAX NUM GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   maxNum  端口令牌桶流控令牌桶的深度
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_token_bucket_fc_max_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 *maxNum);

/***********************************************************/
/** TRPG RX INT&EXT PORT DATA RAM GET
* @param   dev_id      设备号 
* @param   portRamNo   端口RAM号
* @param   word_num    字号(需要 96行*每行2048bit/每次读32bit=6144次 可以将data_buffer全读出)
* @param   dataBuf     数据指针
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_data_ram_get(ZXIC_UINT32 dev_id, DPP_TRPG_PORT_RAM_NUM portRamNo, ZXIC_UINT32 word_num, ZXIC_UINT32* dataBuf);

/***********************************************************/
/** TRPG RX INT&EXT PORT INFO RAM GET
* @param   dev_id      设备号 
* @param   portRamNo   端口RAM号
* @param   word_num    字号(需要 96行*每行（136bit有效，拓展到256bit）,每次读32bit,读480次 可以将data_buffer全读出,(第4，第9.....字中，第一个字节有效)
* @param   infobuf     数据指针
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_rx_port_info_ram_get(ZXIC_UINT32 dev_id, DPP_TRPG_PORT_RAM_NUM portRamNo, ZXIC_UINT32 word_num, ZXIC_UINT32* infoBuf);

/***********************************************************/
/** TRPG TX INT&EXT PORT RAM ALMOST FULL LEVEL SET
* @param   dev_id   设备号 
* @param   portNo   端口号
* @param   level    将满水位(单位：256 Byte)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_ram_almost_full_level_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 level);

/***********************************************************/
/** TRPG TX INT&EXT PORT RAM ALMOST FULL LEVEL GET
* @param   dev_id   设备号 
* @param   portNo   端口号
* @param   level    将满水位(单位：256 Byte)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_ram_almost_full_level_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 *level);

/***********************************************************/
/** TRPG TX INT&EXT PORT RAM TEST ENABLE SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      使能:1-CPU读写RAM  0-逻辑读写RAM
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_ram_test_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN en);

/***********************************************************/
/** TRPG TX INT&EXT PORT RAM TEST ENABLE GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      使能:1-CPU读写RAM  0-逻辑读写RAM
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_ram_test_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN *en);

/***********************************************************/
/** TRPG TX INT&EXT PORT PKT NUMBER GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   pktNum  端口接收包个数指针（指向64bit空间）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_pkt_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT64 *pktNum);

/***********************************************************/
/** TRPG TX INT&EXT PORT PKT BYTE NUMBER GET
* @param   dev_id      设备号 
* @param   portNo      端口号
* @param   pktByteNum  端口接收包字节数指针（指向64bit空间）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_pkt_byte_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT64 *pktByteNum);

/***********************************************************/
/** TRPG TX INT&EXT PORT PKT CNT CLR
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_pkt_cnt_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC CLOCK FREQ SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   clkFreq 端口令牌桶流控工作频率所需的系统clk数（令牌桶流控需要0.1us周期的工作频率，假设芯片的基频为1Ghz,那么令牌桶需要100个clk）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_token_bucket_fc_clk_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 clkFreq);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC CLOCK FREQ GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   clkFreq 端口令牌桶流控工作频率所需的系统clk数（令牌桶流控需要0.1us周期的工作频率，假设芯片的基频为1Ghz,那么令牌桶需要100个clk）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_token_bucket_fc_clk_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 *clkFreq);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC ENABLE SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      端口令牌桶流控使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_token_bucket_fc_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN en);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC ENABLE GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   en      端口令牌桶流控使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_token_bucket_fc_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, BOOLEAN *en);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC ADD NUM SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   addNum  端口令牌桶流控单位时间令牌添加数量(每0.1us增加的令牌数（字节数）粒度：0.08G)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_token_bucket_fc_add_num_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, DPP_TRPG_TOKEN_FC_MODE addNum);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC ADD NUM GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   addNum  端口令牌桶流控单位时间令牌添加数量(每0.1us增加的令牌数（字节数）粒度：0.08G)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_token_bucket_fc_add_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, DPP_TRPG_TOKEN_FC_MODE *addNum);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC MAX NUM SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   maxNum  端口令牌桶流控令牌桶的深度
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_token_bucket_fc_max_num_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 maxNum);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC MAX NUM GET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   maxNum  端口令牌桶流控令牌桶的深度
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_token_bucket_fc_max_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 *maxNum);

/***********************************************************/
/** TRPG TX INT&EXT PORT DATA RAM GET
* @param   dev_id      设备号 
* @param   portRamNo   端口RAM号
* @param   word_num    字号(需要 144行*每行2048bit/每次读32bit=9216次 可以将data_buffer全读出)
* @param   dataBuf     数据指针
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_data_ram_get(ZXIC_UINT32 dev_id, DPP_TRPG_PORT_RAM_NUM portRamNo, ZXIC_UINT32 word_num, ZXIC_UINT32* dataBuf);

/***********************************************************/
/** TRPG TX INT&EXT PORT INFO RAM GET
* @param   dev_id      设备号 
* @param   portRamNo   端口RAM号
* @param   word_num    字号(需要 144行*每行(72bit有效，拓展到128bit)，每次读32bit，需要432次 可以将data_buffer全读出, （第2，第6.....字中，第一个字节有效)
* @param   infobuf     数据指针
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_port_info_ram_get(ZXIC_UINT32 dev_id, DPP_TRPG_PORT_RAM_NUM portRamNo, ZXIC_UINT32 word_num, ZXIC_UINT32* infoBuf);

/***********************************************************/
/** TRPG TX ETM PORT RAM ALMOST FULL LEVEL SET
* @param   dev_id   设备号 
* @param   level    将满水位(单位：256 Byte)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_etm_port_ram_almost_full_level_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 level);

/***********************************************************/
/** TRPG TX ETM PORT RAM ALMOST FULL LEVEL GET
* @param   dev_id   设备号 
* @param   level    将满水位(单位：256 Byte)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_etm_port_ram_almost_full_level_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *level);

/***********************************************************/
/** TRPG TX ETM PORT RAM TEST ENABLE SET
* @param   dev_id  设备号 
* @param   en      使能:1-CPU读写RAM  0-逻辑读写RAM
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_etm_port_ram_test_en_set(ZXIC_UINT32 dev_id, BOOLEAN en);

/***********************************************************/
/** TRPG TX ETM PORT RAM TEST ENABLE GET
* @param   dev_id  设备号 
* @param   en      使能:1-CPU读写RAM  0-逻辑读写RAM
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_etm_port_ram_test_en_get(ZXIC_UINT32 dev_id, BOOLEAN *en);

/***********************************************************/
/** TRPG TX ETM PORT DATA RAM GET
* @param   dev_id      设备号 
* @param   word_num    字号(需要 32行*每行2048bit/每次读32bit=2048次 可以将data_buffer全读出)
* @param   dataBuf     数据指针
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_etm_port_data_ram_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 word_num, ZXIC_UINT32* dataBuf);

/***********************************************************/
/** TRPG TX ETM PORT INFO RAM GET
* @param   dev_id      设备号 
* @param   word_num    字号(需要 32行*每行(72bit有效，拓展到128bit)，每次读32bit，读96次可以将data_buffer全读出, 第2，第6.....字中，第一个字节有效)
* @param   infobuf     数据指针
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_etm_port_info_ram_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 word_num, ZXIC_UINT32* infoBuf);

/***********************************************************/
/** TRPG TX GLB TOD TIME UPDATE INTERRUPTION GET
* @param   dev_id     设备号 
* @param   interrput  中断状态
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_glb_tod_update_interrupt_get(ZXIC_UINT32 dev_id, BOOLEAN* interrput);

/***********************************************************/
/** TRPG TX GLB TOD TIME UPDATE INTERRUPTION MASK SET
* @param   dev_id  设备号 
* @param   mask    中断掩断
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_glb_tod_update_interrupt_mask_set(ZXIC_UINT32 dev_id, BOOLEAN mask);

/***********************************************************/
/** TRPG TX GLB TOD TIME UPDATE INTERRUPTION MASK GET
* @param   dev_id  设备号 
* @param   mask    中断掩断
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_glb_tod_update_interrupt_mask_get(ZXIC_UINT32 dev_id, BOOLEAN *mask);

/***********************************************************/
/** TRPG TX GLB TOD TIME UPDATE INTERRUPTION CLEAR
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_glb_tod_update_interrupt_clr(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG TX GLB TOD TIME RAM TEST ENABLE SET
* @param   dev_id  设备号 
* @param   en      使能:1-CPU读写RAM  0-逻辑读写RAM
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_glb_tod_ram_test_en_set(ZXIC_UINT32 dev_id, BOOLEAN en);

/***********************************************************/
/** TRPG TX GLB TOD TIME RAM TEST ENABLE GET
* @param   dev_id  设备号 
* @param   en      使能:1-CPU读写RAM  0-逻辑读写RAM
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_glb_tod_ram_test_en_get(ZXIC_UINT32 dev_id, BOOLEAN *en);

/***********************************************************/
/** TRPG TX GLB TOD TIME GET
* @param   dev_id        设备号 
* @param   ioamFlowId    时间戳报文flow id
* @param   tod_time      TOD时间戳指针（64bit）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_glb_tod_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 ioamFlowId, ZXIC_UINT64 *todTime);

/***********************************************************/
/** TRPG TX GLB TOD TIME CLEAR
* @param   dev_id        设备号 
* @param   ioamFlowId    时间戳报文flow id
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_tx_glb_tod_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 ioamFlowId);

/***********************************************************/
/** TRPG PORT NUM TURN INTO RAM NUM
* @param   dev_id        设备号 
* @param   portNum       端口号
* @param   ramNum        RAM号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_port_num2ram_num(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 *ramNo);

/***********************************************************/
/** TRPG PORT MODE GET
* @param   dev_id        设备号 
* @param   portNum       端口号
* @param   ramNum        RAM号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_port_mode_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 *mode);

#endif

#endif /* dpp_trpg_api.h */
