/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_debugger.h
* ļʶ : 
* ժҪ:
* ˵:
* ǰ汾 : 
*      : 
*  : 2014/02/08
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT   : 100% 

* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef _DEBUGGER_H_
#define _DEBUGGER_H_

#include "dpp_dbg_reg_mmap.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "dpp_parsemsg.h"


#define DPP_DEBUGER_FUNC_ENTER                  (0)
#define DPP_DEBUGER_FUNC_EXIT                   (1)

#define DPP_DEBUGER_REAL_CHIP                   (0)
#define DPP_DEBUGER_SIMULATOR                   (1)


/* Trap0 Inst ָλ48bit */
#define DPP_TRAP0_INST_HI32    (0x000002600)    /* 001001100000 */
#define DPP_TRAP0_INST_LO32    (0x03FCC0A4)    /* 00000011111111001100000010100100 */

#define ME_BP_ADDR_STEP        (4)
#define DPP_PPU_INTR_NONE      (0)      /* PPUľж */
#define DPP_PPU_INTR_MAX       (0x3F)  
#define DPP_ME_INTR_NONE       (0)      /* һclusterMEж */
#define DPP_ME_INTR_MAX        (0xFF) 

#define DPP_GET_PKT_VLD_CNT    (100) /* ſյʱΪ5 */
#define DPP_GET_PKT_VLD_WAIT   (50)  /* 50ms */

#define DPP_REG_READ_MAX_NUM   (256)

#define DPP_GET_INTR_COUNT     (50)

#define DPP_DOU_LINK_MAX       (1000)


#ifdef DPP_OS_WIN32
#define DPP_GET_INTR_DELAY     (50) /* 50ms, ȴʱ䲻ܹsocketᳬʱ */
#else
#define DPP_GET_INTR_DELAY     (10) /* 10ms */
#endif

/*̬ϵ洢ṹ*/
typedef struct pc_instr{
    ZXIC_UINT32 pc_addr;                 /*pc addr ϵַ*/
    ZXIC_UINT32 instr_hig32;             /*סָ32λ*/
    ZXIC_UINT32 instr_low32;             /*סָ32λ*/
}PC_INSTR;

typedef struct dpp_dbg_mgr_t
{
    ZXIC_UINT32 is_start_dbg;
    ZXIC_UINT32 dev_id;
    ZXIC_UINT32 cluster_id;
    ZXIC_UINT32 me_id;
    ZXIC_RB_CFG *p_softbp_rbs[DPP_DEV_CHANNEL_MAX];
    D_HEAD     *p_head[DPP_DEV_CHANNEL_MAX];
}DPP_DBG_MGR_T;

/* API */
ZXIC_UINT32 dpp_dbg_debugger_server_run(ZXIC_UINT8 *p_recv_msg, ZXIC_UINT8 *p_send_msg, ZXIC_UINT32* p_send_flag);
ZXIC_UINT32 dpp_dbg_debug_start(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_pkt_empty);
ZXIC_UINT32 dpp_dbg_debug_stop(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 me_id);
/***********************************************************/
/** ԣȡжϡڲʹãṩ
* @param   dev_id   
* @param   p_me_id   
* @param   p_bp_addr   
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author        @date  2015/04/30
************************************************************/
DPP_STATUS dpp_dbg_interrupt_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_cluster_id, ZXIC_UINT32 *p_me_id, ZXIC_UINT32 *p_bp_addr);

/***********************************************************/
/** debugģʽִ,ڲʹãṩ
* @param   dev_id   
* @param   cluster_id   
* @param   me_id   
*
* @return  
* @remark  
* @see     
* @author        @date  2014/03/04
************************************************************/
ZXIC_UINT32 dpp_dbg_continue_execute(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 me_id);

/***********************************************************/
/** ͷŶ̬ϵ㼰ռõĿռ
* @param   dev_id   
*
* @return  
* @remark  
* @see     
* @author        @date  2014/08/08
************************************************************/
DPP_STATUS dpp_dbg_dynamic_bp_release(ZXIC_UINT32 dev_id);


/***********************************************************/
/** ʹ,ʼŰ
* @param   dev_id  豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  lfq      @date  2015/04/30
************************************************************/
DPP_STATUS dpp_dbg_download_start(ZXIC_UINT32 dev_id, ZXIC_UINT32 *dbg_status);

/***********************************************************/
/** ʹ,ʼŰ
* @param   dev_id  豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  lfq      @date  2015/04/30
************************************************************/
DPP_STATUS dpp_dbg_download_stop(ZXIC_UINT32 dev_id);

ZXIC_UINT32 dpp_dbg_step_into(ZXIC_UINT32 dev_id,ZXIC_UINT32 cluster_id,ZXIC_UINT32 me_id);
ZXIC_UINT32 dpp_dbg_step_over(ZXIC_UINT32 dev_id,ZXIC_UINT32 cluster_id,ZXIC_UINT32 me_id);
ZXIC_UINT32 dpp_dbg_break_point_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pc_addr);
ZXIC_UINT32 dpp_dbg_break_point_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 pc_addr);
ZXIC_UINT32 dpp_dbg_break_point_clr_all(ZXIC_UINT32 dev_id);
ZXIC_SINT32 dpp_softdbg_bp_pc_addr_cmp(ZXIC_VOID *p_new, ZXIC_VOID *p_old, ZXIC_UINT32 key_size);
ZXIC_UINT32 dpp_dbg_soft_bp_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pc_addr);
ZXIC_UINT32 dpp_dbg_soft_bp_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 pc_addr);
ZXIC_UINT32 dpp_dbg_pc_addr_get(ZXIC_UINT32 dev_id, INTR_PC_INFO_T *p_instr_pc_info);
ZXIC_UINT32 dpp_dbg_bp_real_instr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 pc_addr);
ZXIC_UINT32 dpp_dbg_intr_parser(ZXIC_UINT32 dev_id, INTR_PC_INFO_T *p_intr_info, ZXIC_UINT32 *p_intr_cpuid, ZXIC_UINT32 *p_intr_meid);

ZXIC_VOID dpp_dbg_dev_bp_set(ZXIC_UINT32 dev_id, D_HEAD *ptr);
D_HEAD * dpp_dbg_mgr_dev_bp_get(ZXIC_UINT32 dev_id);
ZXIC_VOID dpp_dbg_mgr_softbp_rbs_set(ZXIC_UINT32 dev_id, ZXIC_RB_CFG *ptr);
ZXIC_RB_CFG *dpp_dbg_mgr_dev_softbp_rb_get(ZXIC_UINT32 dev_id);
ZXIC_UINT32 dpp_dbg_mgr_start_get(ZXIC_VOID);
ZXIC_VOID dpp_dbg_dbg_mgr_start_set(ZXIC_UINT32 val);
ZXIC_UINT32 dpp_dbg_mgr_cur_devid_get(ZXIC_VOID);
ZXIC_UINT32 dpp_dbg_mgr_cur_clsid_get(ZXIC_VOID);
ZXIC_UINT32 dpp_dbg_mgr_cur_meid_get(ZXIC_VOID);
ZXIC_VOID dbg_mgr_cur_info_set(ZXIC_UINT32 dev_id,ZXIC_UINT32 cls_id,ZXIC_UINT32 meid);
ZXIC_UINT32 dpp_dbg_init_single(ZXIC_UINT32 dev_id);
ZXIC_UINT32 dpp_dbg_reg_write(ZXIC_UINT32 dev_id,
                         ZXIC_UINT32 cluster_id,
                         DPP_DBG_REG_TYPE_E reg_type,
                         ZXIC_UINT32 *p_reg_value);



#ifdef __cplusplus
}
#endif

#endif



