/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_etcam.h
* ļʶ : 
* ժҪ : 
* ˵ : 
* ǰ汾 : 
*      : 
*  : 2014/04/03
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef _DPP_ETCAM_H_
#define _DPP_ETCAM_H_

#ifdef __cplusplus
extern "C"{
#endif

#define DPP_ETCAM_BLOCK_NUM           (8)   /* eTcamBlockĿ 16:dpp+etcam block Ŀ */
#define DPP_ETCAM_TBLID_NUM           (8)    /* eTcamֵ֧ҵ */
#define DPP_ETCAM_RAM_NUM             (8)    /* BlockڲRAMĸ */
#define DPP_ETCAM_RAM_WIDTH           (80U)   /* BlockڲRAMĿȣΪλ */

#ifdef DPP_FPGA_TEST_BAORD_SA500FT
#define DPP_ETCAM_RAM_DEPTH           (16U)   /* BlockڲRAM */
#else
#define DPP_ETCAM_RAM_DEPTH           (512U)  /* BlockڲRAM */
#endif

#define DPP_ETCAM_WR_MASK_MAX         (((ZXIC_UINT32)1<<DPP_ETCAM_RAM_NUM)-1)/*255*/
#define DPP_ETCAM_WIDTH_MIN           (DPP_ETCAM_RAM_WIDTH)                     /* eTcamСλΪλ */
#define DPP_ETCAM_WIDTH_MAX           (DPP_ETCAM_RAM_NUM * DPP_ETCAM_RAM_WIDTH) /* eTcamλΪλ */

#define DPP_ETCAM_DEFAULT_MIN         (0)
#define DPP_ETCAM_ONE_BIT_MAX         (1)

#define DPP_ETCAM_PORT_NUM            (1)

typedef enum dpp_etcam_data_type_e
{
    DPP_ETCAM_DTYPE_MASK = 0,
    DPP_ETCAM_DTYPE_DATA = 1,
}DPP_ETCAM_DATA_TYPE_E;

/** etcam ĿvldϢ  */
typedef struct dpp_etcam_entry_vld_t
{
    ZXIC_UINT8 vld;           /** <@brief ʾÿĿʹ״̬ÿbitΪָʾǰĿǷռ */
    ZXIC_UINT8 rsv[3];        /** <@brief ݶ룬 */
}DPP_ETCAM_ENTRY_VLD_T;

/* error code */
#define DPP_STAT_ETCAM_RC_BASE         (0x6000)
#define DPP_ETCAM_RC_INVALID_PARA      (DPP_STAT_ETCAM_RC_BASE | 0x0)

/* macro function */
#define DPP_ETCAM_ENTRY_SIZE_GET(entry_mode) \
    (((ZXIC_UINT32)DPP_ETCAM_RAM_WIDTH << (3 - entry_mode)) / 8)

/* api */
DPP_STATUS dpp_etcam_dm_to_xy(DPP_ETCAM_ENTRY_T *p_dm, DPP_ETCAM_ENTRY_T *p_xy, ZXIC_UINT32 len);

DPP_STATUS dpp_etcam_xy_to_dm(DPP_ETCAM_ENTRY_T *p_dm, DPP_ETCAM_ENTRY_T *p_xy, ZXIC_UINT32 len);

DPP_STATUS dpp_etcam_block_tbl_id_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 block_idx, ZXIC_UINT32 tbl_id);

DPP_STATUS dpp_etcam_block_tbl_id_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 block_idx, ZXIC_UINT32 *p_tbl_id);

DPP_STATUS dpp_etcam_block_baddr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 block_idx, ZXIC_UINT32 base_addr);

DPP_STATUS dpp_etcam_block_baddr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 block_idx, ZXIC_UINT32 *p_base_addr);

DPP_STATUS dpp_etcam_table_block_id_get(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 table_id,
                                        ZXIC_UINT32* p_block_num,
                                        ZXIC_UINT32* p_block_list);

DPP_STATUS dpp_etcam_cpu_afull_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 block_idx, ZXIC_UINT32 *p_cpu_afull);

DPP_STATUS dpp_etcam_ind_cmd_set(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 addr,
                                 ZXIC_UINT32 block_idx,
                                 ZXIC_UINT32 data_or_mask,
                                 ZXIC_UINT32 wr_mask,
                                 ZXIC_UINT32 opr_type,
                                 ZXIC_UINT32 tacm_reg_flag,
                                 ZXIC_UINT32 row_mask_flag,
                                 ZXIC_UINT32 vben,
                                 ZXIC_UINT32 vbit);

DPP_STATUS dpp_etcam_ind_data_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 rd_mode, ZXIC_UINT8 *p_data);

DPP_STATUS dpp_etcam_block_from_tbl(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 table_id,
                                    ZXIC_UINT32 table_index,
                                    ZXIC_UINT32 mode,
                                    ZXIC_UINT32 *p_block_id,
                                    ZXIC_UINT32 *p_block_index);

DPP_STATUS dpp_etcam_entry_print(ZXIC_UINT32 dev_id, 
                                 ZXIC_UINT32 block_idx,
                                 ZXIC_UINT32 index,
                                 ZXIC_UINT32 mode,
                                 ZXIC_UINT32 opr_type);

ZXIC_UINT32 dpp_etcam_entry_cmp(DPP_ETCAM_ENTRY_T *p_entry_dm, DPP_ETCAM_ENTRY_T *p_entry_xy);

ZXIC_UINT32 dpp_etcam_ind_data_reg_opr_mask_get(ZXIC_UINT32 mask);

DPP_STATUS dpp_etcam_glb_size_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_size);

DPP_STATUS dpp_etcam_cpu_reset_get(ZXIC_UINT32 dev_id,
                                   ZXIC_UINT32* p_flag,
                                   ZXIC_UINT32* p_size,
                                   ZXIC_UINT8** pp_buff);

DPP_STATUS dpp_etcam_cpu_reset_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 size, ZXIC_UINT8* p_buff);

#if ZXIC_REAL("Լ")

typedef struct dpp_etcam_port_cnt
{
    ZXIC_UINT32 as_etcam_req_cnt;
    ZXIC_UINT32 etcam_as_index_cnt;
    ZXIC_UINT32 etcam_not_hit_cnt;
}DPP_ETCAM_PORT_CNT_T;

typedef struct dpp_etcam_dbg_cnt
{
    DPP_ETCAM_PORT_CNT_T dpp_etcam_port_cnt[DPP_ETCAM_PORT_NUM];
    ZXIC_UINT32 table_id_not_match_cnt;
    ZXIC_UINT32 table_id_clash01_cnt;
}DPP_ETCAM_DBG_CNT_T;

/* etcam_dbg_cnt */
DPP_STATUS dpp_etcam_dbg_cnt_get(ZXIC_UINT32 dev_id, DPP_ETCAM_DBG_CNT_T * p_dpp_etcam_dbg_cnt);

DPP_STATUS dpp_etcam_dbg_cnt_clr(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_etcam_dbg_cnt_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cnt_rd_mode, ZXIC_UINT32 cnt_overflow_mode);

DPP_STATUS dpp_etcam_int_tb_ini_ok_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_int_tb_ini_ok);

/***********************************************************/
/** etcamʱʹ
* @param   dev_id         豸
* @param   etcam_clk_en   etcamʹλ1-ʹܣ0-δʹ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2015/04/23
************************************************************/
DPP_STATUS dpp_etcam_etcam_clk_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 etcam_clk_en);

DPP_STATUS dpp_etcam_etcam_clk_en_get(ZXIC_UINT32  dev_id, ZXIC_UINT32 *p_etcam_clk_en);

DPP_STATUS dpp_etcam_dbg_cnt_print(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ȡeTcamblockڵӲĿ
* @param   dev_id      豸
* @param   block_idx   blockΧ0~7
* @param   index       ҵĿڵǰblockе
* @param   mode        ֵλģʽȡֵDPP_ETCAM_ENTRY_MODE_EĶ
* @param   opr_type    ȡͣȡֵDPP_ETCAM_OPR_TYPE_EĶ
* @param   p_entry_out ضȡıĿ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/09/14
************************************************************/
DPP_STATUS dpp_etcam_entry_get_ex(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 block_idx,
                                  ZXIC_UINT32 index,
                                  ZXIC_UINT32 mode,
                                  ZXIC_UINT32 opr_type,
                                  DPP_ETCAM_ENTRY_T *p_entry_out);

/***********************************************************/
/** eTcamĿ
* @param   dev_id     豸
* @param   addr       ÿblockеramַλΪ8*80bit
* @param   block_idx  blockţΧ0~15
* @param   wr_mask    д룬8bitÿbitramжӦλõ80bitǷЧ
* @param   p_entry    Ŀݣdatamask
*
* @return
* @remark  
* @see
* @author  wcl      @date  2014/04/03
************************************************************/
DPP_STATUS dpp_etcam_entry_add(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 addr,
                               ZXIC_UINT32 block_idx,
                               ZXIC_UINT32 wr_mask,
                               ZXIC_UINT32 opr_type,
                               DPP_ETCAM_ENTRY_T *p_entry);

/***********************************************************/
/** ɾeTcamĿ
* @param   dev_id     豸
* @param   addr       ÿblockеramַλΪ8*80bit
* @param   block_idx  blockıţΧ0~15
* @param   wr_mask    д룬8bitÿbitramжӦλõ80bitǷЧ
*
* @return
* @remark  
* @see
* @author  wcl      @date  2014/04/03
************************************************************/
DPP_STATUS dpp_etcam_entry_del(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 addr,
                               ZXIC_UINT32 block_idx,
                               ZXIC_UINT32 wr_mask);

/***********************************************************/
/** eTcamĿ
* @param   dev_id     豸
* @param   addr       blockRAMַΧ0~511
* @param   block_idx  blockΧ0~7
* @param   rd_mode    block RAMеλͼ8bitÿһRAM80bit
* @param   opr_type   ȡͣȡֵDPP_ETCAM_OPR_TYPE_EĶ
* @param   p_entry    ȡentry
*
* @return
* @remark  
* @see
* @author  wcl      @date  2014/04/03
************************************************************/
DPP_STATUS dpp_etcam_entry_get(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 addr,
                               ZXIC_UINT32 block_idx,
                               ZXIC_UINT32 rd_mode,
                               ZXIC_UINT32 opr_type,
                               DPP_ETCAM_ENTRY_T *p_entry);

/***********************************************************/
/** eTcamramΪ0
* @param   dev_id 豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/08/04
************************************************************/
DPP_STATUS dpp_etcam_ram_clear(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡeTcamblockڵӲĿ
* @param   dev_id     豸
* @param   block_idx  blockΧ0~15
* @param   index      ҵĿڵǰblockе
* @param   mode       ֵλģʽȡֵDPP_ETCAM_ENTRY_MODE_EĶ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  YXH      @date  2020/03/24
************************************************************/
DPP_STATUS dpp_etcam_entry_vbit_print(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 block_idx,
                                      ZXIC_UINT32 index,
                                      ZXIC_UINT32 mode);

DPP_STATUS dpp_etcam_ind_rd_done_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_rd_done);
DPP_STATUS dpp_etcam_rd_done_status_check(ZXIC_UINT32 dev_id);


#endif
#ifdef __cplusplus
}
#endif


#endif


