/**************************************************************
* 版权所�? (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_se.h
* 文件标识 : 
* 内容摘要 : 
* 其它说明 : 
* 当前版本 : 
* �?    �? : 王春�?
* 完成日期 : 2014/03/11
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* 修改记录1: 
* 修改日期:  
* �? �? �?:  
* �? �? �?:  
* 修改内容:  
***************************************************************/

#ifndef _DPP_SE_H_
#define _DPP_SE_H_


#ifdef __cplusplus
extern "C"{
#endif


#include "dpp_se_api.h"
#include "dpp_se_reg.h"
#include "dpp_stat_reg.h"

#define DPP_HASH_ID_MIN         (0)
#define DPP_HASH_ID_MAX         (3)
#define DPP_HASH_ID_NUM         (4)

#define HASH_FUNC0              (0)
#define HASH_FUNC1              (1)
#define HASH_FUNC2              (2)
#define HASH_FUNC3              (3)

/* 抓包使能 */
#define SDT_CLUTH_DISABLE       (0)
#define SDT_CLUTH_ENABLE        (1)

#define HASH_BULK_ID_MIN        (0)
#define HASH_BULK_ID_MAX        (7)
#define HASH_BULK_NUM           (8)    /* 每个Hash引擎存储资源划分的块�? */

#define CRC_POLY_SEL_MIN        (0)
#define CRC_POLY_SEL_MAX        (3)

#define DPP_LPM_ID_MIN          (4)
#define DPP_LPM_ID_MAX          (5)
#define DPP_LPM_ID_NUM          (2)

#define DPP_ETCAM_ID_MIN        (0)
#define DPP_ETCAM_ID_MAX        (0)
#define DPP_ETCAM_ID_NUM        (1)

#define DPP_AGE_TBL_ID_MIN      (0)
#define DPP_AGE_TBL_ID_MAX      (15)

#define DPP_SMMU1_DDR_GRP_NUM               (1)

//#define DPP_SMMU1_DIR_TBL_BANK_MAX          (15)
#define DPP_SMMU1_DIR_TBL_INDEX_MAX         (255)
//#define DPP_SMMU1_UN_DIR_TBL_BANK_MAX       (29)

#define DPP_SMMU1_HASH_TBL_INDEX_BASE       (1)
#define DPP_SMMU1_HASH_TBL_INDEX_MAX        (31)
#define DPP_SMMU1_LPM_TBL_INDEX_BASE        (33)
#define DPP_SMMU1_LPM_TBL_INDEX_MAX         (3)
#define DPP_SMMU1_OAM_TBL_INDEX_BASE        (37)
#define DPP_SMMU1_FTM_TBL_INDEX_BASE        (38)
#define DPP_SMMU1_ETM_TBL_INDEX_BASE        (39)
#define DPP_SMMU1_DIR_TBL_INDEX_BASE        (40)


#define DPP_SMMU1_SINGLE_BNAK_MAX_ADDR      ((1<<25) - 1)
#define DPP_SMMU1_SINGLE_BANK_MAX_BADDR     (DPP_SMMU1_SINGLE_BNAK_MAX_ADDR >> 12)
#define DPP_SMMU1_TOTAL_BANK_NUM            (8)
#define DPP_SMMU1_TOTAL_MAX_ADDR            (0xffffffff)
#define DPP_SMMU1_TOTAL_MAX_BADDR           (DPP_SMMU1_TOTAL_MAX_ADDR >> 12)
#define DPP_SMMU1_BADDR_MASK                (0x7ffff800)
#define DPP_SMMU1_DDR_GROUP_NUM             (1)
#define DPP_SMMU1_BANK_COPY_MAX_NUM         (16)
#define DPP_SMMU1_READ_REG_MAX_NUM          (16)
#define DPP_DIR_TBL_BUF_MAX_NUM             (DPP_SMMU1_READ_REG_MAX_NUM)

/*hash ext crc cfg*/
#define HASH_ECC_EN_BT_START          (2)
#define HASH_ECC_EN_BT_WIDTH          (1)
#define HASH_BANK_COPY_BT_START       (3)
#define HASH_BANK_COPY_BT_WIDTH       (3)
#define HASH_BASE_ADDR_BT_START       (6)
#define HASH_BASE_ADDR_BT_WIDTH       (15)
/*hash learn  tbl cfg*/
#define LEARN_HASH_TBL_BT_START       (0)
#define LEARN_HASH_TBL_BT_WIDTH       (19)

#define DPP_SMMU0_MCAST_TBL_MAX_GROUP       (0xffff)

#define DPP_SMMU0_CAR0_MONO_POS             (0)
#define DPP_SMMU0_CAR0_MONO_LEN             (1)
#define DPP_SMMU0_CAR0_EN_POS               (1)
#define DPP_SMMU0_CAR0_EN_LEN               (1)
#define DPP_SMMU0_CAR1_MONO_POS             (2)
#define DPP_SMMU0_CAR1_MONO_LEN             (1)
#define DPP_SMMU0_CAR1_EN_POS               (3)
#define DPP_SMMU0_CAR1_EN_LEN               (1)

#define DPP_SMMU0_LPM_AS_TBL_ID_MAX         (7)
#define DPP_SMMU0_LPM_AS_TBL_ID_NUM         (8)

#define DPP_SMMU0_MCAST_DATA_VLD_POS        (16)
#define DPP_SMMU0_MCAST_DATA_VLD_LEN        (1)
#define DPP_SMMU0_MCAST_CNT_POS             (0)
#define DPP_SMMU0_MCAST_CNT_LEN             (16)

#define DPP_SMMU0_INDIER_RDWR_OFFSET_NUM    (4)
#define DPP_SMMU0_READ_REG_MAX_NUM          (4)

/**  SMMU0 调度 fifo ecc 使能标志 */
#define DPP_SMMU0_PPU_FIFO_POS               (12)
#define DPP_SMMU0_PPU_FIFO_LEN               (8)
#define DPP_SMMU0_STAT_FIFO_POS              (11)
#define DPP_SMMU0_STAT_FIFO_LEN              (1)
#define DPP_SMMU0_DMA_FIFO_POS               (10)
#define DPP_SMMU0_DMA_FIFO_LEN               (1)
#define DPP_SMMU0_ODMA_FIFO_POS              (6)
#define DPP_SMMU0_ODMA_FIFO_LEN              (4)
#define DPP_SMMU0_MCAST_FIFO_POS             (5)
#define DPP_SMMU0_MCAST_FIFO_LEN             (1)
#define DPP_SMMU0_ETCAM_FIFO_POS             (1)
#define DPP_SMMU0_ETCAM_FIFO_LEN             (4)
#define DPP_SMMU0_LPM_FIFO_POS               (0)
#define DPP_SMMU0_LPM_FIFO_LEN               (1)

#define DPP_SMMU0_CTRL_ECC_CFG_POS           (0)
#define DPP_SMMU0_CTRL_ECC_CFG_LEN           (3)

#define DPP_SMMU0_RSCHD_RAM_POS              (0)
#define DPP_SMMU0_RSCHD_RAM_LEN              (1)

#define DPP_SMMU0_ERAM_ECC_CFG_POS           (0)
#define DPP_SMMU0_ERAM_ECC_CFG_LEN           (24)

#define DPP_SMMU0_WR_ARB_ECC_CFG_POS         (0)
#define DPP_SMMU0_WR_ARB_ECC_CFG_LEN         (1)

/* smmu0 int0 reg bit define */
#define SMMU0_INT0_DMA_ORDFIFO_START        (0)
#define SMMU0_INT0_DMA_ORDFIFO_LEN          (1)
#define SMMU0_INT0_ODMA_ORDFIFO_START       (1)
#define SMMU0_INT0_ODMA_ORDFIFO_LEN         (1)
#define SMMU0_INT0_MCAST_ORDFIFO_START      (2)
#define SMMU0_INT0_MCAST_ORDFIFO_LEN        (1)

#define DPP_ERAM128_BADDR_MASK              (0x3FFFF80)/* modified for dpp+ 25bit 2018-09-27*/

#define DPP_SE_SMMU1_MAX_BADDR_NO_SHARE     ((1<<20)-1)
#define DPP_SE_SMMU1_MAX_BADDR_SHARE        ((1<<13)-1)
#define DPP_SE_SMMU1_MAX_ADDR               ((1<<30)-1)
#define DPP_SE_SMMU1_MIN_ADDR               (DPP_DDR_BADDR_OFFSET_DEFAULT*1024)  /*0x1400000 对应1.5GB位置*/

#define DPP_SE_SMMU1_BANK_NUM_POS           (16)
#define DPP_SE_SMMU1_BANK_NUM_LEN           (5)

#define DPP_SE_SMMU1_SHARE_TYPE_POS         (21)
#define DPP_SE_SMMU1_SHARE_TYPE_LEN         (2)

#define DPP_SE_SMMU1_RR_STATE_POS           (0)
#define DPP_SE_SMMU1_RR_STATE_LEN           (15)

#define DPP_SE_CFG_PPU_INFO_POS             (0)
#define DPP_SE_CFG_PPU_INFO_LEN             (12)

#define DPP_SE_CFG_DPI_FLAG_POS             (12)
#define DPP_SE_CFG_DPI_FLAG_LEN             (1)

#define DPP_SE_CFG_WR_FLAG_POS              (13)
#define DPP_SE_CFG_WR_FLAG_LEN              (1)


/** 中断相关 */
#define DPP_SE_ALG_SCHD_INT_NUM             (14)
#define DPP_SE_ALG_ZBLK_ECC_INT_NUM         (32)
#define DPP_SE_ALG_HASH0_INT_NUM            (8)
#define DPP_SE_ALG_HASH1_INT_NUM            (8)
#define DPP_SE_ALG_HASH2_INT_NUM            (8)
#define DPP_SE_ALG_HASH3_INT_NUM            (8)
#define DPP_SE_ALG_LPM_INT_NUM              (10)

#define DPP_SMMU0_CLS_NUM                   (6)
#define DPP_SMMU0_STAT_NUM                  (16)
#define DPP_SMMU0_AS_ETCAM_NUM              (DPP_ETCAM_ID_NUM)
#define DPP_SMMU0_PLCR_NUM                  (1)
#define DPP_SMMU0_ERAM_BLOCK_NUM            (32)

#define DPP_SMMU1_SCH_CNT                   (4)/*sch 调度次数 完成6->4调度*/
//#define DPP_SMMU1_GRP_CNT                   (DPP_SMMU1_DDR_GRP_NUM)
#define DPP_SMMU1_GRP_CNT                   (8) /*与reg n_size保持一�?*/
#define DPP_SMMU1_DIR_CHANNEL_CNT           (4)

#define DPP_PARSE_MEX_CHANNEL_NUM           (6)
#define DPP_PARSE_KSCHD_CHANNEL_NUM         (6)
#define DPP_RSCHD_PPU_CHANNEL_NUM           (6)

#define LPM_UNINSTALL_DISABLE       (0)
#define LPM_UNINSTALL_ENABLE        (1)
typedef enum smmu1_stat_type_e
{
    STAT_TYPE_PPU     = 0,
    STAT_TYPE_OAM     = 1,
    STAT_TYPE_MAX,
}SMMU1_STAT_TYPE_E;

typedef enum alg_lpm_type_e
{
    ALG_LPM_V4    = 1,
    ALG_LPM_V6    = 2,
    ALG_LPM_V4_AS = 3,
    ALG_LPM_V6_AS = 4,
    ALG_LPM_MAX
}ALG_LPM_TYPE_E;

typedef enum se_ddr_bank_info_e
{
    SE_DDR_BKINFO_LPM4    = 0,
    SE_DDR_BKINFO_LPM6    = 1,
    SE_DDR_BKINFO_LPM4_AS = 2,
    SE_DDR_BKINFO_LPM6_AS = 3,
}SE_DDR_BANK_INFO_E;

typedef enum alg_zblk_serv_type_e
{
    ALG_ZBLK_SERV_LPM = 0,
    ALG_ZBLK_SERV_HASH,
}ALG_ZBLK_SERV_TYPE_E;

typedef enum cmmu_ddr3_bank_enable_e
{
    CMMU_DDR3_BANK_DISABLE = 0,
    CMMU_DDR3_BANK_ENABLE,
}CMMU_DDR3_BANK_ENABLE_E;

/** TM统计读片外位�? */
typedef enum stat_tm_rd_ddr_mode_e
{
    STAT_TM_RD_DDR_MODE_128 = 0,
    STAT_TM_RD_DDR_MODE_256 = 1,
    STAT_TM_RD_DDR_MODE_512 = 2,
    STAT_TM_RD_DDR_MODE_MAX,
}STAT_TM_RD_DDR_MODE_E;

typedef enum stat_tm_rd_clr_mode_e
{
    STAT_TM_RD_CLR_MODE_UNCLR     = 0,  /**<  @brief 正常读，读完数据不清�?   */
    STAT_TM_RD_CLR_MODE_CLR       = 1,  /**<  @brief 读清模式*/
    STAT_TM_RD_CLR_MODE_MAX,
}STAT_TM_RD_CLR_MODE_E;

typedef enum se_ddr_map_flag_e
{
    VIR_TO_PHY_FLAG       = 0,  /**<  @brief 虚拟地址/bank到物理地址/bank的映�?   */
    PHY_TO_VIR_FLAG       = 1,  /**<  @brief 物理地址/bank到虚拟地址/bank的映�?   */
}SE_DDR_MAP_FLAG_E;

/**  module se*/
typedef enum module_init_se_e
{
    MODULE_INIT_SE_SMMU0 = 0,
    MODULE_INIT_SE_SMMU1,
    MODULE_INIT_SE_ALG,
    MODULE_INIT_SE_AS,
    MODULE_INIT_SE_ETCAM,
    MODULE_INIT_SE_STAT,
    MODULE_INIT_SE_FIFO,
    MODULE_INIT_SE_MAX
} MODULE_INIT_SE_E;

typedef struct smmu1_kschd_hash_ddr_cfg_t
{
    ZXIC_UINT32 baddr;
    ZXIC_UINT32 crcen;
    ZXIC_UINT32 mode;
}SMMU1_KSCHD_HASH_DDR_CFG_T;

typedef struct smmu1_kschd_lpm_ddr_cfg_t
{
    ZXIC_UINT32 baddr;
    ZXIC_UINT32 bankcopy;
    ZXIC_UINT32 crcen;
    ZXIC_UINT32 flag;  /* 0-256, 1-384 */
    ZXIC_UINT32 as_baddr;
    ZXIC_UINT32 as_bankcopy;
    ZXIC_UINT32 as_crcen;
    ZXIC_UINT32 as_mode;
}SMMU1_KSCHD_LPM_DDR_CFG_T;

typedef struct dpp_lpm_as_eram_info_t
{
    ZXIC_UINT32 as_baddr;
    ZXIC_UINT32 as_mode;
}DPP_LPM_AS_ERAM_INFO_T;

typedef struct dpp_lpm_res_info_t
{
    DPP_LPM_AS_ERAM_INFO_T as_eram_info[DPP_SMMU0_LPM_AS_TBL_ID_NUM];
    ZXIC_UINT32 v4_ddr_baddr;
    ZXIC_UINT32 v4_as_ddr_baddr;
    ZXIC_UINT32 v4_as_rsp_len;
    ZXIC_UINT32 v6_ddr_baddr;
    ZXIC_UINT32 v6_as_ddr_baddr;
    ZXIC_UINT32 v6_as_rsp_len;
}DPP_LPM_RES_INFO_T;

/*--------------------------------------------------------调试打印计数--------------------------------------------------------*/

/*smmu0 调试打印计数 开�?*/
typedef struct dpp_smmu0_dbg_cnt_t
{
    ZXIC_UINT32 smmu0_rcv_as_age_req_cnt;
    ZXIC_UINT32 smmu0_rcv_parse_req_cnt;
    ZXIC_UINT32 smmu0_cpu_ind_rd_rsp_cnt;
    ZXIC_UINT32 smmu0_cpu_ind_rd_req_cnt;
    ZXIC_UINT32 smmu0_cpu_ind_wr_req_cnt;
    
    ZXIC_UINT32 smmu0_to_plcr_rsp_cnt[DPP_SMMU0_PLCR_NUM];
    ZXIC_UINT32 smmu0_rcv_plcr_req_cnt[DPP_SMMU0_PLCR_NUM];
    
    ZXIC_UINT32 smmu0_to_lpm_as_rsp_cnt;
    ZXIC_UINT32 smmu0_rcv_lpm_as_req_cnt;
    
    ZXIC_UINT32 smmu0_to_as_etacm_rsp_cnt[DPP_SMMU0_AS_ETCAM_NUM];/* 与fc是反�? */
    ZXIC_UINT32 smmu0_rcv_as_etacm_req_cnt[DPP_SMMU0_AS_ETCAM_NUM];

    ZXIC_UINT32 smmu0_to_ppu_mc_rsp_cnt;
    ZXIC_UINT32 smmu0_rcv_ppu_mc_req_cnt;
    ZXIC_UINT32 smmu0_to_odma_tdm_mc_rsp_cnt;
    ZXIC_UINT32 smmu0_rcv_odma_tdm_mc_req_cnt;
    ZXIC_UINT32 smmu0_to_odma_rsp_cnt;
    ZXIC_UINT32 smmu0_rcv_odma_req_cnt;
    ZXIC_UINT32 smmu0_to_dma_rsp_cnt;
    ZXIC_UINT32 smmu0_rcv_dma_req_cnt;
    
    ZXIC_UINT32 smmu0_to_stat_rsp_cnt[DPP_SMMU0_STAT_NUM];
    ZXIC_UINT32 smmu0_rcv_stat_req_cnt[DPP_SMMU0_STAT_NUM];
    ZXIC_UINT32 smmu0_to_ppu_rsp_cnt[DPP_SMMU0_CLS_NUM];
    ZXIC_UINT32 smmu0_rcv_ppu_req_cnt[DPP_SMMU0_CLS_NUM];

    ZXIC_UINT32 smmu0_rcv_ftm_stat_req0_cnt;
    ZXIC_UINT32 smmu0_rcv_ftm_stat_req1_cnt;
    ZXIC_UINT32 smmu0_rcv_etm_stat_req0_cnt;
    ZXIC_UINT32 smmu0_rcv_etm_stat_req1_cnt;

    ZXIC_UINT32 smmu0_block_rd_cnt[DPP_SMMU0_ERAM_BLOCK_NUM];
    ZXIC_UINT32 smmu0_block_wr_cnt[DPP_SMMU0_ERAM_BLOCK_NUM];

}DPP_SMMU0_DBG_CNT_T;

typedef struct dpp_smmu0_dbg_fc_cnt_t
{
    ZXIC_UINT32 smmu0_to_as_age_req_fc_cnt;
    ZXIC_UINT32 smmu0_to_parse_req_fc_cnt;
    ZXIC_UINT32 smmu0_rcv_wr_arb_cpu_fc_cnt;
    ZXIC_UINT32 smmu0_to_as_lpm_req_fc_cnt;
    ZXIC_UINT32 smmu0_rcv_as_lpm_rsp_fc_cnt;
    ZXIC_UINT32 smmu0_to_as_etacm_req_fc_cnt[DPP_SMMU0_AS_ETCAM_NUM];
    ZXIC_UINT32 smmu0_rcv_as_etacm_rsp_fc_cnt[DPP_SMMU0_AS_ETCAM_NUM];
    ZXIC_UINT32 smmu0_to_ppu_mc_req_fc_cnt;
    ZXIC_UINT32 smmu0_rcv_ppu_mc_rsp_fc_cnt;
    ZXIC_UINT32 smmu0_rcv_odma_tdm_mc_rsp_fc_cnt;
    ZXIC_UINT32 smmu0_to_odma_tdm_mc_req_fc_cnt;
    ZXIC_UINT32 smmu0_to_odma_req_fc_cnt;
    ZXIC_UINT32 smmu0_to_dma_req_fc_cnt;
    ZXIC_UINT32 smmu0_to_stat_req_fc_cnt[DPP_SMMU0_STAT_NUM];
    ZXIC_UINT32 smmu0_rcv_stat_rsp_fc_cnt[DPP_SMMU0_STAT_NUM];
    ZXIC_UINT32 smmu0_to_ppu_req_fc_cnt[DPP_SMMU0_CLS_NUM];
    ZXIC_UINT32 smmu0_rcv_ppu_rsp_fc_cnt[DPP_SMMU0_CLS_NUM];
}DPP_SMMU0_DBG_FC_CNT_T;
/*smmu0 调试打印计数 结束*/

/*smmu1 计数�?*/
typedef struct dpp_smmu1_dbg_cnt_t
{
    ZXIC_UINT32 ctrl_to_cash_fc_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 cash_to_ctrl_req_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 rschd_to_cache_fc_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 cash_to_cache_rsp_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 cash_to_ctrl_fc_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 ctrl_to_cash_rsp_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 kschd_to_cache_req_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 cache_to_kschd_fc_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 dma_to_smmu1_rd_req_cnt;
    ZXIC_UINT32 oam_to_kschd_req_cnt;
    ZXIC_UINT32 oam_rr_state_rsp_cnt;
    ZXIC_UINT32 oam_clash_info_cnt;
    ZXIC_UINT32 oam_to_rr_req_cnt;
    ZXIC_UINT32 lpm_as_to_kschd_req_cnt;
    ZXIC_UINT32 lpm_as_rr_state_rsp_cnt;
    ZXIC_UINT32 lpm_as_clash_info_cnt;
    ZXIC_UINT32 lpm_as_to_rr_req_cnt;
    ZXIC_UINT32 lpm_to_kschd_req_cnt;
    ZXIC_UINT32 lpm_rr_state_rsp_cnt;
    ZXIC_UINT32 lpm_clash_info_cnt;
    ZXIC_UINT32 lpm_to_rr_req_cnt;
    ZXIC_UINT32 hash_to_kschd_req_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 hash_rr_state_rsp_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 hash_clash_info_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 hash_to_rr_req_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 dir_to_kschd_req_cnt[DPP_SMMU1_DIR_CHANNEL_CNT];
    ZXIC_UINT32 dir_clash_info_cnt[DPP_SMMU1_DIR_CHANNEL_CNT];
    ZXIC_UINT32 dir_tbl_wr_req_cnt;
    ZXIC_UINT32 warbi_to_dir_tbl_warbi_fc_cnt;
    ZXIC_UINT32 dir_to_bank_rr_req_cnt[DPP_SMMU1_DIR_CHANNEL_CNT];
    ZXIC_UINT32 kschd_to_dir_fc_cnt[DPP_SMMU1_DIR_CHANNEL_CNT];
    ZXIC_UINT32 dir_rr_state_rsp_cnt[DPP_SMMU1_DIR_CHANNEL_CNT];
    ZXIC_UINT32 wr_done_to_warbi_fc_cnt;
    ZXIC_UINT32 wr_done_ptr_req_cnt;
    ZXIC_UINT32 ctrl_to_warbi_fc_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 warbi_to_ctrl_wr_req_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 warbi_to_cash_wr_req_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 warbi_to_cpu_wr_fc_cnt;
    ZXIC_UINT32 cpu_wr_req_cnt;
    ZXIC_UINT32 ctrl_to_cpu_rd_rsp_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 cpu_to_ctrl_rd_req_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 cpu_rd_dir_tbl_rsp_cnt;
    ZXIC_UINT32 cpu_to_dir_tbl_rd_wr_req_cnt;
    ZXIC_UINT32 smmu1_to_mmu_rsp_fc_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 mmu_to_smmu1_rd_rsp_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 mmu_to_smmu1_rd_fc_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 smmu1_to_mmu_rd_req_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 mmu_to_smmu1_wr_fc_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 smmu1_to_mmu_wr_req_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 se_to_smmu1_wr_rsp_fc_cnt;
    ZXIC_UINT32 smmu1_to_se_wr_rsp_cnt;
    ZXIC_UINT32 ddr_wr_rsp_cnt[DPP_SMMU1_GRP_CNT];
    ZXIC_UINT32 smmu1_to_as_fc_cnt;
    ZXIC_UINT32 as_to_smmu1_wr_req_cnt;
    ZXIC_UINT32 smmu1_to_se_parser_fc_cnt;
    ZXIC_UINT32 se_parser_to_smmu1_req_cnt;/* 微码写ddr直接�? */
    ZXIC_UINT32 smmu1_to_etm_wr_fc_cnt;
    ZXIC_UINT32 etm_wr_req_cnt;
    ZXIC_UINT32 smmu1_to_ftm_wr_fc_cnt;
    ZXIC_UINT32 ftm_wr_req_cnt;
    ZXIC_UINT32 smmu1_to_state_wr_fc_cnt;
    ZXIC_UINT32 state_wr_req_cnt;
    ZXIC_UINT32 se_to_dma_rsp_cnt;
    ZXIC_UINT32 se_to_dma_fc_cnt;
    ZXIC_UINT32 oam_to_smmu1_fc_cnt;
    ZXIC_UINT32 smmu1_to_oam_rsp_cnt;
    ZXIC_UINT32 smmu1_to_oam_fc_cnt;
    ZXIC_UINT32 oam_to_smmu1_req_cnt;
    ZXIC_UINT32 smmu1_to_etm_rsp_cnt;
    ZXIC_UINT32 smmu1_to_ftm_rsp_cnt;
    ZXIC_UINT32 smmu1_to_etm_fc_cnt;
    ZXIC_UINT32 etm_to_smmu1_req_cnt;
    ZXIC_UINT32 smmu1_to_ftm_fc_cnt;
    ZXIC_UINT32 ftm_to_smmu1_req_cnt;
    ZXIC_UINT32 smmu1_to_stat_rsp_cnt;
    ZXIC_UINT32 smmu1_to_stat_fc_cnt;
    ZXIC_UINT32 stat_to_smmu1_req_cnt;   /* cmmu */
    ZXIC_UINT32 lpm_as_to_smmu1_fc_cnt;
    ZXIC_UINT32 lpm_to_smmu1_fc_cnt;
    ZXIC_UINT32 smmu1_to_lpm_as_rsp_cnt;
    ZXIC_UINT32 smmu1_to_lpm_rsp_cnt;
    ZXIC_UINT32 smmu1_to_lpm_as_fc_cnt;
    ZXIC_UINT32 smmu1_to_lpm_fc_cnt;
    ZXIC_UINT32 lpm_as_to_smmu1_req_cnt;
    ZXIC_UINT32 lpm_to_smmu1_req_cnt;
    ZXIC_UINT32 hash_to_smmu1_fc_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 smmu1_to_hash_rsp_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 smmu1_to_hash_fc_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 hash_to_smmu1_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 se_to_smmu1_dir_rsp_fc_cnt[DPP_SMMU1_DIR_CHANNEL_CNT];
    ZXIC_UINT32 smmu1_to_se_dir_rsp_cnt[DPP_SMMU1_DIR_CHANNEL_CNT];
    ZXIC_UINT32 smmu1_to_se_dir_fc_cnt[DPP_SMMU1_DIR_CHANNEL_CNT];
    ZXIC_UINT32 se_to_smmu1_dir_cnt[DPP_SMMU1_DIR_CHANNEL_CNT];
    ZXIC_UINT32 cache_to_rschd_rsp_cnt[DPP_SMMU1_GRP_CNT];
}DPP_SMMU1_DBG_CNT_T;

/*parser 计数�?*/
typedef struct se_parser_dbg_cnt_t
{
    ZXIC_UINT32 mex_req_cnt[DPP_PARSE_MEX_CHANNEL_NUM];
    ZXIC_UINT32 kschd_req_cnt[DPP_PARSE_KSCHD_CHANNEL_NUM];
    ZXIC_UINT32 kschd_parser_fc_cnt[DPP_PARSE_KSCHD_CHANNEL_NUM];
    ZXIC_UINT32 se_ppu_mex_fc_cnt[DPP_PARSE_MEX_CHANNEL_NUM];
    ZXIC_UINT32 smmu0_marc_fc_cnt;
    ZXIC_UINT32 smmu0_marc_key_cnt;
    ZXIC_UINT32 smmu1_key_cnt;
    ZXIC_UINT32 smmu1_parser_fc_cnt;
    ZXIC_UINT32 marc_tab_type_err_mex_cnt[DPP_PARSE_MEX_CHANNEL_NUM];
    ZXIC_UINT32 eram_fulladdr_drop_cnt;
}SE_PARSER_DBG_CNT_T;

/*kschd 计数�?*/
typedef struct se_kschd_dbg_cnt_t
{
    ZXIC_UINT32 parser_kschd_key_cnt[DPP_PARSE_KSCHD_CHANNEL_NUM];
    ZXIC_UINT32 kschd_smmu1_key_cnt[DPP_SMMU1_SCH_CNT];
    ZXIC_UINT32 kschd_to_as_hash0_key_cnt;
    ZXIC_UINT32 kschd_to_as_hash1_key_cnt;
    ZXIC_UINT32 kschd_to_as_hash2_key_cnt;
    ZXIC_UINT32 kschd_to_as_hash3_key_cnt;
    ZXIC_UINT32 kschd_to_as_lpm_key_cnt;
    ZXIC_UINT32 kschd_to_as_etacm0_key_cnt;
    ZXIC_UINT32 kschd_to_as_etacm1_key_cnt;
    ZXIC_UINT32 kschd_to_as_pbu_key_cnt;
    ZXIC_UINT32 kschd_to_parser_fc_cnt[DPP_PARSE_KSCHD_CHANNEL_NUM];
    ZXIC_UINT32 smmu1_kschd_fc_cnt[DPP_SMMU1_SCH_CNT];
    ZXIC_UINT32 kschd_rcv_as_hash0_fc_cnt;
    ZXIC_UINT32 kschd_rcv_as_hash1_fc_cnt;
    ZXIC_UINT32 kschd_rcv_as_hash2_fc_cnt;
    ZXIC_UINT32 kschd_rcv_as_hash3_fc_cnt;
    ZXIC_UINT32 kschd_rcv_as_lpm_fc_cnt;
    ZXIC_UINT32 kschd_rcv_as_etacm0_fc_cnt;
    ZXIC_UINT32 kschd_rcv_as_etacm1_fc_cnt;
    ZXIC_UINT32 kschd_rcv_as_pbu_fc_cnt;
}SE_KSCHD_DBG_CNT_T;

/*rschd 计数�?*/
typedef struct se_rschd_dbg_cnt_t
{
    ZXIC_UINT32 se_ppu_mex_rsp_cnt[DPP_RSCHD_PPU_CHANNEL_NUM];
    ZXIC_UINT32 rschd_rcv_as_hash0_rsp_cnt;
    ZXIC_UINT32 rschd_rcv_as_hash1_rsp_cnt;
    ZXIC_UINT32 rschd_rcv_as_hash2_rsp_cnt;
    ZXIC_UINT32 rschd_rcv_as_hash3_rsp_cnt;
    ZXIC_UINT32 rschd_rcv_as_lpm_rsp_cnt;
    ZXIC_UINT32 rschd_rcv_as_etacm0_rsp_cnt;
    ZXIC_UINT32 rschd_rcv_as_etacm1_rsp_cnt;
    ZXIC_UINT32 rschd_rcv_as_pbu_rsp_cnt;
    ZXIC_UINT32 smmu1_rschd_rsp_cnt[DPP_SMMU1_SCH_CNT];
    ZXIC_UINT32 ppu_se_mex_fc_cnt[DPP_RSCHD_PPU_CHANNEL_NUM];
    ZXIC_UINT32 rschd_to_as_hash0_fc_cnt;
    ZXIC_UINT32 rschd_to_as_hash1_fc_cnt;
    ZXIC_UINT32 rschd_to_as_hash2_fc_cnt;
    ZXIC_UINT32 rschd_to_as_hash3_fc_cnt;
    ZXIC_UINT32 rschd_to_as_lpm_fc_cnt;
    ZXIC_UINT32 rschd_to_as_etacm0_fc_cnt;
    ZXIC_UINT32 rschd_to_as_etacm1_fc_cnt;
    ZXIC_UINT32 rschd_to_as_pbu_fc_cnt;
    ZXIC_UINT32 rschd_smmu1_rdy_cnt[DPP_SMMU1_SCH_CNT];
    ZXIC_UINT32 rschd_rcv_smmu0_wr_done_cnt;
    ZXIC_UINT32 rschd_to_smmu0_wr_done_fc_cnt;
    ZXIC_UINT32 rschd_rcv_smmu1_wr_done_cnt;
    ZXIC_UINT32 rschd_to_smmu1_wr_done_fc_cnt;
    ZXIC_UINT32 rschd_rcv_alg_wr_done_cnt;
    ZXIC_UINT32 rschd_to_alg_wr_done_fc_cnt;
}SE_RSCHD_DBG_CNT_T;

/*cmmu 计数�?*/
typedef struct se_cmmu_dbg_cnt_t
{
    ZXIC_UINT32 stat_cmmu_req_cnt;
    ZXIC_UINT32 cmmu_stat_fc_cnt;
    ZXIC_UINT32 smmu1_cmmu_wr_fc_cnt;
    ZXIC_UINT32 smmu1_cmmu_rd_fc_cnt;
}SE_CMMU_DBG_CNT_T;
/*cmmu req计数�? 结束*/

/*se_as模块 计数�?*/
typedef struct se_as_dbg_cnt_t
{
    ZXIC_UINT32 hash_wr_req_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 smmu0_etcam_fc_cnt[DPP_ETCAM_ID_NUM];
    ZXIC_UINT32 etcam_smmu0_req_cnt[DPP_ETCAM_ID_NUM];
    ZXIC_UINT32 smmu0_etcam_rsp_cnt[DPP_ETCAM_ID_NUM];
    ZXIC_UINT32 as_hla_hash_key_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 as_hla_lpm_key_cnt;
    ZXIC_UINT32 alg_as_hash_rsp_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 alg_as_hash_smf_rsp_cnt[DPP_HASH_ID_NUM];/* 命中计数 */
    ZXIC_UINT32 alg_as_lpm_rsp_cnt;
    ZXIC_UINT32 alg_as_lpm_smf_rsp_cnt;/* 命中计数 */
    ZXIC_UINT32 as_pbu_key_cnt;
    ZXIC_UINT32 pbu_se_dpi_rsp_dat_cnt;
    ZXIC_UINT32 as_etcam_ctrl_req_cnt[DPP_ETCAM_ID_NUM];
    ZXIC_UINT32 etcam_ctrl_as_index_cnt[DPP_ETCAM_ID_NUM];/* 有效返回计数 */
    ZXIC_UINT32 etcam_ctrl_as_hit_cnt[DPP_ETCAM_ID_NUM];
    ZXIC_UINT32 as_smmu0_req_cnt;
    ZXIC_UINT32 learn_hla_wr_cnt;/* 硬件学习 */
    ZXIC_UINT32 as_smmu1_req_cnt;
    ZXIC_UINT32 se_cfg_mac_dat_cnt;/* 到DMA计数 */
    ZXIC_UINT32 alg_as_hash_fc_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 alg_as_lpm_fc_cnt;
    ZXIC_UINT32 as_alg_hash_fc_cnt[DPP_HASH_ID_NUM];
    ZXIC_UINT32 as_alg_lpm_fc_cnt;
    ZXIC_UINT32 as_pbu_fc_cnt;
    ZXIC_UINT32 pbu_se_dpi_key_fc_cnt;
    ZXIC_UINT32 as_etcam_ctrl_fc_cnt[DPP_ETCAM_ID_NUM];
    ZXIC_UINT32 etcam_ctrl_as_fc_cnt[DPP_ETCAM_ID_NUM];
    ZXIC_UINT32 smmu0_as_mac_age_fc_cnt;
    ZXIC_UINT32 alg_learn_fc_cnt;
    ZXIC_UINT32 smmu1_as_fc_cnt;
    ZXIC_UINT32 cfg_se_mac_fc_cnt;
}SE_AS_DBG_CNT_T;


/* hash 是否响应dma流控使能*/
typedef enum se_as_hash_dma_fc_en_e
{
    HASH_EN_DMA_FC     = 0,
    HASH_UN_EN_DMA_FC  = 1,
}SE_AS_HASH_DMA_FC_EN_E;
/*se_as模块 计数�? 结束*/

/**  alg模块调试计数*/
typedef struct se_alg_dbg_cnt_t
{
    ZXIC_UINT32 hash_key_cnt[4];
    ZXIC_UINT32 hash_rsp_cnt[4];
    ZXIC_UINT32 hash_hit_cnt[4];
    ZXIC_UINT32 hash_space_vld_cnt[4];
    ZXIC_UINT32 hash_ddr3_req_vld_cnt[4];
    ZXIC_UINT32 hash_ddr3_rsp_vld_cnt[4];

    ZXIC_UINT32 lpm_key_cnt;
    ZXIC_UINT32 lpm_rsp_cnt;
    ZXIC_UINT32 lpm_hit_cnt;
    ZXIC_UINT32 lpm_key_ddr3_req_vld_cnt; /**<  @brief LPM_SMMU1_P4口用于键�?*/
    ZXIC_UINT32 lpm_key_ddr3_rsp_vld_cnt; /**<  @brief LPM_SMMU1_P4口用于键�?*/
    ZXIC_UINT32 lpm_as_ddr3_req_vld_cnt;  /**<  @brief LPM_SMMU1_P5口用于关联结�?*/
    ZXIC_UINT32 lpm_as_ddr3_rsp_vld_cnt;  /**<  @brief LPM_SMMU1_P5口用于关联结�?*/
}SE_ALG_DBG_CNT_T;

typedef struct se_alg_dbg_excp_cnt_t
{
    ZXIC_UINT32 schd_learn_fifo_int_cnt;
    ZXIC_UINT32 schd_hash_fifo_int_cnt[4];
    ZXIC_UINT32 schd_lpm_fifo_int_cnt;
    ZXIC_UINT32 schd_learn_fifo_parity_err_cnt;
    ZXIC_UINT32 schd_hash_fifo_parity_err_cnt[4];
    ZXIC_UINT32 schd_lpm_fifo_parity_err_cnt;
    ZXIC_UINT32 rd_init_cft_cnt;                 /**<  @brief 初始化过程中出现的CPU读命令冲突计�?*/
    ZXIC_UINT32 zblk_ecc_err_cnt[32];            /**<  @brief 32个zblock的ecc错误计数*/
    ZXIC_UINT32 zcam_hash_parity_err_cnt[4];     /**<  @brief 4个hash业务口的parity错误计数*/
    ZXIC_UINT32 zcam_lpm_err_cnt;                /**<  @brief LPM业务口错误计�?*/

    ZXIC_UINT32 hash_sreq_fifo_parity_err_cnt[4];
    ZXIC_UINT32 hash_sreq_fifo_int_cnt[4];
    ZXIC_UINT32 hash_key_fifo_int_cnt[4];
    ZXIC_UINT32 hash_int_rsp_fifo_parity_err_cnt[4];
    ZXIC_UINT32 hash_ext_rsp_fifo_parity_err_cnt[4];
    ZXIC_UINT32 hash_ext_rsp_fifo_int_cnt[4];
    ZXIC_UINT32 hash_int_rsp_fifo_int_cnt[4];

    ZXIC_UINT32 lpm_ext_rsp_fifo_int_cnt;
    ZXIC_UINT32 lpm_ext_v6_fifo_int_cnt;
    ZXIC_UINT32 lpm_ext_v4_fifo_int_cnt;
    ZXIC_UINT32 lpm_ext_addr_fifo_int_cnt;
    ZXIC_UINT32 lpm_ext_v4_fifo_parity_err_cnt;
    ZXIC_UINT32 lpm_ext_v6_fifo_parity_err_cnt;
    ZXIC_UINT32 lpm_ext_rsp_fifo_parity_err_cnt;
    ZXIC_UINT32 lpm_as_req_fifo_int_cnt;
    ZXIC_UINT32 lpm_as_int_rsp_fifo_int_cnt;
}SE_ALG_DBG_EXCP_CNT_T;

#define LPM_HW_DAT_BUFF_SIZE_MAX (24 * 1024)
typedef enum {
    LPM_DAT_WR_TYPE_DMA     = 1UL,
    LPM_DAT_WR_TYPE_REG     = 2UL,
}LPM_DAT_WR_TYPE;

typedef enum {
    LPM_DAT_ZECLL     = 1UL,
    LPM_DAT_ZREG      = 2UL,
    LPM_DAT_DDR       = 3UL,  
    LPM_DAT_DDR_RST   = 4UL,        
    LPM_DAT_ERAM_RST  = 5UL, 
    LPM_DAT_TYPE_MAX, 
}ROUTE_DAT_TYPE;

typedef struct _lpm_hw_dat_ddr
{
    ZXIC_UINT32         dat_type;     /* ROUTE_DAT_TYPE :LPM_DAT_DDR/LPM_DAT_DDR_RST */
    ZXIC_UINT32         v4v6_flag;    /* ALG_LPM_TYPE_E */
    ZXIC_UINT32         lpm_wr_vld;   /* 0-WR 1-RD */
    ZXIC_UINT32         tbl_id;       /* 对应复制通道 */    
    ZXIC_UINT32         base_addr;    /* 19b */
    ZXIC_UINT32         index;        /* by rw_len */
    ZXIC_UINT32         ecc_en;   
    ZXIC_UINT32         rw_len;       /* SMMU1_DDR_WRT_MODE_E */
    ZXIC_UINT8          data[512/8];  /* 左对�? */   
}ROUTE_HW_DAT_DDR;

typedef struct _lpm_hw_dat_zcam
{
    ZXIC_UINT32         dat_type;       /* ROUTE_DAT_TYPE :LPM_DAT_ZREG/LPM_DAT_ZECLL */
    ZXIC_UINT32         ram_reg_flag;   /* 0-reg 1-cell */
    ZXIC_UINT32         rw_addr;        /* by 512b */
    ZXIC_UINT8          data[512/8];    /* 左对�? */  
}ROUTE_HW_DAT_ZCAM;

typedef struct _lpm_hw_dat_eram
{
    ZXIC_UINT32         dat_type;   /* ROUTE_DAT_TYPE :LPM_DAT_ERAM_RST */
    ZXIC_UINT32         base_addr;  /* by 128b */
    ZXIC_UINT32         index;      /* by rw_len*/
    ZXIC_UINT32         rw_len;     /* DPP_ERAM128_TBL_MODE_E */
    ZXIC_UINT8          data[128/8];/* 左对�? */      
}ROUTE_HW_DAT_ERAM;

typedef struct ppu_stat_cfg_t
{
    ZXIC_UINT32 eram_baddr;           /*片内统计基地址，单位128bit*/
    ZXIC_UINT32 eram_depth;           /*片内深度，单位128bit*/
    ZXIC_UINT32 ddr_base_addr;            /*片外统计基地址(PPU和OAM的片外计数共用此基地址)，单位2k*256bit*/
    ZXIC_UINT32 ppu_addr_offset;      /*PPU统计偏移地址,单位128bit*/
}PPU_STAT_CFG_T;

/** SMMU1 */
/***********************************************************/
/** TM 片外统计获取函数
* @param   dev_id   
* @param   tm_type   
* @param   rd_mode   
* @param   clr_mode     读清模式，仅支持断流读清
* @param   index   
* @param   p_tm_cnt     出参，读取的�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/07/19
************************************************************/
DPP_STATUS dpp_se_smmu1_tm_read(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 tm_type,
                                STAT_TM_RD_DDR_MODE_E rd_mode,
                                STAT_TM_RD_CLR_MODE_E clr_mode,
                                ZXIC_UINT32 index,
                                ZXIC_UINT32 *p_tm_cnt);


/***********************************************************/
/** 获取SMMU1初始化完成状�?
* @param   dev_id       设备�?
* @param   p_clr_done   分段初始化完成标�?
* @param   p_init_ok    全局初始化完成标�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/04/11
************************************************************/
DPP_STATUS dpp_se_smmu1_init_done_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_clr_done, ZXIC_UINT32* p_init_ok);

/***********************************************************/
/** 设置空间清零使能，包括全局和分段清零使�?
* @param   dev_id       设备�?
* @param   gbl_init_en  全局清空时能�?1-使能�?0-未使能，默认未使�?
* @param   clr_tbl_en   固定空间清零使能�?1-使能�?0-未使能，默认未使�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2015/04/27
************************************************************/
DPP_STATUS dpp_se_smmu1_clr_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 gbl_init_en, ZXIC_UINT32 clr_tbl_en);

/***********************************************************/
/** dpp hash的smmu1属性获�?
* @param   dev_id   
* @param   hash_id   
* @param   tbl_id   
* @param   p_len     
* @param   p_ecc_en     
* @param   p_baddr   
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/04/13
************************************************************/
DPP_STATUS dpp_se_smmu1_hash_tbl_cfg_get(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 hash_id,
                                         ZXIC_UINT32 tbl_id,
                                         ZXIC_UINT32* p_len,
                                         ZXIC_UINT32* p_ecc_en,
                                         ZXIC_UINT32* p_baddr);

/***********************************************************/


/** dpp stat的smmu1属性设置
* @param   dev_id       设备号
* @param   baddr        基地址
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  
* @see     
* @author  ls      @date  2016/04/13
************************************************************/
DPP_STATUS dpp_se_smmu1_stat_mode_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 stat_mode);

/***********************************************************/
/** dpp hash的smmu1属性设�?
* @param   dev_id       设备�?
* @param   hash_id      hash引擎�?
* @param   tbl_id       hash表号
* @param   ecc_en       ecc使能
* @param   baddr        ddr基地址
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/04/12
************************************************************/
DPP_STATUS dpp_se_smmu1_hash_tbl_cfg_set(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 hash_id,
                                         ZXIC_UINT32 tbl_id,
                                         ZXIC_UINT32 ecc_en,
                                         ZXIC_UINT32 baddr);

/***********************************************************/
/** dpp lpm的smmu1属性设�?
* @param   dev_id       设备�?
* @param   lpm_type     lpm类型，参见ALG_LPM_TYPE_E
* @param   rsp_len      级联结果表返回位宽，参见DPP_ROUTE_AS_RSP_LEN_E，键值表不使�?
* @param   ecc_en       ECC校验使能
* @param   baddr        基地址
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/04/13
************************************************************/
DPP_STATUS dpp_se_smmu1_lpm_tbl_cfg_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 lpm_type,
                                        ZXIC_UINT32 rsp_len,
                                        ZXIC_UINT32 ecc_en,
                                        ZXIC_UINT32 baddr);

/***********************************************************/
/** dpp lpm的smmu1属性获�?
* @param   dev_id   
* @param   lpm_type     lpm类型，参见ALG_LPM_TYPE_E
* @param   mode         模式: 0-从软件缓存读取，1-从硬件读�?
* @param   p_rsp_len    级联结果表返回位宽，参见DPP_ROUTE_AS_RSP_LEN_E，键值表不使�?
* @param   p_ecc_en     ECC校验使能
* @param   p_baddr      基地址
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/04/13
************************************************************/
DPP_STATUS dpp_se_smmu1_lpm_tbl_cfg_get(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 lpm_type,
                                        ZXIC_UINT32 mode,
                                        ZXIC_UINT32 *p_rsp_len,
                                        ZXIC_UINT32 *p_ecc_en,
                                        ZXIC_UINT32 *p_baddr);

/***********************************************************/
/** dpp ftm的smmu1属性设�?
* @param   dev_id       设备�?
* @param   baddr        基地址
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/04/13
************************************************************/
DPP_STATUS dpp_se_smmu1_ftm_tbl_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 baddr);

/***********************************************************/
/** dpp ftm的smmu1属性获�?
* @param   dev_id     
* @param   p_baddr   
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/04/13
************************************************************/
DPP_STATUS dpp_se_smmu1_ftm_tbl_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_baddr);

/***********************************************************/
/** dpp etm的smmu1属性设�?
* @param   dev_id       设备�?
* @param   baddr        基地址
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/04/13
************************************************************/
DPP_STATUS dpp_se_smmu1_etm_tbl_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 baddr);

/***********************************************************/
/** dpp etm的smmu1属性获�?
* @param   dev_id   
* @param   p_ecc_en   
* @param   p_rw_len   
* @param   p_baddr   
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/04/13
************************************************************/
DPP_STATUS dpp_se_smmu1_etm_tbl_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_baddr);
/***********************************************************/
/** dpp dma的smmu1属性获�?
* @param   dev_id   
* @param   p_ecc_en   
* @param   p_rw_len   
* @param   p_baddr   
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/04/13
************************************************************/
DPP_STATUS dpp_se_smmu1_dma_tbl_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_baddr);

DPP_STATUS dpp_se_smmu1_cache_agetime_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 age_time);

DPP_STATUS dpp_se_smmu1_cache_agetime_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_age_time);

DPP_STATUS dpp_se_smmu1_cfg_cache_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_cache_en);

DPP_STATUS dpp_se_smmu1_cache_ecc_err_addr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cache_id, ZXIC_UINT32 *p_ecc_err_addr);
/***********************************************************/
/** dpp stat的smmu1属性获取
* @param   dev_id     
* @param   p_baddr   
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  
* @see     
* @author  ls      @date  2016/04/13
************************************************************/
DPP_STATUS dpp_se_smmu1_stat_mode_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_baddr);

/***********************************************************/
/** 获取SMMU1统计计数
* @param   dev_id   
* @param   p_smmu1_dbg_cnt   
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/12/30
************************************************************/
DPP_STATUS dpp_se_smmu1_dbg_cnt_get(ZXIC_UINT32 dev_id, DPP_SMMU1_DBG_CNT_T* p_smmu1_dbg_cnt);

/***********************************************************/
/** 配置KSCHD模块hash sdt内容
* @param   dev_id       设备�?
* @param   sdt_high     sdt高位数据
* @param   sdt_low      sdt低位数据
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  刘硕10181552      @date  2016/03/08
************************************************************/
DPP_STATUS dpp_se_kschd_hash_sdt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_high, ZXIC_UINT32 sdt_low);

/***********************************************************/
/** 获取KSCHD模块hash sdt内容
* @param   dev_id       设备�?
* @param   sdt_high     sdt高位数据
* @param   sdt_low      sdt低位数据
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  刘硕10181552      @date  2016/03/08
************************************************************/
DPP_STATUS dpp_se_kschd_hash_sdt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_sdt_high, ZXIC_UINT32* p_sdt_low);

/***********************************************************/
/** CPU口写hash数据
* @param   dev_id       设备�?
* @param   p_data       传入的数�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  刘硕10181552      @date  2016/03/08
************************************************************/
DPP_STATUS dpp_se_kschd_hash_key_set(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 delete_en,
                                     ZXIC_UINT32 dma_en,
                                     ZXIC_UINT32 *p_data);

/***********************************************************/
/** CPU口读取hash数据
* @param   dev_id       设备�?
* @param   p_data       传出的参�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  刘硕10181552      @date  2016/03/08
************************************************************/
DPP_STATUS dpp_se_kschd_hash_key_get(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 *p_delete_en,
                                     ZXIC_UINT32 *p_dma_en,
                                     ZXIC_UINT32 *p_data);

/***********************************************************/
/** cmmu模块smmu1属性配�?
* @param   dev_id           设备�?
* @param   base_addr        基地址
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/08/12
************************************************************/
DPP_STATUS dpp_se_cmmu_smmu1_cfg_set(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 base_addr);

/***********************************************************/
/** cmmu模块smmu1属性获�?
* @param   dev_id   
* @param   p_base_addr      
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see     
* @author  ls      @date  2016/08/30
************************************************************/
DPP_STATUS dpp_se_cmmu_smmu1_cfg_get(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 *p_base_addr);

/** END_SMMU1 */

DPP_STATUS dpp_se_as_age_tbl_baddr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 table_id, ZXIC_UINT32 * p_base_addr);
/* API */
/***********************************************************/
/** alg间接�?
* @param   dev_id  设备�?
* @param   addr       zcam内部ram地址，包括掩�?
* @param   p_data     数据
*
* @return
* @remark  �?
* @see
* @author  王春�?      @date  2014/11/10
************************************************************/
DPP_STATUS dpp_se_alg_comm_ind_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT8 *p_data);
DPP_STATUS dpp_se_alg_ind_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT8   *p_data);

DPP_STATUS dpp_se_alg_ind_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT8   *p_data);

DPP_STATUS dpp_se_hash_ddr_set(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 hash_id,
                               ZXIC_UINT32 hash_ddr_bulk_id,
                               ZXIC_UINT32 ddr_wr_mode,
                               ZXIC_UINT32 index,
                               ZXIC_UINT8   *p_data);

DPP_STATUS dpp_se_hash_ddr_get(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 hash_id,
                               ZXIC_UINT32 hash_ddr_bulk_id,
                               ZXIC_UINT32 ddr_wr_mode,
                               ZXIC_UINT32 index,
                               ZXIC_UINT8   *p_data);

DPP_STATUS dpp_se_lpm_ddr_set(ZXIC_UINT32 dev_id,
                              ZXIC_UINT32 lpm_type,
                              ZXIC_UINT32 ddr_wr_mode,
                              ZXIC_UINT32 index,
                              ZXIC_UINT8   *p_data);

DPP_STATUS dpp_se_zblk_serv_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 zblk_idx, ZXIC_UINT32 serv_sel, ZXIC_UINT32 hash_id, ZXIC_UINT32 enable);

DPP_STATUS dpp_se_zblk_serv_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 zblk_idx, ZXIC_UINT32 *p_serv_sel, ZXIC_UINT32 *p_hash_id, ZXIC_UINT32 *p_enable);

DPP_STATUS dpp_se_zcell_mono_cfg_set(ZXIC_UINT32 dev_id, 
                                     ZXIC_UINT32 zblk_idx, 
                                     ZXIC_UINT32 zcell0_tbl_id, 
                                     ZXIC_UINT32 zcell0_mono_flag, 
                                     ZXIC_UINT32 zcell1_tbl_id,
                                     ZXIC_UINT32 zcell1_mono_flag,
                                     ZXIC_UINT32 zcell2_tbl_id,
                                     ZXIC_UINT32 zcell2_mono_flag,
                                     ZXIC_UINT32 zcell3_tbl_id,
                                     ZXIC_UINT32 zcell3_mono_flag);

DPP_STATUS dpp_se_zcell_mono_cfg_get(ZXIC_UINT32 dev_id, 
                                     ZXIC_UINT32 zblk_idx, 
                                     ZXIC_UINT32 *zcell0_tbl_id, 
                                     ZXIC_UINT32 *zcell0_mono_flag, 
                                     ZXIC_UINT32 *zcell1_tbl_id,
                                     ZXIC_UINT32 *zcell1_mono_flag,
                                     ZXIC_UINT32 *zcell2_tbl_id,
                                     ZXIC_UINT32 *zcell2_mono_flag,
                                     ZXIC_UINT32 *zcell3_tbl_id,
                                     ZXIC_UINT32 *zcell3_mono_flag);

DPP_STATUS dpp_se_zreg_mono_cfg_set(ZXIC_UINT32 dev_id,           
                                    ZXIC_UINT32 zblk_idx,            
                                    ZXIC_UINT32 zreg0_tbl_id,        
                                    ZXIC_UINT32 zreg0_mono_flag,     
                                    ZXIC_UINT32 zreg1_tbl_id,        
                                    ZXIC_UINT32 zreg1_mono_flag,     
                                    ZXIC_UINT32 zreg2_tbl_id,        
                                    ZXIC_UINT32 zreg2_mono_flag,     
                                    ZXIC_UINT32 zreg3_tbl_id,        
                                    ZXIC_UINT32 zreg3_mono_flag);

DPP_STATUS dpp_se_zreg_mono_cfg_get(ZXIC_UINT32 dev_id, 
                                     ZXIC_UINT32 zblk_idx, 
                                     ZXIC_UINT32 *zreg0_tbl_id, 
                                     ZXIC_UINT32 *zreg0_mono_flag, 
                                     ZXIC_UINT32 *zreg1_tbl_id,
                                     ZXIC_UINT32 *zreg1_mono_flag,
                                     ZXIC_UINT32 *zreg2_tbl_id,
                                     ZXIC_UINT32 *zreg2_mono_flag,
                                     ZXIC_UINT32 *zreg3_tbl_id,
                                     ZXIC_UINT32 *zreg3_mono_flag);

DPP_STATUS dpp_se_hash_zcam_mono_flags_set(ZXIC_UINT32 dev_id, 
                                           ZXIC_UINT32 hash0_mono_flag, 
                                           ZXIC_UINT32 hash1_mono_flag, 
                                           ZXIC_UINT32 hash2_mono_flag,
                                           ZXIC_UINT32 hash3_mono_flag);

DPP_STATUS dpp_se_hash_zcam_mono_flags_get(ZXIC_UINT32 dev_id, 
                                           ZXIC_UINT32 *hash0_mono_flag, 
                                           ZXIC_UINT32 *hash1_mono_flag, 
                                           ZXIC_UINT32 *hash2_mono_flag,
                                           ZXIC_UINT32 *hash3_mono_flag);

DPP_STATUS dpp_se_hash_ext_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 hash_id, ZXIC_UINT32 ext_mode, ZXIC_UINT32 flag);

DPP_STATUS dpp_se_hash_ext_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 hash_id, ZXIC_UINT32 *p_content_type, ZXIC_UINT32 *p_flag);

DPP_STATUS dpp_se_hash_tbl_depth_set(ZXIC_UINT32 dev_id, 
                                     ZXIC_UINT32 hash_id, 
                                     ZXIC_UINT32 hash_tbl0_depth,          
                                     ZXIC_UINT32 hash_tbl1_depth,          
                                     ZXIC_UINT32 hash_tbl2_depth,          
                                     ZXIC_UINT32 hash_tbl3_depth,          
                                     ZXIC_UINT32 hash_tbl4_depth,      
                                     ZXIC_UINT32 hash_tbl5_depth,      
                                     ZXIC_UINT32 hash_tbl6_depth,      
                                     ZXIC_UINT32 hash_tbl7_depth);

DPP_STATUS dpp_se_hash_tbl_depth_get(ZXIC_UINT32 dev_id, 
                                     ZXIC_UINT32 hash_id, 
                                     ZXIC_UINT32 *hash_tbl0_depth,          
                                     ZXIC_UINT32 *hash_tbl1_depth,          
                                     ZXIC_UINT32 *hash_tbl2_depth,          
                                     ZXIC_UINT32 *hash_tbl3_depth,          
                                     ZXIC_UINT32 *hash_tbl4_depth,      
                                     ZXIC_UINT32 *hash_tbl5_depth,      
                                     ZXIC_UINT32 *hash_tbl6_depth,      
                                     ZXIC_UINT32 *hash_tbl7_depth);

DPP_STATUS dpp_se_zblk_clk_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 zblk_clk_en);

DPP_STATUS dpp_se_zblk_clk_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *zblk_clk_en);
DPP_STATUS dpp_hash_age_pat_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 age_pat);

DPP_STATUS dpp_hash_age_pat_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *age_pat);

/*lpm下表数据缓存初始化*/
DPP_STATUS dpp_se_lpm_hw_dat_buf_init(ZXIC_UINT32 dev_id);

/*lpm下表数据缓存指针获取*/
ZXIC_UINT8 * dpp_se_lpm_hw_dat_buf_get(ZXIC_UINT32 dev_id);

/*lpm下表数据缓存销毁*/
DPP_STATUS dpp_se_lpm_hw_dat_buf_destroy(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_se_lpm_sram_cmp_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT8 *p_data);

DPP_STATUS dpp_se_lpm_sram_cmp_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT8 *p_data);

DPP_STATUS dpp_se_lpm_as_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable, ZXIC_UINT32 as_type);

DPP_STATUS dpp_se_lpm_as_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_enable, ZXIC_UINT32 *p_as_type);

DPP_STATUS dpp_se_lpm_config_get(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 lpm_id,
                                 ZXIC_UINT32 *p_shift_sel,
                                 ZXIC_UINT32 *p_sram_cmp_flag,
                                 ZXIC_UINT32 *p_ddr3_addr_sel);
DPP_STATUS dpp_se_lpm_config_set(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 lpm_id,
                                 ZXIC_UINT32 shift_sel,
                                 ZXIC_UINT32 sram_cmp_flag,
                                 ZXIC_UINT32 ddr3_addr_sel);
DPP_STATUS dpp_se_zblk_def_route_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT8 *p_data);

DPP_STATUS dpp_se_zblk_def_route_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT8 *p_data);

DPP_STATUS dpp_se_lpm_as_rsp_fifo0_pfull_ast_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

DPP_STATUS dpp_se_lpm_as_rsp_fifo0_pfull_neg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);


DPP_STATUS dpp_se_lpm_as_rslt_write(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 as_type,
                                    ZXIC_UINT32 tbl_id,
                                    ZXIC_UINT32 index,
                                    ZXIC_UINT8 *p_data);

DPP_STATUS dpp_se_smmu0_odma_baddr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 no, ZXIC_UINT32 *p_base_addr);

DPP_STATUS dpp_se_smmu1_all_cnt_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 清空eram空间
* @param   dev_id       设备�?
* @param   base_addr    基地址(128bit)
* @param   index        起始索引(128bit)
* @param   length       清除的条目数
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see     
* @author  刘硕10181552      @date  2015/11/06
************************************************************/
DPP_STATUS dpp_se_smmu0_clear(ZXIC_UINT32 dev_id,
                              ZXIC_UINT32 base_addr,
                              ZXIC_UINT32 index,
                              ZXIC_UINT32 length);

DPP_STATUS dpp_se_smmu0_wr_arb_rdy_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_wr_rdy);

DPP_STATUS dpp_se_kschd_as_ept_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

DPP_STATUS dpp_se_smmu0_mcast_baddr_get(ZXIC_UINT32 dev_id,ZXIC_UINT32 * p_base_addr);

DPP_STATUS dpp_se_smmu0_dma_baddr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_base_addr);

DPP_STATUS dpp_se_smmu0_cfg_car_mono_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_mode);

DPP_STATUS dpp_se_smmu0_stat_overflow_mode_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_mode);

DPP_STATUS dpp_se_cmmu_stat_overflow_mode_get(ZXIC_UINT32 dev_id,ZXIC_UINT32 *p_overflow_mode);

#if ZXIC_REAL("CLUSTER_HDW_CFG")
/* public interface */
ZXIC_UINT32     dpp_se_reg_cnt_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_num);
DPP_STATUS dpp_se_alg_init_done_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_init_done);
DPP_STATUS dpp_se_smmu1_clear_done_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_clr_done);
/* kschd*/
#define KSCHD_PORT_MAX_NUM   (46)

ZXIC_VOID dpp_se_kschd_cnt_show(ZXIC_UINT32 dev_id);

ZXIC_VOID dpp_se_kschd_all_port_cnt_show(ZXIC_UINT32 dev_id);

ZXIC_VOID dpp_se_kschd_portx_cnt_show(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);

/* rschd*/
#define RSCHD_PORT_MAX_NUM   (44)

ZXIC_VOID dpp_se_rschd_cnt_show(ZXIC_UINT32 dev_id);

ZXIC_VOID dpp_se_rschd_all_port_cnt_show(ZXIC_UINT32 dev_id);

ZXIC_VOID dpp_se_rschd_portx_cnt_show(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);

/* cmmu*/
ZXIC_VOID dpp_se_cmmu_cnt_show(ZXIC_UINT32 dev_id);

#define CMMU_RDY_MAX_NUM     (6)

ZXIC_VOID dpp_se_cmmu_rdy_cnt_show(ZXIC_UINT32 dev_id);

ZXIC_VOID dpp_se_cmmu_rdyx_cnt_show(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);

ZXIC_VOID dpp_se_cmmu_key_cnt_show(ZXIC_UINT32 dev_id);

ZXIC_VOID dpp_se_stat_cmmu_req_cnt_show(ZXIC_UINT32 dev_id);

/* debug*/
DPP_STATUS dpp_se_cnt_clr(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_se_parser_dbg_cnt_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 read_mode, ZXIC_UINT32 overflow_mode);

DPP_STATUS dpp_se_parser_dbg_cnt_mode_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_read_mode, ZXIC_UINT32 *p_overflow_mode);

DPP_STATUS dpp_se_kschd_dbg_cnt_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 read_mode, ZXIC_UINT32 overflow_mode);

DPP_STATUS dpp_se_kschd_dbg_cnt_mode_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_read_mode, ZXIC_UINT32 *p_overflow_mode);

DPP_STATUS dpp_se_rschd_dbg_cnt_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 read_mode, ZXIC_UINT32 overflow_mode);

DPP_STATUS dpp_se_rschd_dbg_cnt_mode_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_read_mode, ZXIC_UINT32 *p_overflow_mode);

DPP_STATUS dpp_se_as_dbg_cnt_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 read_mode, ZXIC_UINT32 overflow_mode);

DPP_STATUS dpp_se_as_dbg_cnt_mode_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_read_mode, ZXIC_UINT32 *p_overflow_mode);

DPP_STATUS dpp_se_cmmu_dbg_cnt_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 read_mode, ZXIC_UINT32 overflow_mode);

DPP_STATUS dpp_se_cmmu_dbg_cnt_mode_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_read_mode, ZXIC_UINT32 *p_overflow_mode);

/* se_smmu0_dbg_cnt*/
DPP_STATUS dpp_se_smmu0_dbg_cnt_get(ZXIC_UINT32 dev_id, DPP_SMMU0_DBG_CNT_T * p_smmu0_dbg_cnt);

DPP_STATUS dpp_se_smmu0_fc_cnt_get(ZXIC_UINT32 dev_id, DPP_SMMU0_DBG_FC_CNT_T * p_smmu0_fc_cnt);

/* se_smmu1_dbg_cnt*/
DPP_STATUS dpp_se_smmu1_debug_cnt_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cnt_rd_mode, ZXIC_UINT32 cnt_overflow_mode);

/* se_parse_dbg_cnt*/
DPP_STATUS dpp_se_parser_dbg_cnt_get(ZXIC_UINT32 dev_id, SE_PARSER_DBG_CNT_T *p_dbg_cnt);

/* se_kschd_dbg_cnt*/
DPP_STATUS dpp_se_kschd_dbg_cnt_get(ZXIC_UINT32 dev_id, SE_KSCHD_DBG_CNT_T *p_dbg_cnt);

/* se_rschd_dbg_cnt*/
DPP_STATUS dpp_se_rschd_dbg_cnt_get(ZXIC_UINT32 dev_id, SE_RSCHD_DBG_CNT_T *p_dbg_cnt);

/* se_cmmu_dbg_cnt*/
DPP_STATUS dpp_se_cmmu_dbg_cnt_get(ZXIC_UINT32 dev_id, SE_CMMU_DBG_CNT_T *p_dbg_cnt);

/* se_alg_dbg_cnt*/
DPP_STATUS dpp_se_alg_dbg_cnt_get(ZXIC_UINT32 dev_id, SE_ALG_DBG_CNT_T *p_dbg_cnt);

DPP_STATUS dpp_se_alg_dbg_excp_cnt_get(ZXIC_UINT32 dev_id, SE_ALG_DBG_EXCP_CNT_T * p_alg_excp_cnt);

DPP_STATUS dpp_se_rschd_lpm_ept_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

DPP_STATUS dpp_se_alg_init(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_se_as_init(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_se_smmu0_int8_status_clr(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_se_cfg_se_ddr_key_get(ZXIC_UINT32 dev_id, 
                                    ZXIC_UINT32 cluster_id,
                                    ZXIC_UINT32* key,
                                    ZXIC_UINT32* sdt_info_h,
                                    ZXIC_UINT32* sdt_info_l,
                                    ZXIC_UINT32* ppu_info,
                                    ZXIC_UINT32* dpi_flag,
                                    ZXIC_UINT32* wr_flag);
                                    
DPP_STATUS dpp_se_as_dbg_cnt_get(ZXIC_UINT32 dev_id, SE_AS_DBG_CNT_T * p_as_dbg_cnt);

DPP_STATUS dpp_se_smmu1_all_addr_clr(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_se_smmu1_dma_tbl_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 baddr);

DPP_STATUS dpp_se_smmu1_cfg_cash_addr_pful_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_se_smmu1_cfg_cash_addr_pful_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_smmu1_ctrl_rfifo_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 brst_fwft_fifo_prog_empty_assert, ZXIC_UINT32 brst_fwft_fifo_prog_empty_negate, ZXIC_UINT32 brst_fwft_fifo_prog_full_assert, ZXIC_UINT32 brst_fwft_fifo_prog_full_negate);
DPP_STATUS dpp_se_smmu1_ctrl_rfifo_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_brst_fwft_fifo_prog_empty_assert, ZXIC_UINT32 *p_brst_fwft_fifo_prog_empty_negate, ZXIC_UINT32 *p_brst_fwft_fifo_prog_full_assert, ZXIC_UINT32 *p_brst_fwft_fifo_prog_full_negate);

DPP_STATUS dpp_se_smmu1_cache_req_fifo_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 upper_value,ZXIC_UINT32 lower_value);
DPP_STATUS dpp_se_smmu1_cache_req_fifo_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_hvalue,ZXIC_UINT32 *p_lvalue);

DPP_STATUS dpp_se_smmu1_cache_rsp_rr_fifo_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_se_smmu1_cache_rsp_rr_fifo_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_kschd_as_pful_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_se_kschd_as_pful_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_kschd_dir_pful_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_se_kschd_dir_pful_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_kschd_cpu_arbi_pful_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_se_kschd_cpu_arbi_pful_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_kschd_pbu_pful_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_se_kschd_pbu_pful_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_smmu1_smmu1_int_14_17_en_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_se_smmu1_smmu1_int_14_17_mask_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

DPP_STATUS dpp_se_smmu1_ser_cache_en0_cfg_set(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 lpm_as_cache_en,
                                              ZXIC_UINT32 lpm_cache_en,
                                              ZXIC_UINT32 oam_cache_en,
                                              ZXIC_UINT32 dir_cache_en);
DPP_STATUS dpp_se_smmu1_ser_cache_en0_cfg_get(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 *p_lpm_as_cache_en,
                                              ZXIC_UINT32 *p_lpm_cache_en,
                                              ZXIC_UINT32 *p_oam_cache_en,
                                              ZXIC_UINT32 *p_dir_cache_en);

DPP_STATUS dpp_se_smmu1_ser_cache_en1_cfg_set(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 hash_id3_cache_en,
                                              ZXIC_UINT32 hash_id2_cache_en,
                                              ZXIC_UINT32 hash_id1_cache_en,
                                              ZXIC_UINT32 hash_id0_cache_en);
DPP_STATUS dpp_se_smmu1_ser_cache_en1_cfg_get(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 *p_hash_id3_cache_en,
                                              ZXIC_UINT32 *p_hash_id2_cache_en,
                                              ZXIC_UINT32 *p_hash_id1_cache_en,
                                              ZXIC_UINT32 *p_hash_id0_cache_en);

DPP_STATUS dpp_se_smmu1_cpu_cache_fifo_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_se_smmu1_cpu_cache_fifo_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_smmu1_ser_cache_en2_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_se_smmu1_ser_cache_en2_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_smmu1_cache_age_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_se_smmu1_cache_age_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_smmu1_cache_width_sel_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_se_smmu1_cache_width_sel_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_smmu1_cache7_0_total_item_cnt_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_se_smmu1_cache7_0_to_rschd_rsp_cnt_prt(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_se_smmu1_init_alive_cnt_cfg_set(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 cache0_init_alive_cnt_cfg,
                                               ZXIC_UINT32 cache1_init_alive_cnt_cfg,
                                               ZXIC_UINT32 cache2_init_alive_cnt_cfg,
                                               ZXIC_UINT32 cache3_init_alive_cnt_cfg,
                                               ZXIC_UINT32 cache4_init_alive_cnt_cfg,
                                               ZXIC_UINT32 cache5_init_alive_cnt_cfg,
                                               ZXIC_UINT32 cache6_init_alive_cnt_cfg,
                                               ZXIC_UINT32 cache7_init_alive_cnt_cfg);
DPP_STATUS dpp_se_smmu1_init_alive_cnt_cfg_get(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 *p_cache0_init_alive_cnt,
                                               ZXIC_UINT32 *p_cache1_init_alive_cnt,
                                               ZXIC_UINT32 *p_cache2_init_alive_cnt,
                                               ZXIC_UINT32 *p_cache3_init_alive_cnt,
                                               ZXIC_UINT32 *p_cache4_init_alive_cnt,
                                               ZXIC_UINT32 *p_cache5_init_alive_cnt,
                                               ZXIC_UINT32 *p_cache6_init_alive_cnt,
                                               ZXIC_UINT32 *p_cache7_init_alive_cnt);

DPP_STATUS dpp_se_smmu0_odma_tdm_baddr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr);

DPP_STATUS dpp_se_smmu0_tm_stat_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_tm_stat_en);

DPP_STATUS dpp_se_smmu1_ind_write_debug_set(ZXIC_UINT32 enable);

DPP_STATUS dpp_se_smmu1_clr_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_gbl_init_en, ZXIC_UINT32 *p_clr_tbl_en);

DPP_STATUS dpp_se_smmu1_kschd_oam_sp_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_sp_en);

DPP_STATUS dpp_se_smmu1_kschd_oam_sp_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_oam_sp_en);

DPP_STATUS dpp_se_smmu1_cnt_stat_cache_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cache_en);

DPP_STATUS dpp_se_smmu1_dir_cache_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 dir_cache_en);

DPP_STATUS dpp_se_smmu1_cnt_stat_cache_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_stat_cache_en);

DPP_STATUS dpp_se_smmu1_cnt_stat_cache_clr(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_se_smmu1_cnt_stat_cache_req_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_data_h, ZXIC_UINT32 *p_data_l);

DPP_STATUS dpp_se_smmu1_cnt_stat_cache_hit_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_data_h, ZXIC_UINT32 *p_data_l);

DPP_STATUS dpp_se_smmu1_cfg_cache_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cache_en);

DPP_STATUS dpp_se_smmu1_cpu_w_arb_rdy_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 w_arb_rdy);

DPP_STATUS dpp_se_smmu1_cpu_w_arb_rdy_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_w_arb_rdy);

DPP_STATUS dpp_se_smmu1_dir_arbi_ser_rpful_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

DPP_STATUS dpp_se_cfg_wr_arbi_pful2_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 hash_wr_pful,ZXIC_UINT32 dir_wr_pful);

DPP_STATUS dpp_se_alg_lpm_ex_rsp_fifo_u0_pful_ast_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 lpm_fifo_pful);

DPP_STATUS dpp_se_lpm_ddr_base_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type, ZXIC_UINT32 *p_ddr_base);

DPP_STATUS dpp_se_kschd_as_ept_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_rschd_hash_ept_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

DPP_STATUS dpp_se_rschd_hash_ept_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_rschd_pbu_ept_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_rschd_pbu_ept_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

DPP_STATUS dpp_se_rschd_lpm_ept_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_rschd_etcam_ept_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

DPP_STATUS dpp_se_rschd_etcam_ept_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_rschd_dir_pful_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

DPP_STATUS dpp_se_rschd_dir_pful_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_rschd_dir_ept_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

DPP_STATUS dpp_se_rschd_dir_ept_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);

DPP_STATUS dpp_se_rschd_wr_rsp_vld_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 rsp_en);

DPP_STATUS dpp_se_as_dma_rdy_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_dma_rdy);

DPP_STATUS dpp_se_as_dbg_cnt_prt(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_se_alg_dbg_excp_cnt_prt(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_se_cnt_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 清零smmu0调试计数寄存�?
* @param   dev_id   设备�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  刘硕10181552      @date  2015/06/08
************************************************************/
DPP_STATUS dpp_se_smmu0_dbg_fc_cnt_clr(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 读取rschd中的微码写返�?
* @param   dev_id
* @param   rsp_en
*
* @return
* @remark  �?
* @see
* @author  徐晨�?      @date  2016/11/02
************************************************************/
DPP_STATUS dpp_se_rschd_wr_rsp_vld_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *rsp_en_value);

/***********************************************************/
/** fifo深度默认值配�?
* @param   dev_id   设备�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wll      @date  2019/08/01
************************************************************/
DPP_STATUS dpp_se_fifo_depth_val_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 读取SE查表请求排空状�?
* @param   dev_id        设备�?
* @param   p_empty_flag  �?8比特有效，每比特代表与PPU相连的查表端�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/06
************************************************************/

DPP_STATUS dpp_se_cfg_se_empty_get(ZXIC_UINT32 dev_id, DPP_SE_CFG_EPT_FLAG_T *p_empty_flag);

/***********************************************************/
/** 读取寄存器STAT_STAT_CFG_EPT_FLAGr
* @param   dev_id        设备号
* @param   p_empty_flag  低8比特有效，每比特代表与PPU相连的查表端口
*
* @return
* @remark  无
* @see
* @author  张天浩10345337     @date  2023/09/11
************************************************************/
DPP_STATUS dpp_stat_cfg_empty_get(ZXIC_UINT32 dev_id, DPP_STAT_STAT_CFG_EPT_FLAG_T *p_empty_flag);

/***********************************************************/
/** 设置SE与PPU相连查表端口的软复位
* @param   dev_id     设备�?
* @param   flag       软复位使能标�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/06
************************************************************/
DPP_STATUS dpp_se_cfg_ppu_soft_rst_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 flag);

/***********************************************************/
/** 获取sdt软复位需要的字节长度
* @param   dev_id   设备�?
* @param   p_size   
*
* @return  
* @remark  �?
* @see     
* @author  lim      @date  2020/06/06
************************************************************/
DPP_STATUS dpp_se_sdt_glb_size_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_size);

/***********************************************************/
/** 获取sdt软复位需要的参数信息
* @param   dev_id   设备�?
* @param   p_flag   释放使能�?1-需要手动free�?0-不需要手动free
* @param   p_size   数据大小
*
* @return  
* @remark  �?
* @see     
* @author  lim      @date  2020/06/06
************************************************************/
DPP_STATUS dpp_se_sdt_glb_mgr_get(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32* p_flag,
                                  ZXIC_UINT32* p_size);

/***********************************************************/
/** 还原sdt参数信息
* @param   dev_id       设备�?
*
* @return  
* @remark  �?
* @see     
* @author  lim      @date  2020/06/06
************************************************************/
DPP_STATUS dpp_se_sdt_glb_mgr_set(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 获取SMMU0初始化完成状�?
* @param   dev_id     设备�?
* @param   p_done     完成状�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2014/06/17
************************************************************/
DPP_STATUS dpp_se_smmu0_init_done_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_done);

/***********************************************************/
/** 获取lpm级联表信�?
* @param   dev_id           设备�?
* @param   table_id         lpm标号，取值范围[0,7]
* @param   mode             模式: 0-从软件缓存读取，1-从硬件读�?
* @param   p_lpm_as_mode    出参，级联位宽模式，参见ERAM128_TBL_MODE_E
* @param   p_lpm_as_baddr   出参，级联基地址�?128bit为单�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  lius      @date  2016/03/22
************************************************************/
DPP_STATUS dpp_se_smmu0_lpm_as_cfg_get(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 table_id,
                                       ZXIC_UINT32 mode,
                                       ZXIC_UINT32 *p_lpm_as_mode,
                                       ZXIC_UINT32 *p_lpm_as_baddr);

/***********************************************************/
/** 设置TM计数开启使�?
* @param   dev_id           设备�?
* @param   tm_stat_en       TM计数开启使能，0-未开启，1-开�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  lius      @date  2016/03/22
************************************************************/
DPP_STATUS dpp_se_smmu0_tm_stat_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 tm_stat_en);

/***********************************************************/
/** 配置car独享eram模式，car必须从block0开始，连续占用
* @param   dev_id     设备�?
* @param   mode       模式  0-不独占，1-独占1�?(�?0�?)�?2-独占2�?(�?0~1�?)
*
* @return
* @remark  �?
* @see
* @author  ls      @date  2016/03/17
************************************************************/
DPP_STATUS dpp_se_smmu0_cfg_car_mono_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode);

/***********************************************************/
/** 读取组播表项的内�?
* @param   dev_id       设备�?
* @param   mc_tbl_type  组播表项类型�?0-数据报文表，1-TDM报文表，参见SMMU0_MCAST_TBL_TYPE_E
* @param   group_id     组播索引id
* @param   p_data       传出的数�?,传出是数据组播报文，传入的数据类型为DATA_MCAST_T
*                       传出的是tdm报文，传出的数据类型�? TDM_MCAST_T
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2015/07/09
************************************************************/
DPP_STATUS dpp_se_smmu0_mcast_tbl_get(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 mc_tbl_type,
                                      ZXIC_UINT32 group_id,
                                      ZXIC_VOID *p_data);

/***********************************************************/
/** 配置Debug计数读模�?
* @param   dev_id         设备�?
* @param   rd_mode        读清模式: 0-不自动清0�?1-CPU读之后自动清�?
* @param   overflow_mode  溢出模式: 0-溢出后，保持最大值；1-溢出后最高比特保持不变，其余比特继续计数�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/07/28
************************************************************/
DPP_STATUS dpp_se_smmu0_dbg_cnt_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 rd_mode, ZXIC_UINT32 overflow_mode);

/***********************************************************/
/** 读取Debug计数读模�?
* @param   dev_id           设备�?
* @param   p_rd_mode        读清模式: 0-不自动清0�?1-CPU读之后自动清�?
* @param   p_overflow_mode  溢出模式: 0-溢出后，保持最大值；1-溢出后最高比特保持不变，其余比特继续计数�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/07/28
************************************************************/
DPP_STATUS dpp_se_smmu0_dbg_cnt_mode_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_rd_mode, ZXIC_UINT32 *p_overflow_mode);

/***********************************************************/
/** 获取smmu0 fifo 排空状�?
* @param   dev_id       设备�?
* @param   empty_type   fifo类型，取值参考SMMU0_EMPTY_TYPE_E的定�?
* @param   p_flag       状�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/06
************************************************************/
DPP_STATUS dpp_se_smmu0_empty_flag_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 empty_type, ZXIC_UINT32 *p_flag);

/***********************************************************/
/** 配置PPU软复位使�?
* @param   dev_id     设备�?
* @param   flag       复位使能: 0-不使能，1-使能
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2014/06/23
************************************************************/
DPP_STATUS dpp_se_smmu0_ppu_soft_rst_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 flag);

/***********************************************************/
/** 获取hash算法访问DDR空间的属性，从软件获�?(待优�?)
* @param   dev_id       设备�?
* @param   hash_id      hash引擎�?
* @param   bulk_id      Hash引擎存储资源划分块数的ID�?
* @param   p_ecc_en     使能ECC校验
* @param   p_base_addr  DDR空间基地址
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  tf      @date  2016/06/15
************************************************************/
DPP_STATUS dpp_se_smmu1_hash_tbl_soft_cfg_get(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 hash_id,
                                              ZXIC_UINT32 bulk_id,
                                              ZXIC_UINT32 *p_ecc_en,
                                              ZXIC_UINT32 *p_base_addr);

/***********************************************************/
/** 读取片外统计计数�?
* @param   dev_id           设备�?
* @param   base_addr        stat内部的统计值偏移地址，包含ppu计数偏移地址、oam计数偏移地址
* @param   rd_mode          读取位宽模式�??膊渭? CMMU_RD_OPR_MODE_E�?1-32bit�?2-64bit�?3-128bit
* @param   clr_mode         读清模式。参见CMMU_RD_CLR_MODE_E�?0-不读清，1-读清
* @param   index            索引值，与rd_mode相关�?
* @param   p_data           出参，读取的�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/07/12
************************************************************/
DPP_STATUS dpp_se_cmmu_ddr_read(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 base_addr,
                                ZXIC_UINT32 rd_mode,
                                ZXIC_UINT32 clr_mode,
                                ZXIC_UINT32 index,
                                ZXIC_UINT32 *p_data);

/***********************************************************/
/** 设置片外统计计数值 64bit
* @param   dev_id           设备号
* @param   base_addr        stat内部的统计值偏移地址，包含ppu计数偏移地址、oam计数偏移地址
* @param   index            索引值，与rd_mode相关联
* @param   p_data           出参，读取的值
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  ls      @date  2016/07/12
************************************************************/
DPP_STATUS dpp_se_cmmu_ddr_write(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 base_addr,
                                ZXIC_UINT32 index,
                                ZXIC_UINT32 *p_data);

/***********************************************************/
/** ddr固定空间清零
* 分段初始化使能，必须在cfg_init_en�?0的情况下使用。使能信号被拉高�?
* 一直保持高电平，下次再进行初始化使能寄存器必须先清零，再拉高�?
* @param   dev_id       设备�?
* @param   start_addr   开始地址, �?30bit, �?128bit为单�?
* @param   end_addr     结束地址, �?30bit, �?128bit为单�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2015/05/05
************************************************************/
DPP_STATUS dpp_se_smmu1_clr_addr(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 start_addr,
                                 ZXIC_UINT32 end_addr);

/***********************************************************/
/** 设置lpm级联表信�?
* @param   dev_id           设备�?
* @param   table_id         级联表号
* @param   lpm_as_mode      级联模式，参见ERAM128_TBL_MODE_E
* @param   lpm_as_baddr     级联基地址，以128bit为单�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  刘硕10181552      @date  2016/03/17
************************************************************/
DPP_STATUS dpp_se_smmu0_lpm_as_cfg_set(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 table_id,
                                       ZXIC_UINT32 lpm_as_mode,
                                       ZXIC_UINT32 lpm_as_baddr);

/***********************************************************/
/** 配置DMA BD表基地址
* @param   dev_id      设备�?
* @param   base_addr   基地址，以128bit为单�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2014/06/23
************************************************************/
DPP_STATUS dpp_se_smmu0_dma_baddr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr);

/***********************************************************/
/** 配置odam保序计数的基地址
* @param   dev_id     设备�?
* @param   no         ODMA保序计数编号，取值范�?0~2
* @param   base_addr  基地址，以128bit为单�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2014/06/23
************************************************************/
DPP_STATUS dpp_se_smmu0_odma_baddr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 no, ZXIC_UINT32 base_addr);


/***********************************************************/
/** 配置SA/TDM组播复制成员表基地址
* @param   dev_id     设备�?
* @param   base_addr  基地址，以128bit为单�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2014/06/23
************************************************************/
DPP_STATUS dpp_se_smmu0_mcast_baddr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr);

/***********************************************************/
/** 添加组播表项
* @param   dev_id           设备�?
* @param   valid            有效�?
* @param   mc_tbl_type      组播表项类型�?1-数据报文表，0-TDM报文�? 参考SMMU0_MCAST_TBL_TYPE_E
* @param   base_addr        基地址
* @param   group_id         组播索引id
* @param   p_data           传入的数�?,传入是数据组播报文，传入的数据类型为DATA_MCAST_T
*                           传入的是tdm报文，传入的数据类型�? TDM_MCAST_T
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2015/07/08
************************************************************/
DPP_STATUS dpp_se_smmu0_mcast_tbl_add(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 valid,
                                      ZXIC_UINT32 mc_tbl_type,
                                      ZXIC_UINT32 group_id,
                                      ZXIC_VOID *p_data);

/***********************************************************/
/** 删除组播表项
* @param   dev_id      设备�?
* @param   mc_tbl_type 表项类型 参考SMMU0_MCAST_TBL_TYPE_E
* @param   group_id    组播索引地址
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2015/07/08
************************************************************/
DPP_STATUS dpp_se_smmu0_mcast_tbl_del(ZXIC_UINT32 dev_id, ZXIC_UINT32 mc_tbl_type, ZXIC_UINT32 group_id);

/***********************************************************/
/** 查看单个hash引擎条目插入、更新、删除操作统计计�?
* @param   p_se_cfg  算法模块公共管理数据结构指针
* @param   fun_id    hash引擎�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/05/15
************************************************************/
DPP_STATUS dpp_hash_show_static(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 fun_id);


/***********************************************************/
/** 清空单个hash引擎条目插入和删除操作统计
* @param   p_se_cfg  算法模块公共管理数据结构指针
* @param   fun_id    hash引擎号
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cq      @date  2023/10/10
************************************************************/
DPP_STATUS dpp_hash_clear_static(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 fun_id);

/***********************************************************/
/** 打印软件中hash和业务表配置的情�?
* @param   p_se_cfg    算法模块公共管理数据结构指针
* @param   hash_id     hash引擎�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  tf      @date  2015/12/16
************************************************************/
DPP_STATUS dpp_hash_tbl_cfg_prt(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 fun_id);

/***********************************************************/
/** 查看前缀匹配路由填充�?
* @param   p_se_cfg  算法模块公共管理数据结构指针
* @param   id        前缀匹配路由业务ID，取值参照DPP_ROUTE_ID_E的定�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/10/09
************************************************************/
DPP_STATUS dpp_route_show_cfg(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 id);

/***********************************************************/
/** 前缀匹配路由调试查找函数，从硬件RAM中查�?
* @param   p_se_cfg  算法模块公共管理数据结构指针
* @param   id        前缀匹配路由业务ID，取值参照DPP_ROUTE_ID_E的定�?
* @param   p_entry   查找条目，查找时仅指定键值即�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/10/09
************************************************************/
DPP_STATUS dpp_route_hwdbg_search(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 id, ZXIC_VOID *p_entry);

/***********************************************************/
/** 按链表方式依次打印最长前缀匹配路由节点
* @param   p_se_cfg  算法模块公共管理数据结构指针
* @param   id        前缀匹配路由业务ID，取值参照DPP_ROUTE_ID_E的定�?
* @param   p_entry   查找起始节点条目，仅键值有效即可，数据类型由id决定，DPP_ROUTE_ENTRY_IPV4_T或者DPP_ROUTE_ENTRY_IPV6_T
* @param   show_cnt  从起始节点往后需要输出的路由节点个数，包含起始节�?
* @param   p_out     输出路由节点缓存，输出的首节点为起始节点，数据类型由id决定，DPP_ROUTE_ENTRY_IPV4_T或者DPP_ROUTE_ENTRY_IPV6_T
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/10/16
************************************************************/
DPP_STATUS dpp_route_show_key(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 id, ZXIC_VOID *p_entry, ZXIC_UINT32 show_cnt, ZXIC_VOID *p_out);

/***********************************************************/
/** LPM内部调试接口，回收共享资�?
* @param   p_se_cfg
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2017/02/23
************************************************************/
DPP_STATUS dpp_route_resource_destroy(DPP_SE_CFG *p_se_cfg);

/***********************************************************/
/** LPM内部调试接口，回收引擎独占资�?
* @param   p_se_cfg
* @param   id
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2017/02/23
************************************************************/
DPP_STATUS dpp_route_destroy(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 id);

/***********************************************************/
/** CPU软复位路由需要缓存大小获取接�?
* @param   dev_id     设备�?
* @param   p_se_cfg   算法模块公共管理数据结构指针
* @param   p_size     缓存大小，以字节为单�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2017/07/07
************************************************************/
DPP_STATUS dpp_route_glb_size_get(ZXIC_UINT32 dev_id, DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 *p_size);

/***********************************************************/
/** CPU软复位路由数据备份接�?
* @param   dev_id       设备�?
* @param   p_flag       释放pp_data_buff的标记，0-无需释放�?1-需要释�?
* @param   p_size       信息长度，以字节为单�?
* @param   pp_data_buff 信息内容
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2017/5/22
************************************************************/
DPP_STATUS dpp_route_glb_mgr_backup(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 *p_flag, ZXIC_UINT32 *p_size, ZXIC_UINT8 **pp_data_buff);

/***********************************************************/
/** 备份路由动态占用缓存部�?
* @param   p_se_cfg
* @param   p_flag
* @param   p_size
* @param   pp_data_buff
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2017/07/13
************************************************************/
DPP_STATUS dpp_route_dynamic_trie_backup(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 *p_flag, ZXIC_UINT32 *p_size, ZXIC_UINT8 **pp_data_buff);

/***********************************************************/
/** CPU软复位路由数据恢复接�?
* @param   dev_id       设备�?
* @param   size         信息长度，以字节为单�?
* @param   p_data_buff  信息内容
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2017/5/22
************************************************************/
DPP_STATUS dpp_route_glb_mgr_recovery(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 size, ZXIC_UINT8 *p_data_buff);

#if ZXIC_REAL("se interrupt function")
/***********************************************************/
/** 获取SMMU0保序FIFO写满读空中断状�?
* @param   dev_id        设备�?
* @param   p_smmu0_int0  中断状态指�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/10
************************************************************/
DPP_STATUS dpp_se_smmu0_int0_status_get(ZXIC_UINT32 dev_id, DPP_SE_SMMU0_INT0_T *p_smmu0_int0);


/***********************************************************/
/** 打印SMMU0保序FIFO写满读空中断状�?
* @param   dev_id  设备�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/10
************************************************************/
DPP_STATUS dpp_se_smmu0_int0_status_print(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 打印SMMU0保序模块FIFO空信号
* @param   dev_id  设备号
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/09/19
************************************************************/
DPP_STATUS dpp_se_smmu0_ord_fifo_empty_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 设置etcam控制器中断使�?
* @param   dev_id      设备�?
* @param   p_intr_en   中断使能结构体指�? 18bits
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  如某bit�?1代表该中断关心，可产生中�?
* @see
* @author  xjw      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_etcam_intr_en_set(ZXIC_UINT32 dev_id, DPP_ETCAM_INTR_T *p_intr_en);

/***********************************************************/
/** 获得etcam控制器中断使�?
* @param   dev_id    设备�?
* @param   p_intr_en 中断使能结构体指�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  xjw      @date  2015/02/13
************************************************************/
DPP_STATUS dpp_etcam_intr_en_get(ZXIC_UINT32 dev_id, DPP_ETCAM_INTR_T *p_intr_en);

/***********************************************************/
/** 设置etcam控制器中断使能mask
* @param   dev_id      设备�?
* @param   p_intr_mask 中断使能mask 18bits
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  如某bit�?1，代表该中断不再产生中断
* @see
* @author  xjw      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_etcam_intr_mask_set(ZXIC_UINT32 dev_id, DPP_ETCAM_INTR_T *p_intr_mask);

/***********************************************************/
/** 获得当前etcam控制器中断使能mask
* @param   dev_id      设备�?
* @param   p_intr_mask 中断使能mask结构体指�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  xjw      @date  2015/02/13
************************************************************/
DPP_STATUS dpp_etcam_intr_mask_get(ZXIC_UINT32 dev_id, DPP_ETCAM_INTR_T *p_intr_mask);

/***********************************************************/
/** 获得etcam中断寄存器状�?
* @param   dev_id        设备�?
* @param   p_intr_status 中断寄存�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  xjw      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_etcam_intr_status_get(ZXIC_UINT32 dev_id, DPP_ETCAM_INTR_T *p_intr_status);

/***********************************************************/
/** 打印etcam中断寄存器状�?
* @param   dev_id  设备�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  xjw      @date  2015/02/13
************************************************************/
DPP_STATUS dpp_etcam_intr_status_show(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 读取SE模块总的状�?
* @param   dev_id        设备�?
* @param   p_int_status  中断状态，每比特代表一种中断情�?
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/06
************************************************************/
DPP_STATUS dpp_se_cfg_se_brief_int_status_get(ZXIC_UINT32 dev_id, DPP_SE_INT_STATUS_T *p_se_int_status);

/***********************************************************/
/** SE ALG模块对外总中断状�?
* @param   dev_id               设备�?
* @param   p_brief_int_status   ALG模块总中断状�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  刘硕10181552      @date  2016/02/01
************************************************************/
DPP_STATUS dpp_se_alg_brief_int_status_get(ZXIC_UINT32 dev_id,
                                           DPP_SE_ALG_BRIEF_INT_T *p_brief_int_status);
/***********************************************************/
/** SE SMMU0模块总的中断状�?
* @param   dev_id               设备�?
* @param   p_brief_int_status   SMMU0总的中断状�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  刘硕10181552      @date  2016/02/01
************************************************************/
DPP_STATUS dpp_se_smmu0_brief_int_status_get(ZXIC_UINT32 dev_id,
                                             DPP_SMMU0_BRIEF_INT_T *p_brief_int_status);
/***********************************************************/
/** 设置关联查找(AS)模块的中断使�?
* @param   dev_id     设备�?
* @param   p_int_en   中断使能，每比特代表一种中断情�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_as_int_en_set(ZXIC_UINT32 dev_id, DPP_SE_AS_INT_T *p_int_en);


/***********************************************************/
/** 读取关联查找(AS)模块的中断使�?
* @param   dev_id     设备�?
* @param   p_int_en   中断使能，每比特代表一种中断情�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_as_int_en_get(ZXIC_UINT32 dev_id, DPP_SE_AS_INT_T *p_int_en);


/***********************************************************/
/** 设置关联查找(AS)模块的中断掩�?
* @param   dev_id      设备�?
* @param   p_int_mask  中断掩码，每比特代表一种中断情�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_as_int_mask_set(ZXIC_UINT32 dev_id, DPP_SE_AS_INT_T *p_int_mask);


/***********************************************************/
/** 读取关联查找(AS)模块的中断掩�?
* @param   dev_id      设备�?
* @param   p_int_mask  中断掩码，每比特代表一种中断情�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_as_int_mask_get(ZXIC_UINT32 dev_id, DPP_SE_AS_INT_T *p_int_mask);


/***********************************************************/
/** 读取关联查找(AS)模块的中断状�?
* @param   dev_id        设备�?
* @param   p_int_status  中断状�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_as_int_status_get(ZXIC_UINT32 dev_id, DPP_SE_AS_INT_T *p_int_status);


/***********************************************************/
/** 打印关联查找(AS)模块的中断状�?
* @param   dev_id  设备�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/15
************************************************************/
DPP_STATUS dpp_se_cfg_as_int_status_print(ZXIC_UINT32 dev_id);


/***********************************************************/
/** 配置几乎满水位etcam_pful_cfg
* @param   dev_id           设备号，支持多芯片  
* @param   etcam_pful_cfg   几乎满水位
*
* @return  
* @remark  无
* @see     
* @author  张天浩10345337      @date  2024/01/12
************************************************************/
ZXIC_UINT32 dpp_se_as_etcam_pful_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 etcam_pful_cfg);


/***********************************************************/
/** 获取几乎满水位etcam_pful_cfg
* @param   dev_id           设备号，支持多芯片  
* @param   etcam_pful_cfg   几乎满水位
*
* @return  
* @remark  无
* @see     
* @author  张天浩10345337      @date  2024/01/12
************************************************************/
ZXIC_UINT32 dpp_se_as_etcam_pful_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_etcam_pful_cfg);


/***********************************************************/
/** 打印几乎满水位etcam_pful_cfg数据
* @param   dev_id             设备号，支持多芯片
*
* @return  
* @remark  无
* @see     
* @author  张天浩10345337      @date  2024/01/12
************************************************************/
DPP_STATUS dpp_se_as_etcam_pful_cfg_prt(ZXIC_UINT32 dev_id);


/***********************************************************/
/** 设置KEY键值调�?(KSCHD)模块的中断使�?
* @param   dev_id                设备�?
* @param   p_se_kschd_int_en     中断使能
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_kschd_int_en_set(ZXIC_UINT32 dev_id, DPP_SE_KSCHD_INT_T *p_se_kschd_int_en);

/***********************************************************/
/** 读取KEY键值调�?(KSCHD)模块的中断使�?
* @param   dev_id              设备�?
* @param   p_se_kschd_int_en   中断使能
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_kschd_int_en_get(ZXIC_UINT32 dev_id, DPP_SE_KSCHD_INT_T *p_se_kschd_int_en);

/***********************************************************/
/** 设置KEY键值调�?(KSCHD)模块的中断掩�?
* @param   dev_id                设备�?
* @param   p_se_kschd_int_mask   中断掩码
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_kschd_int_mask_set(ZXIC_UINT32 dev_id, DPP_SE_KSCHD_INT_T *p_se_kschd_int_mask);

/***********************************************************/
/** 读取KEY键值调�?(KSCHD)模块的中断掩�?
* @param   dev_id               设备�?
* @param   p_se_kschd_int_mask  中断掩码
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_kschd_int_mask_get(ZXIC_UINT32 dev_id, DPP_SE_KSCHD_INT_T *p_se_kschd_int_mask);

/***********************************************************/
/** 读取KEY键值调�?(KSCHD)模块的中断状�?
* @param   dev_id                   设备�?
* @param   p_se_kschd_int_status    中断状�?
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_kschd_int_status_get(ZXIC_UINT32 dev_id, DPP_SE_KSCHD_INT_T *p_se_kschd_int_status);

/***********************************************************/
/** 设置RSP结果调度(RSCHD)模块的中断使�?
* @param   dev_id                设备�?
* @param   p_se_rschd_int_en     中断使能
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_rschd_int_en_set(ZXIC_UINT32 dev_id, DPP_SE_RSCHD_INT_T *p_se_rschd_int_en);

/***********************************************************/
/** 读取结果调度(RSCHD)模块的中断使�?
* @param   dev_id               设备�?
* @param   p_se_rschd_int_en    中断使能
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_rschd_int_en_get(ZXIC_UINT32 dev_id, DPP_SE_RSCHD_INT_T *p_se_rschd_int_en);

/***********************************************************/
/** 设置结果调度(RSCHD)模块的中断掩�?
* @param   dev_id                设备�?
* @param   p_se_rschd_int_mask   中断掩码
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_rschd_int_mask_set(ZXIC_UINT32 dev_id, DPP_SE_RSCHD_INT_T *p_se_rschd_int_mask);

/***********************************************************/
/** 读取结果调度(RSCHD)模块的中断掩�?
* @param   dev_id               设备�?
* @param   p_se_rschd_int_mask  中断掩码
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_rschd_int_mask_get(ZXIC_UINT32 dev_id, DPP_SE_RSCHD_INT_T *p_se_rschd_int_mask);

/***********************************************************/
/** 读取结果调度(RSCHD)模块的中断状�?
* @param   dev_id                 设备�?
* @param   p_se_rschd_int_status  中断掩码
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_rschd_int_status_get(ZXIC_UINT32 dev_id, DPP_SE_RSCHD_INT_T *p_se_rschd_int_status);

/***********************************************************/
/** 设置CMMU模块的中断使�?
* @param   dev_id                   设备�?
* @param   p_dpp_se_cmmu_int_en     中断使能
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_cmmu_int_en_set(ZXIC_UINT32 dev_id, DPP_SE_CMMU_INT_T *p_dpp_se_cmmu_int_en);

/***********************************************************/
/** 读取CMMU模块的中断使�?
* @param   dev_id                 设备�?
* @param   p_dpp_se_cmmu_int_en   中断使能
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_cmmu_int_en_get(ZXIC_UINT32 dev_id, DPP_SE_CMMU_INT_T *p_dpp_se_cmmu_int_en);

/***********************************************************/
/** 设置CMMU模块的中断掩�?
* @param   dev_id                   设备�?
* @param   p_dpp_se_cmmu_int_mask   中断掩码
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_cmmu_int_mask_set(ZXIC_UINT32 dev_id, DPP_SE_CMMU_INT_T *p_dpp_se_cmmu_int_mask);

/***********************************************************/
/** 读取CMMU模块的中断掩�?
* @param   dev_id                   设备�?
* @param   p_dpp_se_cmmu_int_mask   中断掩码
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_cmmu_int_mask_get(ZXIC_UINT32 dev_id, DPP_SE_CMMU_INT_T *p_dpp_se_cmmu_int_mask);

/***********************************************************/
/** 读取CMMU模块的中断状�?
* @param   dev_id                    设备�?
* @param   p_dpp_se_cmmu_int_status  中断状�?
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_cmmu_int_status_get(ZXIC_UINT32 dev_id, DPP_SE_CMMU_INT_T *p_dpp_se_cmmu_int_status);

/***********************************************************/
/** 设置SMMU1模块的中�?0使能
* @param   dev_id                设备�?
* @param   p_se_smmu1_int_en     中断使能
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_smmu1_int_en_set(ZXIC_UINT32 dev_id, DPP_SE_SMMU1_INT_T *p_se_smmu1_int_en);

/***********************************************************/
/** 读取SMMU1模块的中�?0使能
* @param   dev_id               设备�?
* @param   p_se_smmu1_int_en    中断使能
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_se_cfg_smmu1_int_en_get(ZXIC_UINT32 dev_id, DPP_SE_SMMU1_INT_T *p_se_smmu1_int_en);

/***********************************************************/
/** 设置SMMU1模块的中�?0掩码
* @param   dev_id                设备�?
* @param   p_se_smmu1_int_mask   中断掩码
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/06
************************************************************/
DPP_STATUS dpp_se_cfg_smmu1_int_mask_set(ZXIC_UINT32 dev_id, DPP_SE_SMMU1_INT_T *p_se_smmu1_int_mask);

/***********************************************************/
/** 读取SMMU1模块的中�?0掩码
* @param   dev_id               设备�?
* @param   p_se_smmu1_int_mask  中断掩码
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/06
************************************************************/
DPP_STATUS dpp_se_cfg_smmu1_int_mask_get(ZXIC_UINT32 dev_id, DPP_SE_SMMU1_INT_T *p_se_smmu1_int_mask);

/***********************************************************/
/** 读取SMMU1模块的中�?0状�?
* @param   dev_id                设备�?
* @param   p_se_smmu1_int_status 中断状�?
*
* @return
* @remark  �?
* @see
* @author  wcl      @date  2015/02/06
************************************************************/
DPP_STATUS dpp_se_cfg_smmu1_int_status_get(ZXIC_UINT32 dev_id, DPP_SE_SMMU1_INT_T *p_se_smmu1_int_status);


/***********************************************************/
/** 设置alg模块中断使能
* @param   device
* @param   p_dpp_se_alg_int_en
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/12
************************************************************/
DPP_STATUS dpp_se_alg_int_en_set(ZXIC_UINT32 dev_id, DPP_SE_ALG_INT_T *p_dpp_se_alg_int_en);

/***********************************************************/
/** 获取alg模块中断使能
* @param   device
* @param   p_dpp_se_alg_int_en
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/12
************************************************************/
DPP_STATUS dpp_se_alg_int_en_get(ZXIC_UINT32 dev_id, DPP_SE_ALG_INT_T *p_dpp_se_alg_int_en);

/***********************************************************/
/** 设置alg模块中断掩码
* @param   device
* @param   p_dpp_se_alg_int_mask
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/12
************************************************************/
DPP_STATUS dpp_se_alg_int_mask_set(ZXIC_UINT32 dev_id, DPP_SE_ALG_INT_T *p_dpp_se_alg_int_mask);

/***********************************************************/
/** 获取alg模块中断掩码
* @param   device
* @param   p_dpp_se_alg_int_mask
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/12
************************************************************/
DPP_STATUS dpp_se_alg_int_mask_get(ZXIC_UINT32 dev_id, DPP_SE_ALG_INT_T *p_dpp_se_alg_int_mask);

/***********************************************************/
/** 获取alg模块的中断状�?
* @param   dev_id
* @param   p_dpp_se_alg_int_status
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/13
************************************************************/
DPP_STATUS dpp_se_alg_int_status_get(ZXIC_UINT32 dev_id, DPP_SE_ALG_INT_T *p_dpp_se_alg_int_status);

/***********************************************************/
/** SMMU0的中断使能设�?
* @param   dev_id                   设备�?
* @param   p_dpp_se_smmu0_int_en    SMMU0中断状�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/11
************************************************************/
DPP_STATUS dpp_se_smmu0_int_en_set(ZXIC_UINT32 dev_id,
                                   DPP_SE_SMMU0_INT_T *p_dpp_se_smmu0_int_en);
/***********************************************************/
/**  获取SMMU0的中断使�?
* @param   dev_id
* @param   p_dpp_se_smmu0_int_en
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/11
************************************************************/
DPP_STATUS dpp_se_smmu0_int_en_get(ZXIC_UINT32 dev_id,
                                   DPP_SE_SMMU0_INT_T *p_dpp_se_smmu0_int_en);
/***********************************************************/
/** 配置SMMU0中断掩码
* @param   dev_id
* @param   p_dpp_se_smmu0_int_mask
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  INT8_MASK还未开�?
* @see
* @author  ls      @date  2016/01/12
************************************************************/
DPP_STATUS dpp_se_smmu0_int_mask_set(ZXIC_UINT32 dev_id,
                                     DPP_SE_SMMU0_INT_T *p_dpp_se_smmu0_int_mask);
/***********************************************************/
/** 获取SMMU0 中断掩码状�?
* @param   dev_id
* @param   p_dpp_se_smmu0_int_mask
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  INT8 暂未打开
* @see
* @author  ls      @date  2016/01/12
************************************************************/
DPP_STATUS dpp_se_smmu0_int_mask_get(ZXIC_UINT32 dev_id,
                                     DPP_SE_SMMU0_INT_T *p_dpp_se_smmu0_int_mask);
/***********************************************************/
/** 获取SMMU0的中断状�?
* @param   dev_id
* @param   p_dpp_se_smmu0_int_status
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/12
************************************************************/
DPP_STATUS dpp_se_smmu0_int_status_get(ZXIC_UINT32 dev_id,
                                       DPP_SE_SMMU0_INT_T *p_dpp_se_smmu0_int_status);
/***********************************************************/
/** 配置SE解析模块中断使能
* @param   dev_id               设备�?
* @param   p_se_parse_int_en    SE解析模块中断使能信息
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/16
************************************************************/
DPP_STATUS dpp_se_cfg_parse_int_en_set(ZXIC_UINT32 dev_id, DPP_SE_PARSER_INT_T *p_se_parse_int_en);

/***********************************************************/
/** 获取SE解析模块中断使能
* @param   dev_id               设备�?
* @param   p_se_parse_int_en    SE解析模块中断使能信息
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/16
************************************************************/
DPP_STATUS dpp_se_cfg_parse_int_en_get(ZXIC_UINT32 dev_id, DPP_SE_PARSER_INT_T *p_se_parse_int_en);

/***********************************************************/
/** 配置SE解析模块中断掩码
* @param   dev_id                   设备�?
* @param   p_se_parse_int_mask      SE解析模块中断掩码信息
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/16
************************************************************/
DPP_STATUS dpp_se_cfg_parse_int_mask_set(ZXIC_UINT32 dev_id, DPP_SE_PARSER_INT_T *p_se_parse_int_mask);

/***********************************************************/
/** 获取SE解析模块中断掩码
* @param   dev_id                   设备�?
* @param   p_se_parse_int_mask      SE解析模块中断掩码信息
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/16
************************************************************/
DPP_STATUS dpp_se_cfg_parse_int_mask_get(ZXIC_UINT32 dev_id, DPP_SE_PARSER_INT_T *p_se_parse_int_mask);

/***********************************************************/
/** 获取SE解析模块中断状�?
* @param   dev_id                   设备�?
* @param   p_se_parse_int_status    SE解析模块中断使能状�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  ls      @date  2016/01/16
************************************************************/
DPP_STATUS dpp_se_cfg_parse_int_status_get(ZXIC_UINT32 dev_id, DPP_SE_PARSER_INT_T *p_se_parse_int_status);

/***********************************************************/
/** 设置stat控制器中断使�?
* @param   dev_id      设备�?
* @param   p_intr_en   中断使能结构体指�? 18bits
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  如某bit�?1代表该中断关心，可产生中�?
* @see
* @author  xjw      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_se_stat_int_en_set(ZXIC_UINT32 dev_id, DPP_SE_STAT_INT_T *p_dpp_se_stat_int_en);

/***********************************************************/
/** 获得stat控制器中断使�?
* @param   dev_id    设备�?
* @param   p_intr_en 中断使能结构体指�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  xjw      @date  2015/02/13
************************************************************/
DPP_STATUS dpp_se_stat_int_en_get(ZXIC_UINT32 dev_id, DPP_SE_STAT_INT_T *p_dpp_se_stat_int_en);

/***********************************************************/
/** 设置stat控制器中断使能mask
* @param   dev_id      设备�?
* @param   p_intr_mask 中断使能mask 18bits
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  如某bit�?1，代表该中断不再产生中断
* @see
* @author  xjw      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_se_stat_int_mask_set(ZXIC_UINT32 dev_id, DPP_SE_STAT_INT_T *p_dpp_se_stat_int_mask);

/***********************************************************/
/** 获得当前stat控制器中断使能mask
* @param   dev_id      设备�?
* @param   p_intr_mask 中断使能mask结构体指�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  xjw      @date  2015/02/13
************************************************************/
DPP_STATUS dpp_se_stat_int_mask_get(ZXIC_UINT32 dev_id, DPP_SE_STAT_INT_T *p_dpp_se_stat_int_mask);

/***********************************************************/
/** 获得stat中断寄存器状�?
* @param   dev_id        设备�?
* @param   p_intr_status 中断寄存�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  xjw      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_se_stat_int_status_get(ZXIC_UINT32 dev_id, DPP_SE_STAT_INT_T *p_dpp_se_stat_int_status);

/***********************************************************/
/** 根据eram模式换算为实际的表项长度
* @param   tbl_mode     
* @return  
* @remark  无
* @see
* @author  cq      @date  2024/09/27
************************************************************/
ZXIC_UINT32 dpp_smmu0_tbl_size_get(ZXIC_UINT32 eram_mode);

#endif

#if ZXIC_REAL("C600_call 地址映射相关函数")
/***********************************************************/
/** 初始化ddr bank使用状�?
* @param   dev_id
* @param
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  xcx     @date  2017/12/07
************************************************************/
DPP_STATUS dpp_se_ddr_used_state_map_init(ZXIC_UINT32 dev_id, SE_DDR_ADDR_MAP_INFO_T *se_ddr_map_info);

/***********************************************************/
/** SE地址映射函数，外部的连续地址映射为真实的物理地址
* @param   dev_id
* @param   virtual_baddr  虚拟地址
* @param   physical_baddr 真实物理地址
* @param   map_flag       SE_DDR_MAP_FLAG_E    0-vir2phy 1-phy2vir
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  xcx     @date  2017/12/07
************************************************************/
DPP_STATUS dpp_se_smmu1_vir_phy_baddr_map(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 *virtual_baddr,
                                          ZXIC_UINT32 *physical_baddr,
                                          ZXIC_UINT32 map_flag);

/***********************************************************/
/** SE地址映射函数，外部的连续bank映射为真实的物理bank
* @param   dev_id
* @param   map_info     SMMU1_DDR_ADDR_MAP_INFO_T
* @param   virtual_bank   虚拟bank,数组
* @param   conv_bank_num  需要转换的bank数量
* @param   physical_bank  真实物理bank，数�?
* @param   map_flag       0-vir2phy 1-phy2vir
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  xcx     @date  2017/12/07
************************************************************/
DPP_STATUS dpp_se_smmu1_vir_phy_bank_map(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 *virtual_bank,
                                         ZXIC_UINT32 conv_bank_num,
                                         ZXIC_UINT32 *physical_bank,
                                         ZXIC_UINT32 map_flag);

/***********************************************************/
/** 读取smmu1的表项复制信�?
* @param   dev_id               设备�?
* @param   tbl_type             表项使用类型，参见SMMU1_DDR_TBL_TYPE_E
* @param   tbl_id               表项索引号，使用的范围和意义参照入参tbl_type，具体规则如�?:
*                                   当表项使用类型为直接表时，索引范围为[0,255]，即sdt号；
*                                   当表项使用类型为HASH表时，索引范围为[0,31]�? 即hash�?32张表;
*                                   当表项使用类型为LPM表时�? 索引范围为[0,3],   �?0-lpm_v4,1-lpm_v6,2-lpm_v4_as,3-lpm_v6_as
*                                   当表项使用类型为其余表项时，此索引值不用关�?
* @param   p_undir_share_type   出参，表示非直接表时，共享模式，参见SMMU1_DDR_SHARE_MODE_E
* @param   p_vir_bank_info      出参，表示复制bank编号，深度为30数组
* @param   p_bank_num           出参，表示bank复制份数，最�?30�?
* @param   p_rr_sate            出参，表示当前的bank轮询状态，非直接表无效
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  xcx      @date  2017/12/15
************************************************************/
DPP_STATUS dpp_se_smmu1_phy2vir_bank_info_read(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 tbl_type,
                                               ZXIC_UINT32 tbl_id,
                                               ZXIC_UINT32 *p_undir_share_type,
                                               ZXIC_UINT32 *p_vir_bank_info,
                                               ZXIC_UINT32 *p_bank_num,
                                               ZXIC_UINT32 *p_rr_sate);

/***********************************************************/
/** 写ddr3数据
* @param   dev_id               设备�?
* @param   tbl_type             表项使用类型，参见SMMU1_DDR_TBL_TYPE_E
* @param   tbl_id               表项索引号，使用的范围和意义参照入参tbl_type，具体规则如�?:
*                                   当表项使用类型为直接表时，索引范围为[0,255]，即sdt号；
*                                   当表项使用类型为HASH表时，索引范围为[0,31]�? 即hash�?32张表;
*                                   当表项使用类型为LPM表时�? 索引范围为[0,3],   �?0-lpm_v4,1-lpm_v6,2-lpm_v4_as,3-lpm_v6_as
*                                   当表项使用类型为其余表项时，此索引值不用关�?
* @param   dir_tbl_base_addr    仅直接表使用，直接表表项基地址，开启复制模式时以bank内地址计算，以4k*128bit为单�?
* @param   tbl_wr_mode          仅直接表/HASH/LPM表使用，参见SMMU1_DDR_WRT_MODE_E
* @param   dir_tbl_ecc_en       仅直接表使用，直接表ecc使能
* @param   index                索引
* @param   p_data               写入的数�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  xcx      @date  2017/12/15
************************************************************/
DPP_STATUS dpp_se_smmu1_vir2phy_data_ind_write(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 tbl_type,
                                               ZXIC_UINT32 tbl_id,
                                               ZXIC_UINT32 vir_dir_tbl_baddr,
                                               ZXIC_UINT32 tbl_wr_mode,
                                               ZXIC_UINT32 dir_tbl_ecc_en,
                                               ZXIC_UINT32 index,
                                               ZXIC_UINT32 *p_data);

/***********************************************************/
/** DPP smmu1数据读取(仅支�?256bit);
* @param   dev_id       设备�?
* @param   base_addr    基地址�?2K*256bit
* @param   index        索引�?(256bit);
* @param   p_data       出参，传出数�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  xcx      @date  2017/12/15
************************************************************/
DPP_STATUS dpp_se_smmu1_vir2phy_data_ind_read(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 vir_base_addr,
                                              ZXIC_UINT32 index,
                                              ZXIC_UINT32 *p_data);

/***********************************************************/
/** 读取片外统计计数�?
* @param   dev_id           设备�?
* @param   base_addr        stat内部的统计值偏移地址，包含ppu计数偏移地址、oam计数偏移地址
* @param   rd_mode          读取位宽模式�??膊渭鸆MMU_RD_OPR_MODE_E�?0:64bit(29+35);,1-32bit�?2-64bit�?3-128bit
* @param   clr_mode         读清模式。参见CMMU_RD_CLR_MODE_E�?0-不读清，1-读清，不读清仅支�?128bit
* @param   index            索引值，与rd_mode相关�?
* @param   p_data           出参，读取的�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  xcx      @date  2017/12/15
************************************************************/
DPP_STATUS dpp_se_cmmu_vir2phy_ddr_read(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 vir_base_addr,
                                        ZXIC_UINT32 rd_mode,
                                        CMMU_RD_CLR_MODE_E clr_mode,
                                        ZXIC_UINT32 index,
                                        ZXIC_UINT32 *p_data);

/***********************************************************/
/** cmmu模块smmu1属性配�?
* @param   dev_id           设备�?
* @param   base_addr        基地址    2K * 256b为单位，需区分bank复制和bank不复�?
* @param   share_type       共享模式，参见SMMU1_DDR_SHARE_MODE_E
* @param   p_bank_info      复制信息
* @param   bank_num         复制份数
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  xcx      @date  2017/12/15
************************************************************/
DPP_STATUS dpp_se_cmmu_smmu1_vir2phy_cfg_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 vir_base_addr);

/***********************************************************/
/** cmmu模块smmu1属性获�?
* @param   dev_id
* @param   p_base_addr
* @param   p_share_type
* @param   p_bank_info
* @param   p_bank_num
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  xcx      @date  2017/12/15
************************************************************/
DPP_STATUS dpp_se_cmmu_smmu1_phy2vir_cfg_get(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 *p_vir_base_addr);

/***********************************************************/
/** 初始化单个hash引擎内的某个业务表，此接口支持为该业务表分配独占的zcell�?
*     必须先初始化hash引擎，再初始化业务表�?
* @param   p_se_cfg        算法模块公共管理数据结构指针
* @param   fun_id          hash引擎�?
* @param   bulk_id         每个Hash引擎资源划分的空间ID�?
* @param   p_ddr_resc_cfg  分配给hash引擎此资源空间的ddr资源属�?
* @param   zcell_num       分配给hash引擎此资源空间的zcell数量
* @param   zreg_num        分配给hash引擎此资源空间的zreg数量
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  xcx      @date  2017/12/15
************************************************************/
DPP_STATUS dpp_hash_vir2phy_bulk_init(DPP_SE_CFG *p_se_cfg,
                                      ZXIC_UINT32     fun_id,
                                      ZXIC_UINT32     bulk_id,
                                      DPP_HASH_DDR_RESC_CFG_T *p_vir_ddr_resc_cfg,
                                      ZXIC_UINT32     zcell_num,
                                      ZXIC_UINT32     zreg_num);

/***********************************************************/
/** 配置路由级联结果表属�?
* @param   p_se_cfg  算法管理数据结构指针
* @param   as_type   路由级联结果表类�?: 1-级联DDR, 0-级联eRam
* @param   tbl_id    级联结果表号，仅级联eRam模式下有效，取值范围[0,7],(通过vpnid�?3bit确定);�?
* @param   p_as_cfg  级联结果表配置属�?
*
* @return  NPE_OK-成功，NPE_ERR-失败
* @remark  �?
* @see
* @author  xcx      @date  2017/12/15
************************************************************/
DPP_STATUS dpp_route_vir2phy_as_rslttbl_set(DPP_SE_CFG *p_se_cfg,
                                            ZXIC_UINT32 as_type,
                                            ZXIC_UINT32 tbl_id,
                                            DPP_ROUTE_AS_RSLTTBL_U *p_vir_as_cfg);

/***********************************************************/
/** 初始化前缀匹配路由模块资源
* @param   p_se_cfg      算法模块公共管理数据结构指针
* @param   flags         前缀路由使能标志，bitmap方式使用，每比特的含义见"前缀路由业务初始化标�?"
* @param   p_resrc_info  为前缀路由分配的ZCAM和DDR3资源属�?
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  �?
* @see
* @author  xcx      @date  2017/12/15
************************************************************/
DPP_STATUS dpp_route_vir2phy_resource_init(DPP_SE_CFG *p_se_cfg,
                                           ZXIC_UINT32         flags,
                                           DPP_ROUTE_RESOURCE_T *p_vir_resrc_info);

DPP_STATUS dpp_se_cfg_ddr_key_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_se_cfg_hash_key_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_se_cfg_lpm_key_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_se_cfg_pbu_key_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_se_show_lpm_ver(void);

/***********************************************************/
/** 设置lpm数据下发模式
* @param   dev_id
* @param   
*
* @return
* @remark  �?
* @see
* @author        @date  2023/03/15
************************************************************/
ZXIC_VOID dpp_se_lpm_dat_wr_type_flag_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 lpm_dat_wr_type_flag);

/***********************************************************/
/** 获取lpm数据下发模式
* @param   dev_id
* @param   
*
* @return
* @remark  �?
* @see
* @author  xucx      @date  2014/09/30
************************************************************/
ZXIC_UINT32 dpp_se_lpm_dat_wr_type_flag_get(ZXIC_UINT32 dev_id);
/***********************************************************/
/** 将生成的lpm写硬件数据放到缓冲区
* @param   dev_id
* @param   
*
* @return
* @remark  �?
* @see
* @author  xucx      @date  2014/09/30
************************************************************/
ZXIC_UINT32 dpp_se_lpm_hw_dat_buf_wr(ZXIC_UINT32 dev_id, ZXIC_UINT32 dat_type, ZXIC_VOID* p_dat_struct_info);

/***********************************************************/
/** 设置lpm卸载标识
* @param   dev_id
* @param   lpm_uninstall_flag 0-不卸载流程 2：卸载流程
* @param   
*
* @return
* @remark  无
* @see
* @author  cq      @date  2024/07/22
************************************************************/
ZXIC_VOID dpp_se_lpm_uninstall_flag_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 lpm_uninstall_flag);

/***********************************************************/
/** 设置lpm卸载标识
* @param   dev_id
* @param   
*
* @return
* @remark  无
* @see
* @author  cq      @date  2024/07/22
************************************************************/
ZXIC_UINT32 dpp_se_lpm_uninstall_flag_get(ZXIC_UINT32 dev_id);
#endif


#endif

#ifdef __cplusplus
}
#endif

#endif
