/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_acl.h
* ļʶ : 
* ժҪ : 
* ˵ : 
* ǰ汾 : 
*      : 
*  : 2014/12/17
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/
#ifndef _DPP_ACL_H_
#define _DPP_ACL_H_

#define DPP_ACL_TBL_ID_MIN      (0)
#define DPP_ACL_TBL_ID_MAX      (7)
#define DPP_ACL_ETCAM_ID_MIN    (0)
#define DPP_ACL_ETCAM_ID_MAX    (0)

#define DPP_ACL_ENTRY_MAX_GET(key_mode, block_num) \
    ((block_num) * DPP_ETCAM_RAM_DEPTH * (1U<<(key_mode)))

#define DPP_ACL_AS_RSLT_SIZE_GET(mode) \
    (((mode)==DPP_ACL_AS_MODE_128b)?(128/8):(((mode)==DPP_ACL_AS_MODE_64b)?(64/8):(((mode)==DPP_ACL_AS_MODE_32b)?\
    (32/8):(((mode)==DPP_ACL_AS_MODE_16b)?(16/8):(0)))))

/** ڲԽӿʹ*/
#define DPP_ACL_AS_RSLT_SIZE_GET_EX(mode) (2U<<(mode))


/**  ACLҽλģʽ*/
typedef enum dpp_acl_as_mode_ex_e
{
    DPP_ACL_AS_MODE_EX_64b  = 1,  /**<  @brief 64bitλ*/
    DPP_ACL_AS_MODE_EX_128b = 2,  /**<  @brief 128bitλ*/
    DPP_ACL_AS_MODE_EX_256b = 3,  /**<  @brief 256bitλΪDDRʱЧ*/
    DPP_ACL_AS_MODE_EX_INVALID,
}DPP_ACL_AS_MODE_EX_E;

/***********************************************************/
/** ʼACLiIṹ
* @param   p_acl_cfg     ACLiIṹָ
* @param   p_client      ûԶiIָ룬ĿǰΪdev_idֵ
* @param   flags         ACLʼʹܱ־DPP_ACL_FLAG_ETCAM0_ENȵĶ
* @param   p_as_wrt_fun  GӲsصiָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  S
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS dpp_acl_cfg_init(DPP_ACL_CFG_T *p_acl_cfg,
                            ZXIC_VOID *p_client,
                            ZXIC_UINT32 flags,
                            ACL_AS_RSLT_WRT_FUNCTION p_as_wrt_fun);

/***********************************************************/
/** ȡACLýṹ
* @param   p_acl_cfg     ACLiIṹָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
************************************************************/
DPP_STATUS dpp_acl_cfg_get(ZXIC_UINT32 dev_id, DPP_ACL_CFG_EX_T **p_acl_cfg);

/***********************************************************/
/** ʼACLҵG?
* @param   p_acl_cfg   ACLiIṹָ
* @param   table_id    ҵţȡֵΧ0~15
* @param   as_enable   Ƿʹܹң0-ʹܣ1-ʹ
* @param   entry_num   Ŀi
* @param   key_mode    ֵλģʽȡֵDPP_ACL_KEY_MODE_EĶ
* @param   as_mode     λģʽȡֵDPP_ACL_AS_MODE_EĶ
* @param   block_num   ǰҵŵblockiĿ
* @param   p_block_idx ǰҵŵblocki
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  S
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS dpp_acl_tbl_init(DPP_ACL_CFG_T *p_acl_cfg,
                            ZXIC_UINT32 table_id,
                            ZXIC_UINT32 as_enable,
                            ZXIC_UINT32 entry_num,
                            DPP_ACL_KEY_MODE_E key_mode,
                            DPP_ACL_AS_MODE_E  as_mode,
                            ZXIC_UINT32 block_num,
                            ZXIC_UINT32 *p_block_idx);

/***********************************************************/
/** ԲACLĿûָhandle
* @param   p_acl_cfg    ACLiIṹָ
* @param   table_id     ҵ
* @param   p_acl_entry  ACLĿǽֵGG?
* @param   srh_mode     ģʽȡֵDPP_ACL_KEY_MODE_EĶ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  S
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS dpp_acl_tbl_search(DPP_ACL_CFG_T *p_acl_cfg, ZXIC_UINT32 table_id, DPP_ACL_ENTRY_T *p_acl_entry, ZXIC_UINT32 srh_mode);

/***********************************************************/
/** aclҵĿG²ֶ֧ȼģʽ?I⿪š
* @param   p_acl_cfg   ACLiIṹָ
* @param   table_id
* @param   acl_entry_array
* @param   acl_entry_num
*
* @return
* @remark  S
* @see
* @author  wcl      @date  2014/12/23
************************************************************/
DPP_STATUS dpp_acl_tbl_insert_ex(DPP_ACL_CFG_EX_T *p_acl_cfg, ZXIC_UINT32 table_id, DPP_ACL_ENTRY_EX_T *p_acl_entry_array, ZXIC_UINT32 acl_entry_num);


/***********************************************************/
/** ɾiaclҵĿֶ֧ȼģʽI⿪š
* @param   p_acl_cfg   ACLiIṹָ
* @param   table_id
* @param   acl_entry_array
* @param   acl_entry_num
*
* @return
* @remark  S
* @see
* @author  wcl      @date  2014/12/23
************************************************************/
DPP_STATUS dpp_acl_tbl_delete_ex(DPP_ACL_CFG_EX_T *p_acl_cfg, ZXIC_UINT32 table_id, DPP_ACL_ENTRY_EX_T *p_acl_entry_array, ZXIC_UINT32 acl_entry_num);

DPP_STATUS dpp_acl_handle_list_free(D_HEAD *p_handle_list);
DPP_STATUS dpp_acl_hdw_addr_get(DPP_ACL_TBL_CFG_T *p_tbl_cfg, ZXIC_UINT32 handle, ZXIC_UINT32 *p_block_idx, ZXIC_UINT32 *p_addr, ZXIC_UINT32 *p_wr_mask);
DPP_STATUS dpp_acl_hdw_addr_get_ex(DPP_ACL_TBL_CFG_T *p_tbl_cfg, ZXIC_UINT32 handle, ZXIC_UINT32 *p_block_idx, ZXIC_UINT32 *p_addr, ZXIC_UINT32 *p_wr_mask);
DPP_STATUS dpp_acl_tbl_as_ddr_write(ZXIC_UINT32 dev_id,ZXIC_UINT32 tbl_type,ZXIC_UINT32 tbl_id,ZXIC_UINT32 dir_tbl_share_type,ZXIC_UINT32 dir_tbl_base_addr, ZXIC_UINT32 ecc_en, ZXIC_UINT32 index, ZXIC_UINT32 as_mode, ZXIC_UINT8  *p_data);
DPP_STATUS dpp_acl_tbl_as_ddr_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index, ZXIC_UINT32 as_mode, ZXIC_UINT8 *p_data);

DPP_STATUS dpp_acl_glb_size_get(ZXIC_UINT32 dev_id, DPP_ACL_CFG_T *p_acl_cfg, ZXIC_UINT32 *p_size);
DPP_STATUS dpp_acl_glb_mgr_get(ZXIC_UINT32 dev_id, DPP_ACL_CFG_T *p_acl_cfg, ZXIC_UINT32 *p_flag, ZXIC_UINT32 *p_size, ZXIC_UINT8 **p_data_buff);
DPP_STATUS dpp_acl_glb_mgr_set(ZXIC_UINT32 dev_id, DPP_ACL_CFG_T *p_acl_cfg, ZXIC_UINT32 size, ZXIC_UINT8 *p_data_buff);
DPP_STATUS dpp_acl_tbl_cfg_print(ZXIC_UINT32 dev_id, ZXIC_UINT32 table_id, ZXIC_UINT32 ex_flag);
DPP_STATUS dpp_acl_block_info_print(ZXIC_UINT32 dev_id, ZXIC_UINT32 block_id, ZXIC_UINT32 ex_flag);
DPP_STATUS dpp_acl_res_destroy(ZXIC_UINT32 dev_id);
#endif



