/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_ddos_diag.h
* 文件标识 : 
* 内容摘要 : 
* 其它说明 : 
* 当前版本 : 
* 作    者 : cjc
* 完成日期 : 2016/01/18
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
* 修改记录1: 
* 修改日期:  
* 版 本 号:  
* 修 改 人:  
* 修改内容:  
***************************************************************/

#ifndef _DPP_TRPG_DIAG_H_
#define _DPP_TRPG_DIAG_H_

#include "dpp_ddos_api.h"

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************************/
/** DDOS DMA地址获取
* @param   dev_id  设备号 
* @param   oddEvenFlag 奇偶标志(0返回偶地址，1返回奇地址)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_dma_addr_get(ZXIC_UINT32 dev_id, DDOS_DMA_BUFF_ADDR_INFO* addr_info, ZXIC_UINT32 oddEvenFlag);

/***********************************************************/
/** DDOS DMA地址配置
* @param   dev_id  设备号 
* @param   oddEvenFlag 奇偶标志(0返回偶地址，1返回奇地址)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_dma_addr_set(ZXIC_UINT32 dev_id, DDOS_DMA_BUFF_ADDR_INFO addr_info, ZXIC_UINT32 oddEvenFlag);

/***********************************************************/
/** DDOS 根据统计表中的统计索引号进行上报阈值打印
* @param   dev_id     设备号 
* @param   statNo     统计索引号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_stat_dump_thrd_prt(ZXIC_UINT32 dev_id, DDOS_STAT_TABLE_STAT_INDEX statNo);

/***********************************************************/
/** DDOS 统计表上报阈值比较使能打印
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_stat_dump_thrd_compare_en_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 上报表项条目数量打印
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_dump_stat_num_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 偶HASH表基地址打印
* @param   dev_id   设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_even_hash_table_base_addr_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 奇HASH表基地址打印
* @param   dev_id   设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_odd_hash_table_base_addr_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 统计表索引在eRAM中的偏移地址打印
* @param   dev_id      设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_stat_index_eram_offset_addr_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 统计n个奇偶数秒打印
* @param   dev_id      设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_stat_ns_flag_cnt_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 偶统计表基地址打印
* @param   dev_id        设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_even_stat_table_base_addr_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 奇统计表基地址打印
* @param   dev_id        设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_odd_stat_table_base_addr_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 偶统计表DUMP目的地址打印
* @param   dev_id        设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_even_stat_dump_addr_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 奇统计表DUMP目的地址打印
* @param   dev_id        设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_odd_stat_dump_addr_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 工作模式使能打印
* @param   dev_id        设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_work_mode_en_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 删除统计表项长度打印
* @param   dev_id        设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_delete_stat_table_len_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 删除hash表项长度打印
* @param   dev_id        设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos_delete_hash_table_len_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 获取DDOS EPID配置信息
* @param   dev_id               芯片id
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 diag_dpp_ddos_dump_host_epid_ptr(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 按索引打印DDOS DUMP信息
* @param   dev_id               芯片id
* @param   index                dump_no
* @param   oddEvenFlag          奇偶标志
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 diag_dpp_ddos_dump_data_ptr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 oddEvenFlag);

/***********************************************************/
/** 打印DDOS DUMP信息
* @param   dev_id               芯片id
* @param   oddEvenFlag          奇偶标志位
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 diag_dpp_ddos_dump_data_all_ptr(ZXIC_UINT32 dev_id, ZXIC_UINT32 oddEvenFlag);

/***********************************************************/
/** DDOS 配置信息打印
* @param   dev_id        设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_ddos(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS HELP
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_help(ZXIC_UINT32 dev_id);

#ifdef __cplusplus
}
#endif

#endif