/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_log_diag.h
* 文件标识 : 
* 内容摘要 : 芯片log配置测试函数头文件
* 其它说明 : 
* 当前版本 : 
* 作    者 : chenqin00181032
* 完成日期 : 2023/04/11
* DEPARTMENT: 
* MANUAL_PERCENT: 100%    
***************************************************************/
#ifndef _DPP_LOG_DIAG_H_
#define _DPP_LOG_DIAG_H_

#include "zxic_common.h"

/***********************************************************/
/** 获取日志使能状态
* @param   
* @param      
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID diag_dpp_comm_get_log_en(ZXIC_VOID);

/***********************************************************/
/** 设置生成日志使能状态
* @param   log_en 1：使能  0：不使能  
* @param      
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID diag_dpp_comm_log_en_set(ZXIC_UINT32 log_en);

/***********************************************************/
/** 显示log类型
* @param    
* @param      
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID diag_dpp_comm_logtype_show(ZXIC_VOID);

/***********************************************************/
/** 设置对应日志类型使能状态
* @param   log_ftype log类型
* @param   en_flag 1：使能  0：不使能    
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID diag_dpp_comm_logtype_set(ZXIC_UINT32 log_ftype, ZXIC_UINT32 en_flag);

/***********************************************************/
/** 获取日志各类型状态  
* @param  
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID diag_dpp_comm_logtype_get(ZXIC_VOID);

/***********************************************************/
/** 设置日志时间开关  
* @param  enable 1：使能  0：不使能  
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID diag_dpp_comm_logtime_set(ZXIC_UINT32 enable);

/***********************************************************/
/** 获取日志时间开关  
* @param   
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID diag_dpp_comm_logtime_get(ZXIC_VOID);

/***********************************************************/
/** 按类型设置sdk日志文件上限大小
* @param   log_ftype 日志文件类型，取值详见ZXIC_LOG_FILE_TYPE_E
* @param   log_fsize 上限大小，以字节为单位，默认上限值为1Mbyte
* @return  
* @remark  无
* @see     
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID diag_dpp_comm_log_size_set(ZXIC_UINT32 log_ftype, ZXIC_UINT32 log_fsize);

/***********************************************************/
/** 设置打印开关，决定ZXIC_COMM_PRINT等调试打印函数是否输出到屏幕
* @param   enable  0-不打印到屏幕，1-打印到屏幕
*
* @return
* @remark  无
* @see
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID dpp_diag_comm_set_print_en(ZXIC_UINT32 enable);

/***********************************************************/
/** 获取打印开关
* @param   
*
* @return
* @remark  无
* @see
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID dpp_diag_comm_get_print_en(ZXIC_VOID);

/***********************************************************/
/** 设置Debug打印级别
* @param   debug_level 0打印级别最低，4打印级别最高，即打印的东西最多
*
* @return
* @remark  无
* @see
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID diag_dpp_comm_set_print_level(ZXIC_UINT32 debug_level);

/***********************************************************/
/** 获取Debug打印级别
* @param   ZXIC_VOID
*
* @return
* @remark  无
* @see
* @author  chenqin00181032      @date  2023/04/11
************************************************************/
ZXIC_VOID diag_dpp_comm_get_print_level(ZXIC_VOID);

#endif