/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_tm_diag.c
* 文件标识 :
* 内容摘要 :
* 其它说明 :
* 当前版本 :
* 作    者 : taq
* 完成日期 : 2016/01/26
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* 修改记录1:
* 修改日期:
* 版 本 号:
* 修 改 人:
* 修改内容:
***************************************************************/
#ifndef  _DPP_TM_DIAG_H_
#define  _DPP_TM_DIAG_H_



/******************************************************************************
 *                START: 头文件                                *
 *****************************************************************************/
#include "zxic_common.h"
#include "dpp_type_api.h"
#include "dpp_reg.h"
#include "dpp_tm_api.h"
#include "dpp_tm.h"


/******************************************************************************
 *                 END: 头文件                                 *
 *****************************************************************************/


#if ZXIC_REAL("TM_CFGMT")


#define MAX_LEVEL 5
#define SCHEDULER_TYPE_STR_NUM 9


/***********************************************************/
/** 打印block长度
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/20
************************************************************/
DPP_STATUS dpp_tm_cfgmt_blk_size_get_diag(ZXIC_UINT32 dev_id);


/***********************************************************/
/** 打印DPP初始化中部分配置信息
* @param   dev_id   设备编号
* @param
* @return
* @remark  无
* @see
* @author whuashan     @date  2020-3-17
************************************************************/
DPP_STATUS diag_dpp_tm_info(ZXIC_UINT32 dev_id);

#endif


#if ZXIC_REAL("TM_CGAVD")

/***********************************************************/
/** 打印cgavd模式
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   p_mode   0:block mode 1:byte mode
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/07/29
************************************************************/
DPP_STATUS dpp_tm_cgavd_cfg_mode_get_diag(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 批量配置各级拥塞避免算法
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   level   拥塞避免支持层次号，0:队列级，1:端口级，2:系统级
* @param   id_s   队列号或端口号起始值，系统级时，id参数无效
* @param   id_e   队列号或端口号终止值，系统级时，id参数无效
* @param   method  配置的拥塞避免算法，0:TD，1:WRED/GRED
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/06/19
************************************************************/
DPP_STATUS dpp_tm_cgavd_method_set_diag(ZXIC_UINT32 dev_id,
                                        DPP_TM_CGAVD_LEVEL_E level,
                                        ZXIC_UINT32 id_s,
                                        ZXIC_UINT32 id_e,
                                        DPP_TM_CGAVD_METHOD_E method);


/***********************************************************/
/** 读取拥塞避免算法
* @param   dev_id 设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   level   拥塞避免支持层次号，0:队列级，1:端口级，2:系统级
* @param   id   队列号或端口号,系统级时,id参数无效
* @return   DPP_OK-成功，DPP_ERR-失败
* @算法标识0:TD,1:WRED,2:GRED
* @remark  无
* @see
* @author  cy      @date  2016/06/24
************************************************************/
DPP_STATUS dpp_tm_cgavd_method_get_diag(ZXIC_UINT32 dev_id,
                                        DPP_TM_CGAVD_LEVEL_E level,
                                        ZXIC_UINT32 id);

/***********************************************************/
/** 获取配置CPU设置的报文长度是否参与计算丢弃概率的使能
* @param   tm_type   0-ETM,1-FTM
* @param   flag   忽略乘法里的当前包长和最大包长比标志位:1为忽略
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy     @date  2015/11/9
************************************************************/
DPP_STATUS dpp_tm_cgavd_wred_pke_len_calc_sign_get_diag(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 读取全部队列的计数信息
* @param   dev_id   设备编号*
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark   使用第2组统计寄存器进行统计
* @see
* @author    yjd    @date  2015/07/04
************************************************************/
DPP_STATUS diag_dpp_tm_cgavd_stat_q_all_get(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 读取某一队列统计计数寄存器的计数信息
* @param   dev_id   设备编号
* @param   q_id   统计该队列的信息
*          使用第1组统计寄存器进行统计
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/04
************************************************************/
DPP_STATUS diag_dpp_tm_cgavd_stat_q_single_get_diag(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 获取配置CPU设置的报文长度是否参与计算丢弃概率的使能
* @param   tm_type   0-ETM,1-FTM
* @param   flag   忽略乘法里的当前包长和最大包长比标志位:1为忽略
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy     @date  2015/11/9
************************************************************/
DPP_STATUS diag_dpp_tm_cgavd_wred_pke_len_calc_sign_get_diag(ZXIC_UINT32 dev_id);


/***********************************************************/
/** 读取WRED丢弃曲线对应的参数
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   level   WRED支持层次号，0:队列级，1:端口级
* @param   wred_id   队列级共支持16个WRED组0-15，端口级支持8组0-7
* @param   dp   共支持8个dp，取值0-7
* 读取的WRED组参数值，包含以下五个参数
           max_th  平均队列深度上限阈值
           min_th  平均队列深度下限阈值
           max_p  最大丢弃概率
           weight   平均队列深度计算权重
           q_len_th 队列深度阈值
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/06/24
************************************************************/
DPP_STATUS dpp_tm_cgavd_wred_dp_line_para_get_diag(ZXIC_UINT32 dev_id,
                                                   DPP_TM_CGAVD_LEVEL_E level,
                                                   ZXIC_UINT32 wred_id,
                                                   ZXIC_UINT32 dp);

/***********************************************************/
/** 读取系统级GRED丢弃曲线对应的参数
* @param   dev_id 设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   dp   共支持8个dp，取值0-7
* 读取GRED丢弃曲线参数值，包含以下六个参数
           max_th  平均队列深度上限阈值
           mid_th  平均队列深度中间阈值
           min_th  平均队列深度下限阈值
           max_p   最大丢弃概率
           weight   平均队列深度计算权重
           q_len_th 队列深度阈值
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/06/24
************************************************************/
DPP_STATUS dpp_tm_cgavd_gred_dp_line_para_get_diag(ZXIC_UINT32 dev_id,  ZXIC_UINT32 dp);

/***********************************************************/
/** 配置等价包长
* @param   dev_id
* @param   equal_pkt_len_index:  等价包长第几个区间(0~7)
* @param   equal_pkt_len:        等价包长
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/06/23
************************************************************/
DPP_STATUS dpp_tm_cgavd_equal_pkt_len_para_set_diag(ZXIC_UINT32 dev_id,
                                                    ZXIC_UINT32 equal_pkt_len_index,
                                                    ZXIC_UINT32 equal_pkt_len);

/***********************************************************/
/** 读取等价包长
* @param   dev_id
* @param   tm_type   0-ETM,1-FTM
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/06/24
************************************************************/
DPP_STATUS dpp_tm_cgavd_equal_pkt_len_para_get_diag(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 读取等价包长阈值
* @param   dev_id
* @param   tm_type   0-ETM,1-FTM
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/06/24
************************************************************/
DPP_STATUS dpp_tm_cgavd_equal_pkt_len_th_para_get_diag(ZXIC_UINT32 dev_id);


/***********************************************************/
/** 配置等价包长阈值
* @param   dev_id
* @param   tm_type   0-ETM,1-FTM
* @param   equal_pkt_len_th_index:  等价包长第几个门限(0~6)
* @param   equal_pkt_len_th      :  等价包长第几个门限的门限值
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2015/06/25
************************************************************/
DPP_STATUS dpp_tm_cgavd_equal_pkt_len_th_para_set_diag(ZXIC_UINT32 dev_id,
                                                       ZXIC_UINT32 equal_pkt_len_th0,
                                                       ZXIC_UINT32 equal_pkt_len_th1,
                                                       ZXIC_UINT32 equal_pkt_len_th2,
                                                       ZXIC_UINT32 equal_pkt_len_th3,
                                                       ZXIC_UINT32 equal_pkt_len_th4,
                                                       ZXIC_UINT32 equal_pkt_len_th5,
                                                       ZXIC_UINT32 equal_pkt_len_th6);

/***********************************************************/
/** 动态门限放大因子参数获取
* @param   dev_id
* @param   tm_type   0-ETM,1-FTM
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/06/24
************************************************************/
DPP_STATUS dpp_tm_cgavd_amplify_gene_para_get_diag(ZXIC_UINT32 dev_id);


/***********************************************************/
/** 动态门限放大因子参数配置
* @param   dev_id
* @param   tm_type   0-ETM,1-FTM
* @param   p_amplify_gene_para 动态门限放大因子参数
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy     @date  2015/06/25
************************************************************/
DPP_STATUS dpp_tm_cgavd_amplify_gene_para_set_diag(ZXIC_UINT32 dev_id,
                                                   ZXIC_UINT32 p_amplify_gene_index,
                                                   ZXIC_UINT32 p_amplify_gene_len);




/***********************************************************/
/**  打印各级拥塞避免功能使能
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/20
************************************************************/
DPP_STATUS dpp_tm_cgavd_en_get_diag(ZXIC_UINT32 dev_id);

/****************************************************************************
* 函数名称: dpp_tm_avg_que_len_get_diag
* 功能描述: 打印各级平均队列深度
* 输入参数: dev_id: 设备索引编号
* @param   tm_type   0-ETM,1-FTM
*           cgavd_level: 拥塞避免支持层次号，0:队列级，1:端口级，2:系统级
*           que_id: 本级别层次内的队列编号。
* 输出参数: p_avg_len: 平均队列深度，单位为BLOCK。
* 返 回 值: DPP_OK-成功，DPP_ERR-失败
* 其它说明:
* author  yjd      @date  2015/07/20
*****************************************************************************/
DPP_STATUS dpp_tm_avg_que_len_get_diag(ZXIC_UINT32 dev_id,
                                       DPP_TM_CGAVD_LEVEL_E cgavd_level,
                                       ZXIC_UINT32 que_id);

/***********************************************************/
/** 打印指定端口或队列绑定的WRED GROUP ID
* @param   dev_id 设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   level   WRED支持层次号，0:队列级，1:端口级
* @param   id   队列号或端口号
* @param
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2014/02/17
************************************************************/
DPP_STATUS dpp_tm_cgavd_wred_id_get_diag(ZXIC_UINT32 dev_id,
                                         DPP_TM_CGAVD_LEVEL_E level,
                                         ZXIC_UINT32 id);

/***********************************************************/
/** 打印指定端口或队列是否支持动态门限机制
* @param   dev_id 设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   level   WRED支持层次号，0:队列级，1:端口级
* @param   id   队列号或端口号
* @param   p_en   读取的值，0-不支持动态门限机制，1-支持动态门限机制
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/20
************************************************************/
DPP_STATUS dpp_tm_cgavd_dyn_th_en_get_diag(ZXIC_UINT32 dev_id,
                                            DPP_TM_CGAVD_LEVEL_E level,
                                           ZXIC_UINT32 id);

/***********************************************************/
/**  打印通用门限使能和门限
* @param   dev_id 设备编号
* @param   tm_type   0-ETM,1-FTM
* @param
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2014/07/20
************************************************************/
DPP_STATUS dpp_tm_cgavd_uniform_th_get_diag(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 打印TM模式下流队列挂接的端口号；SA模式下流队列映射的目的芯片ID
* @param   dev_id 设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   q_id   队列号，范围0~64k-1
* @param   p_pp_id   读取的端口号，范围0~136；目的芯片ID，范围0~511
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/20
************************************************************/
DPP_STATUS dpp_tm_cgavd_q_map_pp_get_diag(ZXIC_UINT32 dev_id,ZXIC_UINT32 q_id);

/***********************************************************/
/** 打印配置TM模式tc到flow的映射
* @param   dev_id 设备编号
* @param   tc_id   itmd tc优先级（0~7）
* @param   flow_id 读取映射的flowid号 （0~4095）
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  sun      @date  2023/07/04
************************************************************/
DPP_STATUS dpp_tm_tc_map_flow_get_diag(ZXIC_UINT32 dev_id,ZXIC_UINT32 tc_id);                                                          

/***********************************************************/
/** 批量配置TM模式下流队列挂接的端口号；SA模式下流队列映射的目的芯片ID
* @param   dev_id 设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   q_id_s   队列号
* @para    q_id_e
* @param   pp_id   配置的端口号
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/02
************************************************************/
DPP_STATUS dpp_tm_cgavd_q_map_pp_set_diag(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 q_id_s,
                                          ZXIC_UINT32 q_id_e,
                                          ZXIC_UINT32 pp_id);

/***********************************************************/
/** 设置指定队列号的统计使能，默认使能
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   flow_num 指定要统计的队列号
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wush      @date  2016/12/16
************************************************************/
DPP_STATUS diag_dpp_tm_cgavd_appoint_que_set(ZXIC_UINT32 dev_id,
                                                          ZXIC_UINT32 flow_num);

/***********************************************************/
/** 打印odma最后一个包的报文描述符
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  xuhb      @date  2019/12/4
************************************************************/
DPP_STATUS diag_dpp_tm_cgavd_itmd(ZXIC_UINT32 dev_id);


#endif


#if ZXIC_REAL("TM_QMU")

/***********************************************************/
/** 查找队列深度不为0的队列
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   start_q_id  起始队列号
* @param   end_q_id    终止队列号
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/09
************************************************************/
DPP_STATUS diag_dpp_tm_qmu_qlen_full(ZXIC_UINT32 dev_id,  ZXIC_UINT32 start_q_id, ZXIC_UINT32 end_q_id);


/***********************************************************/
/** 读取流队列级队列深度
* @param   dev_id 设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   que_id      队列号
*  队列深度以block为单位
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/06/24
************************************************************/
DPP_STATUS dpp_tm_flow_que_len_get_diag(ZXIC_UINT32 dev_id,  ZXIC_UINT32 que_id);

/***********************************************************/
/** 读取端口级队列深度
* @param   dev_id 设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   pp_id      队列号
*  队列深度以block为单位
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/06/24
************************************************************/
DPP_STATUS dpp_tm_port_que_len_get_diag(ZXIC_UINT32 dev_id,  ZXIC_UINT32 pp_id);

/***********************************************************/
/** 读取系统级队列深度
* @param   dev_id 设备编号
* @param   tm_type   0-ETM,1-FTM
* @ 系统级深度以block为单位
*    系统级包含协议队列深度以block为单位
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/06/24
************************************************************/
DPP_STATUS dpp_tm_sys_que_len_get_diag(ZXIC_UINT32 dev_id);


/***********************************************************/
/** 查看队列的授权盈余
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   start_q_id  起始队列号
* @param   end_q_id    终止队列号
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/09
************************************************************/
DPP_STATUS diag_dpp_tm_qmu_crbal(ZXIC_UINT32 dev_id,  ZXIC_UINT32 start_q_id, ZXIC_UINT32 end_q_id);

/***********************************************************/
/** 查看qmu的req发送情况
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   start_q_id  起始队列号
* @param   end_q_id    终止队列号
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/09
************************************************************/
DPP_STATUS diag_dpp_tm_qmu_req(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 查看队列信息
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   que_id  队列号
* @param
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/09      stm模式下使用
************************************************************/
DPP_STATUS diag_dpp_tm_que_cfg(ZXIC_UINT32 dev_id, ZXIC_UINT32 que_id);

/***********************************************************/
/** 查看上行队列10s内发送CRS(内部先读清后统计)
* @param   dev_id   设备编号
* @param   tm_type   0: tm0, 1: tm1
* @param   que_id   上行队列号
*
* @return
* @remark  无
* @see
* @author  wush      @date  2017/10/09
************************************************************/
DPP_STATUS diag_dpp_crs_send(ZXIC_UINT32 dev_id,  ZXIC_UINT32 que_id);

/***********************************************************/
/** 查看下行授权流10s内接收CRS(内部先读清后统计)
* @param   dev_id   设备编号
* @param   tm_type   0: tm0, 1: tm1
* @param   ackflow_id   下行授权流号
*
* @return
* @remark  无
* @see
* @author  wush      @date  2017/10/09
************************************************************/
DPP_STATUS diag_dpp_crs_recv(ZXIC_UINT32 dev_id, ZXIC_UINT32 ackflow_id);

/***********************************************************/
/** 查看上下行对应队列和授权流发送和接收CRS
* @param   dev_id   设备编号
* @param   tm_type   0: ETM, 1: FTM
* @param   que_id   上行队列号
* @param   ackflow_id   下行授权流号
*
* @return
* @remark  无
* @see
* @author  wush      @date  2017/10/09
************************************************************/
DPP_STATUS diag_dpp_crs(ZXIC_UINT32 dev_id, ZXIC_UINT32 que_id, ZXIC_UINT32 ackflow_id);

/***********************************************************/
/** 获取CMD_SW分端口整形速率和使能
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   shape_vlue 整形值，单位Mbps
* @param   shape_en   整形使能
* @return  0表示成功 非0表示操作失败
* @remark  无
* @see
* @author   张明月   @20151217
************************************************************/
DPP_STATUS diag_dpp_tm_qmu_egress_shape(ZXIC_UINT32 dev_id,  ZXIC_UINT32 port_id);

/***********************************************************/
/** 打印QMU队列授权价值
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   p_credit_value   授权价值，默认值是533Byte
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/20
************************************************************/
DPP_STATUS dpp_tm_qmu_credit_value_get_diag(ZXIC_UINT32 dev_id);



/***********************************************************/
/** 获得轮转扫描使能和扫描速率
* @param   dev_id   设备索引编号
* @param   tm_type   0-ETM,1-FTM
* @param   scan_en   轮转扫描使能。0：关闭，1：开启
* @param   scan_rate   轮转扫描速率，配置扫描周期不得少于256个周期
*
* @return  0表示成功 非0表示操作失败
* @remark  无
* @see
* @author  whuashan      @date  2020-3-17
************************************************************/
DPP_STATUS diag_dpp_tm_qmu_scan_info(ZXIC_UINT32 dev_id);


/***********************************************************/
/** 打印自动授权队列范围使能和速率
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   p_first_que   自授权起始队列号
* @param   p_last_que   自授权终止队列号
*
* @return  0表示成功 非0表示操作失败
* @remark  无
* @see
* @author  yjd      @date  2015/07/20
************************************************************/
DPP_STATUS diag_dpp_tm_qmu_auto_credit_info(ZXIC_UINT32 dev_id);



#endif

#if ZXIC_REAL("TM_CRDT")


/***********************************************************/
/** 打印TM子系统 SP/FQ/WFQ调度器资源分配情况：
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
*   说明： ftm无FQ调度器
*          sp_num        SP调度器个数，须是8的倍数
*          fq/wfq_num    调度器个数，须是8的倍数
*          fq2/wfq2_num  调度器个数，须是4的倍数
*          fq4/wfq4_num  调度器个数，须是2的倍数
*          fq8/wfq8_num  调度器个数
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  whuashan      @date  2019/02/26
************************************************************/
DPP_STATUS diag_dpp_tm_crdt_wfqfq(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 打印授权情况
* @param   dev_id   设备编号
* @param   tm_type     0-ETM,1-FTM
* @param   ackflow_id  授权流号
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wush      @date  2017/12/12
************************************************************/
DPP_STATUS diag_dpp_tm_flow_ack(ZXIC_UINT32 dev_id, ZXIC_UINT32 ackflow_id);


/***********************************************************/
/** 打印挂接关系
* @param   tm_type   0-ETM,1-FTM
* @param   ackflow_id   授权流号
* @param   mode 0-查看c桶队列挂接，1-查看e桶队列挂接
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  whuashan      @date  2019/3/8
************************************************************/
DPP_STATUS diag_dpp_tm_crdt_sch(ZXIC_UINT32 dev_id, ZXIC_UINT32 ackflow_id, ZXIC_UINT32 mode);



/***********************************************************/
/** 打印PP级挂接参数
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   pp_id   端口号 0~63
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  whuashan      @date  2019/03/21
************************************************************/
DPP_STATUS diag_dpp_tm_crdt_sch_pp(ZXIC_UINT32 dev_id, ZXIC_UINT32 pp_id);

/***********************************************************/
/** 查看CRDT接收到和发送的拥塞授权总数
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/08/17
************************************************************/
DPP_STATUS diag_dpp_tm_crdt_congest_credit_cnt(ZXIC_UINT32 dev_id);


/***********************************************************/
/** 查看CRDT接收到CRDT接收到的CRS normal和CRS off总数
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/08/18
************************************************************/
DPP_STATUS diag_dpp_tm_crdt_crs_cnt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 查看CRDT接收到的CRS normal和CRS off总数
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/12/08
************************************************************/
DPP_STATUS diag_dpp_tm_crdt_crs_cnt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 查看CRDT申请但未得到授权的总数
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  cy      @date  2016/08/18
************************************************************/
DPP_STATUS diag_dpp_tm_crdt_no_credit_cnt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 查看CRDT收到的指定队列的CRS Normal和CRS off计数
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   flow_id   指定队列号
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wush      @date  2016/12/30
************************************************************/
DPP_STATUS diag_dpp_tm_crdt_que_crs_cnt(ZXIC_UINT32 dev_id, ZXIC_UINT32 flow_id);


#endif


#if ZXIC_REAL("TM_SHAPE")

/***********************************************************/
/** 打印flow级授权流的整形参数
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   ackflow_id   授权流号
* @param   mode 0-查看c桶队列整形，1-查看e桶队列整形
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  whuashan      @date  2019/03/18
************************************************************/
DPP_STATUS diag_dpp_tm_shape(ZXIC_UINT32 dev_id, ZXIC_UINT32 ackflow_id, ZXIC_UINT32 mode);


/***********************************************************/
/** 读取端口级整形参数
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   port_id   端口号
* 读取的整形信息:CIR/CBS/EN
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  whuashan      @date  2019/03/18
************************************************************/
DPP_STATUS diag_dpp_tm_shape_pp(ZXIC_UINT32 dev_id, ZXIC_UINT32 port_id);

/***********************************************************/
/** 读取shap整形参数表
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   para_index   模板索引：ETM=[0-AFF]，FTM=[0-17F]
* 读取的整形信息:CIR/CBS/EN
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  whuashan      @date  2019/03/18
************************************************************/
DPP_STATUS diag_dpp_tm_shape_para(ZXIC_UINT32 dev_id, ZXIC_UINT32 para_index);


/***********************************************************/
/** 读取flow用户配置的整形参数
* @param   dev_id   设备编号
* @param   tm_type   0-ETM,1-FTM
* @param   flow_id_start   起始队列号
* @param   flow_id_end   结束队列号
* @param
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  xuhb      @date  2019/12/4
************************************************************/
DPP_STATUS diag_dpp_tm_flow_shap_para(ZXIC_UINT32 dev_id, ZXIC_UINT32 flow_id_start, ZXIC_UINT32 flow_id_end);


/***********************************************************/
/** TM反压模式设置 配置local_sa_id寄存器
* @param   dev_id 设备编号
* 0:代表按block反压,立即反压；1:代表按包反压，出完一个完整包再反压
*
* @return   DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  sun      @date  2024/07/10
************************************************************/
DPP_STATUS diag_dpp_tm_cfgmt_fc_mode_para(ZXIC_UINT32 dev_id);


#endif

#endif




