#!/bin/bash

if [ "$1" = "c" ]; then
    search_strings="I510 I511 I512 X510 X512"
    config_files="i510_smart_nic_init.cfg i511_smart_nic_init.cfg i512_smart_nic_init.cfg x510_dpu_init.cfg x512_dpu_init.cfg"

    lspci_result=$(lspci -nn | grep '1cf2')

    function copyConfig() {
        local device="$1"
        local config_file=""
        case $device in
            "I510") config_file="i510_smart_nic_init.cfg";;
            "I511") config_file="i511_smart_nic_init.cfg";;
            "I512") config_file="i512_smart_nic_init.cfg";;
            "X510") config_file="x510_dpu_init.cfg";;
            "X512") config_file="x512_dpu_init.cfg";;
        esac
        if [ -n "$config_file" ]; then
            if [[ "$device" == "X510" || "$device" == "X512" ]]; then
                target_file="/etc/dpu_init.cfg"
            else
                target_file="/etc/smart_nic_init.cfg"
            fi
            echo "Trying to copy /etc/zxdh_cfg/$config_file to $target_file."
            if cp "/etc/zxdh_cfg/$config_file" "$target_file"; then
                echo "Copied $config_file to $target_file successfully."
            else
                echo "Error copying $config_file to $target_file."
            fi
        else
            echo "No matching config file found for $device."
        fi
    }

    for device in $search_strings; do
        if echo "$lspci_result" | grep -q "$device"; then
            echo "Found device $device."
            copyConfig "$device"
        else
            echo "Device $device not found."
        fi
    done
elif [ "$1" = "d" ]; then
    for file in "/etc/smart_nic_init.cfg" "/etc/dpu_init.cfg"; do
        if [ -f "$file" ]; then
            rm "$file"
            echo "File $file has been successfully deleted."
        else
            echo "File $file does not exist."
        fi
    done
else
    echo "Invalid argument. Use 'c' for copying config or 'd' for deleting config file."
fi