/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_devmng_api.h
* 文件标识 :
* 内容摘要 :
* 其它说明 :
* 当前版本 :
* 作    者 : wcl
* 完成日期 : 2015/05/20
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* 修改记录1:
* 修改日期:
* 版 本 号:
* 修 改 人:
* 修改内容:
***************************************************************/

#ifndef _DPP_DEVMNG_API_H_
#define _DPP_DEVMNG_API_H_

#include "zxic_common.h"

#if ZXIC_REAL("header file")
#include "dpp_type_api.h"

#endif

#if ZXIC_REAL("data struct define")
/**  底层设备硬件读写接口指针*/
typedef DPP_STATUS (*DPP_DEV_WRITE_FUNC)(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32 *p_data);
typedef DPP_STATUS (*DPP_DEV_READ_FUNC)(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32 *p_data);
typedef DPP_STATUS (*DPP_ACCESS_SWITCH_FUNC)(ZXIC_UINT32 dev_id, ZXIC_UINT32 access_type);

/**  设备访问类型*/
typedef enum dpp_dev_access_type_e
{
    DPP_DEV_ACCESS_TYPE_PCIE = 0, /**<  @brief PCIe访问*/
    DPP_DEV_ACCESS_TYPE_RISCV = 1, /**<  @brief RISCV访问*/
    DPP_DEV_ACCESS_TYPE_INVALID,
} DPP_DEV_ACCESS_TYPE_E;

typedef enum 
{
    DPP_DEV_AGENT_DISABLE= 0, /**<  @brief 代理没使能*/
    DPP_DEV_AGENT_ENABLE = 1, /**<  @brief 代理使能*/
    DPP_DEV_AGENT_INVALID,
} DPP_DEV_AGENT_FLAG_E;


/**  设备类型*/
typedef enum dpp_dev_type_e
{
    DPP_DEV_TYPE_SIM  = 0,  /**<  @brief 仿真器设备*/
    DPP_DEV_TYPE_VCS  = 1,  /**<  @brief VCS设备*/
    DPP_DEV_TYPE_CHIP = 2,  /**<  @brief asci芯片设备*/
    DPP_DEV_TYPE_FPGA = 3,  /**<  @brief fpga设备*/
    DPP_DEV_TYPE_PCIE_ACC = 4,
    DPP_DEV_TYPE_INVALID,
} DPP_DEV_TYPE_E;

/**  设备版本*/
typedef enum dpp_chip_version_e
{
    DPP_CHIP_VERSION_DPP   = 0U,  /**<  @brief DPP */
    DPP_CHIP_VERSION_DPP_P = 1U,  /**<  @brief DPP+ */
    DPP_CHIP_VERSION_INVALID,
} DPP_CHIP_VERSION_E;

/**  互斥锁类型*/
typedef enum dpp_dev_mutex_type_e
{
    DPP_DEV_MUTEX_T_REG   = 0,  /**<  @brief 寄存器操作互斥锁       */
    DPP_DEV_MUTEX_T_OAM   = 1,  /**<  @brief OAM模块操作互斥锁      */
    DPP_DEV_MUTEX_T_ETM   = 2,  /**<  @brief ETM模块操作互斥锁       */
    DPP_DEV_MUTEX_T_DDR   = 4,  /**<  @brief DDR模块操作互斥锁      */
    DPP_DEV_MUTEX_T_IND   = 5,  /**<  @brief RAM间接读写操作互斥锁  */
    DPP_DEV_MUTEX_T_ETCAM = 6,  /**<  @brief ETCAM间接读写操作互斥锁*/
    DPP_DEV_MUTEX_T_MMU   = 7,  /**<  @brief MMU间接读写操作互斥锁  */
    DPP_DEV_MUTEX_T_CAR0  = 8,  /**<  @brief CAR0模块操作互斥锁     */
    DPP_DEV_MUTEX_T_ALG       = 9, /**<  @brief ALG间接读写操作互斥锁  */
    DPP_DEV_MUTEX_T_NPPU      = 10, /**<  @brief nppu间接读写操作互斥锁  */
    DPP_DEV_MUTEX_T_SMMU0     = 11, /**<  @brief smmu0 模块操作互斥锁  */
    DPP_DEV_MUTEX_T_SMMU1     = 12, /**<  @brief smmu1 模块操作互斥锁  */
    DPP_DEV_MUTEX_T_ETM_2ND   = 13, /**<  @brief ETM模块二层间接表操作互斥锁 */
    DPP_DEV_MUTEX_T_LPM       = 14, /**<  @brief LPM模块操作互斥锁 */
    DPP_DEV_MUTEX_T_CRM_TEMP  = 15, /**<  @brief 温度获取操作互斥锁 */
    DPP_DEV_MUTEX_T_SIM       = 16, /**<  @brief 仿真器socket通信操作互斥锁 */
    DPP_DEV_MUTEX_T_DTB       = 17, /**<  @brief DTB队列操作互斥锁 */
    DPP_DEV_MUTEX_T_DTB_MULTI = 18, /**<  @brief DTB 批量流操作互斥锁 */
    DPP_DEV_MUTEX_T_MAX
} DPP_DEV_MUTEX_TYPE_E;

/**  自旋锁类型*/
typedef enum dpp_dev_spin_lock_type_e
{
    DPP_DEV_SPIN_LOCK_T_DTB_MULTI = 0, /**<  @brief DTB 批量流操作自旋锁 */
    DPP_DEV_SPIN_LOCK_T_MAX
} DPP_DEV_SPIN_LOCK_TYPE_E;

typedef struct dpp_cpu_softreset_cfg_t
{
    ZXIC_VOID * p_se_cfg;
    ZXIC_VOID * p_acl_cfg;
} DPP_CPU_SOFTRESET_CFG_T;
#endif

#if ZXIC_REAL("function define")
/***********************************************************/
/** 初始化
* @param   init_flag
*
* @return
* @remark  无
* @see
* @author  王春雷      @date  2014/02/07
************************************************************/
DPP_STATUS dpp_env_init(ZXIC_UINT32 init_flag);

/***********************************************************/
/** 初始化设备管理模块
* @param   ZXIC_VOID
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/03/06
************************************************************/
DPP_STATUS dpp_dev_init(ZXIC_VOID);

/***********************************************************/
/** 添加新设备实例，并初始化
* @param   dev_id         新增设备的设备号
* @param   dev_type          设备类型，取值参照DPP_DEV_TYPE_E的定义
* @param   access_type       设备访问类型，取值参照DPP_DEV_ACCESS_TYPE_E的定义
* @param   pcie_addr         PCIe映射地址
* @param   riscv_addr         RISCV映射地址
* @param   dma_vir_addr      DMA映射地址
* @param   dma_phy_addr      DMA内存物理地址
* @param   p_pcie_write_fun  PCIe硬件写回调函数
* @param   p_pcie_read_fun   PCIe硬件读回调函数
* @param   p_riscv_write_fun  RISCV硬件写回调函数
* @param   p_riscv_read_fun   RISCV硬件读回调函数
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/03/06
************************************************************/
DPP_STATUS dpp_dev_add(ZXIC_UINT32  dev_id,
                       DPP_DEV_TYPE_E dev_type,
                       DPP_DEV_ACCESS_TYPE_E  access_type,
                       ZXIC_ADDR_T  pcie_addr,
                       ZXIC_ADDR_T  riscv_addr,
                       ZXIC_ADDR_T  dma_vir_addr,
                       ZXIC_ADDR_T  dma_phy_addr,
                       DPP_DEV_WRITE_FUNC p_pcie_write_fun,
                       DPP_DEV_READ_FUNC  p_pcie_read_fun,
                       DPP_DEV_WRITE_FUNC p_riscv_write_fun,
                       DPP_DEV_READ_FUNC  p_riscv_read_fun);

/***********************************************************/
/** 删除设备实例
* @param   dev_id  设备号
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS dpp_dev_del(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 写设备底层接口
* @param   dev_id  设备号
* @param   addr       单个设备内部的相对地址
* @param   size       数据的长度，以32bit为单位
* @param   p_data     数据
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2014/05/15
************************************************************/
DPP_STATUS dpp_dev_write_channel(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32 *p_data);

/***********************************************************/
/** 读设备底层接口
* @param   dev_id  设备号
* @param   addr       单个设备内部的相对地址
* @param   size       数据的长度，以32bit为单位
* @param   p_data     数据
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2014/05/15
************************************************************/
DPP_STATUS dpp_dev_read_channel(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32 *p_data);

/***********************************************************/
/** 获取设备PCIe映射到进程空间的内存虚拟地址
* @param   dev_id
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
ZXIC_ADDR_T dpp_dev_get_pcie_addr(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 获取DMA映射到进程空间的内存虚拟地址
* @param   dev_id
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
ZXIC_ADDR_T dpp_dev_get_dma_vir_addr(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 获取DMA映射到进程空间的内存物理地址
* @param   dev_id
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
ZXIC_ADDR_T dpp_dev_get_dma_phy_addr(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 动态切换设备的访问类型
* @param   dev_id    设备号
* @param   access_type  访问类型，取值参照DPP_DEV_ACCESS_TYPE_E的定义
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/03/06
************************************************************/
DPP_STATUS dpp_dev_access_type_switch(ZXIC_UINT32 dev_id, DPP_DEV_ACCESS_TYPE_E access_type);

/***********************************************************/
/** 获取上层软件注册的PCIe写接口函数指针
* @param   dev_id   设备号
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/10/19
************************************************************/
DPP_DEV_WRITE_FUNC dpp_dev_get_pcie_write_fun(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 获取上层软件注册的PCIe读接口函数指针
* @param   dev_id  设备号
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/10/19
************************************************************/
DPP_DEV_WRITE_FUNC dpp_dev_get_pcie_read_fun(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 获取存储流表资源信息的指针
* @param   dev_id  设备号
* @param   type    流表类型0：标卡 1：非标卡
* @return  
* @remark  无
* @see
* @author  cq      @date  2024/11/13
************************************************************/
ZXIC_VOID *dpp_dev_get_se_res_ptr(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** 获取设备类型
* @param   dev_id  设备号
*
* @return  设备类型，参考DPP_DEV_TYPE_E的定义
* @remark  无
* @see
* @author  wcl      @date  2015/03/06
************************************************************/
ZXIC_UINT32 dpp_dev_get_dev_type(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 获取系统中已创建的设备总数
* @param   ZXIC_VOID
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
ZXIC_UINT32 dpp_dev_number_get(ZXIC_VOID);

/***********************************************************/
/** 根据类型获取互斥锁
* @param   dev_id    设备号
* @param   type         互斥锁类型，取值参照DPP_DEV_MUTEX_TYPE_E的定义
* @param   p_mutex_out  返回的互斥锁
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/10/10
************************************************************/
DPP_STATUS dpp_dev_opr_mutex_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type, ZXIC_MUTEX_T **p_mutex_out);

/***********************************************************/
/** 根据类型获取互斥锁
* @param   dev_id    设备号
* @param   type      自旋锁类型，取值参照DPP_DEV_SPIN_LOCK_TYPE_E的定义
* @param   p_spin_lock_out  返回的互斥锁指针地址
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  王春雷      @date  2015/10/10
************************************************************/
DPP_STATUS dpp_dev_opr_spin_lock_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type, ZXIC_SPIN_LOCK_T **p_spin_lock_out);

/***********************************************************/
/** 根据index获取dtb对应队列的互斥锁
* @param   dev_id    设备号
* @param   type         互斥锁类型，取值参照DPP_DEV_MUTEX_TYPE_E的定义
* @param   p_mutex_out  返回的互斥锁指针地址
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  王春雷      @date  2015/10/10
************************************************************/
DPP_STATUS dpp_dev_dtb_opr_mutex_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 type, ZXIC_UINT32 index, ZXIC_MUTEX_T **p_mutex_out);

/***********************************************************/
/** 打印单个设备信息
* @param   dev_id
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  wcl      @date  2015/04/30
************************************************************/
DPP_STATUS dpp_dev_info_print(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 调试模式下，用绝对地址写寄存器
* @param   dev_id  设备号
* @param   addr       单个设备内寄存器地址
* @param   data       写数据
*
* @return
* @remark  无
* @see
* @author  wcl      @date  2014/05/13
************************************************************/
DPP_STATUS dpp_debug_wr(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 data);

/***********************************************************/
/** 调试模式下，用绝对地址读寄存器并打印读到的数据
* @param   dev_id  设备号
* @param   addr       单个设备内寄存器地址
*
* @return
* @remark  无
* @see
* @author  wcl      @date  2014/05/13
************************************************************/
DPP_STATUS dpp_debug_rd(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr);

/***********************************************************/
/** 用绝对地址读多个寄存器
* @param   dev_id  设备号 
* @param   addr       芯片内寄存器地址
*
* @return  
* @remark  无
* @see     
* @author  zzh      @date  2016/09/19
************************************************************/
DPP_STATUS dpp_debug_multi_rd(ZXIC_UINT32 dev_id,
                              ZXIC_UINT32 addr,
                              ZXIC_UINT32 number);

#endif

/***********************************************************/
/**
* @param   DPP_STORE
* @param   offset
* @param   size
* @param   locbuf
*
* @return
* @remark  for cpu soft reset  支持向buf+offset开始处写入size字节数据，数据来源于locbuf，buf基地址由产线维护
* @see
* @author  XXX      @date  2019/07/03
************************************************************/
typedef ZXIC_UINT32 (*DPP_STORE) (ZXIC_UINT32 offset, ZXIC_UINT32 size, ZXIC_VOID *locbuf);

/***********************************************************/
/**
* @param   DPP_RECOVERY
* @param   offset
* @param   size
* @param   locbuf
*
* @return
* @remark  for cpu soft reset  支持从buf+offset开始处读取size字节，放入到locbuf中，buf基地址由产线维护
* @see
* @author  XXX      @date  2019/07/03
************************************************************/
typedef ZXIC_UINT32 (*DPP_RECOVERY) (ZXIC_UINT32 offset, ZXIC_UINT32 size, ZXIC_VOID *locbuf);

/***********************************************************/
/**
* @param   DPP_BACKUP
* @param   pcName
* @param   locbuf
* @param   size
*
* @return
* @remark  支持将locbuf中size字节的数据写入到文件名为pcName的文件中， size以字节为单位
* @see
* @author  XXX      @date  2019/07/03
************************************************************/
typedef ZXIC_SINT32 (*DPP_BACKUP)(ZXIC_CHAR *pcName, ZXIC_VOID *locbuf, ZXIC_UINT32 size);

/***********************************************************/
/**
* @param   DPP_RESTORE
* @param   pcName
* @param   locbuf
* @param   size
* @param   1
*
* @return
* @remark  支持从从文件名为pcName的文件中读取size字节的数据放入到locbuf中，正常时函数返回值为读取字节数数量，异常时返回值为-1, size以字节为单位
* @see
* @author  XXX      @date  2019/07/03
************************************************************/
typedef ZXIC_SINT32 (*DPP_RESTORE)(ZXIC_CHAR *pcName, ZXIC_VOID *locbuf, ZXIC_UINT32 size);

/***********************************************************/
/**
* @param   DPP_FINBACKUP
* @param   pcName
*
* @return
* @remark  无
* @see
* @author  XXX      @date  2019/07/03
************************************************************/
typedef ZXIC_SINT32 (*DPP_FINBACKUP)(ZXIC_CHAR *pcName);

/***********************************************************/
/** 获取本次软复位需要的缓存空间大小
* @param   dev_id   设备号
* @param   p_size   出参，返回本次软复位需要的缓存空间大小，以字节为单位
*
* @return
* @remark  无
* @see
* @author  shijf      @date  2017/04/18
************************************************************/
DPP_STATUS dpp_cpu_soft_reset_space_size(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_size);

/***********************************************************/
/** CPU软复位数据存储接口
* @param   dev_id   设备号
* @param   p_se_cfg   用户维护的芯片算法管理结构结构体
* @param   p_store_fuc   用户提供缓存空间写入函数
*
* @return  0:正常 非0：异常
* @remark  无
* @see
* @author  XXX      @date  2017/03/13
************************************************************/
DPP_STATUS dpp_cpu_soft_reset_store(ZXIC_UINT32    dev_id,
                                    ZXIC_VOID      *p_se_cfg,
                                    DPP_STORE p_store_fuc);

/***********************************************************/
/** CPU软复位数据恢复接口
* @param   dev_id   设备号
* @param   p_se_cfg  用户维护的芯片算法管理结构结构体
* @param   p_recovery_fuc    用户提供缓存空间写入函数
*
* @return  0:正常 非0：异常
* @remark  无
* @see
* @author  XXX      @date  2017/03/13
************************************************************/
DPP_STATUS dpp_cpu_soft_reset_recovery(ZXIC_UINT32       dev_id,
                                       ZXIC_VOID         *p_se_cfg,
                                       DPP_RECOVERY p_recovery_fuc);

/***********************************************************/
/** 获取本次软复位需要的缓存空间大小
* @param   dev_id   设备号
* @param   p_size      出参，返回本次软复位需要的缓存空间大小，以字节为单位
* @param   p_se_cfg    算法管理数据结构体
*
* @return
* @remark  无
* @see
* @author  wcl      @date  2017/07/01
************************************************************/
DPP_STATUS dpp_cpu_soft_reset_space_size_ex(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_size, ZXIC_VOID *p_softreset_cfg);

/***********************************************************/
/** CPU软复位数据存储接口
* @param   ucName   需要存储的模块文件名
* @param   dev_id   设备号
* @param   p_softreset_cfg   用户维护的芯片算法管理结构结构体
* @param   p_backup_fuc   用户提供缓存空间写入函数
*
* @return  0:正常 非0：异常
* @remark  无
* @see
* @author  XXX      @date  2017/03/13
************************************************************/
DPP_STATUS dpp_cpu_soft_reset_store_sup(ZXIC_CHAR    *ucName,
                                        ZXIC_UINT32    dev_id,
                                        ZXIC_VOID *p_softreset_cfg,
                                        DPP_BACKUP p_backup_fuc,
                                        DPP_FINBACKUP p_finbackup_fuc);

/***********************************************************/
/** CPU软复位数据恢复接口
* @param   dev_id   设备号
* @param   p_softreset_cfg  用户维护的芯片算法管理结构结构体
* @param   p_restore_fuc    用户提供缓存空间写入函数
*
* @return  0:正常 非0：异常
* @remark  无
* @see
* @author  XXX      @date  2017/03/13
************************************************************/
DPP_STATUS dpp_cpu_soft_reset_recovery_sup(ZXIC_UINT32       dev_id,
                                           ZXIC_VOID  *p_softreset_cfg,
                                           DPP_RESTORE  p_restore_fuc);

#endif /* dpp_devmng_api.h */



