/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_oam_api.h
* ļʶ : oamģͶͽӿں
* ժҪ :
* ˵ :
* ǰ汾 :
*      : PJ
*  : 2015/01/30
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* ޸ļ¼1:
* ޸:
*   :
*   :
* ޸:
***************************************************************/
#ifndef _DPP_OAM_API_H_
#define _DPP_OAM_API_H_


#if ZXIC_REAL("header file")
#include "dpp_module.h"
#include "dpp_oam.h"
#endif

#if ZXIC_REAL("macro function define")
/** OAM_TYPEͱ  */
#define DPP_ETHOAM_TYPE           (0x0)
#define DPP_TPOAM_TYPE            (0x1)
#define DPP_BFD_TYPE              (0x2)

/** PKT_TYPEͱ */
#define DPP_ETH_CCM_PKT_TYPE      (0x0)
#define DPP_ETH_TST_PKT_TYPE      (0x1)
#define DPP_ETH_AIS_PKT_TYPE      (0x2)
#define DPP_ETH_CSF_PKT_TYPE      (0x3)
#define DPP_TP_CCM_PKT_TYPE       (0x4)
#define DPP_TP_TST_PKT_TYPE       (0x5)
#define DPP_TP_AIS_PKT_TYPE       (0x6)
#define DPP_TP_CSF_PKT_TYPE       (0x7)
#define DPP_BFD_PKT_TYPE          (0x8)
#define DPP_TP_BFD_PKT_TYPE       (0x9)
#define DPP_ETH_APS_PKT_TYPE      (0xa)
#define DPP_TP_APS_PKT_TYPE       (0xb)
#define DPP_PONPROTECT_TYPE       (0xc)

/** ԼΧ */
#define OAM_MAX_MASK_MUN          (16)
#define OAM_MIN_MASK_MUN          (1)
#define OAM_MAX_SESSION_MUN       (4*1024)
#define OAM_MIN_SESSION_MUN       (0)
#define OAM_MAX_PKT_LEN           (256)
#define OAM_MAX_BIG_PKT_LEN       (16000)
#define OAM_MIN_PKT_LEN           (0)

#define OAM_TST_MAX_NUM           (10)
#define OAM_TST_MIN_NUM           (0)
#define OAM_TST_MAX_PKT_LEN       (256)
#define OAM_TST_BIG_PKT_LEN       (2048)
#define OAM_TST_MIN_PKT_LEN       (0)

#define OAM_PON_MAX_NUM           (32)
#define OAM_PON_MIN_NUM           (0)
#define OAM_PON_MAX_PKT_LEN       (64)
#define OAM_PON_MIN_PKT_LEN       (0)

#define OAM_PON_BITMAP_LEN        (16)


#define OAM_2544_MAX_NUM          (256)
#define OAM_2544_MIN_NUM          (0)
#define OAM_2544_MAX_PKT_LEN      (64)
#define OAM_2544_BIG_PKT_LEM      (16000)
#define OAM_2544_MIN_PKT_LEN      (0)
#define OAM_MAX_CHKTIME           (520000)

#endif

#if ZXIC_REAL("function declaration")
#if ZXIC_REAL("OAM_GLOBAL")
/***********************************************************/
/** ȫּʹܣֻʹܴ򿪵£OAMŻԼỰɨ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_global_chk_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

/***********************************************************/
/** MAȫּʹܣֻʹܴ򿪵£OAMŻMAỰɨ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_global_ma_chk_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

/***********************************************************/
/** ȫַʹܣֻʹܴ򿪵£OAMŻԷͻỰɨ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_global_tx_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

/***********************************************************/
/** TSTȫֽʹܣֻʹܴ򿪵£OAMŻԽյTSTĽд
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_global_tst_rx_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

/***********************************************************/
/** 2544ʹܣĬδʹ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹ  0:ر  1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/05
************************************************************/
DPP_STATUS dpp_oam_global_2544_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

/***********************************************************/
/** ÷ͻỰȣ:ƽɨݻỰ
* @param   dev_id    оƬIDţֶ֧оƬ
* @param   grad_type   ,ȡֵμOAM_GRADING_TYPE_E
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/22
************************************************************/
DPP_STATUS dpp_oam_tx_session_grading_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 grad_type);

/***********************************************************/
/** üỰȣ:ƽɨݻỰ
* @param   dev_id    оƬIDţֶ֧оƬ
* @param   grad_type   ,ȡֵμOAM_GRADING_TYPE_E
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/22
************************************************************/
DPP_STATUS dpp_oam_chk_session_grading_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 grad_type);

/***********************************************************/
/** MAỰȣ:ƽɨݻỰ
* @param   dev_id    оƬIDţֶ֧оƬ
* @param   grad_type   ,ȡֵμOAM_GRADING_TYPE_E
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/22
************************************************************/
DPP_STATUS dpp_oam_ma_chk_session_grading_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 grad_type);

/***********************************************************/
/** öȡĵĿȣ:ƽɨݻỰ
* @param   dev_id    оƬIDţֶ֧оƬ
* @param   grad_type   ,ȡֵμOAM_PKT_GRADING_TYPE_E
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/22
************************************************************/
DPP_STATUS dpp_oam_pkt_session_grading_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 grad_type);

/***********************************************************/
/** üỰƼѯỰ֧64KỰ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   num         Ự
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_total_chk_num_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 num);

/***********************************************************/
/** ETHOAMTPOAMʱMA/MEGڣỰ֧64KỰ
* @param   dev_id   dev_id   оƬIDţֶ֧оƬ
* @param   num    MAỰ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_total_ma_chk_num_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 num);


/***********************************************************/
/** ÷ͻỰƷѯỰ֧64KỰ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   num    ͻỰ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_total_tx_num_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 num);

/***********************************************************/
/** òͬ͵OAMỰжϣ64KỰַУʼỰ׵ַ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   pkt_type    ͣϸμPKT_TYPEͱ
* @param   base_addr   ͬOAM͵ļỰƫ׵ַ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_chk_base_haddr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 base_addr);

/***********************************************************/
/** OAM MAỰжϣ64KỰеʼỰ׵ַ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   oam_type    OAMͣϸμOAM_TYPEͱ
* @param   base_addr   tpoamethOAMMAỰƫ׵ַ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_ma_chk_base_haddr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_type, ZXIC_UINT32 base_addr);

/***********************************************************/
/** òͬOAMñǷͱģ64KỰлỰŵƫ׵ַ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   pkt_type    ͣϸμpkt_typeͱ
* @param   base_addr   ӦOAMķͻỰƫ׵ַ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_tx_base_haddr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 base_addr);

/***********************************************************/
/** BFDװޣʱ䵥λ(0.1ms),Ĭֵ50000(5S)
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   chk_th   װֵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/04/15
************************************************************/
DPP_STATUS dpp_oam_bfd_first_chk_time_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 chk_th);

/***********************************************************/
/** oamհͷeramDDR3ռOAMͳƼƫƵַ,
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   stat_add    oamͺͽͳƼĻַ
* @param   stat_addr_flag  oamƬͳʹܣ1-Ƭͳƣ0-Ƭͳ

* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/12/08
************************************************************/
DPP_STATUS dpp_oam_stat_addr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 stat_add, ZXIC_UINT32 stat_addr_flag);

/***********************************************************/
/** BFD_DEBUGȫֿʹܣDEBUG£BFD
* СֵͳƺSEQIDʧͳ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/08/15
************************************************************/
DPP_STATUS dpp_oam_global_bfd_debug_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

#endif


#if ZXIC_REAL("OAM_CONFIG")
/***********************************************************/
/** oamʼ
* @param   dev_id   оƬIDţֶ֧оƬ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ûỰ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   p_grad_type   ͣգmaȻỰãȡֵμOAM_GRADING_TYPE_E
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/11
************************************************************/
DPP_STATUS dpp_oam_grading_type_set(ZXIC_UINT32 dev_id, OAM_GRADING_TYPE_T *p_grad_type);


/***********************************************************/
/** ȫʹܣͣ⣬ma⣬tstգBFD_DEBUGʹܵ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   p_enable   ʹܣμOAM_GLOBAL_EN_T
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/11
************************************************************/
DPP_STATUS dpp_oam_global_en_set(ZXIC_UINT32 dev_id, OAM_GLOBAL_EN_T *p_enable);



/***********************************************************/
/** ܵķ͡⡢MA
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   tx_num   ͻỰѯỰ֧64KỰ
* @param   chk_num   ỰѯỰ֧64KỰ
* @param   ma_chk_num   MAỰѯỰ֧64KỰ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/11
************************************************************/
DPP_STATUS dpp_oam_total_num_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 tx_num, ZXIC_UINT32 chk_num, ZXIC_UINT32 ma_chk_num);


/***********************************************************/
/** LMַ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   lm_addr       LMַ
*
* @return
* @remark  
* @see
* @author  PJ      @date  2015/02/11
************************************************************/
DPP_STATUS dpp_oam_lm_addr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 lm_addr);

/***********************************************************/
/** odma eramռ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   base_addr1   1 eramַ
* @param   base_addr2   2 eramַ
* @param   base_addr3   3 eramַ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/11
************************************************************/
DPP_STATUS dpp_oam_odma_lm_eram_addr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr1, ZXIC_UINT32 base_addr2, ZXIC_UINT32 base_addr3);

/***********************************************************/
/** statͳƼʹ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_stat_tx_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

/***********************************************************/
/** statͳƼʹ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/14
************************************************************/
DPP_STATUS dpp_oam_stat_rec_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);


/***********************************************************/
/**stat_oam1ι
* @param   dev_id   豸ID
* @param   mask_flag   жα־1:;0:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ  0д򷵻ط0
* @remark  
* @see
* @author  PJ      @date  2014/02/25
************************************************************/
DPP_STATUS dpp_oam_stat_fc_mask_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 mask_flag);

/***********************************************************/
/** OAMͳƼLMѹʹ
* @param   dev_id                豸
* @param   p_oam_flow_control_en    ͨѹʹܣ0-ѹЧ1-ѹЧ
* @param   p_oam_flow_lm_control_en LMѹʹܣ0-ѹЧ1-ѹЧ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/03/30
************************************************************/
DPP_STATUS  dpp_oam_stat_flow_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_control_en, ZXIC_UINT32 oam_flow_lm_control_en);

/***********************************************************/
/** ĳỰķͲϢ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   session_id   ֲԻỰ(0~4k-1)
* @param   p_tx_cfg   ͲϢμOAM_SEND_CFG_T
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/22
************************************************************/
DPP_STATUS dpp_oam_txcfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 session_id, OAM_SEND_CFG_T  *p_tx_cfg);

/***********************************************************/
/** ĳỰϢ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   session_id  ֲԻỰ(0~4k-1)
* @param   p_chk_cfg   ϢμOAM_CHK_CFG_T
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/22
************************************************************/
DPP_STATUS dpp_oam_chkcfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 session_id, OAM_CHK_CFG_T  *p_chk_cfg);

/***********************************************************/
/** ĳỰMAϢ
* @param   dev_id    оƬIDţֶ֧оƬ
* @param   session_id   ֲԻỰ(0~4k-1)
* @param   p_chk_cfg   MA,μOAM_MA_CHK_CFG_T
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/22
************************************************************/
DPP_STATUS dpp_oam_ma_chkcfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 session_id, OAM_MA_CHK_CFG_T  *p_chk_cfg);

/***********************************************************/
/** ĳỰĳֱĵMA
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   session_id    ֲԻỰ(0~4k-1)
* @param   p_config_cfg   òμOAM_MA_CONFIG_CFG_T
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/22
************************************************************/
DPP_STATUS dpp_oam_ma_config_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 session_id, OAM_MA_CONFIG_CFG_T  *p_config_cfg);

/***********************************************************/
/** ĳỰķͱģдDDR3Уÿռ256ֽ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   pkt_type   ͣϸμPKT_TYPEͱ
* @param   session_id  ֲԻỰ(0~4k-1)
* @param   p_buf   õDDR3еݱ
* @param   pkt_len   ĳ(MAX 256)
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/22
************************************************************/
DPP_STATUS dpp_oam_pkt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id, ZXIC_UINT8 *p_buf, ZXIC_UINT32 pkt_len);

#endif

#if ZXIC_REAL("TST_CONFIG")
/***********************************************************/
/** tstỰķͲ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index   (0-9)
* @param   p_tx_cfg   ͲϢμOAM_TST_TX_CFG_T
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/22
************************************************************/
DPP_STATUS dpp_oam_tst_txcfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, OAM_TST_TX_CFG_T  *p_tx_cfg);

/***********************************************************/
/** tstỰļ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index   (0-9)
* @param   p_chk_cfg   Ϣ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/22
************************************************************/
DPP_STATUS dpp_oam_tst_chkcfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, OAM_TST_CHK_CFG_T  *p_chk_cfg);

/***********************************************************/
/** TST,tst֧10Ŀÿռ256ֽ
* @param   dev_id    оƬIDţֶ֧оƬ
* @param   index   (0-9)
* @param   p_data       tstݱ
* @param   pkt_len      ĳ(0-256)
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/21
************************************************************/
DPP_STATUS dpp_oam_tst_pkt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT8 *p_data, ZXIC_UINT32 pkt_len);

#endif


#if ZXIC_REAL("EX_CONFIG")
/***********************************************************/
/** TM DDR3ԼϢTSTܣ֧Լ챨ĸ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index    (0-9) ʵֻ֧һTMԼỰ
* @param   tx_en   Լʹܱ־
* @param   count   Լ챨ĵĸ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/08/07
************************************************************/
DPP_STATUS dpp_oam_tm_self_test_txcfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 tx_en, ZXIC_UINT32 count);

/***********************************************************/
/** TM DDR3ԼıϢTSTܣ֧ñĳ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index   (0-9)
* @param   pkt_len   ܵıĳȣӲǰ256ֽдRAMУ256ֽڵĲ֣߼
* @param   p_data   ,֧256ֽ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/08/07
************************************************************/
DPP_STATUS dpp_oam_tm_self_test_pkt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 pkt_len, ZXIC_UINT8 *p_data);

/***********************************************************/
/** DDR3ԼϢ,TSTܣ֧Լ챨ĸ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index    (0-9) ʵֻ֧һDDRԼỰ
* @param   tx_en   Լʹܱ־
* @param   seqid_offset   ɱֶεͷƫӲ̶ֶк
* @param   count   Լ챨ĵĸ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/08/07
************************************************************/
DPP_STATUS dpp_oam_ddr_self_test_txcfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 tx_en, ZXIC_UINT32 seqid_offset, ZXIC_UINT32 count);

/***********************************************************/
/** DDRԼıϢ,TSTܣ֧ñĳ,кŵƫ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index    (0-9)
* @param   pkt_len   ܵıĳȣӲǰ256ֽдRAMУ256ֽڵĲ֣߼
* @param   p_data   ,֧256ֽ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/08/07
************************************************************/
DPP_STATUS dpp_oam_ddr_self_test_pkt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 pkt_len, ZXIC_UINT8 *p_data);

/***********************************************************/
/** ÿϻϢTSTܣ֧ñĸ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index    (0-9) ʵֻ֧һ
* @param   tx_en    ϻʹܱ־
* @param   seqid_offset   ɱֶεͷƫӲ̶ֶк
* @param   count   ϻĵĸ
* @param   send_period   ͱĵ(3bits)֧1:50kpps,2:100kpps,3:150kpps 4:200kpps 5:250kpps 6:300kpps
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/08/08
************************************************************/
DPP_STATUS dpp_oam_fast_aging_txcfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 tx_en, ZXIC_UINT32 seqid_offset, ZXIC_UINT32 count, ZXIC_UINT32 send_period);

/***********************************************************/
/** ÿϻıϢTSTܣ֧ñĳ,
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index    (0-9)
* @param   pkt_len      ĳ
* @param   p_data   ,֧256ֽ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/08/07
************************************************************/
DPP_STATUS dpp_oam_fast_aging_pkt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 pkt_len, ZXIC_UINT8 *p_data);

/***********************************************************/
/** ñ͵ĻỰϢTSTܣ֧÷Ƶʣٷģʽ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index   (0-9)
* @param   p_tx_cfg   ͲϢμOAM_BACKGROUD_FLOW_TX_CFG_T
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/08/07
************************************************************/
DPP_STATUS dpp_oam_backgroud_flow_txcfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, OAM_BACKGROUD_FLOW_TX_CFG_T  *p_tx_cfg);

/***********************************************************/
/** ñıϢTSTܣ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index    (0-9)
* @param   pkt_len   ܵıĳȣӲǰ256ֽдRAMУ256ֽڵĲ֣߼0
* @param   p_data   ,֧256ֽ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/08/07
************************************************************/
DPP_STATUS dpp_oam_backgroud_flow_pkt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 pkt_len, ZXIC_UINT8 *p_data);

/***********************************************************/
/**  öʱϻ͵ĻỰϢ֧ñĸڣʱϻ
* @param   dev_id    оƬIDţֶ֧оƬ
* @param   index    (0-9)ʵֻ֧һ
* @param   p_tx_cfg    ͲϢ
*          send_period   ͱĵ(3bits)֧1:50kpps,2:100kpps,3:150kpps 4:200kpps 5:250kpps 6:300kpps
*          aging_freq    ʱϻ(16bits)0.1s,Χ1~65535
* @param   count   ʱϻͱĸ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/13
************************************************************/
DPP_STATUS dpp_oam_timing_aging_txcfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, OAM_AGING_TX_CFG_T  *p_tx_cfg, ZXIC_UINT32 count);

/***********************************************************/
/** öʱϻıϢTSTܣ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index    (0-9)
* @param   seqid_offset   ɱֶεͷƫӲ̶ֶк
* @param   pkt_len   ĳ
* @param   p_data   ,֧256ֽ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/08/07
************************************************************/
DPP_STATUS dpp_oam_timing_aging_pkt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 pkt_len, ZXIC_UINT8 *p_data);

#endif

#if ZXIC_REAL("FST_SWCH")
/***********************************************************/
/** ÿбoam
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   oam_type    бͷеoam
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_fst_swch_type_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_type);

/***********************************************************/
/** ÿбͷ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   Dmac     Ŀmac
* @param   Smac     Դmac
* @param   E_type   ̫
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_fst_swch_head_set(ZXIC_UINT32 dev_id, ZXIC_UINT64 Dmac, ZXIC_UINT64 Smac, ZXIC_UINT32 E_type);

#endif


#if ZXIC_REAL("2544")
/***********************************************************/
/** 2544ỰķͲ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   index   (0~127)
* @param   p_tx_cfg   ͲϢμOAM_2544_TX_CFG_T
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2016/02/22
************************************************************/
DPP_STATUS dpp_oam_2544_txcfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, OAM_2544_TX_CFG_T  *p_tx_cfg);

/***********************************************************/
/** 2544,ÿռ64ֽ
* @param   dev_id    оƬIDţֶ֧оƬ
* @param   index        Ự(0-127)
* @param   p_data       ݱ
* @param   pkt_len      ĳ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2016/02/21
************************************************************/
DPP_STATUS dpp_oam_2544_pkt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT8 *p_data, ZXIC_UINT32 pkt_len);

#endif

#if ZXIC_REAL("PON_PROTECT")
/***********************************************************/
/** pon򿪹ģʹ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   pon_id   ponںţ0~31
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2017/12/12
************************************************************/
DPP_STATUS dpp_oam_pon_laser_on_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 enable);

/***********************************************************/
/** ponйģʹ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_ponall_laser_on_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

/***********************************************************/
/** ponعģʹ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   pon_id   ponںţ0~31
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_pon_laser_off_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 enable);

/***********************************************************/
/** ȡponعģʹܿص״̬
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   pon_id   ponںţ0~31
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_pon_laser_off_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 *p_enable);

/***********************************************************/
/** ponйģʹ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_ponall_laser_off_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

/***********************************************************/
/** ponбķʹ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   pon_id   ponںţ0~31
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_pon_pkt_tx_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 enable);

/***********************************************************/
/** ponпбķʹ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_ponall_pkt_tx_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

/***********************************************************/
/** pon·
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   pon_id   ponںţ0~31
* @param   value  0:   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2017/12/12
************************************************************/
DPP_STATUS dpp_oam_pon_master_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 value);

/***********************************************************/
/** pon·
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   value          32bitʾ32ponڵ·ֵ0:   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_ponall_master_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

/***********************************************************/
/** ponĵƽ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   pon_id   ponںţ0~31
* @param   value  ponڵĵƽֵ
*            0los01·SD0·11los0·1SD01·
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2017/12/12
************************************************************/
DPP_STATUS dpp_oam_pon_level_model_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 value);

/***********************************************************/
/** ponеĵƽ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   value          32bitʾ32ponڵĵƽֵ
*            0los01·SD0·11los0·1SD01·
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_ponall_level_model_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

/***********************************************************/
/** ponжϱʹ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   pon_id    ponںţ0~31
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_pon_int_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 enable);

/***********************************************************/
/** ponжϱʹ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   enable   ʹܱ־0:ر   1:
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_ponall_int_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

/***********************************************************/
/** pontype_bPON SD¼ȡֵ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   value 8bitμĵ2ʾtypebPNO SD
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_pon_ti_sd_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

/***********************************************************/
/** pontype_bPON LOS¼ȡֵ
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   value   8bitμĵ1ʾtypebPNO LOS
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2015/02/04
************************************************************/
DPP_STATUS dpp_oam_pon_ti_los_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);

/***********************************************************/
/** pon,ÿռ64ֽ
* @param   dev_id    оƬIDţֶ֧оƬ
* @param   index           (0-31)
* @param   p_data       ݱ
* @param   pkt_len      ĳ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2014/02/21
************************************************************/
DPP_STATUS dpp_oam_pon_pkt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT8 *p_data, ZXIC_UINT32 pkt_len);

#endif

/***********************************************************/
/** TPBFDװޣʱ䵥λ(0.1ms),Ĭֵ52S)
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   chk_th   װֵ
*
* @return  DPP_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2017/02/14
************************************************************/
DPP_STATUS dpp_oam_tpbfd_first_chk_time_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 chk_th);

/***********************************************************/
/** TPCCMװޣʱ䵥λ(0.1ms),Ĭֵ52S)
* @param   dev_id   оƬIDţֶ֧оƬ
* @param   chk_th   װֵ
*
* @return  DPP_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  PJ      @date  2017/02/14
************************************************************/
DPP_STATUS dpp_oam_tpccm_first_chk_time_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 chk_th);





#endif
#endif



