/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_pktrx_api.h
* ļʶ : 
* ժҪ : 
* ˵ : 
* ǰ汾 : 
*      : zzh
*  : 2015/02/05
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef _DPP_PKTRX_API_H_
#define _DPP_PKTRX_API_H_

#include "zxic_common.h"

#if ZXIC_REAL("header file")
#include "dpp_module.h"
#include "dpp_reg.h"
#endif

#if ZXIC_REAL("data struct define")

#if ZXIC_REAL("DPP ADD ")
typedef struct dpp_mr_cnt_t
{
    ZXIC_UINT32 mr_sop_in_cnt; /**< @brief mrsop */
    ZXIC_UINT32 mr_eop_in_cnt; /**< @brief mreop */
    ZXIC_UINT32 mr_sop_out_cnt; /**< @brief mrsop */
    ZXIC_UINT32 mr_eop_out_cnt; /**< @brief mreop */
    ZXIC_UINT32 mr_cos0_in_cnt; /**< @brief mrcos0 */
    ZXIC_UINT32 mr_cos1_in_cnt; /**< @brief mrcos1 */
    ZXIC_UINT32 mr_cos2_in_cnt; /**< @brief mrcos2 */
    ZXIC_UINT32 mr_cos3_in_cnt; /**< @brief mrcos3 */
    ZXIC_UINT32 mr_cos0_out_cnt; /**< @brief mrcos0 */
    ZXIC_UINT32 mr_cos1_out_cnt; /**< @brief mrcos1 */
    ZXIC_UINT32 mr_cos2_out_cnt; /**< @brief mrcos2 */
    ZXIC_UINT32 mr_cos3_out_cnt; /**< @brief mrcos3 */
    ZXIC_UINT32 mr_err_in_cnt; /**< @brief mrerrļ */
}DPP_MR_CNT_T;

typedef struct dpp_isu_dbg_cnt_t
{
    ZXIC_UINT32 idma_in_isu_vld_cnt; /**< @brief idma͸isu */
    ZXIC_UINT32 ppu_in_isu_vld_cnt; /**< @brief ppu͸isu(С) */
    ZXIC_UINT32 idma_in_isu_err_cnt; /**< @brief idma͸isu err */
    ZXIC_UINT32 idma_in_isu_tdm_uc_cnt; /**< @brief idma͸isu tdm */
    ZXIC_UINT32 idma_in_isu_tdm_mc_cnt; /**< @brief idma͸isu tdm鲥 */
    ZXIC_UINT32 isu_desc_vld_cnt; /**< @brief isuͱ */
    ZXIC_UINT32 isu_odma_desc_vld_cnt; /**< @brief isu͸odma */
    ZXIC_UINT32 isu_ppu_desc_vld_cnt; /**< @brief isu͸ppu */
    ZXIC_UINT32 isu_odma_err_cnt; /**< @brief isu͸odma err */
    ZXIC_UINT32 isu_odma_tdmuc_cnt;/**< @brief isu͸odma tdmuc */
    ZXIC_UINT32 isu_odma_tdmmc_cnt;/**< @brief isu͸odma tdmmc */
    ZXIC_UINT32 isu_ppu_fifo_fc_cnt; /**< @brief isu͸ppuؼ */
    ZXIC_UINT32 ppu_isu_uc_rdy_cnt; /**< @brief ppu͸isuؼ */
    ZXIC_UINT32 ppu_isu_mc_rdy_cnt; /**< @brief ppu͸isu鲥ؼ */
    ZXIC_UINT32 odma_tdm_uc_rdy_cnt; /**< @brief odmatdmؼ */
    ZXIC_UINT32 odma_tdm_mc_rdy_cnt; /**< @brief odmatdm鲥ؼ */
    ZXIC_UINT32 odma_tdm_err_rdy_cnt; /**< @brief odmatdm errؼ */
    ZXIC_UINT32 isu_ppu_loopback_mc_cnt; /**< @brief isu͸ppu鲥ؼ */
    ZXIC_UINT32 isu_ppu_sa_mc_cnt; /**< @brief isu͸ppu sa鲥ؼ */
    ZXIC_UINT32 isu_ppu_loopback_rdy_cnt; /**< @brief isu͸ppuؼ */
}DPP_ISU_DBG_CNT_T;


typedef struct dpp_pktrx_analogport_change_en_t
{
    ZXIC_UINT32 analogport_sgmii0; /**< @brief sgmii0ģ˿ʹ */
    ZXIC_UINT32 analogport_sgmii1; /**< @brief sgmii1ģ˿ʹ */
    ZXIC_UINT32 analogport_oamtst; /**< @brief oamtstģ˿ʹ */
    ZXIC_UINT32 analogport_oamtx; /**< @brief oamtxģ˿ʹ */
}DPP_PKTRX_ANALOGPORT_CHANGE_EN_T;

typedef struct dpp_pktrx_parser_max_len_cfg_t
{
     ZXIC_UINT32 pktrx_parser_max_len_en;                                      /**< @brief ʹ */
     ZXIC_UINT32 pktrx_parser_max_len;                                                   /**< @brief  ֵ*/
}DPP_PKTRX_PARSER_MAX_LEN_CFG_T;

typedef struct dpp_pktrx_parser_min_len_cfg_t
{
     ZXIC_UINT32 pktrx_parser_min_len_en;                                       /**< @brief Сʹ */
     ZXIC_UINT32 pktrx_parser_min_len;                                                    /**< @brief ֵ*/
}DPP_PKTRX_PARSER_MIN_LEN_CFG_T;

typedef struct dpp_pktrx_ex_tpid_t
{
     ZXIC_UINT32 cfg_tpid_0;  /**< @brief vlan vid0 */                                     
     ZXIC_UINT32 cfg_tpid_1;  /**< @brief vlan vid1 */                                        
     ZXIC_UINT32 cfg_tpid_2;  /**< @brief vlan vid2 */                                      
     ZXIC_UINT32 cfg_tpid_3;  /**< @brief vlan vid3 */                                   
}DPP_PKTRX_EX_TPID_T;

typedef struct dpp_pktrx_in_tpid_t
{
     ZXIC_UINT32 cfg_in_tpid_0;  /**< @brief ڲvlan vid0 */                                         
     ZXIC_UINT32 cfg_in_tpid_1;  /**< @brief ڲvlan vid1 */                                      
     ZXIC_UINT32 cfg_in_tpid_2;  /**< @brief ڲvlan vid2 */                                    
     ZXIC_UINT32 cfg_in_tpid_3;  /**< @brief ڲvlan vid3 */                                 
}DPP_PKTRX_IN_TPID_T;

typedef struct dpp_pktrx_hdu_hdlc_t
{
     ZXIC_UINT32 hdlc_cfg0_type;  /**< @brief hdlcԶ0 */                                       
     ZXIC_UINT32 hdlc_cfg1_type;  /**< @brief hdlcԶ1 */                                      
     ZXIC_UINT32 hdlc_cfg2_type;  /**< @brief hdlcԶ2 */                                    
     ZXIC_UINT32 hdlc_cfg3_type;  /**< @brief hdlcԶ3 */                                 
}DPP_PKTRX_HDU_HDLC_T;

typedef struct dpp_pktrx_udf_l3type_t
{
     ZXIC_UINT32 cfg_l3type_0;    /**< @brief l3_typeԶ0 */                                     
     ZXIC_UINT32 cfg_l3type_1;    /**< @brief l3_typeԶ1 */                                    
     ZXIC_UINT32 cfg_l3type_2;    /**< @brief l3_typeԶ2 */                                  
     ZXIC_UINT32 cfg_l3type_3;    /**< @brief l3_typeԶ3 */                               
     ZXIC_UINT32 cfg_l3type_4;    /**< @brief l3_typeԶ4 */                                     
     ZXIC_UINT32 cfg_l3type_5;    /**< @brief l3_typeԶ5 */                                    
     ZXIC_UINT32 cfg_l3type_6;    /**< @brief l3_typeԶ6 */                                  
     ZXIC_UINT32 cfg_l3type_7;    /**< @brief l3_typeԶ7 */                               
}DPP_PKTRX_UDF_L3TYPE_T;

typedef struct dpp_pktrx_udf_l4type_t
{
     ZXIC_UINT32 cfg_l4type_0;   /**< @brief l4_typeԶ0 */                                      
     ZXIC_UINT32 cfg_l4type_1;   /**< @brief l4_typeԶ1 */                                   
     ZXIC_UINT32 cfg_l4type_2;   /**< @brief l4_typeԶ2 */                                 
     ZXIC_UINT32 cfg_l4type_3;   /**< @brief l4_typeԶ3 */                              
     ZXIC_UINT32 cfg_l4type_4;   /**< @brief l4_typeԶ4 */                                    
     ZXIC_UINT32 cfg_l4type_5;   /**< @brief l4_typeԶ5 */                                   
     ZXIC_UINT32 cfg_l4type_6;   /**< @brief l4_typeԶ6 */                                 
     ZXIC_UINT32 cfg_l4type_7;   /**< @brief l4_typeԶ7 */
     ZXIC_UINT32 cfg_l4type_8;   /**< @brief l4_typeԶ8 */                                    
     ZXIC_UINT32 cfg_l4type_9;   /**< @brief l4_typeԶ9 */                                   
     ZXIC_UINT32 cfg_l4type_10;  /**< @brief l4_typeԶ10 */                                  
}DPP_PKTRX_UDF_L4TYPE_T;

typedef struct dpp_pktrx_phyport_table_0_t
{
    ZXIC_UINT32 table_vld;    /**< @brief Чλ */                      
    ZXIC_UINT32 port_ts_mode;  /**< @brief ʱģʽ 1-ʹ 0-ʹ Ϊ1ʱҪl2_offset2 */                            
    ZXIC_UINT32 port_type;  /**< @brief ˿ */                              
    ZXIC_UINT32 port_decode_type; /**< @brief  */              
    ZXIC_UINT32 port_l2_offset;  /**< @brief 㱨Ľƫ */                     
    ZXIC_UINT32 port_rsv_0;                              
    ZXIC_UINT32 port_base_mac_hi_16;  /**< @brief ˿ڻmac16bit */          
    ZXIC_UINT32 port_base_mac_lw_32;  /**< @brief ˿ڻmac32bit */
    ZXIC_UINT32 port_cos_map_mode; /**< @brief cosģʽ*/
    ZXIC_UINT32 port_flownum_type; /**< @brief flownumȡʽ */
    ZXIC_UINT32 port_flowtcam_en; /**< @brief tcamʹܱ 00-tcamʹ 01-ʹܵһ 2-ʹܵڶ 3-ʹ*/
    ZXIC_UINT32 port_tcam0_mode; /**< @brief һtcam;ָʾ 0-pc 1-icu*/
    ZXIC_UINT32 port_tcam1_mode; /**< @brief ڶtcam;ָʾ 0-pc 1-icu*/
    ZXIC_UINT32 port_cos_map_bit_offset; /**< @brief externalģʽȡʼλ*/
    ZXIC_UINT32 port_cos_map_bit_len; /**< @brief externalȡbit*/
    ZXIC_UINT32 port_rsv_1;  
    ZXIC_UINT32 port_cos_map_defaut_cos;  /**< @brief Ĭcosֵ*/   
    ZXIC_UINT32 port_cos_map_vlan_en; /**< @brief internalģʽʹvlancos*/      
    ZXIC_UINT32 port_cos_map_mpls_en; /**< @brief internalģʽʹmplscos*/       
    ZXIC_UINT32 port_cos_map_ipv4_en; /**< @brief internalģʽʹipv4cos*/       
    ZXIC_UINT32 port_cos_map_ipv6_en; /**< @brief internalģʽʹipv6cos*/ 
    ZXIC_UINT32 port_pc_tcam_udf[9]; /**< @brief pc tcamûԶƫ0-8*/
    ZXIC_UINT32 port_icu_tcam_udf[9]; /**< @brief icu tcamûԶƫ0-8*/
}DPP_PKTRX_PHYPORT_TABLE_0_T;

typedef struct dpp_pktrx_phyport_table_1_t
{
    ZXIC_UINT32 port_rsv;              /**< @brief  1b */
    ZXIC_UINT32 port_default_pc;      /**< @brief 15b ˿Ĭʼpc*/
    ZXIC_UINT32 port_table_vld;        /**< @brief 1b ˿ڱʹ*/
    ZXIC_UINT32 port_default_flownum;  /**< @brief 8b ˿Ĭpc*/      
}DPP_PKTRX_PHYPORT_TABLE_1_T;

typedef struct dpp_pktrx_phyport_udf_table_t
{
    ZXIC_UINT32 port_based_user_data[4];     /**< @brief ûԶ */
}DPP_PKTRX_PHYPORT_UDF_TABLE_T;


typedef struct dpp_pktrx_tcam_dt_table_t
{

    ZXIC_UINT32 tcam_key_mode;                /**< @brief  1b  0:cos 1:start_pc+flownum */
    ZXIC_UINT32 tcam_key_mask_mode;
    ZXIC_UINT32 tcam_key_port_num;            /**<  @brief  ˿ 7b*/
    ZXIC_UINT32 tcam_key_mask_port_num;            
    ZXIC_UINT32 tcam_key_dmac_h24;               /**< @brief Ŀmac24bit */
    ZXIC_UINT32 tcam_key_mask_dmac_h24;
    ZXIC_UINT32 tcam_key_dmac_l24;                /**< @brief Ŀmac24bit */
    ZXIC_UINT32 tcam_key_mask_dmac_l24;
    ZXIC_UINT32 tcam_key_l3type;                /**< @brief l3_ֶ 16b*/
    ZXIC_UINT32 tcam_key_mask_l3type;
    ZXIC_UINT32 tcam_key_priority;                  /**< @brief priority 3b*/
    ZXIC_UINT32 tcam_key_mask_priority;
    ZXIC_UINT32 tcam_key_cfi;                  /**< @brief cfi 1b */
    ZXIC_UINT32 tcam_key_mask_cfi;
    ZXIC_UINT32 tcam_key_ex_vlanid;                  /**< @brief ex_vlanid 12b */
    ZXIC_UINT32 tcam_key_mask_ex_vlanid;
    ZXIC_UINT32 tcam_key_udf_h8;                  /**< @brief udf8bit(udf8) */
    ZXIC_UINT32 tcam_key_mask_udf_h8;
    ZXIC_UINT32 tcam_key_udf_m32;         /**< @brief udfм32bit(udf7 udf6 udf5 udf4) */
    ZXIC_UINT32 tcam_key_mask_udf_m32;               
    ZXIC_UINT32 tcam_key_udf_l32;         /**< @brief udf32bit(udf3 udf2 udf1 udf0) */
    ZXIC_UINT32 tcam_key_mask_udf_l32;          

    ZXIC_UINT32 tcam_result_flownum;         /**< @brief flownum  8b*/
    ZXIC_UINT32 tcam_result_vld;                 /**< @brief vld 1b*/
    ZXIC_UINT32 tcam_result_table_type;         /**< @brief table_type 1b 0:pc  1:cos  */
    ZXIC_UINT32 tcam_result_pc_or_cos;      /**< @brief start_pc 14b  cos 3b table_type*/

}DPP_PKTRX_TCAM_DT_TABLE_T;

typedef struct dpp_pktrx_tcam_xy_table_t
{
    ZXIC_UINT32 xytcam_x[5];
    ZXIC_UINT32 xytcam_y[5];
    ZXIC_UINT32 tcam_result_flownum;           /**< @brief flownum  8b */
    ZXIC_UINT32 tcam_result_vld;                  /**< @brief vld 1b*/
    ZXIC_UINT32 tcam_result_table_type;                  /**< @brief table_type 1b 0:pc  1:cos  */
    ZXIC_UINT32 tcam_result_pc_or_cos;                  /**< @brief start_pc 14b  cos 3b table_type */
}DPP_PKTRX_TCAM_XY_TABLE_T;

typedef struct dpp_pktrx_isch_aging_cfg_t
{
    ZXIC_UINT32 aging_en;      /**< @brief 0:رϻ,1:ϻ */
    ZXIC_UINT32 aging_th;      /**< @brief ϻֵλ:ʱ1s=600MPPS */      
}DPP_PKTRX_ISCH_AGING_CFG_T;

typedef struct dpp_pktrx_sch_fifo_fc_th_t
{
    ZXIC_UINT32 sch_fifo_0_fc_th; /**< @brief ischfifo0ֵ*/                                                                 
    ZXIC_UINT32 sch_fifo_1_fc_th; /**< @brief ischfifo1ֵ*/                                                             
    ZXIC_UINT32 sch_fifo_2_fc_th; /**< @brief ischfifo2ֵ*/                                                                
    ZXIC_UINT32 sch_fifo_3_fc_th; /**< @brief ischfifo3ֵ*/                                                                          
    ZXIC_UINT32 sch_fifo_4_fc_th; /**< @brief ischfifo4ֵ*/                                                                      
    ZXIC_UINT32 sch_fifo_5_fc_th; /**< @brief ischfifo5ֵ*/                                                                   
    ZXIC_UINT32 sch_fifo_6_fc_th; /**< @brief ischfifo6ֵ*/                                                                     
    ZXIC_UINT32 sch_fifo_7_fc_th; /**< @brief ischfifo7ֵ*/     
    ZXIC_UINT32 sch_fifo_8_fc_th; /**< @brief ischfifo8ֵ*/     
}DPP_PKTRX_SCH_FIFO_FC_TH_T;

typedef struct dpp_pktrx_sch_fifo_drop_th_t
{
    ZXIC_UINT32 sch_fifo_0_drop_th; /**< @brief ischfifo0ֵ*/                                                                     
    ZXIC_UINT32 sch_fifo_1_drop_th; /**< @brief ischfifo1ֵ*/                                                             
    ZXIC_UINT32 sch_fifo_2_drop_th; /**< @brief ischfifo2ֵ*/                                                                
    ZXIC_UINT32 sch_fifo_3_drop_th; /**< @brief ischfifo3ֵ*/                                                                          
    ZXIC_UINT32 sch_fifo_4_drop_th; /**< @brief ischfifo4ֵ*/                                                                      
    ZXIC_UINT32 sch_fifo_5_drop_th; /**< @brief ischfifo5ֵ*/                                                                   
    ZXIC_UINT32 sch_fifo_6_drop_th; /**< @brief ischfifo6ֵ*/                                                                     
    ZXIC_UINT32 sch_fifo_7_drop_th; /**< @brief ischfifo7ֵ*/     
    ZXIC_UINT32 sch_fifo_8_drop_th; /**< @brief ischfifo8ֵ*/     
}DPP_PKTRX_SCH_FIFO_DROP_TH_T;


typedef struct dpp_pktrx_sch_wrr_t
{                                                           
    ZXIC_UINT32 sch_wrr1_weight1;        /** һȨ1 odmaض */                                                             
    ZXIC_UINT32 sch_sp_sel;              /** ȼȲѡ*/
}DPP_PKTRX_SCH_WRR_T;

typedef struct dpp_pktrx_int_status_t
{
    ZXIC_UINT32 pktrx_tcam_result1_parity_err;               /**< @brief 31-1У */
    ZXIC_UINT32 pktrx_tcam_result0_parity_err;               /**< @brief 30-0żУ */
    ZXIC_UINT32 pktrx_phyport_table_2_parity_err;       /**< @brief 29-˿Ա2żУ */
    ZXIC_UINT32 pktrx_phyport_table_1_parity_err;             /**< @brief 28-û˿ԱżУ */
    ZXIC_UINT32 pktrx_phyport_table_0_parity_err;               /**< @brief 27-isuppuزָhead_ram3ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_8_parity_err;               /**< @brief 26-isuppuزָhead_ram2ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_7_parity_err;               /**< @brief 25-isuppuزָhead_ram1ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_6_parity_err;               /**< @brief 24-isuppuزָhead_ram0ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_5_parity_err;                           /**< @brief 23-isulifָhead_ram3ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_4_parity_err;                           /**< @brief 22-isulifָhead_ram2ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_3_parity_err;                           /**< @brief 21-isulifָhead_ram1ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_2_parity_err;                           /**< @brief 20-isulifָhead_ram0ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_1_parity_err;                  /**< @brief 19-isuppuزָtail_ram1ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_0_parity_err;                  /**< @brief 18-isuppuزָtail_ram0ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_8_underflow;                              /**< @brief 17-isulifָtail_ram1ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_7_underflow;                              /**< @brief 16-isulifָtail_ram0ecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_6_underflow;                    /**< @brief 15-isuppuزָnaf_ramecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_5_underflow;                                /**< @brief 14-isulifָnaf_ramecc_double_err */
    ZXIC_UINT32 pktrx_isch_fifo_4_underflow;                /**< @brief 13-isuppuزָhead_ram3ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_3_underflow;                /**< @brief 12-isuppuزָhead_ram2ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_2_underflow;                /**< @brief 11-isuppuزָhead_ram1ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_1_underflow;                /**< @brief 10-isuppuزָhead_ram0ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_0_underflow;                            /**< @brief 9-isulifָhead_ram3ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_8_overflow;                            /**< @brief 8-isulifָhead_ram2ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_7_overflow;                            /**< @brief 7-isulifָhead_ram1ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_6_overflow;                            /**< @brief 6-isulifָhead_ram0ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_5_overflow;                   /**< @brief 5-isuppuزָtail_ram1ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_4_overflow;                   /**< @brief 4-isuppuزָtail_ram0ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_3_overflow;                               /**< @brief 3-isulifָtail_ram1ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_2_overflow;                               /**< @brief 2-isulifָtail_ram0ecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_1_overflow;                     /**< @brief 1-isuppuزָnaf_ramecc_single_err */
    ZXIC_UINT32 pktrx_isch_fifo_0_overflow;                                 /**< @brief 0-isulifָnaf_ramecc_single_err */

    ZXIC_UINT32 pktrx_debug_ram_parity_err;                           /**< @brief 35-pktrx_sch tmfifoѿպȨ */
    ZXIC_UINT32 pktrx_capture_ram_parity_err;                      /**< @brief 34-pktrx_sch odmafifoѿպȨ */
    ZXIC_UINT32 pktrx_aging_fifo_1_parity_err;                    /**< @brief 33-pktrx_sch lif_ctrlfifoѿպȨ */
    ZXIC_UINT32 pktrx_aging_fifo_0_parity_err;                        /**< @brief 32-pktrx_sch oamfifoѿպȨ */
}DPP_PKTRX_INT_STATUS_T;

typedef struct pktrx_sch_pfc_rdy_t
{
    ZXIC_UINT32 pktrx_trpgrx_cge0_pfc_rdy_0; /**< @brief ischlif0ȼ״̬*/ 
    ZXIC_UINT32 pktrx_trpgrx_cge1_pfc_rdy_1; /**< @brief ischlif0ȼ״̬*/ 
    ZXIC_UINT32 pktrx_trpgrx_xge_pfc_rdy_2; /**< @brief ischlif0ȼ״̬*/ 
    ZXIC_UINT32 pktrx_trpgrx_ipg0_pfc_rdy_3; /**< @brief ischlif0ȼ״̬*/ 
    ZXIC_UINT32 pktrx_trpgrx_ipg0_pfc_rdy_4; /**< @brief ischlif0ȼ״̬*/ 
    ZXIC_UINT32 pktrx_trpgrx_ipg0_pfc_rdy_5; /**< @brief ischlif0ȼ״̬*/ 
    ZXIC_UINT32 pktrx_trpgrx_ipg1_pfc_rdy_6; /**< @brief ischlif0ȼ״̬*/    
}PKTRX_SCH_PFC_RDY_T;

typedef DPP_NPPU_PKTRX_CFG_PKTRX_PORT_RDY0_T PKTRX_SCH_FC_RDY_T;

typedef struct dpp_pktrx_mcode_glb_cfg_t
{
    ZXIC_UINT32 pktrx_mcode_glb_cfg_data[4];     /**< @brief ȫ(΢)*/ 
}DPP_PKTRX_MCODE_GLB_CFG_T;

typedef struct dpp_isu_dwrr_cfg_t
{
    ZXIC_UINT32 isu_weight_normal_uc;  /**< @brief isu normalȨ*/    
    ZXIC_UINT32 isu_weight_normal_mc;  /**< @brief isu normalಥȨ*/     
    ZXIC_UINT32 isu_weight_sa_mc; /**< @brief isu sa鲥Ȩ*/      
    ZXIC_UINT32 isu_weight_etm;   /**< @brief isu etmȨ*/   
    ZXIC_UINT32 isu_weight_lp_mc;   /**< @brief isu lp鲥Ȩ*/    
    ZXIC_UINT32 isu_weight_oam;   /**< @brief isu oam鲥Ȩ*/   
    ZXIC_UINT32 isu_lif_ctrl1;   /**< @brief isu lifc1鲥Ȩ*/   
    ZXIC_UINT32 isu_lif_ctrl2;   /**< @brief isu lifc2鲥Ȩ*/   
}DPP_ISU_DWRR_CFG_T;

typedef struct dpp_isu_crdt_cfg_t
{
    ZXIC_UINT32 isu_crdt_cfg_cycle_offset;     
    ZXIC_UINT32 isu_crdt_cfg_cycle_value;     
}DPP_ISU_CRDT_CFG_T;


typedef struct dpp_isu_ppu_fifo_t
{
    ZXIC_UINT32 isu_ppu_fdbk_fifo_fc;  
}DPP_ISU_PPU_FIFO_T;

#endif



typedef struct dpp_pktrx_phyport_table_2_t
{

    ZXIC_UINT32 port_based_rsv;                    /**< @brief default 0 */
    ZXIC_UINT32 port_based_flownum;            /**< @brief ȡppuı*/
    ZXIC_UINT32 port_based_start_pc;            /**< @brief ȡppuʼpc */

}DPP_PKTRX_PHYPORT_TBL_2_T;


typedef struct dpp_pktrx_icu_tcam_table_t
{

    ZXIC_UINT32 icu_key_port_type;                /**< @brief ˿ */
    ZXIC_UINT32 icu_key_mask_port_type;
    ZXIC_UINT32 icu_key_dmac_h16;               /**< @brief Ŀmac16bit */
    ZXIC_UINT32 icu_key_mask_dmac_h16;
    ZXIC_UINT32 icu_key_dmac_l32;                /**< @brief Ŀmac32bit */
    ZXIC_UINT32 icu_key_mask_dmac_l32;
    ZXIC_UINT32 icu_key_headtype;                /**< @brief l2_ֶ */
    ZXIC_UINT32 icu_key_mask_headtype;
    ZXIC_UINT32 icu_key_subtype;                  /**< @brief subtype */
    ZXIC_UINT32 icu_key_mask_subtype;
    ZXIC_UINT32 icu_key_protocol;                  /**< @brief L3_Эֶ */
    ZXIC_UINT32 icu_key_mask_protocol;
    ZXIC_UINT32 icu_key_src_port;                  /**< @brief L4Դ˿ں */
    ZXIC_UINT32 icu_key_mask_src_port;
    ZXIC_UINT32 icu_key_dst_port;                  /**< @brief L4ĿĶ˿ں */
    ZXIC_UINT32 icu_key_mask_dst_port;
    ZXIC_UINT32 icu_result_tbl_vld_flag;         /**< @brief vldλ */
    ZXIC_UINT32 icu_result_tbl_cos;                 /**< @brief icu cos */

}DPP_PKTRX_ICU_TCAM_TABLE_T;



typedef struct dpp_pktrx_icu_tcam_rd_table_t
{
    ZXIC_UINT32 xytcam_x[4];
    ZXIC_UINT32 xytcam_y[4];
    ZXIC_UINT32 icu_result_tbl_vld_flag;           /**< @brief vldλ */
    ZXIC_UINT32 icu_result_tbl_cos;                  /**< @brief icuȡcos */

}DPP_PKTRX_ICU_TCAM_RD_TABLE_T;


typedef struct dpp_pktrx_glbcsr_hdu_cfg_t
{
    ZXIC_UINT32 pktrx_hdu_cfg_ing_flownum_based_pkt_head_flag;      /**< @brief ͨͷȡflownumʹܱ */
    ZXIC_UINT32 pktrx_hdu_cfg_ing_pkt_base;                                          /**< @brief бĻȡflownumʱıĵַƫ */
    ZXIC_UINT32 pktrx_hdu_cfg_eg_pkt_base;                                           /**< @brief бĻȡflownumʱıĵַƫ */
    ZXIC_UINT32 pktrx_hdu_cfg_fabric_type;                                             /**< @brief saģʽ0:sa, 1:  */
    ZXIC_UINT32 pktrx_hdu_cfg_flownum_type;                                         /**< @brief flownumȡʽ 0: ڶ˿,1: */
    ZXIC_UINT32 pktrx_hdu_cfg_base_mac_h16;                                       /**< @brief mac H16bit */
    ZXIC_UINT32 pktrx_hdu_cfg_base_mac_l32;                                        /**< @brief mac L32bit */
    ZXIC_UINT32 pktrx_hdu_cfg_slot_no;                                                    /**< @brief λ*/
}DPP_PKTRX_GLBCSR_HDU_CFG_T;

typedef struct dpp_pktrx_cos_meter_cfg_t
{
    ZXIC_UINT32 car_en;                                                                             /**< @brief ppucarʹ */
    ZXIC_UINT32 cir;                                                                             /**< @brief ŵ СȽӽ1MppsԱ仯0x24aӦ600Mppsÿ1ʴű仯0.97mpps  */
    ZXIC_UINT32 eir;                                                                             /**< @brief Ϣʣøcirͬ*/
    ZXIC_UINT32 cbs;                                                                             /**< @brief ŵͻߴ */
    ZXIC_UINT32 ebs;                                                                             /**< @brief ͻߴ */
    ZXIC_UINT32 green_action;                                                                   /**< @brief 0:drop, 1:pass */
    ZXIC_UINT32 yellow_action;                                                                  /**< @brief 0:drop, 1:pass */
    ZXIC_UINT32 red_action;                                                                       /**< @brief 0:drop, 1:pass */
}DPP_PKTRX_COS_METER_CFG_T;


typedef struct dpp_pktrx_stat_channel_cnt_t
{
    ZXIC_UINT32 isch_i_sop;  /**< @brief isch sop*/ 
    ZXIC_UINT32 isch_i_eop;  /**< @brief isch eop*/ 
    ZXIC_UINT32 err_in;      /**< @brief isch err*/ 
    ZXIC_UINT32 port_down;   /**< @brief isch ˿down*/ 
    ZXIC_UINT32 isch_msop_cnt; /**< @brief isch miss sop*/  
    ZXIC_UINT32 isch_meop_cnt; /**< @brief isch miss eop*/ 
    ZXIC_UINT32 isch_meop_err; /**< @brief isch miss eop err*/ 
    ZXIC_UINT32 isch_msop_drop; /**< @brief isch miss sop*/
    ZXIC_UINT32 isch_pre_msop_drop; /**< @brief isch ǰһƬmiss eop*/
    ZXIC_UINT32 sop_drop;  /**< @brief isch sop*/ 
    ZXIC_UINT32 eop_drop;  /**< @brief isch eop*/  
    ZXIC_UINT32 pkt_drop;  /**< @brief isch */  
    ZXIC_UINT32 aging_err; /**< @brief isch ϻ*/   
    ZXIC_UINT32 vld_drop_err;   /**< @brief мƬ*/ 
}DPP_PKTRX_STAT_CHANNEL_CNT_T;


typedef struct dpp_pktrx_stat_pfu_cnt_t
{
    ZXIC_UINT32 msop_cnt;  /**< @brief pfu msop*/ 
    ZXIC_UINT32 meop_cnt;  /**< @brief pfu meop*/ 
    ZXIC_UINT32 max_len_cnt; /**< @brief pfu */ 
    ZXIC_UINT32 min_len_cnt; /**< @brief pfu С*/   
    ZXIC_UINT32 input_err_cnt;  /**< @brief input err*/ 
    ZXIC_UINT32 meop_err_cnt;   /**< @brief pfu meoperrǼ*/ 
    ZXIC_UINT32 max_len_err_cnt;  /**< @brief pfu errǼ*/ 
    ZXIC_UINT32 sngl_err_drop_cnt;  /**< @brief pfu İerrźŶ*/ 
    ZXIC_UINT32 sngl_max_len_drop_cnt; /**< @brief pfuİ */ 
    ZXIC_UINT32 sngl_min_len_drop_cnt;  /**< @brief pfuİ С*/ 
    ZXIC_UINT32 msop_drop_cnt;   /**< @brief pfuȱsop*/
    ZXIC_UINT32 pre_meop_drop_cnt;  /**< @brief ǰһƬmiss eop*/ 
    ZXIC_UINT32 phy_port_tbl_nvld_drop_cnt;   /**< @brief isch ʹܶ*/
}DPP_PKTRX_STAT_PFU_CNT_T;


typedef struct dpp_pktrx_stat_fc_cnt_t
{
    ZXIC_UINT32 tm_port_rdy_cnt;    /**< @brief tmؼ*/
    ZXIC_UINT32 odma_port_rdy_cnt;  /**< @brief odmaض˿ؼ*/
    ZXIC_UINT32 oam_send_port_rdy0_cnt;  /**< @brief oam˿ؼ0*/
    ZXIC_UINT32 oam_send_port_rdy1_cnt;  /**< @brief oam˿ؼ1*/
    ZXIC_UINT32 tm_pfc_rdy0_cnt; /**< @brief tmȼ0*/
    ZXIC_UINT32 tm_pfc_rdy1_cnt; /**< @brief tmȼ1*/  
    ZXIC_UINT32 tm_pfc_rdy2_cnt; /**< @brief tmȼ2*/  
    ZXIC_UINT32 tm_pfc_rdy3_cnt; /**< @brief tmȼ3*/  
}DPP_PKTRX_STAT_FC_CNT_T;


#endif

#if ZXIC_REAL("macro function define")

#endif


#if ZXIC_REAL("PKTRX_API")
/***********************************************************/
/**  
* @param   dev_id   
* @param   p_max_len_info   
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  lfs      @date  2017/12/12
************************************************************/
DPP_STATUS dpp_pktrx_max_len_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 max_len_en, ZXIC_UINT32 max_len_th);

/***********************************************************/
/**  
* @param   dev_id   
* @param   p_min_len_info   
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  lfs      @date  2017/12/12
************************************************************/
DPP_STATUS dpp_pktrx_min_len_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 min_len_en, ZXIC_UINT32 min_len_th);

/***********************************************************/
/**  
* @param   dev_id   
* @param   saip_en   
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  lfs      @date  2017/12/12
************************************************************/
DPP_STATUS dpp_pktrx_slot_no_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 slot_no);

/***********************************************************/
/**  
* @param   dev_id   
* @param   port_no   
* @param   flag   
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  lfs      @date  2017/12/12
************************************************************/
DPP_STATUS dpp_pktrx_port_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 port_no, ZXIC_UINT32 flag);


/***********************************************************/
/** pktrxģʼӿ
* @param   dev_id    оƬid
*
* @return  ZXIC_UINT32ͣDPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  zzh      @date  2015/02/06
************************************************************/
DPP_STATUS dpp_pktrx_init(ZXIC_UINT32 dev_id);


/***********************************************************/
/** ģⱨʹܣֻһ
* @param   dev_id        оƬID
* @param   analogport_type  ģⱨʹܵĶ˿ 0:sgmii0 1:sgmii1 2:oam tx 3:oam tst
* @param   flag             ˿ʹܱ 1:ʹܣ0:ʹ
*
* @return
* @remark  
* @see
* @author  czd      @date  2016/02/24
************************************************************/
DPP_STATUS dpp_pktrx_port_tdm_flag_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 port_no, ZXIC_UINT32 flag);

/***********************************************************/
/**  
* @param   dev_id   
* @param   index   
* @param   p_phyport_table_0_info   
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  lfs      @date  2017/12/12
************************************************************/
DPP_STATUS dpp_pktrx_phy_table_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_PHYPORT_TABLE_0_T *p_phyport_table_0_info);

/***********************************************************/
/**  
* @param   dev_id   
* @param   index   
* @param   p_phyport_info   
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  lfs      @date  2017/12/12
************************************************************/
DPP_STATUS dpp_pktrx_flowpc_table_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index,  DPP_PKTRX_PHYPORT_TABLE_1_T *p_phyport_info);

/***********************************************************/
/** Ϊ˿Աûָ˿дָ
* @param   dev_id                оƬID
* @param   index                    ˿ں
* @param   p_phyport_user_info      Ҫд
*
* @return
* @remark  
* @see
* @author  zzh      @date  2015/04/20
************************************************************/
DPP_STATUS dpp_pktrx_udf_table_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_PHYPORT_UDF_TABLE_T *p_phyport_user_info);

/***********************************************************/
/** ΪtcamָĿдָ
* @param   dev_id          оƬID
* @param   index              
* @param   p_icu_tcam_info    Ҫд
*
* @return
* @remark  1.ӦĿvldΪЧ 2.дx,y 3.д 4.ӦvldΪЧ
* @see
* @author  zzh      @date  2015/04/20
************************************************************/
DPP_STATUS dpp_pktrx_tcam_table_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_TCAM_DT_TABLE_T *p_tcam_info);


/***********************************************************/
/**ȫüĴ
* @param   dev_id
* @param   p_mcode_glb_cfg
*
* @return
* @remark  
* @see
* @author  czd      @date  2016/04/27
************************************************************/
DPP_STATUS dpp_pktrx_mcode_glb_cfg_set(ZXIC_UINT32 dev_id, DPP_PKTRX_MCODE_GLB_CFG_T *p_mcode_glb_cfg);
DPP_STATUS dpp_pktrx_mcode_glb_cfg_set_0(ZXIC_UINT32 dev_id, ZXIC_UINT32 mcode_glb_cfg_0);
DPP_STATUS dpp_pktrx_mcode_glb_cfg_set_1(ZXIC_UINT32 dev_id, ZXIC_UINT32 mcode_glb_cfg_1);
DPP_STATUS dpp_pktrx_mcode_glb_cfg_set_2(ZXIC_UINT32 dev_id, ZXIC_UINT32 mcode_glb_cfg_2);
DPP_STATUS dpp_pktrx_mcode_glb_cfg_set_3(ZXIC_UINT32 dev_id, ZXIC_UINT32 mcode_glb_cfg_3);

/***********************************************************/
/** nppu_saipʹ
* @param   dev_id   оƬID
* @param   saip_en   1-SA 0-SA
*
* @return
* @remark  
* @see
* @author  czd      @date  2016/02/29
************************************************************/
DPP_STATUS dpp_config_nppu_saip_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 saip_en);

/***********************************************************/
/** ȡ˿Ա0ָ˿ڵ
* @param   dev_id        оƬID
* @param   index            ˿ں
* @param   p_phyport_info   ȡ
*
* @return
* @remark  ҪֱĴжٽṹ
* @see
* @author  zzh      @date  2015/04/20
************************************************************/
DPP_STATUS dpp_pktrx_phy_table_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_PHYPORT_TABLE_0_T *p_phyport_info);


/***********************************************************/
/**  ȡ˿Աûָ˿ڶӦ
* @param   dev_id             оƬID
* @param   index                 ˿ں
* @param   p_phyport_user_info   
*
* @return
* @remark  
* @see
* @author  zzh      @date  2015/04/20
************************************************************/
DPP_STATUS dpp_pktrx_udf_table_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_PHYPORT_UDF_TABLE_T *p_phyport_user_info);
#endif

#endif  /* dpp_pktrx_api.h */




