/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_se_api.h
* ļʶ : seģͶͽӿں
* ժҪ :
* ˵ :
* ǰ汾 :
*      : wcl
*  : 2015/01/30
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* ޸ļ¼1:
* ޸:
*   :
*   :
* ޸:
***************************************************************/
#ifndef _DPP_SE_API_H_
#define _DPP_SE_API_H_

#if ZXIC_REAL("header file")
 #include "dpp_type_api.h"  /* xcx_0619 */
#endif

#if ZXIC_REAL("data struct define")

/** DPP+ eram block СΪ2M  ~16K */
#define SE_SMMU0_ERAM_BLOCK_NUM            (32)
#define SE_SMMU0_ERAM_ADDR_NUM_PER_BLOCK   (0x4000)
#define SE_SMMU0_ERAM_ADDR_NUM_TOTAL       (SE_SMMU0_ERAM_BLOCK_NUM * SE_SMMU0_ERAM_ADDR_NUM_PER_BLOCK)

#define DPP_DDR4_PER_BANK_BADDR_SETP       (0x800)/* 8G X16 */
#define DPP_DDR4_BANK_NUM                  (64)
#define DPP_DDR4_PER_BANK_BADDR_CONV(ddr4_phy_type) \
    (DPP_DDR4_PER_BANK_BADDR_SETP*(4U>>ddr4_phy_type))
#if DPP_DEV_VPCI_EN
#define DPP_DDR_BADDR_OFFSET_DEFAULT       (0x0)
#else
#define DPP_DDR_BADDR_OFFSET_DEFAULT       (0x5000)   /*unit:2k*256bit*/
#endif

/*ͨ*/
typedef enum dpp_dma_ecc_en_e
{
    DMA_ECC_DISABLE  = 0,
    DMA_ECC_ENABLE   = 1,
} DPP_DMA_ECC_EN_E;

/**  eRamģʽ */
typedef enum dpp_eram128_rd_clr_mode_e
{
    RD_MODE_HOLD     = 0,  /**<  @brief ݲ   */
    RD_MODE_CLEAR    = 1,  /**<  @brief ģʽeramеֵ */
} DPP_ERAM128_RD_CLR_MODE_E;

/**  eRamcpuдλģʽ*/
typedef enum dpp_eram128_opr_mode_e
{
    ERAM128_OPR_128b = 0,  /**<  @brief 128bitģʽдeRam, ֧128bitģʽ*/
    ERAM128_OPR_64b  = 1,  /**<  @brief 64bitģʽдeRam,  ֧64bit  ģʽ*/
    ERAM128_OPR_1b   = 2,  /**<  @brief 1bitģʽдeRam,   ֧1bit  ģʽ*/
    ERAM128_OPR_32b  = 3   /**<  @brief 32bitģʽeRam,    д֧32bit ģʽ*/
} DPP_ERAM128_OPR_MODE_E;

/**  eRamֱӱλģʽ,ҲeRamʱλ  */
typedef enum dpp_eram128_tbl_mode_e
{
    ERAM128_TBL_1b   = 0,  /**<  @brief 1bit   eRamƬֱӱ  */
    ERAM128_TBL_32b  = 1,  /**<  @brief 32bit  eRamƬֱӱ  */
    ERAM128_TBL_64b  = 2,  /**<  @brief 64bit  eRamƬֱӱ  */
    ERAM128_TBL_128b = 3,  /**<  @brief 128bit eRamƬֱӱ  */
    ERAM128_TBL_2b   = 4,  /**<  @brief 2bit   eRamƬֱӱ  */
    ERAM128_TBL_4b   = 5,  /**<  @brief 4bit   eRamƬֱӱ  */
    ERAM128_TBL_8b   = 6,  /**<  @brief 8bit   eRamƬֱӱ  */
    ERAM128_TBL_16b  = 7   /**<  @brief 16bit  eRamƬֱӱ  */
} DPP_ERAM128_TBL_MODE_E;

/**  eRamͨ*/
typedef enum smmu0_empty_type_e
{
    SMMU0_EMPTY_CLS0 = 0,  /**<  @brief PPU cluster0ͨ*/
    SMMU0_EMPTY_CLS1 = 1,  /**<  @brief PPU cluster1ͨ*/
    SMMU0_EMPTY_CLS2 = 2,  /**<  @brief PPU cluster2ͨ*/
    SMMU0_EMPTY_CLS3 = 3,  /**<  @brief PPU cluster3ͨ*/
    SMMU0_EMPTY_CLS4 = 4,  /**<  @brief PPU cluster4ͨ*/
    SMMU0_EMPTY_CLS5 = 5,  /**<  @brief PPU cluster5ͨ*/
    SMMU0_EMPTY_CLS6 = 6,  /**<  @brief PPU cluster6ͨ*/
    SMMU0_EMPTY_CLS7 = 7,  /**<  @brief PPU cluster7ͨ*/
    SMMU0_EMPTY_MCAST = 8, /**<  @brief 鲥Ʊͨ*/
    SMMU0_EMPTY_ODMA  = 9, /**<  @brief ODMAͨ*/
} SMMU0_EMPTY_TYPE_E;

/**  鲥*/
typedef enum smmu0_mcast_tbl_type_e
{
    MCAST_TDM = 0,         /**<  @brief TDM鲥*/
    MCAST_DATA = 1,        /**<  @brief 鲥*/

    MCAST_INVALID,         /**<  @brief Чֵ */
} SMMU0_MCAST_TBL_TYPE_E;

/** Լģʽ */
typedef enum se_dbg_cnt_read_mode_e
{
    SE_DBG_CNT_READ_UNCLR = 0,  /**<  @brief Ƕģʽ */
    SE_DBG_CNT_READ_CLR,        /**<  @brief ģʽ */
} SE_DBG_CNT_READ_MODE_E;

/** Լģʽ */
typedef enum se_dbg_cnt_overflow_mode_e
{
    SE_DBG_CNT_OVERFLOW_UNREVERSE = 0,  /**<  @brief  */
    SE_DBG_CNT_OVERFLOW_REVERSE,        /**<  @brief ת */
} SE_DBG_CNT_OVERFLOW_MODE_E;

/**  DDR*/
typedef enum se_ddr_phy_cfg_type_e
{
    DPP_SE_DDR_PHY_32G_16 = 0,  /**<  @brief DDRÿ32G,x16*/
    DPP_SE_DDR_PHY_16G_16,      /**<  @brief DDRÿ16G,x16*/
    DPP_SE_DDR_PHY_8G_16,       /**<  @brief DDRÿ8G,x16*/
    DPP_SE_DDR_PHY_4G_16,       /**<  @brief DDRÿ4G,x16*/
    DPP_SE_DDR_PHY_32G_8,       /**<  @brief DDRÿ32G,x8*/
    DPP_SE_DDR_PHY_16G_8,       /**<  @brief DDRÿ16G,x8*/
    DPP_SE_DDR_PHY_8G_8,        /**<  @brief DDRÿ8G,x8*/
    DPP_SE_DDR_PHY_4G_8,        /**<  @brief DDRÿ4G,x8*/
    DPP_SE_DDR_PHY_MAX,
} SE_DDR_PHY_CFG_TYPE_E;

/**  DDRдλģʽ*/
typedef enum smmu1_ddr_wrt_mode_e
{
    SMMU1_DDR_WRT_128b = 0,  /**<  @brief 128bitģʽдDDR*/
    SMMU1_DDR_WRT_256b = 1,  /**<  @brief 256bitģʽдDDR*/
    SMMU1_DDR_WRT_384b = 2,  /**<  @brief 384bitģʽдDDR*/
    SMMU1_DDR_WRT_512b = 3,  /**<  @brief 512bitģʽдDDR*/
} SMMU1_DDR_WRT_MODE_E;

/** DDRĹģʽ */
typedef enum smmu1_ddr_share_mode_e
{
    SMMU1_DDR_SHARE_NO_SHARE    = 0,    /**<  @brief SE ռDDR*/
    SMMU1_DDR_SHARE_1_2         = 1,    /**<  @brief SE ռ1/2 DDR*/
    SMMU1_DDR_SHARE_1_4         = 2,    /**<  @brief SE ռ1/4 DDR*/
    SMMU1_DDR_SHARE_1_8         = 3,    /**<  @brief SE ռ1/8 DDR*/
    SMMU1_DDR_SHARE_MAX
} SMMU1_DDR_SHARE_MODE_E;

/** ռsmmu1ı */
typedef enum smmu1_ddr_tbl_type_e
{
    SMMU1_DDR_TBL_TYPE_DIR_TBL         = 0,    /**<  @brief Ƭֱӱ */
    SMMU1_DDR_TBL_TYPE_HASH_TBL        = 1,    /**<  @brief HASHռñ */
    SMMU1_DDR_TBL_TYPE_LPM_TBL         = 2,    /**<  @brief LPM ռñ  */
    SMMU1_DDR_TBL_TYPE_OAM_TBL         = 3,    /**<  @brief OAM ռñ  */
    SMMU1_DDR_TBL_TYPE_FTM_TBL         = 4,    /**<  @brief FTM ռñ  */
    SMMU1_DDR_TBL_TYPE_ETM_TBL         = 5,    /**<  @brief ETM ռñ  */
    SMMU1_DDR_TBL_TYPE_MAX
} SMMU1_DDR_TBL_TYPE_E;

typedef enum cmmu_rd_mode_e
{
    CMMU_RD_MODE_29_35  = 0,
    CMMU_RD_MODE_32     = 1,
    CMMU_RD_MODE_64     = 2,
    CMMU_RD_MODE_128    = 3,
    CMMU_RD_MODE_MAX,
} CMMU_RD_OPR_MODE_E;

/**  CMMUģʽ */
typedef enum cmmu_rd_clr_mode_e
{
    CMMU_RD_CLR_MODE_UNCLR     = 0,  /**<  @brief ݲ   */
    CMMU_RD_CLR_MODE_CLR       = 1,  /**<  @brief ģʽ*/
    CMMU_RD_CLR_MODE_MAX,
} CMMU_RD_CLR_MODE_E;

/**  DDRλģʽ*/
typedef enum smmu1_ddr_srh_mode_e
{
    SMMU1_DDR_SRH_128b  = 0, /**<  @brief DDR128bitģʽ*/
    SMMU1_DDR_SRH_256b,      /**<  @brief DDR256bitģʽ*/
    SMMU1_DDR_SRH_512b,      /**<  @brief DDR512bitģʽ*/
    SMMU1_DDR_SRH_MAX
} SMMU1_DDR_SRH_MODE_E;

/**  DDRַӳ*/
typedef struct se_ddr_addr_map_info_t
{
    ZXIC_UINT32 is_inited;            /**<  @brief ڼ˽ṹǷѾʼ 0xAA-Ѿʼ ֵ-δʼ */
    ZXIC_UINT32 ddr_phy_type;         /**<  @brief DDR 0-32G,x16,1-16G,x16,2-8G,x16 */
    ZXIC_UINT32 se_use_bank_num;      /**<  @brief SEʹõbankĿ */
    ZXIC_UINT32 bank_used_sate[64];   /**<  @brief ʾ64bankʹ״̬ 0- 1-SEʹ 2-PUBʹ 3-FTMʹ 4-ETMʹ  */
} SE_DDR_ADDR_MAP_INFO_T;

/**  seppuյĲſ״̬*/
typedef struct dpp_se_ept_flag_t
{
    ZXIC_UINT32 ppu5_ept_flag; /**<  @brief seppuͨ5յĲſ״̬*/
    ZXIC_UINT32 ppu4_ept_flag; /**<  @brief seppuͨ4յĲſ״̬*/
    ZXIC_UINT32 ppu3_ept_flag; /**<  @brief seppuͨ3յĲſ״̬*/
    ZXIC_UINT32 ppu2_ept_flag; /**<  @brief seppuͨ2յĲſ״̬*/
    ZXIC_UINT32 ppu1_ept_flag; /**<  @brief seppuͨ1յĲſ״̬*/
    ZXIC_UINT32 ppu0_ept_flag; /**<  @brief seppuͨ0յĲſ״̬*/
} DPP_SE_EPT_FLAG_T;

/**  smmu0(eRam)ͨſ״̬*/
typedef struct dpp_smmu0_ept_flag_t
{
    ZXIC_UINT32 ept_flag8; /**<  @brief odamſ״̬*/
    ZXIC_UINT32 ept_flag7; /**<  @brief odam tdmſ״̬*/
    ZXIC_UINT32 ept_flag6; /**<  @brief sa鲥ſ״̬*/
    ZXIC_UINT32 ept_flag5; /**<  @brief ppuͨ5ſ״̬*/
    ZXIC_UINT32 ept_flag4; /**<  @brief ppuͨ4ſ״̬*/
    ZXIC_UINT32 ept_flag3; /**<  @brief ppuͨ3ſ״̬*/
    ZXIC_UINT32 ept_flag2; /**<  @brief ppuͨ2ſ״̬*/
    ZXIC_UINT32 ept_flag1; /**<  @brief ppuͨ1ſ״̬*/
    ZXIC_UINT32 ept_flag0; /**<  @brief ppuͨ0ſ״̬*/
} DPP_SMMU0_EPT_FLAG_T;

/**  SMMU0FIFOджԭ*/
typedef struct dpp_se_smmu0_int0_t
{
    ZXIC_UINT32 dma_ordfifo;    /**<  @brief DMAfifo дձ־*/
    ZXIC_UINT32 odma_ordfifo;   /**<  @brief ODMAfifo дձ־*/
    ZXIC_UINT32 mcast_ordfifo;  /**<  @brief MCASTfifo дձ־*/
} DPP_SE_SMMU0_INT0_T;

/* 鲥 */
typedef struct data_mcast_t_
{
    ZXIC_UINT8   valid;             /**< @brief valid ʾǷ */
    ZXIC_UINT8   rsv;               /**< @brief rsv   λֽڶʹ, */
    ZXIC_UINT16 mc_cnt;            /**< @brief mc_cnt 16bit */
} DATA_MCAST_T;

/* TDM 鲥 */
typedef struct tdm_mcast_t_
{
    ZXIC_UINT8   valid;             /**< @brief valid ʾǷ */
    ZXIC_UINT8   rsv;               /**< @brief rsv   λֽڶʹã */
    ZXIC_UINT8   bitmap[6];         /**< @brief bitmap[0]λbitmap[2]λ */
} TDM_MCAST_T;

#endif

#if ZXIC_REAL("eTcam data struct define")

#endif

#if ZXIC_REAL("interrupt data struct define")
/** SMMU0 ж״̬ */
typedef struct dpp_se_smmu0_int_t
{
    ZXIC_UINT32 smmu0_int0;
    ZXIC_UINT32 smmu0_int1;
    ZXIC_UINT32 smmu0_int2;
    ZXIC_UINT32 smmu0_int3;
    ZXIC_UINT32 smmu0_int4;
    ZXIC_UINT32 smmu0_int5;
    ZXIC_UINT32 smmu0_int6;
    ZXIC_UINT32 smmu0_int7;
    ZXIC_UINT32 smmu0_int8;
    ZXIC_UINT32 smmu0_int9;
    ZXIC_UINT32 smmu0_int10;
    ZXIC_UINT32 smmu0_int11;
    ZXIC_UINT32 smmu0_int12;
    ZXIC_UINT32 smmu0_int13;
    ZXIC_UINT32 smmu0_int14;
    ZXIC_UINT32 smmu0_int15;
    ZXIC_UINT32 smmu0_int16;
    ZXIC_UINT32 smmu0_int17;
    ZXIC_UINT32 smmu0_int18;
    ZXIC_UINT32 smmu0_int19;
    ZXIC_UINT32 smmu0_int20;
    ZXIC_UINT32 smmu0_int21;
    ZXIC_UINT32 smmu0_int22;
    ZXIC_UINT32 smmu0_int23;
    ZXIC_UINT32 smmu0_int24;
    ZXIC_UINT32 smmu0_int25;
    ZXIC_UINT32 smmu0_int26;
    ZXIC_UINT32 smmu0_int27;
    ZXIC_UINT32 smmu0_int28;
    ZXIC_UINT32 smmu0_int29;
    ZXIC_UINT32 smmu0_int30;
    ZXIC_UINT32 smmu0_int31;
    ZXIC_UINT32 smmu0_int32;
    ZXIC_UINT32 smmu0_int33;
    ZXIC_UINT32 smmu0_int34;
    ZXIC_UINT32 smmu0_int35;
    ZXIC_UINT32 smmu0_int36;
    ZXIC_UINT32 smmu0_int37;
    ZXIC_UINT32 smmu0_int38;

}DPP_SE_SMMU0_INT_T;

/** SMMU0 ģܵж״̬ */
typedef struct dpp_smmu0_brief_int_t
{
    ZXIC_UINT32 smmu0_int14_unmask_flag;
    ZXIC_UINT32 smmu0_int13_unmask_flag;
    ZXIC_UINT32 smmu0_int12_unmask_flag;
    ZXIC_UINT32 smmu0_int11_unmask_flag;
    ZXIC_UINT32 smmu0_int10_unmask_flag;
    ZXIC_UINT32 smmu0_int9_unmask_flag;
    ZXIC_UINT32 smmu0_int8_unmask_flag;
    ZXIC_UINT32 smmu0_int7_unmask_flag;
    ZXIC_UINT32 smmu0_int6_unmask_flag;
    ZXIC_UINT32 smmu0_int5_unmask_flag;
    ZXIC_UINT32 smmu0_int4_unmask_flag;
    ZXIC_UINT32 smmu0_int3_unmask_flag;
    ZXIC_UINT32 smmu0_int2_unmask_flag;
    ZXIC_UINT32 smmu0_int1_unmask_flag;
    ZXIC_UINT32 smmu0_int0_unmask_flag;
} DPP_SMMU0_BRIEF_INT_T;

/** SE ģܵж״̬ */
typedef struct dpp_se_int_status_t
{
    ZXIC_UINT32 as_int_unmask_flag;      /**< @brief ģ飨ASж״̬ */
    ZXIC_UINT32 kschd_int_unmask_flag;   /**< @brief ֵģ飨KSCHDж״̬ */
    ZXIC_UINT32 rschd_int_unmask_flag;   /**< @brief صģ飨RSCHDж״̬ */
    ZXIC_UINT32 smmu1_int_unmask_flag;  /**< @brief SMMU1 жж״̬ */
    ZXIC_UINT32 cmmu_int_unmask_flag;    /**< @brief CMMU  ж״̬ */
    ZXIC_UINT32 parser_int_unmask_flag;  /**< @brief ģ飨parseж״̬ */
} DPP_SE_INT_STATUS_T;

/** seģж״̬ */
typedef struct dpp_se_parser_int_t
{
    ZXIC_UINT32 parser_int_en;
    ZXIC_UINT32 parser_int_mask;
    ZXIC_UINT32 parser_int_status;
} DPP_SE_PARSER_INT_T;

/** keyģ(KSCHD)ж״̬ */
typedef struct dpp_se_kschd_int_t
{
    ZXIC_UINT32 kschd_int_0;
    ZXIC_UINT32 kschd_int_1;
    ZXIC_UINT32 kschd_int_2;
    ZXIC_UINT32 kschd_int_3;
    ZXIC_UINT32 kschd_int_4;
} DPP_SE_KSCHD_INT_T;

/** rspģ(RSCHD)ж״̬ */
typedef struct dpp_se_rschd_int_t
{
    ZXIC_UINT32 port0_int;
    ZXIC_UINT32 port1_int;
} DPP_SE_RSCHD_INT_T;

/**  (AS)ģжԭ*/
typedef struct dpp_se_as_int_t
{
    ZXIC_UINT32 as_int_0;
    ZXIC_UINT32 as_int_1;
    ZXIC_UINT32 as_int_2;
} DPP_SE_AS_INT_T;

/** cmmu ģж*/
typedef struct dpp_se_cmmu_int_t
{
    ZXIC_UINT32 cmmu_int12;
    ZXIC_UINT32 cmmu_int11;
    ZXIC_UINT32 cmmu_int10;
    ZXIC_UINT32 cmmu_int9;
    ZXIC_UINT32 cmmu_int8;
    ZXIC_UINT32 cmmu_int7;
    ZXIC_UINT32 cmmu_int6;
    ZXIC_UINT32 cmmu_int5;
    ZXIC_UINT32 cmmu_int4;
    ZXIC_UINT32 cmmu_int3;
    ZXIC_UINT32 cmmu_int2;
    ZXIC_UINT32 cmmu_int1;
    ZXIC_UINT32 cmmu_int0;
} DPP_SE_CMMU_INT_T;

/** ALG ģж*/
typedef struct dpp_se_alg_int_t
{
    ZXIC_UINT32 wr_rsp_fifo_ovfl_int;              /**< @brief дػptr fifo жϱ */
    ZXIC_UINT32 init_rd_cft_int;                /**< @brief ʼгֶͻж */
    ZXIC_UINT32 schd_lpm_fifo_parity_err_int;     /**< @brief lpmFIFOżУϱ */
    ZXIC_UINT32 schd_hash3_fifo_parity_err_int;    /**< @brief hash3FIFOżУϱ */
    ZXIC_UINT32 schd_hash2_fifo_parity_err_int;    /**< @brief hash2FIFOżУϱ */
    ZXIC_UINT32 schd_hash1_fifo_parity_err_int;    /**< @brief hash1FIFOżУϱ */
    ZXIC_UINT32 schd_hash0_fifo_parity_err_int;    /**< @brief hash0FIFOżУϱ */
    ZXIC_UINT32 schd_learn_fifo_parity_err_int;    /**< @brief ѧϰFIFOżУϱ */
    ZXIC_UINT32 schd_lpm_fifo_ovfl_int;            /**< @brief lpmֵFIFOжϱ */
    ZXIC_UINT32 schd_hash3_fifo_ovfl_int;          /**< @brief hash3ֵFIFOжϱ */
    ZXIC_UINT32 schd_hash2_fifo_unfl_int;          /**< @brief hash2ֵFIFOжϱ */
    ZXIC_UINT32 schd_hash1_fifo_ovfl_int;          /**< @brief hash1ֵFIFOжϱ */
    ZXIC_UINT32 schd_hash0_fifo_ovfl_int;          /**< @brief hash0ֵFIFOжϱ */
    ZXIC_UINT32 schd_learn_fifo_ovfl_int;          /**< @brief ѧϰFIFOжϱ */

    ZXIC_UINT32 zblk31_parity_int;           /**< @brief zblock31  parity ж */
    ZXIC_UINT32 zblk30_parity_int;           /**< @brief zblock30  parity ж */
    ZXIC_UINT32 zblk29_parity_int;           /**< @brief zblock29  parity ж */
    ZXIC_UINT32 zblk28_parity_int;           /**< @brief zblock28  parity ж */
    ZXIC_UINT32 zblk27_parity_int;           /**< @brief zblock27  parity ж */
    ZXIC_UINT32 zblk26_parity_int;           /**< @brief zblock26  parity ж */
    ZXIC_UINT32 zblk25_parity_int;           /**< @brief zblock25  parity ж */
    ZXIC_UINT32 zblk24_parity_int;           /**< @brief zblock24  parity ж */
    ZXIC_UINT32 zblk23_parity_int;           /**< @brief zblock23  parity ж */
    ZXIC_UINT32 zblk22_parity_int;           /**< @brief zblock22  parity ж */
    ZXIC_UINT32 zblk21_parity_int;           /**< @brief zblock21  parity ж */
    ZXIC_UINT32 zblk20_parity_int;           /**< @brief zblock20  parity ж */
    ZXIC_UINT32 zblk19_parity_int;           /**< @brief zblock19  parity ж */
    ZXIC_UINT32 zblk18_parity_int;           /**< @brief zblock18  parity ж */
    ZXIC_UINT32 zblk17_parity_int;           /**< @brief zblock17  parity ж */
    ZXIC_UINT32 zblk16_parity_int;           /**< @brief zblock16  parity ж */
    ZXIC_UINT32 zblk15_parity_int;           /**< @brief zblock15  parity ж */
    ZXIC_UINT32 zblk14_parity_int;           /**< @brief zblock14  parity ж */
    ZXIC_UINT32 zblk13_parity_int;           /**< @brief zblock13  parity ж */
    ZXIC_UINT32 zblk12_parity_int;           /**< @brief zblock12  parity ж */
    ZXIC_UINT32 zblk11_parity_int;           /**< @brief zblock11  parity ж */
    ZXIC_UINT32 zblk10_parity_int;           /**< @brief zblock10  parity ж */
    ZXIC_UINT32 zblk9_parity_int;            /**< @brief zblock9   parity ж */
    ZXIC_UINT32 zblk8_parity_int;            /**< @brief zblock8   parity ж */
    ZXIC_UINT32 zblk7_parity_int;            /**< @brief zblock7   parity ж */
    ZXIC_UINT32 zblk6_parity_int;            /**< @brief zblock6   parity ж */
    ZXIC_UINT32 zblk5_parity_int;            /**< @brief zblock5   parity ж */
    ZXIC_UINT32 zblk4_parity_int;            /**< @brief zblock4   parity ж */
    ZXIC_UINT32 zblk3_parity_int;            /**< @brief zblock3   parity ж */
    ZXIC_UINT32 zblk2_parity_int;            /**< @brief zblock2   parity ж */
    ZXIC_UINT32 zblk1_parity_int;            /**< @brief zblock1   parity ж */
    ZXIC_UINT32 zblk0_parity_int;            /**< @brief zblock0   parity ж */

    ZXIC_UINT32 zcam_hash_p0_err_int;                 /**< @brief hash0 ZCAMҳж */
    ZXIC_UINT32 hash0_agree_int_fifo_ovf_int;         /**< @brief hash0 fifo Ƭͨж */
    ZXIC_UINT32 hash0_agree_ext_fifo_ovf_int;         /**< @brief hash0 fifo Ƭͨparityж */
    ZXIC_UINT32 hash0_agree_ext_fifo_parity_err_int;  /**< @brief hash0 fifo Ƭͨж*/
    ZXIC_UINT32 hash0_agree_int_fifo_parity_err_int;  /**< @brief hash0 fifo Ƭͨparityж */
    ZXIC_UINT32 hash0_key_fifo_ovfl_int;              /**< @brief hash0 ƬֵFIFO ж */
    ZXIC_UINT32 hash0_sreq_fifo_ovfl_int;             /**< @brief hash0 ƬַFIFOж */
    ZXIC_UINT32 hash0_key_fifo_parity_err_int;        /**< @brief hash0 ƬֵFIFO parity errж */

    ZXIC_UINT32 zcam_hash_p1_err_int;                 /**< @brief hash1 ZCAMҳж */
    ZXIC_UINT32 hash1_agree_int_fifo_ovf_int;         /**< @brief hash1 fifo Ƭͨж */
    ZXIC_UINT32 hash1_agree_ext_fifo_ovf_int;         /**< @brief hash1 fifo Ƭͨparityж */
    ZXIC_UINT32 hash1_agree_ext_fifo_parity_err_int;  /**< @brief hash1 fifo Ƭͨж*/
    ZXIC_UINT32 hash1_agree_int_fifo_parity_err_int;  /**< @brief hash1 fifo Ƭͨparityж */
    ZXIC_UINT32 hash1_key_fifo_ovfl_int;              /**< @brief hash1 ƬֵFIFO ж */
    ZXIC_UINT32 hash1_sreq_fifo_ovfl_int;             /**< @brief hash1 ƬַFIFOж */
    ZXIC_UINT32 hash1_key_fifo_parity_err_int;        /**< @brief hash1 ƬֵFIFO parity errж */

    ZXIC_UINT32 zcam_hash_p2_err_int;                 /**< @brief hash2 ZCAMҳж */
    ZXIC_UINT32 hash2_agree_int_fifo_ovf_int;         /**< @brief hash2 fifo Ƭͨж */
    ZXIC_UINT32 hash2_agree_ext_fifo_ovf_int;         /**< @brief hash2 fifo Ƭͨparityж */
    ZXIC_UINT32 hash2_agree_ext_fifo_parity_err_int;  /**< @brief hash2 fifo Ƭͨж*/
    ZXIC_UINT32 hash2_agree_int_fifo_parity_err_int;  /**< @brief hash2 fifo Ƭͨparityж */
    ZXIC_UINT32 hash2_key_fifo_ovfl_int;              /**< @brief hash2 ƬֵFIFO ж */
    ZXIC_UINT32 hash2_sreq_fifo_ovfl_int;             /**< @brief hash2 ƬַFIFOж */
    ZXIC_UINT32 hash2_key_fifo_parity_err_int;        /**< @brief hash2 ƬֵFIFO parity errж */

    ZXIC_UINT32 zcam_hash_p3_err_int;                 /**< @brief hash3 ZCAMҳж */
    ZXIC_UINT32 hash3_agree_int_fifo_ovf_int;         /**< @brief hash3 fifo Ƭͨж */
    ZXIC_UINT32 hash3_agree_ext_fifo_ovf_int;         /**< @brief hash3 fifo Ƭͨparityж */
    ZXIC_UINT32 hash3_agree_ext_fifo_parity_err_int;  /**< @brief hash3 fifo Ƭͨж*/
    ZXIC_UINT32 hash3_agree_int_fifo_parity_err_int;  /**< @brief hash3 fifo Ƭͨparityж */
    ZXIC_UINT32 hash3_key_fifo_ovfl_int;              /**< @brief hash3 ƬֵFIFO ж */
    ZXIC_UINT32 hash3_sreq_fifo_ovfl_int;             /**< @brief hash3 ƬַFIFOж */
    ZXIC_UINT32 hash3_key_fifo_parity_err_int;        /**< @brief hash3 ƬֵFIFO parity errж */

    ZXIC_UINT32 zcam_lpm_err_int;                     /**< @brief lpm ZCAMҳж */
    ZXIC_UINT32 lpm_as_int_rsp_fifo_ovfl_int;         /**< @brief lpm as ƬڲҽFIFOж */
    ZXIC_UINT32 lpm_as_req_fifo_ovfl_int;             /**< @brief lpm as ddr ַ FIFOж */
    ZXIC_UINT32 lpm_ext_ddr_rsp_fifo_parity_int;      /**< @brief lpm ext ddr rsp FIFO parityж */
    ZXIC_UINT32 lpm_ext_v6_key_parity_int;            /**< @brief lpm ext v6 key FIFO parityж */
    ZXIC_UINT32 lpm_ext_v4_key_parity_int;            /**< @brief lpm ext v4 key FIFO parityж */
    ZXIC_UINT32 lpm_ext_addr_fifo_ovfl_int;           /**< @brief lpm ext ddr3 ַж */
    ZXIC_UINT32 lpm_ext_v4_fifo_ovfl_int;             /**< @brief lpm ext v4 keyж */
    ZXIC_UINT32 lpm_ext_v6_fifo_ovfl_int;             /**< @brief lpm ext v6 keyж */
    ZXIC_UINT32 lpm_ext_ddr_rsp_ovf_int;              /**< @brief lpm ext ddrػfifoж */
} DPP_SE_ALG_INT_T;

/** ALG ģж*/
typedef struct dpp_se_alg_brief_int_t
{
    ZXIC_UINT32 schd_int_unmask_flag;        /**<@brief algģ״̬ */
    ZXIC_UINT32 zblk_parity_int_unmask_flag; /**<@brief algģzblockżУж */
    ZXIC_UINT32 hash0_int_unmask_flag;       /**<@brief algģhash0ж״̬ */
    ZXIC_UINT32 hash1_int_unmask_flag;       /**<@brief algģhash1ж״̬ */
    ZXIC_UINT32 hash2_int_unmask_flag;       /**<@brief algģhash2ж״̬ */
    ZXIC_UINT32 hash3_int_unmask_flag;       /**<@brief algģhash3ж״̬ */
    ZXIC_UINT32 lpm_int_unmask_flag;         /**<@brief algģlpmж״̬ */
} DPP_SE_ALG_BRIEF_INT_T;

/** SMMU1 ж */
typedef struct dpp_se_smmu1_int_t
{
    ZXIC_UINT32 smmu1_int0;
    ZXIC_UINT32 smmu1_int1;
    ZXIC_UINT32 smmu1_int2;
    ZXIC_UINT32 smmu1_int3;
    ZXIC_UINT32 smmu1_int4;
    ZXIC_UINT32 smmu1_int5;
    ZXIC_UINT32 smmu1_int6;
    ZXIC_UINT32 smmu1_int7;
    ZXIC_UINT32 smmu1_int8;
    ZXIC_UINT32 smmu1_int9;
    ZXIC_UINT32 smmu1_int10;
    ZXIC_UINT32 smmu1_int11;
    ZXIC_UINT32 smmu1_int12;
    ZXIC_UINT32 smmu1_int13;
    ZXIC_UINT32 smmu1_int14;
    ZXIC_UINT32 smmu1_int15;
    ZXIC_UINT32 smmu1_int16;
    ZXIC_UINT32 smmu1_int17;
} DPP_SE_SMMU1_INT_T;

typedef struct dpp_etcam_intr_t
{
    ZXIC_UINT32 etcam_int_33;
    ZXIC_UINT32 etcam_int_32;
    ZXIC_UINT32 etcam_int_31;
    ZXIC_UINT32 etcam_int_30;
    ZXIC_UINT32 etcam_int_29;
    ZXIC_UINT32 etcam_int_28;
    ZXIC_UINT32 etcam_int_27;
    ZXIC_UINT32 etcam_int_26;
    ZXIC_UINT32 etcam_int_25;
    ZXIC_UINT32 etcam_int_24;
    ZXIC_UINT32 etcam_int_23;
    ZXIC_UINT32 etcam_int_22;
    ZXIC_UINT32 etcam_int_21;
    ZXIC_UINT32 etcam_int_20;
    ZXIC_UINT32 etcam_int_19;
    ZXIC_UINT32 etcam_int_18;
    ZXIC_UINT32 etcam_int_17;
    ZXIC_UINT32 etcam_int_16;
    ZXIC_UINT32 etcam_int_15;
    ZXIC_UINT32 etcam_int_14;
    ZXIC_UINT32 etcam_int_13;
    ZXIC_UINT32 etcam_int_12;
    ZXIC_UINT32 etcam_int_11;
    ZXIC_UINT32 etcam_int_10;
    ZXIC_UINT32 etcam_int_9;
    ZXIC_UINT32 etcam_int_8;
    ZXIC_UINT32 etcam_int_7;
    ZXIC_UINT32 etcam_int_6;
    ZXIC_UINT32 etcam_int_5;
    ZXIC_UINT32 etcam_int_4;
    ZXIC_UINT32 etcam_int_3;
    ZXIC_UINT32 etcam_int_2;
    ZXIC_UINT32 etcam_int_1;
    ZXIC_UINT32 etcam_int_0;
} DPP_ETCAM_INTR_T;

typedef struct dpp_se_stat_int_t
{
    ZXIC_UINT32 stat_int0;
    ZXIC_UINT32 stat_int1;
    ZXIC_UINT32 stat_int2;
    ZXIC_UINT32 stat_int3;
    ZXIC_UINT32 stat_int4;
    ZXIC_UINT32 stat_int5;
} DPP_SE_STAT_INT_T;

#endif

#if ZXIC_REAL("macro function define")

#endif


#if ZXIC_REAL("function declaration")
/***********************************************************/
/** seģʼ
* @param   dev_id   豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/03/20
************************************************************/
DPP_STATUS dpp_se_module_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/** дeRam
* @param   dev_id    豸
* @param   base_addr ַ128bitΪλ
* @param   index     Ŀ
* @param   wrt_mode  λģʽ, ȡֵοERAM128_OPR_MODE_EĶ
* @param   p_data    
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2014/04/16
************************************************************/
DPP_STATUS dpp_se_smmu0_ind_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index, ZXIC_UINT32 wrt_mode, ZXIC_UINT32 *p_data);

/***********************************************************/
/** eRam
* @param   dev_id       豸
* @param   base_addr    ַ128bitΪλ
* @param   index        Ŀ,֧12864321bitֵ
* @param   rd_mode      eRamģʽ, ȡֵERAM128_OPR_MODE_E壬ģʽ²֧1bitģʽ
* @param   rd_clr_mode  eRamģʽ, ȡֵERAM128_RD_CLR_MODE_E
* @param   p_data       ݻָ
*
* @return
* @remark  
* @see
* @author  wcl      @date  2015/01/30
************************************************************/
DPP_STATUS dpp_se_smmu0_ind_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index, ZXIC_UINT32 rd_mode, ZXIC_UINT32 rd_clr_mode, ZXIC_UINT32 *p_data);

/***********************************************************/
/** statģʽ(Ƭͳƴ洢)
* @param   dev_id      豸
* @param   mode        ģʽ: 0-1-
*
* @return
* @remark  μdpp_se_cmmu_stat_overflow_mode_setñһ
* @see
* @author  wcl      @date  2014/06/23
************************************************************/
DPP_STATUS dpp_se_smmu0_stat_overflow_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode);

/***********************************************************/
/** statģʽ(DDR3м)
* @param   dev_id           豸
* @param   overflow_mode    statģʽ0-ת(ж)
*                                             1-󱣳ֵĬֵ1
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  μdpp_se_smmu0_stat_overflow_mode_setҵҪ߱һ¼
* @see
* @author  ls      @date  2015/10/22
************************************************************/
DPP_STATUS dpp_se_cmmu_stat_overflow_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 overflow_mode);

/***********************************************************/
/** lpm㷨DDR
* @param   dev_id       豸
* @param   lpm_type     lpmдddrͣοALG_LPM_TYPE_E֧ALG_LPM_V4ALG_LPM_V6
* @param   ddr_wr_mode  дDDRģʽȡֵοSMMU1_DDR_WRT_MODE_EĶ
* @param   index        
* @param   p_data       
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2014/07/30
************************************************************/
DPP_STATUS dpp_se_lpm_ddr_get(ZXIC_UINT32 dev_id,
                              ZXIC_UINT32 lpm_type,
                              ZXIC_UINT32 ddr_wr_mode,
                              ZXIC_UINT32 index,
                              ZXIC_UINT8   *p_data);

/***********************************************************/
/** дddr3
* @param   dev_id               豸
* @param   tbl_type             ʹͣμSMMU1_DDR_TBL_TYPE_E
* @param   tbl_id               ţʹõķΧtbl_type:
*                                   ʹΪֱӱʱΧΪ[0,255]sdtţ
*                                   ʹΪHASHʱΧΪ[0,31] hash32ű;
*                                   ʹΪLPMʱ ΧΪ[0,3],   0-lpm_v4,1-lpm_v6,2-lpm_v4_as,3-lpm_v6_as
*                                   ʹΪʱֵù
* @param   dir_tbl_base_addr    ֱӱʹãֱӱַģʽʱbankڵַ㣬4k*128bitΪλ
* @param   dir_tbl_wr_mode      ֱӱʹãֱӱдģʽμSMMU1_DDR_WRT_MODE_E
* @param   dir_tbl_ecc_en       ֱӱʹãֱӱeccʹ
* @param   index                
* @param   p_data               д
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/04/20
************************************************************/
DPP_STATUS dpp_se_smmu1_data_ind_write(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 tbl_type,
                                       ZXIC_UINT32 tbl_id,
                                       ZXIC_UINT32 dir_tbl_base_addr,
                                       ZXIC_UINT32 dir_tbl_wr_mode,
                                       ZXIC_UINT32 dir_tbl_ecc_en,
                                       ZXIC_UINT32 index,
                                       ZXIC_UINT32 *p_data);

/***********************************************************/
/** DPP smmu1ݶȡ(֧512bit)
* @param   dev_id       豸
* @param   base_addr    ַ1K*512bit
* @param   index        ֵ(512bit)
* @param   p_data       Σ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/04/25
************************************************************/
DPP_STATUS dpp_se_smmu1_data_ind_read(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 base_addr,
                                      ZXIC_UINT32 index,
                                      ZXIC_UINT32 *p_data);
#endif

#if ZXIC_REAL("Hash & LPM data struct and function")
/** lpm&hash㷨ģӲдָ */
typedef DPP_STATUS (*WRITE32_FUN)(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 write_data);
typedef DPP_STATUS (*READ32_FUN) (ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *read_data);

/**  ǰ׺ƥ·ɹдӲָ*/
typedef DPP_STATUS (*LPM_AS_RSLT_WRT_FUNCTION)(ZXIC_UINT32 dev_id, ZXIC_UINT32 as_type, ZXIC_UINT32 tbl_id, ZXIC_UINT32 index, ZXIC_UINT8 *p_data);

#define     SE_ZGRP_NUM         (4)
#define     SE_ZBLK_NUM         (32)
#define     SE_ZCELL_NUM        (4)
#define     SE_ZCELL_TOTAL_NUM  (SE_ZBLK_NUM * SE_ZCELL_NUM)
#define     SE_ZREG_NUM         (4)
#define     SE_RAM_DEPTH        (512)
#define     MAX_FUN_NUM         (8)
#define     SE_ALG_BANK_NUM     (29)

#define LPM_THREAD_HW_WRITE_EN             (0)      /* ??????????????? */
#if LPM_THREAD_HW_WRITE_EN
#define ROUTE_DEV_CHANNEL_MAX              (4)      /* ?????? NPE_DEV_CHANNEL_MAX ??????? */
#define MAX_ITEM_INFO_BAK_NUM              (0x100)  
#endif
/*
*    zcell/zreg 洢ԪϢ,512bitΪλ
*    zcell512洢Ԫzreg4洢Ԫ
*    ÿԪԴ洢1512bitĿ2256bitĿ4128bitĿ
*    ṹ岻֪ڲ洢Ŀλhashмֵеkey_type
*    ԻȡλϢ
*/
typedef struct se_item_cfg
{
    D_HEAD  item_list;      /** 洢Ԫ˫ͷڵ㣬ԴŷڱԪڵľĿ*/
    ZXIC_UINT32  item_index;     /** 洢Ԫֵ */
    ZXIC_UINT32  hw_addr;        /** 洢Ԫĵַ */
    ZXIC_UINT32  bulk_id;
    ZXIC_UINT32  item_type;      /** 洢ԪĴ洢ͣƬƬڣμSE_ITEM_TYPE */
    ZXIC_UINT8    wrt_mask;       /** 洢Ԫд룬4bitÿbitʾд128bitλ */
    ZXIC_UINT8    valid;          /** 洢ԪǷռã0-δռã1-ռ */
    ZXIC_UINT8    pad[2];
} SE_ITEM_CFG;

/**  zcellԱ־*/
#define DPP_ZCELL_FLAG_IS_MONO       (1) /**<  @brief ZCELLǷ񱻶ռ: 0-δռ1-Ѿռ*/

/**  zcellԱ־*/
#define DPP_ZREG_FLAG_IS_MONO        (1) /**<  @brief ZREGǷ񱻶ռ:  0-δռ1-Ѿռ*/

/* zcell Ϣ*/
typedef struct se_zcell_cfg
{
    ZXIC_UINT8            flag;           /* zcellԱ־صĺDPP_ZCELL_FLAG_MODEȵĶ */
    ZXIC_UINT32          bulk_id;        /* zcellռID  */
    ZXIC_UINT32          zcell_idx;      /* zcell ֵ, 6bitΪzblock     */
    ZXIC_UINT16          mask_len;       /* 볤 */
    ZXIC_UINT8            is_used;        /* zcellǷռ*/
    ZXIC_UINT8            is_share;       /* Ƿblockеzcell*/
    ZXIC_UINT32          item_used;
    SE_ITEM_CFG     item_info[SE_RAM_DEPTH];    /* zcellĻ洢Ԫ*/

    D_NODE          zcell_dn;       /* ˫ڵ㣬ʼdataָָSE_ZCELL_CFGʵȻ˫*/
    ZXIC_AVL_NODE    zcell_avl;      /* hashδʹã ƽڵ*/
} SE_ZCELL_CFG;
/* zreg Ϣ*/
typedef struct se_zreg_cfg
{
    ZXIC_UINT8            flag;           /* zԱ־صĺDPP_ZCELL_FLAG_MODEȵĶ */
    ZXIC_UINT8            pad[3];
    ZXIC_UINT32          bulk_id;        /* zcellռID  */
    SE_ITEM_CFG     item_info;     /* zreg 洢ıĿ*/
} SE_ZREG_CFG;
/* zblock Ϣ*/
typedef struct se_zblk_cfg
{
    ZXIC_UINT32          zblk_idx;   /* ͳһַΧ0~31 */
    ZXIC_UINT16          is_used;    /* zblock Ƿռ */
    ZXIC_UINT16          zcell_bm;   /* hashδʹ */
    ZXIC_UINT16          hash_arg;   /* hash crc㷨 */
    ZXIC_UINT16          pad;

    SE_ZCELL_CFG    zcell_info[SE_ZCELL_NUM];   /* block4zcell */
    SE_ZREG_CFG     zreg_info[SE_ZREG_NUM];     /* block4zreg*/

    D_NODE          zblk_dn;                    /* ָʵ˫ڵ */

} SE_ZBLK_CFG;
/* algã4·hashv4  v6 lpm*/
typedef struct func_id_info
{
    ZXIC_VOID *fun_ptr;
    ZXIC_UINT8  fun_type;             /* ҵ μ SE_FUN_TYPE */
    ZXIC_UINT8  fun_id;
    ZXIC_UINT8  is_used;
    ZXIC_UINT8  pad;
} FUNC_ID_INFO;

typedef struct ddr_mem
{
    ZXIC_UINT32     total_num;
    ZXIC_UINT32     base_addr;
    ZXIC_UINT32     base_addr_offset;
    ZXIC_UINT32     ecc_en;
    ZXIC_UINT32     bank_num;
    ZXIC_UINT32     bank_info[SE_ALG_BANK_NUM];
    ZXIC_UINT32     share_type;  /* DDR bankģʽ */
    ZXIC_UINT32     item_used;
    ZXIC_LISTSTACK_MANGER *p_ddr_mng;
} DDR_MEM;

typedef struct share_ram
{
    ZXIC_UINT32    zblk_array[SE_ZBLK_NUM];
    D_HEAD    zblk_list;
    D_HEAD    zcell_free_list;
    ZXIC_UINT32    def_route_num;

    ZXIC_RB_CFG       def_rb;
    struct def_route_info  *p_dr_info;

    DDR_MEM   ddr4_info;
    DDR_MEM   ddr6_info;
} SHARE_RAM;

/**  㷨ģݽṹû贴ʵȻָ봫ʼdpp_se_init()dpp_se_client_init()ɣҪֵԱ*/
typedef struct dpp_se_cfg
{
    SE_ZBLK_CFG        zblk_info[SE_ZBLK_NUM];

    FUNC_ID_INFO       fun_info[MAX_FUN_NUM];

    SHARE_RAM          route_shareram;
    ZXIC_UINT32             reg_base;

    WRITE32_FUN        p_write32_fun;
    READ32_FUN         p_read32_fun;

    ZXIC_UINT32             lpm_flags;

    ZXIC_VOID               *p_client;

    ZXIC_UINT32             dev_id;

    LPM_AS_RSLT_WRT_FUNCTION p_as_rslt_wrt_fun;           /* dpp_se_lpm_as_rslt_write */

#if LPM_THREAD_HW_WRITE_EN
    // ZXIC_UINT32  mutex_location;                     /* dpp_route_cfg ?? cache mutex???????????route mode */
    ZXIC_MUTEX_T cache_index_mutex[MAX_ITEM_INFO_BAK_NUM];         /* cacheÿڵ */
    ZXIC_UINT32  thread_hw_write_is_create;          /* ??????????????? ???????? add by lining for thread_hw_write */
    ZXIC_LISTSTACK_MANGER *p_thread_liststack_mng;
#endif
} DPP_SE_CFG;

/**  hash洢λ*/
typedef enum dpp_hash_ddr_width_mode
{
    DDR_WIDTH_INVALID = 0,
    DDR_WIDTH_256b,          /**<  @brief 256bitλģʽ*/
    DDR_WIDTH_512b,          /**<  @brief 512bitλģʽ*/
} DPP_HASH_DDR_WIDTH_MODE;

/**  hashĿ*/
typedef enum dpp_hash_key_type
{
    HASH_KEY_INVALID = 0, /**<  @brief Ч*/
    HASH_KEY_128b,        /**<  @brief 128bitλ*/
    HASH_KEY_256b,        /**<  @brief 256bitλ*/
    HASH_KEY_512b,        /**<  @brief 512bitλ*/
} DPP_HASH_KEY_TYPE;

/**  hash ddr resource cfg info*/
typedef struct dpp_hash_ddr_resc_cfg_t
{
    ZXIC_UINT32 ddr_width_mode; /**<  @brief hashDDRռ洢λģʽȡֵοDPP_HASH_DDR_WIDTH_MODEĶ*/
    ZXIC_UINT32 ddr_crc_sel;                     /**<  @brief ѡһDDR CRCʽȡֵΧ0~3,0~3ֱӦһCRCʽ*/
    ZXIC_UINT32 ddr_item_num;                    /**<  @brief hashDDRռ䵥ԪĿ256bitΪһԪ*/
    ZXIC_UINT32 ddr_baddr;                       /**<  @brief hashDDRռӲַ,2k*256bitΪλ*/
    ZXIC_UINT32 ddr_ecc_en;                      /**<  @brief DDR ECCʹ: 0-ʹܣ1-ʹ*/
} DPP_HASH_DDR_RESC_CFG_T;

/** hash search mode */
typedef enum dpp_hash_srh_mode
{
    HASH_SRH_MODE_SOFT = 1,  /**<  @brief  */
    HASH_SRH_MODE_HDW  = 2,  /**<  @brief Ӳ */
} DPP_HASH_SRH_MODE;

/** hash tbl_flag */
#define HASH_TBL_FLAG_AGE             (1<<0)  /**<  @brief ϻλʹ: 0-ʹܣ1-ʹ*/
#define HASH_TBL_FLAG_LEARN           (1<<1)  /**<  @brief Ӳѧϰʹ: 0-ʹܣ1-ʹ*/
#define HASH_TBL_FLAG_MC_WRT          (1<<2)  /**<  @brief ΢дʹ: 0-ʹܣ1-ʹ */

/**  hashĿ*/
typedef struct dpp_hash_entry
{
    ZXIC_UINT8 *p_key; /**<  @brief ֵʽ˵*/
    ZXIC_UINT8 *p_rst; /**<  @brief */
} DPP_HASH_ENTRY;


/**  ǰ׺·ҵʼ־*/
#define LPM_FLAG_RT_HANDLE_START       (0)  /**<  @brief Ƿʹܼ: 0-ʹܣ1-ʹ*/
#define LPM_FLAG_RT_HANDLE_WIDTH       (1)
#define LPM4_FLAG_DDR_EN_START         (1)  /**<  @brief Ƿʹipv4Ƭģʽ: 0-ʹܣ1-ʹ */
#define LPM4_FLAG_DDR_EN_WIDTH         (1)
#define LPM6_FLAG_DDR_EN_START         (2)  /**<  @brief Ƿʹipv6Ƭģʽ: 0-ʹܣ1-ʹ */
#define LPM6_FLAG_DDR_EN_WIDTH         (1)
#define LPM4_FLAG_DDR_SEL_START        (3)  /**<  @brief ǷΪipv4ģʽ: 0-٣1- */
#define LPM4_FLAG_DDR_SEL_WIDTH        (1)
#define LPM6_FLAG_DDR_SEL_START        (4)  /**<  @brief ǷΪipv6ģʽ: 0-٣1- */
#define LPM6_FLAG_DDR_SEL_WIDTH        (1)
#define LPM_FLAG_AS_MODE_START         (5)  /**<  @brief ģʽ: 1-DDR0-eRam  */
#define LPM_FLAG_AS_MODE_WIDTH         (1)

/**  ǰ׺ƥ·ɼDDRλģʽ*/
typedef enum dpp_route_as_rsp_len_e
{
    DPP_ROUTE_AS_128b  = 0,  /**<  @brief 128bitģʽ*/
    DPP_ROUTE_AS_256b  = 1,  /**<  @brief 256bitģʽ*/
    DPP_ROUTE_AS_384b  = 2,  /**<  @brief 384bitģʽ*/
    DPP_ROUTE_AS_512b  = 3   /**<  @brief 512bitģʽ*/
} DPP_ROUTE_AS_RSP_LEN_E;

/**  ǰ׺ƥ·ҵID*/
typedef enum dpp_route_id_e
{
    DPP_ROUTE_V4_ID = 4, /**<  @brief route ipv4 ID*/
    DPP_ROUTE_V6_ID = 5, /**<  @brief route ipv6 ID*/
} DPP_ROUTE_ID_E;

/**  ǰ׺ƥ·ҵģʽ*/
typedef enum dpp_route_mode_e
{
    DPP_ROUTE_MODE_IPV4 = 1UL, /**<  @brief ipv4·ģʽ*/
    DPP_ROUTE_MODE_IPV6        /**<  @brief ipv6·ģʽ*/
} DPP_ROUTE_MODE_E;

/**  ǰ׺ƥ·DDRռռģʽ*/
typedef enum dpp_route_ddr_use_mode_e
{
    DPP_ROUTE_DDR_USE_MINOR   = 1, /**<  @brief DDRʹ*/
    DPP_ROUTE_DDR_USE_MIDDLE  = 2, /**<  @brief DDRʹе*/
    DPP_ROUTE_DDR_USE_MAJOR   = 3, /**<  @brief DDRʹ϶*/
} DPP_ROUTE_DDR_USE_MODE_E;

/**  ǰ׺ƥ·ɵԲģʽ*/
typedef enum dpp_route_srh_mode_e
{
    DPP_ROUTE_SRH_MODE_LP    = 1, /**<  @brief ǰ׺ƥģʽ*/
    DPP_ROUTE_SRH_MODE_EQUAL = 2, /**<  @brief ȷƥģʽ*/
} DPP_ROUTE_SRH_MODE_E;

/**  ǰ׺ƥ·ӲԴ */
typedef struct dpp_route_resource_t
{
    ZXIC_UINT32 zblk_num;          /**<  @brief LPM ipv4ipv6zblockĿ*/
    ZXIC_UINT32 *zblk_idx;         /**<  @brief LPM ipv4ipv6zblock*/
    ZXIC_UINT32 ddr4_item_num;     /**<  @brief ipv4ǰ׺ҵddr洢Ŀ256bitΪλ*/
    ZXIC_UINT32 ddr4_baddr;        /**<  @brief ipv4ǰ׺ҵddr洢ռĻַ4K*128bitΪλ*/
    ZXIC_UINT32 ddr4_base_offset;  /**<  @brief ipv4ǰ׺Ƭddr洢ռַƫ256bitΪλ*/
    ZXIC_UINT32 ddr4_ecc_en;       /**<  @brief ̶Ϊ1ipv4ǰ׺ҵddr洢ռECCУʹܱ־*/
    ZXIC_UINT32 ddr4_bank_num;     /**<  @brief ipv4ǰ׺ҵddr洢ռbankƷ */
    ZXIC_UINT32 *ddr4_bank_info;   /**<  @brief ipv4ǰ׺ҵddr洢ռbankţ鴫룬֧ɢ*/
    ZXIC_UINT32 ddr4_share_type;   /**<  @brief ipv4ǰ׺ҵddr洢ռbankģʽμSMMU1_DDR_SHARE_MODE_E*/
    ZXIC_UINT32 ddr6_item_num;     /**<  @brief ipv6ǰ׺ҵddr洢Ŀ256bitΪλ*/
    ZXIC_UINT32 ddr6_baddr;        /**<  @brief ipv6ǰ׺ҵddr洢ռĻַ4K*128bitΪλ*/
    ZXIC_UINT32 ddr6_base_offset;  /**<  @brief ipv6ǰ׺Ƭddr洢ռַƫ256bitΪλ*/
    ZXIC_UINT32 ddr6_ecc_en;       /**<  @brief ̶Ϊ1ipv4ǰ׺ҵddr洢ռECCУʹܱ־*/
    ZXIC_UINT32 ddr6_bank_num;     /**<  @brief ipv6ǰ׺ҵddr洢ռbankƷ */
    ZXIC_UINT32 *ddr6_bank_info;   /**<  @brief ipv6ǰ׺ҵddr洢ռbankţ鴫룬֧ɢ*/
    ZXIC_UINT32 ddr6_share_type;   /**<  @brief ipv6ǰ׺ҵddr洢ռbankģʽμSMMU1_DDR_SHARE_MODE_E*/
} DPP_ROUTE_RESOURCE_T;

/**  ǰ׺ƥ·ɼƬeRam */
typedef struct dpp_route_as_eram_t
{
    ZXIC_UINT32 baddr;     /**<  @brief LPMeRamַ*/
    ZXIC_UINT32 rsp_mode;  /**<  @brief LPMeRamλģʽȡֵERAM128_TBL_MODE_EĶ*/
} DPP_ROUTE_AS_ERAM_T;

/**  ǰ׺ƥ·ɼƬDDR */
typedef struct dpp_route_as_ddr_t
{
    ZXIC_UINT32 baddr;        /**<  @brief ddrռĻַ4K*128bitΪλ*/
    ZXIC_UINT32 rsp_len;      /**<  @brief LPMDDRλģʽȡֵDPP_ROUTE_AS_RSP_LEN_EĶ*/
    ZXIC_UINT32 ecc_en;       /**<  @brief DDRռECCУʹܱ־: 0-ʹܣ1-ʹ*/
} DPP_ROUTE_AS_DDR_T;

typedef union dpp_route_as_rslttbl_u
{
    DPP_ROUTE_AS_ERAM_T as_eram_cfg;  /**<  @brief LPMeRamռ*/
    DPP_ROUTE_AS_DDR_T  as_ddr_cfg;   /**<  @brief LPMDDRռ*/
} DPP_ROUTE_AS_RSLTTBL_U;

/**  ǰ׺ƥIPv4ֵ*/
typedef struct dpp_route_ipv4_key_t
{
    ZXIC_UINT32     vpnid;          /**<  @brief vpnid16bit*/
    ZXIC_UINT32     mask_len;       /**<  @brief IPַ볤ȣСΪ0(ʾĬ·)Ϊ32*/
    ZXIC_UINT32     ipv4_addr;      /**<  @brief IPַ32bit*/
} DPP_ROUTE_IPV4_KEY_T;

/**  ǰ׺ƥIPv4·Ŀ*/
typedef struct dpp_route_entry_ipv4_t
{
    DPP_ROUTE_IPV4_KEY_T route_key; /**<  @brief ֵ*/
    ZXIC_UINT32         route_handle;    /**<  @brief ֵƥ󣬼ת*/
    ZXIC_UINT8           *p_as_rslt;      /**<  @brief תʹlpmҵЧ */
} DPP_ROUTE_ENTRY_IPV4_T;

/**  ǰ׺ƥIPv6ֵ*/
typedef struct dpp_route_ipv6_key_t
{
    ZXIC_UINT32    vpnid;      /**<  @brief vpnid16bit*/
    ZXIC_UINT32    mask_len;   /**<  @brief IPַ볤ȣСΪ0(ʾĬ·)Ϊ128*/
    ZXIC_UINT32    ipaddr[4];  /**<  @brief IPַ128bit*/
} DPP_ROUTE_IPV6_KEY_T;

/**  ǰ׺ƥIPv6·Ŀ*/
typedef struct dpp_route_entry_ipv6_t
{
    DPP_ROUTE_IPV6_KEY_T route_key;  /**<  @brief ֵ*/
    ZXIC_UINT32         route_handle;     /**<  @brief ֵƥ󣬼ת*/
    ZXIC_UINT8           *p_as_rslt;       /**<  @brief תʹlpmҵЧ */
} DPP_ROUTE_ENTRY_IPV6_T;

/* HASHгʼʱҪ洢Ĳ */
typedef struct dpp_hash_soft_reset_stor_dat
{
    /* dpp_hash_init()Ĳ */
    ZXIC_UINT32 ddr_dis_flag[4];     /**<  @brief 4HASHǷDISABLE DDR־ */
    ZXIC_UINT32 zblk_num[4];         /**<  @brief 4HASHʹõzblk */
    ZXIC_UINT32 *zblk_idx_start[4];  /**<  @brief 4HASHʹõʼzblk index */

    /* dpp_hash_bulk_init()Ĳ */
    ZXIC_UINT32 ddr_item_num[4][8];  /**<  @brief ÿbulkռŵddr item */
    ZXIC_UINT32 ddr_base_addr[4];    /**<  @brief ÿhashַ */
    ZXIC_UINT32 ddr_bank_cp[4];      /**<  @brief ÿhashbank copy */
    ZXIC_UINT32 ddr_ecc_en[4];       /**<  @brief ddrǷeccʹ */

    /*     ZXIC_UINT32 ddr_width_mode[4]; */       /**<  @brief ddr洢λ */
    /*     ZXIC_UINT32 ddr_crc_sel[4];  */      /**<  @brief ddrʽѡ */
    /*     ZXIC_UINT32 ddr_share_type[4]; */       /**<  @brief ddr  */

    ZXIC_UINT32 hash_id_valid;       /** HASHǷѾʼ־ */
} DPP_HASH_SOFT_RESET_STOR_DAT;



/***********************************************************/
/** ʼ㷨ݽṹûԶָ
* @param   p_se_cfg  㷨ݽṹָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS  dpp_se_init(DPP_SE_CFG *p_se_cfg);

/***********************************************************/
/** ʼ㷨ݽṹûԶָ
* @param   dev_id           豸 
* @param   p_se_cfg         㷨ݽṹָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS  dpp_se_init_ex(ZXIC_UINT32 dev_id, DPP_SE_CFG *p_se_cfg);

/***********************************************************/
/** ʼ㷨ݽṹûԶָ룬ǰڴ豸ŵֵ
* @param   p_se_cfg  㷨ݽṹָ
* @param   p_client  ûԶָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS dpp_se_client_init(DPP_SE_CFG *p_se_cfg, ZXIC_VOID *p_client);

/***********************************************************/
/** hashʼ
* @param   p_se_cfg      㷨ģ鹫ݽṹָ
* @param   fun_id         hash
* @param   zblk_num      hashzblockĿ
* @param   zblk_idx      hashzblock
* @param   ddr_dis       DDRرλ0-رƬDDR, 1-رƬDDR
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/15
************************************************************/
DPP_STATUS dpp_hash_init(DPP_SE_CFG *p_se_cfg,
                         ZXIC_UINT32     fun_id,
                         ZXIC_UINT32     zblk_num,
                         ZXIC_UINT32     *zblk_idx,
                         ZXIC_UINT32     ddr_dis);

/***********************************************************/
/** ʼhashڵĳҵ˽ӿ֧Ϊҵռzcell
*     ȳʼhash棬ٳʼҵ
* @param   p_se_cfg        㷨ģ鹫ݽṹָ
* @param   fun_id         hash
* @param   bulk_id         ÿHashԴֵĿռID
* @param   p_ddr_resc_cfg  hashԴռddrԴ
* @param   zcell_num       hashԴռzcell
* @param   zreg_num        hashԴռzreg
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/15
************************************************************/
DPP_STATUS dpp_hash_bulk_init(DPP_SE_CFG *p_se_cfg,
                              ZXIC_UINT32     fun_id,
                              ZXIC_UINT32     bulk_id,
                              DPP_HASH_DDR_RESC_CFG_T *p_ddr_resc_cfg,
                              ZXIC_UINT32     zcell_num,
                              ZXIC_UINT32     zreg_num);

/***********************************************************/
/** ʼhashڵĳҵ˽ӿ֧Ϊҵռzcell
*   ȳʼhash棬Ƭ+Ƭģʽȳʼdpp_hash_ddr_bulk_init
*   ٳʼҵ
* @param   p_se_cfg    㷨ģ鹫ݽṹָ
* @param   fun_id      hash
* @param   tbl_id          ҵ
* @param   tbl_flag        ʼ, bitmapʽʹã:HASH_TBL_FLAG_AGE
* @param   key_type        hashĿͣȡֵDPP_HASH_KEY_TYPEĶ
* @param   actu_key_size   ҵֵЧ: 8bit*NN=1~48
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/15
************************************************************/
DPP_STATUS dpp_hash_tbl_id_info_init(DPP_SE_CFG *p_se_cfg,
                                     ZXIC_UINT32  fun_id,
                                     ZXIC_UINT32  tbl_id,
                                     ZXIC_UINT32  tbl_flag,
                                     ZXIC_UINT32  key_type,
                                     ZXIC_UINT32  actu_key_size);

/***********************************************************/
/** hashĿ
* @param   p_se_cfg  㷨ģ鹫ݽṹָ
* @param   fun_id    hash
* @param   p_entry   hashĿkeyresultkeyĸʽΪ:valid(1bit) + key_type(2bit) + tbl_id(5bit) + actu_key(32*N bit) \n
*                    resultĳɵǰҵλkeyӲܳkey_typeȷĳȡ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/15
************************************************************/
DPP_STATUS dpp_hash_insert(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 fun_id, DPP_HASH_ENTRY *p_entry);


/***********************************************************/
/** hashɾĿ
* @param   p_se_cfg   㷨ģ鹫ݽṹָ
* @param   fun_id     hash
* @param   p_entry    hashĿkeyresultнkeyЧkeyĸʽΪ:valid(1bit) + key_type(2bit) + tbl_id(5bit) + actu_key(32*N bit)
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/15
************************************************************/
DPP_STATUS dpp_hash_delete(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 fun_id, DPP_HASH_ENTRY *p_entry);


/***********************************************************/
/** hashҵԺ
* @param   p_se_cfg    㷨ģ鹫ݽṹָ
* @param   fun_id      hash
* @param   p_entry     hashĿkeyresultʱkeyλΪ392bitʽΪ:wr_flag(1bit) + key_type(2bit) + tbl_id(5bit) + reserve(M bit)+ actu_key(32*N bit) \n
*                      resultӲѧϰʹܵ£ؿλõĵַ
* @param   p_space_vld ѧϰʹʱǷппռ
* @param   srh_mode    ģʽȡֵοDPP_HASH_SRH_MODEĶ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/15
************************************************************/
DPP_STATUS dpp_hash_search(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 fun_id, DPP_HASH_ENTRY *p_entry, ZXIC_UINT32 *p_space_vld, ZXIC_UINT32 srh_mode);

/***********************************************************/
/** hash ϻpendingλʽ
* @param   dev_id     豸
* @param   hash_id    hash
* @param   mode       ϻpendingλʽ 1-¸ʽ 0-ϸʽ
*
*
* @return
* @remark  
* @see
* @author  tf      @date  2016/05/13
************************************************************/
DPP_STATUS dpp_hash_age_pat_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 hash_id, ZXIC_UINT32 mode);

/***********************************************************/
/** ʼǰ׺ƥ·ģԴ
* @param   p_se_cfg      㷨ģ鹫ݽṹָ
* @param   flags         ǰ׺·ʹܱ־bitmapʽʹãÿصĺ"ǰ׺·ҵʼ־"
* @param   p_resrc_info  Ϊǰ׺·ɷZCAMDDR3Դ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2016/06/16
************************************************************/
DPP_STATUS dpp_route_resource_init(DPP_SE_CFG *p_se_cfg,
                                   ZXIC_UINT32     flags,
                                   DPP_ROUTE_RESOURCE_T *p_resrc_info);

/***********************************************************/
/** ʼ·ҵ(ipv4 or ipv6) Ĭ ECCʹ
* @param   p_se_cfg    㷨ģ鹫ݽṹָ
* @param   id          ǰ׺ƥ·ҵIDȡֵDPP_ROUTE_ID_EĶ
* @param   max_num     ·Ŀ
* @param   route_mode  ǰ׺ƥ·ҵģʽȡֵDPP_ROUTE_MODE_EĶ
* @param   flags       ǰ׺ƥ·ɿռʹģʽȡֵDPP_ROUTE_DDR_USE_MODE_EĶ塣
* @param   zblk_num    ҵzblockĿ
* @param   zblk_idx    ҵzblock
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS dpp_route_init(DPP_SE_CFG *p_se_cfg,
                          ZXIC_UINT32     id,
                          ZXIC_UINT32     max_num,
                          ZXIC_UINT32     route_mode,
                          ZXIC_UINT32     flags,
                          ZXIC_UINT32     zblk_num,
                          ZXIC_UINT32     *zblk_idx);

/***********************************************************/
/** ·ɼ
* @param   p_se_cfg  㷨ݽṹָ
* @param   as_type   ·ɼ: 1-DDR, 0-eRam
* @param   tbl_id    ţeRamģʽЧȡֵΧ[0,7],(ͨvpnid3bitȷ)
* @param   p_as_cfg  
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2016/06/14
************************************************************/
DPP_STATUS dpp_route_as_rslttbl_set(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 as_type, ZXIC_UINT32 tbl_id, DPP_ROUTE_AS_RSLTTBL_U *p_as_cfg);

/***********************************************************/
/** ·ɲ뺯
* @param   p_se_cfg  㷨ģ鹫ݽṹָ
* @param   id        ǰ׺ƥ·ҵIDȡֵDPP_ROUTE_ID_EĶ
* @param   p_entry   ·Ŀ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS dpp_route_insert(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 id, ZXIC_VOID *p_entry);

/***********************************************************/
/** ·ɾ
* @param   p_se_cfg  㷨ģ鹫ݽṹָ
* @param   id        ǰ׺ƥ·ҵIDȡֵDPP_ROUTE_ID_EĶ
* @param   p_entry   ·Ŀɾʱֵָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS dpp_route_delete(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 id, ZXIC_VOID *p_entry);

/***********************************************************/
/** ǰ׺ƥ·ɵԲҺв
* @param   p_se_cfg  㷨ģ鹫ݽṹָ
* @param   id        ǰ׺ƥ·ҵIDȡֵDPP_ROUTE_ID_EĶ
* @param   p_entry   Ŀʱֵָ
* @param   srh_mode  ƥģʽȡֵDPP_ROUTE_SRH_MODE_EĶ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS dpp_route_search(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 id, ZXIC_VOID *p_entry, ZXIC_UINT32 srh_mode);

#endif

#if ZXIC_REAL("eTcam data struct and function")
typedef DPP_STATUS (*ACL_AS_RSLT_WRT_FUNCTION)(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index, ZXIC_UINT32 as_mode, ZXIC_UINT8 *p_data);
#define DPP_ACL_TBL_ID_NUM      (8U)
#define DPP_ACL_ETCAM_ID_NUM    (1U)
#define DPP_ACL_BLOCK_NUM       (8U)

/**  eTcamĿλģʽ*/
typedef enum dpp_etcam_entry_mode_e
{
    DPP_ETCAM_KEY_640b = 0,
    DPP_ETCAM_KEY_320b = 1,
    DPP_ETCAM_KEY_160b = 2,
    DPP_ETCAM_KEY_80b  = 3,
    DPP_ETCAM_KEY_INVALID,
} DPP_ETCAM_ENTRY_MODE_E;

/**  eTcam*/
typedef enum dpp_etcam_opr_type_e
{
    DPP_ETCAM_OPR_DM = 0,  /**<  @brief data & mask*/
    DPP_ETCAM_OPR_XY = 1,  /**<  @brief X & Y*/
} DPP_ETCAM_OPR_TYPE_E;

/**  eTcamĿʽ*/
typedef struct dpp_etcam_entry_t
{
    ZXIC_UINT32 mode;     /**<  @brief Ŀλģʽ: 2'b00-640bit,2'b01-320bit,2'b10-160bit,2'b11-80bit*/
    ZXIC_UINT8   *p_data;  /**<  @brief ֵ*/
    ZXIC_UINT8   *p_mask;  /**<  @brief */
} DPP_ETCAM_ENTRY_T;

/**  ACLֵλģʽ*/
typedef enum dpp_acl_key_mode_e
{
    DPP_ACL_KEY_640b = 0, /**<  @brief 640bitֵλ*/
    DPP_ACL_KEY_320b,     /**<  @brief 320bitֵλ*/
    DPP_ACL_KEY_160b,     /**<  @brief 160bitֵλ*/
    DPP_ACL_KEY_80b,      /**<  @brief 80bitֵλ*/
    DPP_ACL_KEY_INVALID,
} DPP_ACL_KEY_MODE_E;

/**  ACLҽλģʽ*/
typedef enum dpp_acl_as_mode_e
{
    DPP_ACL_AS_MODE_16b  = 0,
    DPP_ACL_AS_MODE_32b  = 1,
    DPP_ACL_AS_MODE_64b  = 2,  /**<  @brief 64bitλ*/
    DPP_ACL_AS_MODE_128b = 3,  /**<  @brief 128bitλ*/
    DPP_ACL_AS_MODE_INVALID,
} DPP_ACL_AS_MODE_E;

/**  ACLԲģʽ*/
typedef enum dpp_acl_srh_mode_e
{
    DPP_ACL_SRH_SOFT     = 0, /**<  @brief */
    DPP_ACL_SRH_HARDWARE = 1, /**<  @brief Ӳ*/
} DPP_ACL_SRH_MODE_E;

/**  ACLĿ*/
typedef struct dpp_acl_entry_t
{
    ZXIC_UINT32  handle;     /**<  @brief Ŀ*/
    ZXIC_UINT8    *key_data;  /**<  @brief ֵdata*/
    ZXIC_UINT8    *key_mask;  /**<  @brief ֵmask: 0Ϊģ1Ϊ*/
    ZXIC_UINT8    *p_as_rslt; /**<  @brief ʹܹЧ*/
} DPP_ACL_ENTRY_T;

typedef struct dpp_acl_block_info_t
{
    ZXIC_UINT32 is_used;
    ZXIC_UINT32 tbl_id;
    ZXIC_UINT32 idx_base;
} DPP_ACL_BLOCK_INFO_T;

typedef struct dpp_acl_etcamid_cfg_t
{
    ZXIC_UINT32 is_valid;
    ZXIC_UINT32 as_enable;     /* eTcamԶeRamʹ: 0-ʹܣ1-ʹ */
    ZXIC_UINT32 as_idx_offset; /* ַƫƣ128bitΪλ */
    ZXIC_UINT32 as_eRam_base;  /* eTcamԶeRam blockĻַ128bitΪλ */
    D_HEAD tbl_list;
} DPP_ACL_ETCAMID_CFG_T;

typedef struct dpp_acl_key_info_t
{
    ZXIC_UINT32 handle;
    ZXIC_UINT32 pri;
    ZXIC_UINT8   key[0];  /* data+mask */
} DPP_ACL_KEY_INFO_T;

/**  ACLʼʹܱ־*/
#define DPP_ACL_FLAG_ETCAM0_EN        (1<<0) /**<  @brief eTcam˿0: 0-1-.*/
#define DPP_ACL_FLAG_ETCAM0_AS        (1<<2) /**<  @brief eTcam˿0Ĺ: 0-1-.*/
//#define DPP_ACL_FLAG_ETCAM1_AS        (1<<3) /**<  @brief eTcam˿1Ĺ: 0-1-.*/

typedef DPP_STATUS (*ACL_TBL_AS_DDR_WR_FUN)(ZXIC_UINT32 dev_id, ZXIC_UINT32 tbl_type, ZXIC_UINT32 tbl_id, ZXIC_UINT32 dir_tbl_share_type, ZXIC_UINT32 dir_tbl_base_addr, ZXIC_UINT32 ecc_en, ZXIC_UINT32 index, ZXIC_UINT32 as_mode, ZXIC_UINT8 *p_data);
typedef DPP_STATUS (*ACL_TBL_AS_DDR_RD_FUN)(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index, ZXIC_UINT32 as_mode, ZXIC_UINT8 *p_data);

/**  */
typedef struct dpp_acl_tbl_cfg_t
{
    ZXIC_UINT32 tbl_type;
    ZXIC_UINT32 table_id;
    ZXIC_UINT8   is_as_ddr;
    ZXIC_UINT8   ddr_bankcp_info;
    ZXIC_UINT32 dir_tbl_share_type;
    ZXIC_UINT8   ddr_ecc_en;
    ZXIC_UINT32 pri_mode;
    ZXIC_UINT32 key_mode;
    ZXIC_UINT32 entry_num;
    ZXIC_UINT32 block_num;
    ZXIC_UINT32 *block_array;
    ZXIC_UINT32 is_used;
    ZXIC_UINT32 as_mode;
    ZXIC_UINT32 as_idx_base;
    ZXIC_UINT32 as_enable;           /* eTcamԶeRamʹ: 0-ʹܣ1-ʹ */
    ZXIC_UINT32 as_eRam_base;        /* eTcamԶeRam blockĻַ128bitΪλ */
    ZXIC_UINT32 ddr_baddr;
    ZXIC_UINT32 idx_offset; /* ddr_baddrĻַƫƣas_modeӦλΪλ */
    ACL_TBL_AS_DDR_WR_FUN p_as_ddr_wr_fun;
    ACL_TBL_AS_DDR_RD_FUN p_as_ddr_rd_fun;
    D_NODE         entry_dn;
    INDEX_FILL_CFG index_mng;
    ZXIC_RB_CFG     acl_rb;
    DPP_ACL_KEY_INFO_T  **acl_key_buff;
    ZXIC_UINT8  *as_rslt_buff;
} DPP_ACL_TBL_CFG_T;

/**  ACLݽṹ*/
typedef struct dpp_acl_cfg_t
{
    ZXIC_VOID    *p_client;
    ZXIC_UINT32  dev_id;
    ZXIC_UINT32  flags;
    ACL_AS_RSLT_WRT_FUNCTION  p_as_rslt_write_fun;
    ACL_AS_RSLT_WRT_FUNCTION  p_as_rslt_read_fun;
    DPP_ACL_BLOCK_INFO_T      acl_blocks[DPP_ACL_BLOCK_NUM];
    DPP_ACL_ETCAMID_CFG_T     acl_etcamids;
    DPP_ACL_TBL_CFG_T         acl_tbls[DPP_ACL_TBL_ID_NUM];
} DPP_ACL_CFG_T;

/**<  @brief ACLݽṹ*/
typedef struct dpp_acl_cfg_ex_t
{
    ZXIC_VOID    *p_client;
    ZXIC_UINT32  dev_id;
    ZXIC_UINT32  flags;
    ACL_AS_RSLT_WRT_FUNCTION  p_as_rslt_write_fun;
    ACL_AS_RSLT_WRT_FUNCTION  p_as_rslt_read_fun;
    DPP_ACL_BLOCK_INFO_T      acl_blocks[DPP_ACL_BLOCK_NUM];
    DPP_ACL_ETCAMID_CFG_T     acl_etcamids;
    DPP_ACL_TBL_CFG_T         acl_tbls[DPP_ACL_TBL_ID_NUM];
}DPP_ACL_CFG_EX_T;

/**  aclȼģʽ*/
typedef enum dpp_acl_pri_mode_e
{
    DPP_ACL_PRI_EXPLICIT = 1, /**<  @brief ʾȼ*/
    DPP_ACL_PRI_IMPLICIT,     /**<  @brief ʽȼĿ·˳Ϊȼ*/
    DPP_ACL_PRI_SPECIFY,      /**<  @brief ûָÿĿtcamеĴ*/
    DPP_ACL_PRI_INVALID,
} DPP_ACL_PRI_MODE_E;

/**  */
typedef struct dpp_acl_entry_ex_t
{
    ZXIC_UINT32  idx_val;   /**<  @brief һβ뵥aclĿʱЧص*/
    D_HEAD  idx_list;  /**<  @brief һβaclĿʱЧض*/
    ZXIC_UINT32  pri;       /* PRI_EXPLICIT: pri is priority, PRI_IMPLICIT: pri is invalid, PRI_SPECIFY: pri is handle */
    ZXIC_UINT8    *key_data;
    ZXIC_UINT8    *key_mask;
    ZXIC_UINT8    *p_as_rslt;
} DPP_ACL_ENTRY_EX_T;

/***********************************************************/
/** eTcamģʼ
* @param   dev_id 豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/07/24
************************************************************/
DPP_STATUS dpp_etcam_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/**
* @param   p_acl_cfg   ACLݽṹָ
* @param   p_client   ûԶָ
* @param   flags
* @param   p_as_wrt_fun   дӲصָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  yxh      @date  2017/12/15
************************************************************/
DPP_STATUS dpp_acl_cfg_init_ex(DPP_ACL_CFG_EX_T *p_acl_cfg,
                               ZXIC_VOID *p_client,
                               ZXIC_UINT32 flags,
                               ACL_AS_RSLT_WRT_FUNCTION p_as_wrt_fun);

/***********************************************************/
/** 뵥ACLĿûָhandle
* @param   p_acl_cfg  ACLݽṹָ
* @param   table_id   ҵ
* @param   p_acl_entry  ACLĿָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS dpp_acl_tbl_insert(DPP_ACL_CFG_T *p_acl_cfg, ZXIC_UINT32 table_id, DPP_ACL_ENTRY_T *p_acl_entry);

/***********************************************************/
/** ɾACLĿûָhandle
* @param   p_acl_cfg   ACLݽṹָ
* @param   table_id    ҵ
* @param   p_acl_entry aclĿָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/05/20
************************************************************/
DPP_STATUS dpp_acl_tbl_delete(DPP_ACL_CFG_T *p_acl_cfg, ZXIC_UINT32 table_id, DPP_ACL_ENTRY_T *p_acl_entry);

/***********************************************************/
/** aclҵʼעһtableĶblock_idx
    밴С˳ֶ֧ȼģʽݲ⿪š
* @param   p_acl_cfg   ACLݽṹָ
* @param   table_id   ҵ
* @param   as_enable   Ƿʹܹң0-ʹܣ1-ʹ
* @param   entry_num   Ŀ
* @param   pri_mode   ACLȼģʽ
* @param   key_mode   ACLֵλģʽ, ȡֵDPP_ACL_KEY_MODE_EĶ
* @param   as_mode   ACLҽλģʽ
* @param   as_baddr   ַ
* @param   block_num   ǰҵŵblockĿ
* @param   p_block_idx   ǰҵŵblock
*
* @return
* @remark  
* @see
* @author  wcl      @date  2014/12/23
************************************************************/
DPP_STATUS dpp_acl_tbl_init_ex(DPP_ACL_CFG_EX_T *p_acl_cfg,
                               ZXIC_UINT32 table_id,
                               ZXIC_UINT32 as_enable,
                               ZXIC_UINT32 entry_num,
                               DPP_ACL_PRI_MODE_E pri_mode,
                               ZXIC_UINT32 key_mode,
                               DPP_ACL_AS_MODE_E  as_mode,
                               ZXIC_UINT32 as_baddr,
                               ZXIC_UINT32 block_num,
                               ZXIC_UINT32 *p_block_idx);

/***********************************************************/
/** ҵԺpri+data+maskȫƥ䣬ȼƥ䡣ֶ֧ȼģʽݲ⿪š
* @param   p_acl_cfg   ACLݽṹָ
* @param   table_id
* @param   p_acl_entry
* @param   srh_mode     ģʽ: 0-soft, 1-hardware
*
* @return
* @remark  
* @see
* @author  wcl      @date  2014/12/23
************************************************************/
DPP_STATUS dpp_acl_tbl_search_ex(DPP_ACL_CFG_EX_T *p_acl_cfg, ZXIC_UINT32 table_id, DPP_ACL_ENTRY_EX_T *p_acl_entry, ZXIC_UINT32 srh_mode);

/***********************************************************/
/**
* @param   p_acl_cfg
* @param   table_id
* @param   p_tcam_entry
*
* @return
* @remark  
* @see
* @author  XXX      @date  2018/09/26
************************************************************/
DPP_STATUS dpp_acl_tbl_read_ex(DPP_ACL_CFG_EX_T *p_acl_cfg, ZXIC_UINT32 table_id, DPP_ACL_ENTRY_EX_T *p_tcam_entry);

#endif

#if ZXIC_REAL("SDT data struct and function")
/** SDTеı */
typedef enum dpp_sdt_table_type_e
{
    DPP_SDT_TBLT_INVALID = 0, /**<  @brief Ч*/
    DPP_SDT_TBLT_eRAM    = 1, /**<  @brief eRAMֱӱ*/
    DPP_SDT_TBLT_DDR3    = 2, /**<  @brief DDR3ֱӱ*/
    DPP_SDT_TBLT_HASH    = 3, /**<  @brief Hash*/
    DPP_SDT_TBLT_LPM     = 4, /**<  @brief LPM*/
    DPP_SDT_TBLT_eTCAM   = 5, /**<  @brief ƬTcam*/
    DPP_SDT_TBLT_PORTTBL = 6, /**<  @brief ˿Ա*/
    DPP_SDT_TBLT_MAX     = 7,
} DPP_SDT_TABLE_TYPE_E;

/**  λģʽ*/
typedef enum dpp_sdt_rsp_mode_e
{
    DPP_SDT_RSP_32b  = 0, /**  32bitλ*/
    DPP_SDT_RSP_64b  = 1, /**  64bitλ*/
    DPP_SDT_RSP_128b = 2, /**  128bitλ*/
    DPP_SDT_RSP_256b = 3, /**  256bitλ*/
} DPP_SDT_RSP_MODE_E;

/**  eRamֱӱSDT*/
typedef struct dpp_sdt_tbl_eram_t
{
    ZXIC_UINT32 table_type;          /** <@brief ұ */
    ZXIC_UINT32 eram_mode;           /** <@brief eRamλ */
    ZXIC_UINT32 eram_base_addr;      /** <@brief eRamַ128bitΪλ */
    ZXIC_UINT32 eram_table_depth;    /** <@brief ȣΪԽʹ   */
    ZXIC_UINT32 eram_clutch_en;      /** <@brief ץʹ */
} DPP_SDTTBL_ERAM_T;

/**  DDR3ֱӱSDT*/
typedef struct dpp_sdt_tbl_ddr3_t
{
    ZXIC_UINT32 table_type;           /** <@brief ұ   */
    ZXIC_UINT32 ddr3_base_addr;       /** <@brief ddr ַ     */
    ZXIC_UINT32 ddr3_share_type;      /** <@brief ddr    */
    ZXIC_UINT32 ddr3_rw_len;          /** <@brief /дλ */
    ZXIC_UINT32 ddr3_sdt_num;         /** <@brief SDT/Ϣramı */
    ZXIC_UINT32 ddr3_ecc_en;          /** <@brief eccʹ        */
    ZXIC_UINT32 ddr3_clutch_en;       /** <@brief ץʹ       */
} DPP_SDTTBL_DDR3_T;

/**  HASHSDT*/
typedef struct dpp_sdt_tbl_hash_t
{
    ZXIC_UINT32 table_type;          /** <@brief ұ       */
    ZXIC_UINT32 hash_id;             /** <@brief hash     */
    ZXIC_UINT32 hash_table_width;    /** <@brief hash 洢λ  */
    ZXIC_UINT32 key_size;            /** <@brief hash ֵ      */
    ZXIC_UINT32 hash_table_id;       /** <@brief hash ߼      */
    ZXIC_UINT32 learn_en;            /** <@brief Ӳѧϰʹ       */
    ZXIC_UINT32 keep_alive;          /** <@brief ־ʹ       */
    ZXIC_UINT32 keep_alive_baddr;     /** <@brief ־ַ     */
    ZXIC_UINT32 rsp_mode;            /** <@brief λ   */
    ZXIC_UINT32 hash_clutch_en;      /** <@brief ץʹ           */
} DPP_SDTTBL_HASH_T;

/**  LPMSDT*/
typedef struct dpp_sdt_tbl_lpm_t
{
    ZXIC_UINT32 table_type;          /** <@brief ұ       */
    ZXIC_UINT32 lpm_v46_id;          /** <@brief ipv4/ipv6־      */
    ZXIC_UINT32 rsp_mode;            /** <@brief λ   */
    ZXIC_UINT32 lpm_table_depth;     /** <@brief ȣԽ */
    ZXIC_UINT32 lpm_clutch_en;       /** <@brief ץʹ           */
} DPP_SDTTBL_LPM_T;

/**  eTCAMSDT*/
typedef struct dpp_sdt_tbl_etcam_t
{
    ZXIC_UINT32 table_type;          /** <@brief ұ       */
    ZXIC_UINT32 etcam_id;            /** <@brief etcamͨ         */
    ZXIC_UINT32 etcam_key_mode;      /** <@brief etcamֵ      */
    ZXIC_UINT32 etcam_table_id;      /** <@brief etcam        */
    ZXIC_UINT32 no_as_rsp_mode;      /** <@brief handleģʽλ */
    ZXIC_UINT32 as_en;               /** <@brief eramʹ       */
    ZXIC_UINT32 as_eram_baddr;       /** <@brief eramַ     */
    ZXIC_UINT32 as_rsp_mode;         /** <@brief λ       */
    ZXIC_UINT32 etcam_table_depth;   /** <@brief ȣԽ */
    ZXIC_UINT32 etcam_clutch_en;     /** <@brief ץʹ           */
} DPP_SDTTBL_ETCAM_T;

/**  ˿ԱSDT*/
typedef struct dpp_sdt_tbl_porttbl_t
{
    ZXIC_UINT32 table_type;          /** <@brief ұ       */
    ZXIC_UINT32 porttbl_clutch_en;   /** <@brief ץʹ           */
} DPP_SDTTBL_PORTTBL_T;

/***********************************************************/
/** ʼSDTù
* @param   dev_num       豸Ŀ
* @param   dev_id_array  豸dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/07/13
************************************************************/
DPP_STATUS dpp_sdt_init(ZXIC_UINT32 dev_num, ZXIC_UINT32 *dev_id_array);

/***********************************************************/
/** дSDTԱĿӲͬʱ8clusterд
* @param   dev_id      豸
* @param   sdt_no      ҵӦsdt
* @param   table_type  SDTеıͣȡֵοDPP_SDT_TABLE_TYPE_EĶ(ӲʱЧ)
* @param   p_sdt_info  дSDT(ӲʱЧ)table_typeȷZXIC_VOIDָӦݽṹ, : \n
*                      DPP_SDTTBL_ERAM_TDPP_SDTTBL_DDR3_TDPP_SDTTBL_HASH_TDPP_SDTTBL_LPM_T\n
*                      DPP_SDTTBL_ETCAM_TDPP_SDTTBL_XTCAM_TDPP_SDTTBL_PORTTBL_T
* @param   opr_type    : 0-Ŀ1-ɾĿ.
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2015/07/11
************************************************************/
DPP_STATUS dpp_sdt_tbl_write(ZXIC_UINT32 dev_id,
                             ZXIC_UINT32 sdt_no,
                             ZXIC_UINT32 table_type,
                             ZXIC_VOID *p_sdt_info,
                             ZXIC_UINT32 opr_type);

/***********************************************************/
/** ȡSDTԱĿĬϹ̶cluster 0ȡɸ
* @param   dev_id      豸
* @param   sdt_no      ҵӦsdt
* @param   p_sdt_info  صSDTԣSDTеtable_typeȷZXIC_VOIDָӦݽṹ, : \n
*                      DPP_SDTTBL_ERAM_TDPP_SDTTBL_DDR3_TDPP_SDTTBL_HASH_TDPP_SDTTBL_LPM_T\n
*                      DPP_SDTTBL_ETCAM_TDPP_SDTTBL_XTCAM_TDPP_SDTTBL_PORTTBL_T
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2015/07/13
************************************************************/
DPP_STATUS dpp_sdt_tbl_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no, ZXIC_VOID *p_sdt_info);

/***********************************************************/
/** seⲿppu֮ؼ
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2015/11/07
************************************************************/
DPP_STATUS diag_dpp_se_fc(ZXIC_UINT32 dev_id);

/***********************************************************/
/** seģϸؼ()
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2015/11/07
************************************************************/
DPP_STATUS diag_dpp_se_detail_fc(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ݼֵӡddrе洢Ŀ
* @param   dev_id
* @param   hash_id
* @param   table_id
* @param   zcell_idx
* @param   input0             ֵλ
* @param   input1             ֵθλ
* @param   input2             ֵελ
* @param   input3             ֵλ
* @param   input4             ֵελ
* @param   input5             ֵλ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  xcx               @date  2017/10/16
************************************************************/
DPP_STATUS diag_dpp_se_hash_ddr4_item_prt(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 hash_id,
                                          ZXIC_UINT8 table_id,
                                          ZXIC_UINT32 input0,
                                          ZXIC_UINT32 input1,
                                          ZXIC_UINT32 input2,
                                          ZXIC_UINT32 input3,
                                          ZXIC_UINT32 input4,
                                          ZXIC_UINT32 input5);

/***********************************************************/
/** ݼֵӡzblockе洢Ŀ
* @param      dev_id
* @param      hash_id
* @param      table_id
* @param      zcell_idx
* @param      input0               ֵλ
* @param      input1               ֵθλ
* @param      input2               ֵελ
* @param      input3               ֵλ
* @param      input4               ֵελ
* @param      input5               ֵλ
*
* @return      NPE_OK-ɹNPE_ERR-ʧ
* @remark      
* @see
* @author      xcx              @date      2017/09/18
************************************************************/
DPP_STATUS diag_dpp_se_hash_zcam_item_prt(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 hash_id,
                                          ZXIC_UINT8 table_id,
                                          ZXIC_UINT32 zcell_idx,
                                          ZXIC_UINT32 input0,
                                          ZXIC_UINT32 input1,
                                          ZXIC_UINT32 input2,
                                          ZXIC_UINT32 input3,
                                          ZXIC_UINT32 input4,
                                          ZXIC_UINT32 input5);

/***********************************************************/
/** ERAM128bit
* @param   dev_id       豸
* @param   base_addr    ַ
* @param   index        ʼ
* @param   number       ȡĿ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/01/16
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_rd128_more(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 base_addr,
                                        ZXIC_UINT32 index,
                                        ZXIC_UINT32 number);

/***********************************************************/
/** ȡeccĵַ
* @param
* @param
* @param
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xcx      @date  20161026
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_ecc_addr_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** SMMU1256bitDDR3
* @param   dev_id         豸
* @param   base_addr      ַ
* @param   index          
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552         @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_rd256_more(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 base_addr,
                                        ZXIC_UINT32 index,
                                        ZXIC_UINT32 number);

/***********************************************************/
/** SMMU1512bitDDR3
* @param   dev_id         豸
* @param   base_addr      ַ
* @param   index          
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  chenqin00181032         @date  2022/10/24
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_rd512_more(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 base_addr,
                                        ZXIC_UINT32 index,
                                        ZXIC_UINT32 number);

/***********************************************************/
/** seetcam ramȫַ
* @param   dev_id
* @param   mode       ģʽ 0:ģʽ1:ûdataģʽ
* @param   data       ûdata, modeΪ0,òЧ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  YXH      @date  2020/07/06
************************************************************/
DPP_STATUS diag_dpp_se_zcam_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

/***********************************************************/
/** ֱӱ
* @param   dev_id        豸
* @param   sdt_no        sdtţ0-255
* @param   index         Ŀ,sdtϢеλΪλ
* @param   p_data        
* @return  
* @remark  
* @see     
* @author  lim      @date  2020/01/21
************************************************************/
DPP_STATUS dpp_dir_tbl_add(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no, ZXIC_UINT32 index, ZXIC_UINT32 *p_data);

/***********************************************************/
/** ֱӱ(ִ֧,֧1286432bitд룩
* @param   dev_id        豸
* @param   sdt_no        sdtţ0-255
* @param   index         Ŀ,sdtϢеλΪλ
* @param   p_data        
* @param   p_mask          bitmapwr_modeйأ1ʾbit0ʾҪbit
* @return  
* @remark  
* @see     
* @author  wzz      @date  2020/10/22
************************************************************/
DPP_STATUS dpp_dir_tbl_mask_add(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 sdt_no,
                                ZXIC_UINT32 index,
                                ZXIC_UINT32 *p_data,
                                ZXIC_UINT32 *p_mask);

/***********************************************************/
/** ֱӱ
* @param   dev_id     豸
* @param   sdt_no        sdtţ0-1023
* @param   index         ĿsdtϢеλΪλ
* @param   p_data        
* @return  
* @remark  
* @see     
* @author  lim      @date  2020/01/21
************************************************************/
DPP_STATUS dpp_dir_tbl_srh(ZXIC_UINT32 dev_id,
                           ZXIC_UINT32 sdt_no,
                           ZXIC_UINT32 index,
                           ZXIC_UINT32 *p_data);

/***********************************************************/
/** ödone״̬
* @param   dev_id        豸
* @param   rd_period     ȡ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cq      @date  2024/02/01
************************************************************/
ZXIC_UINT32 dpp_se_rd_done_period_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 rd_period);

/***********************************************************/
/** ȡdone״̬
* @param   dev_id        豸
* @param   rd_period     ȡ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cq      @date  2024/02/01
************************************************************/
ZXIC_UINT32 dpp_se_rd_done_period_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *rd_period);

#endif

#endif /*dpp_se_api.h*/
