/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_stat_api.h
* ļʶ : statģͶͽӿں
* ժҪ : 
* ˵ : 
* ǰ汾 : 
*      : xjw
*  : 2015/02/09
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef _DPP_STAT_API_H_
#define _DPP_STAT_API_H_


#if ZXIC_REAL("header file")

#include "dpp_dev.h"

#endif

#if ZXIC_REAL("data struct define")
/**  STATģTMģʽ*/
typedef enum stat_tm_mode_e
{
    STAT_TM_MODE_ETM = 0,        /**< @brief TM */
    STAT_TM_MODE_FTM = 1,        /**< @brief TM */
    STAT_TM_MODE_MAX
}STAT_TM_MODE_E;

/** TMͳƶ˿ѡ */
typedef enum stat_tm_port_mode_e
{
    STAT_TM_PORT_MODE_0_1 = 0,      /**< @brief ˿0~1 */
    STAT_TM_PORT_MODE_2_3 = 1,      /**< @brief ˿2~3 */
    STAT_TM_PORT_MODE_MAX,
}STAT_TM_PORT_MODE_E;

/**TMͳƼģʽѡ  */
typedef enum stat_tm_cnt_mode_e
{
    STAT_TM_CNT_MODE_MIX = 0,        /**< @brief ģʽ */
    STAT_TM_CNT_MODE_INNER = 1,      /**< @brief ڲģʽ */
    STAT_TM_CNT_MODE_MAX
}STAT_TM_CNT_MODE_E;

/* TM֧ͣ20  */
typedef enum tm_stat_type_e {

    TM_STAT_ENQUE_PKT                   = 0,  /**<  @brief Ӱ*/
    TM_STAT_ENQUE_VALID_PKT             = 1,  /**<  @brief VALID*/      
    TM_STAT_ENQUE_DROP_PKT              = 2,  /**<  @brief Ӷ*/      
    TM_STAT_ENQUE_TD_PKT                = 3,  /**<  @brief TD*/      
    TM_STAT_ENQUE_WRED_PKT              = 4,  /**<  @brief WRED*/      
    TM_STAT_ENQUE_DP0_PKT               = 5,  /**<  @brief DP0*/      
    TM_STAT_ENQUE_DP1_PKT               = 6,  /**<  @brief DP1*/     
    TM_STAT_ENQUE_DP2_PKT               = 7,  /**<  @brief DP2*/     
    TM_STAT_ENQUE_DP3_PKT               = 8,  /**<  @brief DP3*/      
    TM_STAT_ENQUE_DP4_PKT               = 9,  /**<  @brief DP4*/      
    TM_STAT_ENQUE_DP5_PKT               = 10, /**<  @brief DP5*/       
    TM_STAT_ENQUE_DP6_PKT               = 11, /**<  @brief DP6*/    
    TM_STAT_ENQUE_DP7_PKT               = 12, /**<  @brief DP7*/     
    TM_STAT_ENQUE_BLOCK_PKT             = 13, /**<  @brief BLOCK*/     
    TM_STAT_ENQUE_DISABLE_PKT           = 14, /**<  @brief DISABLE*/   
    TM_STAT_DEQUE_PKT                   = 15, /**<  @brief Ӱ*/
    TM_STAT_DEQUE_VALID_PKT             = 16, /**<  @brief VALID*/
    TM_STAT_DEQUE_DISCARD_PKT           = 17, /**<  @brief DISCARD*/
    TM_STAT_DEQUE_CLEAR_PKT             = 18, /**<  @brief CLEAR*/   
    TM_STAT_DEQUE_AGE_PKT               = 19, /**<  @brief AGE*/
    TM_STAT_TYPE_UNEN                   = 20, /**<  @brief ʹܵʱó*/
    TM_STAT_TYPE_MAX
} TM_STAT_TYPE_E;

/** carļ */
typedef enum stat_car_type_e
{
    STAT_CAR_A_TYPE  = 0,      /**<  @brief ACAR*/
    STAT_CAR_B_TYPE,         /**<  @brief BCAR*/
    STAT_CAR_C_TYPE,         /**<  @brief CCAR*/
    STAT_CAR_MAX_TYPE
}STAT_CAR_TYPE_E;

/** carܶ*/
typedef struct stat_car_queue_cfg_t
{
    ZXIC_UINT32 queue_id;        /**<  @brief к*/
    ZXIC_UINT32 plcr_en;         /**<  @brief CARʹ*/
    ZXIC_UINT32 drop_flag;       /**<  @brief */
    ZXIC_VOID * profile_cfg;     /**< @brief carAİģʽʱṹDPP_STAT_CAR_PKT_PROFILE_CFG_TģʽʱṹDPP_STAT_CAR_PROFILE_CFG_T*/    
}STAT_CAR_QUEUE_CFG_T;

/**  statģģʽ*/
typedef struct stat_count_cfg_t
{
    ZXIC_UINT32 rd_mode;       /**< @brief 0:CPUһԶ,1:Զ*/
    ZXIC_UINT32 overflow_mode; /**< @brief 0:ﵽֵһֱֵ,1:ۻ1bitΪ11bitʼΪ1Ϊ*/
}STAT_COUNT_CFG_T;

/** stat smmu1 */
typedef struct dpp_stat_smmu1_cfg_t
{
    ZXIC_UINT32 baddr;         /**<  @brief ַ*/
}DPP_STAT_SMMU1_CFG_T;

/** statģ鹫 */
typedef struct dpp_stat_comm_cfg_t
{
    DPP_STAT_SMMU1_CFG_T stat_smmu1_cfg[DPP_DEV_CHANNEL_MAX];   /**<  @brief stat smmu1*/
    ZXIC_UINT32 is_init[DPP_DEV_CHANNEL_MAX];                        /**<  @brief ʼѡ*/
}DPP_STAT_COMM_CFG_T;

/** statģtmͳ */
typedef struct dpp_stat_tm_cfg_t
{
    ZXIC_UINT32 tm_en;                          /**<  @brief TMͳʹ */
    ZXIC_UINT32 mov_en;                         /**<  @brief ʹ*/
    ZXIC_UINT32 eram_en;                        /**<  @brief Ƭڼʹ*/
    ZXIC_UINT32 ftm_pkt_en;                     /**<  @brief ftmʹ*/
    ZXIC_UINT32 etm_pkt_en;                     /**<  @brief etmʹ*/
    ZXIC_UINT32 ftm_port_type[4];               /**<  @brief ftm˿ѡ ο TM_STAT_TYPE_E */
    ZXIC_UINT32 etm_port_type[4];               /**<  @brief etm˿ѡ ο TM_STAT_TYPE_E */
    ZXIC_UINT32 etm_start_queue_id;             /**<  @brief etmʼк*/
    ZXIC_UINT32 etm_queue_depth_mode;           /**<  @brief etm*/
    DPP_STAT_SMMU1_CFG_T ftm_smmu1_cfg;    /**<  @brief ftmͳƵsmmu1*/
    DPP_STAT_SMMU1_CFG_T etm_smmu1_cfg;    /**<  @brief etmͳƵsmmu1*/
    ZXIC_UINT32 is_init[DPP_DEV_CHANNEL_MAX];   /**<  @brief ʼѡ*/
}DPP_STAT_TM_CFG_T;

/** TM ͳƼϢ */
typedef struct dpp_stat_tm_cnt_t
{
    ZXIC_UINT32 tm_cnt_en;               /**<  @brief tmʹ*/
    ZXIC_UINT32 tm_mode;                 /**<  @brief TMͳģʽ:0-ftm, 1-etm*/
    ZXIC_UINT32 tm_flow_id;              /**<  @brief TMͳ*/
    ZXIC_UINT32 tm_stat_type;            /**<  @brief TMͳƶ˿*/
    ZXIC_UINT32 is_tm_byte_en;           /**<  @brief TMͳֽڼʹ*/
    ZXIC_UINT32 is_eram_en;              /**<  @brief TMͳƬڼʹ*/
    ZXIC_UINT64 tm_cnt;                  /**<  @brief TM*/
}DPP_STAT_TM_CNT_T;

/** STAT ж״̬  */
typedef struct dpp_stat_brief_int_t
{
    ZXIC_UINT32 etcam_int;               /**< @brief etcamģж */
    ZXIC_UINT32 stat_sch_int;            /**< @brief stat schʣಿֵж״̬ */
}DPP_STAT_BRIEF_INT_T;

/** STAT fifoж״̬ѡ  */
typedef struct dpp_stat_sch_intr_t
{
    ZXIC_UINT32 hardware_rsv;            /**< @brief ϵͳû*/
    ZXIC_UINT32 oam0_ord_fifo_int;       /**< @brief oam0ģж*/
    ZXIC_UINT32 oam2_ord_fifo_int;       /**< @brief oam2ģж*/
    ZXIC_UINT32 oam3_ord_fifo_int;       /**< @brief oam3ģж*/
    ZXIC_UINT32 ddr_sch_fifo_int;        /**< @brief ddrж*/
    ZXIC_UINT32 plcr_sch_fifo_int;       /**< @brief plcrж*/
    ZXIC_UINT32 stat_schd_fifo_int;      /**< @brief statģkeyж*/
    ZXIC_UINT32 stat_rschd_fifo_int;     /**< @brief statģrspж*/
}DPP_STAT_SCH_INTR_T;

/*stat */
typedef enum stat_cnt_mode_e
{
    STAT_64_MODE  = 0,         /**<  @brief 64bitλģʽ*/
    STAT_128_MODE = 1,         /**<  @brief 128bitλģʽ*/
    STAT_MAX_MODE,
}STAT_CNT_MODE_E;

/**DPP STATģʽѡ  */
typedef enum stat_rd_clr_mode_e
{
    STAT_RD_CLR_MODE_UNCLR = 0,  /**<  @brief */
    STAT_RD_CLR_MODE_CLR   = 1,  /**<  @brief */
    STAT_RD_CLR_MODE_MAX,
}STAT_RD_CLR_MODE_E;

/* car ȼ */
typedef enum dpp_car_priority_e
{
    DPP_CAR_PRI0 = 0,        /**<  @brief CARȼ0*/
    DPP_CAR_PRI1 = 1,        /**<  @brief CARȼ1*/
    DPP_CAR_PRI2 = 2,        /**<  @brief CARȼ2*/
    DPP_CAR_PRI3 = 3,        /**<  @brief CARȼ3*/
    DPP_CAR_PRI4 = 4,        /**<  @brief CARȼ4*/
    DPP_CAR_PRI5 = 5,        /**<  @brief CARȼ5*/
    DPP_CAR_PRI6 = 6,        /**<  @brief CARȼ6*/
    DPP_CAR_PRI7 = 7,        /**<  @brief CARȼ7*/
    DPP_CAR_PRI_MAX 
}DPP_CAR_PRIORITY_E;

/** car ģõĲ */
typedef struct dpp_stat_car_profile_cfg_t
{
    ZXIC_UINT32 profile_id;                        /**<  @brief carģ*/
    ZXIC_UINT32 pkt_sign;                          /**<  @brief ѡ־*/
    ZXIC_UINT32 cd;                                /**<  @brief CD㷨־/Ͱ㷨־ 0:srtcm 1:trtcm 2:MEF10.1*/
    ZXIC_UINT32 cf;                                /**<  @brief CFϱ־0:1:*/
    ZXIC_UINT32 cm;                                /**<  @brief CMɫä/ɫ־0:ɫäģʽ1:ɫģʽ */
    ZXIC_UINT32 cir;                               /**<  @brief CͰ(0~X, X Gbps/64kbps),СֵΪ64KbpsΪ64Kbps*/
    ZXIC_UINT32 cbs;                               /**<  @brief CͰͰ(XM),÷ΧΪ0~XMByte-1Ϊ1Byte*/
    ZXIC_UINT32 eir;                               /**<  @brief EͰ(0~X, XGbps/64kbps),СֵΪ64KbpsΪ64Kbps*/
    ZXIC_UINT32 ebs;                               /**<  @brief EͰͰ(XM),÷ΧΪ0~XMByte-1Ϊ1Byte*/
    ZXIC_UINT32 random_disc_e;                     /**<  @brief carBcarC֧ */
    ZXIC_UINT32 random_disc_c;                     /**<  @brief carBcarC֧ */
    ZXIC_UINT32 c_pri[DPP_CAR_PRI_MAX];            /**<  @brief pri 1~7Чֵ*/
    ZXIC_UINT32 e_green_pri[DPP_CAR_PRI_MAX];      /**<  @brief pri 1~7Чֵ*/
    ZXIC_UINT32 e_yellow_pri[DPP_CAR_PRI_MAX];
}DPP_STAT_CAR_PROFILE_CFG_T;

/* car ռsmmu0ģʽ */
typedef enum dpp_car_smmu0_mono_mode_e
{
    CAR_SMMU0_MONO_MODE_NONE = 0,             /**<  @brief CARռsmmu0*/
    CAR_SMMU0_MONO_MODE_1    = 1,             /**<  @brief CARռ1Ƭsmmu0*/
    CAR_SMMU0_MONO_MODE_2    = 2,             /**<  @brief CARռ2Ƭsmmu0*/
    CAR_SMMU0_MONO_MODE_MAX
}DPP_CAR_SMMU0_MONO_MODE_E;

/* TMͳƵĶģʽ */
typedef enum stat_tm_clr_mode_e
{
    STAT_TM_CLR_MODE_UNCLR = 0,         /**<  @brief  TMͳƲ*/
    STAT_TM_CLR_MODE_CLR   = 1,           /**<  @brief  TMͳƶ*/
    STAT_TM_CLR_MODE_MAX,
}STAT_TM_CLR_MODE_E;

/** car A õĲ */
typedef struct dpp_stat_car_a_queue_cfg_t
{
    ZXIC_UINT32 flow_id;
    ZXIC_UINT32 drop_flag;
    ZXIC_UINT32 plcr_en;
    ZXIC_UINT32 profile_id;
    ZXIC_UINT64 tq;
    ZXIC_UINT32 ted;
    ZXIC_UINT32 tcd;
    ZXIC_UINT32 tei;
    ZXIC_UINT32 tci;
}DPP_STAT_CAR_A_QUEUE_CFG_T;

#endif

#if ZXIC_REAL("macro function define")

#endif


#if ZXIC_REAL("function declaration")
/***********************************************************/
/** statóʼ
* @param   dev_id   
* @param   p_dpp_stat_comm_cfg   
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/07/14
************************************************************/
DPP_STATUS dpp_stat_comm_init(ZXIC_UINT32 dev_id, DPP_STAT_COMM_CFG_T * p_dpp_stat_comm_cfg);

/***********************************************************/
/** ppuͳ ERAMַ
* @param   dev_id           豸 
* @param   ppu_eram_baddr   ppuͳeRamַ,128bitΪλ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_ppu_eram_baddr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 ppu_eram_baddr);

/***********************************************************/
/** ppuͳƬ
* @param   dev_id           豸
* @param   ppu_eram_depth   ppuͳƬ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_ppu_eram_depth_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 ppu_eram_depth);

/***********************************************************/
/** ppuͳ DDRַ
* @param   dev_id          豸 
* @param   ppu_ddr_baddr   ppuͳDDRַ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_ppu_ddr_baddr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 ppu_ddr_baddr);

/***********************************************************/
/** TMóʼ
* @param   dev_id   
* @param   p_stat_tm_cfg   
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/08/03
************************************************************/
DPP_STATUS dpp_stat_tm_init(ZXIC_UINT32 dev_id, DPP_STAT_TM_CFG_T *p_stat_tm_cfg);

/***********************************************************/
/** Etm ͳ
* @param   dev_id               豸
* @param   etm_port0_type       ͳ0
* @param   etm_port1_type       ͳ1
* @param   etm_port2_type       ͳ2
* @param   etm_port3_type       ͳ3
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_etm_port_type_set(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 etm_port0_type,
                                      ZXIC_UINT32 etm_port1_type,
                                      ZXIC_UINT32 etm_port2_type,
                                      ZXIC_UINT32 etm_port3_type);

/***********************************************************/
/** Ftm ͳ
* @param   dev_id               豸
* @param   ftm_port0_type       ͳ0
* @param   ftm_port1_type       ͳ1
* @param   ftm_port2_type       ͳ2
* @param   ftm_port3_type       ͳ3
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_ftm_port_type_set(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 ftm_port0_type,
                                      ZXIC_UINT32 ftm_port1_type,
                                      ZXIC_UINT32 ftm_port2_type,
                                      ZXIC_UINT32 ftm_port3_type);



/***********************************************************/
/** carӲʼ
* @param   dev_id        豸
* @param   car_type      car
* @param   car_type      carģʽμSTAT_CAR_TYPE_E
* @param   car_mono_mode carռmonoģʽ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/04/27
************************************************************/
DPP_STATUS dpp_stat_car_hardware_init(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 car_type,
                                      ZXIC_UINT32 car_mono_mode);

/***********************************************************/
/** carĲ㼶ģʽ
* @param   dev_id      
* @param   mode   2 - car, һ֧16K
*                 1 - car, һչΪ17K
*                 0 - һcar, һչΪ21K
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/09/28
************************************************************/
DPP_STATUS dpp_stat_car_en_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode);

/***********************************************************/
/** car A ֽټģ趨
* @param   dev_id               豸               car
* @param   profile_id           ģ
* @param   p_cara_profile_cfg   ģ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/04/05
************************************************************/
DPP_STATUS dpp_stat_cara_profile_cfg_set(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 profile_id,
                                         DPP_STAT_CAR_PROFILE_CFG_T* p_cara_profile_cfg);

/***********************************************************/
/** ȡcar A
* @param   dev_id               豸               car
* @param   flow_id              
* @param   p_cara_queue_cfg     car AϢ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/04/05
************************************************************/
DPP_STATUS dpp_stat_cara_queue_cfg_get(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 flow_id,
                                       DPP_STAT_CAR_A_QUEUE_CFG_T* p_cara_queue_cfg);

/***********************************************************/
/** car A
* @param   dev_id           豸           car
* @param   flow_id          
* @param   drop_flag        ־
* @param   plcr_en          ʹ
* @param   profile_id       ģ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/04/05
************************************************************/
DPP_STATUS dpp_stat_cara_queue_cfg_set(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 flow_id,
                                       ZXIC_UINT32 drop_flag,
                                       ZXIC_UINT32 plcr_en,
                                       ZXIC_UINT32 profile_id);

/***********************************************************/
/** statģ鳣úб
* @param   dev_id   
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ˶10181552      @date  2016/02/03
************************************************************/
DPP_STATUS dpp_stat_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** stat ģϵʼ
* @param   dev_id   
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2017/07/20
************************************************************/
DPP_STATUS dpp_stat_module_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ppu statͳƽ
* @param   dev_id           豸
* @param   rd_mode          ȡλģʽμSTAT_CNT_MODE_E0-64bit1-128bit
* @param   index            λμrd_mode
* @param   p_data           Σȡ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  xhj      @date  2018/02/01
************************************************************/
DPP_STATUS dpp_stat_ppu_cnt_set(ZXIC_UINT32 dev_id,
                                STAT_CNT_MODE_E rd_mode,
                                ZXIC_UINT32 index,
                                ZXIC_UINT32 *p_data);

/***********************************************************/
/** Ƭͳƻ
* @param   dev_id           豸
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  zth      @date  2024/05/07
************************************************************/
DPP_STATUS dpp_stat_ppu_cmmu_cache_clear(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ppuֵȡ
* @param   dev_id           豸
* @param   rd_mode          ȡλģʽμSTAT_CNT_MODE_E0-64bit1-128bit
* @param   index            λμrd_mode
* @param   clr_mode         ģʽμSTAT_RD_CLR_MODE_E0-壬1-
* @param   p_data           Σȡ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/07/11
************************************************************/
DPP_STATUS dpp_stat_ppu_cnt_get(ZXIC_UINT32 dev_id,
                                STAT_CNT_MODE_E rd_mode,
                                ZXIC_UINT32 index,
                                ZXIC_UINT32 clr_mode,
                                ZXIC_UINT32 *p_data);

/***********************************************************/
/** ppuֵȡ(ͳòȡ)
* @param   dev_id           豸
* @param   rd_mode          ȡλģʽμSTAT_CNT_MODE_E0-64bit1-128bit
* @param   index            λμrd_mode
* @param   clr_mode         ģʽμSTAT_RD_CLR_MODE_E0-壬1-
* @param   p_data           Σȡ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/07/11
************************************************************/
DPP_STATUS dpp_stat_ppu_cnt_get_ex(ZXIC_UINT32 dev_id,
                                STAT_CNT_MODE_E rd_mode,
                                ZXIC_UINT32 index,
                                ZXIC_UINT32 clr_mode,
                                ZXIC_UINT32 *p_data);

/***********************************************************/
/** TMֵȡ
* @param   dev_id               豸 
* @param   tm_mode              tmģʽ0-ftm1-etm μSTAT_TM_MODE_E
* @param   only_pkt_num_en      ȫģʽʹ
* @param   port_mode            ˿λģʽμSTAT_TM_PORT_MODE_E
* @param   cnt_mode             ģʽ0-Ƭڼ1-ϼ
* @param   clr_mode             ģʽ0-Ƕ壬1-
* @param   index                ֵ
* @param   p_data               
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/07/19
************************************************************/
DPP_STATUS dpp_stat_tm_cnt_get(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 tm_mode,
                               ZXIC_UINT32 only_pkt_num_en,
                               ZXIC_UINT32 port_mode,
                               ZXIC_UINT32 cnt_mode,
                               ZXIC_UINT32 clr_mode,
                               ZXIC_UINT32 index,
                               ZXIC_UINT32 *p_data);

/***********************************************************/
/** CMMUϢppu stat ͳƼôӡ
* @param    dev_id
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark   
* @see
* @author   ˶10181552      @date  2016/01/20
************************************************************/
DPP_STATUS diag_dpp_stat_ppu_cfg_prt(ZXIC_UINT32 dev_id);

#endif
#endif /*dpp_stat_api.h*/



