/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_dtb_cfg.h
* 文件标识 :
* 内容摘要 :
* 其它说明 :
* 当前版本 :
* 作    者 : zab
* 完成日期 : 2022/08/23
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* 修改记录1:
* 修改日期:
* 版 本 号:
* 修 改 人:
* 修改内容:
***************************************************************/
#ifndef _DPP_DTB_CFG_H_
#define _DPP_DTB_CFG_H_

#ifdef __cplusplus
extern "C" {
#endif


#define DPP_DTB_QUEUE_NUM_MAX              (128)
#define DPP_DTB_TRAF_CTRL_RAM_SIZE         (256)
#define DPP_DTB_TRAF_CTRL_RAM_5_SIZE       (64)
#define DPP_DTB_DUMP_PD_RAM_SIZE           (2048)
#define DPP_DTB_RD_CTRL_RAM_SIZE           (4096)
#define DPP_DTB_RD_TABLE_RAM_SIZE          (8192)
#define DPP_DTB_CMD_MAN_RAM_SIZE           (16384)

#define DPP_DTB_TRAF_CTRL_RAM_ITEM_BIT_SIZE    (1024)
#define DPP_DTB_TRAF_CTRL_RAM_5_ITEM_BIT_SIZE  (256)
#define DPP_DTB_DUMP_PD_RAM_ITEM_BIT_SIZE      (128)
#define DPP_DTB_RD_CTRL_RAM_ITEM_BIT_SIZE      (1024)
#define DPP_DTB_RD_TABLE_RAM_ITEM_BIT_SIZE     (128)
#define DPP_DTB_CMD_MAN_RAM_ITEM_BIT_SIZE      (128)

#define DPP_DTB_SMMU1_RAM_ITEM_VALID_BIT_SIZE      (567)
#define DPP_DTB_ZCAM_RAM_ITEM_VALID_BIT_SIZE       (533)
#define DPP_DTB_ETCAM_RAM_ITEM_VALID_BIT_SIZE      (682)
#define DPP_DTB_DUMP_ETCAM_RAM_ITEM_VALID_BIT_SIZE (682)
#define DPP_DTB_HASH_RAM_ITEM_VALID_BIT_SIZE       (567)
#define DPP_DTB_SMMU0_RAM_ITEM_VALID_BIT_SIZE      (256)

#define DPP_DTB_QUEUE_ELEMENT_NUM           (32)
#define DPP_DTB_QUEUE_ACK_SIZE              (16)
#define DPP_DTB_QUEUE_ELEMENT_DATA_SIZE     (16*1024 + DPP_DTB_QUEUE_ACK_SIZE)//16k+16
#define DPP_DTB_QUEUE_DATA_SIZE             (DPP_DTB_QUEUE_ELEMENT_DATA_SIZE *  DPP_DTB_QUEUE_ELEMENT_NUM)
#define DPP_DTB_QUEUE_ELEMENT_DUMP_SIZE     (16*1024 + DPP_DTB_QUEUE_ACK_SIZE)//16K+16
#define DPP_DTB_QUEUE_DUMP_SIZE             (DPP_DTB_QUEUE_ELEMENT_DUMP_SIZE * DPP_DTB_QUEUE_ELEMENT_NUM)
#define DPP_DTB_QUEUE_DMA_SIZE              (DPP_DTB_QUEUE_DATA_SIZE + DPP_DTB_QUEUE_DUMP_SIZE)

typedef enum 
{
    DPP_DDR_FLUSH_REG = 0, /**<  @brief 指定地址清空方式*/
    DPP_DDR_FLUSH_DTB = 1, /**<  @brief dtb逐个清除方式*/
    DPP_DDR_FLUSH_INVALID
}DPP_DDR_FLUSH_MODE_E;

/*vport格式
15 |14 13 12 |     11    |10  9  8|7 6 5 4 3 2 1 0|
rsv| ep_id   |func_active|func_num|    vfunc_num  |
*/
#define VPORT_EPID_BT_START          (12)  /*EPID起始位*/
#define VPORT_EPID_BT_LEN            (3)  /*EPID长度*/
#define VPORT_FUNC_ACTIVE_BT_START   (11)  /*FUNC_ACTIVE起始位*/
#define VPORT_FUNC_ACTIVE_BT_LEN     (1)  /*FUNC_ACTIVE长度*/
#define VPORT_FUNC_NUM_BT_START      (8)  /*FUNC_NUM起始位*/
#define VPORT_FUNC_NUM_BT_LEN        (3)  /*FUNC_NUM长度*/
#define VPORT_VFUNC_NUM_BT_START     (0)  /*FUNC_NUM起始位*/
#define VPORT_VFUNC_NUM_BT_LEN       (8)  /*FUNC_NUM长度*/

#define DPP_EP_NUM (5)

#define DTB_RAM_TRAF_CTRL_DEPTH (8)
#define DTB_RAM_DUMP_PD_DEPTH   (512)
#define DTB_RAM_RD_CTRL_DEPTH   (128)
#define DTB_RAM_RD_TABLE_DEPTH  (2048)
#define DTB_RAM_CMD_MAN_DEPTH   (4096)

#define DPP_DTB_DUMP_16KB_64MODE_NUM        (2048U)

typedef struct dpp_dtb_queue_item_info_t
{
    ZXIC_UINT32 cmd_vld;
    ZXIC_UINT32 cmd_type;
    ZXIC_UINT32 int_en;
    ZXIC_UINT32 data_len;
    ZXIC_UINT32 data_laddr;
    ZXIC_UINT32 data_hddr;
} DPP_DTB_QUEUE_ITEM_INFO_T;

typedef struct dpp_dtb_queue_vm_info_t
{
    ZXIC_UINT32 dbi_en;
    ZXIC_UINT32 queue_en;
    ZXIC_UINT32 epid;
    ZXIC_UINT32 vfunc_num;
    ZXIC_UINT32 vector;
    ZXIC_UINT32 func_num;
    ZXIC_UINT32 vfunc_active;
} DPP_DTB_QUEUE_VM_INFO_T;

#if ZXIC_REAL("DTB_DATA_CONVERT_CFG")
#define DPP_DTB_DATA_CONVERT            (0)
#define DPP_DTB_DATA_NO_CONVERT         (1)

#define DPP_DTB_AXIS_W_CONVERT_MODE_POS (0)
#define DPP_DTB_AXIS_W_CONVERT_MODE_LEN (2)
#define DPP_DTB_AXIS_R_CONVERT_MODE_POS (2)
#define DPP_DTB_AXIS_R_CONVERT_MODE_LEN (2)
/***********************************************************/
/** axis通道数据倒换模式配置
* @param   dev_id           芯片id
* @param   r_convert_mode   通道读数据倒换模式 0：全数据位宽倒换 1：不倒换 2：16bit内倒换  3：32bit内倒换
* @param   w_convert_mode   通道写数据倒换模式 0：全数据位宽倒换 1：不倒换 2：16bit内倒换  3：32bit内倒换
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_axis_convert_mode_set(ZXIC_UINT32 dev_id, 
                                          ZXIC_UINT32 r_convert_mode,
                                          ZXIC_UINT32 w_convert_mode);

/** 获取axis通道数据倒换模式
* @param   dev_id           芯片id
* @param   p_r_convert_mode   通道读数据倒换模式指针
* @param   p_w_convert_mode   通道写数据倒换模式指针
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_axis_convert_mode_get(ZXIC_UINT32 dev_id, 
                                          ZXIC_UINT32 *p_r_convert_mode,
                                          ZXIC_UINT32 *p_w_convert_mode);

/** axim通道0写数据倒换模式配置
* @param   dev_id           芯片id
* @param   w_convert_mode   通道写数据倒换模式 0：全数据位宽倒换 1：不倒换 
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_aximle_lite0_w_convert_mode_set(ZXIC_UINT32 dev_id, 
                                          ZXIC_UINT32 w_convert_mode);

/***********************************************************/
/** axim通道1-0写数据倒换模式配置
* @param   dev_id           芯片id
* @param   w_convert_mode   通道写数据倒换模式 0：全数据位宽倒换 1：不倒换 
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/03/29
************************************************************/
ZXIC_UINT32 dpp_dtb_aximle_lite1_w_convert0_mode_set(ZXIC_UINT32 dev_id, 
                                          ZXIC_UINT32 w_convert_mode);

/***********************************************************/
/** axim通道1-1写数据倒换模式配置
* @param   dev_id           芯片id
* @param   w_convert_mode   通道写数据倒换模式 0：全数据位宽倒换 1：不倒换 
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/03/29
************************************************************/
ZXIC_UINT32 dpp_dtb_aximle_lite1_w_convert1_mode_set(ZXIC_UINT32 dev_id, 
                                          ZXIC_UINT32 w_convert_mode);

/***********************************************************/
/** axim通道1-2写数据倒换模式配置
* @param   dev_id           芯片id
* @param   w_convert_mode   通道写数据倒换模式 0：全数据位宽倒换 1：不倒换 
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/03/29
************************************************************/
ZXIC_UINT32 dpp_dtb_aximle_lite1_w_convert2_mode_set(ZXIC_UINT32 dev_id, 
                                          ZXIC_UINT32 w_convert_mode);                                          

/** 获取axim通道写数据倒换模式
* @param   dev_id           芯片id
* @param   p_w_convert_mode   通道写数据倒换模式指针
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_aximle_lite0_w_convert_mode_get(ZXIC_UINT32 dev_id, 
                                                    ZXIC_UINT32 *p_w_convert_mode);

/***********************************************************/
/** 获取axim lite1 - 0通道写数据倒换模式
* @param   dev_id           芯片id
* @param   p_w_convert_mode   通道写数据倒换模式指针
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/07/7
************************************************************/
ZXIC_UINT32 dpp_dtb_aximle_lite1_w_convert0_mode_get(ZXIC_UINT32 dev_id, 
                                                     ZXIC_UINT32 *p_w_convert_mode);

/***********************************************************/
/** 获取axim lite1 - 1通道写数据倒换模式
* @param   dev_id           芯片id
* @param   p_w_convert_mode   通道写数据倒换模式指针
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/07/7
************************************************************/
ZXIC_UINT32 dpp_dtb_aximle_lite1_w_convert1_mode_get(ZXIC_UINT32 dev_id, 
                                                     ZXIC_UINT32 *p_w_convert_mode);

/***********************************************************/
/** 获取axim lite1 - 2通道写数据倒换模式
* @param   dev_id           芯片id
* @param   p_w_convert_mode   通道写数据倒换模式指针
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/07/7
************************************************************/
ZXIC_UINT32 dpp_dtb_aximle_lite1_w_convert2_mode_get(ZXIC_UINT32 dev_id, 
                                                     ZXIC_UINT32 *p_w_convert_mode);
/** axim通道读数据倒换模式配置
* @param   dev_id           芯片id
* @param   r_convert_mode   通道读数据倒换模式 0：全数据位宽倒换 1：不倒换 
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_aximle_lite0_r_convert_mode_set(ZXIC_UINT32 dev_id, 
                                          ZXIC_UINT32 r_convert_mode);


/** 获取axim通道读数据倒换模式
* @param   dev_id           芯片id
* @param   p_r_convert_mode   通道读数据倒换模式指针
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_aximle_lite0_r_convert_mode_get(ZXIC_UINT32 dev_id, 
                                                   ZXIC_UINT32 *p_r_convert_mode);


/***********************************************************/
/** axis/axim通道数据倒换模式配置为不翻转
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-128 
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/03/29
************************************************************/
ZXIC_UINT32 dpp_dtb_axis_axim_set_to_no_convert(ZXIC_UINT32 dev_id);
#endif
#if ZXIC_REAL("DTB_CFG")
/***********************************************************/
/** 软件ep号转换成硬件ep号
* @param   dev_id        芯片id
* @param   ep_no         EP ID
* @param   pf_no         PF ID
* @param   vf_no         VF IF
* @param   vf_active     VF 有效 
* @param   p_vport       vport指针
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/12/21
************************************************************/
ZXIC_UINT32 dpp_dtb_hw_ep_id_get(ZXIC_UINT32 soft_ep_id);

/***********************************************************/
/** 根据ep_id 得到 vport
* @param   dev_id        芯片id
* @param   ep_no         EP ID
* @param   pf_no         PF ID
* @param   vf_no         VF IF
* @param   vf_active     VF 有效 
* @param   p_vport       vport指针
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/12/21
************************************************************/
ZXIC_UINT32 dpp_dtb_ep_fun_to_vport(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 ep_no,
                                    ZXIC_UINT32 pf_no,
                                    ZXIC_UINT32 vf_no,
                                    ZXIC_UINT32 vf_active,
                                    ZXIC_UINT32 *p_vport);

/***********************************************************/
/** 根据ep,pf,vf 得到 vport
* @param   dev_id        芯片id
* @param   vport         vport信息
* @param   p_ep_no       EP ID
* @param   p_pf_no       PF ID
* @param   p_vf_no       VF IF
* @param   p_vf_active   VF 有效 
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/12/21
************************************************************/
ZXIC_UINT32 dpp_dtb_vport_to_ep_fun(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT16 vport,
                                    ZXIC_UINT32 *p_ep_no,
                                    ZXIC_UINT32 *p_pf_no,
                                    ZXIC_UINT32 *p_vf_no,
                                    ZXIC_UINT32 *p_vf_active);
                                    
/***********************************************************/
/** DTB队列元素信息配置
* @param   dev_id           芯片id
* @param   queue_id         队列ID，范围0-127
* @param   p_item_info      队列元素配置信息
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_item_info_set(ZXIC_UINT32 dev_id, 
                        ZXIC_UINT32 queue_id,
                        DPP_DTB_QUEUE_ITEM_INFO_T *p_item_info);

/***********************************************************/
/** DTB队列元素信息配置
* @param   dev_id           芯片id
* @param   queue_id         队列ID，范围0-127
* @param   p_item_info      队列元素配置信息
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_item_info_get(ZXIC_UINT32 dev_id, 
                        ZXIC_UINT32 queue_id,
                        DPP_DTB_QUEUE_ITEM_INFO_T *p_item_info);

/***********************************************************/
/** 获取DTB队列中剩余未使用的条目数量
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   p_item_num           剩余未使用条目数量
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_unused_item_num_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 queue_id,
                        ZXIC_UINT32 *p_item_num);

/***********************************************************/
/** 配置队列VM相关信息
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   p_vm_info            VM配置信息
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_vm_info_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 queue_id,
                        DPP_DTB_QUEUE_VM_INFO_T *p_vm_info);

/***********************************************************/
/** 获取队列VM配置信息
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   p_vm_info            VM配置信息
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_vm_info_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 queue_id,
                        DPP_DTB_QUEUE_VM_INFO_T *p_vm_info);

/***********************************************************/
/** 配置队列host中断模式
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   mode                 1:dbi中断,0:match中断
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/07/11
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_host_interrupt_mode_set(ZXIC_UINT32 dev_id,
                                                  ZXIC_UINT32 queue_id,
                                                  ZXIC_UINT32 mode);

/***********************************************************/
/** 配置队列使能
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   enable               1:队列使能,0:队列去使能
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/09/27
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_enable_set(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 queue_id,
                                     ZXIC_UINT32 enable);

/***********************************************************/
/** 获取队列使能状态
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   enable               1:队列使能,0:队列去使能
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/09/27
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_enable_get(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 queue_id,
                                     ZXIC_UINT32 *enable);

/***********************************************************/
/** 配置队列中断号
* @param   dev_id               оƬid
* @param   queue_id             队列ID，范围0-127
* @param   enable               1:队列使能,0:队列去使能
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/09/27
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_vector_set(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 queue_id,
                                     ZXIC_UINT32 new_vector);

/***********************************************************/
/** 获取队列中断号
* @param   dev_id               оƬid
* @param   queue_id             队列ID，范围0-127
* @param   enable               1:队列使能,0:队列去使能
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/09/27
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_vector_get(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 queue_id,
                                     ZXIC_UINT32 *p_vector);

/***********************************************************/
/** 队列ep信息清空
* @param   dev_id               о?id
* @param   queue_id             队列ID，范围0-127
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2024/02/27
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_vm_info_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 queue_id);

/***********************************************************/
/** 配置写ram间隔计数器
* @param   dev_id               芯片id
* @param   ram_type             ram类型
*                               0-eram,1-zcam,2-tcam,
*                               3-ddr,4-hash
* @param   wr_interval          间隔计数
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_ram_wr_interval_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 ram_type,
                        ZXIC_UINT32 wr_interval);

/***********************************************************/
/** 获取写ram间隔计数器
* @param   dev_id               芯片id
* @param   ram_type             ram类型
*                               0-eram,1-zcam,2-tcam,
*                               3-ddr,4-hash
* @param   p_wr_interval        间隔计数
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_ram_wr_interval_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 ram_type,
                        ZXIC_UINT32 *p_wr_interval);

/***********************************************************/
/** 配置读ram间隔计数器
* @param   dev_id               芯片id
*                               0-eram,1-zcam,2-tcam,
*                               3-ddr
* @param   wr_interval          间隔计数
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_ram_rd_interval_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 ram_type,
                        ZXIC_UINT32 rd_interval);

/***********************************************************/
/** 获取读ram间隔计数器
* @param   dev_id               芯片id
*                               0-eram,1-zcam,2-tcam,
*                               3-ddr
* @param   p_rd_interval        间隔计数
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_ram_rd_interval_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 ram_type,
                        ZXIC_UINT32 *p_rd_interval);

/***********************************************************/
/** dtb下表速率配置，不区分表类型 10->100Mpps;100->1Mpps
* @param   dev_id          芯片id
* @param   interval        间隔
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/12/25
************************************************************/
ZXIC_UINT32 dpp_dtb_talbe_write_interval_set_all(ZXIC_UINT32 dev_id, ZXIC_UINT32 interval);

/***********************************************************/
/** dtb读表速率配置，不区分表类型 10->100Mpps;100->1Mpps
* @param   dev_id          芯片id
* @param   interval        间隔
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/12/25
************************************************************/
ZXIC_UINT32 dpp_dtb_talbe_read_interval_set_all(ZXIC_UINT32 dev_id, ZXIC_UINT32 interval);

/***********************************************************/
/** dtb下表和dump表速率默认配置为100Mpps，不区分表类型
* @param   dev_id          芯片id
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2023/12/25
************************************************************/
ZXIC_UINT32 dpp_dtb_talbe_interval_default_set(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 配置队列锁状态
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   state                锁状态，0-未锁，1-锁
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_lock_state_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 queue_id,
                        ZXIC_UINT32 state);

/***********************************************************/
/** 配置队列锁状态清空
* @param   dev_id               芯片id
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_lock_state_clr(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 获取队列锁状态
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   p_state              锁状态，0-未锁，1-锁
*
* @return
* @remark  无
* @see
* @author  zab      @date  2018/08/23
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_lock_state_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 queue_id,
                        ZXIC_UINT32 *p_state);
#endif

#if ZXIC_REAL("DTB_INT_CFG")
/***********************************************************/
/** 配置 dtb 完成中断事件状态
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   state                中断事件状态，1-发生中断，0-无中断发生
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2022/11/12
************************************************************/
ZXIC_UINT32 dpp_dtb_finish_interrupt_event_state_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 queue_id,
                        ZXIC_UINT32 state);

/***********************************************************/
/** 获取 dtb 完成中断事件状态
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   p_state                中断事件状态，1-发生中断，0-无中断发生
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2022/11/12
************************************************************/
ZXIC_UINT32 dpp_dtb_finish_interrupt_event_state_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 queue_id,
                        ZXIC_UINT32 *p_state);

/***********************************************************/
/** 清除 dtb 完成中断事件状态
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2022/11/12
************************************************************/
ZXIC_UINT32 dpp_dtb_finish_interrupt_event_state_clr(ZXIC_UINT32 dev_id,
                                                    ZXIC_UINT32 queue_id);

/***********************************************************/
/** 配置 dtb 队列中断使能状态
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   state                中断使能状态，1-使能中断，0-中断去使能
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2022/11/12
************************************************************/
ZXIC_UINT32 dpp_dtb_finish_interrupt_mask_state_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 queue_id,
                        ZXIC_UINT32 state);

/***********************************************************/
/** 获取 dtb 队列中断使能状态
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   p_state                中断使能状态，1-使能中断，0-中断去使能
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2022/11/12
************************************************************/
ZXIC_UINT32 dpp_dtb_finish_interrupt_mask_state_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 queue_id,
                        ZXIC_UINT32 *p_state);

/***********************************************************/
/** 配置 dtb 队列中断测试状态
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   state                中断使能状态，1-使能中断，0-中断去使能
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2022/11/12
************************************************************/
ZXIC_UINT32 dpp_dtb_finish_interrupt_test_state_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 queue_id,
                        ZXIC_UINT32 state);

/***********************************************************/
/** 获取 dtb 队列中断测试状态
* @param   dev_id               芯片id
* @param   queue_id             队列ID，范围0-127
* @param   p_state                中断使能状态，1-使能中断，0-中断去使能
*
* @return
* @remark  无
* @see
* @author  cbb      @date  2022/11/12
************************************************************/
ZXIC_UINT32 dpp_dtb_finish_interrupt_test_state_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 queue_id,
                        ZXIC_UINT32 *p_state);

/***********************************************************/
/** 一个队列成功中断状态检查
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-31 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_success_interrupt_status_check(ZXIC_UINT32 dev_id,
                                                       ZXIC_UINT32 queue_id);

/**流控ram0数据配置
* @param   dev_id       设备号，支持多芯片
* @param   offset       配置数据的偏移0-255    
* @param   ram_data     配置ram的数据  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_0_data_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 ram_data);

/***********************************************************/
/**流控ram0数据获取
* @param   dev_id       设备号，支持多芯片
* @param   offset       获取数据的偏移0-255    
* @param   p_ram_value  获取数据的指针  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_0_data_get(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *p_ram_value);



/***********************************************************/
/**流控ram1数据配置
* @param   dev_id       设备号，支持多芯片
* @param   offset       配置数据的偏移0-255    
* @param   ram_data     配置ram的数据  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_1_data_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 ram_data);


/***********************************************************/
/**流控ram1数据获取
* @param   dev_id       设备号，支持多芯片
* @param   offset       获取数据的偏移0-255  
* @param   p_ram_value  获取数据的指针    
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_1_data_get(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *p_ram_value);

/***********************************************************/
/**流控ram2数据配置
* @param   dev_id       设备号，支持多芯片
* @param   offset       配置数据的偏移0-255    
* @param   ram_data     配置ram的数据  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_2_data_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 ram_data);

/***********************************************************/
/**流控ram2数据获取
* @param   dev_id       设备号，支持多芯片
* @param   offset       获取数据的偏移0-255    
* @param   p_ram_value  获取数据的指针  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_2_data_get(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *p_ram_value);

/***********************************************************/
/**流控ram3数据配置
* @param   dev_id       设备号，支持多芯片
* @param   offset       配置数据的偏移0-255    
* @param   ram_data     配置ram的数据  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_3_data_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 ram_data);

/***********************************************************/
/**流控ram3数据获取
* @param   dev_id       设备号，支持多芯片
* @param   offset       获取数据的偏移0-255   
* @param   p_ram_value  获取数据的指针   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_3_data_get(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *p_ram_value);

/***********************************************************/
/**流控ram4数据配置
* @param   dev_id       设备号，支持多芯片
* @param   offset       配置数据的偏移0-255    
* @param   ram_data     配置ram的数据  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_4_data_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 ram_data);

/***********************************************************/
/**流控ram4数据获取
* @param   dev_id       设备号，支持多芯片
* @param   offset       获取数据的偏移0-255   
* @param   p_ram_value  获取数据的指针   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_4_data_get(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *p_ram_value);

/***********************************************************/
/**流控ram5数据配置
* @param   dev_id       设备号，支持多芯片
* @param   offset       配置数据的偏移0-63   
* @param   ram_data     配置ram的数据  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_5_data_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 ram_data);

/***********************************************************/
/**流控ram5数据获取
* @param   dev_id       设备号，支持多芯片
* @param   offset       获取数据的偏移0-63   
* @param   p_ram_value  获取数据的指针  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_5_data_get(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *p_ram_value);

/***********************************************************/
/** 按深度 写traf_ctrl_ram 内容 
* @param   dev_id             设备号，支持多芯片
* @param   traf_ctrl_ram_num  ram编号 0-5 0:smmu1;1:zcam;2:etcam;3:etcam dump;4:hash;5:smmu0
* @param   offset             偏移 128bit为单位
* @param   depth              深度
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2024/03/5
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_ram_data_block_write(ZXIC_UINT32 dev_id,
                                                   ZXIC_UINT32 traf_ctrl_ram_num,
                                                   ZXIC_UINT32 offset,
                                                   ZXIC_UINT32 depth,
                                                   ZXIC_UINT32 *wr_ram_data);

/***********************************************************/
/**dump pd ram数据配置
* @param   dev_id       设备号，支持多芯片
* @param   offset       配置数据的偏移0-2047  
* @param   ram_data     配置ram的数据  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_dump_pd_ram_data_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 ram_data);

/***********************************************************/
/**写dtb traf ctrl ram 中的smmu1中的数据，
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_smmu1_ram_data_1024bit_wr(ZXIC_UINT32 dev_id,
                                                        ZXIC_UINT32 index,
                                                        ZXIC_UINT32 *wr_data);

/***********************************************************/
/** 打印dtb traf ctrl ram 中的smmu1中的数据，
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_smmu1_ram_data_1024bit_rd(ZXIC_UINT32 dev_id,
                                                          ZXIC_UINT32 index,
                                                          ZXIC_UINT32 *rd_data);

/***********************************************************/
/**写dtb traf ctrl ram 中的zcam中的数据，在1024bit中只有前533bit数据有效
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
* @param   wr_data  要写入的1024bit数据，硬件只取前533bit数据
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_zcam_ram_data_1024bit_wr(ZXIC_UINT32 dev_id,
                                                       ZXIC_UINT32 index,
                                                       ZXIC_UINT32 *wr_data);

/***********************************************************/
/** 读取dtb traf ctrl ram 中的zcam中的数据，在1024bit中只有前533bit数据有效
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
* @param   rd_data  保存读出的1024bit数据，硬件只读取前533bit数据
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_zcam_ram_data_1024bit_rd(ZXIC_UINT32 dev_id,
                                                       ZXIC_UINT32 index,
                                                       ZXIC_UINT32 *rd_data);                                                      

/***********************************************************/
/**写dtb traf ctrl ram 中的etcam中的数据，在1024bit中只有前682bit数据有效
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
* @param   wr_data  要写入的1024bit数据，硬件只取前682bit数据
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_etcam_ram_data_1024bit_wr(ZXIC_UINT32 dev_id,
                                                       ZXIC_UINT32 index,
                                                       ZXIC_UINT32 *wr_data);

/***********************************************************/
/** 读取dtb traf ctrl ram 中的etcam中的数据，在1024bit中只有前682bit数据有效
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
* @param   rd_data  保存读出的1024bit数据，硬件只读取前682bit数据
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_etcam_ram_data_1024bit_rd(ZXIC_UINT32 dev_id,
                                                       ZXIC_UINT32 index,
                                                       ZXIC_UINT32 *rd_data);                                       

/***********************************************************/
/**写dtb traf ctrl ram 中的etcam dump中的数据，在1024bit中只有前682bit数据有效
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
* @param   wr_data  要写入的1024bit数据，硬件只取前682bit数据
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_etcam_dump_ram_data_1024bit_wr(ZXIC_UINT32 dev_id,
                                                             ZXIC_UINT32 index,
                                                             ZXIC_UINT32 *wr_data);

/***********************************************************/
/** 读取dtb traf ctrl ram 中的etcam dump中的数据，在1024bit中只有前682bit数据有效
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
* @param   rd_data  保存读出的1024bit数据，硬件只读取前682bit数据
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_etcam_dump_ram_data_1024bit_rd(ZXIC_UINT32 dev_id,
                                                             ZXIC_UINT32 index,
                                                             ZXIC_UINT32 *rd_data);

/***********************************************************/
/**写dtb traf ctrl ram 中的hash中的数据，在1024bit中只有前567bit数据有效
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
* @param   wr_data  要写入的1024bit数据，硬件只取前567bit数据
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_hash_ram_data_1024bit_wr(ZXIC_UINT32 dev_id,
                                                       ZXIC_UINT32 index,
                                                       ZXIC_UINT32 *wr_data);

/***********************************************************/
/** 读取dtb traf ctrl ram 中的hash中的数据，在1024bit中只有前567bit数据有效
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
* @param   rd_data  保存读出的1024bit数据，硬件只读取前567bit数据
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_hash_ram_data_1024bit_rd(ZXIC_UINT32 dev_id,
                                                       ZXIC_UINT32 index,
                                                       ZXIC_UINT32 *rd_data);

/***********************************************************/
/**写dtb traf ctrl ram 中的smmu0中的数据，
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
* @param   wr_data  要写入的256bit数据
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_smmu0_ram_data_256bit_wr(ZXIC_UINT32 dev_id,
                                                       ZXIC_UINT32 index,
                                                       ZXIC_UINT32 *wr_data);

/***********************************************************/
/** 读取dtb traf ctrl ram 中的smmu0中的数据
* @param   dev_id   设备号，支持多芯片
* @param   index    1024bit为单位的偏移 0-7
* @param   rd_data  保存读出的256bit数据
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 dpp_dtb_traf_ctrl_smmu0_ram_data_256bit_rd(ZXIC_UINT32 dev_id,
                                                       ZXIC_UINT32 index,
                                                       ZXIC_UINT32 *rd_data);                                                                                                             

/***********************************************************/
/** 以128bit为单位写dump pd ram 内容 
* @param   dev_id             设备号，支持多芯片
* @param   offset             偏移 128bit为单位 0 - 511
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_dump_pd_ram_data_block_wr(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *wr_ram_data);

/***********************************************************/
/**读取dump pd ram 数据
* @param   dev_id       设备号，支持多芯片
* @param   offset       获取数据的偏移0-2047
* @param   p_ram_value  获取数据的指针     
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_dump_pd_ram_data_get(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *p_ram_value);

/***********************************************************/
/** 以128bit为单位读取dump pd ram 内容 
* @param   dev_id             设备号，支持多芯片
* @param   offset             偏移 128bit为单位 0 - 511
* @param   rd_ram_data        读出的ram数据，128bit
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_dump_pd_ram_data_block_rd(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *rd_ram_data);

/***********************************************************/
/**rd ctrl ram数据配置
* @param   dev_id       设备号，支持多芯片
* @param   offset       配置数据的偏移0-4095
* @param   ram_data     配置ram的数据  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_rd_ctrl_ram_data_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 ram_data);

/***********************************************************/
/** 以1024bit为单位写dump pd ram 内容 
* @param   dev_id             设备号，支持多芯片
* @param   offset             偏移 1024bit为单位 0 - 127
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_rd_ctrl_ram_data_block_wr(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *wr_ram_data);

/***********************************************************/
/**读取rd ctrl ram 数据
* @param   dev_id       设备号，支持多芯片
* @param   offset       获取数据的偏移0-4095
* @param   p_ram_value  获取数据的指针     
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_rd_ctrl_ram_data_get(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *p_ram_value);

/***********************************************************/
/** 以1024bit为单位读rd ctrl ram 内容 
* @param   dev_id             设备号，支持多芯片
* @param   offset             偏移 1024bit为单位 0 - 127
* @param   rd_ram_data        读出ram数据，1024bit
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_rd_ctrl_ram_data_block_rd(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *rd_ram_data);

/***********************************************************/
/**rd table ram数据配置
* @param   dev_id       设备号，支持多芯片
* @param   offset       配置数据的偏移0-8191
* @param   ram_data     配置ram的数据  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_rd_table_ram_data_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 ram_data);

/***********************************************************/
/** 以128bit为单位写rd table ram 内容 
* @param   dev_id             设备号，支持多芯片
* @param   offset             偏移 128bit为单位 0 - 2047
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_rd_table_ram_data_block_wr(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *wr_ram_data);

/***********************************************************/
/**读取rd table ram 数据
* @param   dev_id       设备号，支持多芯片
* @param   offset       获取数据的偏移0-8191
* @param   p_ram_value  获取数据的指针     
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_rd_table_ram_data_get(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *p_ram_value);


/***********************************************************/
/**cmd man ram数据配置
* @param   dev_id       设备号，支持多芯片
* @param   offset       配置数据的偏移0-16383
* @param   ram_data     配置ram的数据  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_cmd_man_ram_data_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 ram_data);

/***********************************************************/
/** 以128bit为单位写cmd man ram 内容 
* @param   dev_id             设备号，支持多芯片
* @param   offset             偏移 128bit为单位 0 - 4095
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_cmd_man_ram_data_block_wr(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *wr_ram_data);
                                             
/***********************************************************/
/**读取cmd man ram 数据
* @param   dev_id       设备号，支持多芯片
* @param   offset       获取数据的偏移0-16383
* @param   p_ram_value  获取数据的指针     
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dtb_cmd_man_ram_data_get(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *p_ram_value);

/***********************************************************/
/** 以128bit为单位读取cmd man ram 内容 
* @param   dev_id             设备号，支持多芯片
* @param   offset             偏移 128bit为单位 0 - 4095
* @param   wr_ram_data        读出的ram数据，128bit，前96bit有效
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_cmd_man_ram_data_block_rd(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *rd_ram_data);
#endif

#if ZXIC_REAL("DTB_DMA")
#if ZXIC_REAL("CH_ENABLE")
/***********************************************************/
/** DMA使能总开关配置
* @param   dev_id       设备号，支持多芯片
* @param   en           使能标志，1-使能, 0-失能      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dma_en_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 en);

/***********************************************************/
/** DMA使能总开关状态获取
* @param   dev_id       设备号，支持多芯片
* @param   p_en         使能标志，1-使能, 0-失能      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dma_en_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 *p_en);

/***********************************************************/
/** MAC通道使能配置
* @param   dev_id       设备号，支持多芯片
* @param   en           使能标志，1-使能, 0-失能      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dma_mac_en_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 en);

/***********************************************************/
/** MAC通道使能获取
* @param   dev_id       设备号，支持多芯片
* @param   p_en         使能标志，1-使能, 0-失能      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/20
************************************************************/
ZXIC_UINT32 dpp_dma_mac_en_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 *p_en);
#endif

#if ZXIC_REAL("BD_ADDR")
/***********************************************************/
/** 配置BD通道的起止地址
* @param   dev_id           设备号，支持多芯片
* @param   start_haddr      起始地址高32bit
* @param   start_laddr      起始地址低32bit
* @param   end_haddr        结束地址高32bit
* @param   end_laddr        结束地址低32bit
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_mac_bd_addr_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 start_haddr,
                        ZXIC_UINT32 start_laddr,
                        ZXIC_UINT32 end_haddr,
                        ZXIC_UINT32 end_laddr);

/***********************************************************/
/** 获取BD通道的起止地址
* @param   dev_id           设备号，支持多芯片
* @param   p_start_haddr    起始地址高32bit
* @param   p_start_laddr    起始地址低32bit
* @param   p_end_haddr      结束地址高32bit
* @param   p_end_laddr      结束地址低32bit
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_mac_bd_addr_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 *p_start_haddr,
                        ZXIC_UINT32 *p_start_laddr,
                        ZXIC_UINT32 *p_end_haddr,
                        ZXIC_UINT32 *p_end_laddr);

/***********************************************************/
/** 设置BD初始化标志
* @param   dev_id       设备号，支持多芯片
* @param   init_flag    使能标志，1-初始化完成, 0-初始化未完成      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_mac_bd_addr_init_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 init_flag);

/***********************************************************/
/** 获取BD初始化标志
* @param   dev_id       设备号，支持多芯片
* @param   init_flag    使能标志，1-初始化完成, 0-初始化未完成      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_mac_bd_addr_init_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 *p_init_flag);

/***********************************************************/
/** cpu完成bd条目读取后，告知硬件软件完成一个bd调试释放
* @param   dev_id       设备号，支持多芯片 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/

ZXIC_UINT32 dpp_dma_mac_bd_done_set(ZXIC_UINT32 dev_id);
#endif

#if ZXIC_REAL("CH_CFG")
/***********************************************************/
/** 通道传输触发时间配置
* @param   dev_id       设备号，支持多芯片
* @param   time         触发时间，单位sys_clk_period      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_mac_up_time_thresh_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 time);

/***********************************************************/
/** 通道传输触发时间获取
* @param   dev_id       设备号，支持多芯片
* @param   ch_type      通道类型，见SSP4_DMA_CH_TYPE_E结构体
* @param   p_time       触发时间，单位sys_clk_period      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_mac_up_time_thresh_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 *p_time);

/***********************************************************/
/** 通道传输触发数量配置
* @param   dev_id       设备号，支持多芯片
* @param   num          触发数量，单位相应通道位宽      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_mac_up_num_thresh_set(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 num);

/***********************************************************/
/** 通道传输触发数量获取
* @param   dev_id       设备号，支持多芯片
* @param   num          触发数量，单位      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_mac_up_num_thresh_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 *p_num);

/***********************************************************/
/** 配置DMA上送数据倒序功能
* @param   device_id    设备号，支持多芯片
* @param   mode         上送字节序,范围及含义如下;
*                       00:保持原字节序，小端
*                       01:部分调整字节序
*                       10/11:调整字节序，大端
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/2/26
************************************************************/
ZXIC_UINT32 dpp_dma_mac_ch_endian_set(ZXIC_UINT32 dev_id, 
                    ZXIC_UINT32 mode);

/***********************************************************/
/** 获取DMA上送数据倒序功能
* @param   device_id    设备号，支持多芯片
* @param   p_mode       上送字节序,范围及含义如下;
*                       00:保持原字节序，小端
*                       01:部分调整字节序
*                       10/11:调整字节序，大端
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/2/26
************************************************************/
ZXIC_UINT32 dpp_dma_mac_ch_endian_get(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 *p_mode);

/***********************************************************/
/** 配置一个bd buff支持的MAC上送数目上限
* @param   dev_id   设备号，支持多芯片
* @param   max_num   一个bd buff支持多少个512bits hash条目
*
* @return
* @remark  无
* @see
* @author  cbb     @date  2015/04/07
************************************************************/
ZXIC_UINT32 dpp_dma_mac_up_max_num_set(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 max_num);

/***********************************************************/
/** 读取一个bd buff中支持的MAC上送数目上限
* @param   dev_id   设备号，支持多芯片
* @param   p_max_num   一个bd buff支持多少个512bits hash条目
*
* @return
* @remark  无
* @see
* @author  cbb     @date  2015/04/07
************************************************************/
ZXIC_UINT32 dpp_dma_mac_up_max_num_get(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 *p_max_num);

/***********************************************************/
/** 设置CPU的BD个数门限，如果MAC学习超过该阈值将对mac学习产生反压
* @param   dev_id   芯片id
* @param   threshold   一般设置为bd表数目80%~85%为佳
*
* @return
* @remark  无
* @see
* @author  石金锋      @date  2015/04/03
************************************************************/
ZXIC_UINT32 dpp_dma_bd_up_threshold_set(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 threshold);

/***********************************************************/
/** 获取CPU的BD个数门限，
* @param   dev_id   芯片id
* @param   p_threshold   阈值
*
* @return
* @remark  无
* @see
* @author  石金锋      @date  2015/04/03
************************************************************/
ZXIC_UINT32 dpp_dma_bd_up_threshold_get(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 *p_threshold);

/***********************************************************/
/** dma 读检测AXI ID使能
* @param   dev_id            设备号，支持多芯片
* @param   slv_rid_err_en    读检测AXI ID使能   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_slv_rid_err_en_set(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 slv_rid_err_en);

/***********************************************************/
/** 读取 dma 读检测AXI ID使能状态
* @param   dev_id            设备号，支持多芯片
* @param   p_slv_rid_err_en   读检测AXI ID使能状态指针   
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/04/23
************************************************************/
ZXIC_UINT32 dpp_dma_slv_rid_err_en_get(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 *p_slv_rid_err_en);    

/***********************************************************/
/** dma 读检测AXI response 使能
* @param   dev_id            设备号，支持多芯片
* @param   slv_rresp_err_en    读检测AXI ID使能   
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/04/23
************************************************************/
ZXIC_UINT32 dpp_dma_slv_rresp_err_en_set(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 slv_rresp_err_en);

/***********************************************************/
/** 读取 dma 读检测AXI ID使能状态
* @param   dev_id              设备号，支持多芯片
* @param   p_slv_rresp_err_en  检测AXI ID使能指针   
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/04/23
************************************************************/
ZXIC_UINT32 dpp_dma_slv_rresp_err_en_get(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 *p_slv_rresp_err_en);

/***********************************************************/
/** DMA读检测BD字段ERR使能
* @param   dev_id            设备号，支持多芯片
* @param   dma_bd_dat_err_en    dma读检测BD字段ERR使能  
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/04/23
************************************************************/
ZXIC_UINT32 dpp_dma_bd_dat_err_en_set(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 dma_bd_dat_err_en);


/***********************************************************/
/** 获取DMA读检测BD字段ERR使能
* @param   dev_id            设备号，支持多芯片
* @param   p_dma_bd_dat_err_en    dma读检测BD字段ERR使能  
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/04/23
************************************************************/
ZXIC_UINT32 dpp_dma_bd_dat_err_en_get(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 *p_dma_bd_dat_err_en);
#endif

#if ZXIC_REAL("DEBUG_INFO")
/***********************************************************/
/** 获取BD通道当前BD地址
* @param   dev_id       设备号，支持多芯片
* @param   p_haddr      当前地址高32bit
* @param   p_laddr      当前地址低32bit     
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_mac_bd_current_addr_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 *p_haddr,
                        ZXIC_UINT32 *p_laddr);

/***********************************************************/
/** 通道传输报文计数获取
* @param   dev_id       设备号，支持多芯片
* @param   p_cnt        计数值      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_mac_bd_cnt_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 *p_cnt);

/***********************************************************/
/** 当前待上送的mac数目
* @param   dev_id       设备号，支持多芯片
* @param   p_cnt        计数值      
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_mac_bd_ff_usedw_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 *p_cnt);

/***********************************************************/
/** dma bd条目已使用数目获取
* @param   dev_id       设备号，支持多芯片
* @param   p_dma_bd_used      芯片看到的CPU没有释放的BD个数   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_bd_used_cnt_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 *p_dma_bd_used);

/***********************************************************/
/** dma bd控制状态机
* @param   dev_id       设备号，支持多芯片
* @param   p_dma_bd_used      芯片看到的CPU没有释放的BD个数   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/22
************************************************************/
ZXIC_UINT32 dpp_dma_bd_ctl_state_get(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 *p_bd_ctl_state);
#endif
/***********************************************************/
/** 端口outstanding深度配置
* @param   dev_id           设备号，支持多芯片  
* @param   aximr_os         端口os深度   
*
* @return  
* @remark  无
* @see     
* @author  张天浩10345337      @date  2023/10/08
************************************************************/
ZXIC_UINT32 dpp_dtb_dtb_cfg_aximr_os_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 aximr_os);
/***********************************************************/
/** 获取端口outstanding深度
* @param   dev_id           设备号，支持多芯片  
* @param   aximr_os         端口os深度
*
* @return  
* @remark  无
* @see     
* @author  张天浩10345337      @date  2023/10/08
************************************************************/
ZXIC_UINT32 dpp_dtb_dtb_cfg_aximr_os_get(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 *p_aximr_os);

/***********************************************************/
/** 以128bit为单位读出rd table ram 内容 
* @param   dev_id             设备号，支持多芯片
* @param   offset             偏移 128bit为单位 0 - 2047
* @param   rd_ram_data        读出的ram数据，128bit
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_rd_table_ram_data_block_rd(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 offset,
                                             ZXIC_UINT32 *rd_ram_data);
#endif

#ifdef __cplusplus
}
#endif

#endif

