/**************************************************************
* profileid资源分配如下
* 一级CAR 
* flowid:32K, profileid:512 
* 一级CAR 
* flowid:4K, profileid:128 
* 一级CAR 
* flowid:1K, profileid:32 
***************************************************************/
#ifndef  _DPP_CAR_RES_H_
#define  _DPP_CAR_RES_H_

#include "zxic_common.h"
#include "dpp_type_api.h"
#include "dpp_dev.h"
#include "dpp_stat_api.h"

/******************************************************************************
 *                                宏定义                                *
 *****************************************************************************/
#define CARA_PROFILE_ID_MAX (512-1)
#define CARB_PROFILE_ID_MAX (128-1)
#define CARC_PROFILE_ID_MAX (32-1)

#define ZXIC_PROFILE_ID_OUT_BASE      (0xa0)
#define ZXIC_CARA_PROFILE_ID_USED_OUT (0 | ZXIC_PROFILE_ID_OUT_BASE)
#define ZXIC_CARB_PROFILE_ID_USED_OUT (1 | ZXIC_PROFILE_ID_OUT_BASE)
#define ZXIC_CARC_PROFILE_ID_USED_OUT (2 | ZXIC_PROFILE_ID_OUT_BASE)

#define ZXIC_PLCR_ERR_BASE            (0xb0)
#define ZXIC_PLCR_TYPE_ERR            (0 | ZXIC_PLCR_ERR_BASE)


#define    ZXIC_BITDCL     ZXIC_UINT32
#define    ZXIC_BITWID     (32)

#define CAR_RES_USED_SET(_u_, _identifier_) \
    ZXIC_COMM_BITSET(_u_, _identifier_)

#define CAR_RES_USED_CLR(_u_, _identifier_) \
    ZXIC_COMM_BITCLR(_u_, (_identifier_))

#define CAR_RES_USED_GET(_u_, _identifier_) \
    ZXIC_COMM_BITGET(_u_, (_identifier_))

#define G_PROFILE_ID_MASK (0xffffffffffffffff)
#define ZXIC_G_PROFILE_ID_GET(_g_profile_id, _profile_id_vaild, _vport, _type, _profile_id) \
        ((_g_profile_id) = ((((ZXIC_UINT64)_profile_id_vaild) << 56) & G_PROFILE_ID_MASK) | \
                           ((((ZXIC_UINT64)_vport) << 20) & G_PROFILE_ID_MASK) | \
                           ((((ZXIC_UINT64)_type) << 16) & G_PROFILE_ID_MASK) | \
                           (((ZXIC_UINT64)_profile_id) & G_PROFILE_ID_MASK))

#define PROFILE_RES_OUT (0x100000000000000)

#define ZXIC_G_EP_ID_GET(_ep_id, _vport) \
        ((_ep_id) = (_vport & 0x7000) >> 12)

#define ZXIC_G_PF_ID_GET(_pf_id, _vport) \
        ((_pf_id) = (_vport & 0x700) >> 8)

#define ZXIC_EP_ID_MAX (5)
#define ZXIC_PF_ID_MAX (5*256)
#define ZXIC_VPORT_MAX (0xffff)

#define VPORT_EPID_BT_START          (12)  /*EPID起始位*/
#define VPORT_EPID_BT_LEN            (3)  /*EPID长度*/
#define VPORT_FUNC_ACTIVE_BT_START   (11)  /*FUNC_ACTIVE起始位*/
#define VPORT_FUNC_ACTIVE_BT_LEN     (1)  /*FUNC_ACTIVE长度*/
#define VPORT_FUNC_NUM_BT_START      (8)  /*FUNC_NUM起始位*/
#define VPORT_FUNC_NUM_BT_LEN        (3)  /*FUNC_NUM长度*/
#define VPORT_VFUNC_NUM_BT_START     (0)  /*FUNC_NUM起始位*/
#define VPORT_VFUNC_NUM_BT_LEN       (8)  /*FUNC_NUM长度*/
/******************************************************************************
 *                                类型定义                               *
 *****************************************************************************/

typedef enum dpp_profile_type
{
    CAR_A = 0,
    CAR_B = 1,
    CAR_C = 2,
    CAR_MAX
} DPP_PROFILE_TYPE;

typedef struct dpp_profileid_list
{
    ZXIC_UINT32  count;
    ZXIC_BITDCL  *bits;
} DPP_PROFILEID_LIST_T;

typedef struct zxic_plcr_res_info
{
    DPP_PROFILEID_LIST_T car_list[CAR_MAX];
    ZXIC_UINT32     is_valid;
} DPP_CAR_RES_INFO_T;

typedef struct dpp_car_rb_res_info
{
    ZXIC_UINT32 profile_id;
    ZXIC_UINT32 car_type;
    ZXIC_UINT32 vport_id;
} DPP_CAR_RB_RES_INFO_T;

/******************************************************************************
 *                                接口定义                               *
 *****************************************************************************/
/***********************************************************/
/**硬初始化函数  
* @param   device_id   芯片的id号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_car_init(ZXIC_UINT32 device_id);

/***********************************************************/
/**car模式始化函数
* @param   device_id   芯片的id号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_car_mode_init(ZXIC_UINT32 device_id, ZXIC_UINT32 mode);

/***********************************************************/
/**硬初始化函数  对应的资源申请
* @param   device_id   芯片的id号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_car_rate_profile_hard_init(ZXIC_UINT32 device_id);

/***********************************************************/
/**资源对应的bit位置位
* @param   list   节点bit信息
* @param   id     要置位的bit位
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_profile_index_set(DPP_PROFILEID_LIST_T *list, ZXIC_UINT32 id);

/***********************************************************/
/**资源对应的bit位清0
* @param   list   节点bit信息
* @param   id     要置位的bit位
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_profile_index_clr(DPP_PROFILEID_LIST_T *list, ZXIC_UINT32 id);

/***********************************************************/
/**获取资源的id号
* @param   list    对应的bitmap的指针
* @param   start   起始的比特位
* @param   end     终止的比特位
* @param   id      获取的id号
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_profile_index_get(ZXIC_BITDCL *list, ZXIC_UINT32 start, ZXIC_UINT32 end, ZXIC_UINT32 *id);

/***********************************************************/
/**软初始化函数  对应的资源申请
* @param   device_id   芯片的id号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_car_rate_profile_soft_init(ZXIC_UINT32 device_id, ZXIC_UINT32 car_type);

/***********************************************************/
/**获取数据库句柄
* @param   device_id   芯片的id号
* @param   car   类型
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
ZXIC_RB_CFG * dpp_car_res_addr_rb_get(ZXIC_UINT32 device_id, ZXIC_UINT32 car);

/***********************************************************/
/**红黑树key比较
* @param   p_new_key  新键值
* @param   p_old_key   旧键值
* @param   key_len   键值长度
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
ZXIC_SINT32 dpp_car_res_key_default_cmp(void *p_new_key, void *p_old_key, ZXIC_UINT32 key_len);

/***********************************************************/
/**申请profileid
* @param   device_id   芯片的id号
* @param   type        car类型
* @param   p_id        profile号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_car_profile_id_get(ZXIC_UINT32 device_id, DPP_PROFILE_TYPE type, ZXIC_UINT32 *p_id);

/***********************************************************/
/**全局的profile_id的申请
* @param   vport_id    vport id号
* @param   type        car层级
* @param   gprofile_id  获取的gprofile_id的值
*
* @return
* @remark  对于pp级的节点自动的加到dev级     pp级的挂点值
*          允许申请一次  之后只是返回之前的值
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_car_profile_add(ZXIC_UINT32 vport_id, ZXIC_UINT32 type, ZXIC_UINT64 *g_profile_id);

/***********************************************************/
/**获取的调度单元的资源删除
* @param   vport_id    vport id号
* @param   numq        申请的id的个数  目前只支持一次删除一个
* @param   type        car层级
* @param   gprofile_id  获取的gprofile_id的值
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_car_profile_delete(ZXIC_UINT32 vport_id, ZXIC_UINT32 type, ZXIC_UINT32 profile_id);

/***********************************************************/
/**host复位，对应plcr profileid资源释放
* @param   ep_id   host id号
* @param   pf_id   pf id号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_plcr_reset(ZXIC_UINT32 ep_id, ZXIC_UINT32 pf_id);

/***********************************************************/
/**遍历数据库
 * @param   device_id   芯片的id号
 * @param   pp_port     端口号
 *
 *
 * @return
 * @remark  无
 * @see
 * @author  sun      @date  2023/12/1
 ************************************************************/
DPP_STATUS dpp_plcr_res_database(ZXIC_UINT32 device_id, ZXIC_UINT32 car_type);

/***********************************************************/
/**host异常复位，对应profileid资源释放
 * @param   dev_id   设备号
 * @param   ep_id   host id号
 *
 * @return
 * @remark  无
 * @see
 * @author  sun      @date  2023/12/1
 ************************************************************/
DPP_STATUS dpp_host_plcr_reset_process(ZXIC_UINT32 dev_id, ZXIC_UINT32 ep_id);

/***********************************************************/
/**vport复位，对应profileid资源释放
 * @param   dev_id   设备号
 * @param   ep_no   host id号
 * @param   pf_no   pf id号
 * @param   vf_no   vf id号
 * @param   vf_active  pf/vf标记
 *
 * @return
 * @remark  无
 * @see
 * @author  sun      @date  2024/2/27
 ************************************************************/
DPP_STATUS dpp_vport_plcr_reset_process(ZXIC_UINT32 ep_no, ZXIC_UINT32 pf_no, ZXIC_UINT32 vf_no, ZXIC_UINT32 vf_active);

#endif