/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_hash.h
* ļʶ : 
* ժҪ : 
* ˵ : 
* ǰ汾 : 
*      : wcl
*  : 2014/02/14
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef _DPP_HASH_H_
#define _DPP_HASH_H_

#define HASH_FUNC_ID_MIN          (0)
#define HASH_FUNC_ID_NUM          (4)

#define HASH_DDR_CRC_NUM          (4)

#define HASH_KEY_MAX              (49) /* ֵȣֽΪλ */
#define HASH_RST_MAX              (32) /* ȣֽΪλ */
#define HASH_ENTRY_POS_STEP       (16) 

#define HASH_TBL_ID_NUM           (32) /* ÿHashеҵĿ */
#define HASH_BULK_NUM             (8)  /* ÿHashDDRԴֵĿ */


#define HASH_ACTU_KEY_MIN         (1)  /* ҵʵʼֵ */
#define HASH_ACTU_KEY_MAX         (48)
#define HASH_ACTU_KEY_STEP        (1)  /* actual keyĳȵλ: 1ֽ */
#define HASH_KEY_CTR_SIZE         (1)  /* keyпϢĳ, 1ֽ */
#define ITEM_ENTRY_NUM_2          (2)
#define ITEM_ENTRY_NUM_4          (4)

#define HASH_DDR_ITEM_MIN         (1<<14)
#define HASH_DDR_ITEM_MAX         (1<<26)

#define HASH_ZBLK_ID_MAX          (31)

/* hash ext cfg reg */
#define HASH_EXT_MODE_BT_START    (1)
#define HASH_EXT_MODE_BT_WIDTH    (8)
#define HASH_EXT_FLAG_BT_START    (0)
#define HASH_EXT_FLAG_BT_WIDTH    (1)

/* hash tbl30 depth reg */
#define HASH_TBL0_DEPTH_BT_START     (0)
#define HASH_TBL0_DEPTH_BT_WIDTH     (8)
#define HASH_TBL1_DEPTH_BT_START     (8)
#define HASH_TBL1_DEPTH_BT_WIDTH     (8)
#define HASH_TBL2_DEPTH_BT_START     (16)
#define HASH_TBL2_DEPTH_BT_WIDTH     (8)
#define HASH_TBL3_DEPTH_BT_START     (24)
#define HASH_TBL3_DEPTH_BT_WIDTH     (8)

/* hash tbl74 depth reg*/
#define HASH_TBL4_DEPTH_BT_START     (0)
#define HASH_TBL4_DEPTH_BT_WIDTH     (8)
#define HASH_TBL5_DEPTH_BT_START     (8)
#define HASH_TBL5_DEPTH_BT_WIDTH     (8)
#define HASH_TBL6_DEPTH_BT_START     (16)
#define HASH_TBL6_DEPTH_BT_WIDTH     (8)
#define HASH_TBL7_DEPTH_BT_START     (24)
#define HASH_TBL7_DEPTH_BT_WIDTH     (8)
  
/* hash ext crc cfg*/  
#define TBL0_EXT_CRC_CFG_BT_START    (0)
#define TBL0_EXT_CRC_CFG_BT_WIDTH    (2)
#define TBL1_EXT_CRC_CFG_BT_START    (2)
#define TBL1_EXT_CRC_CFG_BT_WIDTH    (2)
#define TBL2_EXT_CRC_CFG_BT_START    (4)
#define TBL2_EXT_CRC_CFG_BT_WIDTH    (2)
#define TBL3_EXT_CRC_CFG_BT_START    (6)
#define TBL3_EXT_CRC_CFG_BT_WIDTH    (2)
#define TBL4_EXT_CRC_CFG_BT_START    (8)
#define TBL4_EXT_CRC_CFG_BT_WIDTH    (2)
#define TBL5_EXT_CRC_CFG_BT_START    (10)
#define TBL5_EXT_CRC_CFG_BT_WIDTH    (2)
#define TBL6_EXT_CRC_CFG_BT_START    (12)
#define TBL6_EXT_CRC_CFG_BT_WIDTH    (2)
#define TBL7_EXT_CRC_CFG_BT_START    (14)
#define TBL7_EXT_CRC_CFG_BT_WIDTH    (2)

/* hash mono flags*/
#define HASH0_MONO_FLAG_BT_START     (0)
#define HASH0_MONO_FLAG_BT_WIDTH     (8)
#define HASH1_MONO_FLAG_BT_START     (8)
#define HASH1_MONO_FLAG_BT_WIDTH     (8)
#define HASH2_MONO_FLAG_BT_START     (16)
#define HASH2_MONO_FLAG_BT_WIDTH     (8)
#define HASH3_MONO_FLAG_BT_START     (24)
#define HASH3_MONO_FLAG_BT_WIDTH     (8)

/* hash zcell mono*/
#define ZCELL0_BULK_ID_BT_START      (2)
#define ZCELL0_BULK_ID_BT_WIDTH      (3)
#define ZCELL0_MONO_FLAG_BT_START    (3)
#define ZCELL0_MONO_FLAG_BT_WIDTH    (1)
#define ZCELL1_BULK_ID_BT_START      (10)
#define ZCELL1_BULK_ID_BT_WIDTH      (3)
#define ZCELL1_MONO_FLAG_BT_START    (11)
#define ZCELL1_MONO_FLAG_BT_WIDTH    (1)
#define ZCELL2_BULK_ID_BT_START      (18)
#define ZCELL2_BULK_ID_BT_WIDTH      (3)
#define ZCELL2_MONO_FLAG_BT_START    (19)
#define ZCELL2_MONO_FLAG_BT_WIDTH    (1)
#define ZCELL3_BULK_ID_BT_START      (26)
#define ZCELL3_BULK_ID_BT_WIDTH      (3)
#define ZCELL3_MONO_FLAG_BT_START    (27)
#define ZCELL3_MONO_FLAG_BT_WIDTH    (1)

/* hash zreg mono                         */
#define ZREG0_BULK_ID_BT_START       (2) 
#define ZREG0_BULK_ID_BT_WIDTH       (3) 
#define ZREG0_MONO_FLAG_BT_START     (3) 
#define ZREG0_MONO_FLAG_BT_WIDTH     (1) 
#define ZREG1_BULK_ID_BT_START       (10)
#define ZREG1_BULK_ID_BT_WIDTH       (3) 
#define ZREG1_MONO_FLAG_BT_START     (11)
#define ZREG1_MONO_FLAG_BT_WIDTH     (1) 
#define ZREG2_BULK_ID_BT_START       (18)
#define ZREG2_BULK_ID_BT_WIDTH       (3) 
#define ZREG2_MONO_FLAG_BT_START     (19)
#define ZREG2_MONO_FLAG_BT_WIDTH     (1) 
#define ZREG3_BULK_ID_BT_START       (26)
#define ZREG3_BULK_ID_BT_WIDTH       (3) 
#define ZREG3_MONO_FLAG_BT_START     (27)
#define ZREG3_MONO_FLAG_BT_WIDTH     (1) 

#define OPR_CLR                (0)
#define OPR_WR                 (1)

#define OBTAIN_CONFLICT_KEY    (0)

/* HASH soft reset*/
#define  HASH_ARG_NUM_PER_BULK (8)  /* ÿbulk Ҫ¼ĲĿ */
#define  HASH_ARG_NUM_PER_TBL  (4)  /* ÿ   Ҫ¼ĲĿ */
#define  HASH_INIT_NUM         (8)  /* HASHʼĿ */
#define  HASH_BULK_INIT_NUM    (1+HASH_BULK_NUM*HASH_ARG_NUM_PER_BULK+3)   /* 1-bulk_valid +3Ϊ˴չ4ı */
#define  HASH_TBL_INIT_NUM     (1+HASH_TBL_ID_NUM*HASH_ARG_NUM_PER_TBL+3)  /* 1-tbl_valid  +3Ϊ˴չ4 */


typedef struct dpp_hash_table_stat
{
    ZXIC_FLOAT ddr;
    ZXIC_FLOAT zcell;
    ZXIC_FLOAT zreg;
    ZXIC_FLOAT sum;
}DPP_HASH_TABLE_STAT;

typedef struct dpp_hash_zreg_mono_stat
{
    ZXIC_UINT32 zblk_id;
    ZXIC_UINT32 zreg_id;
}DPP_HASH_ZREG_MONO_STAT;

typedef struct dpp_hash_bulk_zcam_stat
{
    ZXIC_UINT32 zcell_mono_idx[SE_ZBLK_NUM*SE_ZCELL_NUM];
    DPP_HASH_ZREG_MONO_STAT zreg_mono_id[SE_ZBLK_NUM][SE_ZREG_NUM];
}DPP_HASH_BULK_ZCAM_STAT;

typedef struct dpp_hash_stat
{
    ZXIC_UINT32 insert_ok;
    ZXIC_UINT32 insert_fail;
    ZXIC_UINT32 insert_same;
    ZXIC_UINT32 insert_ddr;
    ZXIC_UINT32 insert_zcell;
    ZXIC_UINT32 insert_zreg;

    ZXIC_UINT32 delete_ok;
    ZXIC_UINT32 delete_fail;

    ZXIC_UINT32 search_ok;
    ZXIC_UINT32 search_fail;

    ZXIC_UINT32 zblock_num;
    ZXIC_UINT32 zblock_array[SE_ZBLK_NUM];

    DPP_HASH_TABLE_STAT insert_table[HASH_TBL_ID_NUM];
    DPP_HASH_BULK_ZCAM_STAT *p_bulk_zcam_mono[HASH_BULK_NUM];
}DPP_HASH_STAT;
    
#if DPP_WRITE_FILE_EN
typedef struct _hash_depth_file_regs
{
    ZXIC_UINT32 tbl03_depth_file_reg;
    ZXIC_UINT32 tbl47_depth_file_reg;

}DPP_HASH_DEPTH_FILE_REGS_T;

typedef struct dpp_hash_file_reg
{
    ZXIC_UINT32 ext_crc_cfg_file_reg[2];
    ZXIC_UINT32 ext_cfg_file_reg[HASH_FUNC_ID_NUM];    
    DPP_HASH_DEPTH_FILE_REGS_T hash_depth_file_regs[HASH_FUNC_ID_NUM];
    ZXIC_UINT32 hash_mono_flags_file_reg;
    ZXIC_UINT32 zblk_clk_en_file_reg;
    ZXIC_UINT32 age_pat_cfg_file_reg;
    ZXIC_UINT8   zcell_mono_file_ram[SE_RAM_WIDTH / 8];
    ZXIC_UINT8   zreg_mono_file_ram[SE_RAM_WIDTH / 8];
}DPP_HASH_FILE_REG_T;
#endif

typedef enum dpp_hash_itme_pos
{
    HASH_ITEM_POS_0   = 0,
    HASH_ITEM_POS_1   = 1,
    HASH_ITEM_POS_2   = 2,
    HASH_ITEM_POS_3   = 3,
    HASH_ITEM_POS_MAX = 4,
}DPP_HASH_ITME_POS;

typedef enum dpp_hash_item_inst_mode
{
    HASH_ITEM_INSERT_LAST = 0,
    HASH_ITEM_INSERT_1ST,
    HASH_ITEM_INSERT_NULL
}DPP_HASH_ITEM_INST_MODE;

/* hash Ϣ */
typedef struct dpp_hash_tbl_info
{
    ZXIC_UINT32 fun_id;
    ZXIC_UINT32 actu_key_size;  /**<  @brief ʵʼֵȣ1ֽΪλ */
    ZXIC_UINT32 key_type;       /**<  @brief : 1-128bit, 2-256bit, 3-512bit */
    ZXIC_UINT8 is_init;        /**<  @brief Ƿʼ*/
    ZXIC_UINT8 mono_zcell;     /**<  @brief Ƿжռzcell*/
    ZXIC_UINT8 zcell_num;      /**<  @brief ռzcellĿ*/
    ZXIC_UINT8 mono_zreg;     /**<  @brief Ƿжռzcell*/
    ZXIC_UINT8 zreg_num;      /**<  @brief ռzcellĿ*/    
    ZXIC_UINT8 is_age;         /* Ӳϻ־ҵ֧Ӳϻ */
    ZXIC_UINT8 is_lrn;         /* Ӳѧϰ־ҵ֧Ӳѧϰ */
    ZXIC_UINT8 is_mc_wrt;      /* ΢д־ҵ֧΢д */
    //ZXIC_UINT8 pad[3];
}DPP_HASH_TBL_ID_INFO;

typedef struct dpp_hash_rbkey_info
{
    ZXIC_UINT8         key[HASH_KEY_MAX];
    ZXIC_UINT8         rst[HASH_RST_MAX];
    D_NODE       entry_dn;
    SE_ITEM_CFG  *p_item_info;
/*    ZXIC_UINT32       rb_idx;*/
    ZXIC_UINT32       entry_size;   /* ĿȣֽΪλ */
    ZXIC_UINT32       entry_pos;    /* Ŀitemеʼλã128bitΪƫƵλ */
}DPP_HASH_RBKEY_INFO;

/* DDR*/
typedef struct hash_ddr_cfg
{
    ZXIC_UINT32                  bulk_use;         /**< @brief hashbulkռǷѾʹ*/
    ZXIC_UINT32                  ddr_baddr;        /**< @brief hashDDRռӲַ*/
    ZXIC_UINT32                  ddr_ecc_en;       /**< @brief DDR ECCʹ: 0-ʹܣ1-ʹ*/
    ZXIC_UINT32                  item_num;         /**< @brief Ӳddr洢ԪĿλΪλ*/
    ZXIC_UINT32                  bulk_id;          /**< @brief DDRռ*/
    ZXIC_UINT32                  hash_ddr_arg;     /**< @brief hash ddr CRC ʽ*/
    ZXIC_UINT32                  width_mode;       /**< @brief ddr3 λ*/
    ZXIC_UINT32                  hw_baddr;         /**< @brief ddr3 洢Ԫʼƫƣ256bitΪλ*/
    ZXIC_UINT32                  zcell_num;          /*cpu λ 洢¼ò*/
    ZXIC_UINT32                  zreg_num;           /*cpu λ 洢¼ò*/

    SE_ITEM_CFG             **p_item_array;   /**< @brief ָָָ*/
}HASH_DDR_CFG;

#define HASH_ADDR_EXT_FLAG_BT_OFF    (31)
#define HASH_ADDR_WRT_MASK_BT_OFF    (27)
#define HASH_ADDR_BT_OFF             (1)
#define HASH_ADDR_DDR_BT_LEN         (26)
#define HASH_ADDR_ZCAM_BT_LEN        (17)
typedef struct dpp_hash_wrt_lrn_rsp
{
    ZXIC_UINT8   space_vld; /* Ӳѧϰʱ˱־Ч */
    ZXIC_UINT8   ext_flag;  /* ģӲѧϰ־λ*/
    ZXIC_UINT8   wrt_mask;
    ZXIC_UINT8   width_flag;
    ZXIC_UINT32 lrn_addr;
}DPP_HASH_WRT_LRN_RSP;

typedef struct dpp_hash_cfg
{
    ZXIC_UINT32             fun_id;
    ZXIC_UINT8               ddr_valid;     /* ǷʹDDR */
    ZXIC_UINT8               pad[3];
    HASH_FUNCTION32    p_hash32_fun;
    HASH_FUNCTION      p_hash16_fun;

    HASH_DDR_CFG       *p_bulk_ddr_info[HASH_BULK_NUM];   /* ÿDDRռ*/
    ZXIC_UINT8               bulk_ram_mono[HASH_BULK_NUM];      /* ÿZCAMռռ־*/
    SHARE_RAM          hash_shareram; /* ZCAMԴ */
    DPP_SE_CFG         *p_se_info;

    ZXIC_RB_CFG         hash_rb;
    ZXIC_RB_CFG         ddr_cfg_rb;
    DPP_HASH_STAT      hash_stat;
}DPP_HASH_CFG;

typedef struct hash_entry_cfg
{
    ZXIC_UINT32 fun_id;
    ZXIC_UINT8 bulk_id;
    ZXIC_UINT8 table_id;
    ZXIC_UINT8 key_type;
    ZXIC_UINT8 rsp_mode;
    ZXIC_UINT32 actu_key_size;
    ZXIC_UINT32 key_by_size;
    ZXIC_UINT32 rst_by_size;
    DPP_SE_CFG *p_se_cfg;
    DPP_HASH_CFG *p_hash_cfg;
    DPP_HASH_RBKEY_INFO *p_rbkey_new;
    ZXIC_RB_TN *p_rb_tn_new;
}HASH_ENTRY_CFG;

#define DPP_GET_HASH_KEY_CTRL(valid, type, tbl_id)  (((valid & 0x1) << 7) | ((type & 0x3) << 5) | (tbl_id & 0x1f))
#define DPP_GET_HASH_TBL_ID(p_key)    ((p_key)[0] & 0x1F)
#define DPP_GET_HASH_KEY_TYPE(p_key)  (((p_key)[0] >> 5) & 0x3)
#define DPP_GET_HASH_KEY_VALID(p_key) (((p_key)[0] >> 7) & 0x1)
/** hashͻȡֵֽ16B,32B64B0*/
#define DPP_GET_HASH_ENTRY_SIZE(key_type) \
    ((key_type == HASH_KEY_128b)?16U:       \
       ((key_type == HASH_KEY_256b)?32U:    \
         ((key_type == HASH_KEY_512b)?64U:0)))

#define DPP_GET_ACTU_KEY_BY_SIZE(actu_key_size) \
    (actu_key_size * HASH_ACTU_KEY_STEP)

#define DPP_GET_KEY_SIZE(actu_key_size) \
    (DPP_GET_ACTU_KEY_BY_SIZE(actu_key_size) + HASH_KEY_CTR_SIZE)
#define DPP_GET_RST_SIZE(key_type, actu_key_size) \
    ((DPP_GET_HASH_ENTRY_SIZE(key_type) != 0)? \
    (DPP_GET_HASH_ENTRY_SIZE(key_type) - DPP_GET_ACTU_KEY_BY_SIZE(actu_key_size) - HASH_KEY_CTR_SIZE): 0xFF)  /* modify coverity kfr 2022.05.31 */

#define DPP_GET_HASH_RB_KEY(p_hash_rb, idx) \
    ((p_hash_rb)->p_keybase + ((p_hash_rb)->key_size * (idx)))

#define DPP_GET_DDR_WR_MODE(key_type) ((key_type == HASH_KEY_512b)?key_type : (key_type - 1))

/** Ŀλʼλûȡд */
#define DPP_GET_HASH_ENTRY_MASK(entry_size, entry_pos) \
    ((((1U << (entry_size/16U)) - 1U) << (4U - entry_size/16U - entry_pos)) & 0xF)

DPP_STATUS dpp_hash_zblkcfg_write(DPP_SE_CFG   *p_se_cfg, ZXIC_UINT32 fun_id, SE_ZBLK_CFG  *p_zblk_cfg);

DPP_STATUS dpp_hash_zblkcfg_clr(DPP_SE_CFG   *p_se_cfg, ZXIC_UINT32 fun_id, SE_ZBLK_CFG  *p_zblk_cfg);

DPP_STATUS dpp_hash_bulk_mono_flags_write(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 hash_id, ZXIC_UINT32 bulk_id);

DPP_STATUS dpp_hash_bulk_mono_flags_clr(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 hash_id, ZXIC_UINT32 bulk_id);

DPP_STATUS dpp_hash_zcell_mono_write(DPP_SE_CFG *p_se_cfg, SE_ZCELL_CFG *p_zcell_cfg);

DPP_STATUS dpp_hash_zcell_mono_clr(DPP_SE_CFG *p_se_cfg, SE_ZCELL_CFG *p_zcell_cfg);

DPP_STATUS dpp_hash_zreg_mono_write(DPP_SE_CFG *p_se_cfg,  
                                    ZXIC_UINT32     tbl_id,
                                    ZXIC_UINT32     zblk_idx,
                                    ZXIC_UINT32     zreg_id);

DPP_STATUS dpp_hash_zreg_mono_clr(DPP_SE_CFG   *p_se_cfg,  
                                  ZXIC_UINT32     tbl_id,
                                  ZXIC_UINT32     zblk_idx,
                                  ZXIC_UINT32     zreg_id);

DPP_STATUS dpp_hash_ext_cfg_write(DPP_SE_CFG   *p_se_cfg, 
                                  ZXIC_UINT32       fun_id,
                                  ZXIC_UINT32       bulk_id,
                                  HASH_DDR_CFG   *p_ddr_cfg);

DPP_STATUS dpp_hash_ext_cfg_clr(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 fun_id);

DPP_STATUS dpp_hash_tbl_depth_write(DPP_SE_CFG   *p_se_cfg, 
                                    ZXIC_UINT32       fun_id,
                                    ZXIC_UINT32       bulk_id,
                                    HASH_DDR_CFG   *p_ddr_cfg);

DPP_STATUS dpp_hash_tbl_depth_clr(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 fun_id);

DPP_STATUS dpp_hash_tbl_crc_poly_write(DPP_SE_CFG *p_se_cfg,
                                       ZXIC_UINT32 fun_id,
                                       ZXIC_UINT32 bulk_id,
                                       ZXIC_UINT32 crc_sel);

DPP_STATUS dpp_se_zblk_clk_en_write(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 bit_num, ZXIC_UINT32 clk_en);

DPP_STATUS dpp_hash_bulk_zcam_mono_prt(DPP_SE_CFG *p_se_cfg,ZXIC_UINT32 fun_id,ZXIC_UINT32 bulk_id);
DPP_STATUS dpp_hash_destroy(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 hash_id);
ZXIC_SINT32 dpp_hash_rb_key_cmp(ZXIC_VOID *p_new, ZXIC_VOID *p_old, ZXIC_UINT32 key_size);

DPP_STATUS dpp_hash_se_cfg_point_get(ZXIC_UINT32 dev_id, ZXIC_UINT64 *p_se_cfg_point);

DPP_STATUS dpp_hash_get_array_ptr(ZXIC_UINT32 dev_id, DPP_HASH_TBL_ID_INFO **ptr);

/***********************************************************/
/** ȡλҪֽڳ
* @param   dev_id
* @param   p_size
*
* @return
* @remark  
* @see
* @author  yxh      @date  2018/06/25
************************************************************/
DPP_STATUS dpp_hash_glb_size_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_size);

/***********************************************************/
/** λȡλʱҪ洢ĲϢ
* @param   p_se_cfg   㷨ģ鹫ݽṹָ
* @param   p_flag     ͷpp_data_buffıǣ0-ͷţ1-Ҫͷ
* @param   p_size     С
* @param   buf
*
* @return
* @remark  
* @see
* @author  yxh      @date  2018/06/19
************************************************************/
DPP_STATUS dpp_hash_glb_mgr_get(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 *p_flag,
                                ZXIC_UINT32 *p_size,
                                DPP_SE_CFG *p_se_cfg,
                                ZXIC_UINT32 **buf);

/***********************************************************/
/** HASHλԭĿ
* @param   p_se_cfg
* @param   size
* @param   rcov_dat
*
* @return
* @remark  
* @see
* @author  YXH      @date  2018/06/19
************************************************************/
DPP_STATUS dpp_hash_glb_mgr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 size, DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 *rcov_dat);

DPP_STATUS dpp_hash_zcell_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 zcell_id);

DPP_STATUS dpp_hash_zreg_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 zblk_id, ZXIC_UINT32 zreg_id);

DPP_STATUS dpp_hash_specify_zcam_space_clr(DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 fun_id, ZXIC_UINT32 bulk_id);

DPP_STATUS dpp_hash_specify_entry_delete(DPP_SE_CFG *p_se_cfg,ZXIC_UINT32 hash_id, ZXIC_UINT32 bulk_id);

DPP_STATUS dpp_hash_specify_table_delete(DPP_SE_CFG *p_se_cfg,ZXIC_UINT32 hash_id, ZXIC_UINT32 table_id);

DPP_STATUS dpp_hash_soft_reset_flag_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_flag);

DPP_STATUS dpp_hash_soft_reset_flag_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 flag);

ZXIC_VOID dpp_hash_entry_into_prt(ZXIC_UINT32 dev_id,DPP_HASH_ENTRY *p_entry);

DPP_STATUS dpp_hash_red_black_node_alloc(ZXIC_UINT32 dev_id,ZXIC_RB_TN **p_rb_tn_new,DPP_HASH_RBKEY_INFO **p_rbkey_new);

DPP_STATUS dpp_hash_parse_entry_info(ZXIC_UINT32 dev_id, DPP_SE_CFG *p_se_cfg, ZXIC_UINT32 fun_id, DPP_HASH_ENTRY *p_entry,HASH_ENTRY_CFG *pTblCfg);

DPP_STATUS dpp_hash_rb_insert(ZXIC_UINT32 dev_id,HASH_ENTRY_CFG *p_hash_entry_cfg,DPP_HASH_ENTRY *p_entry);

DPP_STATUS dpp_hash_set_crc_key(ZXIC_UINT32 dev_id,HASH_ENTRY_CFG *p_hash_entry_cfg,DPP_HASH_ENTRY *p_entry,ZXIC_UINT8 *p_temp_key);

DPP_STATUS dpp_hash_insert_ddr(ZXIC_UINT32 dev_id,HASH_ENTRY_CFG *p_hash_entry_cfg,ZXIC_UINT8 *p_temp_key,ZXIC_UINT8 *p_end_flag);

DPP_STATUS dpp_hash_insert_zcell(ZXIC_UINT32 dev_id,HASH_ENTRY_CFG *p_hash_entry_cfg,ZXIC_UINT8 *p_temp_key,ZXIC_UINT8 *p_end_flag);

DPP_STATUS dpp_hash_insert_zreg(ZXIC_UINT32 dev_id,HASH_ENTRY_CFG *p_hash_entry_cfg,ZXIC_UINT8 *p_temp_key,ZXIC_UINT8 *p_end_flag);

DPP_STATUS dpp_hash_soft_all_entry_delete(DPP_SE_CFG *p_se_cfg,ZXIC_UINT32 hash_id);

DPP_STATUS dpp_hash_zcam_resource_deinit(DPP_HASH_CFG *p_hash_cfg);

DPP_STATUS dpp_hash_get_hash_info_from_sdt(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no, HASH_ENTRY_CFG *p_hash_entry_cfg);

DPP_STATUS dpp_hash_soft_uninstall(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_one_hash_soft_uninstall(ZXIC_UINT32 dev_id,ZXIC_UINT32 hash_id);

DPP_STATUS dpp_lpm_soft_uninstall(ZXIC_UINT32 dev_id);

#endif /* dpp_hash.h */



