/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_vpci.h
* 文件标识 :
* 内容摘要 :
* 其它说明 :
* 当前版本 :
* 作    者 : 石金锋
* 完成日期 : 2014/02/10
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* 修改记录1: 代码规范性修改
* 修改日期:  2014/02/10
* 版 本 号:
* 修 改 人:  丁金凤
* 修改内容:
***************************************************************/


#ifndef  _DPP_VPCI_H_
#define  _DPP_VPCI_H_

#include "zxic_comm_socket.h"
#include "zxic_comm_thread.h"


#ifdef __cplusplus
extern "C"
{
#endif

#define DPP_VPCI_MAX_CFG_LEN         (50)
#define DPP_VPCI_BURST_DATA_MAX      (96) /* VPCI接收/发送的最大数据长度，以ZXIC_UINT32为单位 */

/* flag */
#define PCI_ACCESS_FLAG      (0x7B)
#define PACKET_ACCESS_FLAG   (0x7C)

/* msg_type */
#define PCI_ACCESS_REQUEST   (0x01)
#define PCI_ACCESS_RESPONSE  (0x02)
#define PACKET_ACCESS_DOWN   (0x01)
#define PACKET_ACCESS_UPSEND (0x02)

/* dev_type */
#define PFUZD_ACCESS         (0x01)
#define DPP_MEM_ACCESS       (0x02)

/* opr */
#define DPP_MEM_WRITE        (0x01)
#define DPP_MEM_READ         (0x02)

typedef struct dpp_vpci_sock_msg_t
{
    ZXIC_UINT8   flag;
    ZXIC_UINT8   msg_type;
    ZXIC_UINT8   dev_type;
    ZXIC_UINT8   opr;
    ZXIC_UINT32 addr;
    ZXIC_UINT32 len;
    ZXIC_UINT32 data[0];
} DPP_VPCI_SOCK_MSG_T;

typedef struct dpp_vpci_client_cfg_t
{
    ZXIC_UINT8   ip_addr[16];
    ZXIC_UINT32 port;
    ZXIC_UINT32 dev_type;
    ZXIC_UINT32 chip_version;
    ZXIC_UINT32 server_port;
    ZXIC_UINT32 pkt_port;
} DPP_VPCI_CLIENT_CFG_T;


typedef struct dpp_vpci_mgr_t
{
    ZXIC_UINT32      port;
    ZXIC_SOCKET  sock;
    ZXIC_UINT32      is_connected;
    ZXIC_UINT32      dev_type;
    ZXIC_UINT32      chip_version;
    ZXIC_UINT32      pkt_port;
    ZXIC_UINT32      addr;
} DPP_VPCI_MGR_T;

typedef struct SimInMsg
{
    ZXIC_UINT16 port_no;
    ZXIC_UINT16 pkt_len;
} SERVER_SIM_IN_MSG_T;

/* API */
ZXIC_UINT32 dpp_vpci_debug_flag_set(ZXIC_UINT32 flag);
ZXIC_UINT32 dpp_vpci_get_cnnt_status(ZXIC_VOID);
ZXIC_UINT32 dpp_vpci_get_dev_type(ZXIC_VOID);
ZXIC_UINT32 dpp_vpci_get_chip_version(ZXIC_VOID);
ZXIC_UINT32 dpp_vpci_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 len, ZXIC_UINT32 *p_data);
ZXIC_UINT32 dpp_vpci_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 len, ZXIC_UINT32 *p_data);
ZXIC_UINT32 dpp_vpci_socket_thread_create(ZXIC_THREAD_ID_T *thread_id);
ZXIC_VOID* dpp_vpci_client_connect_create(ZXIC_VOID *p_arg);
ZXIC_UINT32 dpp_vpci_stop_client_connect(ZXIC_VOID);
ZXIC_UINT32 dpp_vpci_read_config_file(DPP_VPCI_CLIENT_CFG_T *p_client_cfg);
ZXIC_UINT32 dpp_pkt_socket_init(ZXIC_VOID);
ZXIC_UINT32 dpp_sim_pkt_send(ZXIC_UINT32 port_id, ZXIC_UINT8 *pkt, ZXIC_UINT32 pkt_len, ZXIC_UINT32 number);

#ifdef __cplusplus
}
#endif


#endif


