/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_se_diag.h
* ļʶ :
* ժҪ :
* ˵ :
* ǰ汾 :
*      : XXX
*  : 2016/01/14
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* ޸ļ¼1:
* ޸:
*   :
*   :
* ޸:
***************************************************************/
#ifndef _DPP_SE_DIAG_H_
#define _DPP_SE_DIAG_H_


#ifdef __cplusplus
extern "C" {
#endif

#define  DPP_SE_SMMU0_ADDR_NUM              (SE_SMMU0_ERAM_ADDR_NUM_TOTAL)/* modified for dpp+ 2019-04-17*/
#define  DPP_SE_SMMU0_BLOCK_ADDR_NUM        (0x4000) /* modified for dpp+ 2019-04-17*/
#define  DPP_SE_SMMU0_BLOCK_NUM             (32)

#define  DPP_SE_DIAG_SMMU1_BANK_ADDR_NUM    (0x200000) /* һbank,512bitΪλ */
#define  DPP_SE_DIAG_SMMU1_BANK_BADDR       (0x800)    /* һbank,1k*512bitΪλ */
#define  DPP_SE_DIAG_SMMU1_8G_MAX_BADDR     (0x3fff)   /* һgroup,1k*512bitΪλ */
#define  DPP_SE_DIAG_SMMU1_DATA256_NUM      (0x800)    /*1DDRַ(λ2k*256bit)256bit*/

#define  DPP_DIAG_HASH_ACTU_KEY_MIN         (1)
#define  DPP_DIAG_HASH_ACTU_KEY_MAX         (48)

#define  DPP_DIAG_HASH_TBL_ID_MIN           (0)
#define  DPP_DIAG_HASH_TBL_ID_MAX           (31)

#define  DPP_DIAG_SMMU1_DATA128_OFFSET      (12)
#define  DPP_DIAG_SMMU1_DATA256_OFFSET      (8)
#define  DPP_DIAG_SMMU0_DATA_OFFSET_MAX     (4)

/** ɨ */
typedef enum diag_dpp_scan_mode_e
{
    SCAN_BY_ZERO = 0,   /**<@brief ʼ0ֵɨ */
    SCAN_BY_RANDOM = 1  /**<@brief ֵɨ */
} DPP_DIAG_SCAN_MODE_E;

/** eramλģʽ */
typedef enum diag_dpp_eram_mode_e
{
    DPP_ERAM_DIAG_MODE_1   = 0,
    DPP_ERAM_DIAG_MODE_32  = 1,
    DPP_ERAM_DIAG_MODE_64  = 2,
    DPP_ERAM_DIAG_MODE_128 = 3,
    DPP_ERAM_DIAG_MODE_2   = 4,
    DPP_ERAM_DIAG_MODE_4   = 5,
    DPP_ERAM_DIAG_MODE_8   = 6,
    DPP_ERAM_DIAG_MODE_16  = 7,
    DPP_ERAM_DIAG_MODE_MAX
} DPP_DIAG_ERAM_MODE_E;

typedef enum diag_dpp_ddr_share_e
{
    DDR_SHARE_TYPE_NONE     = 0,
    DDR_SHARE_TYPE_1_2      = 1,
    DDR_SHARE_TYPE_1_4      = 2,
    DDR_SHARE_TYPE_1_8      = 3,
    DDR_SHARE_TYPE_MAX      = 4,
} DPP_DIAG_DDR_SHARE_E;

typedef enum diag_dpp_hash_key_width_e
{
    HASH_KEY_WIDTH_RSV = 0,
    HASH_KEY_WIDTH_128 = 1,
    HASH_KEY_WIDTH_256 = 2,
    HASH_KEY_WIDTH_512 = 3,
} DPP_DIAG_HASH_KEY_WIDTH_E;

typedef enum diag_dpp_hash_rsp_mode_e
{
    HASH_RSP_MODE_32  = 0,
    HASH_RSP_MODE_64  = 1,
    HASH_RSP_MODE_128 = 2,
    HASH_RSP_MODE_256 = 3,
} DPP_DIAG_HASH_RSP_MODE_E;

typedef enum diag_dpp_lpm_rsp_mode_e
{
    LPM_RSP_MODE_32  = 0,
    LPM_RSP_MODE_64  = 1,
    LPM_RSP_MODE_128 = 2,
    LPM_RSP_MODE_256 = 3,
} DPP_DIAG_LPM_RSP_MODE_E;

typedef enum diag_dpp_etcam_key_mode_e
{
    DPP_ETCAM_KEY_MODE_640 = 0,
    DPP_ETCAM_KEY_MODE_320 = 1,
    DPP_ETCAM_KEY_MODE_160 = 2,
    DPP_ETCAM_KEY_MODE_80  = 3,
} DPP_DIAG_ETCAM_KEY_MODE_E;

typedef enum diag_dpp_etcam_no_as_rsp_mode_e
{
    DPP_ETCAM_NO_AS_RSP_MODE_32  = 0,
    DPP_ETCAM_NO_AS_RSP_MODE_64  = 1,
    DPP_ETCAM_NO_AS_RSP_MODE_128 = 2,
} DPP_DIAG_ETCAM_NO_AS_RSP_MODE_E;

typedef struct diag_dpp_eram_block_cfg_t
{
    ZXIC_UINT32 width;       /* λģʽbitΪλ */
    ZXIC_UINT32 depth;       /*  */
} DPP_DIAG_ERAM_BLOCK_CFG_T;

/* ¼hashļֵ */
typedef struct diag_dpp_hash_key_rst_t
{
    ZXIC_UINT8 key[49];
    ZXIC_UINT8 rst[64];
} DPP_DIAG_HASH_KEY_RST_T;

typedef struct diag_dpp_tbl_hash_tbl_info_t
{
    ZXIC_UINT32 enable;
    ZXIC_UINT32 key_type;
    ZXIC_UINT32 actu_key_size;
    ZXIC_UINT32 rslt_rsp_mode; /* ظ΢Ľλģʽ */
} DPP_DIAG_HASH_TBL_INFO_T;

typedef struct diag_dpp_tbl_hash_cfg_t
{
    ZXIC_UINT16 enable;
    ZXIC_UINT16 is_zcell_mono;
    ZXIC_UINT32 flag;
    ZXIC_UINT32 entry_max_num;
    ZXIC_UINT32 zblk_idx;
    ZXIC_UINT32 ddr_item_num;
    ZXIC_UINT32 start_key;
    ZXIC_UINT32 num;
    ZXIC_UINT32 ddr_baddr;
    ZXIC_UINT32 ddr_idx_baddr; /* Ƭַ/ƫ, 256bitΪλ */
    ZXIC_UINT32 ddr_crc_en;
    ZXIC_UINT32 ddr_rsp_mode;  /* algDDRģʽǷظ΢λģʽ */
    DPP_DIAG_HASH_TBL_INFO_T tbl_cfgs[32];  /*HASH_TBL_ID_NUM */
} DPP_DIAG_TBL_HASH_CFG_T;

typedef struct diag_dpp_tbl_hash_ctrl_t
{
    DPP_SE_CFG *p_se_cfg;
    DPP_DIAG_TBL_HASH_CFG_T hash_cfgs[4];/* HASH_FUNC_ID_NUM */
} DPP_DIAG_TBL_HASH_CTRL_T;

/***********************************************************/
/** sdtͨýӿ
* @param   dev_id      豸
* @param   sdt_no      sdt
* @param   high_data   ݵĸ32bit
* @param   low_data    ݵĵ32bit
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_sdt_tbl_wr(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 sdt_no,
                                  ZXIC_UINT32 high_data,
                                  ZXIC_UINT32 low_data);

/***********************************************************/
/** ɾһsdtɾӲ㣩
* @param   dev_id      豸
* @param   sdt_no      sdt
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/12/8
************************************************************/
DPP_STATUS diag_dpp_se_sdt_info_del(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no);

/***********************************************************/
/** һsdtɾӲ㣩
* @param   dev_id      豸
* @param   sdt_no      sdt
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/12/8
************************************************************/
DPP_STATUS diag_dpp_se_sdt_info_srh(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no);

/***********************************************************/
/** дddr ֱӱsdt
* @param   dev_id           豸
* @param   sdt_no           sdt
* @param   ddr_base_addr    ddr3ַ
* @param   ddr_share_type   ddr3 bank ģʽμDPP_DIAG_DDR_SHARE_E
* @param   ddr_rw_len       Ķ/дλ0-128bit1-256bit, 2- 512bitμSMMU1_DDR_SRH_MODE_E
* @param   ddr_ecc_en       eccУʹ 1:enable 0:disable
* @param   ddr_clutch_en    ץʹ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_ddr_sdt_tbl_wr(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 sdt_no,
                                      ZXIC_UINT32 ddr_base_addr,
                                      ZXIC_UINT32 ddr_share_type,
                                      ZXIC_UINT32 ddr_rw_len,
                                      ZXIC_UINT32 ddr_ecc_en,
                                      ZXIC_UINT32 ddr_clutch_en);

DPP_STATUS diag_dpp_se_sdt_tbl_prt_all(ZXIC_UINT32 dev_id);

DPP_STATUS diag_dpp_se_etcam_block_full_random_add(ZXIC_UINT32 dev_id, ZXIC_UINT32 block_id);

DPP_STATUS diag_dpp_se_etcam_block_mask_add(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT16 block_id,
                                            ZXIC_UINT32 addr,
                                            ZXIC_UINT8 mask);

DPP_STATUS diag_dpp_se_smmu0_wr32(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 base_addr,
                                  ZXIC_UINT32 index,
                                  ZXIC_UINT32 data);

DPP_STATUS diag_dpp_se_smmu0_wr1(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 base_addr,
                                 ZXIC_UINT32 index,
                                 ZXIC_UINT32 data);

DPP_STATUS diag_dpp_se_smmu0_wr2(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 base_addr,
                                 ZXIC_UINT32 index,
                                 ZXIC_UINT32 data);

DPP_STATUS diag_dpp_se_smmu0_wr4(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 base_addr,
                                 ZXIC_UINT32 index,
                                 ZXIC_UINT32 data);

DPP_STATUS diag_dpp_se_smmu0_wr8(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 base_addr,
                                 ZXIC_UINT32 index,
                                 ZXIC_UINT32 data);

DPP_STATUS diag_dpp_se_smmu0_wr16(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 base_addr,
                                  ZXIC_UINT32 index,
                                  ZXIC_UINT32 data);

DPP_STATUS diag_dpp_se_hash_sdt_tbl_wr_pre(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 learn_en,
                                           ZXIC_UINT32 keep_alive,
                                           ZXIC_UINT32 keep_alive_baddr,
                                           ZXIC_UINT32 rsp_mode,
                                           ZXIC_UINT32 hash_clutch_en);

DPP_STATUS diag_dpp_se_hash_sdt_tbl_wr(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 sdt_no,
                                       ZXIC_UINT32 hash_id,
                                       ZXIC_UINT32 hash_table_width,
                                       ZXIC_UINT32 hash_key_size,
                                       ZXIC_UINT32 hash_table_id);

DPP_STATUS diag_dpp_se_sdt_tbl_prt_all(ZXIC_UINT32 dev_id);

DPP_STATUS diag_dpp_se_eram_sdt_tbl_wr(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 sdt_no,
                                       ZXIC_UINT32 eram_mode,
                                       ZXIC_UINT32 eram_base_addr,
                                       ZXIC_UINT32 eram_table_depth,
                                       ZXIC_UINT32 eram_clutch_en);

DPP_STATUS diag_dpp_se_smmu1_rd128_more(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 base_addr,
                                        ZXIC_UINT32 index,
                                        ZXIC_UINT32 number);

DPP_STATUS diag_dpp_se_smmu1_dir_tbl_data_wr256(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 tbl_id,
                                                ZXIC_UINT32 base_addr,
                                                ZXIC_UINT32 ecc_en,
                                                ZXIC_UINT32 index);

DPP_STATUS diag_dpp_se_fifo_depth_val_init_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡSE cacheͳϢ
* @param   dev_id       豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2024.5.8
************************************************************/
DPP_STATUS diag_se_smmu1_cnt_stat_cache_info(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡSEſ״̬
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/01/16
************************************************************/
DPP_STATUS diag_dpp_se_cfg_se_empty_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ʶȡSTAT_STAT_CFG_EPT_FLAGrĴ
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  10345337      @date  2023/09/19
************************************************************/
DPP_STATUS diag_dpp_stat_cfg_empty_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** eramɨ
* @param   dev_id       豸
* @param   start_index  ʼַ128bitΪλ
* @param   end_index    ַֹ128bitΪλ(õַ)
* @param   scan_mode    μDPP_DIAG_SCAN_MODE_E0-ʼ0ֵɨ裬1-дɨ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/01/26
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_scan(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 start_index,
                                  ZXIC_UINT32 end_index,
                                  ZXIC_UINT32 scan_mode);

/***********************************************************/
/** ERAMд128bit
* @param       dev_id             豸
* @param       base_addr          ַ
* @param       index              
* @param       data0              λ
* @param       data1              ݴθλ
* @param       data2              ݴελ
* @param       data3              λ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552        @date      2016/01/16
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_wr128(ZXIC_UINT32 dev_id,
                                   ZXIC_UINT32 base_addr,
                                   ZXIC_UINT32 index,
                                   ZXIC_UINT32 data0,
                                   ZXIC_UINT32 data1,
                                   ZXIC_UINT32 data2,
                                   ZXIC_UINT32 data3);

/***********************************************************/
/** ERAMд128bit
* @param      dev_id        豸
* @param      base_addr     ַ
* @param      index         ֵ
* @param      number        дݵĿ
* @param      data0         λ
* @param      data1         ݴθλ
* @param      data2         ݴελ
* @param      data3         λ
*
* @return      DPP_OK-ɹDPP_ERR-ʧ
* @remark      
* @see
* @author      ˶10181552            @date  2016/01/16
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_wr128_more(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 base_addr,
                                        ZXIC_UINT32 index,
                                        ZXIC_UINT32 number,
                                        ZXIC_UINT32 data0,
                                        ZXIC_UINT32 data1,
                                        ZXIC_UINT32 data2,
                                        ZXIC_UINT32 data3);

/***********************************************************/
/** ERAM128bit
* @param      dev_id          豸
* @param      base_addr       ַ
* @param      index           
*
* @return      DPP_OK-ɹDPP_ERR-ʧ
* @remark      
* @see
* @author      ˶10181552            @date  2016/01/16
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_rd128(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index);

/***********************************************************/
/** ERAMд64bit
* @param   dev_id       豸
* @param   base_addr    ַ
* @param   index        ֵ
* @param   data0        ݸλ
* @param   data1        ݵλ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/01/16
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_wr64(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 base_addr,
                                  ZXIC_UINT32 index,
                                  ZXIC_UINT32 data0,
                                  ZXIC_UINT32 data1);

/***********************************************************/
/** ERAM64bit
* @param       dev_id
* @param       base_addr
* @param       index
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552        @date      2016/01/16
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_rd64(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index);

/***********************************************************/
/** ERAMģʽ64bit
* @param   dev_id
* @param   base_addr
* @param   index
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/10/21
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_rd64_clear(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index);

/***********************************************************/
/** ERAM32bit
* @param   dev_id    豸
* @param   base_addr    ַ
* @param   index        ֵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/01/16
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_rd32(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index);


/** ERAMģʽ32bit
* @param   dev_id       豸
* @param   base_addr    ַ
* @param   index        ֵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/10/21
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_rd32_clear(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index);
/***********************************************************/
/** ERAM2bit
* @param   dev_id    豸
* @param   base_addr    ַ
* @param   index        ֵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  쳿      @date  2016/07/20
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_rd2(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index);

/***********************************************************/
/** ERAM1bit
* @param   dev_id    豸
* @param   base_addr    ַ
* @param   index        ֵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/01/16
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_rd1(ZXIC_UINT32 dev_id, ZXIC_UINT32 base_addr, ZXIC_UINT32 index);

/***********************************************************/
/** ӡplcreramģʽplcrblock0ʼռ
* @param   dev_id    豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2015/09/14
************************************************************/
    DPP_STATUS diag_dpp_se_smmu0_plcr_mono_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡDMA eramռַ
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/01/16
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_dma_baddr_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡodam LMļĻַ
* @param   dev_id    豸
* @param   no           ODMA LM ţȡֵ0~22
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  LMģVs->Port,Vp->Lsp,Vc->Pw,ְ󶨹ϵֱ
* @see
* @author  ˶10181552      @date  2015/09/14
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_odma_baddr_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 no);

/***********************************************************/
/** ӡ鲥Сַ128bitΪλ
* @param   dev_id    豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2015/09/14
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_mcast_baddr_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TDM鲥ƱĿ
* @param   dev_id           豸
* @param   group_id         ಥid
* @param   bitmap_dat0      bitmapݸ16bit(32~48bit)
* @param   bitmap_dat1      bitmapм32bit(0~31bit)
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2015/07/08
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_mcast_tdm_tbl_add(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 group_id,
                                               ZXIC_UINT16 bitmap_dat0,
                                               ZXIC_UINT32 bitmap_dat1);

/***********************************************************/
/** ݱ鲥ƱĿ
* @param   dev_id        豸
* @param   valid         Чλ
* @param   group_id      ಥid
* @param   mc_cnt        Ʒ16bit
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552        @date  2015/07/09
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_mcast_data_tbl_add(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT8 valid,
                                                ZXIC_UINT32 group_id,
                                                ZXIC_UINT16 mc_cnt);

/***********************************************************/
/** ӡ鲥
* @param   dev_id           豸
* @param   mc_tbl_type      鲥ͣ1-ݱı0-TDMıμSMMU0_MCAST_TBL_TYPE_E
* @param   group_id         id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552        @date  2015/09/14
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_mcast_tbl_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 mc_tbl_type, ZXIC_UINT32 group_id);

/***********************************************************/
/** eRamռ临λ
* @param   dev_id       豸
* @param   block_id     Ҫλblock id,0~19
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  쳿      @date  2016/10/24
************************************************************/
DPP_STATUS diag_dpp_se_smmu0_block_reset(ZXIC_UINT32 dev_id, ZXIC_UINT32 block_id);

/***********************************************************/
/** smmu1(ddr4ɨ)
* @param   dev_id          豸
* @param   start_bank_id   ʼbank id
* @param   end_bank_id     bank id
* @param   scan_mode       ɨͣDPP_DIAG_SCAN_MODE_E0-ʼ0ֵɨ裬1-дɨ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/01/27
* @modify  YXH               @date  2019/03/27
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_scan(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 start_bank_id,
                                  ZXIC_UINT32 end_bank_id,
                                  ZXIC_UINT32 scan_mode);

/***********************************************************/
/** Ƭֱӱд128bit
* @param   dev_id
* @param   tbl_id
* @param   baddr
* @param   index
* @param   data0
* @param   data1
* @param   data2
* @param   data3
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/05/27
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_dir_tbl_data_wr128(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 tbl_id,
                                                ZXIC_UINT32 baddr,
                                                ZXIC_UINT32 index,
                                                ZXIC_UINT32 data0,
                                                ZXIC_UINT32 data1,
                                                ZXIC_UINT32 data2,
                                                ZXIC_UINT32 data3);

/***********************************************************/
/** SMMU1дд128bitDDR  SMMU1_HBM_RW_128b
* @param       dev_id       豸
* @param       tabl_id      븴ϢͨӦ
* @param       base_addr    ַ
* @param       index        
* @param       data0        λ 32/64/128bit
* @param       data1        ݴθλ
* @param       data2        ݴελ
* @param       data3        λ
* @param       num          Ŀ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xcx         @date  2017/04/10
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_dir_tbl_data_wr128_more(ZXIC_UINT32 dev_id,
                                                     ZXIC_UINT32 tabl_id,
                                                     ZXIC_UINT32 base_addr,
                                                     ZXIC_UINT32 index,
                                                     ZXIC_UINT32 data0,
                                                     ZXIC_UINT32 data1,
                                                     ZXIC_UINT32 data2,
                                                     ZXIC_UINT32 data3,
                                                     ZXIC_UINT32 num);

/***********************************************************/
/** дDDR 256bitݵֵ
* @param   data0          λ
* @param   data1          ݴθλ
* @param   data2          
* @param   data3          
* @param   data4          
* @param   data5          
* @param   data6          ݴελ
* @param   data7          λ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  XCX         @date  2017/03/20
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_dir_tbl_data_wr256_dat(ZXIC_UINT32 data0,
                                                    ZXIC_UINT32 data1,
                                                    ZXIC_UINT32 data2,
                                                    ZXIC_UINT32 data3,
                                                    ZXIC_UINT32 data4,
                                                    ZXIC_UINT32 data5,
                                                    ZXIC_UINT32 data6,
                                                    ZXIC_UINT32 data7);

/***********************************************************/
/** SMMU1дд256bitDDR
* @param   dev_id         豸
* @param   tabl_id
* @param   base_addr      ַ
* @param   ecc_en         Ƿeccʹ
* @param   index          
* @param   num            
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  xcx               @date 20170318
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_dir_tbl_data_wr256_more(ZXIC_UINT32 dev_id,
                                                     ZXIC_UINT32 tbl_id,
                                                     ZXIC_UINT32 base_addr,
                                                     ZXIC_UINT32 ecc_en,
                                                     ZXIC_UINT32 index,
                                                     ZXIC_UINT32 num);


DPP_STATUS diag_dpp_se_smmu1_dir_tbl_data_wr512_pre(ZXIC_UINT32 data0,
                                                    ZXIC_UINT32 data1,
                                                    ZXIC_UINT32 data2,
                                                    ZXIC_UINT32 data3,
                                                    ZXIC_UINT32 data4,
                                                    ZXIC_UINT32 data5,
                                                    ZXIC_UINT32 data6,
                                                    ZXIC_UINT32 data7,
                                                    ZXIC_UINT32 data8,
                                                    ZXIC_UINT32 data9);

/***********************************************************/
/** SMMU1дд뵥512bitDDR
* @param   dev_id       豸
* @param   tbl_id
* @param   base_addr    ַ 2k*256bitΪλ
* @param   ecc_en       Ƿeccʹ
* @param   index         λΪλ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xcx          @date 2017/03/18
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_dir_tbl_data_wr512(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 tbl_id,
                                                ZXIC_UINT32 base_addr,
                                                ZXIC_UINT32 ecc_en,
                                                ZXIC_UINT32 index,
                                                ZXIC_UINT32 data10,
                                                ZXIC_UINT32 data11,
                                                ZXIC_UINT32 data12,
                                                ZXIC_UINT32 data13,
                                                ZXIC_UINT32 data14,
                                                ZXIC_UINT32 data15);

/***********************************************************/
/** SMMU1ӡǰcachʹֹܽ״̬
* @param
* @param
* @param
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xcx      @date  20160907
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_cache_en_cfg_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** SMMU1ӡǰcacheҵcacheʹλ״̬
* @param   dev_id       豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xcx      @date  20160907
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_ser_cache_en_cfg_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡhashӲѧϰдDDRռ
* @param   dev_id       豸
* @param   hash_id      hash棬ȡֵΧ[0~3]
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/01/19
************************************************************/
DPP_STATUS diag_dpp_se_as_hash_learn_cfg_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 hash_id);

DPP_STATUS diag_dpp_se_cmmu_ddr_read(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 base_addr,
                                     ZXIC_UINT32 rd_mode,
                                     CMMU_RD_CLR_MODE_E clr_mode,
                                     ZXIC_UINT32 index);

/***********************************************************/
/** дhashsdt
* @param      dev_id                豸
* @param      hash_id               hashid
* @param      hash_table_width hash 洢λμDPP_DIAG_HASH_KEY_WIDTH_E
* @param      key_size              hash ֵȣֽΪλ
* @param      hash_table_id         hash ߼
* @param      learn_en              Ӳѧϰʹ
* @param      keep_alive            ־ʹ
* @param      keep_alive_baddr      ־ַ
* @param      rsp_mode              λ,μDPP_DIAG_HASH_RSP_MODE_E
* @param      hash_clutch_en        ץʹ
*
* @return      DPP_OK-ɹDPP_ERR-ʧ
* @remark      
* @see
* @author      ls            @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_kschd_hash_sdt_tbl_wr(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 hash_id,
                                             ZXIC_UINT32 hash_table_width,
                                             ZXIC_UINT32 hash_key_size,
                                             ZXIC_UINT32 hash_table_id,
                                             ZXIC_UINT32 learn_en,
                                             ZXIC_UINT32 keep_alive,
                                             ZXIC_UINT32 keep_alive_baddr,
                                             ZXIC_UINT32 rsp_mode,
                                             ZXIC_UINT32 hash_clutch_en);

 DPP_STATUS diag_dpp_se_kschd_hash_sdt_prt(ZXIC_UINT32 dev_id);

 /***********************************************************/
 /** hash ҵͨHash KeyļֵƥϢĸ9λ
 * @param      dev_id
 * @param      data0
 * @param      data1
 * @param      data2
 * @param      data3
 * @param      data4
 * @param      data5
 * @param      data6
 * @param      data7
 * @param      data8
 *
 * @return      DPP_OK-ɹDPP_ERR-ʧ
 * @remark      
 * @see
 * @author      ˶10181552            @date  2016/03/09
 ************************************************************/
 DPP_STATUS diag_dpp_se_kscdh_hash_key_set_high(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 data0,
                                                ZXIC_UINT32 data1,
                                                ZXIC_UINT32 data2,
                                                ZXIC_UINT32 data3,
                                                ZXIC_UINT32 data4,
                                                ZXIC_UINT32 data5,
                                                ZXIC_UINT32 data6,
                                                ZXIC_UINT32 data7,
                                                ZXIC_UINT32 data8);

/***********************************************************/
/**  hash ҵͨHash KeyļֵƥϢĵ7λ
* @param   dev_id
* @param   data9
* @param   data10
* @param   data11
* @param   data12
* @param   data13
* @param   data14
* @param   data15
* @param   delete_en
* @param   dma_en       дʹܱ־λ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552         @date  2016/03/09
************************************************************/
DPP_STATUS diag_dpp_se_kschd_hash_key_set_low(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 data9,
                                              ZXIC_UINT32 data10,
                                              ZXIC_UINT32 data11,
                                              ZXIC_UINT32 data12,
                                              ZXIC_UINT32 data13,
                                              ZXIC_UINT32 data14,
                                              ZXIC_UINT32 data15,
                                              ZXIC_UINT32 delete_en,
                                              ZXIC_UINT32 dma_en);

DPP_STATUS diag_dpp_se_etcam_add_pre_value0(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 mask_or_data,
                                            ZXIC_UINT32 data0,
                                            ZXIC_UINT32 data1,
                                            ZXIC_UINT32 data2,
                                            ZXIC_UINT32 data3,
                                            ZXIC_UINT32 data4,
                                            ZXIC_UINT32 data5,
                                            ZXIC_UINT32 data6,
                                            ZXIC_UINT32 data7);

DPP_STATUS diag_dpp_se_etcam_add_pre_value1(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 mask_or_data,
                                            ZXIC_UINT32 data8,
                                            ZXIC_UINT32 data9,
                                            ZXIC_UINT32 data10,
                                            ZXIC_UINT32 data11,
                                            ZXIC_UINT32 data12,
                                            ZXIC_UINT32 data13,
                                            ZXIC_UINT32 data14,
                                            ZXIC_UINT32 data15);

DPP_STATUS diag_dpp_se_etcam_add_pre_value2(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 mask_or_data,
                                            ZXIC_UINT32 data16,
                                            ZXIC_UINT32 data17,
                                            ZXIC_UINT32 data18,
                                            ZXIC_UINT32 data19);

/***********************************************************/
/** eTcamĿ

* @param       dev_id
* @param       table_id
* @param       mode
* @param       index
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wyt        @date  2017/12/06
************************************************************/
DPP_STATUS diag_dpp_se_etcam_add(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 tbl_id,
                                 ZXIC_UINT32 mode,
                                 ZXIC_UINT32 index);

DPP_STATUS diag_dpp_se_etcam_block_full_add(ZXIC_UINT32 dev_id, ZXIC_UINT16 block_id);

DPP_STATUS diag_dpp_se_etcam_block_entry_add_80(ZXIC_UINT32 dev_id, ZXIC_UINT16 block_id, ZXIC_UINT32 entry_num);
DPP_STATUS diag_dpp_se_etcam_block_entry_add_160(ZXIC_UINT32 dev_id, ZXIC_UINT16 block_id, ZXIC_UINT32 entry_num);
DPP_STATUS diag_dpp_se_etcam_block_entry_add_320(ZXIC_UINT32 dev_id, ZXIC_UINT16 block_id, ZXIC_UINT32 entry_num);
DPP_STATUS diag_dpp_se_etcam_block_entry_add_640(ZXIC_UINT32 dev_id, ZXIC_UINT16 block_id, ZXIC_UINT32 entry_num);
/***********************************************************/
/** ӡetcam blockӦ table id
* @param   dev_id       豸
* @param   block_idx    block Χ[0~15]
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_etcam_block_tbl_id_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 block_idx);

/***********************************************************/
/** ӡ block Ļַ7bit
* @param   dev_id        豸
* @param   block_idx     block
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_etcam_block_baddr_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 block_idx);

/***********************************************************/
/** ӡetcam бblockռ״̬
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_etcam_table_block_all_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡeTcamblockڵӲĿ
* @param   dev_id     豸
* @param   block_idx  blockΧ0~7
* @param   index      ҵĿڵǰblockе
* @param   mode       ֵλģʽȡֵ DPP_ETCAM_ENTRY_MODE_E Ķ
* @param   opr_type   ȡͣȡֵ DPP_ETCAM_OPR_TYPE_E Ķ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_etcam_entry_prt(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 block_idx,
                                       ZXIC_UINT32 index,
                                       ZXIC_UINT32 mode,
                                       ZXIC_UINT32 opr_type);

/***********************************************************/
/** ȡetcam(table_idindex)
* @param   dev_id       豸
* @param   table_id     
* @param   table_index  
* @param   mode         ֵλģʽȡֵDPP_ETCAM_ENTRY_MODE_EĶ
* @param   opr_type     ȡͣȡֵDPP_ETCAM_OPR_TYPE_EĶ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_etcam_tbl_entry_prt(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 table_id,
                                           ZXIC_UINT32 table_index,
                                           ZXIC_UINT32 mode,
                                           ZXIC_UINT32 opr_type);

/***********************************************************/
/** ӡsdt
* @param   dev_id         豸
* @param   sdt_no         sdt
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  󲻻
* @see
* @author  ˶10181552        @date  2016/01/21
************************************************************/
DPP_STATUS diag_dpp_se_sdt_tbl_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no);

/***********************************************************/
/** ʹӡSDTϢ
* @param   dev_id    豸
* @param   tbl_type  ͣ DPP_SDT_TABLE_TYPE_E
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wll        @date  2019/11/12
************************************************************/
DPP_STATUS diag_dpp_se_sdt_tbl_prt_type(ZXIC_UINT32 dev_id, ZXIC_UINT32 table_type);

/***********************************************************/
/** дlpm sdtϢ
* @param   dev_id           豸
* @param   sdt_no           sdt
* @param   lpm_v46_id       ipv4/ipv6־1-ipv40-ipv6
* @param   rsp_mode         ֱӱλ01-64bit10-128bit11-256bit
* @param   lpm_table_depth; ȣԽ
* @param   lpm_clutch_en;   ץʹ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_lpm_sdt_tbl_wr(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 sdt_no,
                                      ZXIC_UINT32 lpm_v46_id,
                                      ZXIC_UINT32 rsp_mode,
                                      ZXIC_UINT32 lpm_table_depth,
                                      ZXIC_UINT32 lpm_clutch_en);

/***********************************************************/
/** дetcam sdtϢ(ץ)
* @param       dev_id                     豸
* @param       sdt_no                     sdt
* @param       etcam_key_mode             etcamֵ 0-640bit1-320bit2-160bit3-80bit
* @param       etcam_table_id             etcamţ֧8
* @param       no_as_rsp_mode;            handleģʽλ,μDPP_DIAG_ETCAM_NO_AS_RSP_MODE_E
* @param       as_en;                     eramʹ
* @param       as_eram_baddr;             eramַ
* @param       as_rsp_mode;               λμDPP_DIAG_ERAM_MODE_E
* @param       etcam_table_depth;         ȣԽ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls        @date      2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_etcam_sdt_tbl_wr(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 sdt_no,
                                        ZXIC_UINT32 etcam_key_mode,
                                        ZXIC_UINT32 etcam_table_id,
                                        ZXIC_UINT32 no_as_rsp_mode,
                                        ZXIC_UINT32 as_en,
                                        ZXIC_UINT32 as_eram_baddr,
                                        ZXIC_UINT32 as_rsp_mode,
                                        ZXIC_UINT32 etcam_table_depth);

/***********************************************************/
/** portsdtϢ
* @param       dev_id                     豸
* @param       sdt_no                     sdt
* @param       porttbl_clutch_en          ץʹ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls        @date      2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_porttbl_sdt_tbl_wr(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 sdt_no,
                                          ZXIC_UINT32 porttbl_clutch_en);

/***********************************************************/
/** ɾsdt
* @param   dev_id            豸
* @param   sdt_no            sdt
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls         @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_se_sdt_tbl_del(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no);

/***********************************************************/
/** ɾָΧsdt
* @param   dev_id       豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cq      @date  2024/05/09
************************************************************/
DPP_STATUS diag_dpp_se_sdt_tbl_del_range(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_begin,ZXIC_UINT32 sdt_end);

DPP_STATUS diag_dpp_se_hash_insert512_pre(ZXIC_UINT32 key0,
                                          ZXIC_UINT32 key1,
                                          ZXIC_UINT32 key2,
                                          ZXIC_UINT32 key3,
                                          ZXIC_UINT32 key4,
                                          ZXIC_UINT32 key5,
                                          ZXIC_UINT32 key6,
                                          ZXIC_UINT32 key7);

/***********************************************************/
/** hashֵ
* @param   hash_id       
* @param   tbl_id        
* @param   result0
* @param   result1
* @param   result2
* @param   result3
* @param   result4
* @param   result5
* @param   result6
* @param   result7
*
* @return
* @remark  
* @see
* @author  yxh      @date  2018/07/21
************************************************************/
DPP_STATUS diag_dpp_se_hash_insert512(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 hash_id,
                                      ZXIC_UINT32 tbl_id,
                                      ZXIC_UINT32 result0,
                                      ZXIC_UINT32 result1,
                                      ZXIC_UINT32 result2,
                                      ZXIC_UINT32 result3,
                                      ZXIC_UINT32 result4,
                                      ZXIC_UINT32 result5,
                                      ZXIC_UINT32 result6,
                                      ZXIC_UINT32 result7);

/***********************************************************/
/** ݼֵӡddrе洢Ŀ
* @param       baddr              ַ
* @param       item_num           
* @param       width_mode         DDR3洢λ
* @param       input0             ֵλ
* @param       input1             ֵθλ
* @param       input2             ֵελ
* @param       input3             ֵλ
* @param       table_id           ҵ
* @param       actu_key_size      ֵЧ: 8bit*NN=1~48(֧1~16)
* @param       hash_arg           hash CRC ʽ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  tf              @date      2016/06/8
************************************************************/
DPP_STATUS diag_dpp_se_hash_ddr_item_prt(ZXIC_UINT32 baddr,
                                         ZXIC_UINT32 item_num,
                                         DPP_HASH_DDR_WIDTH_MODE width_mode,
                                         ZXIC_UINT32 input0,
                                         ZXIC_UINT32 input1,
                                         ZXIC_UINT32 input2,
                                         ZXIC_UINT32 input3,
                                         ZXIC_UINT32 table_id,
                                         ZXIC_UINT32 actu_key_size,
                                         ZXIC_UINT32 hash_arg);

/***********************************************************/
/** ݼֵ洢Ŀ
* @param   dev_id            豸
* @param   hash_id           
* @param   tbl_id            ҵ
* @param   input0            ֵλ(΢еkey˳ͬ)
* @param   input1            ֵθλ
* @param   input2            ֵελ
* @param   input3            ֵλ
* @param   input4            ֵελ
* @param   input5            ֵλ
* @param   hdw_flag            0-soft, 1-hardware
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  YXH         @date  2019/02/22
************************************************************/
DPP_STATUS diag_dpp_se_hash_search(ZXIC_UINT32 dev_id,
                                   ZXIC_UINT32 hash_id,
                                   ZXIC_UINT32 tbl_id,
                                   ZXIC_UINT32 input0,
                                   ZXIC_UINT32 input1,
                                   ZXIC_UINT32 input2,
                                   ZXIC_UINT32 input3,
                                   ZXIC_UINT32 input4,
                                   ZXIC_UINT32 input5,
                                   ZXIC_UINT32 hdw_flag);

/***********************************************************/
/** ӡhash Ӳȡ
* @param       dev_id         豸
* @param       hash_id        hash
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xcx        @date  2017/09/18
************************************************************/
DPP_STATUS diag_dpp_se_hash_cfg_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 hash_id, ZXIC_UINT32 bulk_id);

/***********************************************************/
/** ӡָhashָbulk Ӳȡ
* @param       dev_id         豸
* @param       hash_id        hash
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cq        @date  2024/03/16
************************************************************/
DPP_STATUS diag_dpp_se_hash_cfg_ex_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 hash_id, ZXIC_UINT32 bulk_id);

/***********************************************************/
/** ӡLPM Ӳȡ
* @param   dev_id       豸
* @param   v4v6_flag    0-v4 1-v6
* @param   table_id     eRAMʱʹ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cq      @date  2024/05/17
************************************************************/
DPP_STATUS diag_dpp_se_lpm_cfg_ex_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 v4v6_flag, ZXIC_UINT32 table_id);

/***********************************************************/
/** lpm
* @param   dev_id       豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cq      @date  2024/05/17
************************************************************/
DPP_STATUS diag_dpp_se_lpm_cfg_clr(ZXIC_UINT32 dev_id);

/***********************************************************/
/** hashеԴ
* @param   dev_id       豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cq      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_se_hash_cfg_clr(ZXIC_UINT32 dev_id);

/***********************************************************/
/** zcamȫռ
* @param
* @param
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author
************************************************************/
DPP_STATUS diag_dpp_hash_zcam_clr(ZXIC_UINT32 dev_id);

/***********************************************************/
/** LPM
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xcx     @date  2019/03/21
************************************************************/
DPP_STATUS diag_dpp_se_lpm_search(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 v4v6_flag,
                                  ZXIC_UINT32 vpn_id,
                                  ZXIC_UINT32 ip0,
                                  ZXIC_UINT32 ip1,
                                  ZXIC_UINT32 ip2,
                                  ZXIC_UINT32 ip3,
                                  ZXIC_UINT32 mask_len,
                                  ZXIC_UINT32 hdw_flag);

/***********************************************************/
/** ӡLPM Ӳȡ
* @param   dev_id       豸
* @param   v4v6_flag    0-v4 1-v6
* @param   table_id     eRAMʱʹ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  xcx      @date  2017/10/17
************************************************************/
DPP_STATUS diag_dpp_se_lpm_cfg_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 v4v6_flag, ZXIC_UINT32 table_id);

DPP_STATUS diag_dpp_se_alg_read512(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr);

/***********************************************************/
/** zcamһzblock ȫ
* @param   dev_id      豸
* @param   zgroup_id   (0-3)
* @param   zblock_id   zblk(0-5)
*
* @return
* @remark  
* @see
* @author  yxh      @date  2018/07/07
************************************************************/
DPP_STATUS diag_dpp_se_alg_read_zblock(ZXIC_UINT32 dev_id, ZXIC_UINT32 zgroup_id, ZXIC_UINT32 zblock_id);

/***********************************************************/
/**
* @param   dev_id       豸
* @param   addr         ZCAMַ
* @param   data0        512bit32bit
* @param   data1        512bit32bit
*
* @return
* @remark  
* @see
* @author  yxh      @date  2018/07/10
************************************************************/
DPP_STATUS diag_dpp_se_alg_write512(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 addr,
                                    ZXIC_UINT32 data0,
                                    ZXIC_UINT32 data1);

/***********************************************************/
/**
* @param   dev_id 豸
* @param   data0       512bit32bit
* @param   data1       512bit[479:448]bit
* @param   data2       512bit[447:416]bit
* @param   data3       512bit[415:384]bit
* @param   data4       512bit[383:352]bit
* @param   data5       512bit[351:320]bit
* @param   data6       512bit[319:288]bit
* @param   data7       512bit[287:256]bit
*
* @return
* @remark  
* @see
* @author  yxh            @date  2018/07/10
************************************************************/
DPP_STATUS diag_dpp_se_alg_write512_pre_ex(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 data0,
                                           ZXIC_UINT32 data1,
                                           ZXIC_UINT32 data2,
                                           ZXIC_UINT32 data3,
                                           ZXIC_UINT32 data4,
                                           ZXIC_UINT32 data5,
                                           ZXIC_UINT32 data6,
                                           ZXIC_UINT32 data7);

/***********************************************************/
/** дȫ512bitֵַ
* @param   dev_id         豸
* @param   addr           ַ
* @param   data8          512bit[255:224]bit
* @param   data9          512bit[223:192]bit
* @param   data10         512bit[191:160]bit
* @param   data11         512bit[159:128]bit
* @param   data12         512bit[127:96]bit
* @param   data13         512bit[95:64]bit
* @param   data14         512bit[63:32]bit
* @param   data15         512bit32bit
*
* @return
* @remark  
* @see
* @author  yxh         @date  2018/07/10
************************************************************/
DPP_STATUS diag_dpp_se_alg_write512_ex(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 addr,
                                       ZXIC_UINT32 data0,
                                       ZXIC_UINT32 data1,
                                       ZXIC_UINT32 data2,
                                       ZXIC_UINT32 data3,
                                       ZXIC_UINT32 data4,
                                       ZXIC_UINT32 data5,
                                       ZXIC_UINT32 data6,
                                       ZXIC_UINT32 data7);

/***********************************************************/
/** zcamеַǷɶ
* @param       dev_id
* @param       zgroup_id
*
* @return
* @remark  
* @see
* @author  yxh        @date  2018/07/10
************************************************************/
DPP_STATUS diag_dpp_se_zgroup_check_rd_only(ZXIC_UINT32 dev_id, ZXIC_UINT32 zgroup_id);

/***********************************************************/
/** zgroupеַдǷ
* @param   dev_id     豸
* @param   mode       (0-3:д̶ֵ4:дֵ, 5:дַ)
* @param   zgroup_id  (0-3)
*
* @return
* @remark  
* @see
* @author  yxh      @date  2018/03/06
************************************************************/
DPP_STATUS diag_dpp_se_zgroup_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 zgroup_id);

/***********************************************************/
/** hashָbulkڴ
* @param   dev_id     豸
* @param   fun_id     hash 0~3
* @param   bulk_id    0~7
*
* @return
* @remark  
* @see
* @author  cq      @date  2023/07/28
************************************************************/
DPP_STATUS diag_dpp_hash_specify_res_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 fun_id,ZXIC_UINT32 bulk_id);

/***********************************************************/
/** se smmu0(ERAM) ģ鳣úб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/02/03
************************************************************/
DPP_STATUS dpp_se_smmu0_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** se smmu1(DDR3) ģ鳣úб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/02/03
************************************************************/
DPP_STATUS dpp_se_smmu1_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** se asģ鳣úб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/02/03
************************************************************/
DPP_STATUS dpp_se_as_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** se cmmuģ鳣úб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/02/03
************************************************************/
DPP_STATUS dpp_se_cmmu_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** se etcamģ鳣úб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/02/03
************************************************************/
DPP_STATUS dpp_se_etcam_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** se ALGģ鳣úб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/02/03
************************************************************/
DPP_STATUS dpp_se_alg_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** SDTúб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/02/03
************************************************************/
DPP_STATUS dpp_se_sdt_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** se Լúб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/02/03
************************************************************/
DPP_STATUS dpp_se_dbg_cnt_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/**  se жϳúб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/02/03
************************************************************/
DPP_STATUS dpp_se_int_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** SE ģ鳣úб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/02/03
************************************************************/
DPP_STATUS dpp_se_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 256 DDR
* @param   dev_id
* @param   baddr
* @param   index
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/05/27
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_dir_tbl_data_rd256(ZXIC_UINT32 dev_id, ZXIC_UINT32 baddr, ZXIC_UINT32 index);

/***********************************************************/
/** 512 DDR
* @param   dev_id
* @param   baddr
* @param   index
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  chenqin00181032      @date  2022/10/24
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_dir_tbl_data_rd512(ZXIC_UINT32 dev_id, ZXIC_UINT32 baddr, ZXIC_UINT32 index);

/***********************************************************/
/** дeramֱӱĿ
* @param   dev_id        豸
* @param   sdt_no        sdtţ0-255
* @param   index         ĿsdtϢеλΪλ
* @param   number        дĿ
* @param   data0         ݣ1/2/4/8/16/32bitλֻʹdata0еĶӦbitλ64/128bitʱΪλ
* @param   data1         ݣ64bitλʱʹdata0data1data0Ǹλ128bitʱΪݴθλ
* @param   data2         ݣ128bitʱݴελ
* @param   data3         , 128bitʱλ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  lim       @date  2020/06/02
************************************************************/
DPP_STATUS diag_dpp_se_eram_dir_wr_more(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 sdt_no,
                                        ZXIC_UINT32 index,
                                        ZXIC_UINT32 number,
                                        ZXIC_UINT32 data0,
                                        ZXIC_UINT32 data1,
                                        ZXIC_UINT32 data2,
                                        ZXIC_UINT32 data3);

/***********************************************************/
/** дeramֱӱĿ(빦)
* @param   data        
* @param   mask      
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wzz       @date  2020/10/27
************************************************************/
DPP_STATUS diag_dpp_se_eram_dir_wr_dat(ZXIC_UINT32 data0,
                                       ZXIC_UINT32 data1,
                                       ZXIC_UINT32 data2,
                                       ZXIC_UINT32 data3,
                                       ZXIC_UINT32 mask0,
                                       ZXIC_UINT32 mask1,
                                       ZXIC_UINT32 mask2,
                                       ZXIC_UINT32 mask3);

/***********************************************************/
/** дeramֱӱĿ(빦)
* @param   dev_id        豸
* @param   sdt_no        sdtţ0-255
* @param   index         ĿsdtϢеλΪλ
* @param   number        дĿ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  lim       @date  2020/06/02
************************************************************/
DPP_STATUS diag_dpp_se_eram_dir_wr_more_mask(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 sdt_no,
                                             ZXIC_UINT32 index,
                                             ZXIC_UINT32 number);

/***********************************************************/
/** eramֱӱĿ
* @param   dev_id        豸
* @param   sdt_no        sdtţ0-255
* @param   index         ĿsdtϢеλΪλ
* @param   number        Ŀ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  lim       @date  2020/06/02
************************************************************/
DPP_STATUS diag_dpp_se_eram_dir_rd_more(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 sdt_no,
                                        ZXIC_UINT32 index,
                                        ZXIC_UINT32 number);

/***********************************************************/
/** ddrֱӱĿ
* @param   dev_id        豸
* @param   sdt_no        sdtţ0-255
* @param   index         ĿsdtϢеλΪλ
* @param   number        Ŀ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  lim       @date  2020/06/02
************************************************************/
DPP_STATUS diag_dpp_se_ddr_dir_rd_more(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 sdt_no,
                                       ZXIC_UINT32 index,
                                       ZXIC_UINT32 number);

/***********************************************************/
/** ȡtlbĴϢ
* @param   dev_id     豸
* @param   entry_id   ʵid
*
* @return
* @remark  
* @see
* @author        @date  2023/05/09
************************************************************/
DPP_STATUS diag_dpp_tlb_entry_cfg_prt(ZXIC_UINT32 dev_id,ZXIC_UINT32 entry_id);

/***********************************************************/
/** ȡȫּĴϢ
* @param   dev_id     豸
*
* @return
* @remark  
* @see
* @author        @date  2023/05/09
************************************************************/
DPP_STATUS diag_dpp_tlb_global_cfg_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ȡõַ
* @param   dev_id     豸
*
* @return
* @remark  
* @see
* @author        @date  2023/05/09
************************************************************/
DPP_STATUS diag_dpp_tlb_pa_va_swit_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ȡõַ
* @param   dev_id     豸
*
* @return
* @remark  
* @see
* @author        @date  2023/05/09
************************************************************/
DPP_STATUS diag_dpp_tlb_va_pa_swit_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ȡתַ
* @param   dev_id     豸
*
* @return
* @remark  
* @see
* @author        @date  2023/05/09
************************************************************/
DPP_STATUS diag_dpp_va_pa_swit_out_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ȡתַ
* @param   dev_id     豸
*
* @return
* @remark  
* @see
* @author        @date  2023/05/09
************************************************************/
DPP_STATUS diag_dpp_pa_va_swit_out_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** tlbʵĴϢ
* @param   dev_id
* @param   entry_id
* @param   flag   bit0:entry_valid ,bit1:wr_valid, bit2:rd_valid
* @param   mask
* @param   va_baddr
* @param   pa_baddr
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2023/05/19
************************************************************/
DPP_STATUS diag_dpp_tlb_entry_cfg_pre(ZXIC_UINT32 mask_h,
                                        ZXIC_UINT32 mask_l,
                                        ZXIC_UINT32 va_h, 
                                        ZXIC_UINT32 va_l, 
                                        ZXIC_UINT32 pa_h2,
                                        ZXIC_UINT32 pa_h1,
                                        ZXIC_UINT32 pa_h0,
                                        ZXIC_UINT32 pa_l);
DPP_STATUS diag_dpp_tlb_entry_cfg_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 entry_id, 
                                        ZXIC_UINT32 valid,
                                        ZXIC_UINT32 wr_valid,
                                        ZXIC_UINT32 rd_valid);

/***********************************************************/
/** tlbȫּĴϢ
* @param   dev_id
* @param   entry_id
* @param   flag   bit0:map_en ,bit1:int_en, bit2:tlb_en bit3:op_con_open bit4:output_sel bit5:regslice_en
* @param   int_mode
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2023/05/09
************************************************************/
DPP_STATUS diag_dpp_tlb_global_cfg_set(ZXIC_UINT32 dev_id, 
                                        ZXIC_UINT32 flag,
                                        ZXIC_UINT32 int_mode);

/***********************************************************/
/** ӡͳ
* @param   dev_id     豸
* @param   hash_id    hash0~3
* @return
* @remark  
* @see
* @author        @date  2023/10/10
************************************************************/
DPP_STATUS diag_dpp_se_hash_stat_prt(ZXIC_UINT32 dev_id,ZXIC_UINT32 hash_id);

/***********************************************************/
/** ձͳ
* @param   dev_id     豸
* @param   hash_id    hash0~3
* @return
* @remark  
* @see
* @author        @date  2023/10/10
************************************************************/
DPP_STATUS diag_dpp_se_hash_stat_clr(ZXIC_UINT32 dev_id,ZXIC_UINT32 hash_id);

/***********************************************************/
/** ӡzblk״̬
* @param   dev_id     豸
* @param   zblk_idx    zblk_idx
* @return
* @remark  
* @see
* @author        @date  2023/10/10
************************************************************/
DPP_STATUS diag_dpp_se_zblk_serv_cfg_prt(ZXIC_UINT32 dev_id,ZXIC_UINT32 zblk_idx);

/***********************************************************/
/** ӡȡddr flush done״̬
* @param   dev_id     豸
* @param   zblk_idx    zblk_idx
* @return
* @remark  
* @see
* @author        @date  2023/10/10
************************************************************/
DPP_STATUS diag_dpp_se_rd_done_period_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡeramȫԴ
* @param  dev_id    豸
* @param  type    ԴDPP_SE_RES_TYPE_E
* @return
* @remark  
* @see
* @author        @date  2023/10/10
************************************************************/
DPP_STATUS diag_dpp_se_eram_res_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** ӡhashȫԴ
* @param  dev_id    豸
* @param  type    ԴDPP_SE_RES_TYPE_E
* @return
* @remark  
* @see
* @author        @date  2023/10/10
************************************************************/
DPP_STATUS diag_dpp_se_hash_res_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** ӡddrȫԴ
* @param  dev_id    豸
* @param  type    ԴDPP_SE_RES_TYPE_E
* @return
* @remark  
* @see
* @author        @date  2023/10/10
************************************************************/
DPP_STATUS diag_dpp_se_ddr_res_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** ӡaclȫԴ
* @param  dev_id    豸
* @param  type    ԴDPP_SE_RES_TYPE_E
* @return
* @remark  
* @see
* @author        @date  2023/10/10
************************************************************/
DPP_STATUS diag_dpp_se_acl_res_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** ӡlpmȫԴ
* @param  dev_id    豸
* @return
* @remark  
* @see
* @author        @date  2023/10/10
************************************************************/
DPP_STATUS diag_dpp_se_lpm_res_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** ӡstatȫԴ
* @param  dev_id    豸
* @return
* @remark  
* @see
* @author        @date  2023/10/10
************************************************************/
DPP_STATUS diag_dpp_se_stat_res_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

ZXIC_VOID diag_dpp_dtb_se_hash_get_data(ZXIC_UINT32 input0,
                                   ZXIC_UINT32 input1,
                                   ZXIC_UINT32 input2,
                                   ZXIC_UINT32 input3,
                                   ZXIC_UINT32 input4,
                                   ZXIC_UINT32 input5);
DPP_STATUS diag_dpp_dtb_se_hash_get(ZXIC_UINT32 dev_id,
                                   ZXIC_UINT32 sdt_no,
                                   ZXIC_UINT32 queue_id,
                                   ZXIC_UINT32 input0,
                                   ZXIC_UINT32 input1,
                                   ZXIC_UINT32 input2,
                                   ZXIC_UINT32 input3,
                                   ZXIC_UINT32 input4,
                                   ZXIC_UINT32 input5,
                                   ZXIC_UINT32 hdw_flag);

/***********************************************************/
/** ӡhash
* @param  dev_id    豸
* @return
* @remark  
* @see
* @author        @date  2023/10/10
************************************************************/
DPP_STATUS diag_dpp_se_sdt_partner_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no);
/***********************************************************/
/** ӡĴʹܱʶ
* @param  
* @return
* @remark  
* @see
* @author        @date  2024/04/03
************************************************************/
ZXIC_VOID diag_dpp_reg_filter_en_prt(ZXIC_VOID);

/***********************************************************/
/** ӡǰĴ˱ʶ
* @param  
* @return
* @remark  
* @see
* @author        @date  2024/04/03
************************************************************/
ZXIC_VOID diag_dpp_reg_filter_flag_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no);

/***********************************************************/
/** ӡlpmжرʶ
* @param  
* @return
* @remark  
* @see
* @author        @date  2024/07/23
************************************************************/
ZXIC_VOID diag_dpp_lpm_uninstall_flag_prt(ZXIC_VOID);

/***********************************************************/
/** ӡstat_mode ͳģʽ
* @param  
* @return
* @remark  
* @see
* @author        @date  2024/07/23
************************************************************/
DPP_STATUS diag_dpp_se_smmu1_stat_mode_cfg_prt(ZXIC_UINT32 dev_id);

#ifdef __cplusplus
}
#endif

#endif
