/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : zxic_slt.h
* ļʶ : 
* ժҪ : 
* ˵ : 
* ǰ汾 : 
*      : PJ
*  : 2022/03/26
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef __ZXIC_SLT_H__
#define __ZXIC_SLT_H__

#ifdef __cplusplus
extern "C" {
#endif


#define ZXIC_SLT_CASE_PASS                        (0U)
#define ZXIC_SLT_CASE_FAILURE                     (1U)

#define ZXIC_SLT_ERR_INFO_LEN                     (255U)
#define ZXIC_SLT_CASE_MAX_NUM                     (255U)
#define ZXIC_SLT_DEV_ID_MAX_NUM                   (16U)
#define ZXIC_SLT_CHIP_ID_LEN                      (3U)

/* װͣͬƷ岻ͬʱ֧5*/
#define ZXIC_SLT_MAX_ENCAP                        (5U)


/* BIN_CODE */
#define ZXIC_SLT_BIN_CODE_PASS                    ZXIC_SLT_CASE_PASS
#define ZXIC_SLT_BIN_CODE_SERDES_FAIL             (1U)/* sredes*/
#define ZXIC_SLT_BIN_CODE_FLOW_FAIL               (2U)/* pvt FLOWͨ*/
#define ZXIC_SLT_BIN_CODE_RAM_FAIL                (3U)/* RAM*/
#define ZXIC_SLT_BIN_CODE_HBM_DDR_FAIL            (4U)/* hbm*/
#define ZXIC_SLT_BIN_CODE_OTHER_FAIL              (5U)/* PLL EFUSE PCIE RISCV */
#define ZXIC_SLT_BIN_CODE_MIX_FAIL                (6U)/* ͵Ļ*/




/* ȫcase_no*/
typedef enum zxic_slt_case_no_e
{
    ZXIC_SLT_CASE_PLL_LOCK_STATUS_CHECK       = (0x08U),
    /* efuseز */
    ZXIC_SLT_CASE_EFUSE_CHECK                 = (0x09U),




    /* serdesŷΧ0x10~0x7f*/
    /* lifx(LIF0 LIF1 LIF2)ӿserdes prbsز  0x10~0x2f*/
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_1G         = (0x10U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_3G         = (0x11U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_5G         = (0x12U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_6G         = (0x13U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_9G         = (0x14U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_10G        = (0x15U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_12G        = (0x16U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_15G        = (0x17U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_20G        = (0x18U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_25G        = (0x19U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_26G        = (0x1aU),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_27G        = (0x1bU),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_28G        = (0x1cU),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_30G        = (0x1dU),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_50G        = (0x1fU),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_51G        = (0x20U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_53G        = (0x21U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_55G        = (0x22U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_56G        = (0x23U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_57G        = (0x24U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_98G        = (0x25U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_106G       = (0x26U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_111G       = (0x27U),
    ZXIC_SLT_CASE_SERDES_LIFX_PRBS_112G       = (0x28U),


    /* lifcӿserdesز 0x30~0x37*/
    ZXIC_SLT_CASE_SERDES_LIFC_PRBS_1G         = (0x30U),
    ZXIC_SLT_CASE_SERDES_LIFC_PRBS_10G        = (0x31U),
    ZXIC_SLT_CASE_SERDES_LIFC_PRBS_25G        = (0x32U),
    ZXIC_SLT_CASE_SERDES_LIFC_PRBS_53G        = (0x33U),

    /* lifc eth ӿڷز 0x38~0x3f*/
    ZXIC_SLT_CASE_PORT_LIFC_SD_1G            = (0x38U),
    ZXIC_SLT_CASE_PORT_LIFC_SD_10G           = (0x39U),
    ZXIC_SLT_CASE_PORT_LIFC_SD_25G           = (0x3aU),
    ZXIC_SLT_CASE_PORT_LIFC_SD_53G           = (0x3bU),

    /* ⲿҵinterlaken-laӿ*/
    ZXIC_SLT_CASE_SERDES_INTERLAKEN_LA       = (0x3fU),


    /* lif0 eth ӿڷز 0x40~0x5f*/
    ZXIC_SLT_CASE_PORT_LIFO_SD_1G         = (0x40U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_5G         = (0x41U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_10G        = (0x42U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_12G        = (0x43U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_25G        = (0x44U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_26G        = (0x45U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_51G        = (0x46U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_53G        = (0x47U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_106G       = (0x48U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_112G       = (0x49U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_20G        = (0x4AU),


    /* lif0 intlkӿڷز 0x60~0x6f*/
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_3G     =  (0x60U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_6G     =  (0x61U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_10G    =  (0x62U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_12G    =  (0x63U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_25G    =  (0x64U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_28G    =  (0x65U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_30G    =  (0x66U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_50G    =  (0x67U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_51G    =  (0x68U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_53G    =  (0x69U),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_56G    =  (0x6aU),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_106G   =  (0x6bU),
    ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_112G   =  (0x6cU),


    /* lif1 FECز 0x70~0x7f*/
    ZXIC_SLT_CASE_SERDES_LIF1_FEC_25G        = (0x70U),
    ZXIC_SLT_CASE_SERDES_LIF1_FEC_26G        = (0x71U),
    ZXIC_SLT_CASE_SERDES_LIF1_FEC_28G        = (0x72U),
    ZXIC_SLT_CASE_SERDES_LIF1_FEC_50G        = (0x73U),
    ZXIC_SLT_CASE_SERDES_LIF1_FEC_53G        = (0x74U),
    ZXIC_SLT_CASE_SERDES_LIF1_FEC_56G        = (0x75U),
    ZXIC_SLT_CASE_SERDES_LIF1_FEC_98G        = (0x76U),
    ZXIC_SLT_CASE_SERDES_LIF1_FEC_106G       = (0x77U),
    ZXIC_SLT_CASE_SERDES_LIF1_FEC_112G       = (0x78U),




    /*ƬramŷΧ0x80~0x87*/
    /* CPUɶдĴ */
    ZXIC_SLT_CASE_REG_CPU_W_R                      =  (0x80U),
    /* CPUɶдram */
    ZXIC_SLT_CASE_RAM_CPU_W_R                      =  (0x81U),
    /* RAMд(΢)*/
    ZXIC_SLT_CASE_RAM_MC_W_R                       =  (0x82U),
   /* RAMд memtest86(΢)*/
    ZXIC_SLT_CASE_RAM_MC_MEMTEST86                 =  (0x83U),




    /* HBM/DDRŷΧ 0x90~0x9f*/
    /*mbist*/
    ZXIC_SLT_CASE_HBM_DDR_CTRL_BIST                =  (0x90U),
    /* HBM/DDRCPUд*/
    ZXIC_SLT_CASE_HBM_DDR_CPU_W_R                  =  (0x91U),
    /* HBM/DDRд(΢)*/
    ZXIC_SLT_CASE_HBM_DDR_MC_W_R                   =  (0x92U),
    /* HBM/DDRд memtest86(΢)*/
    ZXIC_SLT_CASE_HBM_DDR_MC_MEMTEST86             =  (0x93U),
    /* HBM/DDR TMǲ*/
    ZXIC_SLT_CASE_HBM_DDR_TM_TEST                  =  (0x94U),





    /* ԺȫҵPVTŷΧ 0xa0~0xaf*/
    /* · */
    ZXIC_SLT_CASE_PKT_FLOW_NOM                      =  (0xA0U),
    /* OAM */
    ZXIC_SLT_CASE_OAM_SEND_PKT                      =  (0xA1U),
    /* seȫ */
    ZXIC_SLT_CASE_PKT_FLOW_SE_FULL                  =  (0xA2U),
    /* tmȫв */
    ZXIC_SLT_CASE_PKT_FLOW_TM_FULL                  =  (0xA3U),
    /* LIFCڲ */
    ZXIC_SLT_CASE_PKT_FLOW_LIFC                     =  (0xA4U),

    /* оƬPVT ġ¶Ⱥ͵ѹ */
    ZXIC_SLT_CASE_PVT_EXCEED_POWER_TEST             =  (0xA8U),
    ZXIC_SLT_CASE_PVT_EXCEED_TEM_VOLT_TEST          =  (0xA9U),
    ZXIC_SLT_CASE_PVT_EXCEED_HBM_TEMPER_TEST        =  (0xAaU),





    /* ŷΧ0xb0~0xff*/
    /* ѹ*/
    ZXIC_SLT_CASE_VOLT_TEST                         =  (0xB0U),
    /* ʱƵƫ */
    ZXIC_SLT_CASE_CLK_TEST                          =  (0xB1U),

    /* PCIEѹ */
    ZXIC_SLT_CASE_PCIE_W_R_TEST                     =  (0xB2U),
    /* ִ */
    /* PCIE */
    ZXIC_SLT_CASE_PCIE_TEST                         =  (0xB3U),
    /* RISCV */
    ZXIC_SLT_CASE_RISCV_W_R_TEST                     =  (0xB4U),

    ZXIC_SLT_CASE_MAX,
} ZXIC_SLT_CASE_NO_E;


#if ZXIC_REAL("ERR_CODE")
#define ZXIC_SLT_RC_BASE                              (0x100U)


 #define ZXIC_SLT_TEST_CASE_FNC_POINT_NULL            (ZXIC_SLT_RC_BASE | 0x1)  
 #define ZXIC_SLT_CASE_PLL_LOCK_STATUS_CHECK_FAIL     (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PLL_LOCK_STATUS_CHECK)  
 #define ZXIC_SLT_CASE_EFUSE_CHECK_FAIL               (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_EFUSE_CHECK)  
 
 /* lifx*/                                            
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_1G_FAIL        (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_1G)  
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_3G_FAIL        (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_3G)  
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_5G_FAIL        (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_5G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_6G_FAIL        (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_6G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_9G_FAIL        (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_9G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_10G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_10G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_12G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_12G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_15G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_15G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_20G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_20G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_25G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_25G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_26G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_26G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_27G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_27G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_28G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_28G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_30G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_30G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_50G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_50G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_51G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_51G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_53G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_53G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_55G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_55G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_56G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_56G)  
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_57G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_57G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_98G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_98G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_106G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_106G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_111G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_111G)     
 #define ZXIC_SLT_CASE_SERDES_LIFX_PRBS_112G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFX_PRBS_112G)     
     
 /* lifc*/                                            
 #define ZXIC_SLT_CASE_SERDES_LIFC_PRBS_1G_FAIL        (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFC_PRBS_1G)   
 #define ZXIC_SLT_CASE_SERDES_LIFC_PRBS_10G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFC_PRBS_10G)     
 #define ZXIC_SLT_CASE_SERDES_LIFC_PRBS_25G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFC_PRBS_25G)     
 #define ZXIC_SLT_CASE_SERDES_LIFC_PRBS_53G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIFC_PRBS_53G)     
   
 /* lifc */                                           
 #define ZXIC_SLT_CASE_PORT_LIFC_SD_1G_FAIL            (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFC_SD_1G )  
 #define ZXIC_SLT_CASE_PORT_LIFC_SD_10G_FAIL           (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFC_SD_10G)  
 #define ZXIC_SLT_CASE_PORT_LIFC_SD_25G_FAIL           (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFC_SD_25G)   
 #define ZXIC_SLT_CASE_PORT_LIFC_SD_53G_FAIL           (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFC_SD_53G)  
    
 /* lif0 ETH*/                                        
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_1G_FAIL           (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_1G)  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_5G_FAIL           (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_5G)  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_10G_FAIL          (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_10G)  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_12G_FAIL          (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_12G)  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_25G_FAIL          (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_25G)  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_26G_FAIL          (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_26G)  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_51G_FAIL          (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_51G)   
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_53G_FAIL          (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_53G)   
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_106G_FAIL         (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_106G)   
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_112G_FAIL         (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_112G) 
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_20G_FAIL          (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_20G)   
    
 /* lif0 intlk*/                                      
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_3G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_3G  )  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_6G_FAIL       (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_6G  )  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_10G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_10G )    
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_12G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_12G )  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_25G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_25G )  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_28G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_28G )  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_30G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_30G )  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_50G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_50G )  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_51G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_51G )  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_53G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_53G )  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_56G_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_56G )  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_106G_FAIL     (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_106G)  
 #define ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_112G_FAIL     (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PORT_LIFO_SD_ILK_112G )  


/* lif1*/                                              
#define ZXIC_SLT_CASE_SERDES_LIF1_FEC_25G_FAIL   (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIF1_FEC_25G)  
#define ZXIC_SLT_CASE_SERDES_LIF1_FEC_26G_FAIL   (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIF1_FEC_26G)    
#define ZXIC_SLT_CASE_SERDES_LIF1_FEC_28G_FAIL   (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIF1_FEC_28G)   
#define ZXIC_SLT_CASE_SERDES_LIF1_FEC_50G_FAIL   (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIF1_FEC_50G) 
#define ZXIC_SLT_CASE_SERDES_LIF1_FEC_53G_FAIL   (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIF1_FEC_53G)   
#define ZXIC_SLT_CASE_SERDES_LIF1_FEC_56G_FAIL   (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIF1_FEC_56G)
#define ZXIC_SLT_CASE_SERDES_LIF1_FEC_98G_FAIL   (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIF1_FEC_98G)  
#define ZXIC_SLT_CASE_SERDES_LIF1_FEC_106G_FAIL  (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIF1_FEC_106G)   
#define ZXIC_SLT_CASE_SERDES_LIF1_FEC_112G_FAIL  (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_LIF1_FEC_112G) 

/* ⲿҵinterlaken-laӿ*/
#define ZXIC_SLT_CASE_SERDES_INTELAKEN_LA_FAIL   (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_SERDES_INTELAKEN_LA) 

 
 /*Ƭramд*/                                   
 #define ZXIC_SLT_CASE_RAM_CPU_W_R_FAIL               (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_RAM_CPU_W_R )  
 #define ZXIC_SLT_CASE_REG_CPU_W_R_FAIL               (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_REG_CPU_W_R  )  
 #define ZXIC_SLT_CASE_RAM_MC_W_R_FAIL                (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_RAM_MC_W_R  )  
 #define ZXIC_SLT_CASE_RAM_MC_MEMTEST86_FAIL          (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_RAM_MC_MEMTEST86 )  

 /* HBM/DDR */
 #define ZXIC_SLT_CASE_HBM_DDR_CTRL_BIST_FAIL         (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_HBM_DDR_CTRL_BIST    )  
 #define ZXIC_SLT_CASE_HBM_DDR_MC_W_R_FAIL            (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_HBM_DDR_MC_W_R       )  
 #define ZXIC_SLT_CASE_HBM_DDR_MC_MEMTEST86_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_HBM_DDR_MC_MEMTEST86 )  
 #define ZXIC_SLT_CASE_HBM_DDR_CPU_W_R_FAIL           (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_HBM_DDR_CPU_W_R )  
 #define ZXIC_SLT_CASE_HBM_DDR_TM_TEST_FAIL           (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_HBM_DDR_TM_TEST      )  


 /* ԺȫҵPVT*/
 #define ZXIC_SLT_CASE_PKT_FLOW_NOM_FAIL               (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PKT_FLOW_NOM              )  
 #define ZXIC_SLT_CASE_OAM_SEND_PKT_FAIL               (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_OAM_SEND_PKT              )  
 #define ZXIC_SLT_CASE_PKT_FLOW_SE_FULL_FAIL           (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PKT_FLOW_SE_FULL          )  
 #define ZXIC_SLT_CASE_PKT_FLOW_TM_FULL_FAIL           (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PKT_FLOW_TM_FULL          )   
 #define ZXIC_SLT_CASE_PKT_FLOW_LIFC_FAIL              (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PKT_FLOW_LIFC  )

 #define ZXIC_SLT_CASE_PVT_EXCEED_POWER_TEST_FAIL      (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PVT_EXCEED_POWER_TEST     )  
 #define ZXIC_SLT_CASE_PVT_EXCEED_TEM_VOLT_TEST_FAIL   (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PVT_EXCEED_TEM_VOLT_TEST  )  
 #define ZXIC_SLT_CASE_PVT_EXCEED_HBM_TEMPER_TEST_FAIL (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PVT_EXCEED_HBM_TEMPER_TEST)  


 #define ZXIC_SLT_CASE_PCIE_TEST_FAIL                  (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PCIE_TEST    )  
 #define ZXIC_SLT_CASE_PCIE_W_R_TEST_FAIL              (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_PCIE_W_R_TEST    )  
 #define ZXIC_SLT_CASE_RISCV_W_R_TEST_FAIL              (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_RISCV_W_R_TEST)  
 #define ZXIC_SLT_CASE_VOLT_TEST_FAIL                  (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_VOLT_TEST    )  
 #define ZXIC_SLT_CASE_CLK_TEST_FAIL                   (ZXIC_SLT_RC_BASE | ZXIC_SLT_CASE_CLK_TEST)  

#endif 


typedef struct zxic_slt_err_info_mng_t
{
    ZXIC_UINT32         err_code;      /*μERR_CODE*/
    const ZXIC_CHAR *   err_info;
} ZXIC_SLT_ERR_INFO_MNG_T;


typedef struct zxic_slt_init_ctrl_t
{
    ZXIC_ADDR_T pcie_vir_baddr;               /**<  @brief PCIeӳַ*/
    ZXIC_ADDR_T riscv_vir_baddr;               /**<  @brief RISCVӳַ */
    ZXIC_ADDR_T dma_vir_baddr;                /**<  @brief DMAӳַ*/
    ZXIC_ADDR_T dma_phy_baddr;                /**<  @brief DMAڴַ*/
}ZXIC_SLT_INIT_CTRL_T;


typedef struct zxic_slt_case_para_t

{
    ZXIC_UINT32 chip_id[ZXIC_SLT_CHIP_ID_LEN];      /* ضӦоƬID */
    ZXIC_UINT32 case_num;                           /* ִSLT  */
    ZXIC_UINT32 case_no[ZXIC_SLT_CASE_MAX_NUM];     /* ִSLT б */
    ZXIC_UINT32 case_result[ZXIC_SLT_CASE_MAX_NUM]; /* ִSLT Ӧɹֵ */
    ZXIC_UINT32 bin_code;                           /*  SLT ִзBIN */	
    ZXIC_DOUBLE temp;                               /*  SLT ǰʼ¶ */
    ZXIC_DOUBLE volt;                               /*  SLT ǰ˵ѹ */

} ZXIC_SLT_CASE_PARA_T;



/*case ׼*/
typedef ZXIC_RTN32 (*ZXIC_SLT_INST_CASE_FN)(ZXIC_UINT32 device_id);

typedef struct zxic_slt_case_mng_t
{
    const ZXIC_CHAR *        case_name;     /**/
    ZXIC_UINT32              case_no;       /*μZXIC_SLT_CASE_NO_E*/
    ZXIC_SLT_INST_CASE_FN    inst_case_fn; /*caseָ*/
} ZXIC_SLT_CASE_MNG_T;



/* Ͷ*/
typedef enum zxic_slt_power_type_t
{
    ZXIC_SLT_POWER_VCC_SSP4_CORE                =  (0x0U),
    ZXIC_SLT_POWER_VCC0V75_SSP4_SERDES_DVDD     =  (0x1U),
    ZXIC_SLT_POWER_VCC0V75_SSP4_SERDES_AVDDL    =  (0x2U),
    ZXIC_SLT_POWER_VCC1V2_SSP4_SERDES_AVDDH     =  (0x3U),
    ZXIC_SLT_POWER_VCC1V2_SSP4_HBM_VDDQ         =  (0x4U),

    ZXIC_SLT_POWER_VCC0V75_SSP4_AVDD            =  (0x5U),
    ZXIC_SLT_POWER_VCC1V2_SSP4_AVDD             =  (0x6U),
    ZXIC_SLT_POWER_VCC1V2_SSP4_GPIO_DVDD        =  (0x7U),
    ZXIC_SLT_POWER_VCC2V5_SSP4_VPP              =  (0x8U),

    ZXIC_SLT_POWER_TYPE_MAX,

}ZXIC_SLT_POWER_TYPE_T;

typedef struct zxic_slt_power_t
{

   ZXIC_DOUBLE volt;   /* ѹֵ */
   ZXIC_DOUBLE cur;    /* ֵ */
   ZXIC_UINT32 type;   /* ı룬μZXIC_SLT_POWER_TYPE_T */
}ZXIC_SLT_POWER_T;

typedef struct zxic_slt_power_para_t
{
   ZXIC_SLT_POWER_T *p_para;
   ZXIC_UINT32 num;  /* Чĸ */
}ZXIC_SLT_POWER_PARA_T;



/* ѹͶ*/
typedef enum zxic_slt_volt_type_t
{
    ZXIC_SLT_VOLT_VCC_SSP4_CORE                =  (0x0U),
    ZXIC_SLT_VOLT_VCC0V75_SSP4_SERDES_DVDD     =  (0x1U),
    ZXIC_SLT_VOLT_VCC0V75_SSP4_SERDES_AVDDL    =  (0x2U),
    ZXIC_SLT_VOLT_VCC1V2_SSP4_SERDES_AVDDH     =  (0x3U),
    ZXIC_SLT_VOLT_VCC1V2_SSP4_HBM_VDDQ         =  (0x4U),
    
    ZXIC_SLT_VOLT_TYPE_MAX,

}ZXIC_SLT_VOLT_TYPE_T;

typedef struct zxic_slt_volt_t
{

   ZXIC_UINT32 percent;   /* ѹ¸ֵٷֱ*100,ϵ1%ֵ1*/
   ZXIC_UINT32 flag;      /* ƫ0   ƫ1 */
   ZXIC_UINT32 vol_type;  /* ѹͣμZXIC_SLT_VOLT_TYPE_T */
}ZXIC_SLT_VOLT_T;

typedef struct zxic_slt_volt_para_t
{
   ZXIC_SLT_VOLT_T *p_para;
   ZXIC_UINT32 num;  /* Чѹ */
}ZXIC_SLT_VOLT_PARA_T;



/* ʱͶ*/
typedef enum zxic_slt_clk_type_t
{
    ZXIC_SLT_CLK_AU5327_A          =  (0x0U),/*SSP4 SOCKET AU5327#1 HOST_100M*/
    ZXIC_SLT_CLK_AU5327_B          =  (0x1U),/*SSP4 SOCKET AU5327#1 PLL_SYS_CLK/SERDES 156.25M*/
    ZXIC_SLT_CLK_AU5327_C          =  (0x2U),/*SSP4 SOCKET AU5327#1 PLL_LOCAL_CLK  156.25M*/
    ZXIC_SLT_CLK_AU5327_D          =  (0x3U),/*SSP4 SOCKET AU5327#1 PLL_TS_CLK 125M*/
    
    ZXIC_SLT_CLK_TYPE_MAX,


}ZXIC_SLT_CLK_TYPE_T;

typedef struct zxic_slt_clk_t
{

   ZXIC_UINT32 value;     /* ʱƫֵλHZ(PPM),1PPM = 1HZ1MHZ=1000KHZ=1000000HZ*/
   ZXIC_UINT32 flag;      /* ƫ0   ƫ1 */
   ZXIC_UINT32 clk_type;  /* ʱͣμZXIC_SLT_CLK_TYPE_T */
}ZXIC_SLT_CLK_T;

typedef struct zxic_slt_clk_para_t
{
   ZXIC_SLT_CLK_T *p_para;
   ZXIC_UINT32 num;  /* ЧƫʱӸ */
}ZXIC_SLT_CLK_PARA_T;



#if ZXIC_REAL("define_for_bsp")
/***********************************************************/
/** Ļȡ
* @param   ZXIC_SLT_CASE_GETPOWER_FN   
* @param   device_id   
* @param   p_para   
*
* @return  
* @remark  
* @see     
* @author  PJ      @date  2022/04/28
************************************************************/
typedef ZXIC_RTN32 (*ZXIC_SLT_CASE_GETPOWER_FN)(ZXIC_UINT32 device_id, ZXIC_SLT_POWER_PARA_T *p_para);


/***********************************************************/
/** riscvԺ
* @param   ZXIC_SLT_CASE_RISCV_FN   
* @param   device_id   
* @param   reg_addr   Ĵַ
* @param   wr_data   дĴֵ
* @param   rd_data   ӼĴжֵ
*
* @return  
* @remark  
* @see     
* @author  PJ      @date  2022/04/28
************************************************************/
typedef ZXIC_RTN32 (*ZXIC_SLT_CASE_RISCV_FN)(ZXIC_UINT32 device_id, ZXIC_UINT32 reg_addr, ZXIC_UINT32 wr_data, ZXIC_UINT32 rd_data);


/***********************************************************/
/** PCIEԺ
* @param   ZXIC_SLT_CASE_PCIE_FN   
* @param   device_id   
* @param   times  pcieԴ  
*
* @return  
* @remark  
* @see     
* @author  PJ      @date  2022/04/28
************************************************************/
typedef ZXIC_RTN32 (*ZXIC_SLT_CASE_PCIE_FN)(ZXIC_UINT32 device_id, ZXIC_UINT32 times);


/***********************************************************/
/** ѹ
* @param   ZXIC_SLT_CASE_ADJUST_VOLT_FN   
* @param   device_id   
* @param   p_para   
*
* @return  
* @remark  
* @see     
* @author  PJ      @date  2022/04/28
************************************************************/
typedef ZXIC_RTN32 (*ZXIC_SLT_CASE_ADJUST_VOLT_FN)(ZXIC_UINT32 device_id,ZXIC_SLT_VOLT_PARA_T *p_para);


/***********************************************************/
/** ʱӺ
* @param   ZXIC_SLT_CASE_ADJUST_CLK_FN   
* @param   device_id   
* @param   p_para   
*
* @return  
* @remark  
* @see     
* @author  PJ      @date  2022/04/28
************************************************************/
typedef ZXIC_RTN32 (*ZXIC_SLT_CASE_ADJUST_CLK_FN)(ZXIC_UINT32 device_id,ZXIC_SLT_CLK_PARA_T *p_para);


/*BSPص*/
typedef struct zxic_slt_bsp_register_fn_t
{
    ZXIC_SLT_CASE_GETPOWER_FN        zxic_slt_power_fn;        
    ZXIC_SLT_CASE_RISCV_FN            zxic_slt_riscv_fn;          
    ZXIC_SLT_CASE_PCIE_FN            zxic_slt_pcie_fn;         
    ZXIC_SLT_CASE_ADJUST_VOLT_FN     zxic_slt_volt_fn;         
    ZXIC_SLT_CASE_ADJUST_CLK_FN      zxic_slt_clk_fn;          

} ZXIC_SLT_BSP_REGISTER_FN_T;

#endif

#if ZXIC_REAL("define_for_sdk")
/***********************************************************/
/** ʼ
* @param   ZXIC_SLT_INIT_FN   
* @param   device_id   
* @param   chip_type  ֲͬװ  
* @param   p_init_ctrl   μZXIC_SLT_INIT_CTRL_T
*
* @return  
* @remark  
* @see     
* @author  PJ      @date  2022/04/22
************************************************************/
typedef ZXIC_RTN32 (*ZXIC_SLT_INIT_FN)(ZXIC_UINT32 device_id,ZXIC_UINT32 chip_type,ZXIC_SLT_INIT_CTRL_T *p_init_ctrl);




/* Chip_ID ɽṹ˵
** Chip_ID = efusewaferκ+waferƬ+x+Y϶
** waferκ: 48bit lot_id5~0
** waferƬ:   5bit  wafer_no
** x:		8bit  x_addr
** Y:		8bit  y_addr
** chip_id2 = lot_id5[7:3]
** chip_id1 = lot_id5[2:0] + lot_id4 + lot_id3 + lot_id2 + lot_id1[7:3]
** chip_id0 = lot_id1[2:0] + lot_id0 + wafer_no[4:0] + x_addr + y_addr*/

/***********************************************************/
/** ִв֮ǰԤ,ȡchip_id,¶ȣѹϢ
* @param   ZXIC_SLT_PRE_FN   
* @param   device_id   
* @param   chip_type  ֲͬװ 
* @param   p_chip_id   оƬchip_idϢ(μʽ˵
* @param   p_temp   SLT ǰʼ¶ 
* @param   p_volt   SLT ǰ˵ѹ 
*
* @return  
* @remark  
* @see     
* @author  PJ      @date  2022/03/29
************************************************************/
typedef ZXIC_RTN32 (*ZXIC_SLT_PRE_FN)(ZXIC_UINT32 device_id,ZXIC_UINT32 chip_type,ZXIC_UINT32 *p_chip_id, ZXIC_DOUBLE *p_temp,ZXIC_DOUBLE *p_volt);

/***********************************************************/
/** ִк
* @param   ZXIC_SLT_ALL_CASE_FN   
* @param   device_id   
* @param   chip_type  ֲͬװ 
* @param   p_case_num  ִSLT  
* @param   p_case_no   ִSLT б
* @param   p_case_result   ִSLT Ӧɹֵ
*
* @return  
* @remark  
* @see     
* @author  PJ      @date  2022/03/29
************************************************************/
typedef ZXIC_RTN32 (*ZXIC_SLT_ALL_CASE_FN)(ZXIC_UINT32 device_id,ZXIC_UINT32 chip_type,ZXIC_UINT32 *p_case_num,ZXIC_UINT32 *p_case_no,ZXIC_UINT32 *p_case_result);

/*SDKص*/
typedef struct zxic_slt_register_fn_t
{
    ZXIC_SLT_INIT_FN           zxic_slt_init_fn;         /* ʼ */
    ZXIC_SLT_PRE_FN            zxic_slt_pre_fn;          /* Ԥ */
    ZXIC_SLT_ALL_CASE_FN       zxic_slt_all_case_fn;     /* ִк*/
    
} ZXIC_SLT_REGISTER_FN_T;

#endif



#if ZXIC_REAL("fn for sdk")
/***********************************************************/
/** صעắоƬIDעһμɣṩSDK
* @return
* @remark  
* @see
* @author  PJ      @date  2020/05/03
************************************************************/
ZXIC_RTN32 zxic_slt_register_fn_set(ZXIC_SLT_REGISTER_FN_T *pExcCall);

/***********************************************************/
/** ȡPOWER
* @param   pExcCall
*
* @return
* @remark  
* @see
* @author  PJ      @date  2020/05/03
************************************************************/
ZXIC_RTN32 zxic_slt_callback_getpower(ZXIC_VOID *pExcCall);

/***********************************************************/
/** ȡMODI
* @param   pExcCall
*
* @return
* @remark  
* @see
* @author  PJ      @date  2020/05/03
************************************************************/
ZXIC_RTN32 zxic_slt_callback_riscv(ZXIC_VOID *pExcCall);

/***********************************************************/
/** PCIE
* @param   pExcCall
*
* @return
* @remark  
* @see
* @author  PJ      @date  2020/05/03
************************************************************/
ZXIC_RTN32 zxic_slt_callback_pcie(ZXIC_VOID *pExcCall);

/***********************************************************/
/** ȡVOLT
* @param   pExcCall
*
* @return
* @remark  
* @see
* @author  PJ      @date  2020/05/03
************************************************************/
ZXIC_RTN32 zxic_slt_callback_adjust_volt(ZXIC_VOID *pExcCall);

/***********************************************************/
/** ȡCLK
* @param   pExcCall
*
* @return
* @remark  
* @see
* @author  PJ      @date  2020/05/03
************************************************************/
ZXIC_RTN32 zxic_slt_callback_adjust_clk(ZXIC_VOID *pExcCall);


#endif


#if ZXIC_REAL("fn for bsp")

/***********************************************************/
/** صעắоƬIDעһμɣṩSDK
* @return
* @remark  
* @see
* @author  PJ      @date  2020/05/03
************************************************************/
ZXIC_RTN32 zxic_slt_bsp_register_fn_set(ZXIC_SLT_BSP_REGISTER_FN_T *pExcCall);


/***********************************************************/
/** Ƿɾlog,ṩBSP
* @return
* @remark  
* @see
* @author  PJ      @date  2020/05/03
************************************************************/
ZXIC_VOID zxic_slt_log_rm_flag_set(ZXIC_UINT32 log_rm_flag);


/***********************************************************/
/** ִSDK SLT ,ṩBSP
* @param   dev_id   
* @param   chip_type   оƬװ 
* @param   p_init_ctrl  ϸμZXIC_SLT_INIT_CTRL_T˵
* @param   p_case_para  ϸμZXIC_SLT_CASE_PARA_T˵
*
* @return  
* @remark  
* @see     
* @author  PJ      @date  2022/03/29
************************************************************/
ZXIC_RTN32 zxic_slt_all_case_test(ZXIC_UINT32 dev_id,ZXIC_UINT32 chip_type, ZXIC_SLT_INIT_CTRL_T *p_init_ctrl,ZXIC_SLT_CASE_PARA_T *p_case_para);

#endif



#ifdef __cplusplus
}
#endif

#endif /* end __ZXIC_SLT_H__ */

