# Started by AICoder, pid:7c7740d5d0884b64ae5517a0d8676168
import pandas as pd
import json
import re
from ctypes import c_uint32


# Started by AICoder, pid:c74c8561350a4a5e8bb4ced8eb2c2dca
def is_address(s):
    pattern = r"!(.+)"  # 定义正则表达式模式，其中 ! 和 \n 之间为任意字符
    result = re.findall(pattern, s)  # 在字符串中查找所有匹配的字符串
    return result
# Ended by AICoder, pid:c74c8561350a4a5e8bb4ced8eb2c2dca

def split_loop(s):
    return re.split(r'\+|\*', s)

def excel_to_json(file_path):
    # 创建一个空的字典，用来存储最终的JSON数据
    data = {}

    # 读取excel文件
    xls = pd.ExcelFile(file_path)
    for sheet_name in xls.sheet_names:
        # 读取每个sheet的内容
        df = xls.parse(sheet_name)
        members = []
        for index, row in df.iterrows():
            module_data = {}
            module_data['MODULE_NAME'] = row['MODULE_NAME']
            module_data[row['REG_TYPE']] = []
            # 解析width字段
            # print(row['CMP_BITS'][1:-1])
            if pd.isnull(row['CMP_BITS']):
                high_bit, low_bit = 31, 0
            else:
                high_bit, low_bit = map(int, row['CMP_BITS'][1:-1].split(':'))
            compare_list = is_address(str(row['COMP_REG_ADDR_OR_VALUE']))
            compare_value = str(row['COMP_REG_ADDR_OR_VALUE'])
            expect_list = []

            if len(compare_list) != 0:
                for compare in compare_list:
                    operator_flag = 0
                    loop_len = 1
                    loop_step = 4
                    address = compare
                    value = 0
                    if address[0] == '+':
                        operator_flag = 1
                        address = compare[1:]
                    elif address[0] == '-':
                        operator_flag = -1
                        address = compare[1:]
                    if len(address) > 12:
                        result = split_loop(address) 
                        if len(result) == 3 :
                            address = result[0]
                            loop_len = int(result[1])
                            loop_step = int(result[2])

                    # 构造expect列表
                    expect_obj = {'address': address, 'value': value, 'high_bit': high_bit, 'low_bit': low_bit,
                                  'operator_flag': operator_flag, 'loop_len': loop_len, 'loop_step': loop_step, 'meaning': str(row['REG_USAGE'])}
                    # print(expect_list)
                    expect_list.append(expect_obj)
            elif len(compare_value) != 0 and compare_value != "nan":
                operator_flag = 0
                loop_len = 1
                loop_step = 4
                value = 0
                if compare_value[0] == '~':
                    operator_flag = 10
                    value = int(compare_value[1:])
                else:
                    value= int(compare_value[:])
                address = ""
                # 构造expect列表
                expect_obj = {'address': address, 'value': value, 'high_bit': high_bit, 'low_bit': low_bit,
                              'operator_flag': operator_flag, 'loop_len': loop_len, 'loop_step': loop_step, 'meaning': str(row['REG_USAGE'])}
                # print(expect_list)
                expect_list.append(expect_obj)

            # 构造当前行的字典
            operator_flag = 0
            loop_len = 1
            loop_step = 4
            address = str(row['REG_ADDRESS'])
            if len(address) > 12:
                result = split_loop(address) 
                print(row['MODULE_NAME'])
                print(result)
                if len(result) == 3 :
                    address = result[0]
                    loop_len = int(result[1])
                    loop_step = int(result[2])
            row_dict = {'address': address, 'value': 0, 'high_bit': high_bit, 'low_bit': low_bit,
                        'operator_flag': operator_flag, 'loop_len': loop_len, 'loop_step': loop_step, 'meaning': str(row['REG_FUNCTION']), 'expect': expect_list}
            # print(row_dict)
            module_data[row['REG_TYPE']].append(row_dict)

            members.append(module_data)
        data[sheet_name] = members
    return data


json_str = excel_to_json('nvme_health.xlsx')
with open('../dhnvme_health.json', 'w', encoding='utf-8') as f:
    json.dump(json_str, f, indent=4)

# json_str = excel_to_json('nvme_mod.xlsx')
# with open('../dhnvme_mod.json', 'w', encoding='utf-8') as f:
#     json.dump(json_str, f, indent=4)
# Ended by AICoder, pid:7c7740d5d0884b64ae5517a0d8676168