#!/bin/bash

minute=$1

#const value
SELF_HEALING_PATH=/var/log/dhselfhealing
TIME_PATH=/etc/dhselfhealing
DETECT_SCRIPT=dhselfhealing.sh
DEFULT_SCRIPT_PATH=/usr/bin
TIME_FILE=lastreboot.log
MESSAGE_LOG=message.log
UPGRADE_LOG=dhselfhealingrun.log
UPGRADE_JSON=dhselfhealingrun.json
CRONTAB_BAK_FILE=crontab_bak
CRONTAB_BAK_FILE_TMP=crontab_bak_tmp
LOG_PATH=$SELF_HEALING_PATH
JSON_PATH=$SELF_HEALING_PATH

ENABLE=1
DISABLE=0
cron_task=0

TASK_COMMAND='. /etc/profile;/bin/sh '$DEFULT_SCRIPT_PATH/$DETECT_SCRIPT''


json_file()
{
    echo '{' |tee -a $JSON_PATH/$UPGRADE_JSON
    echo '  "status":"'$1'", ' |tee -a $JSON_PATH/$UPGRADE_JSON
    echo '  "progress":"'$2'", ' |tee -a $JSON_PATH/$UPGRADE_JSON
    echo '  "message":"'$3'", ' |tee -a $JSON_PATH/$UPGRADE_JSON
    echo '  "is_reboot":'$4'' |tee -a $JSON_PATH/$UPGRADE_JSON
    echo '}' |tee -a $JSON_PATH/$UPGRADE_JSON
}

check_work_dir()
{
    local curtime=`date`

    if [ -d $SELF_HEALING_PATH ]
    then
        sudo rm -f $SELF_HEALING_PATH/$CRONTAB_BAK_FILE
        sudo rm -f $SELF_HEALING_PATH/$MESSAGE_LOG
        sudo rm -f $LOG_PATH/$UPGRADE_LOG
        sudo rm -f $JSON_PATH/$UPGRADE_JSON
    else
        sudo mkdir -p $SELF_HEALING_PATH
        sudo chmod 750 $SELF_HEALING_PATH
    fi

    if [ -d $TIME_PATH ]
    then
        sudo rm -f $TIME_PATH/$TIME_FILE
    else
        sudo mkdir $TIME_PATH
        sudo chmod 755 $TIME_PATH
    fi

    echo "#" $curtime|tee -a $JSON_PATH/$UPGRADE_JSON
    echo 'check_work_dir success!!!!' | tee -a $LOG_PATH/$UPGRADE_LOG

}

create_time_file()
{
    echo "1" |sudo tee $TIME_PATH/$TIME_FILE
    sudo chmod 755 $TIME_PATH/$TIME_FILE

    echo 'write_time_file success!!!!' | tee -a $LOG_PATH/$UPGRADE_LOG
    echo 'current_time is ' | tee -a $LOG_PATH/$UPGRADE_LOG
    sudo cat $TIME_PATH/$TIME_FILE| tee -a $LOG_PATH/$UPGRADE_LOG
}

create_crontab()
{
    local crontab_task='*/'$minute' * * * * '$TASK_COMMAND' > /dev/null 2>&1 '

    echo "bakup crontab begin "| tee -a $LOG_PATH/$UPGRADE_LOG
    sudo crontab -l |sudo tee $SELF_HEALING_PATH/$CRONTAB_BAK_FILE >>$LOG_PATH/$UPGRADE_LOG
    echo "bakup crontab end"| tee -a $LOG_PATH/$UPGRADE_LOG

    echo "create new crontab begin "| tee -a $LOG_PATH/$UPGRADE_LOG
    sudo crontab -l |sudo tee $LOG_PATH/$CRONTAB_BAK_FILE_TMP >>$LOG_PATH/$UPGRADE_LOG
    sudo sed -e "/${DETECT_SCRIPT}/d" $LOG_PATH/$CRONTAB_BAK_FILE_TMP |sudo tee $LOG_PATH/crontab.tmp &>/dev/null
    echo "$crontab_task" |sudo tee -a $LOG_PATH/crontab.tmp &>/dev/null
    sudo crontab $LOG_PATH/crontab.tmp
    sudo rm $LOG_PATH/crontab.tmp
    sudo rm $LOG_PATH/$CRONTAB_BAK_FILE_TMP

    sudo crontab -l >>$LOG_PATH/$UPGRADE_LOG
    echo "create new crontab end "| tee -a $LOG_PATH/$UPGRADE_LOG
}

delete_crontab()
{
    crontab_list=$(crontab -l)

    echo "delete dhselfhealing.sh crontab task."| tee -a $LOG_PATH/$UPGRADE_LOG
    if [[ $crontab_list = *"dhselfhealing.sh"* ]]; then
        (crontab -l | sed '/dhselfhealing.sh/d' | crontab -)
        json_file 'success' '100' 'host firm dhselfhealingrun.sh delete complete' 'false'
        echo 'dhselfhealingrun.sh end time.' | tee -a $LOG_PATH/$UPGRADE_LOG
        date|tee -a $LOG_PATH/$UPGRADE_LOG
        exit
    fi
}

check_input_param()
{
    if [ -z "$minute" ];then
        minute=5   # 默认间隔5分钟
        cron_task=$ENABLE
    else
        if ! [[ $minute =~ ^[0-9]+$ ]]; then
            echo "The input must be an integer."
            exit
        fi

        if [ "$minute" -eq 0 ]; then
            cron_task=$DISABLE
        elif [ "$minute" -ge 1 ] && [ "$minute" -le 60 ]; then
            cron_task=$ENABLE
        else
            cron_task=$DISABLE
            echo "Please enter from 0 to 60 or null."| tee -a $LOG_PATH/$UPGRADE_LOG
            exit
        fi
    fi
}

main()
{
    check_work_dir
    json_file 'doing' '0' 'host is check work dir' 'false'

    check_input_param
    echo 'dhselfhealingrun.sh begin time.' | tee -a $LOG_PATH/$UPGRADE_LOG
    json_file 'init' '30' 'host start upgrading' 'false'

    if [ "$cron_task" -eq "$DISABLE" ]; then
        delete_crontab
    fi
    json_file 'doing' '50' 'host is check crontab task' 'false'

    create_time_file
    json_file 'doing' '70' 'host is write_time_file' 'false'

    create_crontab
    json_file 'success' '100' 'host firm dhselfhealingrun.sh complete' 'false'

    echo 'dhselfhealingrun.sh end time.' | tee -a $LOG_PATH/$UPGRADE_LOG
    date|tee -a $LOG_PATH/$UPGRADE_LOG
}

main
