''' Started by AICoder, pid:a39e39c58ac0420c9b2c08f97d5589a7 '''
import pandas as pd
import json
import re


# Started by AICoder, pid:71a34ca4dba84399a69585a1cffcd573
def split_string(s):
    pattern = r'!(.*?)\n#(.*?)\$'
    return re.findall(pattern, s, re.DOTALL)
# Ended by AICoder, pid:71a34ca4dba84399a69585a1cffcd573

# 读取Excel文件
xls = pd.ExcelFile('nvme_cnt.xlsx')

# 创建一个空的字典，用来存储最终的JSON数据
data = {}

# 遍历所有的sheet
for sheet_name in xls.sheet_names:
    # 读取每个sheet的内容
    df = xls.parse(sheet_name)

    # 获取第一列的值，作为每个成员的'link_nodes'
    link_nodes = df.iloc[:, 0].tolist()
    print(link_nodes)

    # 获取除了第一列之外的所有列名，作为每个成员的键
    keys = df.columns[1:]
    print(keys)

    # 创建一个空的列表，用来存储每个成员的详细信息
    members = []

    # 遍历每个成员
    for i in range(len(link_nodes)):
        member = {}
        member['module'] = link_nodes[i]

        # 遍历每个键，获取每个成员的详细信息
        for j, key in enumerate(keys):
            # 获取地址、含义解释和值（这里先暂时设置为0）
            s = str(df.iloc[i, j+1])
            s_list = split_string(s)
            obj = s.split('\n')
            member[key] = []
            for list in s_list:
                value = 0
                operator_flag = 0
                address = list[0]
                meaning = list[1]
                # 创建一个字典，用来存储每个地址的详细信息
                if list[0][0] == '+':
                    operator_flag = 1
                    address = list[0][1:]
                elif list[0][0] == '-':
                    operator_flag = -1
                    address = list[0][1:]

                unit = {
                    'address': address,
                    'value': value,
                    'high_bit': 31,
                    'low_bit': 0,
                    'operator_flag': operator_flag,
                    'meaning': meaning
                }
                # 将字典添加到列表中
                member[key].append(unit)
        # 将每个成员添加到列表中
        members.append(member)

    # 将每个sheet下的所有成员添加到字典中
    data[sheet_name] = members

# 将字典转换为JSON格式的字符串，并写入到文件中
with open('../dhnvme_cnt.json', 'w') as f:
    json.dump(data, f, indent=4)
''' Ended by AICoder, pid:a39e39c58ac0420c9b2c08f97d5589a7 '''