#!/bin/bash
# modify script form intel and mellonax


usage()
{
    echo
    echo "Usage: $0 [-c] {all|local|numa} [ethX] <[ethY]> "
    echo "  options: -c   Cancel the specified smp_affinity before"
    echo "  options: {numa} can be followed by a specific node NUMber"
    echo "  Ex: $0 local eth0"
    echo "  Ex: $0 numa 1 eth0"
    echo "  Ex: $0 0-7,16-23 eth0"
    echo "  Ex: $0 -c all eth0"
    echo
    exit 1
}

# Vars
#
if [[ "$1" == "-c" ]]; then
    CANCEL_ENA=1
    shift
fi

AFF=$1
shift

NUM='^[0-9]+$'
case "$AFF" in
    all)    ;;
    local)  ;;
    [0-9]*) ;;
    numa) [[ $1 =~ $NUM ]] && RNUMA=$1 && shift || usage ;;
    -h|--help)  usage && exit 1 ;;
    "")     usage && exit 1 ;;
    *)      IFACES=$AFF && AFF=all ;;   # Backwards compat mode
esac

# append the interfaces listed to the string with spaces
while [[ "$#" -ne "0" ]] ; do
    IFACES=${IFACES}" $1"
    shift
done

# for now the user must specify interfaces
if [[ -z "$IFACES" ]]; then
    usage
    exit 1
fi

# auto-determine interfaces
AUTO_IFACES=$(ls /sys/class/net)
[[ -z "$AUTO_IFACES" ]] && echo "Error: No interfaces up" && exit 1
for IFACE in $IFACES; do
    [[ -z "$(echo $AUTO_IFACES | grep $IFACE)" ]] && usage && exit 1
done

# Core list for each node from sysfs
CORES=$(</sys/devices/system/cpu/online)
[[ "$CORES" ]] || CORES=$(grep ^proc /proc/cpuinfo | cut -f2 -d:)
NODE_DIR=/sys/devices/system/node
for i in $(ls -d $NODE_DIR/node*); do
    i=${i/*node/}
    CORELIST[$i]=$(<$NODE_DIR/node${i}/cpulist)
done

# Numa of interfaces
DEV_DIR=/sys/class/net/$IFACE/device
[[ -e $DEV_DIR/numa_node ]] && NUMA=$(<$DEV_DIR/numa_node)
[[ "$NUMA" ]] && [[ "$NUMA" -gt 0 ]] || NUMA=0


# Support functions
#
# Started by AICoder, pid:m279eb4779ufeb91458609b590620c2299d17d83
generate_mask() {
    local VEC=$1
    local MASK_FILL=""
    local MASK_ZERO="00000000"
    local IDX=0
    local MASK_TMP=0

    if [ $VEC -ge 32 ]; then
        let "IDX = $VEC / 32"
        for ((i=1; i<=$IDX; i++)); do
            MASK_FILL="${MASK_FILL},${MASK_ZERO}"
        done
        let "VEC -= 32 * $IDX"
        MASK_TMP=$((1 << $VEC))
        MASK=$(printf "%X%s" $MASK_TMP $MASK_FILL)
    else
        MASK_TMP=$((1 << $VEC))
        MASK=$(printf "%X" $MASK_TMP)
    fi
    echo $MASK
}
# Ended by AICoder, pid:m279eb4779ufeb91458609b590620c2299d17d83
mask_generate()
{
    FINAL_MASK=""
    MASK1="0"
    MASK2="0"
    MASK3="0"
    MASK4="0"
    MASK5="0"
    MASK6="0"
    MASK7="0"
    MASK8="0"
    
    for core in $CORES; do
        # echo "INFO: generating mask for core $core"
        VEC=$core
        let "IDX = $core / 32"
        let "VEC -= 32 * $IDX"
        MASK=$(generate_mask $VEC)
        # echo "IFO: now IDX=$IDX"
        case $IDX in
        0)
            MASK1=$((0x$MASK1 | 0x$MASK))
            MASK1=$(printf "%X" $MASK1)
            ;;
        1)
            MASK2=$((0x$MASK2 | 0x$MASK))
            MASK2=$(printf "%X" $MASK2)
            ;; 
        2)
            MASK3=$((0x$MASK3 | 0x$MASK))
            MASK3=$(printf "%X" $MASK3)
            ;;
        3) 
            MASK4=$((0x$MASK4 | 0x$MASK))
            MASK4=$(printf "%X" $MASK4)
            ;;
        4)
            MASK5=$((0x$MASK5 | 0x$MASK))
            MASK5=$(printf "%X" $MASK5)
            ;;
        5)
            MASK6=$((0x$MASK6 | 0x$MASK))
            MASK6=$(printf "%X" $MASK6)
            ;;
        6)
            MASK7=$((0x$MASK7 | 0x$MASK))
            MASK7=$(printf "%X" $MASK7)
            ;;
        7)
            MASK8=$((0x$MASK8 | 0x$MASK))
            MASK8=$(printf "%X" $MASK8)
            ;;
        *)
            echo "ERROR: invalid core node $IDX"
        esac
        # Started by AICoder, pid:i279et4779mfeb91458609b590620c0299d17d83
        #FINAL_MASK=$((0x$FINAL_MASK | 0x$MASK))
        #FINAL_MASK=$(printf "%X" $FINAL_MASK)
        #echo "final_mask generated: $FINAL_MASK"
        ## Ended by AICoder, pid:i279et4779mfeb91458609b590620c0299d17d83
    done
    case $IDX in
        0)
            FINAL_MASK="${MASK1}"
            ;;
        1)
            FINAL_MASK="${MASK2},${MASK1}"
            ;; 
        2)
            FINAL_MASK="${MASK3},${MASK2},${MASK1}"
            ;;
        3) 
            FINAL_MASK="${MASK4},${MASK3},${MASK2},${MASK1}"
            ;;
        4)
            FINAL_MASK="${MASK5},${MASK4},${MASK3},${MASK2},${MASK1}"
            ;;
        5)
            FINAL_MASK="${MASK6},${MASK5},${MASK4},${MASK3},${MASK2},${MASK1}"
            ;;
        6)
            FINAL_MASK="${MASK7},${MASK6},${MASK5},${MASK4},${MASK3},${MASK2},${MASK1}"
            ;;
        7)
            FINAL_MASK="${MASK8},${MASK7},${MASK6},${MASK5},${MASK4},${MASK3},${MASK2},${MASK1}"
            ;;
        *)
            echo "ERROR: invalid core node $IDX"
    esac
    echo "FINAL_MASK generated: $FINAL_MASK"
}

set_affinity_cancel()
{
    printf "%s" $FINAL_MASK > /proc/irq/$IRQ/smp_affinity
    printf "%s %4d %16s -> /proc/irq/$IRQ/smp_affinity\n" $IFACE $core $FINAL_MASK
}

set_affinity()
{
    VEC=$core
    if [ $VEC -ge 32 ]
    then
        MASK_FILL=""
        MASK_ZERO="00000000"
        let "IDX = $VEC / 32"
        for ((i=1; i<=$IDX;i++))
        do
            MASK_FILL="${MASK_FILL},${MASK_ZERO}"
        done

        let "VEC -= 32 * $IDX"
        MASK_TMP=$((1<<$VEC))
        MASK=$(printf "%X%s" $MASK_TMP $MASK_FILL)
    else
        MASK_TMP=$((1<<$VEC))
        MASK=$(printf "%X" $MASK_TMP)
    fi
    
    printf "%s" $MASK > /proc/irq/$IRQ/smp_affinity
    printf "%s %4d %16s -> /proc/irq/$IRQ/smp_affinity\n" $IFACE $core $MASK
}

# Allow usage of , or -
#
parse_range () {
    RANGE=${@//,/ }
    RANGE=${RANGE//-/..}
    LIST=""
    for r in $RANGE; do
        # eval lets us use vars in {#..#} range Ex: {0..7} -> 0 1 2 3 4 5 6 7
        # [[ $r =~ "[0-9]+[\.]{2}[0-9]+" ]] && r="$(eval echo {$r})"The =~ Regular Expression match operator no longer requires quoting of the pattern within [[ … ]].
        [[ $r =~ [0-9]+[\.]{2}[0-9]+ ]] && r="$(eval echo {$r})"
        LIST=${LIST}" $r"
    done
    echo $LIST
}

# Affinitize interrupts
#
setaff()
{
    # check for irqbalance running
    #
    IRQBALANCE_ON=`ps ax | grep -v grep | grep -q irqbalance; echo $?`
    if [ "$IRQBALANCE_ON" == "0" ] ; then
        echo "WARNING: irqbalance is running and will likely override this script's affinitization."
        echo "INFO: $(service irqbalance stop)"
        echo "INFO: $(service irqbalance status)"
    else
        echo "INFO: $(service irqbalance status)"
    fi



    # this script only supports interrupt vectors in pairs,
    # modification would be required to support a single Tx or Rx queue
    # per interrupt vector

    queues="${IFACE}-.*TxRx"
    infiniband_device_irqs_path="/sys/class/infiniband/$IFACE/device/msi_irqs"
    net_device_irqs_path="/sys/class/net/$IFACE/device/msi_irqs"
    interface_in_proc_interrupts=$(cat /proc/interrupts | egrep "$IFACE[^0-9,a-z,A-Z]" | awk '{print $1}' | sed 's/://')

    irqs=$(grep "$queues" /proc/interrupts | cut -f1 -d:)
    [[ -z "$irqs" ]] && irqs=$(grep $IFACE /proc/interrupts | cut -f1 -d:)
    [[ -z "$irqs" ]] && [[ "$interface_in_proc_interrupts" != "" ]] && irqs=$interface_in_proc_interrupts
    [[ -z "$irqs" ]] && [[ -d $net_device_irqs_path ]] && irqs=$(ls $net_device_irqs_path | sort -n | tail -n +15)
    [[ -z "$irqs" ]] && [[ -d $infiniband_device_irqs_path ]] && irqs=$(ls $infiniband_device_irqs_path)
    [[ -z "$irqs" ]] && irqs=$(for i in `ls -Ux $net_device_irqs_path` ;\
                               do grep "$i:.*TxRx" /proc/interrupts | grep -v fdir | cut -f 1 -d : ;\
                               done)

    [[ -z "$irqs" ]] && echo "Error: Could not find interrupts for $IFACE"


    CORES=$(parse_range $CORES)
    ncores=$(echo $CORES | wc -w)
    nirqs=$(echo $irqs | wc -w)
    echo "INFO: num of core is $ncores"
    echo "INFO: num of irq  is $nirqs"

    n=1
    judge_same_queue=0
    echo "IFACE   CORE           MASK -> FILE"
    echo "==================================="
    if [ "$CANCEL_ENA" -eq 1 ]; then
        mask_generate
        for IRQ in $irqs; do
        set_affinity_cancel
        done
    else
        for IRQ in $irqs; do
        if [ "$judge_same_queue" -eq 0 ]; then
            [[ "$n" -gt "$ncores" ]] && n=1
            j=1
            # much faster than calling cut for each
            for i in $CORES; do
                [[ $((j++)) -ge $n ]] && break
            done
            core=$i
            set_affinity
            judge_same_queue=1
        else
            j=1
            # much faster than calling cut for each
            for i in $CORES; do
                [[ $((j++)) -ge $n ]] && break
            done
            core=$i
            set_affinity
            ((n++))
            judge_same_queue=0
        fi
        done
    fi

}


# now the actual useful bits of code
#
for IFACE in $IFACES; do
    # echo $IFACE being modified
    case "$AFF" in
        local)  CORES=${CORELIST[$NUMA]} ;;
        numa)   CORES=${CORELIST[$RNUMA]} ;;
        all)    CORES=$CORES  ;;
        [0-9]*) CORES=$AFF ;;
        *) usage && exit 1 ;;
    esac

    [[ -z $CORES ]] && echo "Error: No cores to set irq affiniy" && exit 1

    # call the worker function
    setaff
done


