/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_cfg_api.h
* ļʶ : 
* ժҪ : CFGģݽṹͺ
* ˵ : 
* ǰ汾 : 
*      : lfq
*  : 2015/02/13
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef _DPP_CFG_API_H_
#define _DPP_CFG_API_H_

#if ZXIC_REAL("header file")
#include "dpp_dev.h"
#include "zxic_common.h"
#endif

#if ZXIC_REAL("data struct define")

typedef enum dpp_dma_buff_size_mode_e
{
    BUFF_SIZE_8M   = 1,
    BUFF_SIZE_16M  = 2,
}DPP_DMA_BUFF_SIZE_MODE_E;

typedef enum dpp_dma_en_e
{
    DPP_DMA_DISABLE = 0,
    DPP_DMA_ENABLE = 1,
}DPP_DMA_EN_E;

typedef enum dpp_endian_e
{
    DPP_DMA_LITTLE_ENDIAN = 0,
    DPP_DMA_BIG_ENDIAN_4B = 1,
    DPP_DMA_BIG_ENDIAN    = 2, //Ϳȷ
}DPP_DMA_ENDIAN_E;


#endif


#if ZXIC_REAL("DMA_API")
/***********************************************************/
/** dmaʼ
* @param   dev_id   оƬid
* @param   chip_vir_addr   оƬַ
* @param   buff_phy_addr   ռںַ̬
* @param   buff_vir_addr   ռûַ̬
* @param   buff_size       С
*
* @return  
* @remark  
* @see     
* @author  sjf      @date  2015/03/24
************************************************************/
/*
ZXIC_UINT32 dpp_dma_init(ZXIC_UINT32 dev_id,
                    ZXIC_ADDR_T chip_vir_addr,
                    ZXIC_ADDR_T buff_phy_addr,
                    ZXIC_ADDR_T buff_vir_addr,
                    DPP_DMA_BUFF_SIZE_MODE_E buff_size);
*/
/***********************************************************/
/** ͻȡ
* @param   dev_id   оƬid 
* @param   offset   û̬ͻֽƫ
* @param   len   ȡݳ
* @param   p_data   Σݷصַ
*
* @return  
* @remark  
* @see     
* @author  00105213     @date  2015/03/28
************************************************************/
ZXIC_UINT32 dpp_dma_up_read(ZXIC_UINT32 dev_id,
                       ZXIC_UINT32 offset,
                       ZXIC_UINT32 len,
                       ZXIC_UINT8 * p_data);

/***********************************************************/
/** 
* @param   dev_id  оƬid 
* @param   up_type   Դͣ0: eram_up, 1: ddr3_up
* @param   base_addr   Դַ, 128bitsΪλԴΪeramʱ20bitsЧλԴΪddr3ʱ30bitsЧλ
* @param   len   ݳȣ32bitsΪλ
* @param   dest_offset   ĿĻƫƣ32bitsΪλ
*
* @return  
* @remark  lenΪλ,dest_offsetΪλ
* @see     
* @author  00105213      @date  2014/08/05
************************************************************/
ZXIC_UINT32 dpp_dma_up_work(ZXIC_UINT32 dev_id, 
                       ZXIC_UINT32 up_type, 
                       ZXIC_UINT32 base_addr, 
                       ZXIC_UINT32 len, 
                       ZXIC_UINT32 dest_offset);

/***********************************************************/
/** bdݶȡ
* @param   dev_id   оƬid
* @param   bd_index   bd
* @param   p_valid   ȡЧ
* @param   p_len   ȡݳȣΪλ
* @param   p_data   ȡ
*
* @return  
* @remark  
* @see     
* @author  sjf      @date  2015/04/07
************************************************************/
ZXIC_UINT32 dpp_dma_bd_work(ZXIC_UINT32 dev_id,
                       ZXIC_UINT32 bd_index,
                       ZXIC_UINT32 *p_valid,
                       ZXIC_UINT32 *p_len,
                       ZXIC_UINT32 *p_data);

/***********************************************************/
/** 
* @param   dev_id        оƬid
* @param   up_type       Դͣ0: eram_up, 1: ddr3_up
* @param   base_addr     Դַ, 128bitsΪλԴΪeramʱ20bitsЧλԴΪddr3ʱ30bitsЧλ
* @param   len           ݳȣ32bitsΪλ
* @param   dest_offset   ĿĻƫƣ32bitsΪλ
*
* @return
* @remark  lenΪλ,dest_offsetΪλ
* @see
* @author  YXH     @date  2020/09/22
************************************************************/
ZXIC_UINT32 dpp_dma_up_work_ext(ZXIC_UINT32 dev_id,
                           ZXIC_UINT32 up_type,
                           ZXIC_UINT32 base_addr,
                           ZXIC_UINT32 len,
                           ZXIC_UINT32 dest_offset);

/***********************************************************/
/** CPUͶ
* @param   dev_id   оƬid
*
* @return
* @remark  
* @see
* @author  YXH     @date  2020/09/17
************************************************************/
ZXIC_UINT32 dpp_dma_ext_up_set(ZXIC_UINT32 dev_id);


#endif

#if ZXIC_REAL("LED_API")

/***********************************************************/
/** led״̬͵
* @param   dev_id    豸
* @param   led_cycle    led λ(10ns)
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  lfq      @date  2015/04/13
************************************************************/
DPP_STATUS dpp_cfg_led_cycle_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 led_cycle);

/***********************************************************/
/** led
* @param   dev_id    豸
* @param   led_en       ledź
                        0:close
                        1:open
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  lfq      @date  2015/04/13
************************************************************/
DPP_STATUS dpp_cfg_led_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 led_en);

#endif

#if ZXIC_REAL("INIT")

/***********************************************************/
/** CFGģʼ
* @param   dev_id  豸 
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  lfq      @date  2015/04/13
************************************************************/
DPP_STATUS dpp_cfg_init(ZXIC_UINT32 dev_id);

#endif

/***********************************************************/
/** DMAͨ
* @param   dev_id
* @param   pcie_flag д1axi pcieʣ0inner ddr
*
* @return
* @remark  
* @see
* @author  YXH      @date  2020/09/09
************************************************************/
ZXIC_UINT32 dpp_cfg_pcie_ddr_switch(ZXIC_UINT32 dev_id, ZXIC_UINT32 pcie_flag);

/***********************************************************/
/** ȡDMAͨ
* @param   dev_id
* @param   ddr_switch 1axi pcieʣ0inner ddr
*
* @return
* @remark  
* @see
* @author  YXH      @date  2020/09/09
************************************************************/
ZXIC_UINT32 dpp_cfg_pcie_ddr_switch_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *ddr_switch);

#endif /* dpp_ppu_api.h */



