/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_ppu_api.h
* ļʶ : 
* ժҪ : PPUģݽṹͺ
* ˵ : 
* ǰ汾 : 
*      : wcl
*  : 2015/02/13
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef _DPP_PPU_API_H_
#define _DPP_PPU_API_H_


#if ZXIC_REAL("header file")
#include "dpp_module.h"

#endif

#if ZXIC_REAL("data struct define")

/** mcode version time */
typedef struct dpp_version_t
{
    /*Ӧ΢αָ version = expr_a.expr_b.expr_c*/
    ZXIC_UINT32 version_a; /**<  @brief expr_a*/
    ZXIC_UINT32 version_b; /**<  @brief expr_b*/
    ZXIC_UINT32 version_c; /**<  @brief xpr_c*/

    /*Ӧ΢汾ʱ ///Сʱ*/
    ZXIC_UINT32 year;
    ZXIC_UINT32 month;
    ZXIC_UINT32 day;
    ZXIC_UINT32 hour;
}DPP_VERSION_T;

/**  SDT*/
typedef struct dpp_sdt_tbl_data_t
{
    ZXIC_UINT32 data_high32; /**<  @brief SDTݸ32bit*/
    ZXIC_UINT32 data_low32;  /**<  @brief SDTݵ32bit*/
}DPP_SDT_TBL_DATA_T;

#endif

#if ZXIC_REAL("interrupt data struct define")
/**  PPU ָRAM ECCжԭ*/
typedef struct dpp_ppu_ram_parity_err_t
{
    ZXIC_UINT32 instrmem2_bank3_parity_err; /**<  @brief ָRAM instrmem2 BANK3 parity */
    ZXIC_UINT32 instrmem2_bank2_parity_err; /**<  @brief ָRAM instrmem2 BANK2 parity */
    ZXIC_UINT32 instrmem2_bank1_parity_err; /**<  @brief ָRAM instrmem2 BANK1 parity */
    ZXIC_UINT32 instrmem2_bank0_parity_err; /**<  @brief ָRAM instrmem2 BANK0 parity */
    ZXIC_UINT32 instrmem1_bank3_parity_err; /**<  @brief ָRAM instrmem1 BANK3 parity */
    ZXIC_UINT32 instrmem1_bank2_parity_err; /**<  @brief ָRAM instrmem1 BANK2 parity */
    ZXIC_UINT32 instrmem1_bank1_parity_err; /**<  @brief ָRAM instrmem1 BANK1 parity */
    ZXIC_UINT32 instrmem1_bank0_parity_err; /**<  @brief ָRAM instrmem1 BANK0 parity */
    ZXIC_UINT32 instrmem0_bank3_parity_err; /**<  @brief ָRAM instrmem0 BANK3 parity */
    ZXIC_UINT32 instrmem0_bank2_parity_err; /**<  @brief ָRAM instrmem0 BANK2 parity */
    ZXIC_UINT32 instrmem0_bank1_parity_err; /**<  @brief ָRAM instrmem0 BANK1 parity */
    ZXIC_UINT32 instrmem0_bank0_parity_err; /**<  @brief ָRAM instrmem0 BANK0 parity */
}DPP_PPU_RAM_PARITY_ERR_T;

/**  PPU MEָRAM ECCжԭ*/
typedef struct dpp_ppu_me_interrupt_t
{
    ZXIC_UINT32 me7_interrupt_mask ;     /**<  @brief me7coreж*/
    ZXIC_UINT32 me6_interrupt_mask ;     /**<  @brief me6coreж*/
    ZXIC_UINT32 me5_interrupt_mask ;     /**<  @brief me5coreж*/
    ZXIC_UINT32 me4_interrupt_mask ;     /**<  @brief me4coreж*/
    ZXIC_UINT32 me3_interrupt_mask ;     /**<  @brief me3coreж*/
    ZXIC_UINT32 me2_interrupt_mask ;     /**<  @brief me2coreж*/
    ZXIC_UINT32 me1_interrupt_mask ;     /**<  @brief me1coreж*/
    ZXIC_UINT32 me0_interrupt_mask ;     /**<  @brief me0coreж*/

}DPP_PPU_ME_INTERRUPT_T;

/**  cluster mexĴжԭ*/
typedef struct dpp_ppu_cluster_600m_mex_fifo_int_t
{
    ZXIC_UINT32 ppu_se_ikey_afifo_underflow;       /**<  @brief seƬڱkey fifoж*/
    ZXIC_UINT32 ppu_se_ekey_afifo_underflow;       /**<  @brief seƬkey fifoж*/
    ZXIC_UINT32 ppu_sta_key_afifo_underflow;       /**<  @brief ͳƼkey fifoж*/
    ZXIC_UINT32 ppu_cluster_mf_in_overflow;        /**<  @brief metafram fifoдж*/
    ZXIC_UINT32 ppu_ese_rsp_afifo_overflow;        /**<  @brief seƬ rsp fifoдж*/
    ZXIC_UINT32 ppu_ise_rsp_afifo_overflow;        /**<  @brief seƬڱ rsp fifoдж*/
    ZXIC_UINT32 ppu_sta_rsp_afifo_overflow;        /**<  @brief ͳƼ rsp fifoдж*/
}DPP_PPU_CLUSTER_600M_MEX_FIFO_INT_T;

/**  cluster mexĴжԭ*/
typedef struct dpp_ppu_cluster_1200m_mex_fifo_int_t
{
    ZXIC_UINT32 ppu_se_key_afifo_32x54_wrapper_overflow_flag;              /**<  @brief ppu_se_key_afifo_32x54_wrapperдж*/
    ZXIC_UINT32 ppu_se_key_afifo_32x665_wrapper_overflow_flag;             /**<  @brief ppu_se_key_afifo_32x665_wrapperдж*/
    ZXIC_UINT32 ppu_sta_key_afifo_32x110_wrapper_overflow_flag;            /**<  @brief ppu_sta_key_afifo_32x110_wrapperдж*/
    ZXIC_UINT32 ppu_cluster_mf_in_afifo_16x2048_wrapper_underflow_flag;    /**<  @brief ppu_cluster_mf_in_afifo_32x2048_wrapperж*/
    ZXIC_UINT32 ppu_pbu_mcode_pf_rsp_fifo_32x13_wrapper_overflow_flag;     /**<  @brief ppu_pbu_mcode_pf_rsp_fifoдж*/
    ZXIC_UINT32 ppu_pbu_mcode_pf_rsp_fifo_32x13_wrapper_underflow_flag;    /**<  @brief ppu_pbu_mcode_pf_rsp_fifo_32x13_wrapperж*/
    ZXIC_UINT32 ppu_coprocess_rsp_fifo_32x77_wrapper_overflow_flag;        /**<  @brief ppu_coprocess_rsp_fifo_32x77_wrapperдж*/
    ZXIC_UINT32 ppu_coprocess_rsp_fifo_32x77_wrapper_underflow_flag;       /**<  @brief ppu_coprocess_rsp_fifo_32x77_wrapperж*/
    ZXIC_UINT32 ppu_coprocess_rsp_fwft_fifo_128x78_wrapper_overflow_flag;  /**<  @brief ppu_coprocess_rsp_fwft_fifo_128x78_wrapperдж*/
    ZXIC_UINT32 ppu_coprocess_rsp_fwft_fifo_128x78_wrapper_underflow_flag; /**<  @brief ppu_coprocess_rsp_fwft_fifo_128x78_wrapperж*/
    ZXIC_UINT32 ppu_ese_rsp_afifo_64x271_wrapper_u0_underflow_flag;        /**<  @brief ppu_ese_rsp_afifo_64x271_wrapper_u0дж*/
    
    ZXIC_UINT32 ese_rsp_ram_free_ptr_u0_overflow_flag;                     /**<  @brief ese_rsp_ram_free_ptr_u0дж*/
    ZXIC_UINT32 ese_rsp_ram_free_ptr_u0_underflow_flag;                    /**<  @brief ese_rsp_ram_free_ptr_u0ж*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u0_overflow_flag;  /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u0дж*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u0_underflow_flag; /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u0ж*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u1_overflow_flag;  /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u1дж*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u1_underflow_flag; /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u1ж*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u2_overflow_flag;  /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u2дж*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u2_underflow_flag; /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u2ж*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u3_overflow_flag;  /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u3джϱ*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u3_underflow_flag; /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u3жϱ*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u4_overflow_flag;  /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u4джϱ*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u4_underflow_flag; /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u4жϱ*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u5_overflow_flag;  /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u5джϱ*/
    ZXIC_UINT32 ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u5_underflow_flag; /**<  @brief ppu_ese_rsp_ptr_fwft_fifo_128x7_wrapper_u5жϱ*/
    ZXIC_UINT32 ppu_ise_rsp_afifo_64x143_wrapper_u0_underflow_flag;        /**<  @brief ppu_ise_rsp_afifo_64x143_wrapper_u0жϱ*/
    ZXIC_UINT32 ise_rsp_ram_free_ptr_u0_overflow_flag;                     /**<  @brief ise_rsp_ram_free_ptr_u0джϱ  */
    ZXIC_UINT32 ise_rsp_ram_free_ptr_u0_underflow_flag;                    /**<  @brief ise_rsp_ram_free_ptr_u0жϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u0_overflow_flag;  /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u0джϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u0_underflow_flag; /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u0жϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u1_overflow_flag;  /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u1джϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u1_underflow_flag; /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u1жϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u2_overflow_flag;  /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u2джϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u2_underflow_flag; /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u2жϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u3_overflow_flag;  /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u3джϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u3_underflow_flag; /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u3жϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u4_overflow_flag;  /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u4джϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u4_underflow_flag; /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u4жϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u5_overflow_flag;  /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u5джϱ*/
    ZXIC_UINT32 ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u5_underflow_flag; /**<  @brief ppu_ise_rsp_ptr_fwft_fifo_128x7_wrapper_u5жϱ*/
    ZXIC_UINT32 ppu_sta_rsp_afifo_64x79_wrapper_underflow_flag;            /**<  @brief ppu_sta_rsp_afifo_64x79_wrapperжϱ*/
    ZXIC_UINT32 ppu_sta_rsp_fwft_fifo_128x79_wrapper_overflow_flag;        /**<  @brief ppu_sta_rsp_fwft_fifo_128x79_wrapperджϱ*/
    ZXIC_UINT32 ppu_sta_rsp_fwft_fifo_128x79_wrapper_underflow_flag;       /**<  @brief ppu_sta_rsp_fwft_fifo_128x79_wrapperжϱ*/
}DPP_PPU_CLUSTER_1200M_MEX_FIFO_INT_T;

typedef struct dpp_ppu_ppu_ram_err_t
{
    ZXIC_UINT32 dup_freeptr_fwft_fifo_128x7_wrapper_u0_parity_err_flag;             /**<  @brief dup_freeptr_fwft_fifo_128x7_wrapper_u0_parity_errжϱ*/
    ZXIC_UINT32 free_global_num_fwft_fifo_8192x13_wrapper_u0_parity_err_flag;       /**<  @brief free_global_num_fwft_fifo_8192x13_wrapper_u0_parity_errжϱ*/
    ZXIC_UINT32 ppu_mccnt_fifo_32x15_wrapper_u0_parity_err_flag;                    /**<  @brief ppu_mccnt_fifo_32x15_wrapper_u0_parity_errжϱ*/
    ZXIC_UINT32 ppu_reorder_link_table_ram_1r1w_8192x13_wrapper_u1_parity_err_flag; /**<  @brief ppu_reorder_link_table_ram_1r1w_8192x13_wrapper_u1_parity_errжϱ*/
    ZXIC_UINT32 ppu_reorder_link_table_ram_1r1w_8192x13_wrapper_u0_parity_err_flag; /**<  @brief ppu_reorder_link_table_ram_1r1w_8192x13_wrapper_u0_parity_errжϱ*/
}DPP_PPU_PPU_RAM_ERR_T;

typedef struct dpp_ppu_cls_ram_err_600m_t
{
    ZXIC_UINT32 ppu_sdt_table_ram_2rw_256x64_wrapper_parity_errb_flag; /**<  @brief ppu_sdt_table_ram_2rw_256x64_wrapper_parity_errbжϱ*/
    ZXIC_UINT32 ppu_sdt_table_ram_2rw_256x64_wrapper_parity_erra_flag; /**<  @brief ppu_sdt_table_ram_2rw_256x64_wrapper_parity_errbaжϱ*/
}DPP_PPU_CLS_RAM_ERR_600M_T;

/**  cluster mexĴжԭ*/
typedef struct dpp_ppu_cluster_me_fifo_int_t
{
    ZXIC_UINT32 me_except_refetch_pc_overflow_flag;  /**<  @brief me_except_refetch_pcджϱ*/
    ZXIC_UINT32 me_except_refetch_pc_underflow_flag; /**<  @brief me_except_refetch_pcжϱ*/
    
    ZXIC_UINT32 me_free_pkt_q_overflow_flag;         /**<  @brief me_free_pkt_qдж״̬*/
    ZXIC_UINT32 me_free_pkt_q_underflow_flag;        /**<  @brief me_free_pkt_qж״̬*/
    ZXIC_UINT32 me_free_thread_q_overflow_flag;      /**<  @brief me_free_thread_qдж״̬*/
    ZXIC_UINT32 me_free_thread_q_underflow_flag;     /**<  @brief me_free_thread_qж״̬*/
    ZXIC_UINT32 me_pkt_in_overflow_flag;             /**<  @brief me_pkt_in_дж״̬*/  
    ZXIC_UINT32 me_pkt_in_underflow_flag;            /**<  @brief me_pkt_in_ж״̬*/ 
    ZXIC_UINT32 me_rdy_q_overflow_flag;              /**<  @brief me_rdy_qдж״̬*/ 
    ZXIC_UINT32 me_rdy_q_underflow_flag;             /**<  @brief me_rdy_qж״̬*/
    ZXIC_UINT32 me_pkt_out_q_overflow_flag;          /**<  @brief me_pkt_out_qдж״̬*/
    ZXIC_UINT32 me_pkt_out_q_underflow_flag;         /**<  @brief me_pkt_out_qж״̬*/
    ZXIC_UINT32 me_continue_q_overflow_flag;         /**<  @brief me_continue_qдж״̬*/
    ZXIC_UINT32 me_continue_q_underflow_flag;        /**<  @brief me_continue_qж״̬*/
    ZXIC_UINT32 me_esrh_q_overflow_flag;             /**<  @brief me_esrh_qдж״̬*/ 
    ZXIC_UINT32 me_esrh_q_underflow_flag;            /**<  @brief me_esrh_qж״̬*/
    ZXIC_UINT32 me_isrh_q_overflow_flag;             /**<  @brief me_isrh_qдж״̬*/
    ZXIC_UINT32 me_isrh_q_underflow_flag;            /**<  @brief me_isrh_qж״̬*/  
    ZXIC_UINT32 me_cache_miss_q_overflow_flag;       /**<  @brief me_cache_miss_qдж״̬*/
    ZXIC_UINT32 me_cache_miss_q_underflow_flag;      /**<  @brief me_cache_miss_qж״̬*/ 
    ZXIC_UINT32 me_base_q_u0_overflow_flag;          /**<  @brief me_base_q_u0дж״̬*/
    ZXIC_UINT32 me_base_q_u0_underflow_flag;         /**<  @brief me_base_q_u0ж״̬*/
    ZXIC_UINT32 me_base_q_u1_overflow_flag;          /**<  @brief me_base_q_u1дж״̬*/ 
    ZXIC_UINT32 me_base_q_u1_underflow_flag;         /**<  @brief me_base_q_u1ж״̬*/
    ZXIC_UINT32 me_base_q_u2_overflow_flag;          /**<  @brief me_base_q_u2дж״̬*/ 
    ZXIC_UINT32 me_base_q_u2_underflow_flag;         /**<  @brief me_base_q_u2ж״̬*/
    ZXIC_UINT32 me_base_q_u3_overflow_flag;          /**<  @brief me_base_q_u3дж״̬*/ 
    ZXIC_UINT32 me_base_q_u3_underflow_flag;         /**<  @brief me_base_q_u3ж״̬*/
    ZXIC_UINT32 me_reg_pc_q_overflow_flag;           /**<  @brief me_reg_pc_qдж״̬*/
    ZXIC_UINT32 me_reg_pc_q_underflow_flag;          /**<  @brief me_reg_pc_qж״̬*/
    ZXIC_UINT32 me_branch_q_overflow_flag;           /**<  @brief me_branch_qдж״̬*/
    ZXIC_UINT32 me_branch_q_underflow_flag;          /**<  @brief me_branch_qж״̬*/
    ZXIC_UINT32 me_pkt_base_q_overflow_flag;         /**<  @brief me_pkt_base_qдж״̬*/
    ZXIC_UINT32 me_pkt_base_q_underflow_flag;        /**<  @brief me_pkt_base_qж״̬*/
}DPP_PPU_CLUSTER_ME_FIFO_INT_T;


typedef struct dpp_ppu_ppu_isu_ppu_demux_fifo_int_t
{
    ZXIC_UINT32 isu_in_para_fwft_fifo_32x81_wrapper_u0_overflow_flag;  /**<  @brief isu_in_para_fwft_fifo_32x81_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 isu_in_para_fwft_fifo_32x81_wrapper_u0_underflow_flag; /**<  @brief isu_in_para_fwft_fifo_32x81_wrapper_u0_underflowжϱ*/
    ZXIC_UINT32 isu_in_fifo_64x81_wrapper_u0_overflow_flag;            /**<  @brief isu_in_fifo_64x81_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 isu_in_fifo_64x81_wrapper_u0_underflow_flag;           /**<  @brief isu_in_fifo_64x81_wrapper_u0_underflowжϱ*/
}DPP_PPU_PPU_ISU_PPU_DEMUX_FIFO_INT_T;

typedef struct dpp_ppu_ppu_ppu_multicast_fifo_int_t
{
    ZXIC_UINT32 pf_req_fwft_fifo_16x36_wrapper_u0_overflow_flag;        /**<  @brief pf_req_fwft_fifo_16x36_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 pf_req_fwft_fifo_16x36_wrapper_u0_underflow_flag;       /**<  @brief pf_req_fwft_fifo_16x36_wrapper_u0_underflowжϱ*/
    ZXIC_UINT32 pf_rsp_fwft_fifo_32x34_wrapper_u0_overflow_flag;        /**<  @brief pf_rsp_fwft_fifo_32x34_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 pf_rsp_fwft_fifo_32x34_wrapper_u0_underflow_flag;       /**<  @brief pf_rsp_fwft_fifo_32x34_wrapper_u0_underflowжϱ*/
    ZXIC_UINT32 dup_para_fwft_fifo_16x35_wrapper_u0_overflow_flag;      /**<  @brief dup_para_fwft_fifo_16x35_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 dup_para_fwft_fifo_16x35_wrapper_u0_underflow_flag;     /**<  @brief dup_para_fwft_fifo_16x35_wrapper_u0_underflowжϱ*/
    ZXIC_UINT32 se_mc_rsp_fwft_fifo_32x17_wrapper_u0_overflow_flag;     /**<  @brief se_mc_rsp_fwft_fifo_32x17_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 se_mc_rsp_fwft_fifo_32x17_wrapper_u0_underflow_flag;    /**<  @brief se_mc_rsp_fwft_fifo_32x17_wrapper_u0_underflowжϱ*/
    ZXIC_UINT32 sa_para_fwft_fifo_64x17_wrapper_u0_overflow_flag;       /**<  @brief sa_para_fwft_fifo_64x17_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 sa_para_fwft_fifo_64x17_wrapper_u0_underflow_flag;      /**<  @brief sa_para_fwft_fifo_64x17_wrapper_u0_underflowжϱ*/
    ZXIC_UINT32 group_id_fifo_64x16_wrapper_u0_overflow_flag;           /**<  @brief group_id_fifo_64x16_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 group_id_fifo_64x16_wrapper_u0_underflow_flag;          /**<  @brief group_id_fifo_64x16_wrapper_u0_underflowжϱ*/
    ZXIC_UINT32 isu_mc_para_fwft_fifo_128x34_wrapper_u0_overflow_flag;  /**<  @brief isu_mc_para_fwft_fifo_128x34_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 isu_mc_para_fwft_fifo_128x34_wrapper_u0_underflow_flag; /**<  @brief isu_mc_para_fwft_fifo_128x34_wrapper_u0_underflowжϱ*/
    ZXIC_UINT32 dup_freeptr_fwft_fifo_128x7_wrapper_u0_overflow_flag;   /**<  @brief dup_freeptr_fwft_fifo_128x7_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 dup_freeptr_fwft_fifo_128x7_wrapper_u0_underflow_flag;  /**<  @brief dup_freeptr_fwft_fifo_128x7_wrapper_u0_underflowжϱ*/
    ZXIC_UINT32 car_flag_fifo_32x1_wrapper_overflow_flag;               /**<  @brief car_flag_fifo_32x1_wrapper_overflowжϱ*/
    ZXIC_UINT32 car_flag_fifo_32x1_wrapper_underflow_flag;              /**<  @brief car_flag_fifo_32x1_wrapper_underflowжϱ*/
}DPP_PPU_PPU_PPU_MULTICAST_FIFO_INT_T;

typedef struct dpp_ppu_ppu_ppu_in_schedule_fifo_int_t
{
    ZXIC_UINT32 free_global_num_fwft_fifo_8192x13_wrapper_u0_overflow_flag;  /**<  @brief free_global_num_fwft_fifo_8192x13_джϱ*/
    ZXIC_UINT32 free_global_num_fwft_fifo_8192x13_wrapper_u0_underflow_flag; /**<  @brief free_global_num_fwft_fifo_8192x13_նжϱ*/
    ZXIC_UINT32 mc_mf_fifo_16x2048_wrapper_u0_overflow_flag;                 /**<  @brief mc_mf_fifo_16x2048_джϱ*/
    ZXIC_UINT32 mc_mf_fifo_16x2048_wrapper_u0_underflow_flag;                /**<  @brief mc_mf_fifo_16x2048_նжϱ*/
    ZXIC_UINT32 uc_mf_fifo_96x2048_wrapper_u0_overflow_flag;                 /**<  @brief uc_mf_fifo_96x2048_джϱ*/
    ZXIC_UINT32 uc_mf_fifo_96x2048_wrapper_u0_underflow_flag;                /**<  @brief uc_mf_fifo_96x2048_նжϱ*/
}DPP_PPU_PPU_PPU_IN_SCHEDULE_FIFO_INT_T;

typedef struct dpp_ppu_ppu_ppu_mf_out_fifo_int_t
{
    ZXIC_UINT32 ppu_cluster5_mf_out_afifo_16x2048_wrapper_overflow_flag;  /**<  @brief cluster5fifoджϱ*/
    ZXIC_UINT32 ppu_cluster5_mf_out_afifo_16x2048_wrapper_underflow_flag; /**<  @brief cluster5fifoնжϱ*/
    ZXIC_UINT32 ppu_cluster4_mf_out_afifo_16x2048_wrapper_overflow_flag;  /**<  @brief cluster4fifoджϱ*/
    ZXIC_UINT32 ppu_cluster4_mf_out_afifo_16x2048_wrapper_underflow_flag; /**<  @brief cluster4fifoնжϱ*/
    ZXIC_UINT32 ppu_cluster3_mf_out_afifo_16x2048_wrapper_overflow_flag;  /**<  @brief cluster3fifoджϱ*/
    ZXIC_UINT32 ppu_cluster3_mf_out_afifo_16x2048_wrapper_underflow_flag; /**<  @brief cluster3fifoնжϱ*/
    ZXIC_UINT32 ppu_cluster2_mf_out_afifo_16x2048_wrapper_overflow_flag;  /**<  @brief cluster2fifoджϱ*/
    ZXIC_UINT32 ppu_cluster2_mf_out_afifo_16x2048_wrapper_underflow_flag; /**<  @brief cluster2fifoնжϱ*/
    ZXIC_UINT32 ppu_cluster1_mf_out_afifo_16x2048_wrapper_overflow_flag;  /**<  @brief cluster1fifoджϱ*/
    ZXIC_UINT32 ppu_cluster1_mf_out_afifo_16x2048_wrapper_underflow_flag; /**<  @brief cluster1fifoնжϱ*/
    ZXIC_UINT32 ppu_cluster0_mf_out_afifo_16x2048_wrapper_overflow_flag;  /**<  @brief cluster0fifoджϱ*/
    ZXIC_UINT32 ppu_cluster0_mf_out_afifo_16x2048_wrapper_underflow_flag; /**<  @brief cluster0fifoնжϱ*/
}DPP_PPU_PPU_PPU_MF_OUT_FIFO_INT_T;

typedef struct dpp_ppu_ppu_pbu_mcode_pf_req_schedule_fifo_int_t
{
    ZXIC_UINT32 ppu_cluster5_pbu_mcode_pf_req_afifo_32x15_wrapper_overflow_flag;  /**<  @brief cluster5ָԤȡfifoджϱ*/
    ZXIC_UINT32 ppu_cluster4_pbu_mcode_pf_req_afifo_32x15_wrapper_overflow_flag;  /**<  @brief cluster4ָԤȡfifoджϱ*/
    ZXIC_UINT32 ppu_cluster3_pbu_mcode_pf_req_afifo_32x15_wrapper_overflow_flag;  /**<  @brief cluster3ָԤȡfifoджϱ*/
    ZXIC_UINT32 ppu_cluster2_pbu_mcode_pf_req_afifo_32x15_wrapper_overflow_flag;  /**<  @brief cluster2ָԤȡfifoджϱ*/
    ZXIC_UINT32 ppu_cluster1_pbu_mcode_pf_req_afifo_32x15_wrapper_overflow_flag;  /**<  @brief cluster1ָԤȡfifoджϱ*/
    ZXIC_UINT32 ppu_cluster0_pbu_mcode_pf_req_afifo_32x15_wrapper_overflow_flag;  /**<  @brief cluster0ָԤȡfifoджϱ*/
    ZXIC_UINT32 ppu_cluster5_pbu_mcode_pf_req_afifo_32x15_wrapper_underflow_flag; /**<  @brief cluster5ָԤȡfifoնжϱ*/
    ZXIC_UINT32 ppu_cluster4_pbu_mcode_pf_req_afifo_32x15_wrapper_underflow_flag; /**<  @brief cluster4ָԤȡfifoնжϱ*/
    ZXIC_UINT32 ppu_cluster3_pbu_mcode_pf_req_afifo_32x15_wrapper_underflow_flag; /**<  @brief cluster3ָԤȡfifoնжϱ*/
    ZXIC_UINT32 ppu_cluster2_pbu_mcode_pf_req_afifo_32x15_wrapper_underflow_flag; /**<  @brief cluster2ָԤȡfifoնжϱ*/
    ZXIC_UINT32 ppu_cluster1_pbu_mcode_pf_req_afifo_32x15_wrapper_underflow_flag; /**<  @brief cluster1ָԤȡfifoնжϱ*/
    ZXIC_UINT32 ppu_cluster0_pbu_mcode_pf_req_afifo_32x15_wrapper_underflow_flag; /**<  @brief cluster0ָԤȡfifoնжϱ*/
}DPP_PPU_PPU_PBU_MCODE_PF_REQ_SCHEDULE_FIFO_INT_T;

typedef struct dpp_ppu_ppu_pbu_mcode_pf_rsp_schedule_fifo_int_t
{
    ZXIC_UINT32 ppu_pbu_mcode_pf_rsp_afifo_64x16_wrapper_u0r_underflow_flag; /**<  @brief ppu΢ָ뷵fifoնжϱ*/
    ZXIC_UINT32 ppu_pbu_mcode_pf_rsp_afifo_64x16_wrapper_u0_overflow_flag;   /**<  @brief ppu΢ָ뷵fifoджϱ*/
}DPP_PPU_PPU_PBU_MCODE_PF_RSP_SCHEDULE_FIFO_INT_T;

typedef struct dpp_ppu_ppu_ppu_mccnt_fifo_int_t
{
    ZXIC_UINT32 ppu_mccnt_fifo_32x15_wrapper_u0_overflow_flag;       /**<  @brief ppu_mccnt_fifo_32x15_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 ppu_mccnt_fifo_32x15_wrapper_u0_underflow_flag;      /**<  @brief ppu_mccnt_fifo_32x15_wrapper_u0_underflowжϱ*/
    ZXIC_UINT32 ppu_wb_data_fifo_32x2048_wrapper_u0_overflow_flag;   /**<  @brief ppu_wb_data_fifo_32x2048_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 ppu_wb_data_fifo_32x2048_wrapper_u0_underflow_flag;  /**<  @brief ppu_wb_data_fifo_32x2048_wrapper_u0_underflowжϱ*/
    ZXIC_UINT32 mccnt_rsp_fifo_32x1_wrapper_u0_overflow_flag;        /**<  @brief mccnt_rsp_fifo_32x1_wrapper_u0_overflowжϱ*/
    ZXIC_UINT32 mccnt_rsp_fifo_32x1_wrapper_u0_underflow_flag;       /**<  @brief mccnt_rsp_fifo_32x1_wrapper_u0_underflowжϱ*/
}DPP_PPU_PPU_PPU_MCCNT_FIFO_INT_T;

typedef struct dpp_ppu_ppu_coprocessor_fifo_int_t
{
    ZXIC_UINT32 ppu_cop_random_mod_para_delay_fifo_48x16_wrapper_overflow_flag;   /**<  @brief Эrandom_modfifoджϱ*/
    ZXIC_UINT32 ppu_cop_random_mod_para_delay_fifo_48x16_wrapper_underflow_flag;  /**<  @brief Эrandom_modfifoնжϱ*/

    ZXIC_UINT32 ppu_cop_result_fwft_fifo_80x80_wrapper_overflow_flag;    /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_result_fwft_fifo_80x80_wrapper_underflow_flag;   /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_delay_fifo_48x16_wrapper_overflow_flag;          /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_delay_fifo_48x16_wrapper_underflow_flag;         /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_delay_fifo_16x48_wrapper_overflow_flag;          /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_delay_fifo_16x48_wrapper_underflow_flag;         /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_delay_fifo_16x32_wrapper_overflow_flag;          /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_delay_fifo_16x32_wrapper_underflow_flag;         /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_result_fwft_fifo_96x80_wrapper_overflow_flag;    /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_result_fwft_fifo_96x80_wrapper_underflow_flag;   /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_delay_fifo_16x16_wrapper_overflow_flag;          /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_delay_fifo_16x16_wrapper_underflow_flag;         /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_result_fwft_fifo_32x80_wrapper_overflow_flag;    /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_result_fwft_fifo_32x80_wrapper_underflow_flag;   /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_result_fwft_fifo_16x80_wrapper_overflow_flag;    /**<  @brief fifoжϱ*/
    ZXIC_UINT32 ppu_cop_result_fwft_fifo_16x80_wrapper_underflow_flag;   /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec5_cop_key_crc_fifo_32x625_wrapper_overflow_flag;      /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec5_cop_key_crc_fifo_32x625_wrapper_underflow_flag;     /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec5_cop_key_checksum_fifo_32x180_wrapper_overflow_flag;   /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec5_cop_key_checksum_fifo_32x180_wrapper_underflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec5_cop_key_mul_fifo_32x52_wrapper_overflow_flag;         /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec5_cop_key_mul_fifo_32x52_wrapper_underflow_flag;        /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec5_cop_key_random_mod_fifo_32x44_wrapper_overflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec5_cop_key_random_mod_fifo_32x44_wrapper_underflow_flag; /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec4_cop_key_crc_fifo_32x625_wrapper_overflow_flag;        /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec4_cop_key_crc_fifo_32x625_wrapper_underflow_flag;       /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec4_cop_key_checksum_fifo_32x180_wrapper_overflow_flag;   /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec4_cop_key_checksum_fifo_32x180_wrapper_underflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec4_cop_key_mul_fifo_32x52_wrapper_overflow_flag;         /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec4_cop_key_mul_fifo_32x52_wrapper_underflow_flag;        /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec4_cop_key_random_mod_fifo_32x44_wrapper_overflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec4_cop_key_random_mod_fifo_32x44_wrapper_underflow_flag; /**<  @brief fifoжϱ*/

    ZXIC_UINT32 mec3_cop_key_crc_fifo_32x625_wrapper_overflow_flag;        /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec3_cop_key_crc_fifo_32x625_wrapper_underflow_flag;       /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec3_cop_key_checksum_fifo_32x180_wrapper_overflow_flag;   /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec3_cop_key_checksum_fifo_32x180_wrapper_underflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec3_cop_key_mul_fifo_32x52_wrapper_overflow_flag;         /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec3_cop_key_mul_fifo_32x52_wrapper_underflow_flag;        /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec3_cop_key_random_mod_fifo_32x44_wrapper_overflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec3_cop_key_random_mod_fifo_32x44_wrapper_underflow_flag; /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec2_cop_key_crc_fifo_32x625_wrapper_overflow_flag;        /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec2_cop_key_crc_fifo_32x625_wrapper_underflow_flag;       /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec2_cop_key_checksum_fifo_32x180_wrapper_overflow_flag;   /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec2_cop_key_checksum_fifo_32x180_wrapper_underflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec2_cop_key_mul_fifo_32x52_wrapper_overflow_flag;         /**<  @brief fifoжϱ*/  
    ZXIC_UINT32 mec2_cop_key_mul_fifo_32x52_wrapper_underflow_flag;        /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec2_cop_key_random_mod_fifo_32x44_wrapper_overflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec2_cop_key_random_mod_fifo_32x44_wrapper_underflow_flag; /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec1_cop_key_crc_fifo_32x625_wrapper_overflow_flag;        /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec1_cop_key_crc_fifo_32x625_wrapper_underflow_flag;       /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec1_cop_key_checksum_fifo_32x180_wrapper_overflow_flag;   /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec1_cop_key_checksum_fifo_32x180_wrapper_underflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec1_cop_key_mul_fifo_32x52_wrapper_overflow_flag;         /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec1_cop_key_mul_fifo_32x52_wrapper_underflow_flag;        /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec1_cop_key_random_mod_fifo_32x44_wrapper_overflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec1_cop_key_random_mod_fifo_32x44_wrapper_underflow_flag; /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec0_cop_key_crc_fifo_32x625_wrapper_overflow_flag;        /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec0_cop_key_crc_fifo_32x625_wrapper_underflow_flag;       /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec0_cop_key_checksum_fifo_32x180_wrapper_overflow_flag;   /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec0_cop_key_checksum_fifo_32x180_wrapper_underflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec0_cop_key_mul_fifo_32x52_wrapper_overflow_flag;         /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec0_cop_key_mul_fifo_32x52_wrapper_underflow_flag;        /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec0_cop_key_random_mod_fifo_32x44_wrapper_overflow_flag;  /**<  @brief fifoжϱ*/
    ZXIC_UINT32 mec0_cop_key_random_mod_fifo_32x44_wrapper_underflow_flag; /**<  @brief fifoжϱ*/
}DPP_PPU_PPU_COPROCESSOR_FIFO_INT_T;


typedef struct dpp_ppu_ppu_cos_meter_cfg_t
{
    ZXIC_UINT32 cbs;           /**<  @brief 0~7CBS*/
    ZXIC_UINT32 pbs;           /**<  @brief 0~7PBS*/
    ZXIC_UINT32 green_action;  /**<  @brief 0~7ɫĶãرCARʹܵʱҪͬʱöΪ1*/
    ZXIC_UINT32 yellow_action; /**<  @brief 0~7лɫĶ*/
    ZXIC_UINT32 red_action;    /**<  @brief 0~7кɫĶ*/
    ZXIC_UINT32 cir;           /**<  @brief 0~7CIRãλMpps0x24aӦ600MppsԱ仯*/  
    ZXIC_UINT32 pir;           /**<  @brief 0~7PIRãλMpps0x24aӦ600MppsԱ仯*/
    ZXIC_UINT32 car_en;        /**<  @brief 0~7CARʹ*/
}DPP_PPU_PPU_COS_METER_CFG_T;

#endif
/***********************************************************/
/** PPUģʼ
* @param   dev_id  豸
* @param   cluster_bit cluster bit mapʽ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2015/02/15
************************************************************/
DPP_STATUS dpp_ppu_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_bit);

/***********************************************************/
/** SDT
* @param   dev_id   豸ţΧ0~3
* @param   cluster_id  me clusterţΧ0~7
* @param   index       ַsdtţΧ0~255
* @param   p_sdt_data  sdt
*
* @return
* @remark  
* @see
* @author        @date  2014/03/18
************************************************************/
DPP_STATUS dpp_ppu_sdt_tbl_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 index, DPP_SDT_TBL_DATA_T *p_sdt_data);

/***********************************************************/
/** 鲥Ա
* @param   dev_id    豸
* @param   index        ĿַΧ0~63
* @param   item_vld     ĿЧλ
* @param   flownum_vld  Чλ
* @param   start_pc     ƳıĽPPU΢ʼַָ
* @param   flow_num     
*
* @return
* @remark  
* @see
* @author        @date  2015/02/13
************************************************************/
DPP_STATUS dpp_ppu_dup_tbl_write(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 index,
                                 ZXIC_UINT32 item_vld,
                                 ZXIC_UINT32 flownum_vld,
                                 ZXIC_UINT32 start_pc,
                                 ZXIC_UINT32 flow_num);

/***********************************************************/
/** 8clusterʱʹܣԹرclusterֻоƬ
    ڲ¿á
* @param   dev_id 豸
* @param   clock_en  clusterʹܱ־8clusterӦbit0Ӧcluster0
*
* @return
* @remark  
* @see
* @author        @date  2014/06/12
************************************************************/
DPP_STATUS dpp_ppu_cluster_clk_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 clock_en);

/***********************************************************/
/** ģ
* @param   dev_id     豸
* @param   flow_num_cfg  Ƿ 1  0  Ĭ0
* @param   flow_num      
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  lifq      @date  2016/03/15
************************************************************/
DPP_STATUS dpp_ppu_reorder_bypass_flow_num_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 flow_num_cfg, ZXIC_UINT32 flow_num);

#endif /* dpp_ppu_api.h */



