/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_reg.h
* ļʶ :
* ժҪ :
* ˵ :
* ǰ汾 :
*      : wcl
*  : 2014/02/12
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* ޸ļ¼1:
* ޸:
*   :
*   :
* ޸:
***************************************************************/

#ifndef _DPP_REG_API_H_
#define _DPP_REG_API_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "dpp_reg_struct.h"

/**  ϲģ鲻Ҫֱʹøȫֱ*/
extern  DPP_REG_T g_dpp_reg_info[];

/**  public*/
#define DPP_REG(no)              (g_dpp_reg_info[no])
#define DPP_REG_NAME(no)         ((DPP_REG(no)).reg_name)
#define DPP_REG_NO(no)           ((DPP_REG(no)).reg_no)
#define DPP_REG_MODULE_NO(no)    ((DPP_REG(no)).module_no)
#define DPP_REG_FLAGS(no)        ((DPP_REG(no)).flags)
#define DPP_REG_TYPE(no)         ((DPP_REG(no)).array_type)
#define DPP_REG_ADDR(no)         ((DPP_REG(no)).addr)
#define DPP_REG_WIDTH(no)        ((DPP_REG(no)).width)
#define DPP_REG_M_SIZE(no)       ((DPP_REG(no)).m_size)
#define DPP_REG_N_SIZE(no)       ((DPP_REG(no)).n_size)
#define DPP_REG_M_STEP(no)       ((DPP_REG(no)).m_step)
#define DPP_REG_N_STEP(no)       ((DPP_REG(no)).n_step)
#define DPP_REG_FIELD_NUM(no)    ((DPP_REG(no)).field_num)
#define DPP_REG_FIELD_NAME(no, field_no)    (((DPP_REG(no)).p_fields+field_no)->p_name)

typedef enum dpp_bar_4k_e
{
   BAR_4K_DTB = 0,  /**<  @brief 0*/
   BAR_4K_ETCAM,    /**<  @brief 1*/
   BAR_4K_CLS0,      /**<  @brief 2*/
   BAR_4K_CLS1,      /**<  @brief 3*/
   BAR_4K_CLS2,      /**<  @brief 4*/
   BAR_4K_CLS3,      /**<  @brief 5*/
   BAR_4K_CLS4,      /**<  @brief 6*/
   BAR_4K_CLS5,      /**<  @brief 7*/
   BAR_4K_SE,       /**<  @brief 8*/
   BAR_4K_SMMU1,    /**<  @brief 9*/
   BAR_4K_MAX           
} DPP_BAR_4K_E;
typedef struct
{ 
    ZXIC_UINT32 reg_module;      /*DPP_MODULE_E*/
    ZXIC_UINT32  index_4k;        /*BAR NPռӳ4K*/
    ZXIC_UINT32 addr_offset;     /*ĴƫƣڼBARӳռλ*/
}DPP_REG_OFFSET_ADDR;

/***********************************************************/
/** Ĵдץӡ
* @param   cap_en      ʹ
* @param   reg_start   ʼĴ
* @param   reg_end     Ĵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2017/11/20
************************************************************/
DPP_STATUS dpp_reg_cap_cfg_set(ZXIC_UINT32 cap_en, ZXIC_UINT32 reg_start, ZXIC_UINT32 reg_end);

/***********************************************************/
/** ȡĴ
* @param   reg_no  Ĵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2014/04/17
************************************************************/
DPP_REG_T* dpp_reg_info_get(ZXIC_UINT32 reg_no);

/***********************************************************/
/** ݼĴŻȡĴ
* @param   reg_no  Ĵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2015/06/23
************************************************************/
ZXIC_CHAR* dpp_reg_name_get(ZXIC_UINT32 reg_no);

/***********************************************************/
/** ݼĴŻȡĴģ
* @param   reg_no
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2015/07/23
************************************************************/
ZXIC_UINT32 dpp_reg_module_no_get(ZXIC_UINT32 reg_no);

/***********************************************************/
/** ȡĴȣֽΪλ
* @param   dev_id
* @param   reg_no
* @param   p_reg_width
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2014/03/20
************************************************************/
DPP_STATUS dpp_reg_width_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 *p_reg_width);

/***********************************************************/
/** ͨüĴд
* @param   dev_id  豸ţֶ֧оƬ
* @param   reg_no Ĵ
* @param   m_offset ԪĴmƫ
* @param   n_offset һԪĴԪĴnƫ
* @param   p_data ָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2014/02/12
************************************************************/
DPP_STATUS dpp_reg_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset, ZXIC_VOID *p_data);

/***********************************************************/
/** ͨüĴ
* @param   dev_id 豸ţֶ֧оƬ
* @param   reg_no Ĵ
* @param   m_offset ԪĴmƫ
* @param   n_offset һԪĴԪĴnƫ
* @param   p_data ָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2014/02/12
************************************************************/
DPP_STATUS dpp_reg_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset, ZXIC_VOID *p_data);

/***********************************************************/
/** ݼĴŻüĴоƬھԵַ
* @param   reg_no
* @param   m_offset
* @param   n_offset
*
* @return
* @remark  
* @see
* @author        @date  2014/03/19
************************************************************/
ZXIC_UINT32 dpp_reg_get_reg_addr(ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset);

/***********************************************************/
/** ȡĴĬֵ֧512bitλļĴ
* @param   reg_no     Ĵ
* @param   p_def_val  Ĭֵָ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2014/04/17
************************************************************/
DPP_STATUS dpp_reg_default_val_get(ZXIC_UINT32 reg_no, ZXIC_UINT32 *p_def_val);

/***********************************************************/
/** ݼĴֶεֵƴװֵֻ֧֮32bitĴ
* @param   reg_no  Ĵ
* @param   p_data  Ĵֵֶ
* @param   p_val   ƴ֮ļĴʵֵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2014/04/25
************************************************************/
DPP_STATUS dpp_reg_val_get(ZXIC_UINT32 reg_no, ZXIC_VOID* p_data, ZXIC_UINT32 *p_val);

/***********************************************************/
/** ȡĴдֵ֧512bitλļĴ
* @param   reg_no         Ĵ
* @param   p_fields_data  ֶεֵ
* @param   p_max_val      ƴװ֮ļĴֵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2014/06/11
************************************************************/
DPP_STATUS dpp_reg_max_val_get(ZXIC_UINT32 reg_no, ZXIC_UINT32 *p_fields_data, ZXIC_UINT32 *p_max_val);

/***********************************************************/
/**  ȡĴдֵ֧512bitλļĴ
* @param   reg_no        Ĵ
* @param   p_fields_data ֶεֵ
* @param   field_len     ֶθ
* @param   p_rand_val    ƴװ֮ļĴֵ
* @param   rand_len      p_rand_valֽڳ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  xujw      @date  2022/01/26
************************************************************/
DPP_STATUS dpp_reg_rand_val_get(ZXIC_UINT32 reg_no, ZXIC_UINT32 *p_fields_data, ZXIC_UINT32 field_len, ZXIC_UINT32 *p_rand_val, ZXIC_UINT32 rand_len);

/***********************************************************/
/** ͨĴüĴ32bitλ
    ĳĴ
* @param   dev_id  豸
* @param   reg_no     Ĵ
* @param   m_offset   ԪĴmƫ
* @param   n_offset   һԪĴԪĴnƫ
* @param   data       ݣ32bit
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2015/01/21
************************************************************/
DPP_STATUS dpp_reg_write32(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 data);

/***********************************************************/
/** ͨĴüĴ32bitλ
    ĳĴ
* @param   dev_id  豸
* @param   reg_no     Ĵ
* @param   m_offset   ԪĴmƫ
* @param   n_offset   һԪĴԪĴnƫ
* @param   data       ݣ32bit
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2015/01/21
************************************************************/
DPP_STATUS dpp_reg_write32_bymn(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset, ZXIC_UINT32 data);

/***********************************************************/
/** ͨĴŶȡĴֵ32bitλĳĴ
* @param   dev_id   豸
* @param   reg_no   Ĵ
* @param   m_offset   ԪĴmƫ
* @param   n_offset   һԪĴԪĴnƫ
* @param   p_data   ΣضȡĴֵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ʯ      @date  2015/03/09
************************************************************/
DPP_STATUS dpp_reg_read32(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset, ZXIC_UINT32 *p_data);

/***********************************************************/
/** ͨĴŶȡĴֵӡ32bitλ
    ĳĴ
* @param   dev_id  豸
* @param   reg_no     Ĵ
* @param   m_offset   ԪĴmƫ
* @param   n_offset   һԪĴԪĴnƫ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2015/01/21
************************************************************/
DPP_STATUS dpp_reg_print32(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset);

/***********************************************************/
/** ӡüĴֶ
* @param   dev_id  豸
* @param   reg_no     Ĵ
* @param   m_offset   ԪĴmƫ
* @param   n_offset   һԪĴԪĴnƫ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2016/08/18
************************************************************/
DPP_STATUS dpp_reg_fields_print(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset);

/***********************************************************/
/**޴ӡݼĴַݣڼclear
* @param   dev_id  豸
* @param   reg_no     Ĵ
* @param   m_offset   ԪĴmƫ
* @param   n_offset   һԪĴԪĴnƫ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2016/08/18
************************************************************/
DPP_STATUS dpp_reg_fields_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset);

/***********************************************************/
/** ӡüĴֶΣڶԪԪдӡ
* @param   dev_id  豸
* @param   reg_no     Ĵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2016/08/18
************************************************************/
DPP_STATUS dpp_reg_fields_print_all(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no);

/***********************************************************/
/** ĬֵȽϣĬֵһӡ
* @param   dev_id  豸
* @param   reg_no     Ĵ
* @param   m_offset   ԪĴmƫ
* @param   n_offset   һԪĴԪĴnƫ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2016/08/18
************************************************************/
DPP_STATUS dpp_reg_fields_print_with_def(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset);

/***********************************************************/
/**cntͼĴMNͳۼӶԪֶͬεļͲӡ,32bitĴ
* @param   dev_id
* @param   pon_id
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  baibing      @date  2020/03/19
************************************************************/
DPP_STATUS dpp_reg_fields_sum_calc_prt (ZXIC_UINT32 dev_id,ZXIC_UINT32 show_reg_name_en, ZXIC_UINT32 start_reg_no, ZXIC_UINT32 end_reg_no);

/***********************************************************/
/** оƬӲλ֮ϵͳǷЧ,ͨĴдȷ
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author        @date  2015/06/24
************************************************************/
DPP_STATUS dpp_module_hdw_reset_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** Ĵprint, M+N,мĴӡ
* @param   dev_id    豸
* @param   start_reg_no ʼĴ
* @param   end_reg_no   Ĵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2017/09/14
************************************************************/
DPP_STATUS dpp_regs_print(ZXIC_UINT32 dev_id, ZXIC_UINT32 start_reg_no, ZXIC_UINT32 end_reg_no);

/***********************************************************/
/** Ĵdump, M+N,мĴӡ
* @param   dev_id    豸
* @param   start_reg_no ʼĴ
* @param   end_reg_no   Ĵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ʯ      @date  2015/08/02
************************************************************/

/***********************************************************/
/** Ĵprint, ָԪĴ
* @param   dev_id    豸
* @param   start_reg_no ʼĴ
* @param   end_reg_no   Ĵ
* @param   m_offset   ԪĴmƫ
* @param   n_offset   һԪĴԪĴnƫ
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2017/09/14
************************************************************/
DPP_STATUS dpp_regs_print_bymn(ZXIC_UINT32 dev_id, ZXIC_UINT32 start_reg_no, ZXIC_UINT32 end_reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset);

DPP_STATUS dpp_regs_dump(ZXIC_UINT32 dev_id, ZXIC_UINT32 start_reg_no, ZXIC_UINT32 end_reg_no);

/***********************************************************/
/** mnĴdump
* @param   dev_id    豸
* @param   start_reg_no ʼĴ
* @param   end_reg_no   Ĵ
* @param   m            һԪ
* @param   n            Ԫ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2017/09/14
************************************************************/
DPP_STATUS dpp_regs_dump_bymn(ZXIC_UINT32 dev_id, ZXIC_UINT32 start_reg_no, ZXIC_UINT32 end_reg_no, ZXIC_UINT32 m, ZXIC_UINT32 n);

/***********************************************************/
/** reg help 
* @param   ZXIC_VOID
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2017/11/20
************************************************************/
DPP_STATUS dpp_reg_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ͨĴŴӡüĴ
* @param   reg_no     Ĵ
* @param   m_offset   ԪĴmƫ
* @param   n_offset   һԪĴԪĴnƫ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2017/06/20
************************************************************/
DPP_STATUS dpp_reg_info_prt(ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset);

/***********************************************************/
/** ͨĴŶȡָĴֵӡ32bitλ
    ĳĴ
* @param   dev_id  豸
* @param   reg_no     Ĵ
* @param   m_offset   ԪĴmƫ
* @param   n_offset   һԪĴԪĴnƫ
* @param   num        Ĵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2016/06/15
************************************************************/
DPP_STATUS dpp_reg_print_more(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset, ZXIC_UINT32 num);

/***********************************************************/
/** mnĴdump
* @param   dev_id    豸
* @param   start_reg_no ʼĴ
* @param   end_reg_no   Ĵ
* @param   m            һԪ
* @param   n            Ԫ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xjw      @date  2017/09/14
************************************************************/
DPP_STATUS dpp_regs_fields_dump_bymn(ZXIC_UINT32 dev_id, ZXIC_UINT32 start_reg_no, ZXIC_UINT32 end_reg_no, ZXIC_UINT32 m, ZXIC_UINT32 n);

DPP_STATUS dpp_reg_fields_vld_print(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 reg_no,
                                    ZXIC_UINT32 m_offset,
                                    ZXIC_UINT32 n_offset);

ZXIC_VOID DPP_DBGSTATUS_BIT_PRINT(const ZXIC_CHAR *name, ZXIC_UINT32 value, ZXIC_UINT32 prt_len);

DPP_STATUS dpp_node_data_free(void *p_data);

ZXIC_UINT32 dpp_reg_addr_convert(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_module,ZXIC_UINT32 flags,ZXIC_UINT32 addr);

BOOLEAN dpp_4k_reg(ZXIC_UINT32 reg_module);

ZXIC_VOID dpp_reg_filter_en_set(ZXIC_UINT32 filter_en);

ZXIC_UINT32 dpp_reg_filter_en_get(ZXIC_VOID);

DPP_STATUS dpp_reg_filter_flag_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 *filter_flag);

#ifdef __cplusplus
}
#endif

#endif


