/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_tm_api.h
* ļʶ : tmģͶͽӿں
* ժҪ :
* ˵ :
* ǰ汾 :
*      : djf
*  : 2015/02/04
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* ޸ļ¼1:
* ޸:
*   :
*   :
* ޸:
***************************************************************/
#ifndef  _DPP_TM_API_H_
#define  _DPP_TM_API_H_


#if ZXIC_REAL("header file")
#include "dpp_module.h"
#endif

#if ZXIC_REAL("macro")
#define DPP_TM_SA_NUM   (128)
#define DPP_TM_PP_NUM   (64)/**< @brief TMڲ߼˿ */
#define DPP_ETM_Q_NUM   (9216)/**< @ETM qmu֧9K */
#define DPP_FTM_Q_NUM   (2048)/**< @FTM qmu֧2k */
#define DPP_ETM_CRDT_NUM     (0x47FF)  /*etm ֵ֧crdt߼cir+eir=18K */
#define DPP_FTM_CRDT_NUM     (0xFFF)   /*ftm ֵ֧crdt߼cir+eir=4K */
#define DPP_ETM_MID_SE_NUM   (6144)/**< @ETMм伶0x17FFȵԪ */
#define DPP_FTM_MID_SE_NUM   (512)/**< @FTM м伶0x1FFȵԪ */
#define DPP_ETM_MID_WFQFQ_NUM   (8 * 6144)/**< @brief м伶8 * 6144 */
#define DPP_FTM_MID_WFQFQ_NUM   (8 * 512)/**< @brief м伶8 * 512 */


#define DPP_ETM_WFQSP_OFFSET    (0x4000)  /*etm sp-wfqfqƫ*/
#define DPP_ETM_FQ_NUM          (16*1024) /*etm fq*/
#define DPP_ETM_WFQSP_NUM       (9*1024)  /*etm sp8wfq*/
#define DPP_ETM_FQSPWFQ_NUM     (25*1024) /*etm fq-sp-wfqܸ*/
#define DPP_FTM_WFQSP_NUM       (1920+64)    /*ftm sp8wfq+64˿*/
#define DPP_ETM_SCH_DEL_NUM     (0xABFF)  /*etm-crdtҪɾ͵*/
#define DPP_FTM_SCH_DEL_NUM     (0x177F)  /*ftm-crdtҪɾ͵*/

#define DPP_TM_INVALID_PORT     (0xFFFF)  /* crdtЧ˿ں,жcrdtҽ״̬ */
#define DPP_FTM_DELETED_LINK_ID (0x7FF)   /**ftmѱɾlink_id**/
#define DPP_ETM_DELETED_LINK_ID (0x7FFF)  /**etmѱɾlink_id**/



/* ftm/etm˿ڼҽlink_idƫ */
#define DPP_FTM_PORT_LINKID_BASE   (0x780)
#define DPP_ETM_PORT_LINKID_BASE   (0x7F80)
/**SHAPģse_idŻַ(Ǵ0ʼ)**/
#define DPP_FTM_SHAP_SEID_BASE   (0x1000)
#define DPP_ETM_SHAP_SEID_BASE   (0x4800)



/**< @brief TD */
#define DPP_TM_Q_TD_TH_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_PP_TD_TH_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_SYS_TD_TH_MAX   (8192)/**< @brief Kbyte */

#define DPP_TM_Q_AVG_Q_LEN_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_PP_AVG_Q_LEN_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_SYS_AVG_Q_LEN_MAX   (8192)/**< @brief Kbyte */

/**< @brief WRED */
#define DPP_TM_Q_WRED_NUM   (32)/**< @brief мWRED */
#define DPP_TM_Q_WRED_TH_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_Q_WRED_MAX_TH_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_Q_WRED_MIN_TH_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_Q_WRED_MAX_CFG_PARA   (0xffffffff)

#define DPP_TM_PP_WRED_NUM   (8)/**< @brief ˿ڼWRED */
#define DPP_TM_PP_WRED_TH_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_PP_WRED_MAX_TH_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_PP_WRED_MIN_TH_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_PP_WRED_MAX_CFG_PARA   (0xffffffff)

/**< @brief GRED */
#define DPP_TM_SYS_GRED_TH_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_SYS_GRED_MAX_TH_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_SYS_GRED_MIN_TH_MAX   (8192)/**< @brief Kbyte */
#define DPP_TM_SYS_GRED_MID_TH_MAX   (8192)/**< @brief Kbyte */

#define DPP_TM_DP_NUM   (8)/**< @brief DP */
#define DPP_TM_RED_P_MIN   (1)
#define DPP_TM_RED_P_MAX   (100)
#define DPP_TM_CGAVD_WEIGHT_MAX   (15)
#define DPP_TM_CGAVD_MOVE_PROFILE_NUM   (16)


#define DPP_TM_SCH_WEIGHT_INVALID   (0) /**< @brief WFQȨأFQʱweightЧ */
#define DPP_TM_SCH_WEIGHT_MIN   (1)
#define DPP_TM_SCH_WEIGHT_MAX   (511)
#define DPP_TM_SCH_SP_NUM   (8)

#define DPP_ETM_MID_SHAPE_PROFILE_NUM   (512)/**< ETMм伶β */
#define DPP_FTM_MID_SHAPE_PROFILE_NUM   (64)/**< FTMм伶β */
#define DPP_ETM_FLOW_SHAPE_PROFILE_NUM   (512)/**< ETM β */
#define DPP_FTM_FLOW_SHAPE_PROFILE_NUM   (128)/**< FTM β */

#define DPP_TM_SHAPE_CIR_MIN   (0)                  /**< @brief kbps */
#define DPP_TM_SHAPE_CIR_MAX   (800 * 1000 * 1000)   /**< @brief kbps:û */
#define DPP_TM_SHAPE_CBS_MIN   (0)                   /**< @brief kbyte */
#define DPP_TM_SHAPE_CBS_MAX   (128 * 1024)             /**< @brief kbyte:ûͰ 128M */


/**< CBSдĴֵΪ0x7FF */
#define DPP_TM_SHAPE_CBS_REG_MIN   (0)                   /**< @brief kbyte */
#define DPP_TM_SHAPE_CBS_REG_MAX   (0x7FF)                /**< @brief kbyte */

#define DPP_TM_SYS_HZ   (1000*1000*1000)  /* ϵͳƵ1000MHz */

#define DPP_TM_TC_NUM (8)

#endif


#if ZXIC_REAL("data struct define")
/**< @brief TMģʽ */
typedef enum dpp_tm_work_mode_e
{
    DPP_TM_WORK_MODE_TM = 0,
    DPP_TM_WORK_MODE_SA,
    DPP_TM_WORK_MODE_INVALID
} DPP_TM_WORK_MODE_E;

/**< @brief QMUģʽ */
typedef enum dpp_tm_qmu_work_mode_e
{
    DPP_TM_QMU_WORK_MODE_2M = 0, /**< @brief 2Mڵ㹤ģʽ */
    DPP_TM_QMU_WORK_MODE_4M, /**< @brief 4Mڵ㹤ģʽ */
    DPP_TM_QMU_WORK_MODE_INVALID
} DPP_TM_QMU_WORK_MODE_E;

/**< @brief QMU DDRģʽ */
typedef enum dpp_tm_qmu_ddr_random_mode_e
{
    DPP_TM_QMU_DDR_NOT_RANDOM = 0, /**< @brief DDRģʽ */
    DPP_TM_QMU_DDR_RANDOM, /**< @brief DDRģʽ */
    DPP_TM_QMU_DDR_RANDOM_MODE_INVALID
} DPP_TM_QMU_DDR_RANDOM_MODE_E;

/**< @brief ģʽĴ */
typedef struct dpp_tm_cnt_mode_t
{

    ZXIC_UINT32 fc_count_mode; /**< @brief ģʽ */
    ZXIC_UINT32 count_rd_mode; /**< @brief ģʽ */
    ZXIC_UINT32 count_overflow_mode; /**< @brief ģʽ  */
} DPP_TM_CNT_MODE_T;

/**< @brief жϢ */
typedef struct dpp_tm_int_t
{

    ZXIC_UINT32 shap_int;
    ZXIC_UINT32 crdt_int;
    ZXIC_UINT32 mmu_int;
    ZXIC_UINT32 qmu_int;
    ZXIC_UINT32 cgavd_int;
    ZXIC_UINT32 olif_int;
    ZXIC_UINT32 cfgmt_int;
} DPP_TM_INT_T;


/**< @brief ӵ */
typedef enum dpp_tm_cgavd_level_e
{
    QUEUE_LEVEL = 0, /**< @brief м */
    PP_LEVEL,        /**< @brief ˿ڼ */
    SYS_LEVEL,       /**< @brief ϵͳ */
    SA_LEVEL,        /**< @brief SAвɴӵ */
    INVALID_LEVEL
} DPP_TM_CGAVD_LEVEL_E;

/**< @brief dpѡȡֵ */
typedef enum dpp_tm_cgavd_dp_sel_e
{
    DP_SEL_DP = 0, /**< @brief ѡtmͷdpֶΪcgavddp */
    DP_SEL_TC,        /**< @brief ѡtmͷtcֶΪcgavddp */
    DP_SEL_PKT_LEN,       /**< @brief ѡtmͷpkt[2:0]ֶΪcgavddp */
    INVALID_DP
} DPP_TM_CGAVD_DP_SEL_E;

/**< @brief ӵģʽ */
typedef enum dpp_tm_cgavd_method_e
{
    TD_METHOD = 0, /**< @brief TDģʽ */
    WRED_GRED_METHOD, /**< @brief Ͷ˿ڼΪWREDģʽϵͳΪGREDģʽ */
    INVALID_METHOD
} DPP_TM_CGAVD_METHOD_E;

/**< @brief WRED DPò */
typedef struct dpp_tm_wred_dp_line_para_t
{
    ZXIC_UINT32 max_th; /**< @brief ƽֵ */
    ZXIC_UINT32 min_th; /**< @brief ƽֵ */
    ZXIC_UINT32 max_p; /**< @brief  */
    ZXIC_UINT32 weight; /**< @brief ƽȼȨ */
    ZXIC_UINT32 q_len_th; /**< @brief ֵ */
} DPP_TM_WRED_DP_LINE_PARA_T;

/**< @brief GRED DPò */
typedef struct dpp_tm_gred_dp_line_para_t
{
    ZXIC_UINT32 max_th; /**< @brief 2ƽֵ */
    ZXIC_UINT32 mid_th; /**< @brief 1ƽֵ */
    ZXIC_UINT32 min_th; /**< @brief 1ƽֵ */
    ZXIC_UINT32 max_p; /**< @brief  */
    ZXIC_UINT32 weight; /**< @brief ƽȼȨ */
    ZXIC_UINT32 q_len_th; /**< @brief ֵ */
} DPP_TM_GRED_DP_LINE_PARA_T;

/**< @brief CRDTȲ */
typedef enum dpp_tm_sch_level_e
{
    DPP_TM_SCH_LEVEL_Q = 1,
    DPP_TM_SCH_LEVEL_VC = 2,
    DPP_TM_SCH_LEVEL_VCG = 3,
    DPP_TM_SCH_LEVEL_VP = 4,
    DPP_TM_SCH_LEVEL_PP = 5,
    DPP_TM_SCH_LEVEL_INVALID
} DPP_TM_SCH_LEVEL_E;

/**< @brief SP_ID */
typedef enum dpp_tm_sch_sp_e
{
    DPP_TM_SCH_SP_0 = 0,
    DPP_TM_SCH_SP_1 = 1,
    DPP_TM_SCH_SP_2 = 2,
    DPP_TM_SCH_SP_3 = 3,
    DPP_TM_SCH_SP_4 = 4,
    DPP_TM_SCH_SP_5 = 5,
    DPP_TM_SCH_SP_6 = 6,
    DPP_TM_SCH_SP_7 = 7,
    DPP_TM_SCH_SP_8 = 8,
    DPP_TM_SCH_SP_INVALID
} DPP_TM_SCH_SP_E;

/**< @brief ȵԪҽӲ */
typedef struct dpp_tm_sch_para_t
{
    ZXIC_UINT32 level_id;                    /**< @brief ǰΪм伶ʱvc:0 vcg:1 vp:2 para_getѼ2*/
    DPP_TM_SCH_LEVEL_E se_last_level;   /**< @brief ҽӵϼ */
    ZXIC_UINT32 se_id;                       /**< @brief ҽӵϼȵԪID */
    DPP_TM_SCH_SP_E c_sp_id;            /**< @brief CͰҽӵSPID,SP0~SP7 */
    DPP_TM_SCH_SP_E e_sp_id;            /**< @brief EͰҽӵSPID,SP0~SP7 */
    ZXIC_UINT32 sp_relay;                    /**< @brief ȼݱ־,FLOWʱʾFLOW_WORK_MODE */
    ZXIC_UINT32 c_sp_weight;                 /**< @brief CͰҽӵĵWFQĻWFQȨ */
    ZXIC_UINT32 e_sp_weight;                 /**< @brief EͰҽӵĵWFQĻWFQȨ */
} DPP_TM_SCH_PARA_T;

/**< @brief  */
typedef struct dpp_tm_wfqfq_t
{
    ZXIC_UINT32 wfqfq_id[8];     /**< @brief ȵԪ¹ҽӵ8IDFQ/WFQID */
} DPP_TM_WFQFQ_T;

/**< @brief йҽӲ */
typedef struct dpp_tm_sch_flow_para_t
{
    ZXIC_UINT32 c_linkid;            /**< @brief cͰҪҽӵϼid */
    ZXIC_UINT32 c_weight;            /**< @brief cͰҽӵϼȨ[1~511] */
    ZXIC_UINT32 c_sp;                /**< @brief cͰҽӵϼspȼ,Чֵ[0-8],9ȼν */
    ZXIC_UINT32 mode;                /**< @brief ҽģʽ0-Ͱ 1-˫ͰõͰʱע0 */
    ZXIC_UINT32 e_linkid;            /**< @brief eͰҪҽӵϼid */
    ZXIC_UINT32 e_weight;            /**< @brief eͰҽӵϼȨ[1~511] */
    ZXIC_UINT32 e_sp;                /**< @brief eͰҽӵϼspȼЧֵ[0-8],9ȼν */
} DPP_TM_SCH_FLOW_PARA_T;

/**< @brief ȵԪҽӲ:ȼ */
typedef struct dpp_tm_sch_se_para_t
{
    ZXIC_UINT32  se_linkid;             /**< @brief Ҫҽӵϼid */
    ZXIC_UINT32  cp_token_en;           /**< @brief cp˫Ͱʹܿأfq8/wfq8֧ */
    ZXIC_UINT32  se_weight;             /**< @brief ҽӵϼȨ[1~511] */
    ZXIC_UINT32  se_sp;                  /**< @brief ҽӵϼspȼ,Чֵ[0-8],9ȼν */
} DPP_TM_SCH_SE_PARA_T;

/**< @brief ȵԪҽӲ:ȼݿ */
typedef struct dpp_tm_sch_se_para_insw_t
{
    ZXIC_UINT32  se_linkid;             /**< @brief  Ҫҽӵϼid */
    ZXIC_UINT32  cp_token_en;           /**< @brief cp˫Ͱʹܿأfq8/wfq8֧ */
    ZXIC_UINT32  se_sp;                  /**< @brief ҽӵϼspȼ,Чֵ[0-8],9ȼν */
    ZXIC_UINT32  se_weight[8];             /**< @brief WFQ8иȨֵ[1~511]WFQ2/4 ֻȡǰӦֵЧ */
} DPP_TM_SCH_SE_PARA_INSW_T;

typedef enum dpp_tm_sch_port_linkid_t
{
    DPP_TM_PP_LINKID_PORT0 = 0x7F80,
    DPP_TM_PP_LINKID_PORT1 = 0x7F81,
    DPP_TM_PP_LINKID_PORT2 = 0x7F82,
    DPP_TM_PP_LINKID_PORT3 = 0x7F83,
    DPP_TM_PP_LINKID_PORT4 = 0x7F84,
    DPP_TM_PP_LINKID_PORT5 = 0x7F85,
    DPP_TM_PP_LINKID_PORT6 = 0x7F86,
    DPP_TM_PP_LINKID_PORT7 = 0x7F87,
    DPP_TM_PP_LINKID_PORT8 = 0x7F88,
    DPP_TM_PP_LINKID_PORT9 = 0x7F89,
    DPP_TM_PP_LINKID_PORT10 = 0x7F8A,
    DPP_TM_PP_LINKID_PORT11 = 0x7F8B,
    DPP_TM_PP_LINKID_PORT12 = 0x7F8C,
    DPP_TM_PP_LINKID_PORT13 = 0x7F8D,
    DPP_TM_PP_LINKID_PORT14 = 0x7F8E,
    DPP_TM_PP_LINKID_PORT15 = 0x7F8F,
    DPP_TM_PP_LINKID_PORT16 = 0x7F90,
    DPP_TM_PP_LINKID_PORT17 = 0x7F91,
    DPP_TM_PP_LINKID_PORT18 = 0x7F92,
    DPP_TM_PP_LINKID_PORT19 = 0x7F93,
    DPP_TM_PP_LINKID_PORT20 = 0x7F94,
    DPP_TM_PP_LINKID_PORT21 = 0x7F95,
    DPP_TM_PP_LINKID_PORT22 = 0x7F96,
    DPP_TM_PP_LINKID_PORT23 = 0x7F97,
    DPP_TM_PP_LINKID_PORT24 = 0x7F98,
    DPP_TM_PP_LINKID_PORT25 = 0x7F99,
    DPP_TM_PP_LINKID_PORT26 = 0x7F9A,
    DPP_TM_PP_LINKID_PORT27 = 0x7F9B,
    DPP_TM_PP_LINKID_PORT28 = 0x7F9C,
    DPP_TM_PP_LINKID_PORT29 = 0x7F9D,
    DPP_TM_PP_LINKID_PORT30 = 0x7F9E,
    DPP_TM_PP_LINKID_PORT31 = 0x7F9F,
    DPP_TM_PP_LINKID_PORT32 = 0x7FA0,
    DPP_TM_PP_LINKID_PORT33 = 0x7FA1,
    DPP_TM_PP_LINKID_PORT34 = 0x7FA2,
    DPP_TM_PP_LINKID_PORT35 = 0x7FA3,
    DPP_TM_PP_LINKID_PORT36 = 0x7FA4,
    DPP_TM_PP_LINKID_PORT37 = 0x7FA5,
    DPP_TM_PP_LINKID_PORT38 = 0x7FA6,
    DPP_TM_PP_LINKID_PORT39 = 0x7FA7,
    DPP_TM_PP_LINKID_PORT40 = 0x7FA8,
    DPP_TM_PP_LINKID_PORT41 = 0x7FA9,
    DPP_TM_PP_LINKID_PORT42 = 0x7FAA,
    DPP_TM_PP_LINKID_PORT43 = 0x7FAB,
    DPP_TM_PP_LINKID_PORT44 = 0x7FAC,
    DPP_TM_PP_LINKID_PORT45 = 0x7FAD,
    DPP_TM_PP_LINKID_PORT46 = 0x7FAE,
    DPP_TM_PP_LINKID_PORT47 = 0x7FAF,
    DPP_TM_PP_LINKID_PORT48 = 0x7FB0,
    DPP_TM_PP_LINKID_PORT49 = 0x7FB1,
    DPP_TM_PP_LINKID_PORT50 = 0x7FB2,
    DPP_TM_PP_LINKID_PORT51 = 0x7FB3,
    DPP_TM_PP_LINKID_PORT52 = 0x7FB4,
    DPP_TM_PP_LINKID_PORT53 = 0x7FB5,
    DPP_TM_PP_LINKID_PORT54 = 0x7FB6,
    DPP_TM_PP_LINKID_PORT55 = 0x7FB7,
    DPP_TM_PP_LINKID_PORT56 = 0x7FB8,
    DPP_TM_PP_LINKID_PORT57 = 0x7FB9,
    DPP_TM_PP_LINKID_PORT58 = 0x7FBA,
    DPP_TM_PP_LINKID_PORT59 = 0x7FBB,
    DPP_TM_PP_LINKID_PORT60 = 0x7FBC,
    DPP_TM_PP_LINKID_PORT61 = 0x7FBD,
    DPP_TM_PP_LINKID_PORT62 = 0x7FBE,
    DPP_TM_PP_LINKID_PORT63 = 0x7FBF,
    DPP_TM_PP_LINKID_INVALID
} DPP_TM_SCH_PORT_LINKID_T;
typedef enum dpp_tm_shape_flag_e
{
    DPP_TM_SHAPE_FLAG_CIR = 0,
    DPP_TM_SHAPE_FLAG_EIR = 1,
    DPP_TM_SHAPE_FLAG_INVALID
} DPP_TM_SHAPE_FLAG_E;

/**< @brief Ͱģʽ */
typedef enum dpp_tm_shape_mode_e
{
    DPP_TM_SINGLE_MIX_BUCKET = 0,       /**< @brief Ͱ/ */
    DPP_TM_DUAL_BUCKET = 1,       /**< @brief ˫Ͱ */
    DPP_TM_DUAL_PIPE = 2,      /**< @brief ˫Ͱ */
    DPP_TM_SHAPE_MODE_INVALID
} DPP_TM_SHAPE_MODE_E;

/**< @brief profile */
typedef struct dpp_tm_shape_profile_t
{
    ZXIC_UINT32 cir;
    ZXIC_UINT32 cbs;
    ZXIC_UINT32 eir;
    ZXIC_UINT32 ebs;
} DPP_TM_SHAPE_PROFILE_T;

/**< @brief ˿ڼβ */
typedef struct dpp_tm_shape_pp_para_t
{
    ZXIC_UINT32 cir;
    ZXIC_UINT32 cbs;
    ZXIC_UINT32 c_en;
} DPP_TM_SHAPE_PP_PARA_T;

/**< @brief ȵԪβ */
typedef struct dpp_tm_shape_para_t
{
    ZXIC_UINT32 class_id;      /**< @brief ǰм伶Σvc:1 vcg:2 vp:3 */
    ZXIC_UINT32 profile_id;
    ZXIC_UINT32 c_en;
    ZXIC_UINT32 e_en;
    DPP_TM_SHAPE_MODE_E mode;
} DPP_TM_SHAPE_PARA_T;

/**< @brief β */
typedef struct dpp_tm_shape_t
{
    ZXIC_UINT32 mid_level;      /**< @brief ǰм伶Σvc:1 vcg:2 vp:3 */
    ZXIC_UINT32 cir;
    ZXIC_UINT32 cbs;
    ZXIC_UINT32 eir;
    ZXIC_UINT32 ebs;
    ZXIC_UINT32 c_en;
    ZXIC_UINT32 e_en;
    ZXIC_UINT32 mode;
} DPP_TM_SHAPE_T;

typedef struct dpp_tm_shape_para
{
    ZXIC_UINT32 shape_cir;
    ZXIC_UINT32 shape_cbs;
    ZXIC_UINT32 shape_num;
} DPP_TM_SHAPE_PARA_TABLE;


/**< @brief TMʼ */
typedef struct dpp_tm_init_para_t
{
    DPP_TM_WORK_MODE_E tm_sa_mode;     /**< @brief TMSAģʽ */
    DPP_TM_QMU_WORK_MODE_E qmu_mode;   /**< @brief QMU 2M4Mڵģʽ */
    ZXIC_UINT32 case_num;                   /**< @brief QMUʼΪ1-4;ddr*bank:1:4x2;2:4x4;3:8x2;4:4x8.*/
    DPP_TM_QMU_DDR_RANDOM_MODE_E ddr_random_mode;   /**< @brief ddrģʽ */
    ZXIC_UINT32 block_size;                              /**< @brief blockģʽ128/256/512/1024 */
    ZXIC_UINT32 local_sa_id;                             /**< @brief SAģʽʱsa_id*/
} DPP_TM_INIT_PARA_T;


/* TM ASICʼϢ */
typedef struct dpp_tm_asic_init_info_t
{
    ZXIC_UINT32 blk_size;       /**< @brief qmuõblockС 256B/512B[default]/1024B */
    ZXIC_UINT32 case_num;       /**< @brief QMUʼΪ1-4;ddr*bank:1:4x2;2:4x4;3:8x2;4:4x8. */
    ZXIC_UINT32 imem_omem;      /**< @brief 0:Ƭ; 1:Ƭ;2:Ƭ */
    ZXIC_UINT32 mode;           /**< @brief TMģʽ 0:TMģʽ; 1:SAģʽ */
} DPP_TM_ASIC_INIT_INFO_T;

#endif

#if ZXIC_REAL("function declaration")



/***********************************************************/
/** ȡblockģʽ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   p_size   blockģʽ256/512/1024
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2014/04/09
************************************************************/
DPP_STATUS dpp_tm_cfgmt_blk_size_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_size);


/***********************************************************/
/** TMĹģʽ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   mode   õֵ0-TMģʽ1-SAģʽ
*ETMTMģʽFTMԹTMSAģʽ
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2014/02/25
************************************************************/
DPP_STATUS dpp_tm_cfgmt_sa_work_mode_set(ZXIC_UINT32 dev_id, DPP_TM_WORK_MODE_E mode);


/***********************************************************/
/**  øƹʹ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   level   Ҫõӵκţ0:м1:˿ڼ2:ϵͳ
* @param   en   ʹܱǣ0-ʹܣ1-ʹ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
#ifdef ETM_REAL
DPP_STATUS dpp_tm_cgavd_move_en_set(ZXIC_UINT32 dev_id,
                                    DPP_TM_CGAVD_LEVEL_E level,
                                    ZXIC_UINT32 en);

/***********************************************************/
/** ø
* @param   dev_id 豸
* @param   tm_type   0-ETM,1-FTM
* @param   level   ӵֲ֧κţ0:м1:˿ڼ2:ϵͳ
* @param   id   кŻ˿ںţϵͳʱidЧ
* @param   value   ˿ڼϵͳʱΪֵλΪNPPUĵλ256B
                   ʱΪprofile_id,0~15
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_tm_cgavd_move_th_set(ZXIC_UINT32 dev_id,
                                    DPP_TM_CGAVD_LEVEL_E level,
                                    ZXIC_UINT32 id,
                                    ZXIC_UINT32 value);

/***********************************************************/
/**  flowİƲ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   move_profile  flowİ޷,0~15
* @param   th  flowİޣλΪKB
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_tm_cgavd_flow_move_profile_set(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 move_profile,
                                              ZXIC_UINT32 th);
#endif

/***********************************************************/
/**  ö˿ڹİ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   th  ˿ڹİޣλΪNPPUĵλ256B
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_tm_cgavd_port_share_th_set(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 th);

/***********************************************************/
/**  øӵ⹦ʹ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   level   Ҫõӵκţ0:м1:˿ڼ2:ϵͳ
* @param   en   ʹܱǣ0-ʹܣ1-ʹ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2014/02/28
************************************************************/
DPP_STATUS dpp_tm_cgavd_en_set(ZXIC_UINT32 dev_id,
                               DPP_TM_CGAVD_LEVEL_E level,
                               ZXIC_UINT32 en);

/***********************************************************/
/** ӵ㷨
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   level   ӵֲ֧κţ0:м1:˿ڼ2:ϵͳ
* @param   id   кŻ˿ںţϵͳʱidЧ
* @param   method  õӵ㷨0:TD1:WRED/GRED
*          TD㷨ʱTDֵTD㷨
*          WRED㷨ʱ,˿ڼƽȣWRED㷨
*          GRED㷨ʱϵͳƽȣóGRED㷨
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark
* @see
* @author  taq      @date  2015/04/14
************************************************************/
DPP_STATUS dpp_tm_cgavd_method_set(ZXIC_UINT32 dev_id,
                                   DPP_TM_CGAVD_LEVEL_E level,
                                   ZXIC_UINT32 id,
                                   DPP_TM_CGAVD_METHOD_E method);

/***********************************************************/
/** øӵ㷨
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   level   ӵֲ֧κţ0:м1:˿ڼ2:ϵͳ
* @param   id_s   кŻ˿ںʼֵϵͳʱidЧ
* @param   id_e   кŻ˿ںֵֹϵͳʱidЧ
* @param   method  õӵ㷨0:TD1:WRED/GRED
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  sun      @date  2024/03/13
************************************************************/
DPP_STATUS dpp_tm_cgavd_method_set_more(ZXIC_UINT32 dev_id,
                                        DPP_TM_CGAVD_LEVEL_E level,
                                        ZXIC_UINT32 id_s,
                                        ZXIC_UINT32 id_e,
                                        DPP_TM_CGAVD_METHOD_E method);

/***********************************************************/
/** TDӵģʽµĶֵ
* @param   dev_id 豸
* @param   tm_type   0-ETM,1-FTM
* @param   level   ӵֲ֧κţ0:м1:˿ڼ2:ϵͳ
* @param   id   кŻ˿ںţϵͳʱidЧ
* @param   td_th   õĶֵûֵλΪKbyteҪתΪBlockλдĴ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2014/02/17
************************************************************/
DPP_STATUS dpp_tm_cgavd_td_th_set(ZXIC_UINT32 dev_id,
                                  DPP_TM_CGAVD_LEVEL_E level,
                                  ZXIC_UINT32 id,
                                  ZXIC_UINT32 td_th);

/***********************************************************/
/** TMģʽйҽӵĶ˿ں
* @param   dev_id 豸
* @param   q_id_s   к
* @param   q_id_e
* @param   pp_id   õĶ˿ں
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  sun     @date  2024/03/18
************************************************************/
DPP_STATUS dpp_tm_cgavd_q_map_pp_set_more(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 q_id_s,
                                          ZXIC_UINT32 q_id_e,
                                          ZXIC_UINT32 pp_id);

/***********************************************************/
/** ָ˿ڻа󶨵WRED GROUP ID
* @param   dev_id 豸
* @param   tm_type   0-ETM,1-FTM
* @param   level   WREDֲ֧κţ0:м1:˿ڼ
* @param   id   кŻ˿ں
* @param   wred_id   õWRED GROUP ID
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2014/02/17
************************************************************/
DPP_STATUS dpp_tm_cgavd_wred_id_set(ZXIC_UINT32 dev_id,
                                    DPP_TM_CGAVD_LEVEL_E level,
                                    ZXIC_UINT32 id,
                                    ZXIC_UINT32 wred_id);

/***********************************************************/
/** TMģʽйҽӵĶ˿ںţSAģʽӳĿоƬID
* @param   dev_id 豸
* @param   tm_type   0-ETM,1-FTM
* @param   q_id   к
* @param   pp_id   õĶ˿ں
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2014/02/18
************************************************************/
DPP_STATUS dpp_tm_cgavd_q_map_pp_set(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 q_id,
                                     ZXIC_UINT32 pp_id);

/***********************************************************/
/** TMģʽtcflowӳ
* @param   dev_id 豸
* @param   tc_id   itmd tcȼ0~7
* @param   flow_id ӳflowid 0~4095
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  sun      @date  2023/07/04
************************************************************/
DPP_STATUS dpp_tm_tc_map_flow_set(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 tc_id,
                                  ZXIC_UINT32 flow_id);                                     

/***********************************************************/
/** ָ˿ڻǷֶ֧̬޻
* @param   dev_id 豸
* @param   tm_type   0-ETM,1-FTM
* @param   level   WREDֲ֧κţ0:м1:˿ڼ
* @param   id   кŻ˿ں
* @param   en   õֵ0-ֶ֧̬޻ƣ1-ֶ֧̬޻
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2014/02/17
************************************************************/
DPP_STATUS dpp_tm_cgavd_dyn_th_en_set(ZXIC_UINT32 dev_id,
                                      DPP_TM_CGAVD_LEVEL_E level,
                                      ZXIC_UINT32 id,
                                      ZXIC_UINT32 en);

/***********************************************************/
/**  ǿƬڻƬ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   en      1:ʹ
* @param   mode   1 :omem ǿƬ  0:imem ǿƬ
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wush      @date  2017/10/14
************************************************************/
DPP_STATUS dpp_tm_cgavd_imem_omem_set(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 en,
                                      ZXIC_UINT32 mode);


/***********************************************************/
/** ȡQMUȨֵ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   p_credit_value   ȨֵĬֵ400Byte
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cuiy     @date  2016/04/14
************************************************************/
DPP_STATUS dpp_tm_qmu_credit_value_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_credit_value);

/******************************************************************************
*ϻ
* @param: dev_id: 豸
* @param   tm_type   0-ETM,1-FTM
*           aging_en: ϻʹܣ1ʾϻʹܣ0ʾϻܹرա
*           aging_interval: ͨϻεļ
*           aging_step_interval: ͨϻϻʱĲֵ
*           aging_start_qnum: ϻʼ
*           aging_end_qnum: ϻ
*           aging_req_aful_th: ͨϻFIFOĽֵ
*           aging_pkt_num: һϻİ
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cuiy      @date  2016/05/10
************************************************************/
DPP_STATUS dpp_tm_qmu_pkt_aging_set(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 aging_en,
                                    ZXIC_UINT32 aging_interval,
                                    ZXIC_UINT32 aging_step_interval,
                                    ZXIC_UINT32 aging_start_qnum,
                                    ZXIC_UINT32 aging_end_qnum,
                                    ZXIC_UINT32 aging_pkt_num,
                                    ZXIC_UINT32 aging_req_aful_th);

/******************************************************************************
*ϻһʱ䣬һϻһϻзΧΪ
* @param: dev_id: 豸
* @param    tm_type   0: etm; 1: ftm;
*           aging_en: ϻʹܣ1ʾϻʹܣ0ʾϻܹرա
*           aging_time: ϻһʱ䣬λms
            aging_que_start:ϻʼ
            aging_que_start:ϻֹ
ϻʱ=2*aging_interval*step_interval*q_num
aging_interval = (aging_time * 600000) / (2 * 1 * DPP_TM_Q_NUM);
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  xuhb     @date  2020/12/08
************************************************************/
DPP_STATUS dpp_tm_qmu_pkt_age_time_set(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 aging_en,
                                       ZXIC_UINT32 aging_time,
                                       ZXIC_UINT32 aging_que_start,
                                       ZXIC_UINT32 aging_que_end);


/***********************************************************/
/** etmԴfq/fq2/fq4/fq8 (16K= 16384)
* @param   dev_id   豸
* @param   fq_num   FQ8ı
* @param   fq2_num  FQ24ı
* @param   fq4_num  FQ42ı
* @param   fq8_num  FQ8
*          ܳ16K= 16384
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/02/26
************************************************************/
DPP_STATUS dpp_etm_crdt_fq_set(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 fq_num,
                               ZXIC_UINT32 fq2_num,
                               ZXIC_UINT32 fq4_num,
                               ZXIC_UINT32 fq8_num);

/***********************************************************/
/** TMԴsp/wfq/wfq2/wfq4/wfq8 etm9K=9216,ftm1920
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   sp_num   SP8ı
* @param   wfq_num  WFQ8ı
* @param   wfq2_num  WFQ24ı
* @param   wfq4_num  WFQ42ı
* @param   wfq8_num  WFQ8
*          ܳETM= 9216; FTM= 1920
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/02/26
************************************************************/
DPP_STATUS dpp_tm_crdt_wfqsp_set(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 sp_num,
                                 ZXIC_UINT32 wfq_num,
                                 ZXIC_UINT32 wfq2_num,
                                 ZXIC_UINT32 wfq4_num,
                                 ZXIC_UINT32 wfq8_num);

/***********************************************************/
/** flowеĹҽӹϵ(flowϼĹҽ)
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   flow_id   к
* @param   c_linkid  cͰҪҽӵϼid
* @param   c_weight  cͰҽӵϼȨ[1~511]
* @param   c_sp      cͰҽӵϼspȼ,Чֵ[0-8],9ȼν
* @param   mode      ҽģʽ0-Ͱ 1-˫ͰõͰʱע0
* @param   e_linkid  eͰҪҽӵϼid
* @param   e_weight  eͰҽӵϼȨ[1~511]
* @param   e_sp      eͰҽӵϼspȼЧֵ[0-8],9ȼν
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/02/27
************************************************************/
DPP_STATUS dpp_tm_crdt_flow_link_set(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 flow_id,
                                     ZXIC_UINT32 c_linkid,
                                     ZXIC_UINT32 c_weight,
                                     ZXIC_UINT32 c_sp,
                                     ZXIC_UINT32 mode,
                                     ZXIC_UINT32 e_linkid,
                                     ZXIC_UINT32 e_weight,
                                     ZXIC_UINT32 e_sp);

/***********************************************************/
/** õλQOSĹҽӹϵ:ȼ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   se_id      id
* @param   se_linkid  Ҫҽӵϼid
* @param   se_weight  ҽӵϼȨ[1~511]
* @param   se_sp      ҽӵϼspȼ,Чֵ[0-8],9ȼν
* @param   se_insw    ȼʹܣ0- 1-. òֱ0
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/02/27
************************************************************/
DPP_STATUS dpp_tm_crdt_se_link_set(ZXIC_UINT32 dev_id,
                                   ZXIC_UINT32 se_id,
                                   ZXIC_UINT32 se_linkid,
                                   ZXIC_UINT32 se_weight,
                                   ZXIC_UINT32 se_sp);

/***********************************************************/
/** õλQOSĹҽӹϵ:ȼ
* @param   dev_id       豸
* @param   tm_type      0-ETM,1-FTM
* @param   se_id        id
* @param   se_linkid    Ҫҽӵϼid
* @param   se_weight    WFQ2/4/8иȨֵ[1~511]ȡȵֵ
* @param   se_sp        ҽӵϼspȼ,Чֵ[0-7],8ȼν
* @param   se_insw      ȼʹܣ0- 1-. òֱ1
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/02/27
************************************************************/
DPP_STATUS dpp_tm_crdt_se_link_insw_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 se_id,
                                        ZXIC_UINT32 se_linkid,
                                        ZXIC_UINT32 se_weight,
                                        ZXIC_UINT32 se_sp);

/***********************************************************/
/** õλQOSĹҽӹϵ:ȼ,ҽ
* @param   dev_id       豸
* @param   tm_type      0-ETM,1-FTM
* @param   se_id        id
* @param   se_linkid    Ҫҽӵϼid
* @param   se_weight    WFQ8жӦȨֵ[1~511]
* @param   se_sp        ҽӵϼspȼ,Чֵ[0-7],8ȼν
* @param   se_insw      ȼʹܣ0- 1-. òֱ1
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/02/27
************************************************************/
DPP_STATUS dpp_tm_crdt_se_link_insw_single_set(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 se_id,
                                               ZXIC_UINT32 se_linkid,
                                               ZXIC_UINT32 se_weight,
                                               ZXIC_UINT32 se_sp);

/***********************************************************/
/** ɾҽӹϵ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   id_s      ҪɾŻʼid
* @param   id_e      ҪɾŻֹid
*             ETMΧ:0--0x47FF; FTMΧ:0-0xFFF
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/02/27
************************************************************/
DPP_STATUS dpp_tm_crdt_del_flow_link_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 id_s, ZXIC_UINT32 id_e);

/***********************************************************/
/** ɾҽӹϵ(Ŵ0ʼ)
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   se_id_s   Ҫɾʼid
* @param   se_id_e   Ҫɾֹid
*          ETMΧ:0--0x63FF; FTMΧ:0-0x77F
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/02/27
************************************************************/
DPP_STATUS dpp_tm_crdt_del_se_link_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 id_s, ZXIC_UINT32 id_e);

/***********************************************************/
/** se->pp->devҽӹϵ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   se_id   ˿ڹҽӵĵid
* @param   pp_id   [0-63]
* @param   weight  [1-511]
* @param   sp_mapping   0~7
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/3/4
************************************************************/
DPP_STATUS dpp_tm_crdt_se_pp_link_set(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 se_id,
                                      ZXIC_UINT32 pp_id,
                                      ZXIC_UINT32 weight,
                                      ZXIC_UINT32 sp_mapping);

/***********************************************************/
/**
* @param   dev_id   豸
* @param   tm_type  0-ETM,1-FTM
* @param   que_id   queue id
* @param   en       1:EͰCRS״̬ΪSLOW0:EͰCRS SLOW
*
* @return
* @remark  
* @see
* @author  XXX      @date  2019/05/08
************************************************************/
DPP_STATUS dpp_tm_crdt_eir_crs_filter_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 que_id, ZXIC_UINT32 en);


/***********************************************************/
/** αֵ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  yjd      @date  2015/07/16
************************************************************/
DPP_STATUS dpp_tm_clr_shape_para(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ˫Ͱʹܼģʽ
* @param   dev_id    豸
* @param   tm_type   0-ETM,1-FTM
* @param   db_en     ˫Ͱʹ
* @param   mode      0:c+eģʽ1:c+pģʽ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/03/11
************************************************************/
DPP_STATUS dpp_tm_shape_flow_db_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 db_en, ZXIC_UINT32 mode);

/***********************************************************/
/** β
* @param   dev_id    豸
* @param   tm_type   0-ETM,1-FTM
* @param   flow_id   к ETM:0-9215,FTM:0-2047
* @param   cir       cirʣλKbΧ[64Kb - 160Gb]
* @param   cbs       cbsͰλKBΧ[1KB - 64M]
*                    עcbs=0 ʾر,
* @param   db_en     ˫Ͱʹܣ0-Ͱ1-˫Ͱ
* @param   eir       eirʣλKbΧͬcir
* @param   ebs       ebsͰλKbΧͬcbs
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/03/11
************************************************************/
DPP_STATUS dpp_tm_shape_flow_para_set(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 flow_id,
                                      ZXIC_UINT32 cir,
                                      ZXIC_UINT32 cbs,
                                      ZXIC_UINT32 db_en,
                                      ZXIC_UINT32 eir,
                                      ZXIC_UINT32 ebs);


/***********************************************************/
/** tmõβ
* @param   dev_id    豸
* @param   tm_type   0-ETM,1-FTM
* @param   se_id     ź ETM:0x4800-0xABFF,FTM:0x1000-0x177F
* @param   pir       pirʣλKbΧͬcir
* @param   pbs       pbsͰλKbΧͬcbs
* @param   db_en     ģʽ0-Ͱ1-˫ͰFQ8/WFQ8Ч
* @param   cir       [0-3]cirʣλKbΧ[64Kb - 160Gb]
* @param   cbs       [0-3]cbsͰλKBΧ[1KB - 64M]
*                    עcbs=0 ʾر,
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/03/11
************************************************************/
DPP_STATUS dpp_tm_shape_se_para_set(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 se_id,
                                    ZXIC_UINT32 pir,
                                    ZXIC_UINT32 pbs,
                                    ZXIC_UINT32 db_en,
                                    ZXIC_UINT32 cir,
                                    ZXIC_UINT32 cbs);


/***********************************************************/
/** д˿ڼϢ
* @param   tm_type   0-ETM,1-FTM
* @param   port_id   ˿ں0-63
* @param   cir
* @param   cbs
* @param   c_en   cͰʹ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2014/03/03
************************************************************/
DPP_STATUS dpp_tm_shape_pp_para_wr(ZXIC_UINT32 dev_id,
                                   ZXIC_UINT32 port_id,
                                   ZXIC_UINT32 cir,
                                   ZXIC_UINT32 cbs,
                                   ZXIC_UINT32 c_en);

/***********************************************************/
/** ö˿ڼβ  תʽ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   port_id   ˿ں
* @param   p_para   Ϣ:CIR/CBS/EN
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cuiy      @date  2016/04/15
************************************************************/
DPP_STATUS dpp_tm_shape_pp_para_set(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 port_id,
                                    const DPP_TM_SHAPE_PP_PARA_T *p_para);

/***********************************************************/
/** תɨʹܺɨ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   scan_en   תɨʹܡ0رգ1
* @param   scan_rate   תɨʣɨڲ256
*
* @return  0ʾɹ 0ʾʧ
* @remark  
* @see
* @author  taq      @date  2015/03/10
************************************************************/
DPP_STATUS dpp_tm_qmu_scan_rate_set(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 scan_en,
                                    ZXIC_UINT32 scan_rate);

/***********************************************************/
/** CMD_SWֶ˿(qmu˿)ʺʹ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   shape_cir ֵλMbpsΧ[0-160000]
* @param   shape_cbs Ͱ λBΧ[0-0x1EE00]
* @param   shape_en   ʹ
* @return  0ʾɹ 0ʾʧ
* @remark  
* @see
* @author   whuashan   2020-3-17
************************************************************/
DPP_STATUS dpp_tm_qmu_egress_shape_set(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 port_id,
                                       ZXIC_UINT32 shape_cir,
                                       ZXIC_UINT32 shape_cbs,
                                       ZXIC_UINT32 shape_en);


/***********************************************************/
/** WRED߶ӦĲ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   level   WREDֲ֧κţ0:м1:˿ڼ
* @param   wred_id   м֧16WRED0-15˿ڼ֧80-7
* @param   dp   ֧8dpȡֵ0-7
* @param   p_para   õWREDֵ
           max_th  ƽֵ
           min_th  ƽֵ
           max_p  
           weight   ƽȼȨ
           q_len_th ֵ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  taq     @date  2015/04/20
************************************************************/
DPP_STATUS dpp_tm_cgavd_wred_dp_line_para_set(ZXIC_UINT32 dev_id,
                                              DPP_TM_CGAVD_LEVEL_E level,
                                              ZXIC_UINT32 wred_id,
                                              ZXIC_UINT32 dp,
                                              DPP_TM_WRED_DP_LINE_PARA_T *p_para);


/***********************************************************/
/** øWRED߶ӦĲ
* @param   tm_type   0-ETM,1-FTM
* @param   level   WREDֲ֧κţ0:м1:˿ڼ
* @param   wred_id   м֧16WRED0-15˿ڼ֧80-7
* @param   dp   ֧8dpȡֵ0-7
* @param   max_th  ƽֵ
* @param   min_th  ƽֵ
* @param   max_p  
* @param   weight   ƽȼȨ
* @param   q_len_th   ֵ
* @param   flag   Գ˷ĵǰȱ־λ:1Ϊ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cy     @date  2015/11/9
************************************************************/
DPP_STATUS dpp_tm_wred_dp_line_para_flag_wr(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 level,
                                            ZXIC_UINT32 wred_id,
                                            ZXIC_UINT32 dp,
                                            ZXIC_UINT32 max_th,
                                            ZXIC_UINT32 min_th,
                                            ZXIC_UINT32 max_p,
                                            ZXIC_UINT32 weight,
                                            ZXIC_UINT32 q_len_th,
                                            ZXIC_UINT32 flag);

/***********************************************************/
/** CPUõıĳǷ㶪ʵʹ
* @param   tm_type   0-ETM,1-FTM
* @param   flag   Գ˷ĵǰȱ־λ:1Ϊ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cy    @date  2015/11/9
************************************************************/
DPP_STATUS dpp_tm_cgavd_wred_pke_len_calc_sign_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 flag);


/***********************************************************/
/** TMMU TMƬģʽ
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   imem_en   1Ƭ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  ˵Чʾʹܴ򿪣TMMUٷMMUĶдûҪ֤Cache PDȫС
* @see
* @author  wush      @date  2017/10/14
************************************************************/
DPP_STATUS dpp_tm_tmmu_imem_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 imem_en);

/***********************************************************/
/** TMMU ǿDDR RDY
* @param   dev_id   豸
* @param   tm_type   0-ETM,1-FTM
* @param   ddr_force_rdy   1bit0Ϊ1QMUDDR0 RDYһֱΪ1
                           2bit0DDR0bit7DDR7
                           3ƬģʽҪΪ8'hffųDDRš
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark
* @see
* @author  wush      @date  2017/10/14
************************************************************/
DPP_STATUS dpp_tm_tmmu_ddr_force_rdy_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_force_rdy);

/***********************************************************/
/** дһƬTMĴ
* @param   module_id TMģ
* @param   first_addr   ʼĴĵַ
* @param   reg_num   ܹȡļĴ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  yjd      @date  2015/07/26
************************************************************/
DPP_STATUS dpp_tm_wr_more_reg(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 first_addr, ZXIC_UINT32 first_data, ZXIC_UINT32 data_step, ZXIC_UINT32 reg_num);

/***********************************************************/
/** ӡtmϳúϢ
*
* @return
* @remark  
* @see
* @author        @date  2015/10/21
************************************************************/
DPP_STATUS dpp_tm_help(ZXIC_UINT32 dev_id);

/***********TM CPUλӿ End*************/


#endif/***function declaration***/

#endif/****_DPP_TM_H_****/





