#ifndef _MCODE_DIAG_H_
#define _MCODE_DIAG_H_

#include <stdio.h>
#include "zxic_common.h"

struct DropInfo {
    ZXIC_UINT32 address;
    ZXIC_CHAR reason[256];
};

struct DropInfo dropInfo[] = {
    {0xc8a8, "ingress下行流程入口处查port属性表miss后丢包"},
    {0xc8a9, "ingress上行单播报文panel表或port表miss后丢包"},
    {0xc8aa, "ingress上行非单播报文panel表或port表miss, 且广播包ncis表和debug表都没有命中, 或组播包ncsi表没有命中,丢包"},
    {0xc8ab, "egress流程入口port属性表未命中丢包"},
    {0xc8ac, "rte_flow发送到panel时,查panel属性表未命中,丢包"},
    {0xc8ad, "在toiz、crc或xor算法得到RSS后,进入到GET_VQM_QID_BASE_RSS中,vqm_qid_tbl表未命中,丢包"},
    {0xc8ae, "egress流程中查MG_ID表未命中,丢包"},
    {0xc8af, "ingress流程中,进入RDMA流程后查port端口表未命中,丢包"},
    {0xc8b0, "ingress流程中rdma包头匹配查VHCA表未命中,丢包"},
    {0xc8b1, "egress流程中,跳入JUDGE_IS_MATCH_VLAN_BASE_VFID中查vlan_filter表未命中丢包"},
    {0xc8b2, "下行广播报文流程中广播表未命中,丢包"},
    {0xc8b3, "bc从113端口回环返回到send_to_panel时port属性表未命中,丢包"},
    {0xc8b4, "mc从113端口回环返回到send_to_panel时port属性表未命中,丢包"},
    {0xc8b5, "上行单播未命中L2转发表,且同时未命中单播混杂表,丢包"},
    {0xc8b6, "RDMA时延优化场景下,上行QP0/1报文转发表miss丢包"},
    {0xc8b7, "ingress_acl_action中,acl_action_process中acl_action表查表未命中,丢包"},
    {0xc8b8, "rte_egress_process中,端口属性表未命中,丢包"},
    {0xc8b9, "rte_egress_process中,端口属性表命中,is_passthrough使能,且lag使能,但是lag表没有命中,丢包"},
    {0xc8ba, "rte_egress_process中,upcall时查端口属性表未命中,丢包"},
    {0xc8bb, "egress_process中,发送到bond时,查lag表没有命中,丢包"},
    {0xc8bc, "egress流程中,计算CALC_TM_UP时,查DSCP_TO_UP表没有命中,丢包"},
    {0xc8bd, "egress流程中,计算CALC_TM_TC时,查UP_TO_TC表没有命中,丢包"},
    {0xc8be, "egress入口处port属性表命中,但is_up未使能,丢包"},
    {0xc8bf, "上行单播未命中L2转发表,命中单播混杂表,output_total_vf_num=0,且uc_flood_pf未使能,丢包"},
    {0xc8c0, "flood流程从113端口回环后,返回到flood_to_pf流程,pf未使能,丢包"},
    {0xc8c1, "rte_flow中,action_tbl表命中,但是mask_out_port比特位为0,丢包"},
    {0xc8c2, "rte_egress中,port属性表命中但是is_up未置位,丢包"},
    {0xc8c3, "mc流程从113端口回环后,上下行返回到send_to_pf,但是pf没有使能,丢包"},
    {0xc8c4, "egress中上行数据包vlan_filter使能,但vlan_type和qinq_type皆未使能,丢包"},
    {0xc8c5, "ergress中valn_filter流程中vlan_id不匹配bitmap,丢包"},
    {0xc8c6, "rsv"},
    {0xc8c7, "fd_process中,fd表未命中,且fd的发送到指定队列标志位未置1,丢包"},
    {0xc8c8, "ingress中rdma全0 dmac,丢包"},
    {0xc8c9, "bitmap发包发到自身时,丢包"},
    {0xc8ca, "bc下行113端口回环返回到send_to_pf时,发送到自身,丢包"},
    {0xc8cb, "mc下行113端口回环返回到send_to_pf,发送到自身,丢包"},
    {0xc8cc, "发送到bond时,lag_bitmap_to_egress_port_id中没有找到使能端口后丢包"},
    {0xc8cd, "在CLAC_HASH_EGRESS_PORT_ID(macro)中,lag_member_num为0时,丢包"},
    {0xc8ce, "HARDWARE_BOND_DOWNLINK_PROCESS(macro)中,非LACP报文,丢包（被注释,暂不统计）"},
    {0xc8cf, "lag流程中,计算hash_egress_port时,lag_active_back_up和lag_lacp_mode未使能,丢包"},
    {0xc8d0, "rdma出向时,开启vlan_filter后,非vlan和qinq包,丢包"},
    {0xc8d1, "egress流程中发往host时,vqm,dtp和drs都没有使能后,丢包"},
    {0xc8d2, "进行fd流程中,fd未使能后,进入到calc_egress_vqm_qid内的rss流程,当toiz、crc和xor算法没有使能时,丢包"},
    {0xc8d3, "进行rss计算时,toiz算法五元,三元和二元没有使能,丢包"},
    {0xc8d4, "bitmap流程中,total_pkt_num大于要发包个数,丢包"},
    {0xc8d5, "bitmap流程中,分段total_pkt_num大于分段要发包个数,丢包"},
    {0xc8d6, "rte_flow中路由表查表命中,但是标志位都没有使能,丢包"},
    {0xc8d7, "rte_flow中rte_l2_tbl命中,但是标志位都没有使能,丢包"},
    {0xc8d8, "rte_flow中rte_l3_tbl命中,但是标志位都没有使能,丢包"},
    {0xc8d9, "rte_flow中dp_hash表命中,但是标志位都没有使能,丢包"},
    {0xc8da, "在CLAC_HASH_EGRESS_PORT_ID(macro)中,egress_lacp_hash_factor未使能时,丢包"},
    {0xc8db, "上行magic报文未使能,丢包"},
    {0xc8dc, "rsv"},
    {0xc8dd, "rsv"},
    {0xc8de, "rsv"},
    {0xc8df, "rsv"},
    {0xc8e0, "rsv"},
    {0xc8e1, "spoof_check未通过,丢包"},
    {0xc8e2, "mtu_tx全局丢包"},
    {0xc8e3, "mtu_rx全局丢包"},
    {0xc8e4, "bond_lacp_switch未使能,丢包"},
    {0xc8e5, "bond_bus_switch未使能,丢包"},
    {0xc8e6, "port_meter不正常,丢包"},
    {0xc8e7, "egress流程出口查panel表没有命中"},
    {0xc8e8, "组播回环miss时发给panel和ncsi之后,广播和泛洪发给riscv时,发给ncsi和debug之后,丢包"},
    {0xc8e9, "ncsi多播报文vlan未命中(MC_TO_NCSI_DROP_FLAG置1);NCSI属性表没有命中;NCSI流程中的广播包和组播包处理过程中丢包"},
    {0xc8ea, "debug处理流程中因表未命中,表属性不正确,组播报文等原因丢包"},
    {0xc8eb, "public riscv disc 报文主动丢包（属于正常情况）"},
    {0xc8ec, "L41588单播报文L2表未命中,需要加密的L41588报文未命中加密表,丢包"},
    {0xc8ed, "单播ESP和AH上行报文L2表未命中,丢包"},
    {0xc8ee, "丢包总计"},
};


typedef struct drop_info {
    ZXIC_UINT32 address;
    ZXIC_CHAR info[256];
}drop_info;

drop_info mcode_drop_info_v1[] = {
    {0x11d02, "ovs pipe中全丢包数量统计"},
    {0x11d03, "ovs出向business port属性表未命中,丢包"},
    {0x11d04, "ovs掩码方案l2表action mask没有bit使能,丢包"},
    {0x11d05, "ovs掩码方案l3l4表action mask没有bit使能,丢包"},
    {0x11d06, "ovs掩码方案outer_l3表action mask没有bit使能,丢包"},
    {0x11d07, "ovs掩码方案中掩码开关表保护丢包(总次数超过127次循环丢包/按寄存器查询时超过32次丢包)"},
    {0x11d08, "ovs pipe中action表action_mask中的out_put未使能,丢包"},
    {0x11d09, "ovs pipe中上送时business port属性表未命中,丢包"},
    {0x11d0a, "ovs pipe中meter不正常丢包"},
    {0x11d0b, "ovs pipe中mtu tx方向丢包"},
    {0x11d0c, "ovs pipe中mtu rx方向丢包"},
    {0x11d0d, "ovs egress中查端口属性表miss,丢包"},
    {0x11d22, "sriov中全丢包数量统计"},
    {0x11d23, "sriov中上行广播复制环回后第一份报文报文用于流水线串接,但此时不需要去走流水线串接的流程,丢包"},
    {0x11d24, "sriov中下行广播复制环回后发往pf的报文,但源入向端口就是该pf,丢包"},
    {0x11d25, "sriov中bitmap_to_vfid时得到的出向端口为源入向端口,丢包"},
    {0x11d26, "sriov中bitmap_to_vfid时,在计算vfid时,单组(共四组)bitmap中没有bit位使能,丢包"},
    {0x11d27, "sriov中bitmap_to_vfid时,复制报文的index大于bitmap计算出总共要复制的报文份数,丢包"},
    {0x11d28, "sriov中单播泛洪复制环回后发往pf的报文,但此时pf没有使能,丢包"},
    {0x11d29, "sriov中下行组播复制环回后发往pf的报文,但源入向端口就是该pf,丢包"},
    {0x11d2a, "sriov中下行组播复制环回后发往pf的报文,但此时pf没有使能,丢包"},
    {0x11d2b, "sriov中下行spoof_check丢包"},
    {0x11d2c, "sriov中出向流程中vqm_vfid表未命中,丢包"},
    {0x11d2d, "sriov中入向meter异常丢包"},
    {0x11d2e, "sriov中出向meter异常丢包"},
    {0x11d30, "sriov中sriov vlan过滤不通过,丢包"},
    {0x11d2f, "sriov中sriov business vlan过滤不通过,丢包"},
    {0x11d31, "sriov中vlan filter中vlan id越界,丢包"},
    {0x11d32, "sriov中vlan filter表未命中,丢包"},
    {0x11d33, "sriov入向sriov vlan插入时vlan属性表未命中,丢包"},
    {0x11d34, "sriov出向端口查vlan属性表未命中,丢包"},
    {0x11d35, "sriov出向端口rx mtu丢包"},
    {0x11d36, "sriov中混杂发给pf的报文,pf混杂属性和fd属性没有开启,丢包"},
    {0x11d37, "sriov中混杂发给pf的报文,pf开启fd但未开启混杂,fd表miss,丢包"},
    {0x11d38, "sriov中fd使能drop_action,丢包"},
    {0x11d39, "sriov中单播混杂bitmap不为0时,复制的第二份报文丢包"},
    {0x11d42, "ingress中全丢包数量统计"},
    {0x11d43, "ingress下行vqm_vfid属性表未命中,丢包"},
    {0x11d44, "ingress上行uplink_phy_port属性表未命中,丢包"},
    {0x11d45, "ingress上行vqm_vfid属性表未命中,丢包"},
    {0x11d46, "ingress下行bond pf业务报文丢弃"},
    {0x11d47, "ingress中meter异常丢包"},
    {0x11d48, "ingress的tx方向mtu丢包"},
    {0x11d49, "ingress中rdma收包mac全0丢包"},
    {0x11d4a, "ingress中rdma查询vhca表miss丢包"},
    {0x11d4b, "ingress中svlan插入时查入向端口的vlan属性表未命中,丢包"},
    {0x11d52, "ingress adapter中全丢包数量统计"},
    {0x11d53, "ingress adapter上行lacp报文uplink_phy_port属性表未命中,丢包"},
    {0x11d54, "ingress adapter上行lacp报文member_port未up,丢包"},
    {0x11d55, "ingress adapter下行vqm_vfid属性表未命中,丢包"},
    {0x11d56, "ingress adapter查net_element表未命中,丢包"},
    {0x11d57, "ingress_adapter非单流水线报文,丢包"},
    {0x11d58, "ingress_adapter上行RDMA短路径QP1报文查表未命中,丢包"},
    {0x11d59, "ingress_adapterRDMA短路径QP溢出,丢包"},
    {0x11d5a, "ingress_adapter上行magic报文未使能,丢包"},
    {0x11d92, "pipe adapter中全丢包数量统计"},
    {0x11d93, "pipe adapter中从sriov流水线进入的报文非网元类型表流水线,丢包"},
    {0x11d94, "pipe adapter中的报文为串流水线报文,丢包"},
    {0x11d95, "pipe adapter中upf流水线的目的vport属性表未命中,丢包"},
    {0x11d96, "pipe adapter中ne流水线的目的vport表未命中,丢包"},
    {0x11df2, "egress adapter中全丢包数量统计"},
    {0x11df3, "egress adapter中sriov to phyport 目的vqm_vfid属性表未命中,丢包"},
    {0x11df4, "egress adapter中sriov to phyport 目的vqm_vfid端口没有up,丢包"},
    {0x11df5, "egress adapter中sriov to cpu 目的vqm_vfid属性表未命中,丢包"},
    {0x11df6, "egress adapter中sriov to cpu 目的vqm_vfid端口没有up,丢包"},
    {0x11df7, "egress adapter中ovs to phyport 目的vqm_vfid属性表未命中,丢包"},
    {0x11df8, "egress adapter中ovs to phyport 目的vqm_vfid端口没有up,丢包"},
    {0x11df9, "egress adapter中ovs to cpu 目的vqm_vfid属性表未命中,丢包"},
    {0x11dfa, "egress adapter中ovs to cpu 目的vqm_vfid端口没有up,丢包"},
    {0x11dfb, "egress adapter中upf to phyport 目的vqm_vfid属性表未命中,丢包"},
    {0x11dfc, "egress adapter中upf to phyport 目的vqm_vfid端口没有up,丢包"},
    {0x11dfd, "egress adapter中upf to cpu 目的vqm_vfid属性表未命中,丢包"},
    {0x11dfe, "egress adapter中upf to cpu 目的vqm_vfid端口没有up,丢包"},
    {0x11dff, "egress adapter中ne to phyport 目的vqm_vfid属性表未命中,丢包"},
    {0x11e00, "egress adapter中ne to phyport 目的vqm_vfid端口没有up,丢包"},
    {0x11e01, "egress adapter中ne to cpu 目的vqm_vfid属性表未命中,丢包"},
    {0x11e02, "egress adapter中ne to cpu 目的vqm_vfid端口没有up,丢包"},
    {0x11e03, "egress adapter中ne from cpu 目的vqm_vfid属性表未命中,丢包"},
    {0x11e22, "egress中全丢包数量统计"},
    {0x11e23, "egress中lag表未命中,丢包"},
    {0x11e24, "egress中lag active模式和back_up模式皆没有使能,丢包"},
    {0x11e25, "egress中lag hash_factor没有使能,丢包"},
    {0x11e26, "egress中uplink_phy_port属性表没有命中,丢包"},
    {0x11e28, "egress中通过toiz计算qid时hash_factor未使能,丢包"},
    {0x11e29, "egress中lag_bitmap中没有使能bit位,丢包"},
    {0x11e2a, "egress中发送到cpu时vqm/dtp/drs没有使能,丢包"},
    {0x11e2b, "egress中计算vqm_qid时vqm_qid表没有命中,丢包"},
    {0x11e2c, "egress中下行tm流程中dscp_to_up表没有命中,丢包"},
    {0x11e2d, "egress中下行tm流程中up_to_tc表没有命中,丢包"},
    {0x11e2e, "egress中meter异常丢包"},
    {0x11e2f, "egress中uplink_phy_port表未命中,丢包"},
    {0x11e30, "egress中lacp包uplink_phy_port表未命中,丢包"},
    {0x11e32, "egress中发往phy_port时mtu rx方向丢包"},
    {0x11e33, "egress中vxlan报文出向更新inner vlan时查vlan属性表未命中"},
};


drop_info mcode_drop_info_v2[] = {
    {0x11d02, "ovs pipe中全丢包数量统计"},
    {0x11d03, "ovs出向business port属性表未命中,丢包"},
    {0x11d04, "ovs掩码方案l2表action mask没有bit使能,丢包"},
    {0x11d05, "ovs掩码方案l3l4表action mask没有bit使能,丢包"},
    {0x11d06, "ovs掩码方案outer_l3表action mask没有bit使能,丢包"},
    {0x11d07, "ovs掩码方案中掩码开关表保护丢包(总次数超过127次循环丢包/按寄存器查询时超过32次丢包)"},
    {0x11d08, "ovs pipe中action表action_mask中的out_put未使能,丢包"},
    {0x11d09, "ovs pipe中上送时business port属性表未命中,丢包"},
    {0x11d0a, "ovs pipe中meter不正常丢包"},
    {0x11d0b, "ovs pipe中acl_action表miss,丢包"},
    {0x11d0c, "ovs pipe中mtu rx方向丢包"},
    {0x11d0d, "ovs egress中查端口属性表miss,丢包"},
    {0x11d0e, "ovs performance search L2处理丢包"},
    {0x11d0f, "ovs performance search L34处理丢包"},
    {0x11d22, "sriov中全丢包数量统计"},
    {0x11d23, "sriov中上行广播复制环回后第一份报文报文用于流水线串接,但此时不需要去走流水线串接的流程,丢包"},
    {0x11d24, "sriov中下行广播复制环回后发往pf的报文,但源入向端口就是该pf,丢包"},
    {0x11d25, "sriov中bitmap_to_vfid时得到的出向端口为源入向端口,丢包"},
    {0x11d26, "sriov中bitmap_to_vfid时,在计算vfid时,单组(共四组)bitmap中没有bit位使能,丢包"},
    {0x11d27, "sriov中bitmap_to_vfid时,复制报文的index大于bitmap计算出总共要复制的报文份数,丢包"},
    {0x11d28, "sriov中上行组播复制环回串流水线报文, 但此时不需要走流水线串接的流程,丢包"},
    {0x11d29, "sriov中下行组播复制环回后发往pf的报文,但源入向端口就是该pf,丢包"},
    {0x11d2a, "sriov下行tx mtu丢包"},
    {0x11d2b, "sriov中下行spoof_check丢包"},
    {0x11d2c, "sriov中出向流程中vqm_vfid表未命中,丢包"},
    {0x11d2d, "sriov中入向meter异常丢包"},
    {0x11d2e, "sriov中出向meter异常丢包"},
    {0x11d2f, "sriov中sriov business vlan过滤不通过,丢包"},
    {0x11d30, "sriov中sriov vlan过滤不通过,丢包"},
    {0x11d31, "sriov中vlan filter中vlan id越界,丢包"},
    {0x11d32, "sriov中vlan filter表未命中,丢包"},
    {0x11d33, "sriov入向sriov vlan插入时vlan属性表未命中,丢包"},
    {0x11d34, "sriov出向端口查vlan属性表未命中,丢包"},
    {0x11d35, "sriov出向端口rx mtu丢包"},
    {0x11d36, "sriov中混杂发给pf的报文,pf混杂属性和fd属性没有开启,丢包"},
    {0x11d37, "sriov中混杂发给pf的报文,pf开启fd但未开启混杂,fd表miss,丢包"},
    {0x11d38, "sriov中fd使能drop_action,丢包"},
    {0x11d39, "sriov中单播混杂泛洪复制串流水线报文,不需要走流水线串接流程,正常丢包"},
    {0x11d3a, "sriov中fd计算队列 hash factor不支持, 丢包"},
    {0x11d42, "ingress中全丢包数量统计"},
    {0x11d43, "ingress下行vqm_vfid属性表未命中,丢包"},
    {0x11d44, "ingress上行uplink_phy_port属性表未命中,丢包"},
    {0x11d45, "ingress上行vqm_vfid属性表未命中,丢包"},
    {0x11d46, "ingress下行bond pf业务报文丢弃"},
    {0x11d47, "ingress中meter异常丢包"},
    {0x11d48, "ingress的tx方向mtu丢包"},
    {0x11d49, "ingress中rdma收包mac全0丢包"},
    {0x11d4a, "ingress中rdma查询vhca表miss丢包"},
    {0x11d4b, "ingress中svlan插入时查入向端口的vlan属性表未命中,丢包"},
    {0x11d4c, "ingress中public label riscv单播主动丢包,正常丢包"},
    {0x11d4d, "ingress中驱动包头校验不通过,丢包"},
    {0x11d52, "ingress adapter中全丢包数量统计"},
    {0x11d53, "ingress adapter上行lacp报文uplink_phy_port属性表未命中,丢包"},
    {0x11d54, "ingress adapter上行lacp报文member_port未up,丢包"},
    {0x11d55, "ingress adapter下行lacp报文vqm_vfid属性表未命中,丢包"},
    {0x11d56, "ingress adapter查net_element表未命中,丢包"},
    {0x11d57, "ingress_adapter非单流水线报文,丢包"},
    {0x11d58, "ingress_adapter上行RDMA短路径QP1报文查表未命中,丢包"},
    {0x11d59, "ingress_adapterRDMA短路径QP溢出,丢包"},
    {0x11d5a, "ingress_adapter上行magic报文未使能,丢包"},
    {0x11d5b, "ingress_adapter下行riscv报文pd type不对,丢包"},
    {0x11d92, "pipe adapter中全丢包数量统计"},
    {0x11d93, "pipe adapter中从sriov流水线进入的报文非网元类型表流水线,丢包"},
    {0x11d94, "pipe adapter中的报文为串流水线报文,丢包"},
    {0x11d95, "pipe adapter中upf流水线的目的vport属性表未命中,丢包"},
    {0x11d96, "pipe adapter中ne流水线的目的vport属性表未命中,丢包"},
    {0x11df2, "egress adapter中全丢包数量统计"},
    {0x11df3, "egress adapter中sriov to phyport 目的vqm_vfid属性表未命中,丢包"},
    {0x11df4, "egress adapter中sriov to phyport 目的vqm_vfid端口没有up,丢包"},
    {0x11df5, "egress adapter中sriov to cpu 目的vqm_vfid属性表未命中,丢包"},
    {0x11df6, "egress adapter中sriov to cpu 目的vqm_vfid端口没有up,丢包"},
    {0x11df7, "egress adapter中ovs to phyport 目的vqm_vfid属性表未命中,丢包"},
    {0x11df8, "egress adapter中ovs to phyport 目的vqm_vfid端口没有up,丢包"},
    {0x11df9, "egress adapter中ovs to cpu 目的vqm_vfid属性表未命中,丢包"},
    {0x11dfa, "egress adapter中ovs to cpu 目的vqm_vfid端口没有up,丢包"},
    {0x11dfb, "egress adapter中upf to phyport 目的vqm_vfid属性表未命中,丢包"},
    {0x11dfc, "egress adapter中upf to phyport 目的vqm_vfid端口没有up,丢包"},
    {0x11dfd, "egress adapter中upf to cpu 目的vqm_vfid属性表未命中,丢包"},
    {0x11dfe, "egress adapter中upf to cpu 目的vqm_vfid端口没有up,丢包"},
    {0x11e01, "egress adapter中ne to phyport 目的vqm_vfid属性表未命中,丢包"},
    {0x11e02, "egress adapter中ne to phyport 目的vqm_vfid端口没有up,丢包"},
    {0x11e03, "egress adapter中ne to cpu 目的vqm_vfid属性表未命中,丢包"},
    {0x11e04, "egress adapter中ne to cpu 目的vqm_vfid端口没有up,丢包"},
    {0x11e05, "egress adapter中ne from cpu 目的vqm_vfid属性表未命中,丢包"},
    {0x11e08, "egress_adapter中lag 表miss,丢包"},
    {0x11e09, "egress adapter中lag mode未使能,丢包"},
    {0x11e0a, "egress adapter中lag hash factor不支持,丢包"},
    {0x11e0b, "egress_adapter中lag 成员口个数为0,丢包"},
    {0x11e0c, "egress_adapter中lad bitmap为0,丢包"},
    {0x11e0d, "egress_adapter中debug报文丢包"},
    {0x11e0e, "egress_adapter中ncsi报文丢包"},
    {0x11e0f, "egress_adapter中ncsi 多播报文丢包，正常丢包"},
    {0x11e10, "egress_adapter中riscv复制时保护丢包, 正常丢包"},
    {0x11e11, "egress_adapter中rdma lag tbl misss, 丢包"},
    {0x11e12, "egress_adapter中rdma lag成员口数量为0, 丢包"},
    {0x11e13, "egress_adapter中rdma lag mode未使能, 丢包"},
    {0x11e14, "egress_adapter中rdma lag hash factor不支持丢包"},
    {0x11e22, "egress中全丢包数量统计"},
    {0x11e23, "egress中uplink_phy_port属性表没有命中,丢包"},
    {0x11e24, "egress中发往phy_port时mtu rx方向丢包"},
    {0x11e25, "egress中rss hash factor不支持, 丢包"},
    {0x11e26, "egress中rss vqm qid表miss丢包"},
    {0x11e27, "egress中 meter队列限速丢包"},
    {0x11e28, "egress中发送到cpu时vqm/dtp/drs没有使能,丢包"},
    {0x11e29, "egress中tm dscp_to_up表miss丢包"},
    {0x11e2a, "egress中tm up_to_tc表miss丢包"},
    {0x11e2b, "egress中lacp包uplink_phy_port表未命中,丢包"},
    {0x11de2, "pkt capture全丢包数量统计"},
    {0x11de3, "pkt capture中查上送端口表miss,丢包"},
    {0x11de4, "pkt capture中限速丢包"},
    {0x11de5, "pkt capture中egress方向复制份数异常丢包"},
    {0x11de6, "pkt capture中ingress方向复制份数异常丢包"},
};


typedef struct pkt_info {
    ZXIC_UINT32 address;
    ZXIC_CHAR info[256];
}pkt_info;

pkt_info mcode_pkt_info[] = {
    {0x11e42, "ovs中ct表miss上送"},
    {0x11e43, "ovs中掩码开关表无bit位使能上送"},
    {0x11e44, "ovs中掩码开关表miss上送"},
    {0x11e45, "ovs中业务掩码表miss上送"},
    {0x11e46, "ovs中ct_state掩码表miss上送"},
    {0x11e47, "ovs中mask方案中outer_l3表miss上送"},
    {0x11e48, "ovs中mask方案中l2表未命中后miss上送"},
    {0x11e49, "ovs中mask方案中l3l4表未命中后miss上送"},
    {0x11e4a, "ovs中mask方案中action表未命中后miss上送"},
    {0x11e4b, "ovs中mask方案中tunnel_encap表未命中后miss上送"},
    {0x11e4c, "ovs中ingress acl action中使能upcall动作后上送"},
    {0x11e4d, "ovs中egress acl action中使能upcall动作后上送"},
    {0x11e4e, "ovs中ingress_sample的common_process中acl_action中使能upcall动作后上送"},
    {0x11e4f, "ovs中egress_sample的common_process中acl_action中使能upcall动作后上送"},
    {0x11e50, "ovs中mask方案中组播表未命中后miss上送"},
    {0x11e51, "ovs中mask方案中组播复制回环后查对应组播表未命中后miss上送"},
    {0x11e52, "ovs中2level match ct表miss上送"},
    {0x11e53, "ovs中2level match 掩码开关表无bit位使能上送"},
    {0x11e54, "ovs中2level match 掩码开关表miss上送"},
    {0x11e55, "ovs中2level match 业务掩码表miss上送"},
    {0x11e56, "ovs中2level match ct_state掩码表miss上送"},
    {0x11e57, "ovs中2level match outer_l3表miss上送"},
    {0x11e58, "ovs中2level match mask方案中l2表未命中后miss上送"},
    {0x11e59, "ovs中2level match mask方案中l3l4表未命中后miss上送"},
    {0x11e5a, "ovs中2level match mask方案中action表未命中后miss上送"},
    {0x11e5b, "ovs中2level match mask方案中tunnel_encap表未命中后miss上送"},
    {0x11e62, "sriov中fd表miss"},
};

#endif
