/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_dev.h
* 文件标识 :
* 内容摘要 :
* 其它说明 :
* 当前版本 :
* 作    者 : 王春雷
* 完成日期 : 2014/02/10
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* 修改记录1: 代码规范性修改
* 修改日期:  2014/02/10
* 版 本 号:
* 修 改 人:  丁金凤
* 修改内容:
***************************************************************/


#ifndef _DPP_DEV_H_
#define _DPP_DEV_H_

#ifdef __cplusplus
extern "C" {
#endif
#include "dpp_devmng_api.h"

#include "dpp_reg.h"
#include "dpp_mem_info.h"



#include "dpp_ppu_api.h"
#include "dpp_ppu.h"

#include "dpp_se_api.h"
#include "dpp_se.h"
#include "dpp_etcam.h"
#include "dpp_se_cfg.h"

#include "dpp_pbu.h"
#include "dpp_pktrx_api.h"
#include "dpp_pktrx_cfg.h"
#include "dpp_odma_api.h"
#include "dpp_odma.h"
#include "dpp_mr_api.h"
#include "dpp_nppu_diag.h"


#include "dpp_tm_api.h"
#include "dpp_tm.h"

#include "dpp_dtb_cfg.h"
#include "dpp_dtb.h"
#include "dpp_hash.h"
#include "dpp_apt_se_api.h"


//#include "dpp_stat_api.h"
//#include "dpp_stat_cfg.h"
//#include "dpp_stat_car.h"

#ifndef WIN32

#endif

#include "dpp_oam_api.h"
#include "dpp_oam.h"
#include "dpp_type_api.h"
//#include "dpp_int.h"

#define DPP_KEYSIG_DEBUG           (1)
#define DPP_DEV_CHANNEL_MAX        (16)  /* 支持卡数量 */
#define DPP_DEV_PPU_CLS_MAX        (6)  /* 芯片支持4级cluster */
#define DPP_DEV_PPU_INSTR_REG_NUM  (3)  /* 芯片支持4级cluster 共2个指令空间*/

#define DPP_DEV_ME_MAX             (8)  /* 每级cluster支持8个me */
#define DPP_DEV_SDT_ID_MAX         (256U)
#define DPP_DEV_PF_NUM_MAX         (8)   

#define DPP_DEV_SLOT_ID(DEVICE_ID)       ((DEVICE_ID) & (DPP_DEV_CHANNEL_MAX - 1))
#define DPP_DEV_PCIE_ID(DEVICE_ID)       ((DEVICE_ID >> 16) & 0xFFFF)
#define DPP_DEV_VF_INDEX(DEVICE_ID)      (DPP_DEV_PCIE_ID(DEVICE_ID) & 0xFF)
#define DPP_DEV_PF_INDEX(DEVICE_ID)      ((DPP_DEV_PCIE_ID(DEVICE_ID) >> 8) & 0x7)

#define DPP_CHIP_DPP               (0x279221)

/* env init flag */
#define DPP_ENV_INIT_SAL          (1<<0)
#define DPP_ENV_INIT_SOCKET       (1<<1)
#define DPP_ENV_INIT_THREAD       (1<<2)
#define DPP_ENV_INIT_ALL          (DPP_ENV_INIT_SAL | DPP_ENV_INIT_SOCKET | \
                                   DPP_ENV_INIT_THREAD)

#define DPP_PCIE_DTB4K_ADDR_OFFSET     (0x6000)
#define DPP_PCIE_NP_MEM_SIZE           (0x2000000)
#define DPP_PCIE_AGENT_ADDR_OFFSET     (0x2000)

#define GET_ARRCH64_ADDR_ROUTER(ARRCH64_ADDR) (ARRCH64_ADDR & 0xF0000)
#define ARRCH64_ADDR_2_X86(ARRCH64_ADDR) (((ARRCH64_ADDR >> 20) << 16) | (ARRCH64_ADDR & 0xFFFF))
#define X86_ADDR_2_ARRCH64(X86_ADDR) (((X86_ADDR & (~0xFFFF)) << 4) | (X86_ADDR & 0xFFFF))

#define DEV_ZF_EP_NO (4)

typedef struct dpp_dev_res_t
{
    DPP_APT_SE_RES_T   std_nic_res;      /* 标卡流表资源 */ 
    DPP_APT_SE_RES_T   offload_res;      /* 业务卸载流表资源*/
}DPP_DEV_RES_T;

typedef struct dpp_dev_cfg_t
{
    ZXIC_UINT32 slot_id;                                        /* 槽位号 */
    ZXIC_UINT16 pcie_id[DPP_DEV_PF_NUM_MAX];                    /* 设备的pcie_id信息 */
    DPP_DEV_TYPE_E dev_type;                                    /* 设备类型: 0-SIM, 1-VCS, 2-CHIP(ASIC), 3-FPGA. */
    ZXIC_UINT32 chip_ver;                                       /* 设备类型: 0-DPP, 1-DPP+ */
    ZXIC_UINT32 access_type;                                    /* 访问类型: 0-PCIe, 1-RISCV. */
    ZXIC_UINT32 agent_flag;                                     /* 代理状态: 0-不使能, 1-使能. */
    ZXIC_UINT32 vport[DPP_DEV_PF_NUM_MAX];                      /* vport */
    ZXIC_UINT32 fw_bar_msg_num;                                 /*固件支持的bar消息个数*/
    ZXIC_ADDR_T pcie_addr[DPP_DEV_PF_NUM_MAX];                  /* PCIe映射地址 */
    ZXIC_ADDR_T riscv_addr;                                     /* RISCV映射地址 */
    ZXIC_ADDR_T dma_vir_addr;                                   /* DMA空间映射地址 */
    ZXIC_ADDR_T dma_phy_addr;                                   /* 芯片地址相对偏移 */
    ZXIC_ADDR_T agent_addr[DPP_DEV_PF_NUM_MAX];                 /* 代理映射地址 */
    ZXIC_UINT32 init_flags[MODULE_INIT_MAX];    
    DPP_DEV_WRITE_FUNC p_pcie_write_fun;                        /* PCIe硬件写回调函数 */
    DPP_DEV_READ_FUNC  p_pcie_read_fun;                         /* PCIe硬件读回调函数 */
    DPP_DEV_WRITE_FUNC p_riscv_write_fun;                       /* RISCV硬件写回调函数 */
    DPP_DEV_READ_FUNC  p_riscv_read_fun;                        /* RISCV硬件读回调函数 */
    ZXIC_MUTEX_T    reg_opr_mutex;                              /* 寄存器操作互斥量 */
    ZXIC_MUTEX_T    oam_mutex;                                  /* OAM硬件操作互斥锁  */
    ZXIC_MUTEX_T    etm_mutex;                                  /* ETM硬件操作互斥锁   */
    ZXIC_MUTEX_T    ddr_mutex;                                  /* DDR硬件操作互斥锁  */
    ZXIC_MUTEX_T    ind_mutex;                                  /* RAM间接操作互斥锁  */
    ZXIC_MUTEX_T    etcam_mutex;                                /* ETCAM硬件操作互斥锁 */
    ZXIC_MUTEX_T    car0_mutex;                                 /* CAR0硬件操作互斥锁 */
    ZXIC_MUTEX_T    alg_mutex;                                  /* alg硬件操作互斥锁*/
    ZXIC_MUTEX_T    nppu_mutex;                                 /* nppu硬件操作互斥锁*/
    ZXIC_MUTEX_T    smmu0_mutex;                                /* smmu0 硬件操作互斥锁*/
    ZXIC_MUTEX_T    smmu1_mutex;                                /* smmu1 硬件操作互斥锁*/
    ZXIC_MUTEX_T    etm_2nd_mutex;                              /* ETM 二层间接表 硬件操作互斥锁*/
    ZXIC_MUTEX_T    lpm_mutex;                                  /* lpm配置 操作互斥锁*/
    ZXIC_MUTEX_T    crm_temp_mutex;                             /* 温度获取 操作互斥锁*/
    ZXIC_MUTEX_T    sim_mutex;                                  /* 仿真器socket通信 操作互斥锁*/
    ZXIC_MUTEX_T    dtb_mutex;                                  /* DTB操作互斥锁*/
    ZXIC_MUTEX_T    hash_mutex[HASH_FUNC_ID_NUM];               /* hash插入 操作互斥锁*/
    ZXIC_MUTEX_T    dtb_queue_mutex[DPP_DTB_QUEUE_NUM_MAX];     /* DTB模块队列操作互斥锁 */
    ZXIC_MUTEX_T    dtb_multi_mutex;                            /* DTB 批量流操作互斥锁 */
    ZXIC_SPIN_LOCK_T dtb_multi_spin_lock;                       /* DTB 批量流操作自旋锁 */
    DPP_DEV_RES_T    dev_res;                                   /* 流表资源*/
} DPP_DEV_CFG_T;

typedef struct dpp_dev_mngr_t
{
    ZXIC_UINT32         device_num;  /* 设备数目 */
    ZXIC_UINT32         is_init;
    DPP_DEV_CFG_T  *p_dev_array[DPP_DEV_CHANNEL_MAX];
} DPP_DEV_MGR_T;

typedef struct S_DPP_DEV_REG_DATA_LOG
{
    FILE    *log_file_ptr[4];        /* 文件指针 */
    ZXIC_UINT32  wr_reg_data_switch[4];   /* 写文件开关 */
    ZXIC_UINT32  pre_module_num;          /* 上一次的模块编号 */
} S_DPP_DEV_WR_REG_DATA_LOG;

typedef enum _dpp_soft_reset_module_e
{
    MODULE_SOFT_RESET_DDR    = 0,
    MODULE_SOFT_RESET_LIF0   = 1,
    MODULE_SOFT_RESET_OAM    = 2,
    MODULE_SOFT_RESET_PLCR   = 3,
    MODULE_SOFT_RESET_PKTRX  = 4,
    MODULE_SOFT_RESET_PBU    = 5,
    MODULE_SOFT_RESET_ODMA   = 6,
    MODULE_SOFT_RESET_FTM    = 7,
    MODULE_SOFT_RESET_HASH   = 8,
    MODULE_SOFT_RESET_PPU    = 9,
    MODULE_SOFT_RESET_SERDES = 10,
    MODULE_SOFT_RESET_LPM    = 11,
    MODULE_SOFT_RESET_ACL    = 12,
    MODULE_SOFT_RESET_LIF1   = 13,
    MODULE_SOFT_RESET_ETM    = 14,
    MODULE_SOFT_RESET_SA     = 15,
    MODULE_SOFT_RESET_HEADER = 16,
    MODULE_SOFT_RESET_MAX
} DPP_SOFT_RESET_MODULE_E;

typedef struct _dpp_soft_reset_header_t
{
    ZXIC_UINT32 header_type;  //可作为存储标识
    ZXIC_UINT32 version;      //可作为版本号
    ZXIC_UINT32 rsv;
    ZXIC_UINT32 bitmap;       //每1bit代表一个模块
    ZXIC_UINT32 start[32];    //每个模块的偏移地址
    ZXIC_UINT32 length[32];   //每个模块占用的存储空间长度
} DPP_SOFT_RESET_HEADER_T;

/* inner api */
DPP_DEV_MGR_T* dpp_dev_mgr_get(ZXIC_VOID);
DPP_STATUS dpp_dev_pcie_default_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_dev_pcie_default_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_dev_riscv_default_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_dev_riscv_default_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_dev_write_channel(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_dev_read_channel(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32 *p_data);
ZXIC_UINT32 dpp_dev_chip_version_get(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_dev_init_flag_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 flag);
DPP_STATUS dpp_dev_init_flag_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 *p_flag);
DPP_STATUS dpp_dev_init_done_prt(ZXIC_UINT32 dev_id);
ZXIC_ADDR_T dpp_dev_get_pcie_addr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_dev_pcie_bdf_set(ZXIC_CHAR *bdf);
DPP_STATUS bdf(ZXIC_VOID);
DPP_STATUS dpp_dev_version_set(ZXIC_CHAR *ver);
DPP_STATUS version(ZXIC_VOID);


#if 0
DPP_STATUS dpp_dev_reg_data_write_switch(ZXIC_UINT32 dev_id, ZXIC_UINT32 wr_data_switch);
DPP_STATUS dpp_dev_reg_data_w2f(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32* p_data, ZXIC_UINT32 wr_mode);
#endif
DPP_STATUS dpp_pcie_cap_set(BOOL cap_en, ZXIC_UINT32 cap_start, ZXIC_UINT32 cap_end);
/***********************************************************/
/** 设置PCIE读写使能获取
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  xjw      @date  2018/04/24
************************************************************/
BOOL dpp_pcie_cap_en_get(ZXIC_VOID);

ZXIC_UINT32 dpp_cpu_softreset_lpm_rd(ZXIC_UINT8 *p_buff, ZXIC_UINT32 size);
ZXIC_UINT32 dpp_cpu_softreset_lpm_wr_sup(ZXIC_UINT8 *p_buff, ZXIC_UINT32 size);
ZXIC_UINT32 dpp_cpu_softreset_lpm_wr(ZXIC_UINT8 *p_buff, ZXIC_UINT32 size);
ZXIC_UINT32 dpp_cpu_softrest_name_no_get(ZXIC_CHAR *p_name);
ZXIC_UINT32 dpp_cpu_softreset_lpm_rd_sup(ZXIC_UINT8 *p_buff, ZXIC_UINT32 size);

ZXIC_UINT32 dpp_chip_version_check(ZXIC_UINT32 dev_id);

/** 模拟中断函数插入rb tree(soft buffer)的数据结构*/
typedef struct _soft_int_key 
{
    ZXIC_UINT32 addr;
}DPP_DEV_SOFT_INT_KEY_T;

/** 模拟中断函数插入rb tree(soft buffer)的配置上下文*/
typedef struct _soft_int_cfg 
{
    ZXIC_UINT32 is_open;
    ZXIC_UINT32 is_init;
    ZXIC_UINT32 *data_array;
    ZXIC_RB_CFG soft_int_rb;
}DPP_DEV_SOFT_INT_CFG_T;

/** maximum insert item of soft interrupt 4096*/
#define DPP_DEV_SOFT_INT_INSERT_MAX (0x1000)

/***********************************************************/
/** soft interrupt红黑树插入比较函数
* @param   p_new   
* @param   p_old   
* @param   key_size   
*
* @return  
* @remark  无
* @see     
* @author  yxh      @date  2018/01/09
************************************************************/
ZXIC_SINT32 dpp_dev_soft_int_rb_key_cmp(ZXIC_VOID *p_new, ZXIC_VOID *p_old, ZXIC_UINT32 key_size);

/***********************************************************/
/** soft interrupt软件模拟功能使能
* @param   dev_id   芯片ID
* @param   enable   使能标志
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see     
* @author  yxh      @date  2018/01/15
************************************************************/
DPP_STATUS dpp_dev_soft_int_enable_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);

/***********************************************************/
/** soft interrupt获取软件模拟功能是否使能
* @param   dev_id   芯片ID
* @param   enable   使能标志
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see     
* @author  yxh      @date  2018/01/15
************************************************************/
DPP_STATUS dpp_dev_soft_int_enable_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *penable);

/***********************************************************/
/** 对软件模拟关键信号告警的配置上下文初始化（初始化之前必须要先设置 enable，否则不会初始化）
* @param   device_id
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yxh      @date  2018/01/09
************************************************************/
DPP_STATUS dpp_dev_soft_int_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 对软件模拟关键信号告警的条目进行插入操作
* @param   device_id
* @param   addr           用来做key的地址信息
* @param   value          实际插入的数据
*
* @return  DPP_OK-成功，DPP_ERR-失败
*          DPP_SOFT_INT_CHECK_RB_TREE_FULL - 红黑树已满
* @remark  无
* @see
* @author  yxh      @date  2018/01/09
************************************************************/
DPP_STATUS dpp_dev_soft_int_insert(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 value);

/***********************************************************/
/** 对软件模拟关键信号告警的条目进行查询操作
* @param   device_id
* @param   addr           用来做key的地址信息
*
*
* @return  DPP_OK-搜索条目成功
*          DPP_SOFT_INT_CHECK_SRH_FAIL-搜索条目失败，表中没有此地址
* @remark  无
* @see
* @author  yxh      @date  2018/01/15
************************************************************/
DPP_STATUS dpp_dev_soft_int_search(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *pvalue);

/***********************************************************/
/** 对软件模拟关键信号告警的条目进行查询操作
* @param   device_id
* @param   addr           用来做key的地址信息
*
*
* @return  DPP_OK-搜索条目成功
           DPP_SOFT_INT_CHECK_SRH_FAIL-搜索条目失败，表中没有此地址
* @remark  无
* @see
* @author  yxh      @date  2018/01/15
************************************************************/
DPP_STATUS dpp_dev_soft_int_search_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr);

/***********************************************************/
/** 对软件模拟关键信号告警的条目进行删除操作
* @param   device_id
* @param   addr           用来做key的地址信息
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yxh      @date  2018/01/09
************************************************************/
DPP_STATUS dpp_dev_soft_int_del(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr);

/***********************************************************/
/** soft interrupt 相关打印信息
* @param   无
*
* @return  DPP_OK-成功，DPP_ERR-失败
* @remark  无
* @see
* @author  yxh      @date  2018/01/15
************************************************************/
DPP_STATUS dpp_dev_soft_int_prt(ZXIC_VOID);

DPP_STATUS dpp_dev_agent_status_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 agent_flag);
ZXIC_UINT32 dpp_dev_get_dev_agent_flag(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_dev_vport_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 vport);

DPP_STATUS dpp_dev_vport_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *vport);

DPP_STATUS dpp_dev_fw_bar_msg_num_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 bar_msg_num);

DPP_STATUS dpp_dev_fw_bar_msg_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *bar_msg_num);

DPP_STATUS dpp_dev_ep_no_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_ep_no);

DPP_STATUS dpp_dev_agent_addr_set(ZXIC_UINT32 dev_id, ZXIC_ADDR_T agent_addr);

DPP_STATUS dpp_dev_agent_addr_get(ZXIC_UINT32 dev_id,ZXIC_ADDR_T *agent_addr);

ZXIC_UINT32 dpp_dev_np_bar_offset_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 bar_offset);

ZXIC_UINT32 dpp_dev_np_bar_offset_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_bar_offset);

ZXIC_UINT32 dpp_dev_np_bar_pcie_id_set(ZXIC_UINT32 dev_id, ZXIC_UINT16 pcie_id);

ZXIC_UINT32 dpp_dev_np_bar_pcie_id_get(ZXIC_UINT32 dev_id, ZXIC_UINT16 *p_pcie_id);

ZXIC_ADDR_T dpp_dev_np_addr_calc(ZXIC_ADDR_T pcie_vir_baddr, ZXIC_UINT32 bar_offset);

ZXIC_ADDR_T dpp_dev_agent_addr_calc(ZXIC_UINT32 dev_id, ZXIC_ADDR_T pcie_vir_baddr);

DPP_STATUS dpp_dev_access_type_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *access_type);

DPP_STATUS dpp_dev_set_np_addr(ZXIC_UINT32 dev_id, ZXIC_ADDR_T np_addr);

DPP_STATUS dpp_dev_hash_opr_mutex_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 fun_id, ZXIC_MUTEX_T **p_mutex_out);

DPP_STATUS dpp_dev_mutex_create(ZXIC_UINT32 dev_id);

#ifdef __cplusplus
}
#endif

#endif



