/*********************************************************************
* Ȩ (C)2001, ͨѶɷ޹˾
*
* ļƣ
* ļʶ
* ժҪ:
* ˵:
* 
*
* ǰ汾
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT   : 100% 
*     ߣ ʯ
*   :  
* ڣ2011-7-20
* ޸: 2013-7-29
********************************************************************/
#ifndef DOWNLOADER_H
#define DOWNLOADER_H

#ifdef __cplusplus
extern "C" {
#endif

#include "dpp_ppu_api.h"

#define DPP_DOWN_FUNC_ENTER       (0)
#define DPP_DOWN_FUNC_EXIT          (1)

#define DPP_DOWN_MAX_CHANNELS     (DPP_DEV_CHANNEL_MAX)
#define DPP_DOWN_MAX_MEC_NUM      (DPP_DEV_PPU_CLS_MAX)
#define DPP_STRNLEN_MAXCOUNT            (0xffffffff) 

#define DPP_DOWN_MCODE_FEATURELIST  (0xEEEEEEEE)
#define DPP_DOWN_DUP_TBL_FLAG       (0xCCCCCCCC)
#define DPP_DOWN_FLOW_TCAM_FLAG     (0xDDDDDDDD)
#define DPP_DOWN_PORT_FLOW_PC       (0xBBBBBBBB)
#define DPP_DOWN_MCODE_VERSION_TIME (0xAAAAAAAA)

#define DPP_DOWN_TRAP_START_ADDR  (32704)
#define DPP_DOWN_WRITE_RDY_COUNT  (32)  /* WRITE_RDYĴȡô */

#define DPP_INSTRMEM_BASE         (0x0)
#define DPP_INSTRMEM_DEBUG_BASE   (0x7F98)    /*  */
#define DPP_INSTRMEM_SIZE         (32*1024)   /* xjw mod at 18.6.2 from 16k to 32k */

#define DPP_DOWNLOAD_SIM_START    (0xE)        /* ָʼ־ */
#define DPP_DOWNLOAD_SIM_END      (0xF)        /* ָؽ־ */

#define DPP_FLOW_TCAM_LENTH       (12)         /* flow tcam word32 12word32*/

#define DPP_MCODE_FEATURE_LIST_NUM (6U)

/* debig and trap1 inst */
#define DPP_HWD_DEBUG_INSTR_NUM   (64) /* ָռβ64Ӳ̻debugָ */

/* halt disc Inst*/
#define DPP_HALTDISC_INST_LO32    (0x00000041) 
#define DPP_HALTDISC_INST_HI32    (0x00000640) 

#define DPP_SIM_INST_BUFF         (68)  /* 4LWָϢͷ64LWָ */

#define INSTRMEM_OPR_RD           (0x7FFF)
#define INSTRMEM_OPR_WR           (0x8000)

/* dup table */
#define DUPTBL_IDX_BIT_OFF        (25)         /* bit25~30Ϊд */
#define DUPTBL_IDX_MASK           (0x3F)
#define DUPTBL_ITEMVLD_BIT_OFF    (24)
#define DUPTBL_ITEMVLD_MASK       (0x1)
#define DUPTBL_FLOWNUMVLD_BIT_OFF (23)
#define DUPTBL_FLOWNUMVLD_MASK    (0x1)
#define DUPTBL_STARTPC_BIT_OFF    (8)
#define STARTPC_MASK              (0x7FFF)
#define DUPTBL_FLOWNUM_BIT_OFF    (0)
#define DUPTBL_FLOWNUM_MASK       (0xFF)

/* port flow pc table */
#define PORT_FLOW_IDX_BIT_OFF        (24)
#define PORT_FLOW_FLOWNUM_BIT_OFF    (0)
#define PORT_FLOW_PC_BIT_OFF         (9)
#define PORT_FLOW_TBL_VLD_OFF        (8)

//L2Dַ L2DռС
#define L2D_BASE_ADDR (0x6200000000)
#define L2D_RAM_SIZE  (12*1024*1024)

/* flow tcam table */

typedef struct dpp_instr_by_row_t
{
    ZXIC_UINT32 instr_data[4][2];
}DPP_INSTR_BY_ROW_T;

/*  ṹ嶨 */
typedef struct download_info_t
{
    ZXIC_UINT32 dev_id;
    ZXIC_UINT32 instrmem_addr;
    ZXIC_UINT32 instrmem_size;
    ZXIC_UINT32 instrmem_offset;   /* ¼ָع̵λƫ */
    ZXIC_UINT32 table_buff[12];    /* flowtcamĿݣ12ZXIC_UINT32 */
    ZXIC_UINT32 table_offset;      /* ¼flowtcamĿÿZXIC_UINT32ƫ*/
    ZXIC_UINT32 is_load_mc;        /* Ƿع΢ */
    ZXIC_UINT32 instr_buff[4][2];  /* ָػ棬4ָΪһ· */

    DPP_VERSION_T version;
}DOWNLOAD_INFO_T;

typedef struct download_buff_t
{
    ZXIC_UINT32 instr_num;
    ZXIC_UINT32 instr_buff[DPP_SIM_INST_BUFF];
}DOWNLOAD_BUFF_T;

/* ӿ */
DOWNLOAD_INFO_T * dpp_download_get_info(ZXIC_UINT32 dev_id);
void dpp_download_dbg_flag_set(ZXIC_UINT32 dbg_flag);
ZXIC_UINT32 dpp_download_server_run(ZXIC_UINT8 *p_recv_msg, 
                             ZXIC_UINT8 *p_send_msg);
ZXIC_UINT32 dpp_download_dbg_trap0_Load(ZXIC_UINT32 dev_id,
                                   ZXIC_UINT32 pc_addr,
                                   ZXIC_UINT32 instr_low32,
                                   ZXIC_UINT32 instr_high32);
ZXIC_UINT32 dpp_download_dbg_trap0_unLoad(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 pc_addr,
                                      ZXIC_UINT32 instr_low32,
                                      ZXIC_UINT32 instr_high32);
ZXIC_UINT32 dpp_download_dbg_trap0_unLoad_byall(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_download_cluster_instrmem_replace(ZXIC_UINT32 dev_id, ZXIC_UINT32 mem_id, ZXIC_UINT32 pc_addr, ZXIC_UINT32 instr_hig32, ZXIC_UINT32 instr_low32);
DPP_STATUS dpp_download_chip_instrmem_replace(ZXIC_UINT32 dev_id, ZXIC_UINT32 pc_addr, ZXIC_UINT32 instr_hig32, ZXIC_UINT32 instr_low32);
ZXIC_UINT32 dpp_download_cluster_instrmem_clear(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 start_pc, ZXIC_UINT32 instr_hig32, ZXIC_UINT32 instr_low32);
DPP_STATUS dpp_download_chip_instrmem_clear(ZXIC_UINT32 dev_id, ZXIC_UINT32 start_pc, ZXIC_UINT32 instr_hig32, ZXIC_UINT32 instr_low32);
DPP_STATUS dpp_download_instr_wrt_to_hw_by_row(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 cluster_id,
                                           ZXIC_UINT32 pc_addr,
                                           DPP_INSTR_BY_ROW_T  *p_mc_code_array);
ZXIC_UINT32 dpp_download_instr_wrt_to_hw_all_instrmem_by_row(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 pc_addr,
                                           DPP_INSTR_BY_ROW_T *p_mc_code_array);
ZXIC_UINT32 dpp_download_instr_read_from_hw_by_row(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 cluster_id,
                                              ZXIC_UINT32 pc_addr,
                                              DPP_INSTR_BY_ROW_T  *p_mc_code_array);
/***********************************************************/
/** ؼת΢뵽ָռ䣬ڼeramǷ쳣
* @param   dev_id   
*
* @return  
* @remark  
* @see     
* @author  yxh      @date  2018/02/23
************************************************************/
DPP_STATUS dpp_download_mcode_for_eram_check(ZXIC_UINT32 dev_id);
ZXIC_UINT32 dpp_download_instrmem_init(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_download_mcode_for_tm_check(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_download_simple_send_loop(ZXIC_UINT32 loop_times, ZXIC_UINT32 dev_id, ZXIC_UINT32 mem_id, ZXIC_UINT32 pc_addr, ZXIC_UINT32 offset, ZXIC_UINT32 dest_phy_port);
ZXIC_UINT32 dpp_download_cluster_hdw_instrmem_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 mem_id);
ZXIC_UINT32 dpp_download_cluster_hdw_instrmem_fprt(ZXIC_UINT32 dev_id, ZXIC_UINT32 mem_id);
DPP_STATUS dpp_download_binfile(ZXIC_UINT32 dev_id, const ZXIC_CHAR *p_file_name);
DPP_STATUS dpp_download_binfile_from_l2d(ZXIC_UINT32 dev_id, ZXIC_ADDR_T l2dAddrOffset);
ZXIC_VOID dpp_mcode_num_set(ZXIC_UINT32 num);
ZXIC_VOID dpp_mcode_download_present_en_set(ZXIC_UINT32 en);

#ifdef __cplusplus
}
#endif


#endif



