/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_parsemsg.h
* ļʶ : 
* ժҪ : 
* ˵ : 
* ǰ汾 : 
*      : 
*  : 2014/01/27
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef _DPP_PARSEMSG_H_
#define _DPP_PARSEMSG_H_

#define   INVALID_ADDR                   (0xfffffffe)

#define   THREAD_STOP                    (0)
#define   THREAD_RUNNING                 (1)

#define   MAXLINE                        (1024 + 24 + 20)    /**<  @brief  1024B data length + 24 subhead length + msg head length*/

#define   LISTENQ                        (5)
#define   IDE_SOCK_PORT                  (35000)

#define DPP_MAX_CLUSTER_NUMBER           (6)
#define DPP_MAX_ME_NUMBER                (8)

#define DPP_SEND_VALID          (1)
#define DPP_SEND_INVALID        (0)

#define MSG_IDE2SDK   (1)
#define MSG_SDK2IDE   (0)

/* ءԡ */
#define DPP_MSG_TYPE_DOWNLOADER          (0)
#define DPP_MSG_TYPE_DEBUGGER            (1)
#define DPP_MSG_TYPE_SDT                 (2)
#define DPP_MSG_TYPE_STAT                (3)
#define DPP_MSG_TYPE_PACKETSEND          (4)
#define DPP_MSG_TYPE_CONFIG              (5)
#define DPP_MSG_TYPE_INVALID             (6)

/* ָ */
#define DPP_DOWNLOAD_MSG_DATAWRITE       (0)
#define DPP_DOWNLOAD_MSG_CANCEL          (1)

/* SDTϢ */
#define DPP_SDT_CREATE                   (0)
#define DPP_SDT_SEARCH                   (1)
#define DPP_SDT_DELETE                   (2)
#define DPP_SDT_TABLE_ADD                (3)
#define DPP_SDT_TABLE_SRH                (4)
#define DPP_SDT_TABLE_DEL                (5)

/* StatϢ */
#define DPP_STAT_ADDR_SET                (0)
#define DPP_STAT_ADDR_GET                (1)
#define DPP_STAT_ADDR_CLR                (2)
#define DPP_STAT_REG_READ                (3)
#define DPP_STAT_REG_WRITE               (4)
#define DPP_STAT_REG_CLR                 (5)

/* ָ */
#define DEBUG_MSG_START_DEBUGGER         (0)
#define DEBUG_MSG_STOP_DEBUGGER          (1)
#define DEBUG_MSG_STEP_INTO              (2)
#define DEBUG_MSG_STEP_OUT               (3)
#define DEBUG_MSG_STEP_OVER              (4)
#define DEBUG_MSG_GOTO_CURSOR            (5)
#define DEBUG_MSG_BREAKPOINT_SET         (6)
#define DEBUG_MSG_BREAKPOINT_CLEAR       (7)
#define DEBUG_MSG_BREAKPOINT_CLEAR_ALL   (8)
#define DEBUG_MSG_REG_READ               (9)
#define DEBUG_MSG_REG_WRITE              (10)
#define DEBUG_MSG_GET_PC_ADDR            (11)
#define DEBUG_MSG_PKT_SEND               (12)
#define DEBUG_MSG_MCODE_IS_LOAD          (13)
#define DEBUG_MSG_PKT_IS_EMPTY           (14)
#define DEBUG_MSG_CHIP_VERSION           (15)

/* Ϣ */
#define CONFIG_MSG_GLB_REG               (0)
#define CONFIG_MSG_PHY_PORT              (1)
#define CONFIG_MSG_ICU_TCAM              (2)

/*Msg Header Struct*/
typedef struct msg_head_t
{
    ZXIC_UINT32 channel_id;                /*NP,ֶNP*/
    ZXIC_UINT32 cpu_id;                    /*Cluster,ûͬһNPвͬME*/
    ZXIC_UINT32 me_id;                     /*ME*/
    ZXIC_UINT32 msg_type;                  /*Ϣ,ڲͬķ*/
    ZXIC_UINT32 msg_len;                   /*Ϣ峤ȣMsgbodyȣֽΪλ*/
    ZXIC_UINT8  msg_body[0];
}MSG_HEAD_T;

/*Msg body for Downloader*/
typedef struct msg_down_load_t
{
    ZXIC_UINT32 sub_msg_type;               /*Ϣ*/
    ZXIC_UINT32 file_size;                 /*ļܴСΪλ*/
    ZXIC_UINT32 is_byte_begin;              /*ļʼ*/
    ZXIC_UINT32 is_byte_end;                /*ļ*/
    ZXIC_UINT32 offset_addr;               /*дƫƵַֽΪλ*/
    ZXIC_UINT32 msg_len;                   /*Ϣ峤ȣucMsgbodyȣֽΪλ*/
    ZXIC_UINT8  msg_body [0];              /*д*/
}MSG_DOWN_LOAD_T;

/*Msg body for Debugger*/
typedef struct debug_msg_t
{
    ZXIC_UINT32 dbg_msg_type;                 /*Ϣ*/
    ZXIC_UINT32 dbg_msg_value;                /*Ϣֵ*/
    ZXIC_UINT32 dbg_msg_seq;                  /*Ϣ*/
    ZXIC_UINT32 dbg_msg_len;                  /*Ϣ峤, ֽΪλ*/
    ZXIC_UINT8  dbg_msg_body[0];              /*Ϣ*/
}DEBUG_MSG_T;

/* SubMsg body of Debuger for Get interrupt and PcAddr */
typedef struct intr_pc_info_t
{
    ZXIC_UINT32 cpu_intr_status;                                       /* 6bitЧbitmap 6cls*/
    ZXIC_UINT32 me_intr_status[DPP_MAX_CLUSTER_NUMBER];                /* 8bitЧbitmap 8me*/
    ZXIC_UINT32 bp_addr[DPP_MAX_CLUSTER_NUMBER][DPP_MAX_ME_NUMBER];   /* ϵPCֵ */
}INTR_PC_INFO_T;

/*Msg body for SDT*/
typedef struct sdt_msg_t
{
    ZXIC_UINT32 sub_msg_type;               /*Ϣ*/
    ZXIC_UINT32 table_id;                  /*SDT table_id*/
    ZXIC_UINT32 table_index;               /*SDT Table Index*/
    ZXIC_UINT32 msg_len;                   /*ϢܳȣֽΪλ*/
    ZXIC_UINT8   msg_body[0];               /*ϢӲֵͬ*/
}SDT_MSG_T;


#define DPP_MSG_HASH_KEY_MAX          (12)
typedef struct sdt_hash_msg_t
{
    ZXIC_UINT32 tbl_type;                       /*Hash*/
    ZXIC_UINT32 operate_type;                   /*Hash*/
    ZXIC_UINT32 hash_key[DPP_MSG_HASH_KEY_MAX]; /*Hash󳤶384bits*/
    ZXIC_UINT32 key_len;                        /*Hash keyȣֽΪλ*/
    ZXIC_UINT32 handle;                        /*ֵ*/
    ZXIC_UINT32 handle_len;                     /*ȣֽΪλ*/
}SDT_HASH_MSG_T;


#define DPP_MSG_TREE_IP_MAX           (4)
typedef struct sdt_tree_msg_t
{
    ZXIC_UINT32 opr_arg;                   /*Tree*/
    ZXIC_UINT32 ip_addr[DPP_MSG_TREE_IP_MAX]; /*IPַ,Ipv4һΣIPv6ĸ*/
    ZXIC_UINT32 vpn_id;                    /*VPN ID*/
    ZXIC_UINT32 ip_mask_len;                /*IP볤*/
    ZXIC_UINT32 handle;                   /**/
}SDT_TREE_MSG_T;

typedef struct stat_msg_t
{
    ZXIC_UINT32 sub_msg_type;               /*Ϣ*/
    ZXIC_UINT32 stat_addr;                 /*üַ*/
    ZXIC_UINT32 stat_index;                /*ȡ*/
    ZXIC_UINT32 stat_num;                  /*ȡ*/
    ZXIC_UINT32 msg_len;                   /*ϢȣֽΪλ*/
    ZXIC_UINT8   msg_body[0];               /*ϢӲֵͬ*/
}STAT_MSG_T;

/* Msg body for config */
typedef struct config_msg_t
{
    ZXIC_UINT32 cfg_msg_type;              /*Ϣ*/
    ZXIC_UINT32 cfg_msg_index;             /**/
    ZXIC_UINT32 cfg_msg_len;               /*Ϣ, ֽΪλ*/
    ZXIC_UINT8   cfg_msg_body[0];           /*Ϣ*/
}CONFIG_MSG_T;


/* Public Msg Header */
extern ZXIC_UINT32 dpp_msg_get_channel_id(MSG_HEAD_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_cpu_id(MSG_HEAD_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_me_id(MSG_HEAD_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_msg_type(MSG_HEAD_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_msg_len(MSG_HEAD_T * p_msg);
extern ZXIC_UINT8  *dpp_msg_get_msg_body(MSG_HEAD_T * p_msg);
extern ZXIC_UINT32 dpp_msg_set_channel_id(MSG_HEAD_T * p_msg,  ZXIC_UINT32 channel_id);
extern ZXIC_UINT32 dpp_msg_set_cpu_id(MSG_HEAD_T * p_msg,  ZXIC_UINT32 cpu_id);
extern ZXIC_UINT32 dpp_msg_set_me_id(MSG_HEAD_T * p_msg,  ZXIC_UINT32 me_id);
extern ZXIC_UINT32 dpp_msg_set_msg_type(MSG_HEAD_T * p_msg, ZXIC_UINT32 msg_type);
extern ZXIC_UINT32 dpp_msg_set_msg_len(MSG_HEAD_T * p_msg,  ZXIC_UINT32 msg_len);
extern void   dpp_msg_print_msg_down(ZXIC_UINT8 * p_msg);
extern void   dpp_msg_print_msg_dbg(ZXIC_UINT8 * p_msg, ZXIC_UINT32 msg_flag);


/* Debug SubMsg */
extern ZXIC_UINT32 dpp_msg_get_dbg_msg_type(DEBUG_MSG_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_dbg_msg_len(DEBUG_MSG_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_dbg_msg_value(DEBUG_MSG_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_dbg_msg_seq(DEBUG_MSG_T * p_msg);
extern ZXIC_UINT8*  dpp_msg_get_dbg_msg_body(DEBUG_MSG_T * p_msg);
extern ZXIC_UINT32 dpp_msg_set_dbg_msg_type(DEBUG_MSG_T * p_msg, ZXIC_UINT32 dbg_msg_type);
extern ZXIC_UINT32 dpp_msg_set_dbg_msg_len(DEBUG_MSG_T * p_msg, ZXIC_UINT32 dbg_msg_len);
extern ZXIC_UINT32 dpp_msg_set_dbg_msg_value(DEBUG_MSG_T * p_msg, ZXIC_UINT32 dbg_msg_value);
extern ZXIC_UINT32 dpp_msg_set_dbg_msg_seq(DEBUG_MSG_T * p_msg, ZXIC_UINT32 dbg_msg_seq);
extern ZXIC_UINT32 dpp_msg_set_dbg_msg_body(DEBUG_MSG_T * p_msg, ZXIC_UINT8* msg_body, ZXIC_UINT32 len);

/* Download SubMsg */
extern ZXIC_UINT32 dpp_msg_get_down_msg_type(MSG_DOWN_LOAD_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_down_msg_file_size(MSG_DOWN_LOAD_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_down_msg_begin_flag(MSG_DOWN_LOAD_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_down_msg_end_flag(MSG_DOWN_LOAD_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_down_msg_offset_addr(MSG_DOWN_LOAD_T * p_msg);
extern ZXIC_UINT32 dpp_msg_get_down_msg_len(MSG_DOWN_LOAD_T * p_msg);
extern ZXIC_UINT8*  dpp_msg_get_down_msg_body(MSG_DOWN_LOAD_T * p_msg);
extern ZXIC_UINT32 dpp_msg_set_down_msg_type(MSG_DOWN_LOAD_T * p_msg, ZXIC_UINT32 sub_msg_type);
extern ZXIC_UINT32 dpp_msg_set_down_msg_file_size(MSG_DOWN_LOAD_T * p_msg, ZXIC_UINT32 file_size);
extern ZXIC_UINT32 dpp_msg_set_down_msg_begin_flag(MSG_DOWN_LOAD_T * p_msg, ZXIC_UINT32 is_byte_begin);
extern ZXIC_UINT32 dpp_msg_set_down_msg_end_flag(MSG_DOWN_LOAD_T * p_msg, ZXIC_UINT32 is_byte_end);
extern ZXIC_UINT32 dpp_msg_set_down_msg_offset_addr(MSG_DOWN_LOAD_T * p_msg, ZXIC_UINT32 offset_addr);
extern ZXIC_UINT32 dpp_msg_set_down_msg_len(MSG_DOWN_LOAD_T * p_msg, ZXIC_UINT32 msg_len);
extern ZXIC_UINT32 dpp_msg_set_down_msg_body(MSG_DOWN_LOAD_T * p_msg, ZXIC_UINT8* p_msg_body, ZXIC_UINT32 len);

/* SDT SubMsg */
extern ZXIC_UINT32 dpp_msg_get_sdt_msg_type(SDT_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_get_sdt_msg_table_id(SDT_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_get_sdt_msg_table_index(SDT_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_get_sdt_msg_len(SDT_MSG_T* p_msg);
extern ZXIC_UINT8*  dpp_msg_get_sdt_msg_body(SDT_MSG_T * p_msg);
extern ZXIC_UINT32 dpp_msg_set_sdt_msg_type(SDT_MSG_T *p_msg, ZXIC_UINT32 sub_msg_type);
extern ZXIC_UINT32 dpp_msg_set_sdt_msg_table_id(SDT_MSG_T *p_msg, ZXIC_UINT32 table_id);
extern ZXIC_UINT32 dpp_msg_set_sdt_msg_table_index(SDT_MSG_T *p_msg, ZXIC_UINT32 table_index);
extern ZXIC_UINT32 dpp_msg_set_sdt_msg_len(SDT_MSG_T *p_msg, ZXIC_UINT32 msg_len);
extern ZXIC_UINT32 dpp_msg_set_sdt_msg_body(SDT_MSG_T * p_msg, ZXIC_UINT8* p_msg_body, ZXIC_UINT32 len);
extern ZXIC_VOID   dpp_msg_sdt_msg_print(ZXIC_UINT8 * p_msg);

/* Hash Table SubMsg */
extern ZXIC_UINT32 dpp_msg_get_hash_msg_tbl_type(SDT_HASH_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_get_hash_msg_operate_type(SDT_HASH_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_get_hash_msg_key(SDT_HASH_MSG_T* p_msg, void * p_hash_key);
extern ZXIC_UINT32 dpp_msg_get_hash_msg_key_len(SDT_HASH_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_get_hash_msg_handle(SDT_HASH_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_get_hash_msg_handle_len(SDT_HASH_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_set_hash_msg_tbl_type(SDT_HASH_MSG_T* p_msg, ZXIC_UINT32 tbl_type);
extern ZXIC_UINT32 dpp_msg_set_hash_msg_operate_type(SDT_HASH_MSG_T* p_msg, ZXIC_UINT32 operate_type);
extern ZXIC_UINT32 dpp_msg_set_hash_msg_key(SDT_HASH_MSG_T* p_msg, void * p_hash_key);
extern ZXIC_UINT32 dpp_msg_set_hash_msg_key_len(SDT_HASH_MSG_T* p_msg, ZXIC_UINT32 key_len);
extern ZXIC_UINT32 dpp_msg_set_hash_msg_handle(SDT_HASH_MSG_T* p_msg, ZXIC_UINT32 handle);
extern ZXIC_UINT32 dpp_msg_set_hash_msg_handle_len(SDT_HASH_MSG_T* p_msg, ZXIC_UINT32 handle_len);
extern ZXIC_VOID   dpp_msg_hash_msg_print(SDT_HASH_MSG_T* p_msg);

/* Tree Table SubMsg */
extern ZXIC_UINT32 dpp_msg_get_tree_opr_arg(SDT_TREE_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_get_tree_ip_addr(SDT_TREE_MSG_T* p_msg, void * p_ip_addr);
extern ZXIC_UINT32 dpp_msg_get_tree_vpn_id(SDT_TREE_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_get_tree_ip_mask_len(SDT_TREE_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_get_tree_handle(SDT_TREE_MSG_T* p_msg);
extern ZXIC_UINT32 dpp_msg_set_tree_opr_arg(SDT_TREE_MSG_T *p_msg, ZXIC_UINT32 opr_arg);
extern ZXIC_UINT32 dpp_msg_set_tree_ip_addr(SDT_TREE_MSG_T *p_msg, void * p_ip_addr);
extern ZXIC_UINT32 dpp_msg_set_tree_vpn_id(SDT_TREE_MSG_T *p_msg, ZXIC_UINT32 vpn_id);
extern ZXIC_UINT32 dpp_msg_set_tree_ip_mask_len(SDT_TREE_MSG_T *p_msg, ZXIC_UINT32 ip_mask_len);
extern ZXIC_UINT32 dpp_msg_set_tree_handle(SDT_TREE_MSG_T * p_msg, ZXIC_UINT32 handle);
extern ZXIC_VOID   dpp_msg_tree_msg_print(SDT_TREE_MSG_T * p_msg);

/* stat SubMsg */

/* config submsg */
void dpp_msg_config_msg_print(ZXIC_UINT8 * p_msg);
void dpp_msg_sdt_msg_print_file(ZXIC_UINT8 * p_msg);
void dpp_msg_config_msg_print_file(ZXIC_UINT8 * p_msg);

#endif 



