/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_pktrx_cfg.h
* 文件标识 :
* 内容摘要 :
* 其它说明 :
* 当前版本 :
* 作    者 : zzh
* 完成日期 : 2015/02/06
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* 修改记录1:
* 修改日期:
* 版 本 号:
* 修 改 人:
* 修改内容:
***************************************************************/

#ifndef _DPP_PKTRX_CFG_H_
#define _DPP_PKTRX_CFG_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "dpp_pktrx_api.h"
#include "dpp_reg.h"

#define MR_IND_CMD_WRT_FLAG              (0)    /** 写命令 */
#define MR_IND_CMD_RD_FLAG               (1)    /** 读命令 */

#define MR_IND_CMD0_PROTECT_WR_MODE      (0)    /** 保护写命令 */
#define MR_IND_CMD0_FORCE_WR_MODE        (1)    /** 强制写命令 */

#define MR_SHAP_MAX_TOKEN                (0x1f000)    /** 整形令牌桶最大深度 */

#define DPP_PHYPORT_NUM                  (119)     /**  物理端口号个数(0-118) */
#define OAM_TX_PORT                      (117)
#define OAM_TST_PORT                     (118)
#define ODMA_PORT                        (114)
#define TM_PORT                          (113)
#define DPP_PKTRX_ICU_TCAM_NUM           (512)    /** TCAM深度，两个tcam结构完全相同，看做一个，深度翻倍*/

#define PKTRX_IND_CMD_WRT_FLAG            (0)    /** 写命令 */
#define PKTRX_IND_CMD_RD_FLAG             (1)    /** 读命令 */

#define DPP_PKTRX_DELAY_TIME              (5)  /** 延时5毫秒 */

#define DPP_PKTRX_MAX_PKT_LEN             (16000)  /** 最大包长 */
#define DPP_PKTRX_MIN_PKT_LEN             (127)
#define DPP_MAX_PKT_DBG_NUM               (64)       /** 抓包的分片最大个数 */
#define DPP_PKTRX_CAP_FILTER_MODE_NUM     (4)       /** 抓包过滤模式的种类 */
#define DPP_PKTRX_CAP_FILTER_BIT_NUM      (1056+1024)     /** 抓包过滤能操作的bit位个数 */
#define DPP_PKTRX_CAP_FILTER_ADDR         (0xC8)     /** 抓包过滤能操作地址*/

#define ISU_IND_CMD_WRT_FLAG               (0)    /** 写命令 */
#define ISU_IND_CMD_RD_FLAG                (1)    /** 读命令 */

#define DPP_PKTRX_TCAM_NO_MAX              (1)    /** TCAM编号最大值 **/
#define DPP_PKTRX_CHANNEL_NO_MAX           (8)    /** CHANNEL最大值 **/

#define DPP_PKTRX_TCAM_USED_ITEMS_NUM      (188U) /* NCSI DEBUG PXE已经占用了前188条 */

#define DPP_PKTRX_TCAM_INDEX_GET(index)\
  (((index)>255)?((index)-256):((index)))

#define DPP_PKTRX_TCAM_MEMID_GET(index)\
 (((index) > 255)?(TCAM_MEM_ID_1):(TCAM_MEM_ID_0))

#define DPP_PKTRX_TCAM_RESULT_MEMID_GET(index)\
 (((index) > 255)?(TCAM_RESULT_MEM_ID_1):(TCAM_RESULT_MEM_ID_0))

#define DPP_PKTRX_TCAM_REGID_GET(index)\
 (((index) > 255)?(NPPU_PKTRX_CFG_TCAM_1_VLDr):(NPPU_PKTRX_CFG_TCAM_0_VLDr))

typedef struct dpp_pktrx_reg_field_t
{
    ZXIC_CHAR    *p_name;                       /* 字段名 */
    ZXIC_UINT32  reg_field_size;                /*  相应reg的域数目 */
    ZXIC_UINT16  least_pos;                     /* 比特起始位，以寄存器列表为准*/
    ZXIC_UINT16  len;                           /* 字段长度，以比特为单位 */
} DPP_PKTRX_REG_FIELD_T;


/*  struct define */

typedef enum dpp_pktrx_table_mem_id_e
{
    PHYPORT_TAB_0_MEM_ID = 0,      /** 物理端口属性表0 */
    PHYPORT_TAB_1_MEM_ID = 1,      /** 物理端口属性表1 */
    PHYPORT_TAB_2_MEM_ID = 2,      /** 物理端口属性表2 */
    TCAM_MEM_ID_0 = 3,        /** FLOWTCAM表0 */
    TCAM_MEM_ID_1 = 4,        /** FLOWTCAM表1 */
    TCAM_RESULT_MEM_ID_0 = 5, /** FLOWTCAM结果表0 */
    TCAM_RESULT_MEM_ID_1 = 6, /** FLOWTCAM结果表1 */
    PKT_CAPTURE_MEM_ID = 7,        /** 抓包 */
    MEM_ID_MUX_NUM = 8,            /** PKTRX模块使用的内部表的个数*/
} DPP_PKTRX_TBL_MEM_ID_E;

typedef enum dpp_isu_stat_mem_id_e
{

    ISU_FAKE_LEN_MEM_ID = 1,
    ISU_REAL_LEN_MEM_ID = 2,
    ISU_MEM_ID_MUX_NUM = 3,
} DPP_ISU_STAT_MEM_ID_E;

typedef enum dpp_pktrx_analogport_type
{

    ANALOG_PORT_SGMII0 = 0,  /** SGMII0端口 */
    ANALOG_PORT_SGMII1 = 1,    /** SGMII1端口 */
    ANALOG_PORT_OAM_TX = 2,   /** OAM TX端口 */
    ANALOG_PORT_OAM_TST = 3,   /** OAM TST端口 */
    ANALOG_PORT_TYPE_NUM = 4,
} DPP_PKTRX_ANALOGPORT_TYPE;


typedef enum dpp_pktrx_stat_base_addr_e
{

    PKTRX_STAT_ISCH_I_BASE_ADDR_0 = 0,    /** PKTRX_ISCH_I 0-9口计数基地址 */
    PKTRX_STAT_ISCH_I_BASE_ADDR_16 = 32,    /** PKTRX_ISCH_I 16-27口计数基地址 */
    PKTRX_STAT_ISCH_I_BASE_ADDR_114 = 200,    /** PKTRX_ISCH_I 114口计数基地址 */
    PKTRX_STAT_ISCH_I_BASE_ADDR_113 = 198,    /** PKTRX_ISCH_I 113口计数基地址 */
    PKTRX_STAT_ISCH_I_BASE_ADDR_117 = 206,    /** PKTRX_ISCH_I 117-118口计数基地址 */

    PKTRX_STAT_ISCH_O_BASE_ADDR_0 = 210,    /** PKTRX_ISCH_I 0-27口计数基地址 */
    PKTRX_STAT_ISCH_O_BASE_ADDR_114 = 410,    /** PKTRX_ISCH_O 114口计数基地址 */
    PKTRX_STAT_ISCH_O_BASE_ADDR_113 = 408,    /** PKTRX_ISCH_O 113口计数基地址 */
    PKTRX_STAT_ISCH_O_BASE_ADDR_117 = 416,    /** PKTRX_ISCH_O 117-118口计数基地址 */

    PKTRX_STAT_PARSER_BASE_ADDR_0 = 420, /** PKTRX_PARSER计数基地址 */
    PKTRX_STAT_PARSER_BASE_ADDR_114=  620, /** PKTRX_PARSER计数基地址 */
    PKTRX_STAT_PARSER_BASE_ADDR_113=  618, /** PKTRX_PARSER计数基地址 */
    PKTRX_STAT_PARSER_BASE_ADDR_117=  626, /** PKTRX_PARSER计数基地址 */

    PKTRX_STAT_CHAN_ISCH_I_SOP_BASE_ADDR = 630, /** PKTRX 分通道进入ISCH计数基地址 */
    PKTRX_STAT_CHAN_BASE_ADDR =  646, /** PKTRX 分通道计数基地址 */

    PKTRX_STAT_ISCH_SOP_ADDR =  742, /** PKTRX ISCH出口的SOP分片总数计数地址 */
    PKTRX_STAT_PFU_BASE_ADDR =  744, /** PKTRX PFU过滤计数基地址 */
    PKTRX_STAT_PARSER_SOP_ADDR =  757, /** PKTRX PARSER出口的SOP分片总数计数地址  */

    PKTRX_STAT_FC_CNT_ADDR =  759, /** PKTRX STAT流控计数基地址  */
    PKTRX_STAT_PFU_AGING_CNT_ADDR =  767, /** PKTRX 老化总计数基地址  */

} DPP_PKTRX_STAT_BASE_ADDR_E;

typedef enum dpp_isu_stat_base_addr_e
{
    ISU_STAT_LIF0_LEN_BASE_ADDR = 0,
    ISU_STAT_LIF1_LEN_BASE_ADDR = 0X180,
    ISU_STAT_ODMA_LEN_BASE_ADDR = 0X1C0,
    ISU_STAT_TDM_UC_LEN_BASE_ADDR = 0X1F0
} DPP_ISU_STAT_BASE_ADDR_E;

typedef enum dpp_isu_stat_pkt_type
{
    ISU_STAT_ODMA_LOOP = 0,
    ISU_STAT_SA_MC = 1,
    ISU_STAT_ETM = 2,
    ISU_STAT_SGMII0 = 3,
    ISU_STAT_SGMII1 = 4,
    ISU_STAT_OAM_BFD = 5,
    ISU_STAT_TDM = 6,
    ISU_STAT_OAM_TST = 7,
    ISU_STAT_LP_MC = 8,
    ISU_STAT_PKT_NUM = 9,
} DPP_ISU_STAT_PKT_TYPE;

typedef enum dpp_isu_stat_tdm_pkt_type
{
    ISU_STAT_TDM_UC = 0,
    ISU_STAT_TDM_MC = 1,
    ISU_STAT_ERR = 2,
    ISU_STAT_TDM_PKT_NUM = 3,
} DPP_ISU_STAT_TDM_PKT_TYPE;

/* 4'b0000:GPON */
/* 4'b0001:EPON */
/* 4'b0010:XGPON */
/* 4'b0011:XEPON */
/* 4'b0100:NGPON2 */
/* 4'b0101:Ethernet */
/* 4'b0110:PPP */
/* 4'b0111:HDLC */
/* 4'b1000:ATM_LLC */
/* 4'b1001:ATM_LLC_SNAP */
/* 4'b1010:ATM_VC */
/* 4'b1011:FR_NLPID */
/* 4'b1100:FR_NLPID_SNAP */
/* 4'b1101:FR_CISCO */
typedef enum dpp_phyportbl_port_type
{
    PORT_TYPE_GPON          = 0,
    PORT_TYPE_EPON          = 1,
    PORT_TYPE_XGPON         = 2,
    PORT_TYPE_XEPON         = 3,
    PORT_TYPE_NGPON2        = 4,
    PORT_TYPE_ETH           = 5,
    PORT_TYPE_PPP           = 6,
    PORT_TYPE_HDLC          = 7,
    PORT_TYPE_ATM_LLC       = 8,
    PORT_TYPE_ATM_LLC_SNAP  = 9,
    PORT_TYPE_ATM_VC        = 10,
    PORT_TYPE_FR_NLPID      = 11,
    PORT_TYPE_FR_NLPID_SNAP = 12,
    PORT_TYPE_FR_CISCO      = 13,

} DPP_PHYPORTTBL_PORT_TYPE;

/* 4'b0000:Network */
/* 4'b0001:Fabric */
/* 4'b0010:ODMA */
typedef enum dpp_phyportbl_decode_type
{
    DECODE_TYPE_NETWORK = 0,
    DECODE_TYPE_FABRIC  = 1,
    DECODE_TYPE_ODMA    = 2,
} DPP_PHYPORTTBL_DECODE_TYPE;

DPP_STATUS dpp_pktrx_ind_reg_mode_status_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 sub_module_ind_status_reg, ZXIC_UINT32 sleep_time);
DPP_STATUS dpp_pktrx_ind_cmd_reg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 mem_addr, ZXIC_UINT32 mem_id,  ZXIC_UINT32 wrt_rd_flag);
DPP_STATUS dpp_pktrx_ind_data_reg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 len, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pktrx_ind_data_reg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 len, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pktrx_ind_reg_mode_rd_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mem_addr, ZXIC_UINT32 mem_id);

DPP_STATUS dpp_pktrx_ind_wrt(ZXIC_UINT32 dev_id,
                             ZXIC_UINT32 mem_addr,
                             ZXIC_UINT32 mem_id,
                             ZXIC_UINT32 len,
                             ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pktrx_ind_rd(ZXIC_UINT32 dev_id,
                            ZXIC_UINT32 mem_addr,
                            ZXIC_UINT32 mem_id,
                            ZXIC_UINT32 len,
                            ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pktrx_init(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_pktrx_slot_no_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *slot_no);
DPP_STATUS dpp_pktrx_port_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 port_no, ZXIC_UINT32 *p_flag);
DPP_STATUS dpp_pktrx_l2offset_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 flag);
DPP_STATUS dpp_pktrx_l2offset_mode_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 *flag);
DPP_STATUS dpp_pktrx_analogport_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 analogport_type, ZXIC_UINT32 flag);
DPP_STATUS dpp_pktrx_analogport_en_get(ZXIC_UINT32 dev_id, DPP_PKTRX_ANALOGPORT_CHANGE_EN_T* p_analogport_en);
DPP_STATUS dpp_pktrx_port_tdm_flag_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 port_no, ZXIC_UINT32 *p_flag);
DPP_STATUS dpp_pktrx_port_fc_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 port_no, ZXIC_UINT32 fc_mode);
DPP_STATUS dpp_pktrx_port_fc_mode_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 port_no, ZXIC_UINT32 *p_fc_mode);
DPP_STATUS dpp_pktrx_max_len_get(ZXIC_UINT32 dev_id, DPP_PKTRX_PARSER_MAX_LEN_CFG_T* p_max_len_info);
DPP_STATUS dpp_pktrx_min_len_get(ZXIC_UINT32 dev_id, DPP_PKTRX_PARSER_MIN_LEN_CFG_T* p_min_len_info);
DPP_STATUS dpp_pktrx_ex_vlan_tpid_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 tpid);
DPP_STATUS dpp_pktrx_ex_vlan_tpid_get(ZXIC_UINT32 dev_id, DPP_PKTRX_EX_TPID_T* p_ex_tpid);
DPP_STATUS dpp_pktrx_in_vlan_tpid_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 tpid);
DPP_STATUS dpp_pktrx_in_vlan_tpid_get(ZXIC_UINT32 dev_id, DPP_PKTRX_IN_TPID_T* p_in_tpid);
DPP_STATUS dpp_pktrx_hdlc_type_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 hdlc_type);
DPP_STATUS dpp_pktrx_hdlc_type_get(ZXIC_UINT32 dev_id, DPP_PKTRX_HDU_HDLC_T* p_hdu_hdlc);
DPP_STATUS dpp_pktrx_udf_l3type_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 l3type);
DPP_STATUS dpp_pktrx_udf_l3type_get(ZXIC_UINT32 dev_id, DPP_PKTRX_UDF_L3TYPE_T* p_udf_l3type);
DPP_STATUS dpp_pktrx_udf_l4type_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 l4type);
DPP_STATUS dpp_pktrx_udf_l4type_get(ZXIC_UINT32 dev_id, DPP_PKTRX_UDF_L4TYPE_T* p_udf_l4type);
DPP_STATUS dpp_pktrx_sch_first_aging_set(ZXIC_UINT32 dev_id, DPP_PKTRX_ISCH_AGING_CFG_T* p_aging_info);
DPP_STATUS dpp_pktrx_sch_second_aging_set(ZXIC_UINT32 dev_id, DPP_PKTRX_ISCH_AGING_CFG_T* p_aging_info);
DPP_STATUS dpp_pktrx_sch_first_aging_get(ZXIC_UINT32 dev_id, DPP_PKTRX_ISCH_AGING_CFG_T* p_aging_info);
DPP_STATUS dpp_pktrx_sch_second_aging_get(ZXIC_UINT32 dev_id, DPP_PKTRX_ISCH_AGING_CFG_T* p_aging_info);
DPP_STATUS dpp_pktrx_sch_wrr_set(ZXIC_UINT32 dev_id, DPP_PKTRX_SCH_WRR_T* p_sch_wrr_info);
DPP_STATUS dpp_pktrx_sch_wrr_get(ZXIC_UINT32 dev_id, DPP_PKTRX_SCH_WRR_T* p_sch_wrr_info);
DPP_STATUS dpp_pktrx_phyport_table_init(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_pktrx_flowpc_table_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_PHYPORT_TABLE_1_T *p_phyport_info);
DPP_STATUS dpp_pktrx_tcam_cmd_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 tcam_no, DPP_NPPU_PKTRX_CFG_TCAM_0_CMD_T tcam_cmd);
DPP_STATUS dpp_pktrx_tcam_cmd_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 tcam_no, DPP_NPPU_PKTRX_CFG_TCAM_0_CMD_T *p_tcam_cmd);
DPP_STATUS dpp_pktrx_tcam_item_disable(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_pktrx_tcam_item_enable(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_pktrx_tcam_item_vld_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 *p_vld_flg);
DPP_STATUS dpp_pktrx_xytcam_x_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_TCAM_DT_TABLE_T *p_tcam_info);
DPP_STATUS dpp_pktrx_xytcam_y_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_TCAM_DT_TABLE_T *p_tcam_info);
DPP_STATUS dpp_pktrx_xytcam_key_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 xytcam_x[], ZXIC_UINT32 xytcam_y[]);
DPP_STATUS dpp_pktrx_tcam_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 flag);
DPP_STATUS dpp_pktrx_tcam_table_item_clear(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_pktrx_tcam_table_item_unload(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_pktrx_tcam_table_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_TCAM_DT_TABLE_T *p_tcam_info);
DPP_STATUS dpp_pktrx_tcam_table_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_TCAM_DT_TABLE_T *p_tcam_info);
DPP_STATUS dpp_pktrx_tcam_table_set_by_xydata(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_TCAM_XY_TABLE_T *p_tcam_info);
DPP_STATUS dpp_pktrx_tcam_table_get_to_xydata(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, DPP_PKTRX_TCAM_XY_TABLE_T *p_tcam_rd_info);
DPP_STATUS dpp_pktrx_int_status_get(ZXIC_UINT32 dev_id, DPP_PKTRX_INT_STATUS_T* p_pktrx_int_status);
DPP_STATUS dpp_pktrx_int_status_prt(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_pktrx_fc_rdy_get(ZXIC_UINT32 dev_id, PKTRX_SCH_FC_RDY_T* p_pktrx_sch_fc_rdy);
DPP_STATUS dpp_pktrx_pfc_rdy_get(ZXIC_UINT32 dev_id, PKTRX_SCH_PFC_RDY_T* p_pktrx_sch_pfc_rdy);
DPP_STATUS dpp_pktrx_mcode_glb_cfg_get(ZXIC_UINT32 dev_id, DPP_PKTRX_MCODE_GLB_CFG_T *p_mcode_glb_cfg);
DPP_STATUS dpp_pktrx_mcode_glb_cfg_get_0(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_mcode_glb_cfg_0);
DPP_STATUS dpp_pktrx_mcode_glb_cfg_get_1(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_mcode_glb_cfg_1);
DPP_STATUS dpp_pktrx_mcode_glb_cfg_get_2(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_mcode_glb_cfg_2);
DPP_STATUS dpp_pktrx_mcode_glb_cfg_get_3(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_mcode_glb_cfg_3);

DPP_STATUS dpp_pktrx_nppu_start_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 nppu_start);
DPP_STATUS dpp_pktrx_nppu_start_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_nppu_start);

DPP_STATUS dpp_isu_dwrr_cfg_set(ZXIC_UINT32 dev_id, DPP_ISU_DWRR_CFG_T* p_isu_dwrr_cfg);
DPP_STATUS dpp_isu_dwrr_cfg_get(ZXIC_UINT32 dev_id, DPP_ISU_DWRR_CFG_T* p_isu_dwrr_cfg);
DPP_STATUS dpp_isu_int_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_isu_saip_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 saip_en);
DPP_STATUS dpp_isu_saip_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_saip_en);
DPP_STATUS dpp_isu_crdt_set(ZXIC_UINT32 dev_id, DPP_ISU_CRDT_CFG_T* p_isu_crdt_cfg_info);
DPP_STATUS dpp_isu_crdt_get(ZXIC_UINT32 dev_id, DPP_ISU_CRDT_CFG_T* p_isu_crdt_cfg_info);
DPP_STATUS dpp_isu_ppu_fifo_fc_get(ZXIC_UINT32 dev_id, DPP_ISU_PPU_FIFO_T* p_isu_ppu_fifo_fc);

DPP_STATUS dpp_pktrx_stat_ind_cmd_reg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 mem_addr, ZXIC_UINT32 mem_id,  ZXIC_UINT32 wrt_rd_flag);
DPP_STATUS dpp_pktrx_stat_ind_data_reg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 data0);
DPP_STATUS dpp_pktrx_stat_ind_data_reg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_data);

DPP_STATUS dpp_pktrx_stat_ind_reg_mode_status_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 sub_module_ind_status_reg, ZXIC_UINT32 sleep_time);
DPP_STATUS dpp_pktrx_stat_ind_reg_mode_rd_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mem_addr, ZXIC_UINT32 mem_id);
DPP_STATUS dpp_pktrx_stat_isch_i_port_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32  port_no, ZXIC_UINT32* p_isch_i_sop_cnt, ZXIC_UINT32* p_isch_i_eop_cnt);
DPP_STATUS dpp_pktrx_stat_isch_o_port_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32  port_no, ZXIC_UINT32* p_isch_o_sop_cnt, ZXIC_UINT32* p_isch_o_eop_cnt);
DPP_STATUS dpp_pktrx_stat_isch_o_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_isch_o_sop_cnt, ZXIC_UINT32* p_isch_o_eop_cnt);
DPP_STATUS dpp_pktrx_stat_parser_port_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32  port_no, ZXIC_UINT32* p_parser_sop_cnt, ZXIC_UINT32* p_parser_eop_cnt);
DPP_STATUS dpp_pktrx_stat_parser_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_parser_sop_cnt, ZXIC_UINT32* p_parser_eop_cnt);
DPP_STATUS dpp_pktrx_stat_channel_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32  channel_id, DPP_PKTRX_STAT_CHANNEL_CNT_T *p_pktrx_stat_channel_cnt);
DPP_STATUS dpp_pktrx_stat_pfu_cnt_get(ZXIC_UINT32 dev_id, DPP_PKTRX_STAT_PFU_CNT_T *p_pktrx_stat_pfu_cnt);
DPP_STATUS dpp_pktrx_stat_fc_cnt_get(ZXIC_UINT32 dev_id, DPP_PKTRX_STAT_FC_CNT_T *p_pktrx_stat_fc_cnt);
DPP_STATUS dpp_pktrx_stat_all_cnt_clr(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_isu_stat_ind_cmd_reg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 mem_addr, ZXIC_UINT32 mem_id,  ZXIC_UINT32 wrt_rd_flag);
DPP_STATUS dpp_isu_stat_ind_data_reg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 data0);
DPP_STATUS dpp_isu_stat_ind_data_reg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_isu_stat_ind_reg_mode_status_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 sub_module_ind_status_reg, ZXIC_UINT32 sleep_time);
DPP_STATUS dpp_isu_stat_ind_reg_mode_rd_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mem_addr, ZXIC_UINT32 mem_id);
DPP_STATUS dpp_isu_dbg_cnt_get(ZXIC_UINT32 dev_id, DPP_ISU_DBG_CNT_T *p_isu_dbg_cnt);
DPP_STATUS dpp_isu_dbg_cnt_cfg_set(ZXIC_UINT32 dev_id, DPP_NPPU_ISU_STAT_DEBUG_CNT_CFG_T* p_isu_stat_cfg);
DPP_STATUS dpp_isu_dbg_cnt_cfg_get(ZXIC_UINT32 dev_id, DPP_NPPU_ISU_STAT_DEBUG_CNT_CFG_T* p_isu_stat_cfg);
DPP_STATUS dpp_isu_stat_lif0_len_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 port_id, ZXIC_UINT32 cos, ZXIC_UINT32 *p_fake_len, ZXIC_UINT32 *p_real_len);
DPP_STATUS dpp_isu_stat_lif1_len_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 port_id, ZXIC_UINT32 cos, ZXIC_UINT32 *p_fake_len, ZXIC_UINT32 *p_real_len);
DPP_STATUS dpp_isu_stat_other_tdm_len_get(ZXIC_UINT32 dev_id, DPP_ISU_STAT_TDM_PKT_TYPE index, ZXIC_UINT32 *p_fake_len, ZXIC_UINT32 *p_real_len);
DPP_STATUS dpp_isu_stat_other_len_get(ZXIC_UINT32 dev_id, DPP_ISU_STAT_PKT_TYPE index, ZXIC_UINT32 cos, ZXIC_UINT32 *p_fake_len, ZXIC_UINT32 *p_real_len);
DPP_STATUS dpp_isu_stat_cnt_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_isu_stat_all_cnt_clr(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_pktrx_pkt_capture_start(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_num);
DPP_STATUS dpp_pktrx_pkt_capture_stop(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_pktrx_pkt_capture_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode);
DPP_STATUS dpp_pktrx_pkt_capture_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_pkt_num);
DPP_STATUS dpp_pktrx_pkt_capture_dbg_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_pktrx_pkt_capture_cnt_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_pktrx_pkt_capture_cnt_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_pktrx_pkt_capture_print_one(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_no);
DPP_STATUS dpp_pktrx_pkt_capture_print(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 pkt_start_no,
                                       ZXIC_UINT32 pkt_end_no);
DPP_STATUS dpp_pktrx_pkt_capture_print_all(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_pktrx_pkt_capture_filter_set_bit(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 bit_no,
                                                ZXIC_UINT32 filter_mode);
DPP_STATUS dpp_pktrx_pkt_capture_filter_set_reg(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 index,
                                                ZXIC_UINT32 mode);
DPP_STATUS dpp_pktrx_pkt_capture_filter_set(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 bit_start_no,
                                            ZXIC_UINT32 bit_end_no,
                                            ZXIC_UINT32 filter_mode);
DPP_STATUS dpp_pktrx_pkt_capture_filter_sport_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 port);
DPP_STATUS dpp_pktrx_pkt_capture_filter_clr_bit(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 bit_no);
DPP_STATUS dpp_pktrx_pkt_capture_filter_clr(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 bit_start_no,
                                            ZXIC_UINT32 bit_end_no);
DPP_STATUS dpp_pktrx_pkt_capture_filter_clr_all(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_pktrx_glb_mgr_get(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 *p_flag,
                                 ZXIC_UINT32 *p_size,
                                 ZXIC_UINT8 **pp_data_buff);
DPP_STATUS dpp_pktrx_pkt_capture_filter_mask_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 start, ZXIC_UINT32 end, ZXIC_UINT32 mask, ZXIC_UINT32 data);
DPP_STATUS dpp_pktrx_pkt_capture_filter_pkt_mask_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 start, ZXIC_UINT32 end, ZXIC_UINT32 mask, ZXIC_UINT32 data);
DPP_STATUS dpp_isu_saip_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_saip_en);

#ifdef __cplusplus
}
#endif


#endif /* dpp_pktrx_cfg.h */


