/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_oam.h
* 文件标识 :
* 内容摘要 :
* 其它说明 :
* 当前版本 :
* 作    者 : XXX
* 完成日期 : 2014/04/16
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* 修改记录1:
* 修改日期:
* 版 本 号:
* 修 改 人:
* 修改内容:
***************************************************************/



#ifndef _DPP_OAM_H_
#define _DPP_OAM_H_

#ifdef __cplusplus
extern "C" {
#endif

#define OAM_MAX_PKT_TYPE          (16)
#define OAM_MIN_PKT_TYPE          (0)

#define OAM_MAX_GRADING_TYPE      (8)
#define OAM_MIN_GRADING_TYPE      (0)

#define OAM_MAX_PKT_GRADING_TYPE      (8)
#define OAM_MIN_PKT_GRADING_TYPE      (0)

#define OAM_INT0_REG_MAX_INDEX    (4)
#define OAM_INT0_REG_MIN_INDEX    (0)

#define OAM_INT0_BIT_MAX_INDEX    (128)
#define OAM_INT0_BIT_MIN_INDEX    (0)

#define OAM_INT1_REG_MAX_INDEX    (4)
#define OAM_INT1_REG_MIN_INDEX    (0)

#define OAM_INT1_BIT_MAX_INDEX    (128)
#define OAM_INT1_BIT_MIN_INDEX    (0)

#define OAM_INT_OPEN              (0)
#define OAM_INT_CLOSE             (1)

#define OAM_MEM_WR                (0x0)
#define OAM_MEM_RD                (0x1)

#define OAM_MAX_MA_TYPE          (2)
#define GET_GLOBAL_SEESSION(session_id,base_addr)  ((session_id) + (base_addr))
#define OAM_MIN(A, B) ((A) <= (B) ? (A) : (B))


/* TX发送表项BIT位定义 */
#define OAM_TX_TBL_W          (64)
#define OAM_TX_TBL_TX_EN_SB       (62)
#define OAM_TX_TBL_TX_EN_W        (1)

#define OAM_TX_TBL_TX_TYPE_SB     (61)
#define OAM_TX_TBL_TX_TYPE_W      (4)

#define OAM_TX_TBL_PKT_LEN_SB     (57)
#define OAM_TX_TBL_PKT_LEN_W      (14)

#define OAM_TX_TBL_BFD_SEQ_EN_SB     (43)
#define OAM_TX_TBL_BFD_SEQ_EN_W      (1)

#define OAM_TX_TBL_PARA_SB        (42)
#define OAM_TX_TBL_PARA_W         (7)

#define OAM_TX_TBL_TX_PERIOD_SB   (35)
#define OAM_TX_TBL_TX_PERIOD_W    (16)

#define OAM_TX_TBL_HD_ENA_FLAG_SB (19)
#define OAM_TX_TBL_HD_ENA_FLAG_W  (1)

#define OAM_TX_TBL_LAST_TX_TIME_SB (18)
#define OAM_TX_TBL_LAST_TX_TIME_W (19)


/* 检测表项BIT位定义 */
#define OAM_CHK_TBL_W          (64)
#define OAM_CHK_TBL_FST_SWCH_EN_SB  (55)
#define OAM_CHK_TBL_FST_SWCH_EN_W   (1)

#define OAM_CHK_TBL_CHK_EN_SB       (54)
#define OAM_CHK_TBL_CHK_EN_W        (1)

#define OAM_CHK_TBL_PKT_TYPE_SB     (53)
#define OAM_CHK_TBL_PKT_TYPE_W      (4)

#define OAM_CHK_TBL_DEL_EN_SB       (49)
#define OAM_CHK_TBL_DEL_EN_W        (1)

#define OAM_CHK_TBL_LM_EN_SB        (48)
#define OAM_CHK_TBL_LM_EN_W         (1)

#define OAM_CHK_TBL_GROUP_ID_SB     (47)
#define OAM_CHK_TBL_GROUP_ID_W      (12)

#define OAM_CHK_TBL_PERIOD_SB       (35)
#define OAM_CHK_TBL_PERIOD_W        (16)

#define OAM_CHK_TBL_FIST_CHK_FLAG_SB (19)
#define OAM_CHK_TBL_FIST_CHK_FLAG_W (1)

#define OAM_CHK_TBL_LAST_CHK_TIME_SB (18)
#define OAM_CHK_TBL_LAST_CHK_TIME_W (19)

/* MA检测表项BIT位定义 */
#define OAM_MA_CHK_TBL_W          (141)
#define OAM_MA_CHK_TBL_MA_FST_SWCH_EN_SB      (141)
#define OAM_MA_CHK_TBL_MA_FST_SWCH_EN_W        (1)

#define OAM_MA_CHK_TBL_MA_EN_SB      (140)
#define OAM_MA_CHK_TBL_MA_EN_W        (1)

#define OAM_MA_CHK_TBL_OAM_TYPE_SB   (139)
#define OAM_MA_CHK_TBL_OAM_TYPE_W     (1)

#define OAM_MA_ERR_LVL_DFT_EN_SB     (138)
#define OAM_MA_ERR_LVL_DFT_EN_W      (1)

#define OAM_MA_ERR_MEGID_DFT_EN_SB     (137)
#define OAM_MA_ERR_MEGID_DFT_EN_W      (1)

#define OAM_MA_ERR_MEPID_DFT_EN_SB     (136)
#define OAM_MA_ERR_MEPID_DFT_EN_W      (1)

#define OAM_MA_ERR_FRQ_DFT_EN_SB     (135)
#define OAM_MA_ERR_FRQ_DFT_EN_W      (1)

#define OAM_MA_CHK_TBL_AIS_EN_SB     (134)
#define OAM_MA_CHK_TBL_AIS_EN_W       (1)

#define OAM_MA_CHK_TBL_CSF_EN_SB     (133)
#define OAM_MA_CHK_TBL_CSF_EN_W       (1)

#define OAM_MA_ERR_LVL_DFT_TBL_SB     (132)
#define OAM_MA_ERR_LVL_DFT_TBL_W      (3)

#define OAM_MA_ERR_MEGID_DFT_TBL_SB     (129)
#define OAM_MA_ERR_MEGID_DFT_TBL_W      (3)

#define OAM_MA_ERR_MEPID_DFT_TBL_SB     (126)
#define OAM_MA_ERR_MEPID_DFT_TBL_W     (3)

#define OAM_MA_ERR_FRQ_DFT_TBL_SB     (123)
#define OAM_MA_ERR_FRQ_DFT_TBL_W     (3)

#define OAM_MA_CHK_TBL_AIS_SB       (120)
#define OAM_MA_CHK_TBL_AIS_W        (3)

#define OAM_MA_CHK_TBL_CSF_SB       (117)
#define OAM_MA_CHK_TBL_CSF_W        (3)

#define OAM_MA_CHK_TBL_DEL_FLAG_SB   (114)
#define OAM_MA_CHK_TBL_FLAG_W        (1)

#define OAM_MA_CHK_TBL_ERR_LVL_DFT_TS_SB   (113)
#define OAM_MA_CHK_TBL_ERR_LVL_DFT_TS_W    (19)

#define OAM_MA_CHK_TBL_ERR_MEGID_DFT_TS_SB   (94)
#define OAM_MA_CHK_TBL_ERR_MEGID_DFT_TS_W    (19)

#define OAM_MA_CHK_TBL_ERR_MEPID_DFT_TS_SB   (75)
#define OAM_MA_CHK_TBL_ERR_MEPID_DFT_TS_W    (19)

#define OAM_MA_CHK_TBL_ERR_FRQ_DFT_TS_SB   (56)
#define OAM_MA_CHK_TBL_ERR_FRQ_DFT_TS_W    (19)


#define OAM_MA_CHK_TBL_AIS_DEFECT_TS_SB   (37)
#define OAM_MA_CHK_AIS_DEFECT_TS_W        (19)

#define OAM_MA_CHK_TBL_CSF_DEFECT_TS_SB   (18)
#define OAM_MA_CHK_CSF_DEFECT_TS_W        (19)

/* 2544发送表项BIT位定义 */
#define OAM_2544_TBL_W                (64)
#define OAM_2544_TBL_RSV_SB           (47)
#define OAM_2544_TBL_RSV_W            (1)

#define OAM_2544_TBL_TX_EN_SB         (46)
#define OAM_2544_TBL_TX_EN_W          (1)

#define OAM_2544_TBL_TX_TIMES_SB      (45)
#define OAM_2544_TBL_TX_TIMES_W       (16)

#define OAM_2544_TBL_CURR_TIMES_SB    (29)
#define OAM_2544_TBL_CURR_TIMES_W     (16)

#define OAM_2544_TBL_SLICE_NUM_SB     (13)
#define OAM_2544_TBL_SLICE_NUM_W      (7)

#define OAM_2544_TBL_PKT_MTY_SB       (6)
#define OAM_2544_TBL_PKT_MTY_W        (7)


typedef struct dpp_oam_ma_cnt_t
{
    ZXIC_UINT32 oam_rcv_tpoam_ais_cnt;
    ZXIC_UINT32 oam_rcv_tpoam_csf_cnt;
    ZXIC_UINT32 oam_rcv_tpoam_level_defect_cnt;
    ZXIC_UINT32 oam_rcv_tpoam_megid_defect_cnt;
    ZXIC_UINT32 oam_rcv_tpoam_mepid_defect_cnt;
    ZXIC_UINT32 oam_rcv_tpoam_freq_defect_cnt;
    ZXIC_UINT32 oam_rcv_ethoam_ais_cnt;
    ZXIC_UINT32 oam_rcv_ethoam_level_defect_cnt;
    ZXIC_UINT32 oam_rcv_ethoam_megid_defect_cnt;
    ZXIC_UINT32 oam_rcv_ethoam_mepid_defect_cnt;
    ZXIC_UINT32 oam_rcv_ethoam_freq_defect_cnt;
} DPP_OAM_MA_CNT_T;

typedef struct dpp_oam_pkt_cnt_t
{
    ZXIC_UINT32 oam_to_pktrx_sop_cnt;
    ZXIC_UINT32 oam_to_pktrx_eop_cnt;
    ZXIC_UINT32 oam_rcv_odma_sop_cnt;
    ZXIC_UINT32 oam_rcv_odma_eop_cnt;
} DPP_OAM_PKT_CNT_T;


typedef struct dpp_oam_err_cnt_t
{
    ZXIC_UINT32 oam_rcv_session_unenable_cnt;
    ZXIC_UINT32 oam_rcv_rmep_pkt_illegal_cnt;
    ZXIC_UINT32 oam_rcv_ma_pkt_illegal_cnt;
} DPP_OAM_ERR_CNT_T;


typedef struct dpp_oam_stat_cnt_t
{
    ZXIC_UINT32 oam_to_stat1_txstat_req_cnt;
    ZXIC_UINT32 oam_rcv_stat1_chkstat_req_cnt;
    ZXIC_UINT32 oam_to_stat2_bfdseq_req_cnt;
    ZXIC_UINT32 oam_to_stat2_lm_req_cnt;
    ZXIC_UINT32 oam_rcv_stat2_rsp_cnt;
    ZXIC_UINT32 oam_to_stat2_bfdseq_wr_cnt;
    ZXIC_UINT32 oam_to_stat2_bfdtime_wr_cnt;
    ZXIC_UINT32 oam_to_stat2_lm_wr_cnt;
} DPP_OAM_STAT_CNT_T;


typedef struct dpp_oam_se_cnt_t
{
    ZXIC_UINT32 oam_to_se_req_cnt;
    ZXIC_UINT32 oam_rcv_se_rsp_cnt;
} DPP_OAM_SE_CNT_T;


typedef struct dpp_oam_stat_fc_cnt_t
{
    ZXIC_UINT32 oam_rcv_stat1_fc_cnt;
    ZXIC_UINT32 oam_rcv_stat2_fc_cnt;
} DPP_OAM_STAT_FC_CNT_T;


typedef struct dpp_oam_se_fc_cnt_t
{
    ZXIC_UINT32 oam_rcv_se_fc_cnt;
    ZXIC_UINT32 oam_to_se_fc_cnt;
} DPP_OAM_SE_FC_CNT_T;

typedef struct dpp_oam_rd_cnt_t
{
    ZXIC_UINT32 pkt_2544_rd_cnt;
    ZXIC_UINT32 pkt_fs_rd_cnt;
    ZXIC_UINT32 pkt_ma_fs_rd_cnt;
} DPP_OAM_RD_CNT_T;
/** 会话颗粒度定义 */
typedef enum oam_grading_type_e
{
    GRADING_TYPE_INVALID  = 0,            /**<  @brief 无效值 */
    GRADING_TYPE_1K       = 1,            /**<  @brief 1K */
    GRADING_TYPE_2K       = 2,            /**<  @brief 2K*/
    GRADING_TYPE_4K       = 3,            /**<  @brief 4K */
    GRADING_TYPE_8K       = 4,            /**<  @brief 8K */
    GRADING_TYPE_16K      = 5,            /**<  @brief 16K */
    GRADING_TYPE_32K      = 6,            /**<  @brief 32K*/
    GRADING_TYPE_64K      = 7,            /**<  @brief 64K */
    GRADING_TYPE_MAX,                     /**<  @brief 无效值 */
} OAM_GRADING_TYPE_E;
/** OAM INT 中断掩码*/
typedef struct oam_interrupt_mask_t
{
    ZXIC_UINT32 tpma_interrupt_mask;    /**<  @brief tpma中断掩码*/
    ZXIC_UINT32 ethma_interrupt_mask;   /**<  @brief ethma中断掩码*/
    ZXIC_UINT32 bfd_interrupt_mask;     /**<  @brief bfd中断掩码*/
    ZXIC_UINT32 ethoam_interrupt_mask;  /**<  @brief ethoam ccm中断掩码*/
    ZXIC_UINT32 tpbfd_interrupt_mask;   /**<  @brief tpbfd中断掩码*/
    ZXIC_UINT32 tpoam_interrupt_mask;   /**<  @brief tpoam ccm中断掩码*/
} OAM_INTERRUPT_MASK_T;

typedef enum oam_pkt_grading_type_e
{
    GRADING_TYPE_INVALIDT = 0,            /**<  @brief 无效值 */
    GRADING_TYPE_32T      = 1,            /**<  @brief 32T */
    GRADING_TYPE_16T      = 2,            /**<  @brief 16T*/
    GRADING_TYPE_8T       = 3,            /**<  @brief 8T */
    GRADING_TYPE_4T       = 4,            /**<  @brief 4T */
    GRADING_TYPE_2T       = 5,            /**<  @brief 2T */
    GRADING_TYPE_1T       = 6,            /**<  @brief 1T*/
    GRADING_TYPE_T        = 7,            /**<  @brief 1T */
    GRADING_TYPE_TMAX,                     /**<  @brief 无效值 */
} OAM_PKT_GRADING_TYPE_E;

/** MEM_ID */
typedef enum oam_mem_id_e
{
    OAM_MEM_ID_INT0       = 0,   /**<  @brief 中断0 ram*/
    OAM_MEM_ID_INT1       = 1,   /**<  @brief 中断1 ram*/
    OAM_MEM_ID_TST        = 2,   /**<  @brief tst ram*/
    OAM_MEM_ID_GROUPNUM   = 3,   /**<  @brief groupnum ram*/
    OAM_MEM_ID_TX_CFG     = 4,   /**<  @brief 发送参数表项 ram*/
    OAM_MEM_ID_CHK_CFG    = 5,   /**<  @brief 检测参数表项0 ram*/
    OAM_MEM_ID_MA_CHK_CFG = 6,   /**<  @brief 检测参数表项1 ram*/
    OAM_MEM_ID_PON_INT    = 7,   /**<  @brief PON保护中断 ram*/
    OAM_MEM_ID_PON_PKT_CFG = 8,  /**<  @brief PON保护报文 ram*/
    OAM_MEM_ID_2544_CFG   = 9,   /**<  @brief 2544发送表 ram*/
    OAM_MEM_ID_2544_PKT   = 10,   /**<  @brief 2544报文 ram*/
    OAM_MEM_ID_2544_CNT   = 11,   /**<  @brief 2544计数 ram*/
    OAM_MEM_ID_MAX,
} OAM_MEM_ID_E;

/** CCM发送时间间隔 */
typedef enum oam_interval_value_e
{
    INTERVAL_INVALID    = 0,            /**<  @brief 周期为无效值 */
    FIRST_INTERVAL      = 1,            /**<  @brief 周期为3.3ms */
    SECOND_INTERVAL     = 2,            /**<  @brief 周期为10ms */
    THREE_INTERVAL      = 3,            /**<  @brief 周期为100ms */
    FOUR_INTERVAL       = 4,            /**<  @brief 周期为1s */
    FIVE_INTERVAL       = 5,            /**<  @brief 周期为10s */
    SIX_INTERVAL        = 6,            /**<  @brief 周期为1MIN */
    SEVEN_INTERVAL      = 7,            /**<  @brief 周期为10MIN */
    OAM_INTERVAL_MAX,                       /**<  @brief 周期为无效值 */
} OAM_INTERVAL_VALUE_E;

/** 2544发包速率定义pps */
typedef enum oam_2544_speed_e
{
    OAM_2544_SPEED_INVALID  = 0,            /**<  @brief 无效值 */
    OAM_2544_SPEED_4M       = 4000000,      /**<  @brief 发包速率4MPPS */
    OAM_2544_SPEED_2M       = 2000000,      /**<  @brief 发包速率2MPPS */
    OAM_2544_SPEED_1M       = 1000000,      /**<  @brief 发包速率1MPPS */
    OAM_2544_SPEED_500K     = 500000,       /**<  @brief 发包速率500KPPS */
    OAM_2544_SPEED_200K     = 200000,       /**<  @brief 发包速率200KPPS */
    OAM_2544_SPEED_100K     = 100000,       /**<  @brief 发包速率100KPPS */
    OAM_2544_SPEED_50K      = 50000,        /**<  @brief 发包速率50KPPS*/
    OAM_2544_SPEED_20K      = 20000,        /**<  @brief 发包速率20KPPS */
    OAM_2544_SPEED_10K      = 10000,        /**<  @brief 发包速率10KPPS */
    OAM_2544_SPEED_5K       = 5000,         /**<  @brief 发包速率5KPPS */
    OAM_2544_SPEED_2K       = 2000,         /**<  @brief 发包速率2KPPS*/
    OAM_2544_SPEED_1K       = 1000,         /**<  @brief 发包速率1KPPS */
    OAM_2544_SPEED_500      = 500,          /**<  @brief 发包速率500PPS */
    OAM_2544_SPEED_200      = 200,          /**<  @brief 发包速率200PPS*/
    OAM_2544_SPEED_100      = 100,          /**<  @brief 发包速率100PPS */
    OAM_2544_SPEED_MAX,                     /**<  @brief 无效值 */
} OAM_2544_SPEED_E;

/** 2544轮询次数定义pps */
typedef enum oam_2544_rr_time_e
{
    OAM_2544_RR_TIME_INVALID  = 0,            /**<  @brief 无效值 */
    OAM_2544_RR_TIME_1        = 1,            /**<  @brief 轮询次数1次*/
    OAM_2544_RR_TIME_2        = 2,            /**<  @brief 轮询次数2次 */
    OAM_2544_RR_TIME_4        = 4,            /**<  @brief 轮询次数4次*/
    OAM_2544_RR_TIME_8        = 8,            /**<  @brief 轮询次数10次 */
    OAM_2544_RR_TIME_20       = 20,           /**<  @brief 轮询次数20次 */
    OAM_2544_RR_TIME_40       = 40,           /**<  @brief 轮询次数40次 */
    OAM_2544_RR_TIME_80       = 80,           /**<  @brief 轮询次数100次*/
    OAM_2544_RR_TIME_200      = 200,          /**<  @brief 轮询次数200次 */
    OAM_2544_RR_TIME_400      = 400,          /**<  @brief 轮询次数400次 */
    OAM_2544_RR_TIME_800      = 800,          /**<  @brief 轮询次数800次 */
    OAM_2544_RR_TIME_2K       = 2000,         /**<  @brief 轮询次数2K次 */
    OAM_2544_RR_TIME_4K       = 4000,         /**<  @brief 轮询次数4K次 */
    OAM_2544_RR_TIME_8K       = 8000,         /**<  @brief 轮询次数10K次 */
    OAM_2544_RR_TIME_20K      = 20000,        /**<  @brief 轮询次数20K次 */
    OAM_2544_RR_TIME_40K      = 40000,        /**<  @brief 轮询次数40K次 */
    OAM_2544_RR_TIME_MAX,                     /**<  @brief 无效值 */
} OAM_2544_RR_TIME_E;


/** 发送配置表项中，diag/RDI的修改方式 */
typedef enum oam_driving_type_e
{
    OAM_NO_DRIVING         = 0,    /**<  @brief  不修改DIAG/rdi的值 */
    OAM_SOFT_DRIVING       = 1,    /**<  @brief  软件下插,修改DIAG/RDI  */
    OAM_LOC_DRIVING        = 2,    /**<  @brief  LOC告警触发修改DIAG/RDI值 */
} OAM_DRIVING_TYPE_E;


/** BFD发送配置参数*/
typedef struct cfg_bfd_send_para_t
{
    ZXIC_UINT32   driving;   /**<  @brief 参见OAM_DRIVING_TYPE_E定义说明*/
    ZXIC_UINT32   diag_value;   /**<  @brief diag*/
    ZXIC_UINT32   pad;          /**<  @brief 保留位 */
} CFG_BFD_SEND_PARA_T;

/** ccm发送配置参数*/
typedef struct cfg_ccm_send_para_t
{
    ZXIC_UINT32   lm_en;         /**<  @brief LM使能位 */
    ZXIC_UINT32   driving;   /**<  @brief 参见OAM_DRIVING_TYPE_E定义说明*/
    ZXIC_UINT32   rdi_value;   /**<  @brief rdi数值:0或1*/
} CFG_CCM_SEND_PARA_T;


/** FFD、BDI、CCM、BFD发包配置参数结构*/
typedef struct oam_send_para_t
{
    ZXIC_UINT32  tx_en;          /**<  @brief 会话使能位 */
    ZXIC_UINT32  pkt_type;       /**<  @brief 检测报文子类型编码，最多支持16种 */
    ZXIC_UINT32  bfd_seq_en;     /**<  @brief bfd序列号检测功能开启 */
    ZXIC_UINT32  hd_ena_flag;    /**<  @brief 硬件使能标志 */
    ZXIC_UINT32  pkt_len;        /**<  @brief 报文长度, 最大支持1510*/
    ZXIC_UINT32  period;         /**<  @brief 发送间隔 */
    ZXIC_UINT32  last_tx_time;   /**<  @brief 上次发送时间 */
    union
    {
        CFG_BFD_SEND_PARA_T   bfd_para;  /**<  @brief 参见 CFG_BFD_SEND_PARA_T定义*/
        CFG_CCM_SEND_PARA_T   ccm_para;  /**<  @brief 参见 CFG_CCM_SEND_PARA_T定义 */
    } para_info;

} OAM_SEND_CFG_T;


/** CV/FFD、BDI、CCM接收报文检测配置参数结构*/
typedef struct oam_chk_cfg_t
{
    ZXIC_UINT32  pkt_type;      /**<  @brief 报文类型 */
    ZXIC_UINT32  chk_en;        /**<  @brief 会话使能位 */
    ZXIC_UINT32  del_flag;      /**<  @brief 预删除字段，硬件自动删掉检测表项和中断RAM*/
    ZXIC_UINT32  ccm_lm_en;     /**<  @brief lm使能 ，ccm报文使用，其他填0便可*/
    ZXIC_UINT32  fist_chk_flag; /**<  @brief 当前BFD是否为首包检测*/
    ZXIC_UINT32  fst_swch_en;   /**<  @brief 快切报文发送使能位 */
    ZXIC_UINT32  group_id;      /**<  @brief ccm报文使用,其他报文填0即可，即组会话号 */
    ZXIC_UINT32  time_out;      /**<  @brief 超时时长 */
    ZXIC_UINT32  last_chk_time; /**<  @brief 上次检测时间 */
} OAM_CHK_CFG_T;


/** MA的检测时间间隔，ccm和ais csf配置使用*/
typedef struct oam_ma_config_cfg_t
{
    ZXIC_UINT32  pkt_type;       /**<  @brief 报文类型 */
    ZXIC_UINT32  chk_en;         /**<  @brief 检测使能 */
    ZXIC_UINT32  chk_interval;   /**<  @brief MEP发送CCM/AIS/CSF报文的时间间隔，定义参见OAM_INTERVAL_VALUE_E*/
    ZXIC_UINT32  ma_fst_swch_en;  /**<  @brief MA快切使能 */
} OAM_MA_CONFIG_CFG_T;



/** MA的检测表项信息*/
typedef struct oam_ma_chk_cfg_t
{
    ZXIC_UINT32    ma_fst_swch_en;     /**<  @brief MA会话发送快切使能位 */
    ZXIC_UINT32    ma_chk_en;          /**<  @brief MA会话使能位 */
    ZXIC_UINT32    oam_type;           /**<  @brief 报文类型0:ethoam  1:tpoam */
    ZXIC_UINT32    err_lvl_en;         /**<  @brief CCM错误MEG等级报文检测使能*/
    ZXIC_UINT32    err_megid_en;       /**<  @brief CCM错误MEG_ID报文检测使能*/
    ZXIC_UINT32    err_mepid_en;       /**<  @brief CCM错误MEP_ID检测使能*/
    ZXIC_UINT32    err_frq_en;         /**<  @brief CCM错误发射频率检测使能*/
    ZXIC_UINT32    ais_en;             /**<  @brief ais检测使能*/
    ZXIC_UINT32    csf_en;             /**<  @brief csf检测使能*/
    ZXIC_UINT32    err_lvl_interval;   /**<  @brief LOW MDL_LEVEL或MAID缺陷检测周期，定义参见OAM_INTERVAL_VALUE_E*/
    ZXIC_UINT32    err_megid_interval; /**<  @brief CCM错误MEG_ID报文检测检测周期*/
    ZXIC_UINT32    err_mepid_interval; /**<  @brief CCM错误MEP_ID检测检测周期*/
    ZXIC_UINT32    err_frq_interval;   /**<  @brief MEPID或周期不相等缺陷检测周期，定义参见OAM_INTERVAL_VALUE_E*/
    ZXIC_UINT32    ais_interval;       /**<  @brief AIS检测周期，定义参见OAM_INTERVAL_VALUE_E*/
    ZXIC_UINT32    csf_interval;       /**<  @brief CSF检测周期，定义参见OAM_INTERVAL_VALUE_E*/
    ZXIC_UINT32    del_flag;           /**<  @brief 预删除字段，硬件自动删掉检测表项和中断RAM*/
    ZXIC_UINT32    err_lvl_ts;         /**<  @brief ERR Level上次检测时间*/
    ZXIC_UINT32    err_megid_ts;       /**<  @brief Megid缺陷上次检测时间*/
    ZXIC_UINT32    err_mepid_ts;       /**<  @brief Mepid缺陷上次检测时间*/
    ZXIC_UINT32    err_frq_ts;         /**<  @brief Interval不匹配缺陷上次检测时间*/
    ZXIC_UINT32    ais_defect_ts;      /**<  @brief AIS缺陷上次检测时间*/
    ZXIC_UINT32    csf_defect_ts;      /**<  @brief CSF缺陷上次检测时间*/
  
} OAM_MA_CHK_CFG_T;


/** OAM中断所有返回类型*/
typedef struct oam_int_type_t
{
    ZXIC_UINT8    tpma_int;      /**<  @brief MA TPOAM中断 */
    ZXIC_UINT8    ethma_int;     /**<  @brief MA ETHOAM中断 */
    ZXIC_UINT8    bfd_int;       /**<  @brief BFD中断 */
    ZXIC_UINT8    tpbfd_int;     /**<  @brief BFD中断 */
    ZXIC_UINT8    ethoam_int;    /**<  @brief ethoam ccm中断 */
    ZXIC_UINT8    tpoam_int;     /**<  @brief tpoam ccm中断 */
    ZXIC_UINT8    pad;           /**<  @brief 保留位 */
    ZXIC_UINT8    pad1;          /**<  @brief 保留位 */
} OAM_INT_TYPE_T;


/** lm计数定义*/
typedef struct oam_lm_cnt_t
{
    ZXIC_UINT32    lm_rxfci;    /**<  @brief rxfci */
    ZXIC_UINT32    lm_txfcf;    /**<  @brief txfcf */
    ZXIC_UINT32    lm_rxfcb;    /**<  @brief rxfcb*/
    ZXIC_UINT32    lm_txfcb;    /**<  @brief txfcb */
} OAM_LM_CNT_T;

/** bfd 最大最小时间间隔*/
typedef struct bfd_recv_interval_t
{
    ZXIC_UINT32    max_recv_interval;    /**<  @brief bfd报文最大接收间隔*/
    ZXIC_UINT32    min_recv_interval;    /**<  @brief bfd报文最小接收间隔*/
} BFD_RECV_INTERVAL_T;

/** bfd seqid存储信息*/
typedef struct bfd_debug_seqid_info_t
{
    ZXIC_UINT32    seqid_lost_cnt;    /**<  @brief seqid丢失计数值*/
    ZXIC_UINT32    last_recv_seqid;   /**<  @brief 上次接收到报文的seqid值*/
    ZXIC_UINT32    new_send_seqid;    /**<  @brief 本次发送报文的seqid值*/

} BFD_DEBUG_SEQID_INFO_T;


/** TST接收报文检测配置参数结构*/
typedef struct oam_tst_chk_cfg_t
{
    ZXIC_UINT32  chk_en;          /**<  @brief 会话使能位 */
    ZXIC_UINT32  session_id;      /**<  @brief ccm报文使用,其他报文填0即可，即组会话号 */
} OAM_TST_CHK_CFG_T;


/** TST发包配置参数结构*/
typedef struct oam_tst_tx_cfg_t
{
    ZXIC_UINT32  fast_tx_en;     /**<  @brief 快速发包模式使能位，精度:普通模式0.1ms 快速模式1.667ns */
    ZXIC_UINT32  tx_en;          /**<  @brief 会话使能位 */
    ZXIC_UINT32  pkt_len;        /**<  @brief 报文头长度, 最大支持127*/
    ZXIC_UINT32  period;         /**<  @brief 发送间隔 */
} OAM_TST_TX_CFG_T;

/** 2544发包配置参数结构*/
typedef struct oam_2544_tx_cfg_t
{
    ZXIC_UINT32  tx_en;            /**<  @brief 发包使能位*/
    ZXIC_UINT32  tx_speed;         /**<  @brief 发包速率*/
    ZXIC_UINT32  pkt_len;          /**<  @brief 报文长度, 最大支持*/
} OAM_2544_TX_CFG_T;

/** 背景流发包配置参数结构*/
typedef struct oam_backgroud_flow_tx_cfg_t
{
    ZXIC_UINT32  fast_tx_en;     /**<  @brief 快速发包模式使能位，精度:普通模式0.1ms 快速模式1.667ns */
    ZXIC_UINT32  tx_en;          /**<  @brief 会话使能位 */
    ZXIC_UINT32  period;         /**<  @brief 发送间隔 */
    ZXIC_UINT32  pktlen;         /**<  @brief 报文长度 */
} OAM_BACKGROUD_FLOW_TX_CFG_T;



/** 定时老化发包配置参数结构*/
typedef struct oam_aging_tx_cfg_t
{
    ZXIC_UINT32  tx_en;          /**<  @brief 会话使能位 */
    ZXIC_UINT32  send_period;    /**<  @brief 发送间隔 */
    ZXIC_UINT32  aging_freq;     /**<  @brief 老化周期 */
    ZXIC_UINT32  seqid_offset;   /**<  @brief 序列号偏移 */
    ZXIC_UINT32  pkt_len;        /**<  @brief 报文长度 */
} OAM_AGING_TX_CFG_T;


/** BFD中断位图返回值的定义*/
typedef struct oam_bfd_intr_cfg_t
{
    ZXIC_UINT8    diag_value;       /**<  @brief BFD diag的值*/
    ZXIC_UINT8    dloc_intr;        /**<  @brief LOC中断FLAG */
    ZXIC_UINT8    diag_intr;        /**<  @brief diag中断FLAG */
    ZXIC_UINT8    pad;
} OAM_BFD_INTR_CFG_T;


/** CCM中断位图返回值的定义*/
typedef struct oam_ccm_intr_cfg_t
{
    ZXIC_UINT8    current_loc_intr;       /**<  @brief 实时LOC告警状态 */
    ZXIC_UINT8    current_rdi_intr;       /**<  @brief 实时RDI告警状态 */
    ZXIC_UINT8    sticky_loc_intr;        /**<  @brief 锁存LOC告警状态 */
    ZXIC_UINT8    sticky_rdi_intr;        /**<  @brief 锁存RDI告警状态 */
} OAM_CCM_INTR_CFG_T;


/** MPLSOAM中断位图返回值的定义*/
typedef struct oam_mplsoam_intr_cfg_t
{
    ZXIC_UINT8    current_loc_intr;      /**<  @brief 实时LOC告警状态 */
    ZXIC_UINT8    sticky_loc_intr;       /**<  @brief 锁存LOC告警状态 */
    ZXIC_UINT8    pad[2];
} OAM_MPLSOAM_INTR_CFG_T;


/** MA中断位图返回值的定义*/
typedef struct oam_ma_intr_cfg_t
{
    ZXIC_UINT8    sticky_err_lvl_intr;         /**<  @brief 锁存错误混入告警状态 */
    ZXIC_UINT8    sticky_err_megid_intr;       /**<  @brief 锁存错误MEG ID 告警状态 */
    ZXIC_UINT8    sticky_err_mepid_intr;       /**<  @brief 锁存错误MEP ID告警状态 */
    ZXIC_UINT8    sticky_err_frq_intr;         /**<  @brief 锁存发送周期告警状态 */
    ZXIC_UINT8    sticky_ais_intr;             /**<  @brief 锁存AIS告警状态 */
    ZXIC_UINT8    sticky_csf_intr;             /**<  @brief 锁存CSF告警状态 */
    ZXIC_UINT8    current_err_lvl_intr;        /**<  @brief 实时错误混入告警状态 */
    ZXIC_UINT8    current_err_megid_intr;      /**<  @brief 实时错误MEG ID告警状态 */
    ZXIC_UINT8    current_err_mepid_intr;      /**<  @brief 实时错误MEP ID告警状态 */
    ZXIC_UINT8    current_err_frq_intr;        /**<  @brief 实时发送周期告警状态 */
    ZXIC_UINT8    current_ais_intr;            /**<  @brief 实时AIS告警状态 */
    ZXIC_UINT8    current_csf_intr;            /**<  @brief 实时CSF告警状态 */
} OAM_MA_INTR_CFG_T;


/** OAM INT0 中断清除类型*/
typedef struct oam_type_int_clr0_t
{
    ZXIC_UINT32 bfd_int_clr;           /**<  @brief bfd中断清除*/
    ZXIC_UINT32 tpbfd_int_clr;         /**<  @brief tpbfd中断清除*/
    ZXIC_UINT32 ethoam_int_clr;        /**<  @brief ethoam ccm中断清除*/
    ZXIC_UINT32 tpoam_int_clr;         /**<  @brief tpoam ccm中断清除*/
    ZXIC_UINT32 tpma_int_clr;          /**<  @brief  tpma中断清除*/
    ZXIC_UINT32 ethma_int_clr;         /**<  @brief  ethma中断清除*/
} OAM_TYPE_INT_CLR0_T;


/** OAM INT1 中断清除类型*/
typedef struct oam_type_int_clr1_t
{
    ZXIC_UINT32 fifo_int_clr;            /**<  @brief  fifo中断清除*/
    ZXIC_UINT32 pon_protect_int_clr;     /**<  @brief pon保护中断清除*/

} OAM_TYPE_INT_CLR1_T;

/** 发送，接收，ma，报文检测会话颗粒度配置*/
typedef struct oam_grading_type_t
{
    ZXIC_UINT32 tx_grading_type;         /**<  @brief 发送会话颗粒度*/
    ZXIC_UINT32 chk_grading_type;        /**<  @brief 接收会话颗粒度*/
    ZXIC_UINT32 ma_chk_grading_type;     /**<  @brief MA检测会话颗粒度*/
    ZXIC_UINT32 pkt_grading_type;        /**<  @brief 报文检测会话颗粒度*/

} OAM_GRADING_TYPE_T;


/** 发送，接收，ma等检测使能配置*/
typedef struct oam_global_en_t
{
    ZXIC_UINT32 tx_enable;             /**<  @brief 发送使能*/
    ZXIC_UINT32 chk_enable;            /**<  @brief 检测使能*/
    ZXIC_UINT32 ma_chk_enable;         /**<  @brief MA检测使能*/
    ZXIC_UINT32 tst_chk_enable;        /**<  @brief tst检测使能*/
    ZXIC_UINT32 bfd_debug_enable;      /**<  @brief BFD DEBUG功能使能*/
    ZXIC_UINT32 tx_2544_enable;        /**<  @brief 2544功能使能*/
} OAM_GLOBAL_EN_T;


DPP_STATUS dpp_oam_debug_2544_fs_cnt_rd(ZXIC_UINT32 dev_id, DPP_OAM_RD_CNT_T *p_rd_cnt);
DPP_STATUS dpp_oam_debug_pkt_cnt_rd(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_pktrx_cnt, ZXIC_UINT32 *p_odma_cnt);
DPP_STATUS dpp_oam_debug_fc_cnt_rd(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_pktrx_fc, ZXIC_UINT32 *p_odma_fc, ZXIC_UINT32 *p_pktrx_tst_fc);
DPP_STATUS dpp_oam_debug_detail_pkt_cnt_rd(ZXIC_UINT32 dev_id, DPP_OAM_PKT_CNT_T *p_pkt_cnt);
DPP_STATUS dpp_oam_debug_detail_ma_cnt_rd(ZXIC_UINT32 dev_id, DPP_OAM_MA_CNT_T *p_ma_cnt);
DPP_STATUS dpp_oam_debug_detail_err_cnt_rd(ZXIC_UINT32 dev_id, DPP_OAM_ERR_CNT_T *p_err_cnt);
DPP_STATUS dpp_oam_debug_detail_stat_cnt_rd(ZXIC_UINT32 dev_id, DPP_OAM_STAT_CNT_T *p_stat_cnt);
DPP_STATUS dpp_oam_debug_detail_se_cnt_rd(ZXIC_UINT32 dev_id, DPP_OAM_SE_CNT_T *p_se_cnt);
DPP_STATUS dpp_oam_debug_detail_stat_fc_cnt_rd(ZXIC_UINT32 dev_id, DPP_OAM_STAT_FC_CNT_T *p_stat_fc_cnt);
DPP_STATUS dpp_oam_debug_detail_se_fc_cnt_rd(ZXIC_UINT32 dev_id, DPP_OAM_SE_FC_CNT_T *p_se_fc_cnt);
DPP_STATUS dpp_oam_cnt_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_debug_detail_fifo_status_show(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_fifo_int_mask_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
DPP_STATUS dpp_oam_fifo_int_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 value);
ZXIC_VOID dpp_oam_debug_pktrx_pkt_show(ZXIC_UINT32 dev_id);
ZXIC_VOID dpp_oam_debug_odma_pkt_show(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_glb_size_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_size);
DPP_STATUS dpp_oam_glb_mgr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 size, ZXIC_UINT8 * p_data_buff);
DPP_STATUS dpp_oam_glb_mgr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_flag, ZXIC_UINT32 *p_size, ZXIC_UINT8 ** pp_data_buff);
void dpp_oam_fpga_pkt_print(ZXIC_UINT8 *pkt, ZXIC_UINT32 pkt_len);
DPP_STATUS dpp_oam_ethccm_first_chk_time_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 chk_th);
DPP_STATUS dpp_oam_stat_rec_en_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_frequency_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 enable);
DPP_STATUS dpp_oam_2544_pkt_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 pkt_len);
DPP_STATUS dpp_oam_int_handle(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_fst_swch_type_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_fst_swch_head_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_groupnum_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 session_id);
DPP_STATUS dpp_oam_2544_txinfo_ram_init_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_stat_fc_mask_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_global_chk_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_global_ma_chk_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_global_tx_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_global_tst_rx_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_global_2544_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_tx_session_grading_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_grad_type);
DPP_STATUS dpp_oam_chk_session_grading_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_grad_type);
DPP_STATUS dpp_oam_ma_chk_session_grading_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_grad_type);
DPP_STATUS dpp_oam_pkt_session_grading_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_grad_type);
DPP_STATUS dpp_oam_total_chk_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_num);
DPP_STATUS dpp_oam_total_ma_chk_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_num);
DPP_STATUS dpp_oam_total_tx_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_num);
DPP_STATUS dpp_oam_chk_base_haddr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 *p_base_addr);
DPP_STATUS dpp_oam_ma_chk_base_haddr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_type, ZXIC_UINT32 *p_base_addr);
DPP_STATUS dpp_oam_tx_base_haddr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 *p_base_addr);
DPP_STATUS dpp_oam_bfd_first_chk_time_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_chk_th);
DPP_STATUS dpp_oam_stat_addr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_stat_addr, ZXIC_UINT32 *p_stat_addr_flag);
DPP_STATUS dpp_oam_global_bfd_debug_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_en);
DPP_STATUS dpp_oam_odma_lm_eram_addr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_base_addr1, ZXIC_UINT32 *p_base_addr2, ZXIC_UINT32 *p_base_addr3);
DPP_STATUS dpp_oam_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 mask, ZXIC_UINT32 mem_id, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 mask, ZXIC_UINT32 mem_id, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_int_mask_set(ZXIC_UINT32 dev_id, OAM_INTERRUPT_MASK_T *p_mask);
DPP_STATUS dpp_oam_int_mask_get(ZXIC_UINT32 dev_id, OAM_INTERRUPT_MASK_T *p_mask);
DPP_STATUS dpp_oam_int_mask_flag_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 mask_flag);
DPP_STATUS dpp_oam_int_open(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_int_close(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_int_get(ZXIC_UINT32 dev_id, OAM_INT_TYPE_T *p_int_type);
DPP_STATUS dpp_oam_int0_clr_type_set(ZXIC_UINT32 dev_id, OAM_TYPE_INT_CLR0_T *p_int_clr);
DPP_STATUS dpp_oam_int0_clr_type_get(ZXIC_UINT32 dev_id, OAM_TYPE_INT_CLR0_T *p_int_clr);
DPP_STATUS dpp_oam_int0_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_int1_clr_type_set(ZXIC_UINT32 dev_id, OAM_TYPE_INT_CLR1_T *p_int_clr);
DPP_STATUS dpp_oam_int1_clr_type_get(ZXIC_UINT32 dev_id, OAM_TYPE_INT_CLR1_T *p_int_clr);
DPP_STATUS dpp_oam_int1_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_int_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_int0_region_status_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_int1_region_status_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_int0_regist_status_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_int0_regist_status_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_int0_persen_status_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_int1_persen_status_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_int0_bitmap_status_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 session_id, ZXIC_UINT32 mask, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_int0_bitmap_status_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 session_id, ZXIC_UINT32 mask);
DPP_STATUS dpp_oam_int1_bitmap_status_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 session_id, ZXIC_UINT32 mask, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_int1_bitmap_status_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 session_id, ZXIC_UINT32 mask);
DPP_STATUS dpp_oam_int0_ram_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_int1_ram_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_groupnum_ram_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_2544_txinfo_ram_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_index_ram0_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_index_ram1_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_pon_ram_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_lm_addr_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_lm_addr);
DPP_STATUS dpp_oam_stat_tx_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_stat_rec_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_stat_fc_mask_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_mask_flag);
DPP_STATUS  dpp_oam_stat_flow_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_oam_flow_control_en, ZXIC_UINT32 *p_oam_flow_lm_control_en);
ZXIC_UINT32 dpp_oam_tx_gsession_id_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id);
ZXIC_UINT32 dpp_oam_chk_gsession_id_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id);
ZXIC_UINT32 dpp_oam_ma_chk_gsession_id_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_type, ZXIC_UINT32 session_id);
DPP_STATUS dpp_oam_txcfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id, OAM_SEND_CFG_T  *p_tx_cfg);
DPP_STATUS dpp_oam_txcfg_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id);
DPP_STATUS dpp_oam_chkcfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id, OAM_CHK_CFG_T  *p_chk_cfg);
DPP_STATUS dpp_oam_chkcfg_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id, ZXIC_UINT32 hardware_del_flag);
DPP_STATUS dpp_oam_ma_chkcfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_type, ZXIC_UINT32 session_id, OAM_MA_CHK_CFG_T  *p_chk_cfg);
DPP_STATUS dpp_oam_ma_chkcfg_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_type, ZXIC_UINT32 session_id);
DPP_STATUS dpp_oam_ma_config_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id, OAM_MA_CHK_CFG_T  *p_config_cfg);
DPP_STATUS dpp_oam_ma_config_cfg_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id, ZXIC_UINT32 hardware_del_flag);
DPP_STATUS dpp_oam_rx_stat_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id, ZXIC_UINT64 *p_rx_num);
DPP_STATUS dpp_oam_rx_stat_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id);
DPP_STATUS dpp_oam_tx_stat_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id, ZXIC_UINT64 *p_tx_num);
DPP_STATUS dpp_oam_tx_stat_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id);
DPP_STATUS dpp_oam_lm_stat_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id, OAM_LM_CNT_T *p_lm_num);
DPP_STATUS dpp_oam_lm_stat_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 pkt_type, ZXIC_UINT32 session_id);
DPP_STATUS dpp_oam_bfd_debug_info_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 session_id, ZXIC_UINT32 pkt_type, BFD_RECV_INTERVAL_T *p_inter, BFD_DEBUG_SEQID_INFO_T *p_seq);
DPP_STATUS dpp_oam_bfd_debug_info_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 session_id, ZXIC_UINT32 pkt_type);
DPP_STATUS dpp_oam_tst_txcfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, OAM_TST_TX_CFG_T  *p_tx_cfg);
DPP_STATUS dpp_oam_tst_txcfg_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_int1_regist_status_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_tst_chkcfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, OAM_TST_CHK_CFG_T  *p_chk_cfg);
DPP_STATUS dpp_oam_tst_chkcfg_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_tst_pkt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT8 *p_data, ZXIC_UINT32 pkt_len);
DPP_STATUS dpp_oam_tst_lost_stat_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 *p_cnt);
DPP_STATUS dpp_oam_tst_pkt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT8 *p_data, ZXIC_UINT32 pkt_len);
DPP_STATUS dpp_oam_tst_lost_stat_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 *p_cnt);
DPP_STATUS dpp_oam_tst_lost_stat_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_tst_tx_stat_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 *p_cnt);
DPP_STATUS dpp_oam_tst_tx_stat_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_tst_rx_stat_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 *p_cnt);
DPP_STATUS dpp_oam_tst_rx_stat_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_fst_swch_type_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *oam_type);
DPP_STATUS dpp_oam_fst_swch_head_get(ZXIC_UINT32 dev_id, ZXIC_UINT64 *Dmac, ZXIC_UINT64 *Smac, ZXIC_UINT32 *E_type);
DPP_STATUS dpp_oam_2544_txcfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, OAM_2544_TX_CFG_T  *p_tx_cfg);
DPP_STATUS dpp_oam_2544_txcfg_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_2544_pkt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT8 *p_data, ZXIC_UINT32 pkt_len);
DPP_STATUS dpp_oam_2544_pkt_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_2544_tx_stat_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT64 *p_tx_num);
DPP_STATUS dpp_oam_2544_tx_stat_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_2544_pkt_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_2544_tx_stat_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT64 *p_tx_num);
DPP_STATUS dpp_oam_2544_tx_stat_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_2544_all_stat_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_pon_regist_status_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_pon_laser_on_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_pon_laser_off_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_pon_pkt_tx_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_pon_master_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 *p_value);
DPP_STATUS dpp_oam_pon_level_model_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 *p_value);
DPP_STATUS dpp_oam_pon_int_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 *p_enable);
DPP_STATUS dpp_oam_pon_ti_sd_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);
DPP_STATUS dpp_oam_pon_ti_los_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_value);
DPP_STATUS dpp_oam_pon_pkt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT8 *p_data, ZXIC_UINT32 pkt_len);
DPP_STATUS dpp_oam_pon_pkt_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_pon_bitmap_status_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_pon_bitmap_status_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id);
DPP_STATUS dpp_oam_ethccm_first_chk_time_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_chk_th);
DPP_STATUS dpp_oam_tpccm_first_chk_time_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_chk_th);
DPP_STATUS dpp_oam_backgroud_flow_txcfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, OAM_BACKGROUD_FLOW_TX_CFG_T  *p_tx_cfg);
DPP_STATUS dpp_oam_pon_pkt_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 pkt_len);
DPP_STATUS dpp_oam_ethccm_first_chk_time_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_chk_th);
DPP_STATUS dpp_oam_tpccm_first_chk_time_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_chk_th);
DPP_STATUS dpp_oam_backgroud_flow_txcfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, OAM_BACKGROUD_FLOW_TX_CFG_T  *p_tx_cfg);
DPP_STATUS dpp_oam_pon_pkt_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 pkt_len);
DPP_STATUS dpp_oam_stat_tx_en_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_tpbfd_first_chk_time_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_chk_th);
DPP_STATUS dpp_oam_stat_tx_en_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_oam_tpbfd_first_chk_time_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_chk_th);
DPP_STATUS dpp_oam_2544_txcfg_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_oam_2544_tx_stat_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);

/***********************************************************/
/** 配置pon某个口的中断位图，返回512bits的位图状态信息,具体位图比特定义参见OAM详设文档
* @param   dev_id   芯片ID号，支持多芯片
* @param   pon_id          pon口号(0~31)
* @param   p_data
*
* @return  DPP_OK-成功，DPP_ERR-失败  0表示成功 非0表示操作失败
* @remark  无
* @see
* @author  PJ      @date  2014/02/20
************************************************************/
DPP_STATUS dpp_oam_pon_bitmap_status_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pon_id, ZXIC_UINT32 *p_data);





#ifdef __cplusplus
}
#endif

#endif






