/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_ppu.h
* ļʶ :
* ժҪ :
* ˵ :
* ǰ汾 :
*      : 
*  : 2014/03/18
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* ޸ļ¼1:
* ޸:
*   :
*   :
* ޸:
***************************************************************/

#ifndef _DPP_PPU_H_
#define _DPP_PPU_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "dpp_module.h"
#include "dpp_ppu_api.h"
#include "dpp_ppu_reg.h"
#include "zxic_comm_thread.h"


#define PPU_CLS_ME_NUM         (8)
#define PPU_INSTR_MEM_NUM      (3)    /*ppuе΢ָռ 2cluster һָռ*/
#define PPU_INSTR_REG_NUM      (4)    /*ppuָռеݼĴĿ*/
#define PPU_INSTR_NUM_MAX      (32*1024)    /* xjw mod at 18.6.2 from 16k to 32k */
#define PPU_SDT_IDX_MIN        (0)
#define PPU_SDT_IDX_MAX        (255)
#define PPU_DUP_IDX_MIN        (0)
#define PPU_DUP_IDX_MAX        (63)
#define PPU_INSTR_COL_MAX      (4)
#define PPU_IPV4_IPID_START_VALUE_MAX (65535U)
#define PPU_IPV4_IPID_END_VALUE_MAX   (65535U)

/**  MEָж*/
#define PPU_ME0_INT_BT_START   (0)
#define PPU_ME0_INT_BT_LEN     (1)
#define PPU_ME1_INT_BT_START   (1)
#define PPU_ME1_INT_BT_LEN     (1)
#define PPU_ME2_INT_BT_START   (2)
#define PPU_ME2_INT_BT_LEN     (1)
#define PPU_ME3_INT_BT_START   (3)
#define PPU_ME3_INT_BT_LEN     (1)
#define PPU_ME4_INT_BT_START   (4)
#define PPU_ME4_INT_BT_LEN     (1)
#define PPU_ME5_INT_BT_START   (5)
#define PPU_ME5_INT_BT_LEN     (1)
#define PPU_ME6_INT_BT_START   (6)
#define PPU_ME6_INT_BT_LEN     (1)
#define PPU_ME7_INT_BT_START   (7)
#define PPU_ME7_INT_BT_LEN     (1)

//#define DPP_DEV_CHIP_NUM       (4)
#define DPP_FPGA_MAX_FLOWTCAM_NUM (32)
#define DPP_PPU_CLS_0_BIT_MAP  (1<<0) /*bit0 = 1 cluster0 */
#define DPP_PPU_CLS_1_BIT_MAP  (1<<1) /*bit1 = 1 cluster1 */
#define DPP_PPU_CLS_2_BIT_MAP  (1<<2) /*bit2 = 1 cluster2 */
#define DPP_PPU_CLS_3_BIT_MAP  (1<<3) /*bit3 = 1 cluster3 */
#define DPP_PPU_CLS_4_BIT_MAP  (1<<4) /*bit4 = 1 cluster4 */
#define DPP_PPU_CLS_5_BIT_MAP  (1<<5) /*bit5 = 1 cluster5 */

#define DPP_PPU_CLS_ALL_START  (0x3F) /*cluster*/


/*ýṹppuʼʱ ȫֲ޸*/
typedef struct dpp_ppu_cls_bitmap_t
{
    ZXIC_UINT32 cls_use[DPP_PPU_CLUSTER_NUM]; /*¼Ч cluster bitmap*/
    ZXIC_UINT32 instr_mem[PPU_INSTR_MEM_NUM]; /*¼Ч ָռ, ÿcluster һָռ*/
} DPP_PPU_CLS_BITMAP_T;

typedef struct dpp_instr_ind_data_t
{
    ZXIC_UINT32 instr_data[4][2];
} DPP_INSTR_IND_DATA_T;


/*PPUͳƼ */
typedef struct dpp_ppu_key_top_cnt_t
{
    ZXIC_UINT64 ppu_mf_cnt_rx;        /*PPUձͷܼ*/
    ZXIC_UINT64 ppu_mf_cnt_tx;        /*PPUͱͷܼ*/
    ZXIC_UINT32 ppu_mf_sop_cnt_rx;    /*PPUձͷSOPܼ*/
    ZXIC_UINT32 ppu_mf_eop_cnt_rx;    /*PPUձͷEOPܼ*/

    ZXIC_UINT32 ppu_ise_key_out_cnt;  /*PPUڲֱӱֵܼ*/
    ZXIC_UINT32 ppu_ise_rsp_in_cnt;   /*PPUղڲֱӱܼ */
    ZXIC_UINT32 ppu_ese_key_out_cnt;  /*PPUⲿֱӱֵܼ*/
    ZXIC_UINT32 ppu_ese_rsp_in_cnt;   /*PPUղⲿֱӱܼ */
    ZXIC_UINT64 ppu_cop_key_out_cnt;  /*PPUЭֵܼ*/
    ZXIC_UINT64 ppu_cop_rsp_in_cnt;   /*PPUЭܼ*/
    ZXIC_UINT32 ppu_stat_key_out_cnt; /*PPUͳֵܼ*/
    ZXIC_UINT32 ppu_stat_rsp_in_cnt;  /*PPUͳƽܼ*/

    ZXIC_UINT32 ppu_debug_refresh_cnt; /*PPUˢDebugĴܴ*/

    ZXIC_UINT64 ppu_se_mc_srh_vld_cnt;
    ZXIC_UINT64 se_ppu_mc_srh_vld_cnt;

    ZXIC_UINT64 mex_me_pkt_in_sop_cnt;
    ZXIC_UINT64 mex_me_pkt_in_eop_cnt;
    ZXIC_UINT64 mex_me_pkt_in_vld_cnt;
    ZXIC_UINT64 me_mex_pkt_out_sop_cnt;
    ZXIC_UINT64 me_mex_pkt_out_eop_cnt;
    ZXIC_UINT64 me_mex_pkt_out_vld_cnt;
    ZXIC_UINT64 me_mex_i_key_out_sop_cnt;
    ZXIC_UINT64 me_mex_i_key_out_eop_cnt;
    ZXIC_UINT64 me_mex_i_key_out_vld_cnt;
    ZXIC_UINT64 me_mex_e_key_out_sop_cnt;
    ZXIC_UINT64 me_mex_e_key_out_eop_cnt;
    ZXIC_UINT64 me_mex_e_key_out_vld_cnt;
    ZXIC_UINT64 me_mex_demux_ise_key_vld_cnt;
    ZXIC_UINT64 me_mex_demux_ese_key_vld_cnt;
    ZXIC_UINT64 me_mex_demux_sta_key_vld_cnt;
    ZXIC_UINT64 me_mex_demux_cop_key_vld_cnt;
    ZXIC_UINT64 mex_me_demux_ise_rsp_vld_cnt;
    ZXIC_UINT64 mex_me_demux_ese_rsp_vld_cnt;
    ZXIC_UINT64 mex_me_demux_sta_rsp_vld_cnt;
    ZXIC_UINT64 mex_me_demux_cop_rsp_vld_cnt;

} DPP_PPU_KEY_TOP_CNT_T;

typedef struct dpp_ppu_ppu_cop_thash_rsk_t
{
    ZXIC_UINT32 rsk_319_288;
    ZXIC_UINT32 rsk_287_256;
    ZXIC_UINT32 rsk_255_224;
    ZXIC_UINT32 rsk_223_192;
    ZXIC_UINT32 rsk_191_160;
    ZXIC_UINT32 rsk_159_128;
    ZXIC_UINT32 rsk_127_096;
    ZXIC_UINT32 rsk_095_064;
    ZXIC_UINT32 rsk_063_032;
    ZXIC_UINT32 rsk_031_000;

} DPP_PPU_PPU_COP_THASH_RSK_T;

typedef struct dpp_ppu_ppu_car_cnt_t
{
    ZXIC_UINT64 car_green_vld_cnt;
    ZXIC_UINT64 car_yellow_vld_cnt;
    ZXIC_UINT64 car_red_vld_cnt;
    ZXIC_UINT64 car_drop_vld_cnt;
} DPP_PPU_PPU_CAR_CNT_T;

typedef struct dpp_ppu_ppu_top_cnt_t
{
    ZXIC_UINT64 ppu_se_mc_srh_vld_cnt;
    ZXIC_UINT64 se_ppu_mc_srh_vld_cnt;
    ZXIC_UINT64 ppu_pbu_logic_pf_req_vld_cnt;
    ZXIC_UINT64 pbu_ppu_logic_pf_rsp_vld_cnt;
    ZXIC_UINT64 ppu_pbu_mcode_pf_req_vld_cnt;
    ZXIC_UINT64 pbu_ppu_mcode_pf_rsp_vld_cnt;
    ZXIC_UINT64 ppu_odma_mccnt_wr_vld_cnt;
    ZXIC_UINT64 odma_ppu_mccnt_rsp_vld_cnt;
    ZXIC_UINT64 pktrx_ppu_desc_vld_cnt;
    ZXIC_UINT64 ppu_pbu_ifb_req_vld_cnt;
    ZXIC_UINT64 pbu_ppu_ifb_rsp_vld_cnt;
    ZXIC_UINT64 ppu_pbu_wb_vld_cnt;
    ZXIC_UINT64 pbu_ppu_reorder_para_vld_cnt;
    ZXIC_UINT64 ppu_odma_para_vld_cnt;

    ZXIC_UINT64 isu_ppu_mc_vld_cnt; /*ISU鲥ͳƼ*/
    ZXIC_UINT64 isu_ppu_mc_loop_vld_cnt; /*ISUPPUظƱͳƼ*/
    ZXIC_UINT64 isu_ppu_uc_vld_cnt; /*ISUеͳƼ*/
    ZXIC_UINT64 isu_ppu_uc_bufnumis0_vld_cnt; /*ISUеbufnumõbufnumıͳƼ*/

    ZXIC_UINT64 demux_schedule_mc_vld_cnt; /*isu_ppu_demuxģ鲥ͳƼ*/
    ZXIC_UINT64 demux_schedule_mc_bufnumis0_vld_cnt; /*isu_ppu_demuxģ鲥bufnumõbufnumıͳƼ*/
    ZXIC_UINT64 demux_schedule_mc_srcportis0_vld_cnt; /*isu_ppu_demuxģ鲥srcportõsrcport0ıͳƼ*/
    ZXIC_UINT64 demux_schedule_mc_srcportis1_vld_cnt; /*isu_ppu_demuxģ鲥srcportõsrcport1ıͳƼ*/
    ZXIC_UINT64 demux_schedule_uc_vld_cnt; /*isu_ppu_demuxģеͳƼ*/
    ZXIC_UINT64 demux_schedule_uc_bufnumis0_vld_cnt; /*isu_ppu_demuxģеbufnumõbufnumıͳƼ*/
    ZXIC_UINT64 demux_schedule_uc_srcportis0_vld_cnt; /*isu_ppu_demuxģеsrcportõsrcport0ıͳƼ*/
    ZXIC_UINT64 demux_schedule_uc_srcportis1_vld_cnt; /*isu_ppu_demuxģеsrcportõsrcport1ıͳƼ*/

    ZXIC_UINT64 ppu_wb_vld_cnt; /*ppuдʱ,ͳƼ*/
    ZXIC_UINT64 ppu_wb_bufnumis0_vld_cnt; /*ppuд,bufnumõbufnumıͳƼ*/
    ZXIC_UINT64 ppu_wb_srcportis0_vld_cnt; /*ppuд,srcportõsrcport0ıͳƼ*/
    ZXIC_UINT64 ppu_wb_srcportis1_vld_cnt; /*ppuд,srcportõsrcport1ıͳƼ*/
    ZXIC_UINT64 ppu_wb_halt_send_type_vld_cnt; /*ppuд,halt_send_typeõhalt_send_typeıͳƼ*/
    ZXIC_UINT64 ppu_wb_mf_type_vld_cnt; /*ppuд,mf_typeõmf_typeıͳƼ*/
    ZXIC_UINT64 ppu_wb_halt_continue_end_vld_cnt; /*ppuд,halt_continue_endõhalt_continue_endıͳƼ*/
    ZXIC_UINT64 ppu_wb_dup_flag_vld_cnt; /*ppuд,dup_flagõdup_flagıͳƼ*/
    ZXIC_UINT64 ppu_wb_last_flag_vld_cnt; /*ppuд,last_flagõlast_flagıͳƼ*/
    ZXIC_UINT64 ppu_wb_dis_flag_vld_cnt; /*ppuд,dis_flagõdis_flagıͳƼ*/

    ZXIC_UINT64 pbu_ppu_reorder_halt_send_type_vld_cnt; /*pbuصı,halt_send_typeõhalt_send_typeıͳƼ*/
    ZXIC_UINT64 pbu_ppu_reorder_mf_type_vld_cnt; /*pbuصı,mf_typeõmf_typeıͳƼ*/
    ZXIC_UINT64 pbu_ppu_reorder_halt_continue_end_vld_cnt; /*pbuصı,halt_continue_endõhalt_continue_endıͳƼ*/

    ZXIC_UINT64 ppu_pktrx_mc_ptr_vld_cnt;

} DPP_PPU_PPU_TOP_CNT_T;



typedef struct dpp_ppu_me_cnt_t
{
    ZXIC_UINT64 mex_me_pkt_in_sop_cnt;
    ZXIC_UINT64 mex_me_pkt_in_eop_cnt;
    ZXIC_UINT64 mex_me_pkt_in_vld_cnt;
    ZXIC_UINT64 me_mex_pkt_out_sop_cnt;
    ZXIC_UINT64 me_mex_pkt_out_eop_cnt;
    ZXIC_UINT64 me_mex_pkt_out_vld_cnt;
    ZXIC_UINT64 me_mex_i_key_out_sop_cnt;
    ZXIC_UINT64 me_mex_i_key_out_eop_cnt;
    ZXIC_UINT64 me_mex_i_key_out_vld_cnt;
    ZXIC_UINT64 me_mex_e_key_out_sop_cnt;
    ZXIC_UINT64 me_mex_e_key_out_eop_cnt;
    ZXIC_UINT64 me_mex_e_key_out_vld_cnt;
    ZXIC_UINT64 me_mex_demux_ise_key_vld_cnt;
    ZXIC_UINT64 me_mex_demux_ese_key_vld_cnt;
    ZXIC_UINT64 me_mex_demux_sta_key_vld_cnt;
    ZXIC_UINT64 me_mex_demux_cop_key_vld_cnt;
    ZXIC_UINT64 mex_me_demux_ise_rsp_vld_cnt;
    ZXIC_UINT64 mex_me_demux_ese_rsp_vld_cnt;
    ZXIC_UINT64 mex_me_demux_sta_rsp_vld_cnt;
    ZXIC_UINT64 mex_me_demux_cop_rsp_vld_cnt;
} DPP_PPU_ME_CNT_T;

typedef struct dpp_ppu_cls_fc_cnt_t
{
    ZXIC_UINT32 ise_cluster_key_fc_cnt;
    ZXIC_UINT32 ese_cluster_key_fc_cnt;
    ZXIC_UINT32 cluster_ise_rsp_fc_cnt;
    ZXIC_UINT32 cluster_ese_rsp_fc_cnt;
    ZXIC_UINT32 stat_cluster_cmd_fc_cnt;
    ZXIC_UINT32 cluster_stat_rsp_fc_cnt;
} DPP_PPU_CLS_FC_CNT_T;

typedef struct dpp_ppu_cls_cnt_t
{
    ZXIC_UINT64 cls_mf_cnt_rx;      /*clusterձͷܼ*/
    ZXIC_UINT64 cls_mf_cnt_tx;      /*clusterͱͷܼ*/

    ZXIC_UINT32 ise_key_out_cnt;    /*clusterڲֱӱֵܼ*/
    ZXIC_UINT32 ise_rsp_in_cnt;     /*clusterղڲֱӱܼ */
    ZXIC_UINT32 ese_key_out_cnt;    /*clusterⲿֱӱֵܼ*/
    ZXIC_UINT32 ese_rsp_in_cnt;     /*clusterղⲿֱӱܼ */
    ZXIC_UINT64 cop_key_out_cnt;    /*clusterЭֵܼ*/
    ZXIC_UINT64 cop_rsp_in_cnt;     /*clusterЭܼ*/
    ZXIC_UINT32 stat_key_out_cnt;   /*clusterͳֵܼ*/
    ZXIC_UINT32 stat_rsp_in_cnt;    /*clusterͳƽܼ*/

    ZXIC_UINT32 mex_debug_key_refresh_cnt; /*clusterˢDebugĴ*/
} DPP_PPU_CLS_CNT_T;


typedef struct dpp_ppu_ppu_fc_cnt_t
{
    ZXIC_UINT64 se_ppu_mc_srh_fc_cnt;
    ZXIC_UINT64 pbu_ppu_logic_pf_fc_cnt;
    ZXIC_UINT64 pbu_ppu_ifb_rd_fc_cnt;
    ZXIC_UINT64 odma_ppu_para_fc_cnt;
    ZXIC_UINT64 ppu_pktrx_uc_fc_cnt;
    ZXIC_UINT64 ppu_se_mc_srh_fc_cnt;
    ZXIC_UINT64 ppu_pbu_logic_rsp_fc_cnt;
    ZXIC_UINT64 pbu_ppu_wb_fc_cnt;
    ZXIC_UINT64 odma_ppu_mccnt_wr_fc_cnt;
    ZXIC_UINT64 ppu_pktrx_mc_fc_cnt;

    ZXIC_UINT32 ise_cls_key_fc_cnt;  /*SE iseֵؼ*/
    ZXIC_UINT32 cls_ise_rsp_fc_cnt;  /*PPUiseؼ*/
    ZXIC_UINT32 ese_cls_key_fc_cnt;  /*SE eseֵؼ*/
    ZXIC_UINT32 cls_ese_rsp_fc_cnt;  /*PPUeseؼ*/
    ZXIC_UINT32 stat_cls_cmd_fc_cnt; /*STATPPUؼ*/
    ZXIC_UINT32 cls_stat_rsp_fc_cnt; /*PPUSTATؼ*/
} DPP_PPU_PPU_FC_CNT_T;

/* ÿmeexcp  */
typedef struct dpp_ppu_me_code_excp_cnt_t
{
    ZXIC_UINT64 exception_code0_vld_cnt;   /*group0 exception code0õļ*/
    ZXIC_UINT64 exception_code1_vld_cnt;   /*group0 exception code1õļ*/
    ZXIC_UINT64 exception_code2_vld_cnt;   /*group0 exception code2õļ*/
    ZXIC_UINT64 exception_code3_vld_cnt;   /*group0 exception code3õļ*/
    ZXIC_UINT64 exception_code4_vld_cnt;   /*group0 exception code4õļ*/
    ZXIC_UINT64 exception_code5_vld_cnt;   /*group0 exception code5õļ*/
} DPP_PPU_ME_CODE_EXCP_CNT_T;



/*ȡcluster ȫֵ*/
ZXIC_UINT32 dpp_ppu_cls_use_set(ZXIC_UINT32 dev_id,
                           ZXIC_UINT32 cluster_id,
                           ZXIC_UINT32 flag);
ZXIC_UINT32 dpp_ppu_cls_use_get(ZXIC_UINT32 dev_id,
                           ZXIC_UINT32 cluster_id);

ZXIC_UINT32 dpp_ppu_instr_mem_set(ZXIC_UINT32 dev_id,
                             ZXIC_UINT32 mem_id,
                             ZXIC_UINT32 flag);
ZXIC_UINT32 dpp_ppu_instr_mem_get(ZXIC_UINT32 dev_id,
                             ZXIC_UINT32 mem_id);
ZXIC_UINT32 dpp_ppu_parse_cls_bitmap(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 bitmap);
DPP_STATUS dpp_ppu_isu_fwft_mf_fifo_prog_full_assert_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 fifo);
DPP_STATUS dpp_ppu_isu_fwft_mf_fifo_prog_full_assert_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* fifo);
DPP_STATUS dpp_ppu_isu_fwft_mf_fifo_prog_full_negate_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 fifo);
DPP_STATUS dpp_ppu_isu_fwft_mf_fifo_prog_full_negate_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* fifo);

/* api */
DPP_STATUS dpp_ppu_instr_ind_reg_write(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 cluster_id,
                                       ZXIC_UINT32 instr_addr,
                                       DPP_INSTR_IND_DATA_T *p_instr_data);

DPP_STATUS dpp_ppu_instr_ind_reg_all_instrmem_write(ZXIC_UINT32 dev_id,
                                                    ZXIC_UINT32 instr_addr,
                                                    DPP_INSTR_IND_DATA_T *p_instr_data);


DPP_STATUS dpp_ppu_instr_ind_reg_read(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 cluster_id,
                                      ZXIC_UINT32 instr_addr,
                                      DPP_INSTR_IND_DATA_T *p_instr_data);

DPP_STATUS dpp_ppu_dup_tbl_write(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 index,
                                 ZXIC_UINT32 item_vld,
                                 ZXIC_UINT32 flownum_vld,
                                 ZXIC_UINT32 start_pc,
                                 ZXIC_UINT32 flow_num);

DPP_STATUS dpp_ppu_dup_tbl_read(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 index,
                                ZXIC_UINT32 *p_item_vld,
                                ZXIC_UINT32 *p_flownum_vld,
                                ZXIC_UINT32 *p_flow_num,
                                ZXIC_UINT32 *p_start_pc);

DPP_STATUS dpp_ppu_ipv4_ipid_start_value_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *startValue);

DPP_STATUS dpp_ppu_ipv4_ipid_start_value_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 startValue);

DPP_STATUS dpp_ppu_ipv4_ipid_end_value_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *endValue);

DPP_STATUS dpp_ppu_ipv4_ipid_end_value_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 endValue);

DPP_STATUS dpp_ppu_instr_mem_rdy_get(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 cluster_id,
                                     ZXIC_UINT32 *p_rdy);

DPP_STATUS dpp_ppu_debug_en_set(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 enable);

DPP_STATUS dpp_ppu_interrupt_en_set(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 interrupt_en);

DPP_STATUS dpp_ppu_host_interrupt_get(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 *p_interrupt);

DPP_STATUS dpp_ppu_current_bp_addr_get(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 cluster_id,
                                       ZXIC_UINT32 me_id,
                                       ZXIC_UINT32 *p_bp_addr);

DPP_STATUS dpp_ppu_bp_real_instr_set(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 cluster_id,
                                     ZXIC_UINT32 instr_low32,
                                     ZXIC_UINT32 instr_hig32);

DPP_STATUS dpp_ppu_me_step_set(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 cluster_id,
                               ZXIC_UINT32 step_val);

DPP_STATUS dpp_ppu_me_continue_set(ZXIC_UINT32 dev_id,
                                   ZXIC_UINT32 cluster_id,
                                   ZXIC_UINT32 continue_val);

DPP_STATUS dpp_ppu_me_refresh_set(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 cluster_id,
                                  ZXIC_UINT32 refresh_val);

DPP_STATUS dpp_ppu_debug_data_complete_set(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 data_complete);

DPP_STATUS dpp_ppu_debug_data_complete_get(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 *p_data_complete);

DPP_STATUS dpp_ppu_cls_me_int_sta_get(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 cluster_id,
                                      ZXIC_UINT32 *p_interrupt);

DPP_STATUS dpp_ppu_debug_valid_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_valid);
DPP_STATUS dpp_ppu_debug_send_pkt_set(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_ppu_cluster_clk_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_clock_en);
DPP_STATUS dpp_ppu_empty_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_empty);
DPP_STATUS dpp_ppu_dup_freeptr_fifo_aempty_assert_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 assert_value);
DPP_STATUS dpp_ppu_mex_cnt_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 overflow_mode, ZXIC_UINT32 rd_mode);
DPP_STATUS dpp_ppu_instr_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id);
DPP_STATUS dpp_ppu_all_instrmem_init(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_ppu_cnt_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 overflow_mode, ZXIC_UINT32 rd_mode);
DPP_STATUS dpp_ppu_cls_stat_wb_excp_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_CHAR *p_exc_str0, ZXIC_CHAR *p_exc_str1, ZXIC_CHAR *p_exc_str2, ZXIC_CHAR *p_exc_str3, ZXIC_CHAR *p_exc_str4,  ZXIC_CHAR *p_exc_str5);
DPP_STATUS dpp_ppu_stat_wb_excp_cnt_prt(ZXIC_UINT32 dev_id);
/* debug api */
DPP_STATUS dpp_ppu_debug_sdt_tbl_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 cls_id, ZXIC_UINT32 tbl_id, ZXIC_UINT32 dat_hi32, ZXIC_UINT32 dat_lw32);

DPP_STATUS dpp_ppu_cls_cls_stat_wb_excp_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, DPP_PPU_ME_CODE_EXCP_CNT_T *p_cls_excp_cnt);
DPP_STATUS dpp_ppu_cls_ppu_stat_wb_excp_cnt_get(ZXIC_UINT32 dev_id, DPP_PPU_ME_CODE_EXCP_CNT_T *p_ppu_excp_cnt);
DPP_STATUS dpp_ppu_cls_top_cnt_get(ZXIC_UINT32 dev_id, DPP_PPU_KEY_TOP_CNT_T *p_ppu_top_cnt);
DPP_STATUS dpp_ppu_ppu_top_cnt_get(ZXIC_UINT32 dev_id, DPP_PPU_PPU_TOP_CNT_T *p_ppu_top_cnt);
DPP_STATUS dpp_ppu_ppu_car_cnt_get(ZXIC_UINT32 dev_id, DPP_PPU_PPU_CAR_CNT_T *p_ppu_car_cnt);
DPP_STATUS dpp_ppu_cnt_clr(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_ppu_ppu_top_fc_cnt_get(ZXIC_UINT32 dev_id, DPP_PPU_PPU_FC_CNT_T *p_ppu_fc_cnt);
DPP_STATUS dpp_ppu_me_drr_excp_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 me_id, ZXIC_UINT32 *p_except);
DPP_STATUS dpp_ppu_cls_sub_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, DPP_PPU_CLS_CNT_T *p_cls_cnt);
DPP_STATUS dpp_ppu_cos_meter_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cos, DPP_PPU_PPU_COS_METER_CFG_T *p_meter_cfg);
DPP_STATUS dpp_ppu_cos_meter_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cos, DPP_PPU_PPU_COS_METER_CFG_T *p_meter_cfg);

DPP_STATUS dpp_ppu_ppu_cop_thash_rsk_set(ZXIC_UINT32 dev_id, DPP_PPU_PPU_COP_THASH_RSK_T *p_para);
DPP_STATUS dpp_ppu_ppu_cop_thash_rsk_get(ZXIC_UINT32 dev_id, DPP_PPU_PPU_COP_THASH_RSK_T *p_ppu_cop_thash_rsk);


DPP_STATUS dpp_ppu_me_sub_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 me_id, DPP_PPU_ME_CNT_T *p_me_cnt);
DPP_STATUS dpp_ppu_cls_fc_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, DPP_PPU_CLS_FC_CNT_T *p_cls_fc_cnt);
DPP_STATUS dpp_ppu_cls_me_stat_wb_excp_cnt_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 me_id, DPP_PPU_ME_CODE_EXCP_CNT_T *p_code_exp_cnt);
DPP_STATUS dpp_ppu_int_flag_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_ppu_random_arbiter_8to1_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_random_cfg);
DPP_STATUS dpp_ppu_cls_stat_wb_excp_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 exc_code0, ZXIC_UINT32 exc_code1, ZXIC_UINT32 exc_code2, ZXIC_UINT32 exc_code3, ZXIC_UINT32 exc_code4, ZXIC_UINT32 exc_code5);
DPP_STATUS dpp_ppu_cls_is_me_not_idle_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, DPP_PPU_CLUSTER_IS_ME_NOT_IDLE_T *p_me_not_idle);
DPP_STATUS dpp_ppu_reorder_bypass_flow_num_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_flow_num_cfg, ZXIC_UINT32 *p_flow_num);
DPP_STATUS dpp_ppu_cluster_dsr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 dsr_value);
DPP_STATUS dpp_ppu_cls_thread_switch_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 *p_thread_switch_en);
DPP_STATUS dpp_ppu_wr_table_self_rsp_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 rsp_en);
DPP_STATUS dpp_ppu_cls_drr_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id);
DPP_STATUS dpp_ppu_cls_me_int_mask_ppu_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 mask_flag);
DPP_STATUS dpp_ppu_cls_thread_switch_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 thread_switch_en);
DPP_STATUS dpp_ppu_host_int_prt(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_ppu_cls_me_int_mask_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, DPP_PPU_ME_INTERRUPT_T *p_int_mask);
DPP_STATUS dpp_ppu_random_arbiter_8to1_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 random_cfg);
DPP_STATUS dpp_ppu_sdt_tbl_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 index, DPP_SDT_TBL_DATA_T *p_sdt_data);
DPP_STATUS dpp_ppu_dup_tbl_read(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 index,
                                ZXIC_UINT32 *p_item_vld,
                                ZXIC_UINT32 *p_flownum_vld,
                                ZXIC_UINT32 *p_start_pc,
                                ZXIC_UINT32 *p_flow_num);
DPP_STATUS dpp_ppu_dup_start_num_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 dup_start_num);
DPP_STATUS dpp_ppu_dup_start_num_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_dup_start_num);
DPP_STATUS dpp_ppu_uc_mc_wrr_weight_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 uc_weight, ZXIC_UINT32 mc_weight);
DPP_STATUS dpp_ppu_uc_mc_wrr_weight_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_uc_weight, ZXIC_UINT32 *p_mc_weight);
DPP_STATUS dpp_ppu_instr_print(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 instr_addr);
DPP_STATUS dpp_ppu_sdt_tbl_print(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 index);
DPP_STATUS dpp_ppu_dup_tbl_print(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);
DPP_STATUS dpp_download_debug_load(ZXIC_UINT32 dev_id);
DPP_VERSION_T * dpp_download_get_mcode_version_time(ZXIC_UINT32 dev_id);
ZXIC_UINT32 dpp_mcode_feature_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT64 *feature);
DPP_STATUS dpp_loader_bp_print(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_loader_instr_print(ZXIC_UINT32 dev_id, ZXIC_UINT32 start_instr_addr, ZXIC_UINT32 num);
DPP_STATUS dpp_ppu_cls_me_int_mask_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, DPP_PPU_ME_INTERRUPT_T *p_int_mask);
DPP_STATUS dpp_ppu_ram_parity_err_flag_get(ZXIC_UINT32 dev_id, DPP_PPU_RAM_PARITY_ERR_T *p_int_status);
DPP_STATUS dpp_ppu_me_ram_ecc_int_status_print(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id);
DPP_STATUS dpp_ppu_cls_ram_err_flag_600m_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, DPP_PPU_CLS_RAM_ERR_600M_T *p_ram_err);
DPP_STATUS dpp_ppu_sdt_ram_int_status_print(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id);
ZXIC_UINT32 dpp_dbg_init(ZXIC_VOID);
DPP_STATUS dpp_softdbg_bp_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 pc_addr);
DPP_STATUS dpp_softdbg_bp_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 pc_addr);
DPP_STATUS dpp_softdbg_bp_print(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_softdbg_start(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_softdbg_stop(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_softdbg_pkt_send(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_softdbg_step_into(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_softdbg_step_over(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_softdbg_mem_print(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);
DPP_STATUS dpp_softdbg_reg_print(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_softdbg_status(ZXIC_UINT32 dev_id);
ZXIC_VOID dpp_softdbg_help(ZXIC_VOID);
DPP_STATUS dpp_ppu_me_busy_threshold_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 threshold);
ZXIC_UINT32 dpp_download_init(ZXIC_UINT32 dev_id);
DPP_STATUS dpp_download_is_load_mc(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_is_load);
ZXIC_UINT32 dpp_agent_socket_thread_create(ZXIC_THREAD_ID_T *p_thread_id);
DPP_STATUS dpp_ppu_ppu_stat_wb_cfg_set(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 dis_flag,
                                       ZXIC_UINT32 last_flag,
                                       ZXIC_UINT32 dup_falg,
                                       ZXIC_UINT32 halt_con_end,
                                       ZXIC_UINT32 mf_type,
                                       ZXIC_UINT32 halt_send_type);
DPP_STATUS dpp_ppu_ppu_stat_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portnum0, ZXIC_UINT32 portnum1, ZXIC_UINT32 bufnum, ZXIC_UINT32 mc_type);
DPP_STATUS dpp_ppu_me_busy_threshold_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cluster_id, ZXIC_UINT32 *p_threshold);
DPP_STATUS dpp_ppu_wr_table_self_rsp_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_rsp_en);
#ifdef __cplusplus
}
#endif

#endif


