/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_apt_se.h
* 文件标识 : 
* 内容摘要 : SE适配业务接口数据结构和函数声明
* 其它说明 : 
* 当前版本 : 
* 作    者 : chenqin00181032
* 完成日期 : 2022/02/22
* MANUAL_PERCENT: 100%   
 
* 修改记录1: 
* 修改日期:  
* 版 本 号:  
* 修 改 人:  
* 修改内容:  
***************************************************************/

#ifndef _DPP_APT_SE_H_
#define _DPP_APT_SE_H_

#include "dpp_apt_se_api.h"

#define SDT_OPER_ADD (ZXIC_UINT32)(0)
#define SDT_OPER_DEL (ZXIC_UINT32)(1)

#define SDT_DDR_RW_128BIT  (ZXIC_UINT32)(0)
#define SDT_DDR_RW_256BIT  (ZXIC_UINT32)(1)
#define SDT_DDR_RW_512BIT  (ZXIC_UINT32)(2)

#define DDR_128BIT_BYTE    (ZXIC_UINT32)(16)
typedef struct se_apt_eram_func_t
{
    ZXIC_UINT32 opr_mode;     /**cpu读写位宽模式DPP_ERAM128_OPR_MODE_E 0:128b 1:64b 2:1b 3:32b <@*/
    ZXIC_UINT32 rd_mode;      /*读清模式DPP_ERAM128_RD_CLR_MODE_E，0:正常读 1:读清模式*/
    DPP_APT_ERAM_SET_FUNC  eram_set_func;
    DPP_APT_ERAM_GET_FUNC  eram_get_func;
}SE_APT_ERAM_FUNC_T;

typedef struct se_apt_ddr_func_t
{
    ZXIC_UINT32 ddr_tbl_depth;     /*ddr表项深度，单位与ddr读写模式一致*/
    DPP_APT_DDR_SET_FUNC  ddr_set_func;
    DPP_APT_DDR_GET_FUNC  ddr_get_func;
}SE_APT_DDR_FUNC_T;

typedef struct se_apt_acl_func_t
{
    ZXIC_UINT32 sdt_partner;
    DPP_APT_ACL_ENTRY_SET_FUNC  acl_set_func;
    DPP_APT_ACL_ENTRY_GET_FUNC  acl_get_func;
}SE_APT_ACL_FUNC_T;

typedef struct se_apt_hash_func_t
{
    ZXIC_UINT32 sdt_partner;
    DPP_APT_HASH_ENTRY_SET_FUNC  hash_set_func;
    DPP_APT_HASH_ENTRY_GET_FUNC  hash_get_func;
}SE_APT_HASH_FUNC_T;

typedef struct se_apt_lpm_func_t
{
    ZXIC_UINT32 v46_ddr_item_num;
    DPP_APT_LPM_ENTRY_SET_FUNC  lpm_set_func;
    DPP_APT_LPM_ENTRY_GET_FUNC  lpm_get_func;
}SE_APT_LPM_FUNC_T;
typedef struct se_apt_callback_t
{
    ZXIC_UINT32 sdtNo;          /** <@brief sdt no 0~255 */
    ZXIC_UINT32 table_type;     /** <@brief 查找表项类型 */
    union
    {
        SE_APT_ERAM_FUNC_T eramFunc;
        SE_APT_DDR_FUNC_T  ddrFunc;
        SE_APT_ACL_FUNC_T  aclFunc;
        SE_APT_HASH_FUNC_T hashFunc;
        SE_APT_LPM_FUNC_T  lpmFunc;
    }se_func_info;
}SE_APT_CALLBACK_T;

typedef struct se_apt_eram_convert_t
{
    ZXIC_UINT32 sdt_no;
    DPP_APT_ERAM_SET_FUNC  eram_set_func;
    DPP_APT_ERAM_GET_FUNC  eram_get_func;
}SE_APT_ERAM_CONVERT_T;

typedef struct se_apt_ddr_convert_t
{
    ZXIC_UINT32 sdt_no;
    DPP_APT_DDR_SET_FUNC  ddr_set_func;
    DPP_APT_DDR_GET_FUNC  ddr_get_func;
}SE_APT_DDR_CONVERT_T;

typedef struct se_apt_hash_convert_t
{
    ZXIC_UINT32 sdt_no;
    DPP_APT_HASH_ENTRY_SET_FUNC  hash_set_func;
    DPP_APT_HASH_ENTRY_GET_FUNC  hash_get_func;
}SE_APT_HASH_CONVERT_T;

typedef struct se_apt_acl_convert_t
{
    ZXIC_UINT32 sdt_no;
    DPP_APT_ACL_ENTRY_SET_FUNC  acl_set_func;
    DPP_APT_ACL_ENTRY_GET_FUNC  acl_get_func;
}SE_APT_ACL_CONVERT_T;

typedef struct se_apt_lpm_convert_t
{
    ZXIC_UINT32 sdt_no;
    DPP_APT_LPM_ENTRY_SET_FUNC  lpm_set_func;
    DPP_APT_LPM_ENTRY_GET_FUNC  lpm_get_func;
}SE_APT_LPM_CONVERT_T;

SE_APT_CALLBACK_T *dpp_apt_get_func(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no);
DPP_STATUS dpp_apt_set_callback(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no, ZXIC_UINT32 table_type,ZXIC_VOID *pData);
DPP_STATUS se_apt_get_zblock_index(ZXIC_UINT32 zblock_bitmap,ZXIC_UINT32 *zblk_idx);
DPP_STATUS se_apt_get_ddr_index(ZXIC_UINT32 dev_id,ZXIC_UINT32 rw_mode,ZXIC_UINT32 index, ZXIC_UINT32 *row,ZXIC_UINT32 *column);
ZXIC_UINT32 dpp_apt_get_sdt_partner(ZXIC_UINT32 dev_id,ZXIC_UINT32 sdt_no);
DPP_STATUS dpp_apt_se_callback_init(ZXIC_UINT32 dev_id);
DPP_STATUS se_apt_get_eram_opr_mode(ZXIC_UINT32 eram_mode,ZXIC_UINT32 *opr_mode);
ZXIC_UINT32 dpp_get_se_buff_size(ZXIC_UINT32 opr);

/***********************************************************/
/** 红黑树默认key比较函数
* @param   p_new_key      新键值
* @param   p_old_key      旧键值
* @param   key_len        键值长度
* @return  比较结果
* @remark  无
* @see
* @author  chenqin00181032      @date  2023/02/24
************************************************************/
ZXIC_SINT32 dpp_se_apt_key_default_cmp(void *p_new_key, void *p_old_key, ZXIC_UINT32 key_len);


/***********************************************************/
/** 红黑树插入
* @param   rb_cfg     红黑树配置
* @param   pData      待插入的新数据
* @param   len        长度
* @return  比较结果
* @remark  无
* @see
* @author  chenqin00181032      @date  2023/02/24
************************************************************/
DPP_STATUS dpp_se_apt_rb_insert(ZXIC_RB_CFG *rb_cfg,void *pData,ZXIC_UINT32 len);

/***********************************************************/
/** 红黑树查找
* @param   rb_cfg     红黑树配置
* @param   pData      待查找的数据
* @param   len        长度
* @return  比较结果
* @remark  无
* @see
* @author  chenqin00181032      @date  2023/02/24
************************************************************/
DPP_STATUS dpp_se_apt_rb_search(ZXIC_RB_CFG *rb_cfg,void *pData,ZXIC_UINT32 len);

/***********************************************************/
/** 删除红黑树指定数据
* @param   rb_cfg     红黑树配置
* @param   pData      待删除的数据
* @param   len        长度
* @return  比较结果
* @remark  无
* @see
* @author  chenqin00181032      @date  2023/02/24
************************************************************/
DPP_STATUS dpp_se_apt_rb_delete(ZXIC_RB_CFG *rb_cfg,void *pData,ZXIC_UINT32 len);

/***********************************************************/
/** 删除整个红黑树
* @param   rb_cfg     红黑树配置
* @return  
* @remark  无
* @see
* @author  cq      @date  2023/09/23
************************************************************/
DPP_STATUS dpp_se_apt_rb_destroy(ZXIC_RB_CFG *p_rb_cfg);

/***********************************************************/
/** 计算读写位宽转换为1bit的个数
* @param   tbl_mode     
* @return  
* @remark  无
* @see
* @author  cq      @date  2023/10/10
************************************************************/
ZXIC_UINT32 dpp_smmu0_rd_convert_1bit(ZXIC_UINT32 eram_mode);

/***********************************************************/
/** 消息通道获取hash表func/bulk信息
* @param   devId          NP设备号
* @param   type           资源类型0:标卡 1:非标卡
* @param   pHashResInit   获取到的func/bulk信息
* @return
* @remark  无
* @see
* @author  cq      @date  2024/11/11
************************************************************/
ZXIC_UINT32 dpp_agent_hash_func_bulk_get(ZXIC_UINT32 devId,ZXIC_UINT32 type,DPP_APT_HASH_RES_INIT_T *pHashResInit);

/***********************************************************/
/** 消息通道获取hash表table信息
* @param   devId          NP设备号
* @param   type           资源类型0:标卡 1:非标卡
* @param   pHashResInit   获取到的table信息
* @return
* @remark  无
* @see
* @author  cq      @date  2024/11/11
************************************************************/
ZXIC_UINT32 dpp_agent_hash_tbl_get(ZXIC_UINT32 devId,ZXIC_UINT32 type,DPP_APT_HASH_RES_INIT_T *pHashResInit);

/***********************************************************/
/** 消息通道获取eram表table信息
* @param   devId          NP设备号
* @param   type           资源类型0:标卡 1:非标卡
* @param   pEramResInit   获取到的eram信息
* @return
* @remark  无
* @see
* @author  cq      @date  2024/11/11
************************************************************/
ZXIC_UINT32 dpp_agent_eram_tbl_get(ZXIC_UINT32 devId,ZXIC_UINT32 type,DPP_APT_ERAM_RES_INIT_T *pEramResInit);

/***********************************************************/
/** 消息通道获取acl表table信息
* @param   devId          NP设备号
* @param   type           资源类型0:标卡 1:非标卡
* @param   pAclResInit   获取到的acl信息
* @return
* @remark  无
* @see
* @author  cq      @date  2024/11/11
************************************************************/
ZXIC_UINT32 dpp_agent_acl_tbl_get(ZXIC_UINT32 devId,ZXIC_UINT32 type,DPP_APT_ACL_RES_INIT_T *pAclResInit);

/***********************************************************/
/** 消息通道获取lpm表table信息
* @param   devId          NP设备号
* @param   type           资源类型0:标卡 1:非标卡
* @param   pLpmResInit   获取到的lpm信息
* @return
* @remark  无
* @see
* @author  cq      @date  2024/11/11
************************************************************/
ZXIC_UINT32 dpp_agent_lpm_tbl_get(ZXIC_UINT32 devId,ZXIC_UINT32 type,DPP_APT_LPM_RES_INIT_T *pLpmResInit);

/***********************************************************/
/** 消息通道获取ddr表table信息
* @param   devId          NP设备号
* @param   type           资源类型0:标卡 1:非标卡
* @param   pDdrResInit   获取到的ddr信息
* @return
* @remark  无
* @see
* @author  cq      @date  2024/11/11
************************************************************/
ZXIC_UINT32 dpp_agent_ddr_tbl_get(ZXIC_UINT32 devId,ZXIC_UINT32 type,DPP_APT_DDR_RES_INIT_T *pDdrResInit);

/***********************************************************/
/** 消息通道获取stat cfg信息
* @param   devId          NP设备号
* @param   type           资源类型0:标卡 1:非标卡
* @param   pStatCfgInit   获取到的统计信息
* @return
* @remark  无
* @see
* @author  cq      @date  2024/11/11
************************************************************/
ZXIC_UINT32 dpp_agent_stat_cfg_get(ZXIC_UINT32 devId,ZXIC_UINT32 type,DPP_APT_STAT_RES_INIT_T *pStatCfgInit);

#endif
