/**************************************************************
* 调度器资源分配如下
* FQ 
*fq_num:  1280 : 0, 1, 2 ... 0x4ff
*fq2_num: 1024 : 0x500, 0x502, 0x504 ... 0xcfe 
*fq4_num: 1024 : 0xd00, 0xd04, 0xd08 ... 0x1cfc 
*fq8_num: 1120 : 0x1d00, 0x1d08, 0x1d10 ... 0x3ff8
* SP-WFQ
*sp_num: 128 : 0x4000, 0x4001, 0x4002 ... 0x407f 
*wfq_num: 2048 : 0x4080, 0x4081, 0x4082 ... 0x487f 
*wfq2_num: 256 : 0x4880, 0x4882, 0x4884 ... 0x4a7e 
*wfq4_num: 256 : 0x4a80, 0x4a84, 0x4a88 ... 0x4e7c 
*wfq8_num: 688 : 0x4e80, 0x4e88, 0x4e90 ... 0x63f8 
*
*队列资源分配如下
*flow id 0~0xf 预留 0队列用于MR复制队列， 0x10~0xfff 通用队列
***************************************************************/
#ifndef  _DPP_TM_SCH_H_
#define  _DPP_TM_SCH_H_

#include "dpp_tm_api.h"
#include "dpp_etm_reg.h"

/******************************************************************************
 *                                宏定义                                *
 *****************************************************************************/
#define FQ_NUM_START      0
#define FQ2_NUM_START     0x500
#define FQ4_NUM_START     0xd00
#define FQ8_NUM_START     0x1d00
#define SP_NUM_START      0x4000
#define WFQ_NUM_START     0x4080
#define WFQ2_NUM_START    0x4880
#define WFQ4_NUM_START    0x4a80
#define WFQ8_NUM_START    0x4e80
#define FLOW_NUM_START    0

#define FQ_NUM_END      0x4ff
#define FQ2_NUM_END     0xcfe
#define FQ4_NUM_END     0x1cfc
#define FQ8_NUM_END     0x3ff8
#define SP_NUM_END      0x407f
#define WFQ_NUM_END     0x487f
#define WFQ2_NUM_END    0x4a7e
#define WFQ4_NUM_END    0x4e7c
#define WFQ8_NUM_END    0x63f8
#define FLOW_NUM_END    0xfff

#define FQ_NEXT_OFFSET  1
#define FQ2_NEXT_OFFSET 2
#define FQ4_NEXT_OFFSET 4
#define FQ8_NEXT_OFFSET 8
#define SP_NEXT_OFFSET  1
#define WFQ_NEXT_OFFSET  1
#define WFQ2_NEXT_OFFSET 2
#define WFQ4_NEXT_OFFSET 4
#define WFQ8_NEXT_OFFSET 8
#define FLOW_NEXT_OFFSET  1

#define FQ_NUM_MAX   (1280 - 1)
#define FQ2_NUM_MAX  (1024 - 1)
#define FQ4_NUM_MAX  (1024 - 1)
#define FQ8_NUM_MAX  (1120 - 1)
#define SP_NUM_MAX   (128 - 1)
#define WFQ_NUM_MAX   (2048 - 1)
#define WFQ2_NUM_MAX  (256 - 1)
#define WFQ4_NUM_MAX  (256 - 1)
#define WFQ8_NUM_MAX  (688 - 1)
#define FLOW_NUM_MAX   (4096 - 1)

#define RESERVE_FLOW_MAX (192)

#define ZXIC_SCHE_ID_OUT_BASE         (0x80)
#define ZXIC_TM_FQ_USED_OUT           (0 | ZXIC_SCHE_ID_OUT_BASE)
#define ZXIC_TM_WFQ_USED_OUT          (1 | ZXIC_SCHE_ID_OUT_BASE)
#define ZXIC_TM_FQ2_USED_OUT          (2 | ZXIC_SCHE_ID_OUT_BASE)
#define ZXIC_TM_WFQ2_USED_OUT         (3 | ZXIC_SCHE_ID_OUT_BASE)
#define ZXIC_TM_FQ4_USED_OUT          (4 | ZXIC_SCHE_ID_OUT_BASE)
#define ZXIC_TM_WFQ4_USED_OUT         (5 | ZXIC_SCHE_ID_OUT_BASE)
#define ZXIC_TM_FQ8_USED_OUT          (6 | ZXIC_SCHE_ID_OUT_BASE)
#define ZXIC_TM_WFQ8_USED_OUT         (7 | ZXIC_SCHE_ID_OUT_BASE)
#define ZXIC_TM_SP_USED_OUT           (8 | ZXIC_SCHE_ID_OUT_BASE)
#define ZXIC_TM_SES_SE_ID_USED_OUT    (9 | ZXIC_SCHE_ID_OUT_BASE)
#define ZXIC_TM_FLOW_SE_ID_USED_OUT  (10 | ZXIC_SCHE_ID_OUT_BASE)

#define SCHE_RES_OUT                  (0x100000000000000)

#define ZXIC_TM_ERR_BASE              (0x90)
#define ZXIC_TM_SHCE_TYPE_ERR         (1 | ZXIC_TM_ERR_BASE)


#define    ZXIC_BITDCL     ZXIC_UINT32
#define    ZXIC_BITWID     (32)

#define SCHE_RES_USED_SET(_u_, _identifier_) \
    ZXIC_COMM_BITSET(_u_, _identifier_)

#define SCHE_RES_USED_CLR(_u_, _identifier_) \
    ZXIC_COMM_BITCLR(_u_, (_identifier_))

#define SCHE_RES_USED_GET(_u_, _identifier_) \
    ZXIC_COMM_BITGET(_u_, (_identifier_))

#define DPP_EPID_MAX (5)

#define HOST_POWER_OFF  (0)
#define PF_POWER_OFF    (1)

#define G_SCH_ID_MASK (0xffffffffffffffff)
#define ZXIC_G_SCH_ID_GET(_gsch_id, _seid_vaild, _port, _vport, _level, _type, _num, _se_id) \
        ((_gsch_id) = ((((ZXIC_UINT64)_seid_vaild) << 56) & G_SCH_ID_MASK) | \
                      ((((ZXIC_UINT64)_port) << 48) & G_SCH_ID_MASK) |   \
                      ((((ZXIC_UINT64)_vport) << 32) & G_SCH_ID_MASK) |  \
                      ((((ZXIC_UINT64)_level) << 28) & G_SCH_ID_MASK) |  \
                      ((((ZXIC_UINT64)_type) << 24) & G_SCH_ID_MASK) |  \
                      ((((ZXIC_UINT64)_num) << 16) & G_SCH_ID_MASK) |  \
                      (((ZXIC_UINT64)_se_id) & G_SCH_ID_MASK))

#define ZXIC_G_EP_ID_GET(_ep_id, _vport) \
        ((_ep_id) = (_vport & 0x7000) >> 12)

#define ZXIC_G_PF_ID_GET(_pf_id, _vport) \
        ((_pf_id) = (_vport & 0x700) >> 8)
       
/******************************************************************************
 *                                类型定义                               *
 *****************************************************************************/
typedef enum dpp_tm_crdt_level_e
{
    DPP_TM_CRDT_LEVEL_FLOW = 0,     /* CRDT FLOW级*/
    DPP_TM_CRDT_LEVEL_SES = 1,      /* CRDT SES级*/
    DPP_TM_CRDT_LEVEL_VC = 2,       /* CRDT VC级*/
    DPP_TM_CRDT_LEVEL_VCG = 3,      /* CRDT VCG级*/
    DPP_TM_CRDT_LEVEL_VP = 4,       /* CRDT VP级*/
    DPP_TM_CRDT_LEVEL_PP = 5,       /* CRDT PP级*/
    DPP_TM_CRDT_LEVEL_DEV = 6       /* CRDT DEV级*/
} DPP_TM_CRDT_LEVEL_E;

typedef enum dpp_cosq_sche_type
{
    FQ_SCHE = 0,
    FQ2_SCHE = 1,
    FQ4_SCHE = 2,
    FQ8_SCHE = 3,
    SP_SCHE = 4,
    WFQ_SCHE = 5,
    WFQ2_SCHE = 6,
    WFQ4_SCHE = 7,
    WFQ8_SCHE = 8,
    FLOW_SCHE = 9,
    SCHE_TYPE = 10
} DPP_COSQ_SCHE_TYPE;

typedef struct dpp_port_crdt
{
    ZXIC_UINT32 fq;
    ZXIC_UINT32 wfq[DPP_EPID_MAX];
} DPP_PORT_CRDT_T;

typedef struct dpp_cosq_list
{
    ZXIC_UINT32  count;
    ZXIC_BITDCL  *bits;
} DPP_COSQ_LIST_T;
typedef struct zxic_tm_res_info
{
    DPP_COSQ_LIST_T sche_list[SCHE_TYPE];
    ZXIC_UINT32     is_valid;
} DPP_TM_RES_INFO_T;

typedef struct dpp_tm_rb_res_info
{
    ZXIC_UINT32 se_id;
    ZXIC_UINT32 sche_type;
    ZXIC_UINT32 pp_port;
    ZXIC_UINT32 vport_id;
    ZXIC_UINT32 sche_level;
    ZXIC_UINT32 num;
} DPP_TM_RB_RES_INFO_T;

typedef struct 
{
    ZXIC_UINT32 flag;
} DPP_TM_PORT_RES_STATUS_T;


/******************************************************************************
 *                                接口定义                               *
 *****************************************************************************/
/***********************************************************/
/**tm 预留队列初始化函数
* @param   device_id   芯片的id号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_tm_reserver_flow_init(ZXIC_UINT32 device_id);

/***********************************************************/
/**tm drv初始化函数
* @param   device_id   芯片的id号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_tm_drv_init(ZXIC_UINT32 device_id);

/***********************************************************/
/**tm寄存器初始化函数
* @param   device_id   芯片的id号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_tm_reg_init(ZXIC_UINT32 device_id);

/***********************************************************/
/**硬初始化函数  对应的资源申请
* @param   device_id   芯片的id号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_tm_cosq_hard_init(ZXIC_UINT32 device_id);

/***********************************************************/
/**资源对应的bit位置位
* @param   list   节点bit信息
* @param   id     要置位的bit位
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_cosq_sche_index_set(DPP_COSQ_LIST_T *list, ZXIC_UINT32 id);

/***********************************************************/
/**资源对应的bit位清0
* @param   list   节点bit信息
* @param   id     要置位的bit位
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_cosq_sche_index_clr(DPP_COSQ_LIST_T *list, ZXIC_UINT32 id);

/***********************************************************/
/**获取资源的id号
* @param   list    对应的bitmap的指针
* @param   start   起始的比特位
* @param   end     终止的比特位
* @param   id      获取的id号
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_cosq_sche_index_get(ZXIC_BITDCL *list, ZXIC_UINT32 start, ZXIC_UINT32 end, ZXIC_UINT32 *id);

/***********************************************************/
/**软初始化函数  对应的资源申请
* @param   device_id   芯片的id号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_tm_cosq_soft_init(ZXIC_UINT32 device_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**获取数据库句柄
* @param   device_id   芯片的id号
* @param   pp_port   芯片的id号
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
ZXIC_RB_CFG * dpp_tm_res_addr_rb_get(ZXIC_UINT32 device_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**红黑树key比较
* @param   p_new_key  新键值
* @param   p_old_key   旧键值
* @param   key_len   键值长度
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
ZXIC_SINT32 dpp_tm_res_key_default_cmp(void *p_new_key, void *p_old_key, ZXIC_UINT32 key_len);

/***********************************************************/
/**用于crdt的pp级端口初始化 
* 初始化FQ调度器挂接到pp级端口上
* @param   device_id   芯片的id号
* @param   pp_port     tm端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_tm_pp_level_init(ZXIC_UINT32 device_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**对应的pp级FQ调度器删除
* @param   device_id   芯片的id号
* @param   pp_port     tm端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_tm_pp_level_delete(ZXIC_UINT32 device_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**申请调度器
* @param   device_id   芯片的id号
* @param   mode        调度器类型
* @param   p_id        调度器号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_tm_cosq_fq_wfq_get(ZXIC_UINT32 device_id, DPP_COSQ_SCHE_TYPE mode, ZXIC_UINT32 *p_id);

/***********************************************************/
/**pp级挂接调度器id
* @param   device_id   芯片的id号
* @param   type        调度器类型
* @param   se_id       调度器号
* @param   num         个数
* @param   pp_port     端口号
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_sche_crdt_pp_creat(ZXIC_UINT32 device_id, DPP_COSQ_SCHE_TYPE type, ZXIC_UINT32 se_id, ZXIC_UINT32 num, ZXIC_UINT32 pp_port);

/***********************************************************/
/**全局的gsch_id的申请
* @param   vport_id    vport id号
* @param   pp_port     pp_port的值
* @param   numq        申请的id的个数  目前只支持一次申请一个
* @param   level       挂接层级
* @param   flags       对应的se_id的类型
* @param   gsch_id     获取的gsc_id的值    (获取的挂点除pp级的
*                      只有挂接上才算真正的使用了)
*
* @return
* @remark  对于pp级的节点自动的加到dev级     pp级的挂点值
*          允许申请一次  之后只是返回之前的值
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_cosq_gsch_id_add(ZXIC_UINT32 pp_port, ZXIC_UINT32 vport_id, ZXIC_UINT32 numq, ZXIC_UINT32 level, ZXIC_UINT32 flags, ZXIC_UINT64 *gsch_id);

/***********************************************************/
/**获取的限速模版的资源删除
*
* @param   vport_id    vport id号
* @param   pp_port     pp_port的值
* @param   numq        申请的id的个数  目前只支持一次申请一个
* @param   level       挂接层级
* @param   flags       对应的se_id的类型
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_cosq_gsch_id_delete(ZXIC_UINT32 pp_port, ZXIC_UINT32 vport_id, ZXIC_UINT32 numq, ZXIC_UINT32 level, ZXIC_UINT32 flags, ZXIC_UINT32 se_id);

/***********************************************************/
/**查询根节点调度器
* @param   device_id   芯片的id号
* @param   gsch_id     全局的调度单元的编号
*                      (删除除pp级以外的节点)
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_sch_base_node_get(ZXIC_UINT32 vport_id, ZXIC_UINT32 pp_port, ZXIC_UINT32 numq, ZXIC_UINT32 level, ZXIC_UINT32 flags, ZXIC_UINT64 *gsch_id);

/***********************************************************/
/**遍历数据库
* @param   device_id   芯片的id号
* @param   pp_port     端口号
* 
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_tm_res_database(ZXIC_UINT32 device_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**host复位，对应riscv资源释放
* @param   ep_id   host id号
* @param   pf_id   pf id号
* @param   pp_port 物理端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_crdt_reset(ZXIC_UINT32 ep_id, ZXIC_UINT32 pf_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**host复位，对应riscv资源释放
* @param   se_id   调度单元id号
* @param   type    调度单元类型
* @param   pp_port 物理端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_crdt_sche_release(ZXIC_UINT32 se_id, ZXIC_UINT32 type, ZXIC_UINT32 pp_port);

/***********************************************************/
/**host复位，对应flow资源释放
* @param   ep_id   host id号
* @param   pf_id   pf id号
* @param   pp_port 物理端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_crdt_flow_delete(ZXIC_UINT32 ep_id, ZXIC_UINT32 pf_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**host复位，对应se资源释放
* @param   ep_id   host id号
* @param   pf_id   pf id号
* @param   pp_port 物理端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_crdt_ses_delete(ZXIC_UINT32 ep_id, ZXIC_UINT32 pf_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**host复位，对应se资源释放
* @param   ep_id   host id号
* @param   pf_id   pf id号
* @param   pp_port 物理端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_crdt_vcg_delete(ZXIC_UINT32 ep_id, ZXIC_UINT32 pf_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**host复位，对应se资源释放
* @param   ep_id   host id号
* @param   pf_id   pf id号
* @param   pp_port 物理端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_riscv_crdt_vc_delete(ZXIC_UINT32 ep_id, ZXIC_UINT32 pf_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**host异常复位，对应tm资源释放
* @param   dev_id  设备号
* @param   ep_id   host id号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2023/12/1
************************************************************/
DPP_STATUS dpp_host_tm_reset_process(ZXIC_UINT32 dev_id, ZXIC_UINT32 ep_id);

/***********************************************************/
/**vport复位，对应flow资源释放
* @param   vport_id   vport_id号
* @param   pp_port 物理端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2024/2/27
************************************************************/
DPP_STATUS dpp_riscv_vport_crdt_flow_delete(ZXIC_UINT32 vport_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**vport复位，对应se资源释放
* @param   vport_id   vport_id号
* @param   pp_port 物理端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2024/2/27
************************************************************/
DPP_STATUS dpp_riscv_vport_crdt_ses_delete(ZXIC_UINT32 vport_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**vport复位，对应se资源释放
* @param   vport_id   vport_id号
* @param   pp_port 物理端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2024/2/27
************************************************************/
DPP_STATUS dpp_riscv_vport_crdt_vcg_delete(ZXIC_UINT32 vport_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**vport复位，对应se资源释放
* @param   vport_id   vport_id号
* @param   pp_port 物理端口号
*
* @return
* @remark  无
* @see
* @author  sun      @date  2024/2/27
************************************************************/
DPP_STATUS dpp_riscv_vport_crdt_vc_delete(ZXIC_UINT32 vport_id, ZXIC_UINT32 pp_port);

/***********************************************************/
/**vport复位，对应tm挂接资源释放
 * @param   dev_id   设备号
 * @param   ep_no   host id号
 * @param   pf_no   pf id号
 * @param   vf_no   vf id号
 * @param   vf_active  pf/vf标记
 *
 * @return
 * @remark  无
 * @see
 * @author  sun      @date  2024/2/27
 ************************************************************/
DPP_STATUS dpp_vport_tm_reset_process(ZXIC_UINT32 ep_no, ZXIC_UINT32 pf_no, ZXIC_UINT32 vf_no, ZXIC_UINT32 vf_active);

#endif
