/**************************************************************
* 版权所?? (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_module.h
* 文件标识 :
* 内容摘要 :
* 其它说明 :
* 当前版本 :
* ??    ?? : 石金??
* 完成日期 : 2014/02/10
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* 修改记录1:
* 修改日期:
* ?? ?? ??:
* ?? ?? ??:
* 修改内容:*/
#ifndef _DPP_MODULE_H_
#define _DPP_MODULE_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "zxic_common.h"
#include "dpp_type_api.h"

#define TM_FILE_PATH "dpp_tm_output.txt"

/**  For TM*/
#define TM_REG_WR                        (0x0U)
#define TM_REG_RD                        (0x1U)
#define TM_REG_OFFSET_CMD                (0x0)
#define TM_REG_OFFSET_ADDR               (0x4)
#define TM_REG_OFFSET_WRITE_DATA         (0x8)
#define TM_REG_OFFSET_READ_DATA          (0xc)
#define TM_REG_CMD_BUILD                 (0x1)
#define TM_REG_ADDR_BUILD(rwflag,addr)   (((rwflag)<<31)|((addr)&0x7FFFFFFF))

#define DPP_ETM                          (0) 
#define DPP_FTM                          (1) 

#define DPP_ETM_Q_HEALTH_CHECK_NUM       (256)
#define DPP_ETM_CRDT_HEALTH_CHECK_NUM    (256)

/**  for PLCR*/
#define PLCR_REG_WR                      (0x0U)
#define PLCR_REG_RD                      (0x1U)

#define PLCR_REG_OFFSET_CMD              (0x0)
#define PLCR_REG_OFFSET_ADDR             (0x4)
#define PLCR_REG_OFFSET_WRITE_DATA       (0x8)
#define PLCR_REG_OFFSET_READ_DATA        (0xc)

#define PLCR_REG_CMD_BUILD               (0x1)
#define PLCR_REG_ADDR_BUILD(rwflag,addr) (((rwflag)<<31)|((addr)&0x7FFFFFFF))

#define PLCR_REG_OFFSET_ZXIC_UINT8S       (26)
#define PLCR_REG_OFFSET_MASK             (0x3ffffff)

/**  for PPU*/
#ifdef DPP_TEST_BAORD_SSP2T
#define DPP_PPU_CLUSTER_NUM              (1)
#else
#define DPP_PPU_CLUSTER_NUM              (6)
#endif

#define DPP_PPU_ME_EXCEPTION_MAX         (8)
#define DPP_PPU_CLUSTER_MEPERCLS_NUM     (8)
#define DPP_PPU_CLUSTER_SPACE_SIZE       (0x00008000)
#define DPP_MAX_CHCHK_NUM                (50)


#define DPP_TRPG_PORT_NUM                (32)
#define DPP_TRPG_PORT_SPACE_SIZE         (0x10000)

#define DPP_TRPG_RAM_NUM                 (16)
#define DPP_TRPG_RAM_SPACE_SIZE          (0x10000)

#define DPP_TSN_PORT_NUM                (4)
#define DPP_TSN_PORT_SPACE_SIZE         (0x4000)



/**  module serdes*/
typedef enum module_init_e
{
    MODULE_INIT_NPPU = 0,  /**<  @brief 01:pktrx  0x2:pbu  0x4:odma*/
    MODULE_INIT_PPU,
    MODULE_INIT_SE,    /**<  @brief corresponding bits indicacte SE submodule, 0:smmu0 1:smmu1 2:alg 3:as 4:etcam 5:stat 6:reg_fifo 31:SE_init_done*/
    MODULE_INIT_ETM,   /**<  @brief bit31:tm  bit0:olif  bit1:cgavd  bit2:tmmu  bit3:shap  bit4:crdt  bit5:qmu */
    MODULE_INIT_DLB,   
    MODULE_INIT_TRPG,   
    MODULE_INIT_TSN,   
    MODULE_INIT_MAX
} MODULE_INIT_E;

typedef enum dpp_module_e
{
    CFG = 1,             /**<  @brief 1*/
    NPPU,                /**<  @brief 2*/
    PPU,                 /**<  @brief 3*/
    ETM,                 /**<  @brief 4*/
    STAT,                /**<  @brief 5*/
    CAR,                 /**<  @brief 6*/
    SE,                  /**<  @brief 7*/
    SMMU0       = SE,    /**<  @brief 7*/
    SMMU1       = SE,    /**<  @brief 7*/
    DTB,                 /**<  @brief 8*/
    TRPG ,               /**<  @brief 9*/
    TSN ,                /**<  @brief 10*/
    AXI ,                /**<  @brief 11*/
    PTPTM ,              /**<  @brief 12*/
    DTB4K,               /**<  @brief 13*/
    STAT4K,              /**<  @brief 14*/
    PPU4K,               /**<  @brief 15*/
    SE4K,                /**<  @brief 16*/
    SMMU14K,             /**<  @brief 17*/
    MODULE_MAX           
} DPP_MODULE_E;

typedef enum module_tm_e
{
    MODULE_TM_CFGMT = 0,
    MODULE_TM_OLIF  = 1,
    MODULE_TM_CGAVD = 2,
    MODULE_TM_TMMU  = 3,
    MODULE_TM_SHAP  = 4,
    MODULE_TM_CRDT  = 5,
    MODULE_TM_QMU   = 6,
    MODULE_TM_MAX
} MODULE_TM_E;

/*NP 在PICE中的偏移地址*/
#define SYS_VF_NP_BASE_OFFSET      0X0000000000
/*NP 在DPU中的基地址*/

#if DPP_DEV_VPCI_EN
#define SYS_NP_BASE_ADDR           0x6300000000
#define SYS_NP_BASE_ADDR0          0x14000000
#define SYS_NP_BASE_ADDR1          0x16000000
#else
#define SYS_NP_BASE_ADDR           0x6218000000
#define SYS_NP_BASE_ADDR0          0x00000000
#define SYS_NP_BASE_ADDR1          0x02000000
#endif
/**  sub system base address*/
typedef enum sys_base_addr_e
{
    SYS_NPPU_BASE_ADDR               = (SYS_NP_BASE_ADDR0 + 0x00000000),
    SYS_PPU_BASE_ADDR                = (SYS_NP_BASE_ADDR0 + 0x00080000),
    SYS_ETM_BASE_ADDR                = (SYS_NP_BASE_ADDR0 + 0x00180000),
    SYS_STAT_BASE_ADDR               = (SYS_NP_BASE_ADDR0 + 0x00200000),
    SYS_SE_BASE_ADDR                 = (SYS_NP_BASE_ADDR0 + 0x00280000),
    SYS_SE_SMMU0_BASE_ADDR           = (SYS_NP_BASE_ADDR0 + 0x00300000),
    SYS_SE_SMMU1_BASE_ADDR           = (SYS_NP_BASE_ADDR0 + 0x00310000),
//    SYS_TRPG_BASE_ADDR               = (SYS_NP_BASE_ADDR0 + 0x00320000),
    SYS_CFG_BASE_ADDR                = (SYS_NP_BASE_ADDR0 + 0x00330000),
    SYS_PTP0_BASE_ADDR               = (SYS_NP_BASE_ADDR0 + 0x00340000),
    SYS_PTP1_BASE_ADDR               = (SYS_NP_BASE_ADDR0 + 0x00344000),
    SYS_TSN_BASE_ADDR                = (SYS_NP_BASE_ADDR0 + 0x00350000),
    SYS_TRPG_BASE_ADDR               = (SYS_NP_BASE_ADDR0 + 0x00400000),

    SYS_DTB_BASE_ADDR                = (SYS_NP_BASE_ADDR1 + 0x00000000),
    SYS_AXIM0_BASE_ADDR              = (SYS_NP_BASE_ADDR1 + 0x01400000),
    SYS_AXIM1_BASE_ADDR              = (SYS_NP_BASE_ADDR1 + 0x01408000),
    SYS_AXI_CONV_BASE_ADDR           = (SYS_NP_BASE_ADDR1 + 0x01410000),
    SYS_AXIS_BASE_ADDR               = (SYS_NP_BASE_ADDR1 + 0x01418000),
    SYS_TLB_BASE_ADDR                = (SYS_NP_BASE_ADDR1 + 0x01420000),
    
    SYS_MAX_BASE_ADDR                = 0x20000000,
} SYS_BASE_ADDR_E;

/**  module base address*/
typedef enum module_base_addr_e
{
    /* CFG         */
    MODULE_CFG_PCIE_BASE_ADDR        = 0x00000000,
    MODULE_CFG_DMA_BASE_ADDR         = 0x00001000,
    MODULE_CFG_CSR_BASE_ADDR         = 0x00003000,

    /* NPPU       */
    MODULE_NPPU_MR_CFG_BASE_ADDR           = 0x00000000,
    MODULE_NPPU_PKTRX_CFG_BASE_ADDR        = 0x00000800,
    MODULE_NPPU_PKTRX_STAT_BASE_ADDR       = 0x00001000,
    MODULE_NPPU_IDMA_CFG_BASE_ADDR         = 0x00001800,
    MODULE_NPPU_IDMA_STAT_BASE_ADDR        = 0x00002000,
    MODULE_NPPU_PBU_CFG_BASE_ADDR          = 0x00002800,
    MODULE_NPPU_PBU_STAT_BASE_ADDR         = 0x00003000,
    MODULE_NPPU_ISU_CFG_BASE_ADDR          = 0x00003800,
    MODULE_NPPU_ISU_STAT_BASE_ADDR         = 0x00004000,
    MODULE_NPPU_ODMA_CFG_BASE_ADDR         = 0x00004800,
    MODULE_NPPU_ODMA_STAT_BASE_ADDR        = 0x00005000,
    MODULE_NPPU_OAM_CFG_BASE_ADDR          = 0x00005800,
    MODULE_NPPU_OAM_STAT_BASE_ADDR         = 0x00006000,
    MODULE_NPPU_OAM_INT_IDX0_BASE_ADDR     = 0x00006800,
    MODULE_NPPU_OAM_INT_IDX1_BASE_ADDR     = 0x00007000,

    /* PPU         */
    MODULE_PPU_CSR_BASE_ADDR         = 0x00000000,
    MODULE_PPU_DBG_BASE_ADDR         = 0x00000800,
    MODULE_CLUSTER0_BASE_ADDR        = 0x00008000,
    MODULE_CLUSTER1_BASE_ADDR        = 0x00010000,
    MODULE_CLUSTER2_BASE_ADDR        = 0x00018000,
    MODULE_CLUSTER3_BASE_ADDR        = 0x00020000,

    /* TM          */
    MODULE_TM_CFGMT_BASE_ADDR        = 0x00000000,
    MODULE_TM_OLIF_BASE_ADDR         = 0x00020000,
    MODULE_TM_CGAVD_BASE_ADDR        = 0x00030000,
    MODULE_TM_TMMU_BASE_ADDR         = 0x00040000,
    MODULE_TM_SHAP_BASE_ADDR         = 0x00050000,
    MODULE_TM_CRDT_BASE_ADDR         = 0x00060000,
    MODULE_TM_QMU_BASE_ADDR          = 0x00070000,

    /* STAT        */
    MODULE_STAT_CAR0_BASE_ADDR       = 0x00000000,
    MODULE_STAT_ETCAM_BASE_ADDR      = 0x00002000,
    MODULE_STAT_GLBL_BASE_ADDR       = 0x00003000,

    /* SE          */
    MODULE_SE_ALG_BASE_ADDR          = 0x00000000,         
    MODULE_SE_KSCHD_BASE_ADDR        = 0x00004000,        
    MODULE_SE_RSCHD_BASE_ADDR        = 0x00008000,         
    MODULE_SE_PARSER_BASE_ADDR       = 0x0000c000,        
    MODULE_SE_AS_BASE_ADDR           = 0x00010000,        
    MODULE_SE_CFG_BASE_ADDR          = 0x00014000, 
    
    /* SMMU0          */
    MODULE_SE_SMMU0_BASE_ADDR        = 0x00000000,         

    /* SMMU1          */
    MODULE_SE_SMMU1_BASE_ADDR        = 0x00000000,         
    MODULE_SE_CMMU_BASE_ADDR         = 0x00004000,    

    /* DTB          */
    MODULE_DTB_ENQ_BASE_ADDR        = 0x00000000,         
    MODULE_DTB_CFG_BASE_ADDR        = 0x01000000, 
    MODULE_DTB_DDOS_BASE_ADDR       = 0x01010000,
    MODULE_DTB_RAM_BASE_ADDR        = 0x01100000,

    /* TRPG          */
    MODULE_TRPG_RX_BASE_ADDR                = 0x00000000,         
    MODULE_TRPG_TX_BASE_ADDR                = 0x00400000, 
    MODULE_TRPG_TX_GLB_BASE_ADDR            = 0x00600000,
    MODULE_TRPG_TX_ETM_PORT_BASE_ADDR       = 0x00610000,
    MODULE_TRPG_RX_RAM_BASE_ADDR            = 0x00200000,
    MODULE_TRPG_TX_RAM_BASE_ADDR            = 0x00620000,
    MODULE_TRPG_TX_ETM_RAM_BASE_ADDR        = 0x00710000,
    MODULE_TRPG_TX_TODTIME_RAM_BASE_ADDR    = 0x00720000,
    


    /* TSN          */
    MODULE_TSN_PORT0_BASE_ADDR      = 0x00000000,
    MODULE_TSN_PORT1_BASE_ADDR      = 0x00004000,
    MODULE_TSN_PORT2_BASE_ADDR      = 0x00008000,
    MODULE_TSN_PORT3_BASE_ADDR      = 0x0000C000,
      
} MODULE_BASE_ADDR_E;

DPP_STATUS dpp_tm_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_module_name_get(ZXIC_UINT32 module_no, ZXIC_CHAR *p_name);

DPP_STATUS dpp_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);

#if ZXIC_REAL("TM")
ZXIC_VOID dpp_tm_reg_cap_flag_set(BOOL en);
DPP_STATUS dpp_module_get_tm_baseaddr(ZXIC_UINT32 module_id, ZXIC_UINT32 *p_baseaddr);
DPP_STATUS dpp_tm_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_tm_output_print(ZXIC_UINT32 module_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_tm_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_tm_print32(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 addr);
DPP_STATUS dpp_tm_write32(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 addr, ZXIC_UINT32 data);
DPP_STATUS dpp_tm_ind_is_idle(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id);
DPP_STATUS dpp_tm_ind_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 addr, ZXIC_UINT32* p_data);
DPP_STATUS dpp_tm_ind_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 addr, ZXIC_UINT32* p_data);
DPP_STATUS dpp_tm_ind_write32(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 addr, ZXIC_UINT32 data);
DPP_STATUS dpp_tm_ind_print32(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 addr);
DPP_STATUS dpp_etm_cfgmt_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_cfgmt_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_olif_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_olif_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_cgavd_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_cgavd_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_tmmu_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_tmmu_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_shap_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_shap_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_shap_ind_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_shap_ind_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_crdt_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_crdt_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_crdt_ind_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_crdt_ind_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_qmu_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_etm_qmu_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
#endif


DPP_STATUS dpp_module_get_se_alg_baseaddr(ZXIC_UINT32 *p_baseaddr);
DPP_STATUS dpp_se_alg_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_se_alg_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_se_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr);
DPP_STATUS dpp_se_wr(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 data);

DPP_STATUS dpp_se_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_se_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_se_smmu0_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_se_smmu0_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_se_smmu0_print32(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr);
DPP_STATUS dpp_se_smmu0_write32(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 data);

DPP_STATUS dpp_ppu_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_ppu_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_ppu_print32(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr);
DPP_STATUS dpp_ppu_write32(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 data);

DPP_STATUS dpp_stat_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_stat_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_stat_print32(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr);
DPP_STATUS dpp_stat_write32(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 data);

DPP_STATUS dpp_stat_car0_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_stat_car0_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_stat_car0_print32(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr);
DPP_STATUS dpp_stat_car0_write32(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 data);

DPP_STATUS dpp_pbu_cfg_memid_0_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_cfg_memid_0_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_cfg_memid_1_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_cfg_memid_1_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_stat_memid_1_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_stat_memid_1_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_stat_memid_2_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_stat_memid_2_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_stat_memid_3_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_stat_memid_3_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_stat_memid_4_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_stat_memid_4_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_stat_memid_5_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_pbu_stat_memid_5_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_idma_stat_memid_0_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_idma_stat_memid_0_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_idma_stat_memid_1_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_idma_stat_memid_1_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);

DPP_STATUS dpp_oam_cfg_indir_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);
DPP_STATUS dpp_oam_cfg_indir_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 *p_data);

#ifdef __cplusplus
}
#endif

#endif



