/**************************************************************
* Ȩ (C)2013-2019, ͨѶɷ޹˾
* ļ : dpp_dtb_diag.c
* ļʶ : 
* ժҪ : 
* ˵ : 
* ǰ汾 : 
*        : zab
*  : 2022/08/30
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/
#ifndef _DPP_DTB_DIAG_H_
#define _DPP_DTB_DIAG_H_

#include "dpp_stat_api.h"

#ifdef __cplusplus
extern "C" {
#endif

#if ZXIC_REAL("DTB")
/***********************************************************/
/** ӡָĿACKϢ
* @param   dev_id       оƬid  
* @param   queue_id     кţΧ0-127   
* @param   dir_flag     ,0-down,1-up    
* @param   index        Ŀ 
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2022/08/30
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_item_ack_prt(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 dir_flag,
                    ZXIC_UINT32 index);

/***********************************************************/
/** ӡָĿBUFF
* @param   dev_id       оƬid  
* @param   queue_id     кţΧ0-127   
* @param   dir_flag     ,0-down,1-up    
* @param   index        Ŀ  
* @param   len          ȡݳ 
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2022/08/30
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_item_buff_prt(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 dir_flag,
                    ZXIC_UINT32 index, 
                    ZXIC_UINT32 len);

/***********************************************************/
/** ӡһдʹõԪر
* @param   dev_id               豸ţֶ֧оƬ
* @param   queue_id             кţΧ0-127 
* @param   p_element_id         Ŀ 
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/04/26
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_tab_down_element_id_prt(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 queue_id);

/***********************************************************/
/** ӡһдʹõdumpԪر
* @param   dev_id               豸ţֶ֧оƬ
* @param   queue_id             кţΧ0-127 
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/04/26
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_tab_dump_element_id_prt(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 queue_id);
/***********************************************************/
/** ӡ±ָԪصĵַACK±ǰ768bit
* @param   dev_id       оƬid  
* @param   queue_id     кţΧ0-127    
* @param   element_id   ԪغţΧ0-31  
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2022/08/30
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_down_table_element_info_prt(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 element_id);

/***********************************************************/
/** ӡָԪصdumpַACK±ǰ768bit
* @param   dev_id       оƬid  
* @param   queue_id     кţΧ0-127    
* @param   element_id   ԪغţΧ0-31  
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2022/08/30
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_dump_table_element_info_prt(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 element_id);                   

/***********************************************************/
/** ָĿBUFFָд
* @param   dev_id       оƬid  
* @param   queue_id     кţΧ0-128   
* @param   dir_flag     ,0-down,1-up    
* @param   index        Ŀ        
* @param   data         д,ڲи
* @param   len          дݳ 
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2022/08/30
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_item_buff_wr(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 dir_flag,
                    ZXIC_UINT32 index,
                    ZXIC_UINT32 data,
                    ZXIC_UINT32 len);

/***********************************************************/
/** dtb userϢ
* @param   dev_id       оƬid  
* @param   queue_id     кţΧ0-127  
* @param   ep_no        ep    
* @param   pf_no        pf         
* @param   vf_no        vf 
* @param   vf_active    vf flag 
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_user_info_wr(ZXIC_UINT32 dev_id, 
                                      ZXIC_UINT32 queue_id, 
                                      ZXIC_UINT32 ep_no, 
                                      ZXIC_UINT32 pf_no, 
                                      ZXIC_UINT32 vf_no, 
                                      ZXIC_UINT32 vf_active );

/***********************************************************/
/** ӡеԵϢ
* @param   dev_id               豸ţֶ֧оƬ
* @param   vport                vport 
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/04/22
************************************************************/
ZXIC_UINT32 diag_dpp_vport_to_ep(ZXIC_UINT32 dev_id, 
                                 ZXIC_UINT32 vport);

/***********************************************************/
/** ӡеԵϢ
* @param   dev_id               豸ţֶ֧оƬ
* @param   queue_id             кţΧ0-127 
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_all_info_prt(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id);

/***********************************************************/
/** ͨϢ
* @param   dev_id               豸ţֶ֧оƬ
* @param   queue_id             кţΧ0-128 
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/02/27
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_channel_cfg_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 queue_id);

/***********************************************************/
/** ӡdtbϢ
* @param   dev_id               豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/01/22
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_queue_lock_info_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡaxis/aximͨݵģʽ
* @param   dev_id               豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/03/29
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_axis_axim_convert_mode_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡṹеϢ
* @param   dev_id               豸ţֶ֧оƬ
* @param   queue_id             кţΧ0-128 
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_mgr_info_prt(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id);

/***********************************************************/
/** ӡdtbģϢ
* @param   dev_id               豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_module_cfg_info_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡdtbͳϢ
* @param   dev_id               豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_multi_info_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡdtb traf ctrl ram е
* @param   dev_id             豸ţֶ֧оƬ
* @param   traf_ctrl_ram_num  ram 0-5
* @param   offset             ƫram0-40-255   ram50-63
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_ram_data_prt(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 traf_ctrl_ram_num,
                                                ZXIC_UINT32 offset);

/***********************************************************/
/**  ӡtraf_ctrl_ram  
* @param   dev_id             豸ţֶ֧оƬ
* @param   traf_ctrl_ram_num  ram 0-5 0:smmu1;1:zcam;2:etcam;3:etcam dump;4:hash;5:smmu0
* @param   offset             ƫ 128bitΪλ
* @param   depth              
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_ram_data_block_prt(ZXIC_UINT32 dev_id,
                                                     ZXIC_UINT32 traf_ctrl_ram_num,
                                                     ZXIC_UINT32 offset,
                                                     ZXIC_UINT32 depth);

/***********************************************************/
/** ӡdtb traf ctrl ram еsmmu1еݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_smmu1_ram_data_1024bit_prt(ZXIC_UINT32 dev_id,
                                                              ZXIC_UINT32 index);

/***********************************************************/
/** ӡdtb traf ctrl ram еsmmu1еݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_smmu1_ram_data_prt_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡdtb traf ctrl ram еzcamеݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_zcam_ram_data_1024bit_prt(ZXIC_UINT32 dev_id,
                                                              ZXIC_UINT32 index);

/***********************************************************/
/** ӡdtb traf ctrl ram еzcamеݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_zcam_ram_data_prt_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡdtb traf ctrl ram еetcamеݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_etcam_ram_data_1024bit_prt(ZXIC_UINT32 dev_id,
                                                              ZXIC_UINT32 index);

/***********************************************************/
/** ӡdtb traf ctrl ram еetcamеݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_etcam_ram_data_prt_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡdtb traf ctrl ram еetcam dumpеݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_etcam_dump_ram_data_1024bit_prt(ZXIC_UINT32 dev_id,
                                                                   ZXIC_UINT32 index);

/***********************************************************/
/** ӡdtb traf ctrl ram еetcam dumpеݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_etcam_dump_ram_data_prt_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡdtb traf ctrl ram еhashеݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_hash_ram_data_1024bit_prt(ZXIC_UINT32 dev_id,
                                                              ZXIC_UINT32 index);

/***********************************************************/
/** ӡdtb traf ctrl ram еhashеݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_hash_ram_data_prt_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡdtb traf ctrl ram еsumm0еݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    256bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_smmu0_ram_data_256bit_prt(ZXIC_UINT32 dev_id,
                                                              ZXIC_UINT32 index);
/***********************************************************/
/** ӡdtb traf ctrl ram еsumm0еݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_smmu0_ram_data_prt_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡdtb traf ctrl ram е
* @param   dev_id             豸ţֶ֧оƬ
* @param   traf_ctrl_ram_num  ram 0-5
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_ram_data_prt_all(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 traf_ctrl_ram_num);
                                    
      /***********************************************************/
/** ӡdump pd ram е
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ0-2047
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_dump_pd_ram_data_prt(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 offset);

/***********************************************************/
/**  ӡdump pd ram  
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ 128bitΪλ
* @param   depth              1-512
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_dump_pd_ram_data_block_prt(ZXIC_UINT32 dev_id,
                                                     ZXIC_UINT32 offset,
                                                     ZXIC_UINT32 depth);

/***********************************************************/
/** ӡdump pd ram е
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_dump_pd_ram_data_prt_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡrd ctrl ram е
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ0-4095
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_rd_ctrl_ram_data_prt(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 offset);

/***********************************************************/
/**  ӡrd ctrl_ram  
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ 128bitΪλ
* @param   depth               1 - 1024
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_rd_ctrl_ram_data_block_prt(ZXIC_UINT32 dev_id,
                                                     ZXIC_UINT32 offset,
                                                     ZXIC_UINT32 depth);

/***********************************************************/
/**  ӡrd ctrl_ram  
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0 -127
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_rd_ctrl_ram_data_1024bit_prt(ZXIC_UINT32 dev_id,
                                                      ZXIC_UINT32 index);

/***********************************************************/
/** ӡrd ctrl ram е
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_rd_ctrl_ram_data_prt_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡrd table ram е
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ0-4095
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_rd_table_ram_data_prt(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 offset);

/***********************************************************/
/**  ӡrd table ram  
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ 128bitΪλ
* @param   depth              1-4096
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_rd_table_ram_data_block_prt(ZXIC_UINT32 dev_id,
                                                     ZXIC_UINT32 offset,
                                                     ZXIC_UINT32 depth);

/***********************************************************/
/** ӡrd ctrl ram е
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_rd_table_ram_data_prt_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡcmd man ram е
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ0-4095
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_cmd_man_ram_data_prt(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 offset);

/***********************************************************/
/**  ӡcmd man ram 
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ 128bitΪλ
* @param   depth              1-4096
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_cmd_man_ram_data_block_prt(ZXIC_UINT32 dev_id, 
                                                    ZXIC_UINT32 offset, 
                                                    ZXIC_UINT32 depth);

/***********************************************************/
/**  ӡcmd man ram 
* @param   dev_id             豸ţֶ֧оƬ
* @param   queue_id           к0-127
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_cmd_man_ram_data_queue_prt(ZXIC_UINT32 dev_id, 
                                                    ZXIC_UINT32 queue_id);

/***********************************************************/
/** ӡrd ctrl ram е
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_cmd_man_ram_data_prt_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/**dtb traf ctrl ram еsmmu1еݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_smmu1_ram_data_1024bit_clr(ZXIC_UINT32 dev_id,
                                                              ZXIC_UINT32 index);

/***********************************************************/
/** dtb traf ctrl ram еsmmu1еݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_smmu1_ram_data_clr_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** dtb traf ctrl ram еzcamеݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_zcam_ram_data_1024bit_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);

/***********************************************************/
/** dtb traf ctrl ram еzcamеݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_zcam_ram_data_clr_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** dtb traf ctrl ram еetcamеݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_etcam_ram_data_1024bit_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);

/***********************************************************/
/** dtb traf ctrl ram еetcamеݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_etcam_ram_data_clr_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** dtb traf ctrl ram еetcam dumpеݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_etcam_dump_ram_data_1024bit_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);

/***********************************************************/
/** dtb traf ctrl ram еetcam dumpеݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_etcam_dump_ram_data_clr_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** dtb traf ctrl ram еhashеݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_hash_ram_data_1024bit_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);

/***********************************************************/
/** dtb traf ctrl ram еhashеݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_hash_ram_data_clr_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** dtb traf ctrl ram еsmmu0еݣ
* @param   dev_id   豸ţֶ֧оƬ
* @param   index    1024bitΪλƫ 0-7
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_smmu0_ram_data_256bit_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 index);

/***********************************************************/
/** dtb traf ctrl ram еsmmu0еݣ
* @param   dev_id   豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2023/06/13
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_traf_ctrl_smmu0_ram_data_clr_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 128bitΪλdump pd ram  
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ 0-511
*
* @return  
* @remark  
* @see     
* @author cbb      @date  2024/03/05
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_dump_pd_ram_data_block_clr(ZXIC_UINT32 dev_id,ZXIC_UINT32 offset);

/***********************************************************/
/** dump pd ram е
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author cbb      @date  2024/03/05
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_dump_pd_ram_data_clr_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 1024bitΪλrd ctrl ram  
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ 0-127
*
* @return  
* @remark  
* @see     
* @author cbb      @date  2024/03/05
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_rd_ctrl_ram_data_block_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 offset);

/***********************************************************/
/** rd ctrl ram е
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author cbb      @date  2024/03/05
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_rd_ctrl_ram_data_clr_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 128bitΪλrd table ram  
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ 0-2047
*
* @return  
* @remark  
* @see     
* @author cbb      @date  2024/03/05
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_rd_table_ram_data_block_clr(ZXIC_UINT32 dev_id,
                                                     ZXIC_UINT32 offset);

/***********************************************************/
/** rd table ram е
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author cbb      @date  2024/03/05
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_rd_table_ram_data_clr_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 128bitΪλcmd man ram  
* @param   dev_id             豸ţֶ֧оƬ
* @param   offset             ƫ 0-4095
*
* @return  
* @remark  
* @see     
* @author cbb      @date  2024/03/05
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_cmd_man_ram_data_block_clr(ZXIC_UINT32 dev_id, 
                                                    ZXIC_UINT32 offset);

/***********************************************************/
/** ԶΪλcmd man ram  
* @param   dev_id             豸ţֶ֧оƬ
* @param   queue_id           к0-127
*
* @return  
* @remark  
* @see     
* @author cbb      @date  2024/03/05
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_cmd_man_ram_data_queue_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 queue_id);

/***********************************************************/
/** ȫcmd man ram  
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author cbb      @date  2024/03/05
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_cmd_man_ram_data_clr_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡ±صram 
* @param   dev_id             豸ţֶ֧оƬ
* @param   queue_id           к
*
* @return  
* @remark  
* @see     
* @author cbb      @date  2024/03/05
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_down_table_ram_prt_all(ZXIC_UINT32 dev_id, ZXIC_UINT32 queue_id);

/***********************************************************/
/** ӡdumpصram 
* @param   dev_id             豸ţֶ֧оƬ
* @param   queue_id           к
*
* @return  
* @remark  
* @see     
* @author cbb      @date  2024/03/05
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_dump_table_ram_prt_all(ZXIC_UINT32 dev_id, ZXIC_UINT32 queue_id);

/***********************************************************/
/** ȫdtb debug ram data
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  10345337      @date  2023/10/9
************************************************************/
DPP_STATUS diag_dpp_dtb_ram_data_clr_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** smmu1 traf ram check
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_dtb_traf_ctrl_smmu1_ram_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** zcam traf ram check
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_dtb_traf_ctrl_zcam_ram_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** etcam traf ram check
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_dtb_traf_ctrl_etcam_ram_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** etcam dump traf ram check
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_dtb_traf_ctrl_etcam_dump_ram_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** hash traf ram check
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_dtb_traf_ctrl_hash_ram_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** smmu0 traf ram check
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_dtb_traf_ctrl_smmu0_ram_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** dump pd ram check
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_dtb_dump_pd_ram_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** rd ctrl ram check
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_dtb_rd_ctrl_ram_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** rd table ram check
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_dtb_rd_table_ram_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** cmd man ram check
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_dtb_cmd_man_ram_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** dtb ram check all
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2024/03/15
************************************************************/
DPP_STATUS diag_dpp_dtb_ram_check_all(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ȡ˿os
* @param   dev_id             豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  10345337      @date  2023/10/9
************************************************************/
DPP_STATUS diag_dpp_dtb_aximr_os_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** tab upԺ
* @param   dev_id               豸ţֶ֧оƬ
* @param   queue_id             кţΧ0-128 
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2022/08/30
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_tab_up_rcv(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id);

/***********************************************************/
/** tab downԺ
* @param   dev_id               豸ţֶ֧оƬ
* @param   queue_id             кţΧ0-128 
* @param   data_len             ݳ 
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2022/08/30
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_tab_down_send(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 data_len);

#if ZXIC_REAL("DTB_TABLE")

/*dtbдeramֱӱдַ16bitε16biΪд+1ĵ16bit*/
/***********************************************************/
/** dtb erma
* @param   dev_id
* @param   queue_id,        ͨ
* @param   base_addr        ַ 128bitΪλ
* @param   smmu0_wrt_mode         дλģʽ 0-128bit  1-64bit  2-1bi
* @param   start_index            ʼindexindexղ1ۼ
* @param   add_number       ӱȣλΪλ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/11/21
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_smmu0_table_add(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 queue_id,
                                        ZXIC_UINT32 base_addr,
                                        ZXIC_UINT32 smmu0_wrt_mode,
                                        ZXIC_UINT32 start_index,
                                        ZXIC_UINT32 add_number);

/***********************************************************/
/** dtbͨDDR
* @param   dev_id          豸
* @param   queue_id        к
* @param   smmu0_base_addr smmu0ַ128bitΪλ
* @param   smmu0_wr_mode   smmu0дģʽοDPP_ERAM128_OPR_MODE_E֧128bit64bit1bitģʽ
* @param   start_index     flushʼĿ
* @param   entry_num       ·Ŀ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/11/21
************************************************************/
DPP_STATUS diag_dpp_dtb_smmu0_flush(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 queue_id,
                                    ZXIC_UINT32 smmu0_base_addr,
                                    ZXIC_UINT32 smmu0_wr_mode,
                                    ZXIC_UINT32 start_index,
                                    ZXIC_UINT32 entry_num);

/***********************************************************/
/** dtbͨDDR
* @param   dev_id
* @param   queue_id         к
* @param   rw_mode          дģʽ0-128bit1-256bit 2:512bit
* @param   ecc_en           eccʹ
* @param   base_addr        ַ 4K *128bit
* @param   index            дģʽΪλ
* @param   num              дĿ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/11/21
************************************************************/
DPP_STATUS diag_dpp_dtb_ddr_dir_tbl_ecc_add(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 queue_id,
                                        ZXIC_UINT32 rw_mode,
                                        ZXIC_UINT32 ecc_en,
                                        ZXIC_UINT32 base_addr,
                                        ZXIC_UINT32 index,
                                        ZXIC_UINT32 num);

/***********************************************************/
/** ȶDDRȡдıǷȣҰѱȽϽӡ
* @param   dev_id      豸
* @param   queue_id    к
* @param   base_addr   ַλ2k*256bit
* @param   rd_mode     0:128bit 1:256bit 2:512bit
* @param   index       modeΪλ
* @param   add_number  Ƚϵ
*
* @return
* @remark  
* @see
* @author  cbb      @date  2024/2/2
* @note    ԤڵĻÿԪصֵӦΪǰԪ±֮
************************************************************/
DPP_STATUS diag_dpp_dtb_ddr_dir_table_compare(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 queue_id,
                                              ZXIC_UINT32 base_addr,
                                              ZXIC_UINT32 rd_mode,
                                              ZXIC_UINT32 index,
                                              ZXIC_UINT32 add_number);

/***********************************************************/
/** dtbͨдZCAMռ䣬д512bitֵߺ32bitֵΪ0
* @param   dev_id
* @param   queue_id         к
* @param   addr             zcamַ
* @param   data0            512bit32bit
* @param   num              дĿ204
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/11/21
************************************************************/
DPP_STATUS diag_dpp_dtb_se_alg_write512(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 queue_id,
                                        ZXIC_UINT32 base_addr,
                                        ZXIC_UINT32 data0,
                                        ZXIC_UINT32 num);

/***********************************************************/
/** ʹdtbָblockĿ(640bitΪλ)
ݸʽ:16bit(block_id) +  32bit(etcam_row)  + 32bit(handle)
* @param   dev_id
* @param   block_id
* @param   entry_num ӵĿ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/11/03
************************************************************/
DPP_STATUS diag_dpp_dtb_se_etcam_block_entry_add_640(ZXIC_UINT32 dev_id, 
                                                ZXIC_UINT32 queue_id, 
                                                ZXIC_UINT16 block_id, 
                                                ZXIC_UINT32 entry_num);

/***********************************************************/
/** DTB ģ΢hashǰsdt׼
* @param   dev_id           豸
* @param   hash_id          hashid
* @param   hash_table_width hash 洢λμDPP_DIAG_HASH_KEY_WIDTH_E
* @param   key_size         hash ֵȣֽΪλ
* @param   hash_table_id    hash ߼
* @param   learn_en         Ӳѧϰʹ
* @param   keep_alive       ־ʹ
* @param   keep_alive_baddr ־ַ
* @param   rsp_mode         λ,μDPP_DIAG_HASH_RSP_MODE_E
* @param   hash_clutch_en   ץʹ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2022/10/20
************************************************************/
DPP_STATUS diag_dpp_dtb_se_kschd_hash_sdt_info_wr(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 hash_id,
                                             ZXIC_UINT32 hash_table_width,
                                             ZXIC_UINT32 hash_key_size,
                                             ZXIC_UINT32 hash_table_id,
                                             ZXIC_UINT32 learn_en,
                                             ZXIC_UINT32 keep_alive,
                                             ZXIC_UINT32 keep_alive_baddr,
                                             ZXIC_UINT32 rsp_mode,
                                             ZXIC_UINT32 hash_clutch_en);

/***********************************************************/
/** DTB ģ΢дʽĿֵ8bit,16bit
*32bitݹɣ32bitݹ
* @param   dev_id
* @param   queue_id         к
* @param   dat8      8λ
* @param   dat16     16λ
* @param   dat32_0   32λ
* @param   dat32_1   32λ
* @param   num       Ŀ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2022/10/20
************************************************************/
DPP_STATUS diag_dpp_dtb_hash_simu_mcode_wr_mul_ex(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 queue_id,
                                              ZXIC_UINT32 dat8,
                                              ZXIC_UINT32 dat16,
                                              ZXIC_UINT32 dat32_0,
                                              ZXIC_UINT32 dat32_1,
                                              ZXIC_UINT32 num);


/***********************************************************/
/** dtbͨӡsmmu0б(128bitΪλ)
* @param   dev_id
* @param   queue_id       к
* @param   base_addr      128bitλĻַ
* @param   index          128bitλindex
* @param   depth          1-1024
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2022/10/20
************************************************************/
DPP_STATUS diag_dpp_dtb_smmu0_read(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 queue_id,
                                  ZXIC_UINT32 base_addr,
                                  ZXIC_UINT32 index,
                                  ZXIC_UINT32 depth);

/***********************************************************/
/** DTB ERAMд128bit
* @param   dev_id       豸
* @param   queue_id     к
* @param   base_addr    ַ
* @param   index        
* @param   data0        λ
* @param   data1        ݴθλ
* @param   data2        ݴελ
* @param   data3        λ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2024/01/23
************************************************************/
DPP_STATUS diag_dpp_dtb_smmu0_write_128(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 queue_id,
                                       ZXIC_UINT32 base_addr,
                                       ZXIC_UINT32 index,
                                       ZXIC_UINT32 data0,
                                       ZXIC_UINT32 data1,
                                       ZXIC_UINT32 data2,
                                       ZXIC_UINT32 data3);

/***********************************************************/
/** dtbͨӡsmmu0б128bit
* @param   dev_id
* @param   queue_id       к
* @param   base_addr      128bitλĻַ
* @param   index          128bitλindex
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2024/1/22
************************************************************/
DPP_STATUS diag_dpp_dtb_smmu0_read_128(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 queue_id,
                                       ZXIC_UINT32 base_addr,
                                       ZXIC_UINT32 index);

/***********************************************************/
/** DTB ERAMд64bit
* @param   dev_id       豸
* @param   queue_id     к
* @param   base_addr    ַ
* @param   index        ֵ
* @param   data0        ݸλ
* @param   data1        ݵλ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2024/01/23
************************************************************/
DPP_STATUS diag_dpp_dtb_smmu0_write_64(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 queue_id,       
                                      ZXIC_UINT32 base_addr,
                                      ZXIC_UINT32 index,
                                      ZXIC_UINT32 data0,
                                      ZXIC_UINT32 data1);

/***********************************************************/
/** dtbͨӡsmmu0б64bit
* @param   dev_id
* @param   queue_id       к
* @param   base_addr      128bitλĻַ
* @param   index          64bitλindex
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2024/1/22
************************************************************/
DPP_STATUS diag_dpp_dtb_smmu0_read_64(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 queue_id,
                                       ZXIC_UINT32 base_addr,
                                       ZXIC_UINT32 index);

/***********************************************************/
/** DTB ERAMд1bit
* @param   dev_id       豸
* @param   queue_id     к
* @param   base_addr    ַ
* @param   index        ֵ
* @param   data         ݣֵΧΪ[0,1],1λضϣȡλ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ˶10181552      @date  2016/01/16
************************************************************/
DPP_STATUS diag_dpp_dtb_smmu0_write_1(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 queue_id,
                                     ZXIC_UINT32 base_addr,
                                     ZXIC_UINT32 index,
                                     ZXIC_UINT32 data);

/***********************************************************/
/** dtbͨӡsmmu0б1bit
* @param   dev_id
* @param   queue_id       к
* @param   base_addr      128bitλĻַ
* @param   index          1bitλindex
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2024/1/22
************************************************************/
DPP_STATUS diag_dpp_dtb_smmu0_read_1(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 queue_id,
                                     ZXIC_UINT32 base_addr,
                                     ZXIC_UINT32 index); 

/***********************************************************/
/** dtbͨӡsmmu0statֵ
* @param   dev_id
* @param   queue_id       к
* @param   base_addr      128bitλĻַ
* @param   index          64bitλindex
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2024/1/22
************************************************************/
DPP_STATUS diag_dpp_dtb_stat_smmu0_read(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 queue_id,
                                        ZXIC_UINT32 base_addr,
                                        ZXIC_UINT32 index);

/***********************************************************/
/** dtbͨӡsmmu1statֵ
* @param   dev_id
* @param   queue_id       к
* @param   cmmu_addr      2k*256bitλĻַ
* @param   ppu_ddr_addr   128bitλĵַƫ
* @param   index          64bitλindex
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2024/1/22
************************************************************/
DPP_STATUS diag_dpp_dtb_stat_smmu1_read(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 queue_id,
                                        ZXIC_UINT32 cmmu_addr,
                                        ZXIC_UINT32 ppu_ddr_addr,
                                        ZXIC_UINT32 index);

/***********************************************************/
/** dtbͨӡsmmu1statֵ
* @param   dev_id           豸
* @param   queue_id         к
* @param   rd_mode          ȡλģʽμSTAT_CNT_MODE_E0-64bit1-128bit
* @param   index            λμrd_mode
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cq     @date  2024/1/22
************************************************************/
DPP_STATUS diag_dpp_dtb_stat_ppu_cnt_get(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 queue_id,
                                        STAT_CNT_MODE_E rd_mode,
                                        ZXIC_UINT32 index);

/***********************************************************/
/** ȡDDR ֵַ (512bitΪλ)
* @param   dev_id   豸
* @param   queue_id   豸
* @param   base_addr  ddrַ1k * 512bitΪλ
* @param   start_index   ʼindex Ϊ512bitΪλ
* @param   depth 1-256
*
* @return
* @remark  
* @see
* @author  쳿 @date 20160824
* @note
************************************************************/
DPP_STATUS diag_dpp_dtb_ddr_dir_table_read(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 queue_id,
                                             ZXIC_UINT32 base_addr,
                                             ZXIC_UINT32 start_index,
                                             ZXIC_UINT32 depth);

/***********************************************************/
/** dtbͨӡsmmu1б512bit
* @param   dev_id
* @param   queue_id       к
* @param   base_addr      ddrַ1k * 512bitΪλ
* @param   index          512bitλindex
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2024/1/22
************************************************************/
DPP_STATUS diag_dpp_dtb_smmu1_read_512(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 queue_id,
                                       ZXIC_UINT32 base_addr,
                                       ZXIC_UINT32 index);

/***********************************************************/
/** dtbͨӡsmmu1б256bit
* @param   dev_id
* @param   queue_id       к
* @param   base_addr      ddrַ1k * 512bitΪλ
* @param   index          256bitλindex
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2024/1/22
************************************************************/
DPP_STATUS diag_dpp_dtb_smmu1_read_256(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 queue_id,
                                       ZXIC_UINT32 base_addr,
                                       ZXIC_UINT32 index);

/***********************************************************/
/** dtbͨӡsmmu1б128bit
* @param   dev_id
* @param   queue_id       к
* @param   base_addr      ddrַ1k * 512bitΪλ
* @param   index          128bitλindex
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb     @date  2024/1/22
************************************************************/
DPP_STATUS diag_dpp_dtb_smmu1_read_128(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 queue_id,
                                       ZXIC_UINT32 base_addr,
                                       ZXIC_UINT32 index);

/***********************************************************/
/** dtbͨZCAMռ
* @param   dev_id
* @param   queue_id         к
* @param   addr             zcamַ(λ512bit)
* @param   tb_width         ݿ 0:128bit  1:256bit  2:512bit
* @param   depth            depth 
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/11/21
************************************************************/
DPP_STATUS diag_dpp_dtb_zcam_read(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 queue_id,
                                  ZXIC_UINT32 addr,
                                  ZXIC_UINT32 tb_width,
                                  ZXIC_UINT32 depth);

/***********************************************************/
/** dtbͨZCAMռ䣬ȡ512bitֵ
* @param   dev_id
* @param   queue_id         к
* @param   addr             zcamַ
* @param   depth            depth 1-256
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/11/21
************************************************************/
DPP_STATUS diag_dpp_dtb_se_alg_read512(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 queue_id,
                                        ZXIC_UINT32 addr,
                                        ZXIC_UINT32 depth);

/***********************************************************/
/** dtb algӶȽϺ
* @param   dev_id
* @param   queue_id         к
* @param   addr             zcamַ(λ512bit)
* @param   data             Ƚ
* @param   tb_width         ݿ 0:128bit  1:256bit  2:512bit
* @param   depth            Ƚϵĸ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2022/11/21
************************************************************/
DPP_STATUS diag_dpp_dtb_se_alg_read_compare(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 queue_id,
                                           ZXIC_UINT32 addr,
                                           ZXIC_UINT32 data,
                                           ZXIC_UINT32 tb_width,
                                           ZXIC_UINT32 depth);

/***********************************************************/
/** ӡeTcamblockڵӲĿ
* @param   dev_id     豸
* @param   block_idx  blockΧ0~7
* @param   index      ҵĿڵǰblockе
* @param   mode       ֵλģʽȡֵ DPP_ETCAM_ENTRY_MODE_E Ķ
* @param   opr_type   ȡͣȡֵ DPP_ETCAM_OPR_TYPE_E Ķ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wcl      @date  2016/01/18
************************************************************/
DPP_STATUS diag_dpp_dtb_etcam_entry_read(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 queue_id, 
                                       ZXIC_UINT32 block_idx,
                                       ZXIC_UINT32 index,
                                       ZXIC_UINT32 mode,
                                       ZXIC_UINT32 data_or_mask,
                                       ZXIC_UINT32 depth);                                       
#endif
#endif

#if ZXIC_REAL("DMA")
/***********************************************************/
/** ӡBDĿϢ
* @param   dev_id       оƬid  
* @param   bd_index     bd    
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dma_bd_item_prt(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 bd_index);


/***********************************************************/
/** ӡBDĿָBUFF
* @param   device_id    оƬid  
* @param   bd_index     bd    
* @param   len          ȡݳ 
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dma_bd_buff_prt(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 bd_index, 
                    ZXIC_UINT32 len);

ZXIC_UINT32 diag_dpp_dma_bd_buff_set(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 bd_index, 
                    ZXIC_UINT32 len,
                    ZXIC_UINT8 data);

ZXIC_UINT32 diag_dpp_dma_data_parse(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡBDԵϢ
* @param   dev_id            豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dma_bd_all_info_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡṹϢ
* @param   dev_id            豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dma_mgr_info_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ͨܲԺ
* @param   dev_id            豸ţֶ֧оƬ
*
* @return  
* @remark  
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 diag_dpp_dma_ch_data_rcv(ZXIC_UINT32 dev_id);

#endif

#if ZXIC_REAL("INT")
/***********************************************************/
/** ӡdtbжѡMSIXʹϢ
* @param   dev_id       оƬid  
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2022/11/11
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_int_info_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡdtb жϢ
* @param   dev_id       оƬid  
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2022/11/11
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_finish_int_info_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 queue_id);

/***********************************************************/
/** ӡdtb 128жϢ
* @param   dev_id       оƬid  
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2022/11/11
************************************************************/
ZXIC_UINT32 dpp_dtb_finish_interrupt_event_state_prt_all(ZXIC_UINT32 dev_id);


/***********************************************************/
/**  dtb 128жϢ
* @param   dev_id       оƬid  
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2022/11/11
************************************************************/
ZXIC_UINT32 dpp_dtb_finish_interrupt_event_state_clr_all(ZXIC_UINT32 dev_id);
#endif


#if ZXIC_REAL("DTB_DOORBELL_ADDR")
/***********************************************************/
/** ӡEP doorbellַ
* @param   dev_id       оƬid  
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2022/11/11
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_ep_doorbell_addr_info_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 ep_id);

#endif

#if ZXIC_REAL("DTB_DEBUG")
/***********************************************************/
/** ӡDTB debugģʽϢ
* @param   dev_id       оƬid  
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2022/11/11
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_debug_mode_info_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ͨͳƴӡ
* @param   dev_id       оƬid  
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2022/11/11
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_channels_axi_resp_err_cnt_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** AXIMһβϢ¼ӡ
* @param   dev_id       оƬid  
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2022/11/11
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_axi_last_operate_info_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DTB ±ͳϢȡ
* @param   dev_id       оƬid  
* @param   clr          ͳϢ 1 0
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2022/11/11
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_wr_table_cnt_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DTB dumpͳϢȡ
* @param   dev_id       оƬid  
* @param   clr          ͳϢ 1 0
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2022/11/11
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_dump_table_cnt_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DTB ͨ״̬Ϣȡ
* @param   dev_id       оƬid  
*
* @return  
* @remark  
* @see     
* @author  cbb      @date  2022/11/11
************************************************************/
ZXIC_UINT32 diag_dpp_dtb_channels_state_info_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** dtb ģͳƺͶϢӡ
* @param   dev_id    豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cbb      @date  2024/02/27
************************************************************/
DPP_STATUS diag_dpp_dtb_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 queue_id);

/***********************************************************/
/** dtbʽzcamռ
* @param   dev_id    豸
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  cq      @date  2024/05/09
************************************************************/
DPP_STATUS diag_dpp_dtb_zcam_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 queue_id);

/***********************************************************/
/** DTBͨϢúб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author CBB      @date  2024.01.27
************************************************************/
DPP_STATUS dpp_dtb_channel_info_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DTB stateúб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  CBB      @date  2024/01/27
************************************************************/
DPP_STATUS dpp_dtb_state_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DTB debug ramúб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  CBB      @date  2024/01/27
************************************************************/
DPP_STATUS dpp_dtb_debug_ram_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DTB smmu0úб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  CBB      @date  2024/01/27
************************************************************/
DPP_STATUS dpp_dtb_smmu0_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DTB ģ鳣úб
* @param   dev_id
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  CBB      @date  2024/01/27
************************************************************/
DPP_STATUS dpp_dtb_help(ZXIC_UINT32 dev_id);

DPP_STATUS diag_dpp_dtb_smmu0_stat_dump(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 queue_id,
                                      ZXIC_UINT32 index,
                                      ZXIC_UINT32 depth);

DPP_STATUS diag_dpp_dtb_smmu1_stat_dump(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 queue_id,
                                      ZXIC_UINT32 index,
                                      ZXIC_UINT32 depth);
#endif
#ifdef __cplusplus
}
#endif

#endif
