/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : npe_diag.h
* ļʶ : 
* ժҪ : оƬòԺͷļ
* ˵ : 
* ǰ汾 : 
*      : wcl
*  : 2015/05/29
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef _NPE_SIM_DIAG_H_
#define _NPE_SIM_DIAG_H_

#define MF_ZXIC_UINT8_LEN (256)

/*simʹõĵַҪ*/
#define NPE_SIM_NPPU_CNT_ADDR       (0XFFFFFF00)
#define NPE_SIM_PPU_CNT_ADDR         (0XFFFFFF10)
#define NPE_SIM_SE_CNT_ADDR          (0XFFFFFF20)
#define NPE_SIM_SOCKET_CNT_ADDR      (0XFFFFFF30)
#define NPE_SIM_DEBUG_LEVEL_ADDR     (0XFFFFFF40)
#define NPE_SIM_CORE_MAP_ADDR        (0XFFFFFF60)
#define NPE_SIM_OAM_CNT_ADDR         (0XFFFFFF70)
#define NPE_SIM_DIAG_PORT_PKTRXID    (0XFFFFFF90)
#define NPE_SIM_DIAG_VERSION         (0XFFFFFFA0)
#define NPE_SIM_LIF_RMON_FCS_CNT     (0XFFFFFFA4)
#define NPE_SIM_LIF_RX_RMON_CNT      (0XFFFFFFA8) // lif RX rmon ͳ
#define NPE_SIM_LIF_TX_RMON_CNT      (0XFFFFFFAC) // lif TX rmon ͳ
#define NPE_SIM_DEL_SE_TBL           (0XFFFFFFD0)
#define NPE_SIM_CFG_SET_ADDR         (0XFFFFFFF0)
#define NPE_SIM_SE_PRT_CFG_SET_ADDR   (0XFFFFFFF4)


#define DIAG_CNT_CLEAR          (0xffffffff)
#define PORT_NUM                     (282)

//ʹܼӶ˿ڹ
#define NPE_CAPTURE_RX_FILTER_BASEADDR  (0XFFFFF000)
#define NPE_CAPTURE_AFTER_PPU_IPORT_FILTER_BASEADDR  (0XFFFFF100)
#define NPE_CAPTURE_AFTER_PPU_EPORT_FILTER_BASEADDR  (0XFFFFF200)
#define NPE_CAPTURE_TX_FILTER_BASEADDR  (0XFFFFF300)
#define NPE_CAPTURE_AFTER_HDU_FILTER_BASEADDR  (0XFFFFF400)

//Чλ
#define NPE_RX_CAPTURE_INFO_BASEADDR  (0XFFFFF001)
#define NPE_AFTER_HDU_CAPTURE_INFO_BASEADDR  (0XFFFFF101)
#define NPE_AFTER_PPU_CAPTURE_INFO_BASEADDR  (0XFFFFF201)
#define NPE_TX_CAPTURE_INFO_BASEADDR  (0XFFFFF301)
//
#define NPE_RX_CAPTURE_PKT_BASEADDR  (0XFFFFF002)
#define NPE_AFTER_HDU_CAPTURE_PKT_BASEADDR  (0XFFFFF102)
#define NPE_AFTER_PPU_CAPTURE_PKT_BASEADDR  (0XFFFFF202)
#define NPE_TX_CAPTURE_PKT_BASEADDR  (0XFFFFF302)

typedef enum sim_cap_module_id_e
{
    SIM_MODULE_RX = 0,    
    SIM_MODULE_AFTER_HDU = 1,    
    SIM_MODULE_AFTER_PPU = 2,       
    SIM_MODULE_TX = 3,   
    SIM_MODULE_ID_NUM   
}SIM_CAP_MODULE_ID_E;

typedef struct sim_cap_pktrx_odma_info_t
{
    ZXIC_UINT32 vld;
    ZXIC_UINT32 input_port;
    ZXIC_UINT32 pkt_len;
} SIM_CAP_INFO_T;


typedef struct sim_cfg_info_t
{
    ZXIC_UINT32 pos;
    ZXIC_UINT32 len;
}SIM_CFG_INFO_T;

typedef enum 
{
    SIM_CFG_LOG_EN = 0,    
    SIM_CFG_INTERFACE_EN = 1,    
    SIM_CFG_LEVEL = 2,    
    SIM_CFG_OAM_EN = 3,    
    SIM_CFG_OAM_PKT_PRT_EN = 4,    
    SIM_CFG_INST_INFO_EN = 5,    
    SIM_CFG_AUTO_TEST_PKT_EN = 6,    
    SIM_CFG_INST_STAT_EN = 7  ,
    SIM_CFG_FIELD_NUM   ,
}sim_cfg_filed;

typedef struct sim_top_config_t
{
    ZXIC_UINT32 print_level;                //ӡȼ
    ZXIC_UINT32 log_en;
    ZXIC_UINT32 print_to_interface_en;
    ZXIC_UINT32 print_to_auto_test_pkt_en;
    ZXIC_UINT32 print_inst_info_en;
    ZXIC_UINT32 oam_en;
    ZXIC_UINT32 oam_pkt_prt_en;
    ZXIC_UINT32 inst_stat_en;
} SIM_TOP_CONFIG_T;


typedef enum 
{
    SIM_MODULE_PRT_SE_FWD_PLAIN = 0,    
    SIM_MODULE_PRT_SE_CTRL_PLAIN = 1,    
    SIM_MODULE_PRT_CFG_FIELD_NUM   ,
}sim_module_prt_cfg_filed;

typedef struct sim_module_prt_config_t
{
    ZXIC_UINT32 sim_se_fwd_plain;   //seת          
    ZXIC_UINT32 sim_se_ctrl_plain;//se

} SIM_MODULE_PRT_CONFIG_T;


typedef struct SimSocketCntRecord
{
    ZXIC_UINT32 rx_cnt;//rx߳̽յı
    ZXIC_UINT32 tx_cnt;//tx̷߳ı뻷
    ZXIC_UINT32 loop_cnt;//߻/Ƶıƺ
    ZXIC_UINT32 loop_disc_cnt;//򻷻ػﵽֵıǰ
    ZXIC_UINT32 tx_disc_cnt;//tx̶߳
    ZXIC_UINT32 big_loop_cnt;     //󻷱ǰ
    ZXIC_UINT32 small_loop_cnt;   //Сǰ
    ZXIC_UINT32 sainner_loop_cnt; //saԻͳƼ
    ZXIC_UINT32 odma_loop_cnt;    //odmaͳƼ
    ZXIC_UINT32 ppu_rep_loop_cnt; //ppuСǰͳƼ
    ZXIC_UINT32 sa_rep_loop_cnt;  //saƻǰͳƼ
    ZXIC_UINT32 mr_rep_loop_cnt;  //mrƻǰͳƼ
    ZXIC_UINT32 oam_tx_cnt; //oamļ
    ZXIC_UINT32 oam_rx_cnt; //oamյļ
    ZXIC_UINT32 oam_fst_cnt; //oamͿаļ
    ZXIC_UINT32 pkt_over_max_len_cnt; //ļ
    ZXIC_UINT32 pktrx_port_over_max_cnt; //˿ڳΧ
}NPE_SIM_SOCKET_CNT_RECORD_T;

typedef struct OamCntRecord
{
    ZXIC_UINT32 oam_total_rx_cnt;   //oamܵĽ
    ZXIC_UINT32 oam_total_tx_cnt;   //oamܵķ
    ZXIC_UINT32 bfd_rx_cnt;         //յbfdļ
    ZXIC_UINT32 bfd_tx_cnt;         //bfd͵ļ
    ZXIC_UINT32 ethccm_rx_cnt;      //ethccmյıļ
    ZXIC_UINT32 ethccm_tx_cnt;      //ethccm͵ıļ
    ZXIC_UINT32 rx_2544_cnt;       //2544յıļ
    ZXIC_UINT32 tx_2544_cnt;       //2544͵ıļ
    ZXIC_UINT32 tst_rx_cnt;    //tstյıļ
    ZXIC_UINT32 tst_tx_cnt; //tst͵ıļ
    ZXIC_UINT32 ais_rx_cnt;  //aisյıļ
    ZXIC_UINT32 ais_tx_cnt;  //ais͵ıļ
    ZXIC_UINT32 csf_rx_cnt;  //csfյıļ
    ZXIC_UINT32 csf_tx_cnt;  //csf͵ıļ
    ZXIC_UINT32 unmep_rx_cnt; //mepյıļ
    ZXIC_UINT32 unmeg_rx_cnt;//megյıļ
    ZXIC_UINT32 unmel_rx_cnt;//megյıļ
    ZXIC_UINT32 unexpperiod_rx_cnt;//megյıļ
    ZXIC_UINT32 oam_fst_cnt; //oamͿаļ
    ZXIC_UINT32 oam_int_cnt; //oamжϵļ
} NPE_SIM_OAM_CNT_RECORD_T;

typedef struct sim_version_diag_t
{
    ZXIC_UINT32 version_main;//汾
    ZXIC_UINT32 version_offical;//ȶ汾
    ZXIC_UINT32 version_test;//԰汾
}NPE_SIM_VERSION_DIAG_T;


typedef struct sim_nppu_cnt_t
{
    ZXIC_UINT32 pktrx_in_total_cnt;    //ܱļ
    ZXIC_UINT32 pktrx_pfu_tbl_invld_cnt;//DPP ˿ûʹܶ
    ZXIC_UINT32 pktrx_pfu_port_down_cnt; //˿down(δʹ)
    ZXIC_UINT32 pktrx_pfu_max_len_cnt;  //
    ZXIC_UINT32 pktrx_pfu_min_len_cnt;  //С
    ZXIC_UINT32 pktrx_out_total_cnt;   //pktrx
    //debug
    ZXIC_UINT32 vhd_tcam_srh_vld_cnt;  //䳤ͷtcam
    ZXIC_UINT32 vhd_tcam_key_hit_cnt;  //tcamؼ
    ZXIC_UINT32 icu_tcam_srh_vld_cnt;  //tcam
    ZXIC_UINT32 icu_tcam_key_hit_cnt;  //tcamyؼ
    ZXIC_UINT32 flownum_tcam_srh_vld_cnt; //tcam
    ZXIC_UINT32 flownum_tcam_key_hit_cnt; //tcamؼ
    ZXIC_UINT32 mr_mc_err_cnt;  //mr鲥쳣
    ZXIC_UINT32 sa_mc_srcpkt_disc_cnt;  //sa鲥Դ
    ZXIC_UINT32 sa_out_notm_flow_id_err_cnt;  //sanotm_flow_id쳣
    //ODMA
    ZXIC_UINT32 odma_rcv_offset_err_cnt;  //offset쳣
    ZXIC_UINT32 odma_rcv_ppu_total_cnt;  //odmaյppuں˼
    ZXIC_UINT32 odma_rcv_ppu_disc_total_cnt;  //odmaյppu
    ZXIC_UINT32 odma_to_tm_cnt;   //odma͸tm
    ZXIC_UINT32 odma_to_lpbk_cnt;  //odma͸ؽӿڼ
    ZXIC_UINT32 odma_to_lif0_cnt;  //odma͸lif0ܼ
    ZXIC_UINT32 odma_to_lif1_cnt;  //odma͸lif1ܼ
    ZXIC_UINT32 odma_to_lifc_cnt;  //odma͸lifcڼ
    ZXIC_UINT32 odma_to_oam_cnt;   //odma͸oamڼ    
}NPE_SIM_NPPU_CNT_T;



typedef struct sim_thread_nppu_mng_t
{
    NPE_SIM_NPPU_CNT_T nppu_port_cnt_t[PORT_NUM];/*˿ + кcore*/
} SIM_THREAD_NPPU_MNG_T; 

typedef struct sim_ppu_cnt_t
{
    ZXIC_UINT32 ppu_rcv_pktrx_total_cnt;   //ppuյpktrxܼ
    ZXIC_UINT32 ppu_rcv_pktrx_uc_cnt;     //ppuյpktrxĵܼ
    ZXIC_UINT32 ppu_rcv_pktrx_sa_mc_cnt;  //ppuյpktrxsa鲥ܼ
    ZXIC_UINT32 ppu_rcv_pktrx_mcloop_cnt;  //ppuյpktrx΢鲥ܼ
    ZXIC_UINT32 ppu_to_pktrx_mcloop_cnt;   //ppu͸鲥ĽСıļ
    ZXIC_UINT32 ppu_to_pbu_mcode_pf_req_cnt;   //΢鲥ָ
    ZXIC_UINT32 pbu_to_ppu_mcode_pf_rsp_cnt;    //ָɹؼ
    ZXIC_UINT32 ppu_dup_send_cnt;  //ppu΢ִdup_snedıļ
    ZXIC_UINT32 ppu_dup_flag_cnt;  //ppuƻdup_flag
    ZXIC_UINT32 ppu_to_odma_pkt_total_cnt;  //ppu͸odmaļ
    ZXIC_UINT32 ppu_total_disc_cnt;  //ppu嶪
    ZXIC_UINT32 wb_pbu_halt_disc_cnt;
    ZXIC_UINT32 wb_pbu_illegal_instr_disc_cnt;
    ZXIC_UINT32 wb_pbu_memory_overflow_disc_cnt;
    ZXIC_UINT32 wb_pbu_busy_disc_cnt;
    ZXIC_UINT32 wb_pbu_rsp_drop_disc_cnt;
    ZXIC_UINT32 wb_pbu_error_flownum_disc_cnt;
    ZXIC_UINT32 wb_pbu_duptable_invalid_disc_cnt;
    ZXIC_UINT32 ppu_to_se_eram_key_cnt;
    ZXIC_UINT32 ppu_rcv_se_eram_rsp_cnt;
    ZXIC_UINT32 ppu_to_se_hbm_key_cnt;
    ZXIC_UINT32 ppu_rcv_se_hbm_rsp_cnt;
    ZXIC_UINT32 ppu_to_se_hash_key_cnt;
    ZXIC_UINT32 ppu_rcv_se_hash_rsp_cnt;
	ZXIC_UINT32 ppu_to_se_lpm_key_cnt;
    ZXIC_UINT32 ppu_rcv_se_lpm_rsp_cnt;
    ZXIC_UINT32 ppu_to_se_stat_key_cnt;
    ZXIC_UINT32 ppu_rcv_se_stat_rsp_cnt;
    ZXIC_UINT32 ppu_to_se_etcam_key_cnt;
    ZXIC_UINT32 ppu_rcv_se_etcam_rsp_cnt;
}NPE_SIM_PPU_CNT_T;

 
DPP_STATUS diag_sim_core_port_cmp(ZXIC_UINT32 dev_id,ZXIC_UINT32 pktrx_id,ZXIC_UINT32 core_id,ZXIC_UINT32 port);

DPP_STATUS diag_sim_pkt_cnt_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 clr);
DPP_STATUS diag_sim_vpci_socket_empty(ZXIC_UINT32 dev_id);
DPP_STATUS diag_sim_npe_se_tbl_del(ZXIC_UINT32 dev_id, ZXIC_UINT32 sdt_no, ZXIC_UINT32 flag);
DPP_STATUS sim_soc_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cfg);
DPP_STATUS sim_soc_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *cfg);
DPP_STATUS diag_sim_cfg_oam_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_en, ZXIC_UINT32 pkt_prt_en);
DPP_STATUS diag_sim_cfg_pkt_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 inst_info_en, ZXIC_UINT32 auto_test_pkt_en);
DPP_STATUS diag_sim_cfg_log_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 level, ZXIC_UINT32 interface_en);
DPP_STATUS diag_sim_npe(ZXIC_UINT32 dev_id, ZXIC_UINT32 clr);
DPP_STATUS diag_sim_cfg_prt(ZXIC_UINT32 dev_id);
DPP_STATUS diag_sim_ver_prt(ZXIC_UINT32 dev_id);
DPP_STATUS diag_sim_port_cnt_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 port_id, ZXIC_UINT32 clr);
DPP_STATUS diag_sim_port_cnt_prt_all(ZXIC_UINT32 dev_id);

DPP_STATUS diag_sim_oam_cnt_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 clr);
DPP_STATUS diag_sim_lif_rmon_fcs_cnt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 port, ZXIC_UINT32 num);
DPP_STATUS diag_sim_npe_pkt_cnt_get(ZXIC_UINT32 dev_id, NPE_SIM_SOCKET_CNT_RECORD_T *cnt_rtn, ZXIC_UINT32 clr);
DPP_STATUS sim_soc_oam_cnt_get(ZXIC_UINT32 dev_id, NPE_SIM_OAM_CNT_RECORD_T *cnt_rtn, ZXIC_UINT32 clr);
DPP_STATUS sim_soc_module_prt_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *cfg);
DPP_STATUS sim_soc_module_prt_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cfg);
DPP_STATUS diag_sim_module_prt_cfg_field_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 index, ZXIC_UINT32 value);
DPP_STATUS diag_sim_module_prt_cfg_prt(ZXIC_UINT32 dev_id);
DPP_STATUS diag_sim_rmon_cnt_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 dir, ZXIC_UINT32 port_id, ZXIC_UINT32 clr);
void sim_soc_pkt_print(ZXIC_UINT8 *pkt, ZXIC_UINT32 pkt_len);
DPP_STATUS diag_sim_iport_filter_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 en, ZXIC_UINT32 input_port);
DPP_STATUS diag_sim_dport_filter_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 en, ZXIC_UINT32 out_port);
DPP_STATUS diag_sim_cap_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id);
DPP_STATUS diag_sim_cap_all_prt(ZXIC_UINT32 dev_id);
DPP_STATUS diag_sim_port_cap_all_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 en, ZXIC_UINT32 iport, ZXIC_UINT32 eport);
#endif /* npe_sim_diag.h */




