/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : zxic_comm_thread.h
* ļʶ : 
* ժҪ : 
* ˵ : 
* ǰ汾 : 
*      : 
*  : 2014/02/08
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef _ZXIC_COMM_THREAD_H_
#define _ZXIC_COMM_THREAD_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifdef ZXIC_OS_LINUX
#include <sched.h>
#include <limits.h>
#endif

#define THREAD_NAME_MAX                 (64)
#define ZXIC_THREAD_TIME_INFINITE       (0xFFFFFFFF)  /* Infinite timeout */

typedef ZXIC_VOID* (*ZXIC_THREAD_FUNC) (ZXIC_VOID*);

/* Thread ID */
typedef struct zxic_comm_thread_id_t
{
#ifdef ZXIC_OS_WIN
    HANDLE  id;
#else
    pthread_t id;
#endif
}ZXIC_THREAD_ID_T;

/* Thread CreateFlag */
#define ZXIC_THREAD_FLAG_DETACH             (1 << 0)
#define ZXIC_THREAD_FLAG_EXPLICIT_SCHED     (1 << 1)

typedef struct zxic_comm_thread_info_t
{
    ZXIC_CHAR         name[THREAD_NAME_MAX];  /* ߳   */
    ZXIC_UINT32       priority;               /* ȼ   */
    ZXIC_UINT32       stack_size;             /* ʼջСֽΪλ */
    ZXIC_UINT32       create_flag;            /* ̱߳־ */
    ZXIC_THREAD_ID_T  id;                     /* ߳ID   */
    ZXIC_THREAD_FUNC  thread_func;            /* ̺߳ */
    ZXIC_VOID*        p_arg;                  /* ߳ */
    ZXIC_UINT32       is_valid;               /* ǷЧ */
}ZXIC_THREAD_INFO_T;

/* API */
ZXIC_RTN32 zxic_comm_thread_info_init(ZXIC_VOID);
ZXIC_RTN32 zxic_comm_thread_info_add(ZXIC_THREAD_ID_T*     p_thread_id,
                                     ZXIC_CONST ZXIC_CHAR* p_name,
                                     ZXIC_UINT32           priority,
                                     ZXIC_UINT32           stack_size,
                                     ZXIC_UINT32           create_flag,
                                     ZXIC_THREAD_FUNC      p_thread_func,
                                     ZXIC_VOID*            p_arg,
                                     ZXIC_UINT32*          p_info_index);
ZXIC_RTN32 zxic_comm_thread_info_del(ZXIC_THREAD_ID_T *p_thread_id);
ZXIC_RTN32 zxic_comm_thread_info_print(ZXIC_VOID);

ZXIC_RTN32 zxic_comm_thread_create(ZXIC_CONST ZXIC_CHAR *p_name, 
                              ZXIC_UINT32            priority,
                              ZXIC_UINT32            stack_size,
                              ZXIC_UINT32            create_flag,
                              ZXIC_THREAD_FUNC       thread_func,
                              ZXIC_VOID              *p_arg,
                              ZXIC_THREAD_ID_T       *p_thread_id);

ZXIC_RTN32 zxic_comm_thread_exit(ZXIC_VOID);
ZXIC_RTN32 zxic_comm_thread_wait(ZXIC_THREAD_ID_T  *p_thread_id, ZXIC_DWORD wait_time);
ZXIC_RTN32 zxic_comm_thread_close_handle(ZXIC_THREAD_ID_T *p_thread_id);

#ifdef __cplusplus
}
#endif


#endif

