#ifndef DPP_AGENT_CHANNEL_H
#define DPP_AGENT_CHANNEL_H

#include "zxic_common.h"
#include "dpp_type_api.h"
#include "dpp_stat_api.h"
#include "dpp_stat_car.h"
#include "dpp_agent_se_res.h"

#define BUFFER_LEN_MAX 256
#define REG_REPS_LEN 8
#define CHANNEL_REPS_LEN 4
#define SCHE_RSP_LEN (2)
#define SCHE_REQ_VALID      (0Xffff)
#define PROFILEID_REQ_VALID (0Xffff)
#define DPP_EPID_LEVEL         (4)

#pragma pack(1)

typedef enum dpp_tm_level
{
    Q_LEVEL = 0,
    P_LEVEL,
    S_LEVEL,
    MAX_LEVEL
}TM_LEVEL_E;
typedef enum dpp_agent_msg_type
{
    DPP_REG_MSG = 0,
    DPP_DTB_MSG,
    DPP_TM_MSG,
    DPP_PLCR_MSG,
    DPP_PKTRX_IND_REG_RW_MSG,
    DPP_PCIE_BAR_MSG,
    DPP_RESET_MSG,
    DPP_PXE_MSG,
    DPP_TM_FLOW_SHAPE,
    DPP_TM_TD,
    DPP_TM_SE_SHAPE,
    DPP_TM_PP_SHAPE,
    DPP_PLCR_CAR_RATE,
    DPP_PLCR_CAR_PKT_RATE,
    DPP_PPU_THASH_RSK,
    DPP_ACL_MSG,
    DPP_STAT_MSG,
    DPP_RES_MSG,
    DPP_MSG_MAX
}MSG_TYPE_E;

typedef enum dpp_agent_msg_reg
{
    REG_DIRECT = 0,
    REG_INDIRECT,
    REG_TYPE_INDIRECT
}MSG_REG_TYPE;

typedef enum dpp_agent_msg_res
{
    RES_STD_NIC_MSG = 0,
    RES_OFFLOAD_MSG,
    RES_MAX_MSG
}MSG_RES_TYPE_E;
typedef enum dpp_agent_msg_oper
{
    DPP_WR = 0,
    DPP_RD,
    DPP_WR_RD_MAX
}MSG_OPER_E;

typedef enum dpp_msg_dtb_oper
{
    QUEUE_REQUEST = 0,
    QUEUE_RELEASE = 1,
}MSG_DTB_OPER_E;
typedef enum dpp_msg_tm_oper
{
    SEID_REQUEST = 0,
    SEID_RELEASE = 1,
    SEID_QUERY = 2
} MSG_TM_OPER_E;
typedef enum dpp_msg_plcr_oper
{
    PROFILEID_REQUEST = 0,
    PROFILEID_RELEASE = 1,
} MSG_PLCR_OPER_E;

typedef enum dpp_cosq_sche
{
    FQ_SCHE_TYPE = 0,
    FQ2_SCHE_TYPE = 1,
    FQ4_SCHE_TYPE = 2,
    FQ8_SCHE_TYPE = 3,
    SP_SCHE_TYPE = 4,
    WFQ_SCHE_TYPE = 5,
    WFQ2_SCHE_TYPE = 6,
    WFQ4_SCHE_TYPE = 7,
    WFQ8_SCHE_TYPE = 8,
    FLOW_SCHE_TYPE = 9,
    SCHE_TYPE_TYPE = 10
} DPP_COSQ_SCHE;
typedef enum  dpp_agent_msg_csflag
{
   DPP_CS_ADDR_FLAG = 0,
   DPP_CS_REGNO_FLAG,
   DPP_CS_FLAG_MAX
}MSG_CSFLAG_E;

typedef enum dpp_ppu_thash_rsk_oper
{
    DPP_PPU_THASH_RSK_RD = 0,
    DPP_PPU_THASH_RSK_WR,
    DPP_PPU_THASH_RSK_MAX
} DPP_PPU_THASH_RSK_OPER_E;

typedef enum dpp_pktrx_ind_reg_rw_oper
{
    DPP_PKTRX_IND_REG_RD = 0,
    DPP_PKTRX_IND_REG_WR,
    DPP_PKTRX_IND_REG_MAX
}DPP_PKTRX_IND_REG_RW_OPER_E;

typedef enum dpp_msg_acl_index_oper
{
    ACL_INDEX_REQUEST    = 0,    /*申请一个index*/
    ACL_INDEX_RELEASE    = 1,    /*释放指定index*/
    ACL_INDEX_VPORT_REL  = 2,    /*释放vport下的所有index*/
    ACL_INDEX_ALL_REL    = 3,    /*释放所有的index*/
    ACL_INDEX_STAT_CLR   = 4,    /*释放指定vport下的index对应的统计项*/
    ACL_INDEX_MAX
}MSG_ACL_INDEX_OPER_E;

typedef enum dpp_se_res_oper
{
    HASH_FUNC_BULK_REQ    = 0, 
    HASH_TBL_REQ          = 1,  
    ERAM_TBL_REQ          = 2,
    ACL_TBL_REQ           = 3,
    LPM_TBL_REQ           = 4,
    DDR_TBL_REQ           = 5,
    STAT_CFG_REQ          = 6,
    RES_REQ_MAX
}MSG_SE_RES_OPER_E;

typedef enum  dpp_agent_pcie_bar
{
   BAR_MSG_NUM_REQ = 0,
   PCIE_BAR_MAX
}MSG_PCIE_BAR_E;

typedef struct dpp_agent_channel_reg_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 subtype;
    ZXIC_UINT8 oper;
    ZXIC_UINT32 reg_no;
    ZXIC_UINT32 addr;
    ZXIC_UINT32 val_len;
    ZXIC_UINT32 val[32];
}DPP_AGENT_CHANNEL_REG_MSG_T;

typedef struct dpp_agent_channel_dtb_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 oper;
    ZXIC_UINT8 rsv;
    ZXIC_CHAR name[32];
    ZXIC_UINT32 vport;
    ZXIC_UINT32 queue_id;
}DPP_AGENT_CHANNEL_DTB_MSG_T;
typedef struct dpp_agent_channel_tm_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 oper;
    ZXIC_UINT8  num;
    ZXIC_UINT32 port;
    ZXIC_UINT32 vport;
    ZXIC_UINT32 sche_level;
    ZXIC_UINT32 sche_type;
    ZXIC_UINT32 se_id;
} DPP_AGENT_CHANNEL_TM_MSG_T;
typedef struct dpp_agent_channel_plcr_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 oper;
    ZXIC_UINT8 rsv;
    ZXIC_UINT32 vport;
    ZXIC_UINT32 car_type;
    ZXIC_UINT32 profile_id;
} DPP_AGENT_CHANNEL_PLCR_MSG_T;

typedef struct dpp_agent_tm_flow_shape_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 rsv;
    ZXIC_UINT8 rsv1;
    ZXIC_UINT32 flow_id;
    ZXIC_UINT32 cir;
    ZXIC_UINT32 cbs;
    ZXIC_UINT32 db_en;
    ZXIC_UINT32 eir;
    ZXIC_UINT32 ebs;
}DPP_AGENT_TM_FLOW_SHAPE_MSG_T;

typedef struct dpp_agent_tm_td_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 rsv;
    ZXIC_UINT8 rsv1;
    ZXIC_UINT32 level;
    ZXIC_UINT32 id;
    ZXIC_UINT32 td_th;
}DPP_AGENT_TM_TD_MSG_T;

typedef struct dpp_agent_tm_se_shape_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 rsv;
    ZXIC_UINT8 rsv1;
    ZXIC_UINT32 se_id;
    ZXIC_UINT32 pir;
    ZXIC_UINT32 pbs;
    ZXIC_UINT32 db_en; 
    ZXIC_UINT32 cir; 
    ZXIC_UINT32 cbs;
}DPP_AGENT_TM_SE_SHAPE_MSG_T;

typedef struct dpp_agent_tm_pp_shape_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 rsv;
    ZXIC_UINT8 rsv1;
    ZXIC_UINT32 pp_port; 
    ZXIC_UINT32 cir;
    ZXIC_UINT32 cbs;
    ZXIC_UINT32 c_en;
}DPP_AGENT_TM_PP_SHAPE_MSG_T;

typedef struct dpp_agent_car_pkt_profile_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 rsv;
    ZXIC_UINT8 rsv1;
    ZXIC_UINT32 car_level;
    ZXIC_UINT32 profile_id;
    ZXIC_UINT32 pkt_sign;
    ZXIC_UINT32 cir;
    ZXIC_UINT32 cbs;
    ZXIC_UINT32 pri[DPP_CAR_PRI_MAX];
}DPP_AGENT_CAR_PKT_PROFILE_MSG_T;

typedef struct dpp_agent_car_profile_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 rsv;
    ZXIC_UINT8 rsv1;
    ZXIC_UINT32 car_level;
    ZXIC_UINT32 profile_id;
    ZXIC_UINT32 pkt_sign;
    ZXIC_UINT32 cd;
    ZXIC_UINT32 cf;
    ZXIC_UINT32 cm;
    ZXIC_UINT32 cir;
    ZXIC_UINT32 cbs;
    ZXIC_UINT32 eir;
    ZXIC_UINT32 ebs;
    ZXIC_UINT32 random_disc_e;
    ZXIC_UINT32 random_disc_c;
    ZXIC_UINT32 c_pri[DPP_CAR_PRI_MAX];
    ZXIC_UINT32 e_green_pri[DPP_CAR_PRI_MAX];
    ZXIC_UINT32 e_yellow_pri[DPP_CAR_PRI_MAX];
}DPP_AGENT_CAR_PROFILE_MSG_T;

typedef struct dpp_agent_ppu_thash_rsk_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 oper;
    ZXIC_UINT8 rsv;
    ZXIC_UINT32 rsk_319_288;
    ZXIC_UINT32 rsk_287_256;
    ZXIC_UINT32 rsk_255_224;
    ZXIC_UINT32 rsk_223_192;
    ZXIC_UINT32 rsk_191_160;
    ZXIC_UINT32 rsk_159_128;
    ZXIC_UINT32 rsk_127_096;
    ZXIC_UINT32 rsk_095_064;
    ZXIC_UINT32 rsk_063_032;
    ZXIC_UINT32 rsk_031_000;
}DPP_AGENT_PPU_THASH_RSK_MSG_T;

typedef struct dpp_agent_pktrx_ind_reg_rw_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 oper;
    ZXIC_UINT8 rsv;
    ZXIC_UINT32 mem_addr;
    ZXIC_UINT32 mem_id;
    ZXIC_UINT32 len;
    ZXIC_UINT32 ind_data[8];
}DPP_AGENT_PKTRX_IND_REG_RW_MSG_T;

typedef struct dpp_agent_channel_acl_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 oper;
    ZXIC_UINT8 rsv;
    ZXIC_UINT32 sdt_no;
    ZXIC_UINT32 vport;
    ZXIC_UINT32 index;
    ZXIC_UINT32 counter_id;
    ZXIC_UINT32 rd_mode;
}DPP_AGENT_CHANNEL_ACL_MSG_T;

typedef struct dpp_agent_channel_stat_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 oper;
    ZXIC_UINT8 rsv;
    ZXIC_UINT32 counter_id;
    ZXIC_UINT32 rd_mode;
    ZXIC_UINT32 num;
}DPP_AGENT_CHANNEL_STAT_MSG_T;

typedef struct dpp_agent_se_res_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 sub_type;
    ZXIC_UINT8 oper;
}DPP_AGENT_SE_RES_MSG_T;

typedef struct dpp_agent_channel_pcie_bar_msg
{
    ZXIC_UINT8 devId;
    ZXIC_UINT8 type;
    ZXIC_UINT8 oper;
    ZXIC_UINT8 rsv;
}DPP_AGENT_PCIE_BAR_MSG_T;

typedef struct dpp_agent_channel_msg
{
    ZXIC_UINT32 msg_len;
    ZXIC_VOID *msg;
}DPP_AGENT_CHANNEL_MSG_T;

#pragma pack()
DPP_STATUS dpp_agent_channel_sync_send(ZXIC_UINT32 dev_id, DPP_AGENT_CHANNEL_MSG_T* pMsg, ZXIC_UINT32 *pData, ZXIC_UINT32 rep_len);
DPP_STATUS dpp_agent_channel_reg_sync_send(ZXIC_UINT32 dev_id, DPP_AGENT_CHANNEL_REG_MSG_T* pMsg, ZXIC_UINT32 *pData, ZXIC_UINT32 rep_len);
DPP_STATUS dpp_agent_channel_reg_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_type, ZXIC_UINT32 reg_no, ZXIC_UINT32 reg_width, ZXIC_UINT32 addr, ZXIC_UINT32 *pData);
DPP_STATUS dpp_agent_channel_reg_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_type, ZXIC_UINT32 reg_no, ZXIC_UINT32 reg_width, ZXIC_UINT32 addr,ZXIC_UINT32 *pData);
DPP_STATUS dpp_agent_channel_dtb_sync_send(ZXIC_UINT32 dev_id, DPP_AGENT_CHANNEL_DTB_MSG_T* pMsg, ZXIC_UINT32 *pData, ZXIC_UINT32 rep_len);

DPP_STATUS dpp_agent_channel_dtb_queue_request(ZXIC_UINT32 dev_id, ZXIC_CHAR p_name[32], ZXIC_UINT32 vport_info, ZXIC_UINT32 *p_queue_id);
DPP_STATUS dpp_agent_channel_dtb_queue_release(ZXIC_UINT32 devId, ZXIC_CHAR p_name[32], ZXIC_UINT32 queueId);

DPP_STATUS dpp_agent_channel_tm_sync_send(ZXIC_UINT32 dev_id, DPP_AGENT_CHANNEL_TM_MSG_T *pMsg, ZXIC_UINT32 *pData, ZXIC_UINT32 rep_len);
DPP_STATUS dpp_agent_channel_tm_seid_request(ZXIC_UINT32 dev_id, ZXIC_UINT32 port, ZXIC_UINT32 vport, ZXIC_UINT32 sche_level, ZXIC_UINT32 sche_type, ZXIC_UINT32 num, ZXIC_UINT32 *p_se_id);
DPP_STATUS dpp_agent_channel_tm_seid_release(ZXIC_UINT32 dev_id, ZXIC_UINT32 port, ZXIC_UINT32 vport, ZXIC_UINT32 sche_level, ZXIC_UINT32 sche_type, ZXIC_UINT32 num, ZXIC_UINT32 se_id);

DPP_STATUS dpp_agent_channel_tm_base_node_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 port, ZXIC_UINT32 vport, ZXIC_UINT32 *p_se_id);

DPP_STATUS dpp_agent_channel_plcr_sync_send(ZXIC_UINT32 dev_id, DPP_AGENT_CHANNEL_PLCR_MSG_T *pMsg, ZXIC_UINT32 *pData, ZXIC_UINT32 rep_len);
DPP_STATUS dpp_agent_channel_plcr_profileid_request(ZXIC_UINT32 dev_id, ZXIC_UINT32 vport, ZXIC_UINT32 car_type, ZXIC_UINT32 *p_profileid);
DPP_STATUS dpp_agent_channel_plcr_profileid_release(ZXIC_UINT32 dev_id, ZXIC_UINT32 vport, ZXIC_UINT32 car_type, ZXIC_UINT32 profileid);

DPP_STATUS dpp_agent_channel_tm_flow_shape(ZXIC_UINT32 dev_id, ZXIC_UINT32 flow_id, ZXIC_UINT32 cir, ZXIC_UINT32 cbs, ZXIC_UINT32 db_en, ZXIC_UINT32 eir, ZXIC_UINT32 ebs);
DPP_STATUS dpp_agent_channel_tm_td_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 level, ZXIC_UINT32 id, ZXIC_UINT32 td_th);
DPP_STATUS dpp_agent_channel_tm_se_shape(ZXIC_UINT32 dev_id, ZXIC_UINT32 se_id, ZXIC_UINT32 pir, ZXIC_UINT32 pbs,ZXIC_UINT32 db_en, ZXIC_UINT32 cir, ZXIC_UINT32 cbs);
DPP_STATUS dpp_agent_channel_tm_port_shape(ZXIC_UINT32 dev_id, ZXIC_UINT32 pp_port, ZXIC_UINT32 cir, ZXIC_UINT32 cbs, ZXIC_UINT32 c_en);

DPP_STATUS dpp_agent_channel_plcr_car_rate(ZXIC_UINT32 dev_id, ZXIC_UINT32 car_type, ZXIC_UINT32 pkt_sign, ZXIC_UINT32 profile_id, ZXIC_VOID* p_car_profile_cfg);
DPP_STATUS dpp_agent_channel_ppu_thash_rsk(ZXIC_UINT32 dev_id, DPP_PPU_THASH_RSK_OPER_E oper, DPP_PPU_PPU_COP_THASH_RSK_T *p_para);
DPP_STATUS dpp_agent_channel_acl_index_request(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 sdt_no, 
                                               ZXIC_UINT32 vport,
                                               ZXIC_UINT32 *p_index);
DPP_STATUS dpp_agent_channel_acl_index_release(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 rel_type,
                                               ZXIC_UINT32 sdt_no, 
                                               ZXIC_UINT32 vport,
                                               ZXIC_UINT32 index); 
DPP_STATUS dpp_agent_channel_stat_clr(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 count_id,
                                    ZXIC_UINT32 rd_mode,
                                    ZXIC_UINT32 num);
DPP_STATUS dpp_agent_channel_acl_stat_clr(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 sdt_no,
                                    ZXIC_UINT32 vport,
                                    ZXIC_UINT32 counter_id,
                                    ZXIC_UINT32 rd_mode);
DPP_STATUS dpp_agent_channel_se_res_get(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 sub_type,
                                    ZXIC_UINT32 opr,
                                    ZXIC_UINT32 *p_rsp_buff,
                                    ZXIC_UINT32 buff_size);
DPP_STATUS dpp_agent_channel_pcie_bar_request(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 *p_bar_msg_num);
DPP_STATUS dpp_agent_channel_pktrx_ind_reg_rw(ZXIC_UINT32 dev_id,
                                              ZXIC_UINT32 mem_addr,
                                              ZXIC_UINT32 mem_id,
                                              ZXIC_UINT32 oper,
                                              ZXIC_UINT32 len,
                                              ZXIC_UINT32 *p_data);
#endif