/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_trpg_api.h
* 文件标识 : 
* 内容摘要 : TRPG模块对外数据结构和函数声明
* 其它说明 : 
* 当前版本 : 
* 作    者 : yangyg
* 完成日期 : 2015/02/15
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* 修改记录1: 
* 修改日期:  
* 版 本 号:  
* 修 改 人:  
* 修改内容:  
***************************************************************/

#ifndef _DPP_DDOS_API_H_
#define _DPP_DDOS_API_H_

#include "zxic_common.h"

#if ZXIC_REAL("header file")
#include "dpp_dev.h"
#include "dpp_dtb4k_reg.h"
#include "dpp_reg_info.h"
#include "dpp_module.h"
#endif

#if ZXIC_REAL("DDOS macro")

#define DDOS_STAT_TABLE_STAT_NO_MAX             (16U)
#define DDOS_DUMP_STAT_NUM_MAX                  (16777215U)//24bit
#define DDOS_TABLE_BASE_ADDR_BIT_WIDTH          (1048575U)//20bit
#define DDOS_STAT_INDEX_OFFSET_ADDR_BIT_WIDTH   (524287U)//19bit
#define DDOS_NS_FLAG_CNT_BIT_WIDTH              (255U)//8bit
#define DDOS_DELETE_TABLE_LENGTH                (1073741823U)//30bit
#define DDOS_DMA_BUFF_SIZE         	            (4*1024*1024)   //4M空间

#endif

#if ZXIC_REAL("DDOS ENMU macro")

/*队列地址信息*/
typedef struct ddos_dma_buff_addr_info
{
  ZXIC_UINT32 size;
  ZXIC_ADDR_T dma_phy_addr;
  ZXIC_UINT8 *dma_vir_addr;
}DDOS_DMA_BUFF_ADDR_INFO;
typedef enum ddos_stat_table_stat_index
{
    DDOS_STAT_TABLE_STAT0 = 0,
    DDOS_STAT_TABLE_STAT1 = 1,
    DDOS_STAT_TABLE_STAT2 = 2,
    DDOS_STAT_TABLE_STAT3 = 3,
    DDOS_STAT_TABLE_STAT4 = 4,
    DDOS_STAT_TABLE_STAT5 = 5,
    DDOS_STAT_TABLE_STAT6 = 6,
    DDOS_STAT_TABLE_STAT7 = 7,
    DDOS_STAT_TABLE_STAT8 = 8,
    DDOS_STAT_TABLE_STAT9 = 9,
    DDOS_STAT_TABLE_STAT10 = 10,
    DDOS_STAT_TABLE_STAT11 = 11,
    DDOS_STAT_TABLE_STAT12 = 12,
    DDOS_STAT_TABLE_STAT13 = 13,
    DDOS_STAT_TABLE_STAT14 = 14,
    DDOS_STAT_TABLE_STAT15 = 15,
}DDOS_STAT_TABLE_STAT_INDEX;

#endif

#if ZXIC_REAL("DDOS FUNCTION")

/***********************************************************/
/** DDOS功能初始化
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/** DDOS 根据统计表中的统计索引号进行上报阈值配置
* @param   dev_id     设备号 
* @param   statNo     统计索引号
* @param   dumpThrd   上报阈值
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_stat_dump_thrd_set(ZXIC_UINT32 dev_id, DDOS_STAT_TABLE_STAT_INDEX statNo, ZXIC_UINT32 dumpThrd);

/***********************************************************/
/** DDOS 根据统计表中的统计索引号进行上报使能配置
* @param   dev_id  设备号 
* @param   statNo  统计索引号 
* @param   en      使能配置 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_stat_dump_thrd_compare_en_set(ZXIC_UINT32 dev_id, DDOS_STAT_TABLE_STAT_INDEX statNo, BOOLEAN en);

/***********************************************************/
/** DDOS 上报表项条目数量配置
* @param   dev_id  设备号 
* @param   statNum 上报表项的数量(24bit)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_dump_stat_num_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 statNum);

/***********************************************************/
/** DDOS 偶HASH表基地址配置
* @param   dev_id   设备号 
* @param   baseAddr HASH表基地址（以2k*256bit为单位，20bit）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_even_hash_table_base_addr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 baseAddr);

/***********************************************************/
/** DDOS 奇HASH表基地址配置
* @param   dev_id   设备号 
* @param   baseAddr HASH表基地址（以2k*256bit为单位，20bit）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_odd_hash_table_base_addr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 baseAddr);

/***********************************************************/
/** DDOS 统计表索引在eRAM中的偏移地址配置
* @param   dev_id      设备号 
* @param   offsetAddr  统计索引表在eRAM中的偏移地址（以128bit为单位，19bit）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_stat_index_eram_offset_addr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 offsetAddr);

/***********************************************************/
/** DDOS 统计n个奇偶数秒配置
* @param   dev_id      设备号 
* @param   second      统计second个奇偶数秒（8bit）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_stat_ns_flag_cnt_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 second);

/***********************************************************/
/** DDOS 偶统计表基地址配置
* @param   dev_id        设备号 
* @param   baseAddr      统计表基地址（以2k*256bit为单位，20bit）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_even_stat_table_base_addr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 baseAddr);

/***********************************************************/
/** DDOS 奇统计表基地址配置
* @param   dev_id        设备号 
* @param   baseAddr      统计表基地址（以2k*256bit为单位，20bit）
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_odd_stat_table_base_addr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 baseAddr);

/***********************************************************/
/** DDOS 偶统计表DUMP目的地址高位配置
* @param   dev_id        设备号 
* @param   destAddr      dump目的地址
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_even_stat_dump_addr_high_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 destAddr);

/***********************************************************/
/** DDOS 偶统计表DUMP目的地址低位配置
* @param   dev_id        设备号 
* @param   destAddr      dump目的地址
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_even_stat_dump_addr_low_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 destAddr);

/***********************************************************/
/** DDOS 偶统计表DUMP目的地址配置
* @param   dev_id        设备号 
* @param   destAddr      dump目的地址
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_even_stat_dump_addr_set(ZXIC_UINT32 dev_id, ZXIC_UINT64 destAddr);

/***********************************************************/
/** DDOS 偶统计表DUMP目的地址获取
* @param   dev_id        设备号 
* @param   destAddr      dump目的地址指针
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_even_stat_dump_addr_get(ZXIC_UINT32 dev_id, ZXIC_UINT64* destAddr);

/***********************************************************/
/** DDOS 奇统计表DUMP目的地址高位配置
* @param   dev_id        设备号 
* @param   destAddr      dump目的地址
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_odd_stat_dump_addr_high_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 destAddr);

/***********************************************************/
/** DDOS 奇统计表DUMP目的地址低位配置
* @param   dev_id        设备号 
* @param   destAddr      dump目的地址
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_odd_stat_dump_addr_low_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 destAddr);

/***********************************************************/
/** DDOS 奇统计表DUMP目的地址配置
* @param   dev_id        设备号 
* @param   destAddr      dump目的地址
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_odd_stat_dump_addr_set(ZXIC_UINT32 dev_id, ZXIC_UINT64 destAddr);

/***********************************************************/
/** DDOS 奇统计表DUMP目的地址获取
* @param   dev_id        设备号 
* @param   destAddr      dump目的地址指针
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_odd_stat_dump_addr_get(ZXIC_UINT32 dev_id, ZXIC_UINT64* destAddr);

/***********************************************************/
/** DDOS 工作模式使能配置
* @param   dev_id        设备号 
* @param   en            工作模式使能
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_work_mode_en_set(ZXIC_UINT32 dev_id, BOOLEAN en);

/***********************************************************/
/** DDOS 删除统计表项长度配置
* @param   dev_id        设备号 
* @param   length        删除统计表项长度
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_delete_stat_table_len_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 length);

/***********************************************************/
/** DDOS 删除hash表项长度配置
* @param   dev_id        设备号 
* @param   length        删除统计表项长度
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_delete_hash_table_len_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 length);

/***********************************************************/
/** DDOS 配置HOST EPID信息
* @param   dev_id        设备号 
* @param   epid          HOST使用的EPID
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_ddos_dump_host_epid_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 epid);
#endif

#endif