/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_mr_api.h
* ļʶ : mrģͶͽӿں
* ժҪ :
* ˵ :
* ǰ汾 :
*      : djf
*  : 2015/02/04
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* ޸ļ¼1:
* ޸:
*   :
*   :
* ޸:
***************************************************************/
#ifndef _DPP_MR_API_H_
#define _DPP_MR_API_H_

#if ZXIC_REAL("header file")
#include "dpp_module.h"
#endif

#if ZXIC_REAL("macro")
#define DPP_MR_MLT_NUM            (0x1ffff)/**< @brief ڵ */
#define DPP_MR_COS_NUM            (4U)
#define DPP_MR_IDLE_FIFO_AFUL_MAX (0xff)
#define DPP_MR_IDLE_FIFO_AFUL_DEFAULT     (120U)
#define DPP_MR_SHAPE_TOKEN_DEFAULT        (200000U)
#define DPP_MR_SHAPE_TOKEN_BUCKET_NUM_MAX (0x1f000)
#endif


#if ZXIC_REAL("data struct define")
typedef enum dpp_mr_rep_mode_e
{
    DPP_MR_COUNT = 0,
    DPP_MR_LIST,
    DPP_MR_REP_MODE_MAX
} DPP_MR_REP_MODE_E;

typedef enum dpp_mr_wr_rd_e
{
    DPP_MR_MLT_WR = 0,
    DPP_MR_MLT_RD,
    DPP_MR_MLT_WR_RD_MAX
} DPP_MR_WR_RD_E;

typedef enum dpp_mr_wr_mode_e
{
    DPP_MR_MLT_WR_TWO = 0,
    DPP_MR_MLT_WR_ONE,
    DPP_MR_MLT_WR_MODE_MAX
} DPP_MR_WR_MODE_E;
#endif

#define DPP_MR_SHAPE_TOKEN_GAP  (59)
#define DPP_MR_SHAPE_TOKEN_DEPTH  (0x1F000)
#define DPP_MR_SHAPE_OFFSET (0)


#if ZXIC_REAL("function declaration")
/***********************************************************/
/**  MRʼ
* @param   dev_id   豸
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/**  TM鲥ģʽ
* @param   dev_id   豸
* @param   rep_mode   ģʽ:0-ʽ,1-ʽ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_rep_mode_set(ZXIC_UINT32 dev_id,
                               DPP_MR_REP_MODE_E rep_mode);

/***********************************************************/
/**  ȡTM鲥ģʽ
* @param   dev_id   豸
* @param   p_rep_mode   ģʽ:0-ʽ,1-ʽ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_rep_mode_get(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 *p_rep_mode);

/***********************************************************/
/**  MRͳƼģʽ
* @param   dev_id   豸
* @param   rd_mode   ģʽ0-Ƕ壬1-
* @param   overflow_mode   ģʽ0-1-
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_count_mode_set(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 rd_mode,
                                 ZXIC_UINT32 overflow_mode);

/***********************************************************/
/**  ȡMRͳƼģʽ
* @param   dev_id   豸
* @param   p_rd_mode   ģʽ0-Ƕ壬1-
* @param   p_overflow_mode   ģʽ0-1-
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_count_mode_get(ZXIC_UINT32 dev_id,
                                 ZXIC_UINT32 *p_rd_mode,
                                 ZXIC_UINT32 *p_overflow_mode);

/***********************************************************/
/**  TM鲥MLTҪĿͬʱдֹ
* @param   dev_id   豸
* @param   mlt_addr0   mltַ,Чλ17bit
* @param   mlt_data0   mlt,Чλ18bit1bit valid+17bit ptr
* @param   mlt_addr1   mltַ,Чλ17bit
* @param   mlt_data1   mlt,Чλ18bit1bit valid+17bit ptr
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_mlt_wr(ZXIC_UINT32 dev_id,
                         ZXIC_UINT32 mlt_addr0,
                         ZXIC_UINT32 mlt_data0,
                         ZXIC_UINT32 mlt_addr1,
                         ZXIC_UINT32 mlt_data1);

/***********************************************************/
/**  ȡTM鲥MLT
* @param   dev_id   豸
* @param   mlt_addr0   mltַ,Чλ17bit
* @param   p_mlt_data   mlt,Чλ18bit1bit valid+17bit ptr
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_mlt_rd(ZXIC_UINT32 dev_id,
                         ZXIC_UINT32 mlt_addr,
                         ZXIC_UINT32 *p_mlt_data);

/***********************************************************/
/**  TM鲥MLTǿд뵥Ŀ쳣ʹ
* @param   dev_id   豸
* @param   mlt_addr0   mltַ,Чλ17bit
* @param   mlt_data0   mlt,Чλ18bit1bit valid+17bit ptr
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_mlt_force_wr(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 mlt_addr,
                               ZXIC_UINT32 mlt_data);

/***********************************************************/
/**  MRβ
* @param   dev_id   豸
* @param   token_add_num   [23:12]:Ŀ(1ƴ1ֽ)
* @param   token_gap   [11:0]:ƼʵʼΪü+1
* @param   token_depth   Ͱȣֵֻ䵽0x1f000
* @param   en   ʹܣ0-ʹܣ1-ʹ
* @param   offset   У׼ֵλֽڣλΪλ0-ӣ1-
*   (600*8*token_add_num)/(token_gap+1) = X Mbps
* עʽ600ϵͳƵ600MHz
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_shape_set(ZXIC_UINT32 dev_id,
                            ZXIC_UINT32 en,
                            ZXIC_UINT32 token_add_num,
                            ZXIC_UINT32 token_gap,
                            ZXIC_UINT32 token_depth,
                            ZXIC_UINT32 offset);

/***********************************************************/
/**  MRβ
* @param   dev_id   豸
* @param   en   ʹܣ0-ʹܣ1-ʹ
* @param   cir   ֵλMbps(С100M)
* @param   cbs   Ͱȣֵֻ䵽0x1f000
* @param   offset   У׼ֵλֽڣ8bitλΪλ0-ӣ1-
*   (600*8*token_add_num)/(token_gap+1) = X Mbps
* עʽ600ϵͳƵ600MHz
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2019/08/1
************************************************************/
DPP_STATUS dpp_mr_shape_set_ext(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 cir,
                                ZXIC_UINT32 cbs,
                                ZXIC_UINT32 offset,
                                ZXIC_UINT32 en);

/***********************************************************/
/**  ӡMRβ
* @param   dev_id   豸
* @param   token_add_num   [23:12]:Ŀ(1ƴ1ֽ)
* @param   token_gap   [11:0]:ƼʵʼΪü+1
* @param   token_depth   Ͱȣֵֻ䵽0x1f000
* @param   en   ʹܣ0-ʹܣ1-ʹ
* @param   offset   У׼ֵλֽڣλΪλ0-ӣ1-
*   (600*8*token_add_num)/(token_gap+1) = X Mbps
* עʽ600ϵͳƵ600MHz
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  whuashan      @date  2020/9/27
************************************************************/
DPP_STATUS dpp_mr_shape_prt(ZXIC_UINT32 dev_id);


/***********************************************************/
/**  ӡTM鲥MLT
* @param   dev_id   豸
* @param   mlt_addr   mltַ,Чλ17bit
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_mlt_prt(ZXIC_UINT32 dev_id,
                          ZXIC_UINT32 mlt_addr);

/***********************************************************/
/**  ӡTM鲥MLT
* @param   dev_id   豸
* @param   mlt_addr   ӡʼַЧλ17bit
* @param   num   ӡ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_mlt_prt_more(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 mlt_addr,
                               ZXIC_UINT32 num);

/***********************************************************/
/**  ӡMRͳƼܼ4н
* @param   dev_id   豸
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_pkt_count_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/**  ӡMR״̬Ϣʱӡ򲻴򣬶
* @param   dev_id   豸
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_err_status_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ӡcossopeoperrorϢ
* @param   dev_id  豸
*
* @return
* @remark  
* @see
* @author  wush      @date  2017/03/20
************************************************************/
DPP_STATUS dpp_mr_in_out_sop_eop_error_prt(ZXIC_UINT32 dev_id);


/***********************************************************/
/** MR COSӦĶ˿ں
* @param   dev_id   豸
* @param   cos_num   cosֵ
* @param   port_num   Ӧ˿ںţܳ63
*
* @return
* @remark  
* @see
* @author  wush      @date  2017/03/20
************************************************************/
DPP_STATUS dpp_mr_cos_port_cfg_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 cos_num, ZXIC_UINT32 port_num);


/***********************************************************/
/** MR COSӦĶ˿ںôӡ
* @param   dev_id   豸
* @param   cos_num   cosֵ
* @param   port_num   Ӧ˿ںţܳ63
*
* @return
* @remark  
* @see
* @author  wush      @date  2017/03/20
************************************************************/
DPP_STATUS dpp_mr_cos_port_cfg_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 cos_num, ZXIC_UINT32 *port_num);

/***********************************************************/
/** MR ӡĸCOSӦĶ˿ں
* @param   dev_id   豸
* @param   port_num0-port_num3   Ӧ˿ںţܳ63
*
* @return
* @remark  
* @see
* @author  wush      @date  2017/03/20
************************************************************/
DPP_STATUS dpp_mr_cos_port_cfg_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** MRӡMR MLT߼ЧĿͶӦMGID
* @param   dev_id   豸
*
* @return
* @remark  
* @see
* @author  wush      @date  2017/03/20
************************************************************/
DPP_STATUS dpp_mr_mlt_unvld_mgid_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/**  TM鲥MLTҪĿͬʱдֹ
* @param   dev_id   豸
* @param   mlt_start_addr0   mltʼַ,Чλ17bit
* @param   mlt_start_data0   mltʼַ,Чλ18bit1bit valid+17bit ptr
* @param   rep_num   Ʒ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wush     @date  2016/11/23
************************************************************/
DPP_STATUS dpp_mr_mlt_wr_more(ZXIC_UINT32 dev_id,
                              ZXIC_UINT32 mlt_start_addr0,
                              ZXIC_UINT32 mlt_start_data0,
                              ZXIC_UINT32 rep_num);

/***********************************************************/
/**  MR idleָfifoѹˮ
* @param   dev_id   豸
* @param   mrCos    õĶӦȼ
* @param   idleFifo ˮ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wush     @date  2016/11/23
************************************************************/
DPP_STATUS dpp_mr_idle_fifo_aful_th_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 mrCos,
                                        ZXIC_UINT32 idleFifo);

/***********************************************************/
/**  MR idleָfifoѹˮߴӡ
* @param   dev_id   豸
* @param   mrCos    õĶӦȼ
* @param   idleFifo ˮ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wush     @date  2016/11/23
************************************************************/
DPP_STATUS dpp_mr_idle_fifo_aful_th_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/**  MR SOP EOP MATCHģˮ(ˮ)
* @param   dev_id    豸
* @param   matchEn   ʹ(Ĭʹܣرմ˹ܣҪLIF VOQģϻܹر)
* @param   discardTh ˮ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wush     @date  2016/11/23
************************************************************/
DPP_STATUS dpp_mr_sop_eop_match_cfg_set(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 matchEn,
                                    ZXIC_UINT32 discardTh);

/***********************************************************/
/**  MR sop eop matchģôӡ
* @param   dev_id   豸
* @param   mrCos    õĶӦȼ
* @param   idleFifo ˮ
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  wush     @date  2016/11/23
************************************************************/
DPP_STATUS dpp_mr_sop_eop_match_cfg_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/**  mr
* @param   dev_id   豸
*
* @return   DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  djf      @date  2016/10/18
************************************************************/
DPP_STATUS dpp_mr_help(ZXIC_UINT32 dev_id);


#endif//function declaration
#endif//_DPP_MR_API_H_





