/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_dtb.h
* 文件标识 :
* 内容摘要 :
* 其它说明 :
* 当前版本 :
* 作    者 : zab
* 完成日期 : 2022/08/26
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* 修改记录1:
* 修改日期:
* 版 本 号:
* 修 改 人:
* 修改内容:
***************************************************************/
#ifndef _DPP_DTB_H_
#define _DPP_DTB_H_

#ifdef __cplusplus
extern "C" {
#endif

#define DPP_DTB_QUEUE_ITEM_NUM_MAX              (32)

#define DPP_DTB_ITEM_ACK_SIZE                   (16)
#define DPP_DTB_ITEM_BUFF_SIZE                  (16 * 1024)
#define DPP_DTB_ITEM_SIZE                       (16 + 16 * 1024)
#define DPP_DTB_TAB_UP_SIZE                     ((16 + 16 * 1024) * 32)
#define DPP_DTB_TAB_DOWN_SIZE                   ((16 + 16 * 1024) * 32)

#define DPP_DTB_TAB_UP_ACK_VLD_MASK             (0x555555)
#define DPP_DTB_TAB_DOWN_ACK_VLD_MASK           (0x5a5a5a)
#define DPP_DTB_TAB_ACK_IS_USING_MASK           (0x11111100)
#define DPP_DTB_TAB_ACK_UNUSED_MASK             (0x0)
#define DPP_DTB_TAB_ACK_SUCCESS_MASK            (0xff)
#define DPP_DTB_TAB_ACK_FAILED_MASK             (0x1)
#define DPP_DTB_TAB_ACK_CHECK_VALUE             (0x12345678)

#define DPP_DTB_TAB_ACK_VLD_SHIFT               (104)
#define DPP_DTB_TAB_ACK_STATUS_SHIFT            (96)

#define DPP_DTB_TAB_UP_PHY_ADDR_GET(DEV_ID, QUEUE_ID, INDEX)     \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_up.start_phy_addr + INDEX * p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_up.item_size)
#define DPP_DTB_TAB_UP_USER_PHY_ADDR_GET(DEV_ID, QUEUE_ID, INDEX)     \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_up.user_addr[INDEX].phy_addr)
#define DPP_DTB_TAB_UP_USER_PHY_ADDR_FLAG_GET(DEV_ID, QUEUE_ID, INDEX)     \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_up.user_addr[INDEX].user_flag)
#define DPP_DTB_TAB_UP_USER_ADDR_FLAG_SET(DEV_ID, QUEUE_ID, INDEX, VAL)     \
        do {\
            p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_up.user_addr[INDEX].user_flag = VAL;\
        }while(0)
#define DPP_DTB_TAB_DOWN_PHY_ADDR_GET(DEV_ID, QUEUE_ID, INDEX)   \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_down.start_phy_addr + INDEX * p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_down.item_size)
#define DPP_DTB_TAB_UP_VIR_ADDR_GET(DEV_ID, QUEUE_ID, INDEX)     \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_up.start_vir_addr + INDEX * p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_up.item_size)
#define DPP_DTB_TAB_UP_USER_VIR_ADDR_GET(DEV_ID, QUEUE_ID, INDEX)     \
            (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_up.user_addr[INDEX].vir_addr)
#define DPP_DTB_TAB_DOWN_VIR_ADDR_GET(DEV_ID, QUEUE_ID, INDEX)   \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_down.start_vir_addr + INDEX * p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_down.item_size)
#define DPP_DTB_TAB_UP_WR_INDEX_GET(DEV_ID, QUEUE_ID)       \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_up.wr_index)
#define DPP_DTB_TAB_UP_RD_INDEX_GET(DEV_ID, QUEUE_ID)       \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_up.rd_index)
#define DPP_DTB_TAB_DOWN_WR_INDEX_GET(DEV_ID, QUEUE_ID)       \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_down.wr_index)
#define DPP_DTB_TAB_DOWN_RD_INDEX_GET(DEV_ID, QUEUE_ID)       \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_down.rd_index)
#define DPP_DTB_TAB_UP_DATA_LEN_GET(DEV_ID, QUEUE_ID, INDEX)       \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].tab_up.data_len[INDEX])
#define DPP_DTB_QUEUE_INIT_FLAG_GET(DEV_ID, QUEUE_ID)       \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].init_flag)
#define DPP_DTB_QUEUE_VPORT_GET(DEV_ID, QUEUE_ID)       \
        (p_dpp_dtb_mgr[DEV_ID]->queue_info[QUEUE_ID].vport)

#define DPP_BDRING_ITEM_SIZE                (16)

#define DPP_UP_MAC_BD_ITEM_NUM              (0XFF)

#define DPP_BD_ITEM_NUM_MAX                 (0XFF)
#define DPP_UP_BD_BUFF_SIZE_MAX             (4 * 1024)

#define DPP_UP_MAC_BD_ITEM_SIZE             ((DPP_UP_MAC_BD_ITEM_NUM + 1) * DPP_BDRING_ITEM_SIZE)
#define DPP_UP_MAC_BUFF_SIZE                (16 * 1024)
#define DPP_UP_MAC_BD_BUFF_SIZE             (DPP_UP_MAC_BD_ITEM_NUM * DPP_UP_MAC_BUFF_SIZE)
#define DPP_UP_MAC_BD_TOTAL_SIZE            (DPP_UP_MAC_BD_ITEM_SIZE + DPP_UP_MAC_BD_BUFF_SIZE)
#define DPP_DMA_BUFF_SIZE                   (4*1024*1024)

#define DPP_DMA_BD_VLD_MSK                  (0x80000000)
#define DPP_DMA_BD_DATA_LEN_MSK             (0x7FF)

#define DPP_EP_ID_MAX                       (16)

#define DPP_DTB_LEN_MIN                     (1)
#define DPP_DTB_DOWN_LEN                    (0x3FF)

#define DPP_DMA_HASH_KEY_OFFSET             (6)
#define DPP_DMA_HASH_ITEM_MAX               (64)
#define DPP_DMA_HASH_KEY_RST                (DPP_DMA_HASH_ITEM_MAX-DPP_DMA_HASH_KEY_OFFSET)

#define DPP_DMA_SENDTYPE_START_BIT          (23)
#define DPP_DMA_SENDTYPE_BIT_NUM            (2)
#define DPP_DMA_VALID_START_BIT             (23)
#define DPP_DMA_VALID_BIT_NUM               (1)
#define DPP_DMA_HASHID_START_BIT            (21)
#define DPP_DMA_HASHID_BIT_NUM              (2)
#define DPP_DMA_TBLID_START_BIT             (16)
#define DPP_DMA_TBLID_BIT_NUM               (2)

typedef struct dpp_dtb_queue_cfg_t
{
    ZXIC_ADDR_T up_start_phy_addr;
    ZXIC_ADDR_T up_start_vir_addr;
    ZXIC_ADDR_T down_start_phy_addr;
    ZXIC_ADDR_T down_start_vir_addr;
    
    ZXIC_UINT32 up_item_size;
    ZXIC_UINT32 down_item_size;
}DPP_DTB_QUEUE_CFG_T;

typedef struct dpp_dtb_tab_up_user_addr_t
{
    ZXIC_UINT32 user_flag;
    
    ZXIC_ADDR_T phy_addr;
    ZXIC_ADDR_T vir_addr;
}DPP_DTB_TAB_UP_USER_ADDR_T;

typedef struct dpp_dtb_tab_up_info_t
{
    ZXIC_ADDR_T start_phy_addr;
    ZXIC_ADDR_T start_vir_addr;
    ZXIC_UINT32 item_size;

    ZXIC_UINT32 wr_index;
    ZXIC_UINT32 rd_index;

    ZXIC_UINT32 data_len[DPP_DTB_QUEUE_ITEM_NUM_MAX];
    DPP_DTB_TAB_UP_USER_ADDR_T user_addr[DPP_DTB_QUEUE_ITEM_NUM_MAX];
}DPP_DTB_TAB_UP_INFO_T;

typedef struct dpp_dtb_tab_down_info_t
{
    ZXIC_ADDR_T start_phy_addr;
    ZXIC_ADDR_T start_vir_addr;
    ZXIC_UINT32 item_size;

    ZXIC_UINT32 wr_index;
    ZXIC_UINT32 rd_index;
}DPP_DTB_TAB_DOWN_INFO_T;

typedef struct dpp_dtb_queue_info_t
{
    ZXIC_UINT32 init_flag;
    ZXIC_UINT32 vport;
    ZXIC_UINT32 vector;
    
    DPP_DTB_TAB_UP_INFO_T tab_up;
    DPP_DTB_TAB_DOWN_INFO_T tab_down;
}DPP_DTB_QUEUE_INFO_T;

typedef struct dpp_dtb_mgr_t
{  
    DPP_DTB_QUEUE_INFO_T queue_info[DPP_DTB_QUEUE_NUM_MAX];
} DPP_DTB_MGR_T;

typedef enum dpp_dtb_dir_type_e
{
    DPP_DTB_DIR_DOWN_TYPE    = 0, 
    DPP_DTB_DIR_UP_TYPE    = 1,        
    DPP_DTB_DIR_TYPE_MAX,
} DPP_DTB_DIR_TYPE_E;


typedef enum dpp_dtb_tab_up_user_addr_type_e
{
    DPP_DTB_TAB_UP_NOUSER_ADDR_TYPE     = 0, 
    DPP_DTB_TAB_UP_USER_ADDR_TYPE       = 1,        
    DPP_DTB_TAB_UP_USER_ADDR_TYPE_MAX,
} DPP_DTB_TAB_UP_USER_ADDR_TYPE_E;

typedef enum dpp_dma_send_type_e
{
    DMA_LEARN_HASH  = 0,
    DMA_DEL_HASH    = 1,
    DMA_UPDATE_HASH = 2,
    DMA_ADD_HASH    = 3,
    DMA_SEND_TYPE_MAX
}DPP_DMA_SEND_TYPE_E;

/* 单个通道BD表管理结构体 */
typedef struct dpp_dma_bd_t
{
    ZXIC_ADDR_T bd_phy_addr;    /* BD表物理地址 */
    ZXIC_ADDR_T bd_vir_addr;    /* BD表进程空间虚拟地址 */
    ZXIC_ADDR_T buff_phy_addr;  /* BD表指向的BUFF物理地址 */
    ZXIC_ADDR_T buff_vir_addr;  /* BD表指向的BUFF进程空间虚拟地址 */
    ZXIC_UINT32 bd_index;       /* BD表当前使用index */
} DPP_DMA_BD_T;

/* 单个设备BD表管理结构体 */
typedef struct dpp_dma_mgr_t
{
    ZXIC_UINT32 init;
    ZXIC_UINT32 endian_flag;    /* DMA数据通道大小端，0-小端，1-大端 */
    DPP_DMA_BD_T up_mac;
} DPP_DMA_MGR_T;

/**使能dtb时间统计函数*/
ZXIC_UINT32 dpp_dtb_time_stat_enable(ZXIC_VOID);

/**去使能dtb时间统计函数*/
ZXIC_UINT32 dpp_dtb_time_stat_disable(ZXIC_VOID);

/**获取dtb时间统计状态*/
ZXIC_UINT32 dpp_dtb_time_stat_get(ZXIC_VOID);

/**使能dtb调试函数*/
ZXIC_UINT32 dpp_dtb_debug_fun_enable(ZXIC_VOID);

/**去使能dtb调试函数*/
ZXIC_UINT32 dpp_dtb_debug_fun_disable(ZXIC_VOID);

/**获取dtb调试函数*/
ZXIC_UINT32 dpp_dtb_debug_fun_get(ZXIC_VOID);

/**使能dtb打印函数*/
ZXIC_UINT32 dpp_dtb_prt_enable(ZXIC_VOID);

/**去使能dtb打印函数*/
ZXIC_UINT32 dpp_dtb_prt_disable(ZXIC_VOID);

/**获取dtb打印函数*/
ZXIC_UINT32 dpp_dtb_prt_get(ZXIC_VOID);

ZXIC_UINT32 dpp_dtb_soft_perf_test_set(ZXIC_UINT32 value);

ZXIC_UINT32 dpp_dtb_soft_perf_test_get(ZXIC_VOID);

ZXIC_UINT32 dpp_dtb_down_table_overtime_set(ZXIC_UINT32 times_s);
ZXIC_UINT32 dpp_dtb_down_table_overtime_get(ZXIC_VOID);

ZXIC_UINT32 dpp_dtb_dump_table_overtime_set(ZXIC_UINT32 times_s);
ZXIC_UINT32 dpp_dtb_dump_table_overtime_get(ZXIC_VOID);
ZXIC_UINT32 dpp_dtb_delay_overtime_set(ZXIC_UINT32 times_s);
ZXIC_UINT32 dpp_dtb_delay_overtime_get(ZXIC_VOID);

#if ZXIC_REAL("MGR")
/***********************************************************/
/** 创建DTB的管理结构
* @param   dev_id       设备号，支持多芯片  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_mgr_create(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 注销DTB的管理结构
* @param   dev_id       设备号，支持多芯片   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_mgr_destory(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 重置DTB管理结构
* @param   dev_id       设备号，支持多芯片   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_mgr_reset(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 获取DMA管理结构
* @param   dev_id               设备号，支持多芯片
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
DPP_DTB_MGR_T *dpp_dtb_mgr_get(ZXIC_UINT32 dev_id);
#endif

#if ZXIC_REAL("INT")
/***********************************************************/
/** 中断线选择配置
* @param   dev_id           设备号，支持多芯片  
* @param   queue_id         队列号，表示选择该队列的中断，范围0-127
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2022/11/09
************************************************************/
ZXIC_UINT32 dpp_dtb_interrupt_to_riscv_sel_set(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 queue_id);


/***********************************************************/
/** 获取中断线选择
* @param   dev_id               设备号，支持多芯片  
* @param   p_interrupt_sel_id   获取的中断线编号即队列号
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2022/11/09
************************************************************/
ZXIC_UINT32 dpp_dtb_interrupt_to_riscv_sel_get(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 *p_interrupt_sel_id);

/***********************************************************/
/** 对EP进行中断MSIX使能配置
* @param   dev_id           设备号，支持多芯片  
* @param   ep_id            使能中断MSIX的EP号，范围0-15
* @param   state            中断使能状态，1-使能，0-去使能
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2022/11/09
************************************************************/
ZXIC_UINT32 dpp_dtb_ep_interrupt_msix_enable_set(ZXIC_UINT32 dev_id,
                                                 ZXIC_UINT32 ep_id,
                                                 ZXIC_UINT32 state);

/***********************************************************/
/** 获取中断MSIX使能状态
* @param   dev_id           设备号，支持多芯片  
* @param   int_msix_state   中断MSIX的使能状态
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2022/11/09
************************************************************/
ZXIC_UINT32 dpp_dtb_ep_interrupt_msix_enable_get(ZXIC_UINT32 dev_id,
                                                 ZXIC_UINT32 *p_int_msix_state);
#endif

#if ZXIC_REAL("DTB_DOORBELL_ADDR")
/***********************************************************/
/** 配置EP的doorbell地址
* @param   dev_id                       设备号，支持多芯片  
* @param   ep_id                        EP号，返回0-15
* @param   doorbell_addr_h32            doorbell高地址
* @param   doorbell_addr_l32            doorbell低地址
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2022/11/09
************************************************************/
ZXIC_UINT32 dpp_dtb_ep_doorbell_addr_set(ZXIC_UINT32 dev_id, 
                                         ZXIC_UINT32 ep_id,
                                         ZXIC_UINT32 doorbell_addr_h32,
                                         ZXIC_UINT32 doorbell_addr_l32);

/***********************************************************/
/** 获取EP的doorbell地址
* @param   dev_id                       设备号，支持多芯片  
* @param   ep_id                        EP号，返回0-15
* @param   doorbell_addr_h32            doorbell高地址
* @param   doorbell_addr_l32            doorbell低地址
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2022/11/09
************************************************************/
ZXIC_UINT32 dpp_dtb_ep_doorbell_addr_get(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 ep_id,
                                         ZXIC_UINT32 *p_doorbell_addr_h32,
                                         ZXIC_UINT32 *p_doorbell_addr_l32);
#endif

#if ZXIC_REAL("QUEUE_ADDR")
/***********************************************************/
/** 获得下表队列中某元素的物理地址
* @param   dev_id                         设备号，支持多芯片  
* @param   queue_id                       队列号0-127
* @param   element_id                     队列中元素号0-31
* @param   p_element_start_addr_h         元素起始高32位地址
* @param   p_element_start_addr_l         元素起始低32位地址
* @param   p_element_table_addr_h         元素高32位地址
* @param   p_element_table_addr_l         元素起始低32位地址
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_down_table_elemet_addr_get(ZXIC_UINT32 dev_id, 
                        ZXIC_UINT32 queue_id, 
                        ZXIC_UINT32 element_id,
                        ZXIC_UINT32 *p_element_start_addr_h,
                        ZXIC_UINT32 *p_element_start_addr_l,
                        ZXIC_UINT32 *p_element_table_addr_h,
                        ZXIC_UINT32 *p_element_table_addr_l);

/***********************************************************/
/** 获得队列中某元素dump的物理地址
* @param   dev_id                         设备号，支持多芯片  
* @param   queue_id                       队列号0-127
* @param   element_id                     队列中元素号0-31
* @param   p_element_start_addr_h         元素起始高32位地址
* @param   p_element_start_addr_l         元素起始低32位地址
* @param   p_element_dump_addr_h          dump描述符开始高32位地址
* @param   p_element_dump_addr_l          dump描述符开始低32位地址
* @param   p_element_table_info_addr_h    表内容开始高32位地址
* @param   p_element_table_info_addr_l    表内容开始低32位地址
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_dump_table_elemet_addr_get(ZXIC_UINT32 dev_id, 
                        ZXIC_UINT32 queue_id, 
                        ZXIC_UINT32 element_id,
                        ZXIC_UINT32 *p_element_start_addr_h,
                        ZXIC_UINT32 *p_element_start_addr_l,
                        ZXIC_UINT32 *p_element_dump_addr_h,
                        ZXIC_UINT32 *p_element_dump_addr_l,
                        ZXIC_UINT32 *p_element_table_info_addr_h,
                        ZXIC_UINT32 *p_element_table_info_addr_l);
#endif

#if ZXIC_REAL("ACK_RW")
/***********************************************************/
/** 读取BD表条目信息
* @param   dev_id       芯片的id号  
* @param   queue_id     队列号,范围0-127
* @param   dir_flag     方向,1-上送表项,0-下发表项    
* @param   index        条目索引,范围0-31 
* @param   pos          一个item里面的4个32位，pos对应的是第几个ZXICP_WORD32，
*                       取值为0，1，2，3      
* @param   p_data       读取的数据,大端格式  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2019/11/2
************************************************************/
ZXIC_UINT32 dpp_dtb_item_ack_rd(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 dir_flag,
                    ZXIC_UINT32 index, 
                    ZXIC_UINT32 pos,
                    ZXIC_UINT32 *p_data);

/***********************************************************/
/** 向BD表条目指定位置写入值
* @param   dev_id       芯片的id号  
* @param   queue_id     队列号,范围0-127
* @param   dir_flag     方向,1-上送表项,0-下发表项  
* @param   index        条目索引,范围0-31 
* @param   pos          一个item里面的4个32位，pos对应的是第几个ZXICP_WORD32，
*                       取值为0，1，2，3      
* @param   data         读取的数据,大端格式 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2019/11/2
************************************************************/
ZXIC_UINT32 dpp_dtb_item_ack_wr(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 dir_flag,
                    ZXIC_UINT32 index, 
                    ZXIC_UINT32 pos,
                    ZXIC_UINT32 data);
#endif

#if ZXIC_REAL("BUFF_RW")
/***********************************************************/
/** 读取BD表条目指向BUFF的数据
* @param   dev_id       芯片的id号  
* @param   queue_id     队列号,范围0-127
* @param   dir_flag     方向,1-上送表项,0-下发表项  
* @param   index        条目索引,范围0-31 
* @param   pos          相对BUFF起始地址的偏移,单位32bit;      
* @param   p_data       读取的数据,大端格式 
* @param   len          读取数据长度,单位32bit; 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2019/11/2
************************************************************/
ZXIC_UINT32 dpp_dtb_item_buff_rd(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 dir_flag,
                    ZXIC_UINT32 index, 
                    ZXIC_UINT32 pos,
                    ZXIC_UINT32 len,
                    ZXIC_UINT32 *p_data);

/***********************************************************/
/** 向BD表条目指向的BUFF指定位置写入值
* @param   dev_id       芯片的id号  
* @param   queue_id     队列号,范围0-127
* @param   dir_flag     方向,1-上送表项,0-下发表项  
* @param   index        条目索引,范围0-31   
* @param   pos          相对BUFF起始地址的偏移,单位32bit;       
* @param   p_data       读取的数据,大端格式 
* @param   len          写入数据长度,单位32bit; 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2019/11/2
************************************************************/
ZXIC_UINT32 dpp_dtb_item_buff_wr(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 dir_flag,
                    ZXIC_UINT32 index, 
                    ZXIC_UINT32 pos,
                    ZXIC_UINT32 len,
                    ZXIC_UINT32 *p_data);
#endif

#if ZXIC_REAL("API")
/***********************************************************/
/** 配置下发配置数据信息
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-31 
* @param   int_flag             中断标志，0-无，1-有 
* @param   data_len             数据长度，单位32bit;
* @param   p_data               待下发数据 
* @param   p_item_index         返回使用的条目编号 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_down_info_set(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 int_flag,
                    ZXIC_UINT32 data_len,
                    ZXIC_UINT32 *p_data,
                    ZXIC_UINT32 *p_item_index);

/***********************************************************/
/** 查询队列表项下发状态
* @param   dev_id       设备号，支持多芯片   
* @param   queue_id             队列号，范围0-31 
* @param   p_item_index         返回使用的条目编号 
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_down_status_get(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 *p_item_index);

/***********************************************************/
/** 一个元素down成功状态检查
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-31 
* @param   element_id           条目编号 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_down_success_status_check(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 element_id);

/***********************************************************/
/** 获取一个队列中待使用的元素编号
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-127 
* @param   p_element_id         条目编号 
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/04/26
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_down_element_id_get(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 queue_id,
                                            ZXIC_UINT32 *p_element_id);

/***********************************************************/
/** 获取一个队列中dump表待使用的元素编号
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-127 
* @param   p_element_id         条目编号 
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/04/26
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_dump_element_id_get(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 queue_id,
                                            ZXIC_UINT32 *p_element_id);
/***********************************************************/
/** 设置一个队列中dump要使用的元素编号
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-127 
* @param   element_id           要使用的元素编号
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/04/26
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_dump_element_id_set(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 queue_id,
                                            ZXIC_UINT32 element_id);

/***********************************************************/
/** 设置一个队列中要使用的元素编号
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-127 
* @param   element_id           要使用的元素编号
*
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/04/26
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_down_element_id_set(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 queue_id,
                                            ZXIC_UINT32 element_id);
/***********************************************************/
/** dump队列空闲条目获取
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-31 
* @param   p_item_index         返回使用的条目编号 
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_up_free_item_get(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 *p_item_index);

/***********************************************************/
/** 获取dump指定条目物理地址
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列编号,范围:0-127  
* @param   item_index           条目编号,范围0-31  
* @param   p_phy_haddr          物理地址高32bit  
* @param   p_phy_laddr          物理地址低32bit  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_up_item_addr_get(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 item_index,
                    ZXIC_UINT32 *p_phy_haddr,
                    ZXIC_UINT32 *p_phy_laddr);

/***********************************************************/
/** 获取指定dump条目一定地址偏移的物理地址
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列编号,范围:0-127  
* @param   item_index           条目编号,范围0-31  
* @param   p_phy_haddr          物理地址高32bit  
* @param   p_phy_laddr          物理地址低32bit  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_up_item_offset_addr_get(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 queue_id,
                                                ZXIC_UINT32 item_index,
                                                ZXIC_UINT32 addr_offset,
                                                ZXIC_UINT32 *p_phy_haddr,
                                                ZXIC_UINT32 *p_phy_laddr);

/***********************************************************/
/** 设置dump指定条目空间地址，用于用户自定义空间传输
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列编号,范围:0-127  
* @param   item_index           条目编号,范围0-31  
* @param   phy_haddr            物理地址高  
* @param   vir_laddr            虚拟地址低  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_up_item_user_addr_set(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 item_index,
                    ZXIC_ADDR_T phy_addr,
                    ZXIC_ADDR_T vir_addr);

/***********************************************************/
/** 清除用户dump指定条目空间地址
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列编号,范围:0-127  
* @param   item_index           条目编号,范围0-31   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_up_item_user_addr_clr(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 item_index);

/***********************************************************/
/** dump配置描述符信息设置
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-31 
* @param   item_index           返回使用的条目编号 
* @param   int_flag             中断标志，0-无，1-有 
* @param   data_len             数据长度，单位32bit;
* @param   desc_len             描述符长度，单位32bit;
* @param   p_desc_data          待下发描述符 
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_up_info_set(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 item_index,
                    ZXIC_UINT32 int_flag,
                    ZXIC_UINT32 data_len,
                    ZXIC_UINT32 desc_len,
                    ZXIC_UINT32 *p_desc_data);

/***********************************************************/
/** 获取dump成功数据信息
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-31 
* @param   p_item_index         获取到的数据对应的的条目编号 
* @param   p_data_len           数据长度，单位32bit; 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_up_index_get(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 *p_item_index,
                    ZXIC_UINT32 *p_data_len);

/***********************************************************/
/** 一个元素dump成功状态检查
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-31 
* @param   element_id           条目编号 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_up_success_status_check(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 element_id);

/***********************************************************/
/** 获取dump数据
* @param   dev_id               设备号，支持多芯片
* @param   queue_id             队列号，范围0-31 
* @param   item_index           数据对应的的条目编号 
* @param   data_len             数据长度，单位32bit; 
* @param   p_data               dump数据 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_tab_up_data_get(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    ZXIC_UINT32 item_index,
                    ZXIC_UINT32 data_len,
                    ZXIC_UINT32 *p_data);

/***********************************************************/
/** dtb初始化
* @param   dev_id       设备号，支持多芯片   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2022/08/30
************************************************************/
ZXIC_UINT32 dpp_dtb_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/** dtb软件初始化
* @param   dev_id       设备号，支持多芯片   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2022/08/30
************************************************************/
ZXIC_UINT32 dpp_dtb_soft_init(ZXIC_UINT32 dev_id);

/***********************************************************/
/** dtb队列down初始化
* @param   dev_id           设备号，支持多芯片 
* @param   queue_id         队列号
* @param   p_queue_cfg      队列配置参数，具体见DPP_DTB_QUEUE_CFG_T结构体类型
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_down_init(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    DPP_DTB_QUEUE_CFG_T *p_queue_cfg);

/***********************************************************/
/** dtb队列dump初始化
* @param   dev_id           设备号，支持多芯片 
* @param   queue_id         队列号
* @param   p_queue_cfg      队列配置参数，具体见DPP_DTB_QUEUE_CFG_T结构体类型
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_dump_init(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id,
                    DPP_DTB_QUEUE_CFG_T *p_queue_cfg);

/***********************************************************/
/** dtb队列down 空间地址配置
* @param   channelId    dtb通道号 
* @param   phyAddr      down物理地址
* @param   virAddr      down虚拟地址
* @param   size         空间大小
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_down_channel_addr_set(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 channelId, 
                                          ZXIC_UINT64 phyAddr, 
                                          ZXIC_UINT64 virAddr, 
                                          ZXIC_UINT32 size);

/***********************************************************/
/** dtb队列dump 空间地址配置
* @param   channelId    dtb通道号 
* @param   phyAddr      dump物理地址
* @param   virAddr      dump虚拟地址
* @param   size         空间大小
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_dump_channel_addr_set(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 channelId, 
                                          ZXIC_UINT64 phyAddr, 
                                          ZXIC_UINT64 virAddr, 
                                          ZXIC_UINT32 size);

/***********************************************************/
/** 释放队列资源
* @param   dev_id           设备号，支持多芯片  
* @param   queue_id         分配到的队列号;
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_id_free(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 queue_id);

/***********************************************************/
/** 根据vport查找相应的队列号
* @param   dev_id       设备号，支持多芯片   
* @param   vport        vport信息
* @param   p_queue_arr 找到到队列数组
* @param   p_num          找到的队列个数
* @return  
* @remark  无
* @see     
* @author  cbb      @date  2023/09/13
************************************************************/
ZXIC_UINT32 dpp_dtb_queue_id_search_by_vport(ZXIC_UINT32 dev_id, 
                                             ZXIC_UINT32 vport, 
                                             ZXIC_UINT32 *p_queue_arr,
                                             ZXIC_UINT32 *p_num);
#endif

#if ZXIC_REAL("DMA")
#if ZXIC_REAL("MGR")
/***********************************************************/
/** 创建DTB的管理结构
* @param   dev_id       设备号，支持多芯片  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dma_mgr_create(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 注销DTB的管理结构
* @param   dev_id       设备号，支持多芯片   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dma_mgr_destory(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 重置DTB管理结构
* @param   dev_id       设备号，支持多芯片   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dma_mgr_reset(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 获取DMA管理结构
* @param   dev_id               设备号，支持多芯片
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
DPP_DMA_MGR_T *dpp_dma_mgr_get(ZXIC_UINT32 dev_id);
#endif

#if ZXIC_REAL("MEM_RW")
/***********************************************************/
/** 内存32bits写入函数
* @param   dev_id           设备号，支持多芯片  
* @param   addr             地址偏移
* @param   data             写入数据
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dma_wr32(ZXIC_UINT32 dev_id, 
                        ZXIC_ADDR_T addr, 
                        ZXIC_UINT32 data);

/***********************************************************/
/** 内存32bits读取函数
* @param   dev_id           设备号，支持多芯片  
* @param   addr             读取地址
* @param   p_data           读取数据
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dma_rd32(ZXIC_UINT32 dev_id,
                        ZXIC_ADDR_T addr, 
                        ZXIC_UINT32 *p_data);
#endif

#if ZXIC_REAL("BD_INIT")
/***********************************************************/
/** 初始化DMA通道的BD表
* @param   dev_id               设备号，支持多芯片 
* @param   bd_num               BD最大条目数
* @param   bd_size              单个BD条目的大小，单位：字节
* @param   bd_buff_size         单个BD BUFF空间大小，单位：字节
* @param   phy_addr             物理地址
* @param   vir_addr             虚拟地址
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dma_ch_bd_init(ZXIC_UINT32 dev_id,
                        ZXIC_UINT32 bd_num,
                        ZXIC_UINT32 bd_size,
                        ZXIC_ADDR_T phy_addr,
                        ZXIC_ADDR_T vir_addr);

/***********************************************************/
/** 内存32bits读取函数
* @param   device_id        芯片的id号  
* @param   phy_addr         物理地址
* @param   vir_addr         虚拟地址
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dma_bd_init(ZXIC_UINT32 dev_id,
                        ZXIC_ADDR_T phy_addr,
                        ZXIC_ADDR_T vir_addr);
#endif


#if ZXIC_REAL("BD_RW")
/***********************************************************/
/** 读取BD表条目信息
* @param   dev_id       芯片的id号   
* @param   index        条目索引,范围0-31 
* @param   pos          一个item里面的4个32位，pos对应的是第几个ZXICP_WORD32，
*                       取值为0，1，2，3      
* @param   p_data       读取的数据,大端格式  
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2019/11/2
************************************************************/
ZXIC_UINT32 dpp_dma_bd_item_rd(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 index, 
                    ZXIC_UINT32 pos,
                    ZXIC_UINT32 *p_data);

/***********************************************************/
/** 向BD表条目指定位置写入值
* @param   dev_id       芯片的id号  
* @param   index        条目索引,范围0-31 
* @param   pos          一个item里面的4个32位，pos对应的是第几个ZXICP_WORD32，
*                       取值为0，1，2，3      
* @param   data         读取的数据,大端格式 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2019/11/2
************************************************************/
ZXIC_UINT32 dpp_dma_bd_item_wr(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 index, 
                    ZXIC_UINT32 pos,
                    ZXIC_UINT32 data);
#endif


#if ZXIC_REAL("BD_BUFF_RW")
/***********************************************************/
/** 读取BD表条目指向BUFF的数据
* @param   dev_id       芯片的id号  
* @param   index        条目索引,范围0-31 
* @param   pos          相对BUFF起始地址的偏移,单位32bit;      
* @param   p_data       读取的数据,大端格式 
* @param   len          读取数据长度,单位32bit; 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2019/11/2
************************************************************/
ZXIC_UINT32 dpp_dma_bd_buff_rd(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 index, 
                    ZXIC_UINT32 pos,
                    ZXIC_UINT32 len,
                    ZXIC_UINT32 *p_data);

/***********************************************************/
/** 向BD表条目指向的BUFF指定位置写入值
* @param   dev_id       芯片的id号  
* @param   index        条目索引,范围0-31   
* @param   pos          相对BUFF起始地址的偏移,单位32bit;       
* @param   p_data       读取的数据,大端格式 
* @param   len          写入数据长度,单位32bit; 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2019/11/2
************************************************************/
ZXIC_UINT32 dpp_dma_bd_buff_wr(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 index, 
                    ZXIC_UINT32 pos,
                    ZXIC_UINT32 len,
                    ZXIC_UINT32 *p_data);
#endif

#if ZXIC_REAL("PROCESS")
/***********************************************************/
/** 处理上送数据
* @param   p_data_in            原始数据内容
* @param   data_in_len          原始数据长度,单位为32bit;
* @param   p_data_out           经过处理后的数据内容
* @param   data_out_len         处理后的数据长度,单位为32bit;   
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/03/01
************************************************************/
ZXIC_UINT32 dpp_dma_up_data_process(ZXIC_UINT32 *p_data_in,
                    ZXIC_UINT32 data_in_len,
                    ZXIC_UINT32 *p_data_out,
                    ZXIC_UINT32 *p_data_out_len);

/***********************************************************/
/** 接收数据上送
* @param   device_id        设备号，支持多芯片
* @param   p_rdata          接收到数据
* @param   rdata_len        接收到长度,单位为32bit;
*                           如果未接收到任何数据，rdata_len = 0; 
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/03/01
************************************************************/
ZXIC_UINT32 dpp_dma_up_rcv(ZXIC_UINT32 dev_id,
                    ZXIC_UINT32 *p_rdata, 
                    ZXIC_UINT32 *rdata_len);

/***********************************************************/
/** 接收数据上送处理
* @param   dev_id        设备号，支持多芯片
* @param   p_buff        DMA hash item
* @return  
* @remark  无
* @see     
* @author        @date  2021/03/01
************************************************************/
ZXIC_UINT32 dpp_dma_hash_data_handle(ZXIC_UINT32 dev_id,ZXIC_UINT32 *p_buff);
#endif

#if ZXIC_REAL("INIT")
/***********************************************************/
/** DMA各通道及总开关打开/关闭
* @param   dev_id           设备号，支持多芯片
* @param   en               开关标志,0-关闭，1-打开
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dma_enable(ZXIC_UINT32 dev_id, 
                    ZXIC_UINT32 en);

/***********************************************************/
/** DMA的初始化
* @param   devi_id          设备号，支持多芯片 
* @param   phy_addr         物理地址
* @param   vir_addr         虚拟地址
*
* @return  
* @remark  无
* @see     
* @author  zab      @date  2021/02/23
************************************************************/
ZXIC_UINT32 dpp_dma_init(ZXIC_UINT32 dev_id,
                    ZXIC_ADDR_T phy_addr,
                    ZXIC_ADDR_T vir_addr);
#endif

#endif


#ifdef __cplusplus
}
#endif

#endif

