/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_stat_car.h
* ļʶ : 
* ժҪ : 
* ˵ : 
* ǰ汾 : 
*      : ls
*  : 2016/04/05
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/
#ifndef _DPP_STAT_CAR_H_
#define _DPP_STAT_CAR_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "dpp_dev.h"
#include "dpp_stat_api.h"


#define     DPP_CAR_ID_MAX                                  (1)

#define     DPP_CAR_DEBUG_SWITCH                            (0)

#define     DPP_CAR_A_FLOW_ID_MAX                           (0x7fff)  /*car Aֶ֧̬ȡ32K, ޸*/
#define     DPP_CAR_B_FLOW_ID_MAX                           (0xfff)
#define     DPP_CAR_C_FLOW_ID_MAX                           (0x3ff)
#define     DPP_CAR_A_FLOW_ID_NUM                           (0x8000)  /*car Aֶ֧̬ȡ32K, ޸*/
#define     DPP_CAR_B_FLOW_ID_NUM                           (0x1000)
#define     DPP_CAR_C_FLOW_ID_NUM                           (0x400)

#define     DPP_CAR_PROFILE_ID_TOTAL                        ((0x200 + 0x80 + 0x20) * DPP_CAR_ID_MAX)

#define     DPP_CAR_PKT_PROFILE_ID_MAX                      (0x200)  /* 512 */
#define     DPP_CAR_A_PROFILE_ID_MAX                        (0x1ff)
#define     DPP_CAR_B_PROFILE_ID_MAX                        (0x7f)
#define     DPP_CAR_C_PROFILE_ID_MAX                        (0x1f)

#define     DPP_CAR_B_PROFILE_ID_RANDOM_MAX                 (0x1f)
#define     DPP_CAR_C_PROFILE_ID_RANDOM_MAX                 (0x7)
#define     DPP_CAR_RANDOM_OFFSET_VAL                       (7)

#define     DPP_CAR_MAX_CBS_VALUE                           ((1<<27) - 1)
#define     DPP_CAR_MAX_EBS_VALUE                           ((1<<27) - 1)
#define     DPP_CAR_MAX_CIR_VALUE                           ((1<<23) - 1)
#define     DPP_CAR_MAX_EIR_VALUE                           ((1<<23) - 1)
#define     DPP_CAR_MAX_PKT_CIR_VALUE                       ((1<<29) - 1)
#define     DPP_CAR_MAX_PKT_CBS_VALUE                       ((1<<13) - 1)
#define     DPP_CAR_MAX_PRI_VALUE                           ((1<<5) - 1)

#define     DPP_CAR_QUEUQ_CFG_TQ_LEN                        (64)
#define     DPP_CAR_QUEUQ_CFG_TQ_HIGH_13BIT_POS             (44)
#define     DPP_CAR_QUEUQ_CFG_TQ_HIGH_13BIT_LEN             (13)
#define     DPP_CAR_QUEUQ_CFG_TQ_LOW_32BIT_POS              (31)
#define     DPP_CAR_QUEUQ_CFG_TQ_LOW_32BIT_LEN              (32)

#define     DPP_CAR_PROFILE_CFG_ZXIC_UINT8                        (28)
#define     DPP_CAR_PROFILE_CFG_ZXIC_UINT32                      (DPP_CAR_PROFILE_CFG_ZXIC_UINT8>>2)
#define     DPP_CAR_PROFILE_CFG_WIDTH                       (DPP_CAR_PROFILE_CFG_ZXIC_UINT8<<3)

#define     DPP_CAR_QUEUE_CFG_ZXIC_UINT8                          (4)
#define     DPP_CAR_QUEUE_CFG_WIDTH                         (DPP_CAR_QUEUE_CFG_ZXIC_UINT8<<3)

#define     DPP_CAR_PROFILE_CFG_CAR_TYPE_POS                (1)
#define     DPP_CAR_PROFILE_CFG_CAR_TYPE_LEN                (2)
#define     DPP_CAR_PROFILE_CFG_PKT_SIGN_POS                (2)
#define     DPP_CAR_PROFILE_CFG_PKT_SIGN_LEN                (1)
#define     DPP_CAR_PROFILE_CFG_CD_POS                      (4)
#define     DPP_CAR_PROFILE_CFG_CD_LEN                      (2)
#define     DPP_CAR_PROFILE_CFG_CF_POS                      (5)
#define     DPP_CAR_PROFILE_CFG_CF_LEN                      (1)
#define     DPP_CAR_PROFILE_CFG_CM_POS                      (6)
#define     DPP_CAR_PROFILE_CFG_CM_LEN                      (1)
#define     DPP_CAR_PROFILE_CFG_EIR_POS                     (28)
#define     DPP_CAR_PROFILE_CFG_EIR_LEN                     (22)
#define     DPP_CAR_PROFILE_CFG_CIR_POS                     (50)
#define     DPP_CAR_PROFILE_CFG_CIR_LEN                     (22)
#define     DPP_CAR_PROFILE_CFG_EBS_POS                     (77)
#define     DPP_CAR_PROFILE_CFG_EBS_LEN                     (27)
#define     DPP_CAR_PROFILE_CFG_CBS_POS                     (104)
#define     DPP_CAR_PROFILE_CFG_CBS_LEN                     (27)
#define     DPP_CAR_PROFILE_CFG_C_PRI1_POS                  (139)
#define     DPP_CAR_PROFILE_CFG_C_PRI1_LEN                  (5)
#define     DPP_CAR_PROFILE_CFG_E_G_PRI1_POS                (174)
#define     DPP_CAR_PROFILE_CFG_E_G_PRI1_LEN                (5)
#define     DPP_CAR_PROFILE_CFG_E_Y_PRI0_POS                (214)
#define     DPP_CAR_PROFILE_CFG_E_Y_PRI0_LEN                (5)

#define     DPP_CAR_PKT_PROFILE_CFG_CAR_TYPE_POS            (1)
#define     DPP_CAR_PKT_PROFILE_CFG_CAR_TYPE_LEN            (2)
#define     DPP_CAR_PKT_PROFILE_CFG_PKT_SIGN_POS            (2)
#define     DPP_CAR_PKT_PROFILE_CFG_PKT_SIGN_LEN            (1)
#define     DPP_CAR_PKT_PROFILE_CFG_CIR_POS                 (32)
#define     DPP_CAR_PKT_PROFILE_CFG_CIR_LEN                 (30)
#define     DPP_CAR_PKT_PROFILE_CFG_CBS_POS                 (46)
#define     DPP_CAR_PKT_PROFILE_CFG_CBS_LEN                 (14)
#define     DPP_CAR_PKT_PROFILE_CFG_C_PRI0_POS              (86)
#define     DPP_CAR_PKT_PROFILE_CFG_C_PRI0_LEN              (5)

#define     DPP_CAR_QUEUE_CFG_CAR_TYPE_POS                  (1)
#define     DPP_CAR_QUEUE_CFG_CAR_TYPE_LEN                  (2)
#define     DPP_CAR_QUEUE_CFG_PKT_SIGN_POS                  (2)
#define     DPP_CAR_QUEUE_CFG_PKT_SIGN_LEN                  (1)
#define     DPP_CAR_QUEUE_CFG_QUEUE_ID_POS                  (16)
#define     DPP_CAR_QUEUE_CFG_QUEUE_ID_LEN                  (14)

/* car 㷨ģʽ */
typedef enum dpp_car_cd_mode_e
{
    CAR_CD_MODE_SRTCM   = 0,
    CAR_CD_MODE_TRTCM,
    CAR_CD_MODE_MEF10_1,
    CAR_CD_MODE_INVALID
}DPP_CAR_CD_MODE_E;

/* car ģʽ*/
typedef enum dpp_car_rd_mode_e
{
    CAR_READ_NOT_CLEAR = 0,
    CAR_READ_AND_CLEAR = 1,
}DPP_CAR_RD_MODE_E;

/* car תģʽ */
typedef enum dpp_car_overflow_mode_e
{
    CAR_KEEP_COUNT   = 0,
    CAR_RE_COUNT     = 1,
}DPP_CAR_OVERFLOW_MODE_E;

/** QVOSתģʽ */
typedef enum dpp_car_qvos_mode_e
{
    CAR_QVOS_MODE_OVERFLOW_0 = 0,
    CAR_QVOS_MODE_OVERFLOW_1 = 1,
    CAR_QVOS_MODE_OVERFLOW_2 = 2,
    CAR_QVOS_MODE_OVERFLOW_MAX
}DPP_CAR_QVOS_MODE_E;

typedef enum dpp_car_en_mode_e
{
    DPP_CAR_EN_MODE_BOTH_EN =  0,
    DPP_CAR_EN_MODE_A_EN    =  1,
    DPP_CAR_EN_MODE_A_B_EN  =  2,
    DPP_CAR_EN_MODE_INVALID
}DPP_CAR_EN_MODE_E;

typedef enum dpp_car_cfg_operate_mode_e
{
    CAR_OPERATE_MODE_ADD    = 0,
    CAR_OPERATE_MODE_DEL    = 1,
    CAR_OPERATE_MODE_SRH    = 2,
    CAR_OPERATE_MODE_GET    = 3,
    CAR_OPERATE_MODE_MAX,
}DPP_CAR_CFG_OPERATE_MODE_E;

typedef struct dpp_stat_car_dbg_cnt_t
{
    ZXIC_UINT32 pkt_input_total_cnt;
    ZXIC_UINT32 pkt_input_green_cnt;
    ZXIC_UINT32 pkt_input_yellow_cnt;
    ZXIC_UINT32 pkt_input_red_cnt;
    ZXIC_UINT32 pkt_output_total_cnt;
    ZXIC_UINT32 pkt_output_green_cnt;
    ZXIC_UINT32 pkt_output_yellow_cnt;
    ZXIC_UINT32 pkt_output_red_cnt;
    ZXIC_UINT32 pkt_fc_dbg_cnt;
    ZXIC_UINT32 pkt_size_cnt;
}DPP_STAT_CAR_DBG_CNT_T;

/** car ģõĲ */
typedef struct dpp_stat_car_pkt_profile_cfg_t
{
    ZXIC_UINT32 profile_id;
    ZXIC_UINT32 pkt_sign;
    ZXIC_UINT32 cir;
    ZXIC_UINT32 cbs;
    ZXIC_UINT32 pri[DPP_CAR_PRI_MAX];              /**< @brief pri 0~7Чֵ*/
}DPP_STAT_CAR_PKT_PROFILE_CFG_T;

/** car AõĲ */
typedef struct dpp_stat_car_a_pkt_queue_cfg_t
{
    ZXIC_UINT32 flow_id;
    ZXIC_UINT32 drop_flag;
    ZXIC_UINT32 plcr_en;
    ZXIC_UINT32 profile_id;
    ZXIC_UINT64 tq;
    ZXIC_UINT64 dc;
    ZXIC_UINT32 tc;
}DPP_STAT_CAR_A_PKT_QUEUE_CFG_T;

/** car B õĲ */
typedef struct dpp_stat_car_b_queue_cfg_t
{
    ZXIC_UINT32 flow_id;
    ZXIC_UINT32 drop_flag;
    ZXIC_UINT32 plcr_en;
    ZXIC_UINT32 profile_id;
    ZXIC_UINT64 tq;
    ZXIC_UINT32 tce_flag;
    ZXIC_UINT32 tce;
    ZXIC_UINT32 tc;
    ZXIC_UINT32 te;
}DPP_STAT_CAR_B_QUEUE_CFG_T;

/** car C õĲ */
typedef struct dpp_stat_car_c_queue_cfg_t
{
    ZXIC_UINT32 flow_id;
    ZXIC_UINT32 drop_flag;
    ZXIC_UINT32 plcr_en;
    ZXIC_UINT32 profile_id;
    ZXIC_UINT64 tq;
    ZXIC_UINT32 tce_flag;
    ZXIC_UINT32 tce;
    ZXIC_UINT32 tc;
    ZXIC_UINT32 te;
}DPP_STAT_CAR_C_QUEUE_CFG_T;

/* profileüֵ */
typedef struct dpp_car_profile_rb_key_t
{
    /**carprofile: 
         car_type[2]+pkt_sign[1]+cd[2]+cf[1]+cm[1]+eir[22]+cir[22]+ebs[27]+cbs[27]+cpri[35]+e_g_pri[35]+e_y_pri[40]+0[9]*/
    /**carpktprofile: 
         car_type[2]+pkt_sign[1]+cir[30]+cbs[14]+c_pri[32]+0[115]*/
    ZXIC_UINT32 profile_cfg[DPP_CAR_PROFILE_CFG_ZXIC_UINT32];
    ZXIC_UINT32 is_static;                                    /* Ƿ̬̬profileûֶɾ,ʵ */
    ZXIC_UINT32 use_count;
}DPP_CAR_PROFILE_RB_KEY_T;

/* profile idprofile ýڵϵֵ */
typedef struct dpp_car_profile_id_rb_key_t
{
    ZXIC_UINT32 profile_id;
    void * p_car_node;
    ZXIC_UINT32 is_used;
}DPP_CAR_PROFILE_ID_RB_KEY_T;

/* кprofile id󶨹ϵֵ */
typedef struct dpp_car_queue_rb_key_t
{   /** carqueue
          car_type[2]+pkt_sign[1]+queue_id[14]+15[0]*/
    ZXIC_UINT8 profile_cfg[DPP_CAR_QUEUE_CFG_ZXIC_UINT8];   
    ZXIC_UINT32 is_used;
    ZXIC_UINT32 profile_id;
}DPP_CAR_QUEUE_RB_KEY_T;

/*  */
typedef struct dpp_car_rb_mng_t
{
    ZXIC_UINT32          init_en;
    ZXIC_UINT32          total_num;
    ZXIC_UINT32          key_size;               /** ڵռĴС */
    ZXIC_RB_CMPFUN   p_cmpfun;
    ZXIC_RB_CMPFUN   p_id_cmpfun;
    ZXIC_RB_CFG *    p_plcr_rb;
    ZXIC_RB_CFG *    p_plcr_id_rb;           /** idcar ĺṹ */
    ZXIC_LISTSTACK_MANGER *p_liststack_mng;  /**  */
}DPP_CAR_RB_MNG_T;

/* profile */
typedef struct dpp_car_profile_mng_t
{
    ZXIC_UINT32    is_init;
    DPP_CAR_RB_MNG_T *p_car_a_rb_profile_mng;
    DPP_CAR_RB_MNG_T *p_car_b_rb_profile_mng;
    DPP_CAR_RB_MNG_T *p_car_c_rb_profile_mng;
}DPP_CAR_PROFILE_MNG_T;

/* й */
typedef struct dpp_car_queue_mng_t
{
    ZXIC_UINT32    is_init;
    DPP_CAR_RB_MNG_T *p_car_rb_queue_mng;       /** ͬcar*/
}DPP_CAR_QUEUE_MNG_T;

/* carϢ */
typedef struct dpp_car_cfg_t
{
    ZXIC_UINT32 is_init[DPP_DEV_CHANNEL_MAX];
    ZXIC_UINT32 car0_mono_mode[DPP_DEV_CHANNEL_MAX];
    DPP_CAR_QUEUE_MNG_T *     p_car_queue_mng[DPP_DEV_CHANNEL_MAX];
    DPP_CAR_PROFILE_MNG_T * p_car_profile_mng[DPP_DEV_CHANNEL_MAX];
}DPP_CAR_CFG_T;

/* carλҪ洢Ĳ */
typedef struct dpp_car_soft_reset_item_t
{
    ZXIC_UINT32 flow_id;
    ZXIC_UINT32 profile_id;
}DPP_CAR_SOFT_RESET_ITEM_T;

typedef struct dpp_car_soft_reset_data_t
{
    ZXIC_UINT8 car_pkt_sign[DPP_CAR_PKT_PROFILE_ID_MAX];   /*  */

    ZXIC_UINT32 is_init;                                   /* carǷʼ־λ */
    ZXIC_UINT32 car0_pkt_num;                              /*  */

    ZXIC_UINT32 cara_flow_num;             /* car0ùIDĿ */
    ZXIC_UINT32 carb_flow_num;             /* car0ùIDĿ */
    ZXIC_UINT32 carc_flow_num;             /* car0ùIDĿ */

    DPP_CAR_SOFT_RESET_ITEM_T cara_item[DPP_CAR_A_FLOW_ID_NUM];
    DPP_CAR_SOFT_RESET_ITEM_T carb_item[DPP_CAR_B_FLOW_ID_NUM];
    DPP_CAR_SOFT_RESET_ITEM_T carc_item[DPP_CAR_C_FLOW_ID_NUM];

}DPP_CAR_SOFT_RESET_DATA_T;

typedef struct dpp_car_random_ram_t
{
    ZXIC_UINT32 p1;    /* һ(ٷֱ)ȡֵ0-100ƼΪ1(ٷֱ) */
    ZXIC_UINT32 p2;    /* ڶ(ٷֱ)ȡֵ0-100ƼΪ10(ٷֱ) */
    ZXIC_UINT32 p3;    /* (ٷֱ)ȡֵ0-100ƼΪ50(ٷֱ) */
    ZXIC_UINT32 tc;    /* ͰCBSEBS */
    ZXIC_UINT32 t1;    /* Ͱĵˮߣȡֵ0-CBS/EBSƼ70%Ͱ */
    ZXIC_UINT32 t2;    /* Ͱˮߣȡֵ0-CBS/EBSƼ85%Ͱ */
    ZXIC_UINT32 t3;    /* Ͱĸˮߣȡֵ0-CBS/EBSƼ95%Ͱ */
}DPP_CAR_RANDOM_RAM_T;

typedef struct dpp_car_soft_reset_queue_t
{
    ZXIC_UINT32 car_type;
    ZXIC_UINT32 flow_id;
    ZXIC_UINT32 drop_flag;
    ZXIC_UINT32 plcr_en;
    ZXIC_UINT32 profile_id;

}DPP_CAR_SOFT_RESET_QUEUE_T;

/***********************************************************/
/** car Aټģ趨
* @param   dev_id               豸               car
* @param   profile_id           ģ
* @param   p_cara_profile_cfg   ģ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/04/05
************************************************************/
DPP_STATUS dpp_stat_cara_pkt_profile_cfg_set(ZXIC_UINT32 dev_id,
                                             ZXIC_UINT32 profile_id,
                                             DPP_STAT_CAR_PKT_PROFILE_CFG_T* p_cara_profile_cfg);

/***********************************************************/
/** ȡcar A 
* @param   dev_id               豸               car
* @param   flow_id              
* @param   p_cara_queue_cfg     car AϢ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/04/05
************************************************************/
DPP_STATUS dpp_stat_cara_pkt_queue_cfg_get(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 flow_id,
                                           DPP_STAT_CAR_A_PKT_QUEUE_CFG_T* p_cara_queue_cfg);

/***********************************************************/
/** car B ʶò
* @param   dev_id      
* @param   profile_id   
* @param   p_random_ram   
*
* @return  
* @remark  
* @see     
* @author  YXH      @date  2019/04/01
************************************************************/
DPP_STATUS dpp_stat_carb_random_ram_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 profile_id,
                                        DPP_CAR_RANDOM_RAM_T *p_random_ram_e,
                                        DPP_CAR_RANDOM_RAM_T *p_random_ram_c);

/***********************************************************/
/** ȡcar B ʶò
* @param   dev_id      
* @param   profile_id   
* @param   p_random_ram   
*
* @return  
* @remark  
* @see     
* @author  YXH      @date  2019/04/01
************************************************************/
DPP_STATUS dpp_stat_carb_random_ram_get(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 profile_id,
                                        DPP_CAR_RANDOM_RAM_T *p_random_ram_e,
                                        DPP_CAR_RANDOM_RAM_T *p_random_ram_c);

/***********************************************************/
/** car C ʶò
* @param   dev_id      
* @param   profile_id   
* @param   p_random_ram   
*
* @return  
* @remark  
* @see     
* @author  YXH      @date  2019/04/01
************************************************************/
DPP_STATUS dpp_stat_carc_random_ram_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 profile_id,
                                        DPP_CAR_RANDOM_RAM_T *p_random_ram_e,
                                        DPP_CAR_RANDOM_RAM_T *p_random_ram_c);

/***********************************************************/
/** ȡcar B ʶò
* @param   dev_id      
* @param   profile_id   
* @param   p_random_ram   
*
* @return  
* @remark  
* @see     
* @author  YXH      @date  2019/04/01
************************************************************/
DPP_STATUS dpp_stat_carc_random_ram_get(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 profile_id,
                                        DPP_CAR_RANDOM_RAM_T *p_random_ram_e,
                                        DPP_CAR_RANDOM_RAM_T *p_random_ram_c);

/***********************************************************/
/** ȡcarİƫ
* @param   dev_id
* @param   p_pkt_size_off  
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  wll      @date  2019/06/06
************************************************************/
DPP_STATUS dpp_stat_car_pkt_size_offset_get(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 *p_pkt_size_off);

/***********************************************************/
/** cara
* @param   dev_id
* @param   max_pkt_size  
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  wll      @date  2019/06/06
************************************************************/
DPP_STATUS dpp_stat_cara_max_pkt_size_set(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 max_pkt_size);

/***********************************************************/
/** ȡcara
* @param   dev_id
* @param   p_max_pkt_size  
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  wll      @date  2019/06/06
************************************************************/
DPP_STATUS dpp_stat_cara_max_pkt_size_get(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 *p_max_pkt_size);

/***********************************************************/
/** carb
* @param   dev_id
* @param   max_pkt_size  
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  wll      @date  2019/06/06
************************************************************/
DPP_STATUS dpp_stat_carb_max_pkt_size_set(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 max_pkt_size);

/***********************************************************/
/** ȡcarb
* @param   dev_id
* @param   p_max_pkt_size  
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  wll      @date  2019/06/06
************************************************************/
DPP_STATUS dpp_stat_carb_max_pkt_size_get(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 *p_max_pkt_size);

/***********************************************************/
/** carc
* @param   dev_id
* @param   max_pkt_size  
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  wll      @date  2019/06/06
************************************************************/
DPP_STATUS dpp_stat_carc_max_pkt_size_set(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 max_pkt_size);

/***********************************************************/
/** ȡcarc
* @param   dev_id
* @param   p_max_pkt_size  
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  wll      @date  2019/06/06
************************************************************/
DPP_STATUS dpp_stat_carc_max_pkt_size_get(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 *p_max_pkt_size);

/***********************************************************/
/** ȡ
* @param   dev_id
* @param   car_type
* @param   p_max_pkt_len
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  wll      @date  2019/06/06
************************************************************/
DPP_STATUS dpp_stat_car_max_pkt_size_get(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 car_type,
                                         ZXIC_UINT32 *p_max_pkt_len);

/***********************************************************/
/** carİƫ
* @param   dev_id
* @param   pkt_size_off  
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  wll      @date  2019/06/06
************************************************************/
DPP_STATUS dpp_stat_car_pkt_size_offset_set(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 pkt_size_off);

/***********************************************************/
/** 
* @param   dev_id
* @param   car_type
* @param   max_pkt_size
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  wll      @date  2019/06/06
************************************************************/
DPP_STATUS dpp_stat_car_max_pkt_size_set(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 car_type,
                                         ZXIC_UINT32 max_pkt_size);

/***********************************************************/
/** car ģ
* @param   dev_id      
* @param   car_type   
* @param   flow_id   
* @param   drop_flag   
* @param   plcr_en   
* @param   profile_id   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/05/06
************************************************************/
DPP_STATUS dpp_stat_car_queue_cfg_set(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 car_type,
                                      ZXIC_UINT32 flow_id,
                                      ZXIC_UINT32 drop_flag,
                                      ZXIC_UINT32 plcr_en,
                                      ZXIC_UINT32 profile_id);

/***********************************************************/
/** car profileӲд
* @param   dev_id      
* @param   car_type   
* @param   pkt_sign   
* @param   profile_id   
* @param   p_car_profile_cfg   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/05/06
************************************************************/
DPP_STATUS dpp_stat_car_profile_cfg_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 car_type,
                                        ZXIC_UINT32 pkt_sign,
                                        ZXIC_UINT32 profile_id,
                                        ZXIC_VOID* p_car_profile_cfg);

/***********************************************************/
/** car ӳϵ
* @param   dev_id      豸      0:CAR 1:CAR
* @param   car_type    0:Acar1:Bcar2:Ccar
* @param   flow_id     
* @param   map_flow_id ӳ
* @param   map_sp      ӳȼ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/09/27
************************************************************/
DPP_STATUS dpp_stat_car_queue_map_set(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 car_type,
                                      ZXIC_UINT32 flow_id,
                                      ZXIC_UINT32 map_flow_id,
                                      ZXIC_UINT32 map_sp);

/***********************************************************/
/** 
* @param   dev_id      
* @param   car_type   
* @param   pkt_sign   
* @param   flow_id   
* @param   p_data   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/09/27
************************************************************/
DPP_STATUS dpp_stat_car_queue_get(ZXIC_UINT32 dev_id,
                                  ZXIC_UINT32 car_type,
                                  ZXIC_UINT32 pkt_sign,
                                  ZXIC_UINT32 flow_id,
                                  ZXIC_VOID* p_data);
/***********************************************************/
/** car ģûȡ
* @param   dev_id      
* @param   car_type   
* @param   flow_id   
* @param   p_drop_flag   
* @param   p_plcr_en   
* @param   p_profile_id   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/08/19
************************************************************/
DPP_STATUS dpp_stat_car_queue_cfg_get(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 car_type,
                                      ZXIC_UINT32 flow_id,
                                      ZXIC_UINT32 *p_drop_flag,
                                      ZXIC_UINT32 *p_plcr_en,
                                      ZXIC_UINT32 *p_profile_id);

DPP_STATUS dpp_stat_car_profile_cfg_get(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 car_type,
                                        ZXIC_UINT32 pkt_sign,
                                        ZXIC_UINT32 profile_id,
                                        ZXIC_VOID* p_car_profile_cfg);

/***********************************************************/
/** 
* @param   dev_id         豸ID         car ID
* @param   profile_id     ģID
* @param   p_random_ram_e EͰʶò
* @param   p_random_ram_c CͰʶò
*
* @return  
* @remark  
* @see     
* @author  YXH      @date  2019/04/01
************************************************************/
DPP_STATUS dpp_stat_car_random_ram_set(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 car_type,
                                       ZXIC_UINT32 profile_id,
                                       DPP_CAR_RANDOM_RAM_T *p_random_ram_e,
                                       DPP_CAR_RANDOM_RAM_T *p_random_ram_c);

/***********************************************************/
/** 
* @param   dev_id         豸ID         car ID
* @param   profile_id     ģID
* @param   p_random_ram_e EͰʶò
* @param   p_random_ram_c CͰʶò
*
* @return  
* @remark  
* @see     
* @author  YXH      @date  2019/04/01
************************************************************/
DPP_STATUS dpp_stat_car_random_ram_get(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 car_type,
                                       ZXIC_UINT32 profile_id,
                                       DPP_CAR_RANDOM_RAM_T *p_random_ram_e,
                                       DPP_CAR_RANDOM_RAM_T *p_random_ram_c);

/***********************************************************/
/** ȡ car ŵİ󶨹ϵ
* @param   dev_id      
* @param   car_type   
* @param   flow_id   
* @param   p_map_flow_id   
* @param   p_map_sp   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/09/27
************************************************************/
DPP_STATUS dpp_stat_car_queue_map_get(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 car_type,
                                      ZXIC_UINT32 flow_id,
                                      ZXIC_UINT32* p_map_flow_id,
                                      ZXIC_UINT32* p_map_sp);

/***********************************************************/
/** car ģԼ ȡ
* @param   dev_id      
* @param   car_type   
* @param   p_car_dbg_cnt   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/09/27
************************************************************/
DPP_STATUS dpp_stat_car_dbg_cnt_get(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 car_type,
                                    DPP_STAT_CAR_DBG_CNT_T *p_car_dbg_cnt);
/***********************************************************/
/** 
* @param   dev_id      
* @param   car_type   
* @param   overflow_mode   
* @param   rd_mode   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/09/27
************************************************************/
DPP_STATUS dpp_stat_car_dbg_cnt_mode_set(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 car_type,
                                         ZXIC_UINT32 overflow_mode,
                                         ZXIC_UINT32 rd_mode);
/***********************************************************/
/** 
* @param   dev_id      
* @param   car_type   
* @param   p_overflow_mode   
* @param   p_rd_mode   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/09/27
************************************************************/
DPP_STATUS dpp_stat_car_dbg_cnt_mode_get(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 car_type,
                                         ZXIC_UINT32* p_overflow_mode,
                                         ZXIC_UINT32* p_rd_mode);

/***********************************************************/
/** car ģʼ
* @param   dev_id   
* @param   p_car_cfg   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/05/05
************************************************************/
DPP_STATUS dpp_stat_car_init(ZXIC_UINT32 dev_id,
                             DPP_CAR_CFG_T *p_car_cfg);


/***********************************************************/
/** STAT CARλȡȫֱС
* @param   dev_id   
* @param   p_size   
*
* @return  
* @remark  
* @see     
* @author  yxh      @date  2018/06/26
************************************************************/
DPP_STATUS dpp_stat_car_glb_size_get(ZXIC_UINT32 dev_id, ZXIC_UINT32* p_size);

/***********************************************************/
/** STAT CARλȫֱ
* @param   dev_id           豸
* @param   size             Сֽ
* @param   p_data_buff      ȫֱ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  yxh      @date  2018/06/26
************************************************************/
DPP_STATUS dpp_stat_car_glb_mgr_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 size, ZXIC_UINT8 *p_data_buff);

/***********************************************************/
/** STAT CARλȡȫֱ
* @param   dev_id               豸
* @param   p_flag               ͷʹܣ1-Ҫֶfree0-Ҫֶfree
* @param   p_size               ݴС
* @param   pp_data_buff         ȫֱ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  yxh      @date  2018/06/26
************************************************************/
DPP_STATUS dpp_stat_car_glb_mgr_get(ZXIC_UINT32 dev_id, 
                                    ZXIC_UINT32 *p_flag,
                                    ZXIC_UINT32 *p_size, 
                                    ZXIC_UINT8 **pp_data_buff);

DPP_STATUS dpp_stat_queue_rb_root_prt(ZXIC_RB_CFG *p_rb_cfg);
DPP_STATUS dpp_stat_car_profile_id_rb_root_prt(ZXIC_UINT32 dev_id, ZXIC_RB_CFG *p_rb_cfg);

/***********************************************************/
/** car Aqvosģʽ
* @param   dev_id        豸           car
* @param   flow_id          
* @param   qvos_mode        ģʽμDPP_CAR_QVOS_MODE_E
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/04/06
************************************************************/
DPP_STATUS dpp_stat_cara_queue_qvos_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 flow_id,
                                        ZXIC_UINT32 qvos_mode);

/***********************************************************/
/** ȡcar Aqvosģʽ
* @param   dev_id        豸        car
* @param   flow_id       
* @param   p_qvos_mode   qvosģʽ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls	   @date  2016/04/06
************************************************************/
DPP_STATUS dpp_stat_cara_queue_qvos_get(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 flow_id,
                                        ZXIC_UINT32 *p_qvos_mode);

/***********************************************************/
/** car Aָģʽãڵ
* @param   dev_id           豸           car
* @param   global_en        ȫֶʹܣ0-ʹܣ1-ʹ
* @param   sp_en            ȼʹܣ0-ʹܣ1-ʹ
* @param   appoint_sp       ָȼ
* @param   appoint_queue    ָĶк
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls       @date  2016/04/06
************************************************************/
DPP_STATUS dpp_stat_cara_queue_appoint_mode_set(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 global_en,
                                                ZXIC_UINT32 sp_en,
                                                ZXIC_UINT32 appoint_sp,
                                                ZXIC_UINT32 appoint_queue);

/***********************************************************/
/** ȡcar Aָģʽ
* @param   dev_id           豸           car
* @param   p_global_en      ȫֶʹܣ0-ʹܣ1-ʹ
* @param   p_sp_en          ȼʹܣ0-ʹܣ1-ʹ
* @param   p_appoint_sp     ָȼ
* @param   p_appoint_queue  ָĶк
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls       @date  2016/04/07
************************************************************/
DPP_STATUS dpp_stat_cara_queue_appoint_mode_get(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 *p_global_en,
                                                ZXIC_UINT32 *p_sp_en,
                                                ZXIC_UINT32 *p_appoint_sp,
                                                ZXIC_UINT32 *p_appoint_queue);

/***********************************************************/
/** car Bqvosģʽ
* @param   dev_id           豸           car
* @param   flow_id          
* @param   qvos_mode        ģʽμDPP_CAR_QVOS_MODE_E
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/04/06
************************************************************/
DPP_STATUS dpp_stat_carb_queue_qvos_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 flow_id,
                                        ZXIC_UINT32 qvos_mode);

/***********************************************************/
/** ȡcar Bqvosģʽ
* @param   dev_id           豸           car
* @param   flow_id          
* @param   p_qvos_mode      qvosģʽ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls       @date  2016/04/06
************************************************************/
DPP_STATUS dpp_stat_carb_queue_qvos_get(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 flow_id,
                                        ZXIC_UINT32 *p_qvos_mode);

/***********************************************************/
/** car Bָģʽãڵ
* @param   dev_id           豸           car
* @param   global_en        ȫֶʹܣ0-ʹܣ1-ʹ
* @param   sp_en            ȼʹܣ0-ʹܣ1-ʹ
* @param   appoint_sp       ָȼ
* @param   appoint_queue    ָĶк
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls       @date  2016/04/06
************************************************************/
DPP_STATUS dpp_stat_carb_queue_appoint_mode_set(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 global_en,
                                                ZXIC_UINT32 sp_en,
                                                ZXIC_UINT32 appoint_sp,
                                                ZXIC_UINT32 appoint_queue);
/***********************************************************/
/** ȡcar Bָģʽ
* @param   dev_id        豸           car
* @param   p_global_en      ȫֶʹܣ0-ʹܣ1-ʹ
* @param   p_sp_en          ȼʹܣ0-ʹܣ1-ʹ
* @param   p_appoint_sp     ָȼ
* @param   p_appoint_queue  ָĶк
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/04/07
************************************************************/
DPP_STATUS dpp_stat_carb_queue_appoint_mode_get(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 *p_global_en,
                                                ZXIC_UINT32 *p_sp_en,
                                                ZXIC_UINT32 *p_appoint_sp,
                                                ZXIC_UINT32 *p_appoint_queue);

/***********************************************************/
/** car Cqvosģʽ
* @param   dev_id           豸           car
* @param   flow_id          
* @param   qvos_mode        ģʽμDPP_CAR_QVOS_MODE_E
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/04/06
************************************************************/
DPP_STATUS dpp_stat_carc_queue_qvos_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 flow_id,
                                        ZXIC_UINT32 qvos_mode);

/***********************************************************/
/** ȡcar Cqvosģʽ
* @param   dev_id           豸           car
* @param   flow_id          
* @param   p_qvos_mode      qvosģʽ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/04/06
************************************************************/
DPP_STATUS dpp_stat_carc_queue_qvos_get(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 flow_id,
                                        ZXIC_UINT32 *p_qvos_mode);

/***********************************************************/
/** car Cָģʽãڵ
* @param   dev_id           豸           car
* @param   global_en        ȫֶʹܣ0-ʹܣ1-ʹ
* @param   sp_en            ȼʹܣ0-ʹܣ1-ʹ
* @param   appoint_sp       ָȼ
* @param   appoint_queue    ָĶк
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/04/06
************************************************************/
DPP_STATUS dpp_stat_carc_queue_appoint_mode_set(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 global_en,
                                                ZXIC_UINT32 sp_en,
                                                ZXIC_UINT32 appoint_sp,
                                                ZXIC_UINT32 appoint_queue);

/***********************************************************/
/** ȡcar Cָģʽ
* @param   dev_id           豸           car
* @param   p_global_en      ȫֶʹܣ0-ʹܣ1-ʹ
* @param   p_sp_en          ȼʹܣ0-ʹܣ1-ʹ
* @param   p_appoint_sp     ָȼ
* @param   p_appoint_queue  ָĶк
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/04/07
************************************************************/
DPP_STATUS dpp_stat_carc_queue_appoint_mode_get(ZXIC_UINT32 dev_id,
                                                ZXIC_UINT32 *p_global_en,
                                                ZXIC_UINT32 *p_sp_en,
                                                ZXIC_UINT32 *p_appoint_sp,
                                                ZXIC_UINT32 *p_appoint_queue);

/***********************************************************/
/**
* @param   dev_id
* @param   p_mode
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/09/28
************************************************************/
DPP_STATUS dpp_stat_car_en_mode_get(ZXIC_UINT32 dev_id,
                                    ZXIC_UINT32 *p_mode);

#ifdef __cplusplus
}
#endif

#endif



