/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_stat_cfg.h
* ļʶ : 
* ժҪ : 
* ˵ : 
* ǰ汾 : 
*      : ls
*  : 2016/03/29
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/
#ifndef _DPP_STAT_CFG_H_
#define _DPP_STAT_CFG_H_

#ifdef __cplusplus
extern "C" {
#endif
#include "dpp_stat_api.h"

#if ZXIC_REAL("Variable definition")

#define         DPP_STAT_TM_PORT_MAX                (4)
#define         DPP_STAT_ETM_ADDR_MAX               (9*1024)
#define         DPP_STAT_FTM_ADDR_MAX               (2048)	
#define         DPP_STAT_IND_WR_MODE                (0)
#define         DPP_STAT_IND_RD_MODE                (1)
#define         DPP_STAT_TM_MOV_PERIOD_MAX          (0xff)

#define         DPP_STAT_WIDTH_3_MAX_VALUE          ((1<<3) - 1)
#define         DPP_STAT_WIDTH_4_MAX_VALUE          ((1<<4) - 1)
#define         DPP_STAT_PPU_ERAM_DEPTH_MAX         (0x7ffff)
#define         DPP_STAT_PPU_ERAM_BADDR_MAX         (0x7ffff)
#define         DPP_STAT_PPU_DDR_BADDR_MAX          (0x1fffffff)

#define         DPP_STAT_OAM_ERAM_BADDR_MAX         (0x7ffff)
#define         DPP_STAT_OAM_DDR_BADDR_MAX          (0x1fffffff)

#define         DPP_STAT_PLCR_ERAM_BADDR_MAX        (0x7ffff)
#define         DPP_STAT_PLCR_ID                (0)

#define         DPP_STAT_TM_FLAG_FTM_PKT_EN         (0)
#define         DPP_STAT_TM_FLAG_ETM_PKT_EN         (1)
#define         DPP_STAT_TM_FLAG_ERAM_EN            (2)

#define         DPP_STAT_PPU_STAT_CHANNEL_NUM       (16)
#define         DPP_STAT_PPU_MEX_NUM                (6)
#define         CMMU_DDR_DIR_CPY_NUM                (15)


/** stat TM */
typedef enum dpp_stat_tm_type_e
{
    DPP_STAT_TM_TYPE_ETM = 0,   /*<@brief FTMģʽ */
    DPP_STAT_TM_TYPE_FTM = 1,   /*<@brief ETMģʽ */
    DPP_STAT_TM_TYPE_MAX
}DPP_STAT_TM_TYPE_E;


typedef enum dpp_stat_tm_store_mode_e
{
    DPP_STAT_TM_STORE_MODE_ERAM = 0,    /* Ƭڴ洢ģʽ */
    DPP_STAT_TM_STORE_MODE_MIX  = 1,    /* ϴ洢ģʽ */
    DPP_STAT_TM_STORE_MODE_MAX,
}DPP_STAT_TM_STORE_MODE_E;

typedef enum dpp_stat_etm_depth_mode_e
{
    DPP_STAT_ETM_DEPTH_ERAM_1K = 0,
    DPP_STAT_ETM_DEPTH_ERAM_4K = 1,
    DPP_STAT_ETM_DEPTH_ERAM_5K = 2,
    DPP_STAT_ETM_DEPTH_ERAM_8K = 3,
    DPP_STAT_ETM_DEPTH_ERAM_9K = 4,
    DPP_STAT_ETM_DEPTH_MIX_2K  = 5,
    DPP_STAT_ETM_DEPTH_MIX_8K  = 6,
    DPP_STAT_ETM_DEPTH_MIX_9K  = 7,
    DPP_STAT_ETM_DEPTH_MAX,
}DPP_STAT_ETM_DEPTH_MODE_E;

typedef enum stat_store_mode_e
{
    STAT_STORE_MODE_IN_ERAM = 0,
    STAT_STORE_MODE_IN_DDR  = 1,
    STAT_STORE_MODE_MAX,
}STAT_STORE_MODE_E;

typedef enum stat_oam_type_e
{
    STAT_OAM_TYPE_ERAM     = 0,
    STAT_OAM_TYPE_LM_ERAM  = 1,
    STAT_OAM_TYPE_DDR      = 2,
    STAT_OAM_TYPE_MAX,
}STAT_OAM_TYPE_E;

typedef struct dpp_stat_dbg_cnt_t
{
    ZXIC_UINT32 stat_to_smmu0_rsp_fc_cnt[DPP_STAT_PPU_STAT_CHANNEL_NUM];
    ZXIC_UINT32 stat_rcv_smmu0_req_fc_cnt[DPP_STAT_PPU_STAT_CHANNEL_NUM];
    ZXIC_UINT32 stat_to_ppu_req_fc_cnt[DPP_STAT_PPU_MEX_NUM];
    ZXIC_UINT32 stat_rcv_ppu_rsp_fc_cnt[DPP_STAT_PPU_MEX_NUM];
    ZXIC_UINT32 stat_rcv_se_etm_wr_fc_cnt;
    ZXIC_UINT32 stat_rcv_se_etm_rd_fc_cnt;
    ZXIC_UINT32 stat_rcv_se_ftm_wr_fc_cnt;
    ZXIC_UINT32 stat_rcv_se_ftm_rd_fc_cnt;
    ZXIC_UINT32 stat_to_etm_deq_fc_cnt;
    ZXIC_UINT32 stat_to_etm_enq_fc_cnt;
    ZXIC_UINT32 stat_to_ftm_deq_fc_cnt;
    ZXIC_UINT32 stat_to_ftm_enq_fc_cnt;
    ZXIC_UINT32 stat_to_oam_lm_fc_cnt;
    ZXIC_UINT32 stat_rcv_oam_lm_fc_cnt;
    ZXIC_UINT32 stat_to_oam_fc_cnt;
    ZXIC_UINT32 stat_rcv_cmmu_fc_cnt;
    ZXIC_UINT32 stat_to_cmmu_req_cnt;
    ZXIC_UINT32 stat_rcv_smmu0_rsp_cnt[DPP_STAT_PPU_STAT_CHANNEL_NUM];
    ZXIC_UINT32 stat_to_smmu0_req_cnt[DPP_STAT_PPU_STAT_CHANNEL_NUM];
    ZXIC_UINT32 stat_plcr_rcv_smmu0_rsp1_cnt;
    ZXIC_UINT32 stat_plcr_rcv_smmu0_rsp0_cnt;
    ZXIC_UINT32 stat_plcr_to_smmu0_req1_cnt;
    ZXIC_UINT32 stat_plcr_to_smmu0_req0_cnt;
    ZXIC_UINT32 stat_to_ppu_mex_rsp_cnt[DPP_STAT_PPU_MEX_NUM];
    ZXIC_UINT32 stat_oam_lm_rsp_cnt;
    ZXIC_UINT32 stat_rcv_oam_lm_req_cnt;
    ZXIC_UINT32 stat_rcv_oam_req_cnt;
    ZXIC_UINT32 stat_rcv_ppu_mex_key_cnt[DPP_STAT_PPU_MEX_NUM];
    ZXIC_UINT32 stat_rcv_se_etm_rsp_cnt;
    ZXIC_UINT32 stat_rcv_etm_se_wr_req_cnt;
    ZXIC_UINT32 stat_rcv_etm_se_rd_req_cnt;
    ZXIC_UINT32 stat_rcv_se_ftm_rsp_cnt;
    ZXIC_UINT32 stat_to_ftm_se_wr_req_cnt;
    ZXIC_UINT32 stat_to_ftm_se_rd_req_cnt;
    ZXIC_UINT32 stat_rcv_ftm_smmu0_req_cnt0;
    ZXIC_UINT32 stat_rcv_ftm_smmu0_req_cnt1;
    ZXIC_UINT32 stat_rcv_etm_smmu0_req_cnt0;
    ZXIC_UINT32 stat_rcv_etm_smmu0_req_cnt1;
    ZXIC_UINT32 ppu_no_exist_opcd_ex_cnt[DPP_STAT_PPU_MEX_NUM];
    ZXIC_UINT32 stat_rcv_tm_eram_cpu_rsp_cnt;
    ZXIC_UINT32 cpu_rd_eram_req_cnt;
    ZXIC_UINT32 cpu_wr_eram_req_cnt;
    ZXIC_UINT32 tm_stat_ddr_cpu_rsp_cnt;
    ZXIC_UINT32 cpu_rd_ddr_req_cnt;
    ZXIC_UINT32 cpu_wr_ddr_req_cnt;
}DPP_STAT_DBG_CNT_T;

#endif

/***********************************************************/
/** TMͳֵȡ
* @param   dev_id           豸
* @param   p_stat_tm_cfg    TMͳ
* @param   tm_mode          TMͣ0-ftm1-etm
* @param   clr_mode         ģʽ0-壬1-
* @param   flow_id          ֵ
* @param   p_stat_tm_cnt    Σصļ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/07/28
************************************************************/
DPP_STATUS dpp_stat_tm_cnt_value_get(ZXIC_UINT32 dev_id,
                                     DPP_STAT_TM_CFG_T *p_stat_tm_cfg,
                                     STAT_TM_MODE_E tm_mode,
                                     ZXIC_UINT32 clr_mode,
                                     ZXIC_UINT32 flow_id,
                                     DPP_STAT_TM_CNT_T *p_stat_tm_cnt);

/***********************************************************/
/** TMͳƼӡ
* @param   dev_id          豸
* @param   p_stat_tm_cnt   TMͳƽ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/08/03
************************************************************/
DPP_STATUS dpp_stat_tm_cnt_value_prt(ZXIC_UINT32 dev_id,DPP_STAT_TM_CNT_T* p_stat_tm_cnt);

/***********************************************************/
/** Լģʽ
* @param   dev_id   
* @param   rd_mode      0-ģʽ1-ģʽ 
* @param   ovfl_mode    0-֣  1-ת  
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2017/05/05
************************************************************/
DPP_STATUS dpp_stat_dbg_cnt_mode_set(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 rd_mode,
                                     ZXIC_UINT32 ovfl_mode);

DPP_STATUS dpp_stat_brief_int_status_get(ZXIC_UINT32 dev_id, DPP_STAT_BRIEF_INT_T *p_stat_brief_int_status);


/***********************************************************/
/** ȡTMcpu eramдrdyź
* @param   dev_id       豸
* @param   p_rdy        ɶдrdyź
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/29
************************************************************/
DPP_STATUS dpp_stat_tm_eram_cpu_rdy_get(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 *p_rdy);
/***********************************************************/
/** ȡTMͳƼcpu eramؿɶ״̬
* @param   dev_id       豸
* @param   p_done       cpuɶ״̬
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/29
************************************************************/
DPP_STATUS dpp_stat_tm_eram_cpu_rd_done_get(ZXIC_UINT32 dev_id,
                                            ZXIC_UINT32 *p_done);

/***********************************************************/
/** ȡTMcpuɶдddr3rdyź
* @param   dev_id   
* @param   p_rdy   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/08/03
************************************************************/
DPP_STATUS dpp_stat_tm_ddr_cpu_rdy_get(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 *p_rdy);

/***********************************************************/
/** ȡTMͳƼcpu ddr3ݷ״̬
* @param   dev_id   
* @param   p_done   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/08/03
************************************************************/
DPP_STATUS dpp_stat_tm_ddr_cpu_rd_done_get(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 *p_done);


/***********************************************************/
/** ȡppuͳƬ
* @param   dev_id               豸
* @param   p_ppu_eram_depth     ppuͳƬ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_ppu_eram_depth_get(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32* p_ppu_eram_depth);


/***********************************************************/
/** ȡppuͳ ERAMַ
* @param   dev_id               豸
* @param   p_ppu_eram_baddr     ppuͳƬڻַ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_ppu_eram_baddr_get(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32* p_ppu_eram_baddr);

/***********************************************************/
/** ȡppuͳ ddrַ
* @param   dev_id               豸
* @param   p_ppu_ddr_baddr      ppuͳƬַ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_ppu_ddr_baddr_get(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32* p_ppu_ddr_baddr);
/***********************************************************/
/** statģOAMͳʹϢ
* @param   dev_id                   豸
* @param   oam_flow_control_en      ͨѹʹܣ0-ѹЧ1-ѹЧ
* @param   oam_flow_lm_control_en   LMѹʹܣ0-ѹЧ1-ѹЧ
* @param   oam_in_eram_en           ͨƬͳʹܣ1-Ƭͳƣ0-Ƭͳ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/30
************************************************************/
DPP_STATUS  dpp_stat_oam_en_set(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 oam_flow_control_en,
                                ZXIC_UINT32 oam_flow_lm_control_en,
                                ZXIC_UINT32 oam_in_eram_en);
/***********************************************************/
/** ȡstatģOAMͳʹϢ
* @param   dev_id                       豸
* @param   p_oam_flow_control_en        ͨѹʹܣ0-ѹЧ1-ѹЧ
* @param   p_oam_flow_lm_control_en     LMѹʹܣ0-ѹЧ1-ѹЧ
* @param   p_oam_in_eram_en             ͨƬͳʹܣ1-Ƭͳƣ0-Ƭͳ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/30
************************************************************/
DPP_STATUS dpp_stat_oam_en_get(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32* p_oam_flow_control_en,
                               ZXIC_UINT32* p_oam_flow_lm_control_en,
                               ZXIC_UINT32* p_oam_in_eram_en);
/***********************************************************/
/** oamͳ ERAMַ
* @param   dev_id           豸 
* @param   oam_eram_baddr   oamͳeRamַ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_oam_eram_baddr_set(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32 oam_eram_baddr);
/***********************************************************/
/** ȡoamͳ ERAMַ
* @param   dev_id               豸
* @param   p_oam_eram_baddr     oamͳƬڻַ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_oam_eram_baddr_get(ZXIC_UINT32 dev_id,
                                       ZXIC_UINT32* p_oam_eram_baddr);

/***********************************************************/
/** oam LMͳ ERAMַ
* @param   dev_id               豸 
* @param   oam_lm_eram_baddr    oam LMͳeRamַ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_oam_lm_eram_baddr_set(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 oam_lm_eram_baddr);

/***********************************************************/
/** ȡoam LMͳ ERAMַ
* @param   dev_id                   豸
* @param   p_oam_lm_eram_baddr      oam LMͳƬڻַ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_oam_lm_eram_baddr_get(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32* p_oam_lm_eram_baddr);
/***********************************************************/
/** oamͳ DDRַ
* @param   dev_id           豸 
* @param   oam_ddr_baddr    oamͳeRamַ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_oam_ddr_baddr_set(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 oam_ddr_baddr);

/***********************************************************/
/** ȡoamͳ DDRַ
* @param   dev_id               豸
* @param   p_oam_ddr_baddr      oamͳƬڻַ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_oam_ddr_baddr_get(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32* p_oam_ddr_baddr);


/***********************************************************/
/** OAMֵȡ
* @param   dev_id           豸
* @param   oam_type         OAMͣμSTAT_OAM_TYPE_E
* @param   rd_mode          ȡλģʽμSTAT_CNT_MODE_E0-64bit1-128bit
* @param   index            ֵ
* @param   clr_mode         ģʽμSTAT_RD_CLR_MODE_E0-壬1-
* @param   p_data           Σص
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/07/14
************************************************************/
DPP_STATUS dpp_stat_oam_cnt_get(ZXIC_UINT32 dev_id,
                                STAT_OAM_TYPE_E oam_type,
                                STAT_CNT_MODE_E rd_mode,
                                ZXIC_UINT32 index,
                                STAT_RD_CLR_MODE_E clr_mode,
                                ZXIC_UINT32 *p_data);

/***********************************************************/
/** ȡTM ͳƻ
* @param   dev_id                       豸
* @param   p_stat_overflow_mode         ģʽƬЧ0-ת1-
* @param   p_tm_stat_mode_cfg           TMͳƼģʽ
* @param   p_tm_flow_control_cfg        TMͳ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_tm_cfg_get(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32* p_stat_overflow_mode,
                               ZXIC_UINT32* p_tm_stat_mode_cfg,
                               ZXIC_UINT32* p_tm_flow_control_cfg);

/***********************************************************/
/** TM ͳƻ
* @param   dev_id                       豸
* @param   stat_overflow_mode           ģʽƬЧ0-ת1-
* @param   tm_stat_mode_cfg             TMͳƼģʽ
* @param   tm_flow_control_cfg          TMͳ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_tm_cfg_set(ZXIC_UINT32 dev_id,
                               ZXIC_UINT32 stat_overflow_mode,
                               ZXIC_UINT32 tm_stat_mode_cfg,
                               ZXIC_UINT32 tm_flow_control_cfg);


/***********************************************************/
/**  etm ͳʼֵ
* @param   dev_id   
* @param   etm_start_queue_id   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/07/16
************************************************************/
DPP_STATUS dpp_stat_tm_etm_start_queue_set(ZXIC_UINT32 dev_id,
                                           ZXIC_UINT32 etm_start_queue_id);

/***********************************************************/
/** etm 
* @param   dev_id   
* @param   etm_queue_depth_mode   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/07/16
************************************************************/
DPP_STATUS dpp_stat_tm_etm_queue_depth_set(ZXIC_UINT32 dev_id,
                                           DPP_STAT_ETM_DEPTH_MODE_E etm_queue_depth_mode);

DPP_STATUS dpp_stat_tm_etm_queue_depth_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_etm_queue_depth_cfg);

/***********************************************************/
/** ETM кУ
* @param   dev_id   
* @param   etm_queue_start   
* @param   etm_queue_depth_mode   
* @param   flow_id   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/07/25
************************************************************/
DPP_STATUS dpp_stat_tm_etm_flow_check(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 etm_queue_start,
                                      ZXIC_UINT32 etm_queue_depth_mode,
                                      ZXIC_UINT32 flow_id);

/***********************************************************/
/** ʹ
* @param   dev_id       豸
* @param   mov_en       ʹ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/07/18
************************************************************/
DPP_STATUS dpp_stat_tm_cycle_mov_en_set(ZXIC_UINT32 dev_id,
                                        ZXIC_UINT32 mov_en);

/***********************************************************/
/** statģĵԼȡ
* @param   dev_id   
* @param   p_dpp_stat_dbg_cnt   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2017/05/05
************************************************************/
DPP_STATUS dpp_stat_dbg_cnt_get(ZXIC_UINT32 dev_id,
                                DPP_STAT_DBG_CNT_T *p_dpp_stat_dbg_cnt);

/***********************************************************/
/** Լ
* @param   dev_id   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2017/05/05
************************************************************/
DPP_STATUS dpp_stat_dbg_cnt_clr(ZXIC_UINT32 dev_id);

/***********************************************************/
/**ȡppu statϢ
* @param   dev_id
* @param   PPU_STAT_CFG_T  ΣstatϢ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  cq      @date  2024/02/02
************************************************************/
DPP_STATUS dpp_stat_cfg_soft_get(ZXIC_UINT32 dev_id,PPU_STAT_CFG_T *p_stat_cfg);

/***********************************************************/
/**жϵǰͳƵַƬڻƬ
* @param   dev_id
* @param   counter_id      ͳʼţӦ΢еaddress
* @param   rd_mode         ȡλģʽμSTAT_CNT_MODE_E0-64bit1-128bit
* @param   ppu_stat_eram    1:Ƭ 0Ƭ  
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  cq      @date  2024/10/15
************************************************************/
DPP_STATUS dpp_stat_ppu_eram_or_smmu1(ZXIC_UINT32 dev_id,ZXIC_UINT32 counter_id,ZXIC_UINT32 rd_mode,ZXIC_UINT32 *ppu_stat_eram);

/***********************************************************/
/** DPP statTMͳeRamݣ֧128bit
* @param   dev_id    豸
* @param   tm_mode      TMģʽ0-TM,1-TM
* @param   queue_mode   ģʽ0-ģʽ1-ģʽ
* @param   addr         ƫƵĵַ
* @param   p_data       Σص
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/03/30
************************************************************/
DPP_STATUS dpp_stat_ind_eram_read(ZXIC_UINT32 dev_id,
                                  STAT_TM_MODE_E tm_mode,
                                  STAT_TM_PORT_MODE_E port_mode,
                                  STAT_TM_CLR_MODE_E clr_mode,
                                  ZXIC_UINT32 addr,
                                  ZXIC_UINT32 *p_data);

DPP_STATUS dpp_stat_plcr_baddr_set(ZXIC_UINT32 dev_id,
                                   ZXIC_UINT32 plcr_id,
                                   ZXIC_UINT32 plcr_baddr);


/***********************************************************/
/** DPP statдTMͳeram
* @param   dev_id       豸
* @param   tm_mode      TMģʽ0-TM,1-TM
* @param   port_mode    ˿ģʽ0-˿0Ͷ˿11-˿2Ͷ˿3
* @param   cnt_mode     ģʽ0-ģʽ1-ڲ洢ģʽ
* @param   addr         ƫƵĵַ
* @param   p_data       дݣTMϼʱд64bitTMƬʱд128bit
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls     @date  2016/03/29
************************************************************/
DPP_STATUS dpp_stat_ind_eram_write(ZXIC_UINT32 dev_id,
                                   STAT_TM_MODE_E tm_mode,
                                   STAT_TM_PORT_MODE_E port_mode,
                                   STAT_TM_CNT_MODE_E cnt_mode,
                                   ZXIC_UINT32 addr,
                                   ZXIC_UINT32 *p_data);

/***********************************************************/
/** DPP statӡTMͳeRamݣ֧128bit
* @param     dev_id      豸
* @param     tm_mode     TMģʽ0-TM,1-TM
* @param     queue_mode  ģʽ0-ģʽ1-ģʽ
* @param     addr        ƫƵĵַ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  xhj    @date  2018/01/09
************************************************************/
DPP_STATUS dpp_stat_ind_eram_prt(ZXIC_UINT32 dev_id,
                                 STAT_TM_MODE_E tm_mode,
                                 STAT_TM_PORT_MODE_E port_mode,
                                 STAT_TM_CLR_MODE_E clr_mode,
                                 ZXIC_UINT32 addr );

/***********************************************************/
/** DPP statдTMͳddr
* @param   dev_id
* @param   tm_mode
* @param   only_pkt_num_en
* @param   addr
* @param   p_data
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/08/03
************************************************************/
DPP_STATUS dpp_stat_ind_ddr_write(ZXIC_UINT32 dev_id,
                                  STAT_TM_MODE_E tm_mode,
                                  ZXIC_UINT32 only_pkt_num_en,
                                  ZXIC_UINT32 addr,
                                  ZXIC_UINT32 *p_data);

/***********************************************************/
/** DPP statȡTMͳddr(256bitǴ512bit)
* @param    dev_id
* @param    tm_mode
* @param    only_pkt_num_en 	 ʹܣ0-δʹܣ1-ʹ
* @param    clr_mode
* @param    addr
*
* @return    NPE_OK-ɹNPE_ERR-ʧ
* @remark    
* @see
* @author    xhj      @date	2018/01/09
************************************************************/
DPP_STATUS dpp_stat_ind_ddr_prt(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 tm_mode,
                                ZXIC_UINT32 only_pkt_num_en,
                                ZXIC_UINT32 clr_mode,
                                ZXIC_UINT32 addr);

/***********************************************************/
/** ϼʱTMʱ
* @param    dev_id
* @param    ftm_mov_period
* @param    etm_mov_period
*
* @return   NPE_OK-ɹNPE_ERR-ʧ
* @remark   
* @see
* @author   ls      @date  2016/07/14
************************************************************/
DPP_STATUS dpp_stat_tm_mov_period_cfg_set(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 ftm_mov_period,
                                          ZXIC_UINT32 etm_mov_period);

/***********************************************************/
/**
* @param   dev_id
* @param   p_ftm_mov_period
* @param   p_etm_mov_period
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/07/14
************************************************************/
DPP_STATUS dpp_stat_tm_mov_period_cfg_get(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 *p_ftm_mov_period,
                                          ZXIC_UINT32 *p_etm_mov_period);

/***********************************************************/
/**
* @param    dev_id
* @param    p_etm_start_queue_id
*
* @return   NPE_OK-ɹNPE_ERR-ʧ
* @remark   
* @see
* @author   ls     @date  2016/07/16
************************************************************/
DPP_STATUS dpp_stat_tm_etm_start_queue_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_etm_start_queue_id);

/***********************************************************/
/** ʹܻȡ
* @param   dev_id    豸
* @param   p_mov_en     ʹ
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/07/18
************************************************************/
DPP_STATUS dpp_stat_tm_cycle_mov_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_mov_en);

/***********************************************************/
/** ȡPLCR ַ
* @param   dev_id        豸
* @param   plcr_id          plcr idţȡֵ0~1
* @param   p_plcr_baddr     plcrַ,Ϊ0x3ffff
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_plcr_baddr_get(ZXIC_UINT32 dev_id,
                                   ZXIC_UINT32 plcr_id,
                                   ZXIC_UINT32 *p_plcr_baddr);

/***********************************************************/
/** tm ͳ
* @param   dev_id          豸
* @param   tm_type         TMͣμDPP_STAT_TM_TYPE_E
* @param   port_id         ˿ںţȡֵΧ[0~3]
* @param   tm_port_type	   tmͳͣμTM_STAT_TYPE_E
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/04/05
************************************************************/
DPP_STATUS dpp_stat_tm_port_type_set(ZXIC_UINT32 dev_id,
                                     DPP_STAT_TM_TYPE_E tm_type,
                                     ZXIC_UINT32 port_id,
                                     TM_STAT_TYPE_E tm_port_type);

/***********************************************************/
/** TMͳģʽ
* @param   dev_id                   豸
* @param   only_eram_en             Ƭڴ洢ʹܣ0-Ƭϣ1-Ƭ
* @param   etm_only_pkt_cnt_en      etmڴʹܣ0-ֽڼ1-
* @param   ftm_only_pkt_cnt_en      ftmڴʹܣ0-ֽڼ1-
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls        @date  2016/07/13
************************************************************/
DPP_STATUS dpp_stat_tm_mode_set(ZXIC_UINT32 dev_id,
                                ZXIC_UINT32 only_eram_en,
                                ZXIC_UINT32 etm_only_pkt_cnt_en,
                                ZXIC_UINT32 ftm_only_pkt_cnt_en);

/***********************************************************/
/** ͳ״̬Ϣӡ
* @param   dev_id
*
* @return
* @remark  
* @see
* @author  xhj     @date  2018/01/09
************************************************************/
DPP_STATUS dpp_stat_state_print(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ͳжϴӡ
* @param   dev_id
*
* @return
* @remark  
* @see
* @author  xhj      @date  2018/01/11
************************************************************/
DPP_STATUS dpp_stat_int_print(ZXIC_UINT32 dev_id);

/***********************************************************/
/** ͳؼӡ
* @param   dev_id
*
* @return
* @remark  
* @see
* @author  xhj      @date  2018/01/11
************************************************************/
DPP_STATUS dpp_stat_fc_print(ZXIC_UINT32 dev_id);

/***********************************************************/
/** statóʼ
* @param   dev_id   
* @param   p_dpp_stat_comm_cfg   
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see     
* @author  ls      @date  2016/07/14
************************************************************/
DPP_STATUS dpp_stat_vir2phy_comm_init(ZXIC_UINT32 dev_id,
                                      DPP_STAT_COMM_CFG_T * p_dpp_stat_vir_comm_cfg);

/***********************************************************/
/** ȡEtmļ
* @param   dev_id
* @param   p_etm_port0_type
* @param   p_etm_port1_type
* @param   p_etm_port2_type
* @param   p_etm_port3_type
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_etm_port_type_get(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 *p_etm_port0_type,
                                      ZXIC_UINT32 *p_etm_port1_type,
                                      ZXIC_UINT32 *p_etm_port2_type,
                                      ZXIC_UINT32 *p_etm_port3_type);

/***********************************************************/
/** ȡFtmļ
* @param   dev_id
* @param   p_ftm_port0_type
* @param   p_ftm_port1_type
* @param   p_ftm_port2_type
* @param   p_ftm_port3_type
*
* @return  NPE_OK-ɹNPE_ERR-ʧ
* @remark  
* @see
* @author  ls      @date  2016/03/31
************************************************************/
DPP_STATUS dpp_stat_ftm_port_type_get(ZXIC_UINT32 dev_id,
                                      ZXIC_UINT32 *p_ftm_port0_type,
                                      ZXIC_UINT32 *p_ftm_port1_type,
                                      ZXIC_UINT32 *p_ftm_port2_type,
                                      ZXIC_UINT32 *p_ftm_port3_type);


#ifdef __cplusplus
}
#endif

#endif
